#Developed by Jan Fabian Martin


#importing libraries
library("ggplot2")
library("ggthemes")
library("tidyr")



#importing model results
cost_df <- read.csv("Rdata/cost_df_baseline.csv")
cost_df_pk <- read.csv("Rdata/cost_df_pk.csv") 

colnames(cost_df) <- c('index.name', 'variable.cost', 'startup.cost', 'penalty.cost', 'balancing.cost', 'total.cost')



#--------------------------------------------------------------------------------------------------
#total cost (absolute)
run1 <- c(cost_df[1,6], cost_df[2,6], cost_df[3,6], cost_df[4,6], cost_df[5,6], cost_df[6,6], cost_df[7,6])
run2 <- c(cost_df_pk[1,6], cost_df_pk[2,6], cost_df_pk[3,6], cost_df_pk[4,6], cost_df_pk[5,6], cost_df_pk[6,6], cost_df_pk[7,6])

frequency <- c(24, 12, 8, 6, 4, 2, 1)

tC <- data.frame(run1, run2)
tC$frequency <- frequency

totalCost_ggp <- data.frame(x = tC$frequency,
                            y = c(tC$run1, tC$run2),
                            group = c(rep('baseline scenario', nrow(tC)),
                                      rep('perfect knowledge', nrow(tC))))


ggp_tC <- ggplot(totalCost_ggp, aes(x=x, y=y*1e-09, color=group)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(totalCost_ggp$x), breaks = totalCost_ggp$x) +
  scale_y_continuous(breaks=seq(1.71,1.80,by=0.01)) +
  labs(x="auction frequency [h]",
       y="total UC costs [billion €]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_tC

ggsave("totalCost.pdf", width = 34, height = 20, units = "cm")




#relative total cost (base-case is 1h)

run1 <- c(cost_df[1,6]/cost_df[7,6], cost_df[2,6]/cost_df[7,6], cost_df[3,6]/cost_df[7,6], cost_df[4,6]/cost_df[7,6], cost_df[5,6]/cost_df[7,6], cost_df[6,6]/cost_df[7,6], cost_df[7,6]/cost_df[7,6])
run2 <- c(cost_df_pk[1,6]/cost_df[7,6], cost_df_pk[2,6]/cost_df[7,6], cost_df_pk[3,6]/cost_df[7,6], cost_df_pk[4,6]/cost_df[7,6], cost_df_pk[5,6]/cost_df[7,6], cost_df_pk[6,6]/cost_df[7,6], cost_df_pk[7,6]/cost_df[7,6])

frequency <- c(24, 12, 8, 6, 4, 2, 1)

r1tC <- data.frame(run1, run2)
r1tC$frequency <- frequency

relative1totalCost_ggp <- data.frame(x = r1tC$frequency,
                            y = c(r1tC$run1*100, r1tC$run2*100),
                            group = c(rep('baseline scenario', nrow(r1tC)),
                                      rep('perfect knowledge', nrow(r1tC))))



ggp_r1tC <- ggplot(relative1totalCost_ggp, aes(x=x, y=y)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(totalCost_ggp$x), breaks = totalCost_ggp$x) +
  scale_y_continuous(breaks=seq(99,105,by=0.5)) +
  labs(x="auction frequency [h]",
       y="total UC costs [%]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_r1tC

ggsave("1rtotalCost.pdf", width = 34, height = 20, units = "cm")






#--------------------------------------------------------------------------------------------------
#balancing cost (absolute values)

run1 <- c(cost_df[1,5], cost_df[2,5], cost_df[3,5], cost_df[4,5], cost_df[5,5], cost_df[6,5], cost_df[7,5])
frequency <- c(24, 12, 8, 6, 4, 2, 1)

bC <- data.frame(run1)
bC$frequency <- frequency

balancingCost_ggp <- data.frame(x = bC$frequency,
                                y = c(bC$run1),
                                group = c(rep('', nrow(bC))))


ggp_b <- ggplot(balancingCost_ggp, aes(x=x, y=y*1e-06, color=group)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(balancingCost_ggp$x), breaks = balancingCost_ggp$x) +
  scale_y_continuous(breaks=seq(10,90,by=10)) +
    labs(x="auction frequency [h]",
       y="balancing costs [million €]") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="none")
  

ggp_b

ggsave("balancingCost.pdf", width = 34, height = 18, units = "cm")





#relative balancing cost (base-case is 1h)

run1 <- c(cost_df[1,5]/cost_df[7,5], cost_df[2,5]/cost_df[7,5], cost_df[3,5]/cost_df[7,5], cost_df[4,5]/cost_df[7,5], cost_df[5,5]/cost_df[7,5], cost_df[6,5]/cost_df[7,5], cost_df[7,5]/cost_df[7,5])

frequency <- c(24, 12, 8, 6, 4, 2, 1)

r1bC <- data.frame(run1)
r1bC$frequency <- frequency

relative1balancingCost_ggp <- data.frame(x = r1bC$frequency,
                                    y = c(r1bC$run1*100),
                                    group = c(rep('', nrow(r1bC))))


ggp_r1bC <- ggplot(relative1balancingCost_ggp, aes(x=x, y=y)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(balancingCost_ggp$x), breaks = balancingCost_ggp$x) +
  scale_y_continuous(breaks=seq(100,900,by=100)) +
  labs(x="auction frequency [h]",
       y="balancing costs [%]") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="none")


ggp_r1bC

ggsave("1rbalancingCost.pdf", width = 34, height = 17, units = "cm")





#relative balancing cost (balancing cost / total cost)

run1 <- c(cost_df[1,5]/cost_df[1,6], cost_df[2,5]/cost_df[2,6], cost_df[3,5]/cost_df[3,6], cost_df[4,5]/cost_df[4,6], cost_df[5,5]/cost_df[5,6], cost_df[6,5]/cost_df[6,6], cost_df[7,5]/cost_df[7,6])
frequency <- c(24, 12, 8, 6, 4, 2, 1)

rbC <- data.frame(run1)
rbC <- rbC*100
rbC$frequency <- frequency

relativebalancingCost_ggp <- data.frame(x = rbC$frequency,
                               y = c(rbC$run1),
                               group = c(rep('', nrow(rbC))))


ggp_rbC <- ggplot(relativebalancingCost_ggp, aes(x=x, y=y)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(balancingCost_ggp$x), breaks = balancingCost_ggp$x) +
  scale_y_continuous(breaks=seq(0.5,5,by=0.5)) +
  labs(x="auction frequency [h]",
       y="balancing costs / total UC costs [%]") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="none")


ggp_rbC

ggsave("rbalancingCost.pdf", width = 34, height = 17, units = "cm")




#--------------------------------------------------------------------------------------------------
#variable cost (absolute values)

run1 <- c(cost_df[1,2], cost_df[2,2], cost_df[3,2], cost_df[4,2], cost_df[5,2], cost_df[6,2], cost_df[7,2])
run2 <- c(cost_df_pk[1,2], cost_df_pk[2,2], cost_df_pk[3,2], cost_df_pk[4,2], cost_df_pk[5,2], cost_df_pk[6,2], cost_df_pk[7,2])

frequency <- c(24, 12, 8, 6, 4, 2, 1)

vC <- data.frame(run1, run2)
vC$frequency <- frequency

variableCost_ggp <- data.frame(x = vC$frequency,
                            y = c(vC$run1, vC$run2),
                            group = c(rep('baseline scenario', nrow(vC)),
                                      rep('perfect knowledge', nrow(vC))))

ggp_v <- ggplot(variableCost_ggp, aes(x=x, y=y*1e-9, color=group)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(variableCost_ggp$x), breaks = variableCost_ggp$x) +
  scale_y_continuous(breaks=seq(1.685, 1.705, 0.002), limits=c(1.685, 1.705))+
  labs(x="auction frequency [h]",
       y="variable costs [billion €]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_v

ggsave("variableCost.pdf", width = 34, height = 20, units = "cm")





#relative variable cost (base-case is 1h)

run1 <- c(cost_df[1,2]/cost_df[7,2], cost_df[2,2]/cost_df[7,2], cost_df[3,2]/cost_df[7,2], cost_df[4,2]/cost_df[7,2], cost_df[5,2]/cost_df[7,2], cost_df[6,2]/cost_df[7,2], cost_df[7,2]/cost_df[7,2])
run2 <- c(cost_df_pk[1,2]/cost_df[7,2], cost_df_pk[2,2]/cost_df[7,2], cost_df_pk[3,2]/cost_df[7,2], cost_df_pk[4,2]/cost_df[7,2], cost_df_pk[5,2]/cost_df[7,2], cost_df_pk[6,2]/cost_df[7,2], cost_df_pk[7,2]/cost_df[7,2])

frequency <- c(24, 12, 8, 6, 4, 2, 1)

r1vC <- data.frame(run1, run2)
r1vC$frequency <- frequency

relative1variableCost_ggp <- data.frame(x = r1vC$frequency,
                                     y = c(r1vC$run1*100, r1vC$run2*100),
                                     group = c(rep('baseline scenario', nrow(r1vC)),
                                               rep('perfect knowledge', nrow(r1vC))))



ggp_r1vC <- ggplot(relative1variableCost_ggp, aes(x=x, y=y)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(variableCost_ggp$x), breaks = variableCost_ggp$x) +
  scale_y_continuous(breaks=seq(99.4, 100.6, 0.2), limits=c(99.4, 100.6))+
    labs(x="auction frequency [h]",
       y="variable costs [%]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_r1vC

ggsave("1rvariableCost.pdf", width = 34, height = 20, units = "cm")



#relative variable cost (variable cost / total cost)

run1 <- c(cost_df[1,2]/cost_df[1,6], cost_df[2,2]/cost_df[2,6], cost_df[3,2]/cost_df[3,6], cost_df[4,2]/cost_df[4,6], cost_df[5,2]/cost_df[5,6], cost_df[6,2]/cost_df[6,6], cost_df[7,2]/cost_df[7,6])
run2 <- c(cost_df_pk[1,2]/cost_df_pk[1,6], cost_df_pk[2,2]/cost_df_pk[2,6], cost_df_pk[3,2]/cost_df_pk[3,6], cost_df_pk[4,2]/cost_df_pk[4,6], cost_df_pk[5,2]/cost_df_pk[5,6], cost_df_pk[6,2]/cost_df_pk[6,6], cost_df_pk[7,2]/cost_df_pk[7,6])


frequency <- c(24, 12, 8, 6, 4, 2, 1)

rvC <- data.frame(run1, run2)
rvC <- rvC*100
rvC$frequency <- frequency

relativevariableCost_ggp <- data.frame(x = rvC$frequency,
                                        y = c(rvC$run1, rvC$run2),
                                        group = c(rep('baseline scenario', nrow(rvC)),
                                                  rep('perfect knowledge', nrow(rvC))))


ggp_rvC <- ggplot(relativevariableCost_ggp, aes(x=x, y=y)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(variableCost_ggp$x), breaks = variableCost_ggp$x) +
  scale_y_continuous(breaks=seq(94,99,by=0.5)) +
  labs(x="auction frequency [h]",
       y="var. costs / total UC costs [%]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_rvC

ggsave("rvariableCost.pdf", width = 34, height = 20, units = "cm")











#--------------------------------------------------------------------------------------------------
#start-up cost (absolute values)

run1 <- c(cost_df[1,3], cost_df[2,3], cost_df[3,3], cost_df[4,3], cost_df[5,3], cost_df[6,3], cost_df[7,3])
run2 <- c(cost_df_pk[1,3], cost_df_pk[2,3], cost_df_pk[3,3], cost_df_pk[4,3], cost_df_pk[5,3], cost_df_pk[6,3], cost_df_pk[7,3])

frequency <- c(24, 12, 8, 6, 4, 2, 1)

suC <- data.frame(run1, run2)
suC$frequency <- frequency

startupCost_ggp <- data.frame(x = suC$frequency,
                               y = c(suC$run1, suC$run2),
                               group = c(rep('baseline scenario', nrow(suC)),
                                         rep('perfect knowledge', nrow(suC))))



ggp_su <- ggplot(startupCost_ggp, aes(x=x, y=y*1e-06, color=group)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(startupCost_ggp$x), breaks = startupCost_ggp$x) +
  scale_y_continuous(breaks=seq(14, 19.5, 1), limits=c(14, 19.5))+
  labs(x="auction frequency [h]",
       y="start-up costs [million €]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_su

ggsave("startupCost.pdf", width = 34, height = 20, units = "cm")





#relative start-up cost (base-case is 1h)

run1 <- c(cost_df[1,3]/cost_df[7,3], cost_df[2,3]/cost_df[7,3], cost_df[3,3]/cost_df[7,3], cost_df[4,3]/cost_df[7,3], cost_df[5,3]/cost_df[7,3], cost_df[6,3]/cost_df[7,3], cost_df[7,3]/cost_df[7,3])
run2 <- c(cost_df_pk[1,3]/cost_df[7,3], cost_df_pk[2,3]/cost_df[7,3], cost_df_pk[3,3]/cost_df[7,3], cost_df_pk[4,3]/cost_df[7,3], cost_df_pk[5,3]/cost_df[7,3], cost_df_pk[6,3]/cost_df[7,3], cost_df_pk[7,3]/cost_df[7,3])

frequency <- c(24, 12, 8, 6, 4, 2, 1)

r1suC <- data.frame(run1, run2)
r1suC$frequency <- frequency

relative1startupCost_ggp <- data.frame(x = r1suC$frequency,
                                        y = c(r1suC$run1*100, r1suC$run2*100),
                                        group = c(rep('baseline scenario', nrow(r1suC)),
                                                  rep('perfect knowledge', nrow(r1suC))))



ggp_r1suC <- ggplot(relative1startupCost_ggp, aes(x=x, y=y)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(startupCost_ggp$x), breaks = startupCost_ggp$x) +
  scale_y_continuous(breaks=seq(92, 120, 4), limits=c(95, 120))+
  labs(x="auction frequency [h]",
       y="start-up costs [%]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_r1suC

ggsave("1rstartupCost.pdf", width = 34, height = 20, units = "cm")





#relative start-up cost (start-up cost / total cost)

run1 <- c(cost_df[1,3]/cost_df[1,6], cost_df[2,3]/cost_df[2,6], cost_df[3,3]/cost_df[3,6], cost_df[4,3]/cost_df[4,6], cost_df[5,3]/cost_df[5,6], cost_df[6,3]/cost_df[6,6], cost_df[7,3]/cost_df[7,6])
run2 <- c(cost_df_pk[1,3]/cost_df_pk[1,6], cost_df_pk[2,3]/cost_df_pk[2,6], cost_df_pk[3,3]/cost_df_pk[3,6], cost_df_pk[4,3]/cost_df_pk[4,6], cost_df_pk[5,3]/cost_df_pk[5,6], cost_df_pk[6,3]/cost_df_pk[6,6], cost_df_pk[7,3]/cost_df_pk[7,6])

frequency <- c(24, 12, 8, 6, 4, 2, 1)


rsuC <- data.frame(run1, run2)
rsuC <- rsuC*100
rsuC$frequency <- frequency

relativestartupCost_ggp <- data.frame(x = rsuC$frequency,
                                       y = c(rsuC$run1, rsuC$run2),
                                       group = c(rep('baseline scenario', nrow(rsuC)),
                                                 rep('perfect knowledge', nrow(rsuC))))



ggp_rsuC <- ggplot(relativestartupCost_ggp, aes(x=x, y=y)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(startupCost_ggp$x), breaks = startupCost_ggp$x) +
  scale_y_continuous(breaks=seq(0.86, 1.10, 0.04), limits=c(0.86, 1.10))+
  labs(x="auction frequency [h]",
       y="start-up costs / total UC costs [%]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_rsuC

ggsave("rstartupCost.pdf", width = 34, height = 20, units = "cm")

