#Developed by Jan Fabian Martin



#importing libraries
library("ggplot2")
library("ggthemes")
library("tidyr")



#importing model results
cost_df <- read.csv("Rdata/cost_df_baseline.csv")
cost_df_pk <- read.csv("Rdata/cost_df_pk.csv")
cost_df_c <- read.csv("Rdata/cost_df_c.csv")



colnames(cost_df) <- c('index.name', 'variable.cost', 'startup.cost', 'penalty.cost', 'balancing.cost', 'total.cost')
colnames(cost_df_pk) <- c('index.name', 'variable.cost', 'startup.cost', 'penalty.cost', 'balancing.cost', 'total.cost')
colnames(cost_df_c) <- c('index.name', 'balancing.run1', 'total.run1', 'balancing.run2', 'total.run2', 'balancing.run3', 'total.run3')





#--------------------------------------------------------------------------------------------------
#total costs (% 1h baseline scenario)

run0 <- c(cost_df[1,6]/cost_df[7,6], cost_df[2,6]/cost_df[7,6], cost_df[3,6]/cost_df[7,6], cost_df[4,6]/cost_df[7,6], cost_df[5,6]/cost_df[7,6], cost_df[6,6]/cost_df[7,6], cost_df[7,6]/cost_df[7,6])
run1 <- c(cost_df_c[1,3]/cost_df[7,6], cost_df_c[2,3]/cost_df[7,6], cost_df_c[3,3]/cost_df[7,6], cost_df_c[4,3]/cost_df[7,6], cost_df_c[5,3]/cost_df[7,6], cost_df_c[6,3]/cost_df[7,6], cost_df_c[7,3]/cost_df[7,6])
run2 <- c(cost_df_c[1,5]/cost_df[7,6], cost_df_c[2,5]/cost_df[7,6], cost_df_c[3,5]/cost_df[7,6], cost_df_c[4,5]/cost_df[7,6], cost_df_c[5,5]/cost_df[7,6], cost_df_c[6,5]/cost_df[7,6], cost_df_c[7,5]/cost_df[7,6])
run3 <- c(cost_df_c[1,7]/cost_df[7,6], cost_df_c[2,7]/cost_df[7,6], cost_df_c[3,7]/cost_df[7,6], cost_df_c[4,7]/cost_df[7,6], cost_df_c[5,7]/cost_df[7,6], cost_df_c[6,7]/cost_df[7,6], cost_df_c[7,7]/cost_df[7,6])
run4 <- c(cost_df_c[1,7]/cost_df[7,6], cost_df_c[2,7]/cost_df[7,6], cost_df_c[3,7]/cost_df[7,6], cost_df_c[4,7]/cost_df[7,6], cost_df_c[5,7]/cost_df[7,6], cost_df_c[6,7]/cost_df[7,6], cost_df_c[7,7]/cost_df[7,6])
run5 <- c(cost_df_c[1,7]/cost_df[7,6], cost_df_c[2,7]/cost_df[7,6], cost_df_c[3,7]/cost_df[7,6], cost_df_c[4,7]/cost_df[7,6], cost_df_c[5,7]/cost_df[7,6], cost_df_c[6,7]/cost_df[7,6], cost_df_c[7,7]/cost_df[7,6])

pk <- c(cost_df_pk[1,6]/cost_df[7,6], cost_df_pk[2,6]/cost_df[7,6], cost_df_pk[3,6]/cost_df[7,6], cost_df_pk[4,6]/cost_df[7,6], cost_df_pk[5,6]/cost_df[7,6], cost_df_pk[6,6]/cost_df[7,6], cost_df_pk[7,6]/cost_df[7,6])

frequency <- c(24, 12, 8, 6, 4, 2, 1)

r1tC <- data.frame(run0, run1, run2, run3, pk)
r1tC <- r1tC*100
r1tC$frequency <- frequency

relative1totalCost_ggp <- data.frame(x = r1tC$frequency,
                                     y = c(r1tC$run0, r1tC$run1, r1tC$run2, r1tC$run3, r1tC$pk),
                                     group = c(rep('baseline scenario', nrow(r1tC)),
                                               rep('0.8 / 1.2', nrow(r1tC)),
                                               rep('0.7 / 1.3', nrow(r1tC)),
                                               rep('0.6 / 1.4', nrow(r1tC)),
                                               rep('0.5 / 1.5', nrow(r1tC)),
                                               rep('0.5 / 2', nrow(r1tC)),
                                               rep('0.5 / 3', nrow(r1tC)),
                                               rep('perfect knowledge', nrow(r1tC))))



ggp_r1tC <- ggplot(relative1totalCost_ggp, aes(x=x, y=y)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(relative1totalCost_ggp$x), breaks = relative1totalCost_ggp$x) +
  scale_y_continuous(breaks=seq(99,105,by=0.5)) +
  labs(x="auction frequency [h]",
       y="total UC cost [% (baseline)]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_r1tC

ggsave("1rtotalCost_c.pdf", width = 34, height = 20, units = "cm")






#--------------------------------------------------------------------------------------------------
#relative balancing costs (% 1h baseline scenario)

run0 <- c(cost_df[1,5]/cost_df[7,5], cost_df[2,5]/cost_df[7,5], cost_df[3,5]/cost_df[7,5], cost_df[4,5]/cost_df[7,5], cost_df[5,5]/cost_df[7,5], cost_df[6,5]/cost_df[7,5], cost_df[7,5]/cost_df[7,5])
run1 <- c(cost_df_c[1,2]/cost_df[7,5], cost_df_c[2,2]/cost_df[7,5], cost_df_c[3,2]/cost_df[7,5], cost_df_c[4,2]/cost_df[7,5], cost_df_c[5,2]/cost_df[7,5], cost_df_c[6,2]/cost_df[7,5], cost_df_c[7,2]/cost_df[7,5])
run2 <- c(cost_df_c[1,4]/cost_df[7,5], cost_df_c[2,4]/cost_df[7,5], cost_df_c[3,4]/cost_df[7,5], cost_df_c[4,4]/cost_df[7,5], cost_df_c[5,4]/cost_df[7,5], cost_df_c[6,4]/cost_df[7,5], cost_df_c[7,4]/cost_df[7,5])
run3 <- c(cost_df_c[1,6]/cost_df[7,5], cost_df_c[2,6]/cost_df[7,5], cost_df_c[3,6]/cost_df[7,5], cost_df_c[4,6]/cost_df[7,5], cost_df_c[5,6]/cost_df[7,5], cost_df_c[6,6]/cost_df[7,5], cost_df_c[7,6]/cost_df[7,5])
run4 <- c(cost_df_c[1,8]/cost_df[7,5], cost_df_c[2,8]/cost_df[7,5], cost_df_c[3,8]/cost_df[7,5], cost_df_c[4,8]/cost_df[7,5], cost_df_c[5,8]/cost_df[7,5], cost_df_c[6,8]/cost_df[7,5], cost_df_c[7,8]/cost_df[7,5])
run5 <- c(cost_df_c[1,10]/cost_df[7,5], cost_df_c[2,10]/cost_df[7,5], cost_df_c[3,10]/cost_df[7,5], cost_df_c[4,10]/cost_df[7,5], cost_df_c[5,10]/cost_df[7,5], cost_df_c[6,10]/cost_df[7,5], cost_df_c[7,10]/cost_df[7,5])



frequency <- c(24, 12, 8, 6, 4, 2, 1)

r1bC <- data.frame(run0, run2, run3, run4, run5)
r1bC <- r1bC*100
r1bC$frequency <- frequency

relative1balancingCost_ggp <- data.frame(x = r1bC$frequency,
                                         y = c(r1bC$run0, r1bC$run2, r1bC$run3, r1bC$run4, r1bC$run5),
                                         group = c(rep('baseline scenario', nrow(r1bC)),
                                                   rep('0.7 / 1.3', nrow(r1bC)),
                                                   rep('0.6 / 1.4', nrow(r1bC)),
                                                   rep('0.5 / 1.5', nrow(r1bC)),
                                                   rep('0.5 / 2', nrow(r1bC))))


ggp_r1bC <- ggplot(relative1balancingCost_ggp, aes(x=x, y=y)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(relative1balancingCost_ggp$x), breaks = relative1balancingCost_ggp$x) +
  scale_y_continuous(breaks=seq(100,900,by=100)) +
  labs(x="auction frequency [h]",
       y="balancing cost [% (baseline)]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_r1bC

ggsave("1rbalancingCost_c.pdf", width = 34, height = 20, units = "cm")



#relative balancing cost (balancing cost / total cost)

run0 <- c(cost_df[1,5]/cost_df[1,6], cost_df[2,5]/cost_df[2,6], cost_df[3,5]/cost_df[3,6], cost_df[4,5]/cost_df[4,6], cost_df[5,5]/cost_df[5,6], cost_df[6,5]/cost_df[6,6], cost_df[7,5]/cost_df[7,6])
run1 <- c(cost_df[1,5]/cost_df[1,6], cost_df[2,5]/cost_df[2,6], cost_df[3,5]/cost_df[3,6], cost_df[4,5]/cost_df[4,6], cost_df[5,5]/cost_df[5,6], cost_df[6,5]/cost_df[6,6], cost_df[7,5]/cost_df[7,6])
run2 <- c(cost_df[1,5]/cost_df[1,6], cost_df[2,5]/cost_df[2,6], cost_df[3,5]/cost_df[3,6], cost_df[4,5]/cost_df[4,6], cost_df[5,5]/cost_df[5,6], cost_df[6,5]/cost_df[6,6], cost_df[7,5]/cost_df[7,6])
run3 <- c(cost_df[1,5]/cost_df[1,6], cost_df[2,5]/cost_df[2,6], cost_df[3,5]/cost_df[3,6], cost_df[4,5]/cost_df[4,6], cost_df[5,5]/cost_df[5,6], cost_df[6,5]/cost_df[6,6], cost_df[7,5]/cost_df[7,6])


frequency <- c(24, 12, 8, 6, 4, 2, 1)

rbC <- data.frame(run1)
rbC <- rbC*100
rbC$frequency <- frequency

relativebalancingCost_ggp <- data.frame(x = rbC$frequency,
                                        y = c(rbC$run1),
                                        group = c(rep('', nrow(rbC))))


ggp_rbC <- ggplot(relativebalancingCost_ggp, aes(x=x, y=y)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(balancingCost_ggp$x), breaks = balancingCost_ggp$x) +
  scale_y_continuous(breaks=seq(0.5,5,by=0.5)) +
  labs(x="auction frequency [h]",
       y="balancing cost / total UC cost [%]") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="none")


ggp_rbC

ggsave("rbalancingCost.pdf", width = 34, height = 20, units = "cm")
