# Developed by Jan Fabian Martin



#auction frequency of the run
af = str(int(auction_frequency*snapshot_weight))

# -------------------------------------------------------------------------------------------------------------------------
#exporting dispatch to csv
nu.generators_t.p.to_csv("results/dispatch/final_dispatch_{}hf.csv".format(af))

#entire optimized network as netCDF (constant and time-dependent data)
nu.export_to_netcdf("results/netCDF/network_{}hf.nc".format(af))


#------------------------------------------------------------------------------------------------------------------------
#dimension balancing dispatch per bus (balancing requirement)
dimension_balancing = pd.DataFrame(index = range(s1,s2)).fillna(0)

for gen in generators_vre.index:
    dimension_balancing[gen] = (nu.generators_t.p_max_pu[gen][s1:s2].reset_index(drop=True)-generation_vre[gen][s1:s2].reset_index(drop=True)) * nu.generators.p_nom[gen] #assuming no redispatch (curtailment)

for bus in nu.buses.index:
    gen = nu.generators.index[nu.generators.bus==bus]
    gen_bus = gen[gen.isin(generators_vre.index)]

    dimension_balancing[bus] = 0
    for gen in gen_bus:
        dimension_balancing[bus] = dimension_balancing[bus] + dimension_balancing[gen]


dimension_balancing['total'] = 0
for bus in nu.buses.index:
    dimension_balancing['total'] = dimension_balancing['total'] + dimension_balancing[bus]


for carrier in carriers_vre:
    dimension_balancing[carrier] = 0
for gen in generators_vre.index: # dimension balancing per carrier (for balancing dispatch)
    carrier = nu.generators.loc[gen, 'carrier']
    dimension_balancing[carrier] = dimension_balancing[carrier] + dimension_balancing[gen]

dimension_balancing.to_csv("results/balancing_dimension/dimension_balancing_{}hf.csv".format(af))


#------------------------------------------------------------------------------------------------------------------------
# balancing merit order per snapshot:
merit_order_t = [0]*a1

#rules explained in method section

for i in range(a1, a2):
    mo = pd.DataFrame()
    mo['marginal cost [€/MWh]'] = nu.generators['marginal_cost'].copy()
    mo = mo.sort_values('marginal cost [€/MWh]')

    for r in mo.index:
        if r in generators_conventional.index:
            mo.loc[r, 'max adjustment up [MW]'] = nu.generators.loc[r, 'ramp_limit_up'] * nu.generators.loc[
                r, 'p_nom'] * nu.generators_t.status.iloc[i][r]
        else:
            mo.loc[r, 'max adjustment up [MW]'] = 0

        mo.loc[r, 'max adjustment down [MW]'] = nu.generators.loc[r, 'ramp_limit_down'] * nu.generators.loc[
            r, 'p_nom'] * nu.generators_t.status.iloc[i][r]

        if (nu.generators_t.p.iloc[i][r] - mo.loc[r, 'max adjustment down [MW]'] < nu.generators.loc[
            r, 'p_nom']) & (mo.loc[r, 'max adjustment down [MW]'] > 0):

            if nu.generators.loc[r, 'min_down_time'] > 1:
                mo.loc[r, 'max adjustment down [MW]'] = nu.generators_t.p.iloc[i][r] - (
                            nu.generators.loc[r, 'p_min_pu'] * nu.generators.loc[r, 'p_nom'])
            else:
                mo.loc[r, 'max adjustment down [MW]'] = nu.generators_t.p.iloc[i][r]

        if nu.generators_t.p.iloc[i][r] + mo.loc[r, 'max adjustment up [MW]'] > nu.generators.loc[r, 'p_nom']:
            mo.loc[r, 'max adjustment up [MW]'] = nu.generators.loc[r, 'p_nom'] - nu.generators_t.p.iloc[i][r]


        if (nu.generators.loc[r, 'min_up_time'] < 2) & (nu.generators_t.status.iloc[i][r] == 0) & (r in generators_conventional.index):
            mo.loc[r, 'max adjustment up [MW]'] = nu.generators.loc[r, 'ramp_limit_start_up'] * nu.generators.loc[r, 'p_nom']

        if r in penalty_terms:
           mo.loc[r, 'max adjustment up [MW]'] = nu.generators.loc[r, 'p_nom']

        mo.loc[r, 'carrier'] = nu.generators.loc[r, 'carrier']


        #  merit order version based on _t.p in every snapshot (also for conventional generators):
        mo.loc[r, 'available power [MW]'] = nu.generators_t.p.iloc[i][r]

        if (r in nu.generators[nu.generators.min_up_time < 2].index) & (r in generators_conventional.index):
            mo.loc[r, 'available power [MW]'] = nu.generators.loc[r, 'ramp_limit_start_up'] * nu.generators.loc[r, 'p_nom']

        if (r in penalty_terms):
            mo.loc[r, 'available power [MW]'] = nu.generators.loc[r, 'p_nom']
            mo.loc[r, 'marginal cost [€/MWh]'] = 300 #penalty term cost to 300€/MWh for balancing cost calculation




    mo['accumulated power [MW]'] = mo['available power [MW]'].cumsum()  # general merit order to find mc point -> problematic that it is very artificial (due to complex optimization (ramping constraints), not necessary dispatch each snapshot according to merit order
    mo['accumulated power [MW]'] = mo['accumulated power [MW]'].shift(1).fillna(0)

    merit_order_t.append(mo)



# -------------------------------------------------------------------------------------------------------------------------
#cost calculation:


#variable cost per generator and snapshot (without penalty term) - only within snapshots under analysis
var_cost_generators = pd.DataFrame()

for gen in nu.generators.index:
    var_cost_generators[gen] = nu.generators_t.p[gen][a1:a2] * nu.generators.loc[
        gen, "marginal_cost"] * snapshot_weight

#excluding penalty-term
for pen in penalty_terms:
    var_cost_generators = var_cost_generators.drop(columns=pen)

#total variable cost per generator (without penalty term)
generator_cost = pd.DataFrame()
for gen in var_cost_generators.columns:
    generator_cost.loc[gen, 'total variable cost [€]'] = var_cost_generators[gen].sum()

#total variable cost generators
var_cost_generators_total = generator_cost['total variable cost [€]'].sum()



#start-up cost per generator and snapshot
startup_generators = pd.DataFrame(index=generators_conventional.index)
steps_count = pd.DataFrame()
for gen in nu.generators.index:
    if gen not in nu.generators.index[nu.generators['carrier'] == 'penalty']:  #_t.p is given in MW; _t.p_max_pu given in 0-1 p.u.
        status = nu.generators_t.p[gen][a1:a2].copy()
        status[status >= 1] = 1
        status[status < 1] = 0
        steps = status.diff()
        steps[steps < 0] = 0
        steps = steps.fillna(0)
        cost = steps * nu.generators.start_up_cost[gen]
        startup_generators.loc[gen, 'start_up_cost'] = cost.sum()

    steps_count.loc[gen, 'number of ramp-ups'] = steps.sum()

#total startup cost
startup_cost_generators_total = startup_generators['start_up_cost'].sum()



#penalty term cost per snapshot
penalty_cost = pd.DataFrame()
for pen in penalty_terms:
    penalty_cost[pen] = nu.generators_t.p[pen][a1:a2] * nu.generators.loc[pen, "marginal_cost"] * snapshot_weight

#total penalty term cost
penalty_cost_total = penalty_cost.to_numpy().sum()


#----------------------------------------------------------------------------------------------------------

# dispatch analysis per carrier:
columns = nu.carriers.index.tolist()
index = nu.generators_t.p.index[a1:a2].tolist()
dispatch_before_balancing = pd.DataFrame(columns=columns, index=index)
dispatch_before_balancing = dispatch_before_balancing.fillna(0)
dispatch_before_balancing['penalty'] = 0
dispatch_before_balancing['PHS'] = 0

for carrier in nu.carriers.index:
    for gen in nu.generators.index[nu.generators.carrier == carrier]:
        dispatch_before_balancing[carrier] = dispatch_before_balancing[carrier] + nu.generators_t.p[gen][a1:a2]

for pen in nu.generators.index[nu.generators.carrier == 'penalty']:
    dispatch_before_balancing['penalty'] = dispatch_before_balancing['penalty'] + nu.generators_t.p[pen][a1:a2]

for phs in nu.storage_units.index[nu.storage_units.carrier == 'PHS']:
    dispatch_before_balancing['PHS'] = dispatch_before_balancing['PHS'] + nu.storage_units_t.p[phs][a1:a2]

#excluding "charging" cycles of PHS
dispatch_phs = dispatch_before_balancing['PHS'].copy()
dispatch_phs[dispatch_phs < 0] = 0
dispatch_before_balancing['PHS'] = dispatch_phs


dispatch_before_balancing.to_csv('results/dispatch/dispatch_before_balancing_{}hf.csv'.format(af))



#----------------------------------------------------------------------------------------------------------
#balancing cost
balancing_cost = pd.DataFrame()
mc_df = pd.DataFrame()
balancing_dispatch = pd.DataFrame(columns=nu.carriers.index, index = range(nu.snapshots.size)).fillna(0)
balancing_dispatch['penalty'] = 0
balancing_dispatch['PHS'] = 0
balancing_up = pd.DataFrame(columns=nu.carriers.index, index = range(nu.snapshots.size)).fillna(0)
balancing_up['penalty'] = 0
balancing_up['PHS'] = 0
balancing_down = pd.DataFrame(columns=nu.carriers.index, index = range(nu.snapshots.size)).fillna(0)
balancing_down['penalty'] = 0
balancing_down['PHS'] = 0
dim_total = pd.DataFrame()
dim_total = dimension_balancing['total'].tolist()  # negative value = underestimated (surplus), positive value = overestimated (short fall)


for i in range(a1, a2):
    dim = dim_total[i]
    mcp = nu.generators_t.p.iloc[i, :].sum()  # mc=market clearing point

    bc = 0  # bc = balancing cost
    mo = merit_order_t[i].reset_index(drop=True)
    start = mo[mo["accumulated power [MW]"] <= mcp-1].iloc[-1, :].name  # -0.001 -> as available power is defined by marginal generator, mcp would be located one mo step to the right,
                                                                           # even though it could be increased in output power

    if dim > 0:  # mo upwards modification
        imbalance = dim

        mi = start
        #mi = 0
        while imbalance != 0:
            carrier = mo.loc[mi, 'carrier']
            if carrier == 'OCGT':  # exception for OCGT and oil, as 1/2 ramping concept (area of triangle) would underestimate flexibility of ocgt (e.g. 0.75 as
                # as about half up to 7.5 minutes and then full for second half
                max_adj_up = mo.loc[mi, 'max adjustment up [MW]']

            elif carrier == 'oil':
                max_adj_up = mo.loc[mi, 'max adjustment up [MW]']

            else:
                max_adj_up = 0.5 * mo.loc[mi, 'max adjustment up [MW]']

            mc = mo.loc[mi, 'marginal cost [€/MWh]']


            im = max(0, imbalance - max_adj_up)

            if im > 0:
                bc = bc + (max_adj_up * mc * snapshot_weight)
                #bc = bc + (max_adj_up * generator_settings.loc[carrier]['marginal_cost [€/MWh]'] * snapshot_weight)
                balancing_dispatch.loc[i, carrier] = balancing_dispatch.loc[i, carrier] + max_adj_up #not multiplied with snaphot wight as rather power interpretation for snapshot
                balancing_up.loc[i, carrier] = balancing_up.loc[i, carrier] + max_adj_up #not multiplied with snaphot wight as rather power interpretation for snapshot
                imbalance = im
            else:
                bc = bc + (imbalance * mc * snapshot_weight)
                balancing_dispatch.loc[i, carrier] = balancing_dispatch.loc[i, carrier] + imbalance
                balancing_up.loc[i, carrier] = balancing_up.loc[i, carrier] + imbalance
                imbalance = 0
            mi += 1

    else:  # mo downwards modification
        imbalance = abs(dim)

        mi = start
        while imbalance != 0:
            carrier = mo.loc[mi, 'carrier']

            if (carrier == 'OCGT') or (carrier == 'oil'):  # exception for OCGT and oil, as 1/2 ramping concept (area of triangle) would underestimate flexibility of ocgt (e.g. 0.75 as
                # as about half up to 7.5 minutes and then full for second half
                max_adj_down = mo.loc[mi, 'max adjustment down [MW]']


            elif (carrier == 'offwind-ac') or (carrier == 'offwind-dc') or (carrier == 'onwind') or (carrier == 'solar'):
                max_adj_down = mo.loc[mi, 'max adjustment down [MW]']

            else:
                max_adj_down = 0.5 * mo.loc[mi, 'max adjustment down [MW]']

            mc = mo.loc[mi, 'marginal cost [€/MWh]']
            im = max(0, imbalance - max_adj_down)
            if im > 0:
                bc = bc - (max_adj_down * mc * snapshot_weight)
                imbalance = im
                balancing_dispatch.loc[i, carrier] = balancing_dispatch.loc[i, carrier] - max_adj_down
                balancing_down.loc[i, carrier] = balancing_down.loc[i, carrier] - max_adj_down
            else:
                bc = bc - (imbalance * mc * snapshot_weight)
                balancing_dispatch.loc[i, carrier] = balancing_dispatch.loc[i, carrier] - imbalance
                balancing_down.loc[i, carrier] = balancing_down.loc[i, carrier] - imbalance
                imbalance = 0
            mi -= 1

    balancing_cost.loc[i, 'balancing cost [€]'] = bc

balancing_cost = balancing_cost.set_index(nu.snapshots[a1:a2])

balancing_cost_total = balancing_cost['balancing cost [€]'].sum()



#adding dimension balancing (correction of forecasting errors wind&pv) in balancing dispatch df
dimension_balancing = dimension_balancing[a1:a2]
dimension_balancing.index = nu.snapshots[a1:a2]
balancing_dispatch = balancing_dispatch.iloc[a1:a2,:]
balancing_dispatch.index = nu.snapshots[a1:a2]

dispatch_after_balancing = pd.DataFrame()

    #columns=nu.carriers.index, index=nu.snapshots[a1:a2]).fillna(0)

for carrier in dispatch_before_balancing.columns:
    dispatch_after_balancing[carrier] = dispatch_before_balancing.loc[:, carrier]

for carrier in dispatch_after_balancing.columns:
    dispatch_after_balancing[carrier] = dispatch_after_balancing[carrier] + balancing_dispatch[carrier].tolist()
    #dispatch_after_balancing.index = nu.snapshots[a1:a2]

for carrier in carriers_vre:
    dispatch_after_balancing[carrier] = dispatch_after_balancing[carrier] + dimension_balancing[carrier].tolist()




#------------------------------------------------------------------------------------------------------
#total dispatch cost
dispatch_cost_total = var_cost_generators_total + penalty_cost_total + startup_cost_generators_total + balancing_cost_total


#saving scalar cost results to df (main cost df)
cost_df = pd.read_csv('results/cost_df.csv', index_col=0)

cost_df.loc['{}hf'.format(af), 'total variable generation cost [€]'] = var_cost_generators_total
cost_df.loc['{}hf'.format(af), 'total generator start-up cost [€]'] = startup_cost_generators_total
cost_df.loc['{}hf'.format(af), 'total penalty-term cost [€]'] = penalty_cost_total
cost_df.loc['{}hf'.format(af), 'total balancing cost [€]'] = balancing_cost_total
cost_df.loc['{}hf'.format(af), 'total dispatch cost [€]'] = dispatch_cost_total

cost_df.to_csv('results/cost_df.csv')



# -----------------------------------------------------------------------------------------------------------------------
#saving dispatch

balancing_dispatch.to_csv('results/balancing_dimension/balancing_dispatch_{}hf.csv'.format(af))  # dispatch change after balancing

balancing_up = balancing_up[a1:a2].set_index(nu.snapshots[a1:a2])
balancing_up.to_csv('results/balancing_dimension/balancing_up_{}hf.csv'.format(af))  # dispatch change after balancing

balancing_down = balancing_down[a1:a2].set_index(nu.snapshots[a1:a2])
balancing_down.to_csv('results/balancing_dimension/balancing_down_{}hf.csv'.format(af))  # dispatch change after balancing

dispatch_after_balancing.to_csv('results/dispatch/dispatch_after_balancing_{}hf.csv'.format(af))








'''
#-----------------------------------------------------------------------------------------------------------------------
# balancing cost simple version (constant factors):
cost_df_c = pd.read_csv('results/cost_df_c.csv', index_col=0)

for c in range(1, 7):

    if c == 1:
        downwards = 0.8
        upwards = 1.2
    if c == 2:
        downwards = 0.7
        upwards = 1.3
    if c == 3:
        downwards = 0.6
        upwards = 1.4
    if c == 4:
        downwards = 0.5
        upwards = 1.5
    if c == 5:
        downwards = 0.5
        upwards = 2
    if c == 6:
        downwards = 0.5
        upwards = 3

    balancing_cost = pd.DataFrame()
    mc_df = pd.DataFrame()

    for i in range(a1, a2):

        dim = dimension_balancing.loc[
            i, 'total']  # negative value = underestimated (surplus), positive value = overestimated (short fall)

        mo = merit_order_t[i].reset_index(drop=True)

        mcp = nu.generators_t.p.iloc[i, :].sum()  # mcp=market clearing point
        mc =mo[mo["accumulated power [MW]"] <= mcp - 1].iloc[-1, :]['marginal cost [€/MWh]'] #marginal cost

        bc = 0  # bc = balancing cost

        if dim < 0:
            bc = dim * downwards * mc * snapshot_weight

        else:
            bc = dim * upwards * mc * snapshot_weight

        balancing_cost.loc[i, 'balancing cost [€]'] = bc

    balancing_cost = balancing_cost.set_index(nu.snapshots[a1:a2])

    balancing_cost_total = balancing_cost['balancing cost [€]'].sum()

    cost_df_c.loc['{}hf'.format(af), '{}run.balancing'.format(c)] = balancing_cost_total
    cost_df_c.loc['{}hf'.format(af), '{}run.total'.format(c)] = var_cost_generators_total + startup_cost_generators_total + penalty_cost_total + balancing_cost_total

cost_df_c.to_csv('results/cost_df_c.csv')
'''