# Developed by Jan Fabian Martin


#importing modified RMSE distribution (see "ForecastError_SigmaIteration.R")
synthCorrectSd = pd.read_csv('synthCorrectSd.csv', index_col=0)
synthCorrectSd = synthCorrectSd.append(synthCorrectSd.iloc[[-1]*3]).reset_index(drop=True)

#generating a random error distribution
#array length of forecasting horizon
#carrier specific and lead-time dependent standard deviation around mean=1
def probability_distribution(length, carrier):
    random_array = np.zeros(length)
    for i in range(length):
        if carrier == 'solar':
            random_array[i] = np.random.normal(loc=1, scale=synthCorrectSd.iloc[i,2])
        if carrier == 'onwind':
            random_array[i] = np.random.normal(loc=1, scale=synthCorrectSd.iloc[i,0])
        if carrier == 'offwind-ac' or carrier == 'offwind-dc':
            random_array[i] = np.random.normal(loc=1, scale=synthCorrectSd.iloc[i,1])
    return random_array


#generating probability distribution matrix (given carrier and horizon)
#rows: forecasting horizon
#colums: one probability distribution per snapshot -> each column = array from "probability_distribution" function (above)
def probability_matrix(length, carrier):
    random_df = pd.DataFrame([])
    for i in range(nu.snapshots.size):
        random_df[i] = probability_distribution(length, carrier)
    random_df[random_df < 0] = 0 #forecasting error factor not to be below zero to avoid "negative generation"
    return random_df


#compiling and holding all probability distribution matrices (one per VRE carrier) in a dictionary
prob_matrices = {} #dictionary
np.random.seed(17805) #seed for reproducable results

for c in ['onwind', 'offwind-ac', 'solar']:
    prob_matrices[c] = probability_matrix(length=horizon+tbr, carrier=c)

prob_matrices['offwind-dc'] = prob_matrices['offwind-ac']


# saving dictionary (probability matrices) to file
with open('results/prob_matrices.p', 'wb') as fp:
    pickle.dump(prob_matrices, fp, protocol=pickle.HIGHEST_PROTOCOL)


#saving probability matrices to csv files
prob_matrices['offwind-ac'].to_csv('results/probabilityMatrix_offwind.csv')
prob_matrices['onwind'].to_csv('results/probabilityMatrix_onwind.csv')
prob_matrices['solar'].to_csv('results/probabilityMatrix_solar.csv')


'''
# importing dictionary probabilities
with open('results/prob_matrices.p', 'rb') as fp:
    prob_matrices = pickle.load(fp)
'''