# Developed by Jan Fabian Martin


# range of forecasting lead-time (horizon)
rng = pd.RangeIndex(start=0, stop=145, step=1) # 0-36 hours in 15 minutes snapshots

rmse = np.empty((len(rng)))
rmse[:] = np.nan

#---------------------------------------------

# probability vs. lead-time onwind
prb_vector_onwind = pd.DataFrame(index=rng)
prb_vector_onwind['RMSE [%]'] = rmse

#feed with data from referenced literature
prb_vector_onwind['RMSE [%]'][0] = 0
prb_vector_onwind['RMSE [%]'][4] = 1.7
prb_vector_onwind['RMSE [%]'][8] = 2.7
prb_vector_onwind['RMSE [%]'][16] = 3.95
prb_vector_onwind['RMSE [%]'][32] = 4.6
prb_vector_onwind['RMSE [%]'][96] = 5.8
prb_vector_onwind['RMSE [%]'][144] = 6.7


prb_vector_onwind = prb_vector_onwind.interpolate(method='linear')

#---------------------------------------------

# probability vs. lead time solar
prb_vector_solar = pd.DataFrame(index=rng)
prb_vector_solar['RMSE [%]'] = rmse

#feed with data from referenced literature

prb_vector_solar['RMSE [%]'][0] = 0
prb_vector_solar['RMSE [%]'][1] = 0.5
prb_vector_solar['RMSE [%]'][2] = 0.8
prb_vector_solar['RMSE [%]'][3] = 1.1
prb_vector_solar['RMSE [%]'][4] = 1.3
prb_vector_solar['RMSE [%]'][8] = 2.1
prb_vector_solar['RMSE [%]'][12] = 2.8
prb_vector_solar['RMSE [%]'][16] = 3
prb_vector_solar['RMSE [%]'][20] = 3.1

prb_vector_solar['RMSE [%]'][144] = 7

prb_vector_solar = prb_vector_solar.interpolate(method='linear')

#---------------------------------------------

# probability vs. lead time offwind-ac and offwind-d
prb_vector_offwind = pd.DataFrame(index=rng)
prb_vector_offwind['RMSE [%]'] = rmse

#feed with data from referenced literature
prb_vector_offwind['RMSE [%]'][0] = 0
prb_vector_offwind['RMSE [%]'][12] = 9
#prb_vector_offwind['RMSE [%]'][52] = 9.5
prb_vector_offwind['RMSE [%]'][56] = 10.5
prb_vector_offwind['RMSE [%]'][60] = 11
prb_vector_offwind['RMSE [%]'][80] = 12
prb_vector_offwind['RMSE [%]'][100] = 12.5
prb_vector_offwind['RMSE [%]'][120] = 13.5
prb_vector_offwind['RMSE [%]'][144] = 13.5

prb_vector_offwind = prb_vector_offwind.interpolate(method='linear')

#---------------------------------------------



# saving intermittent renewable energy generator availability time series - further process with "ForecastError-SigmaIteration.R":

# onshore wind availability
generators_onwind_p_max_pu = pd.DataFrame()

gen_list = nu.generators.index[nu.generators.carrier=='onwind']
for gen in gen_list:
    generators_onwind_p_max_pu[gen] = nu.generators_t.p_max_pu[gen]

generators_onwind_p_max_pu.to_csv('results/beforeBalancing/re_timeseries/timeseries_onwind.csv')


# solar PV availability
generators_solar_p_max_pu = pd.DataFrame()

gen_list = nu.generators.index[nu.generators.carrier=='solar']
for gen in gen_list:
    generators_solar_p_max_pu[gen] = nu.generators_t.p_max_pu[gen]

generators_solar_p_max_pu.to_csv('results/beforeBalancing/re_timeseries/timeseries_solar.csv')


# offshore wind availability
generators_offwind_p_max_pu = pd.DataFrame()

gen_list = nu.generators.index[(nu.generators.carrier=='offwind-ac') | (nu.generators.carrier=='offwind-dc')]
for gen in gen_list:
    generators_offwind_p_max_pu[gen] = nu.generators_t.p_max_pu[gen]

generators_offwind_p_max_pu.to_csv('results/beforeBalancing/re_timeseries/timeseries_offwind.csv')


#---------------------------------------------

# saving RMSE literature values over lead time as .csv - further process with "ForecastError-SigmaIteration.R"
nu.generators.p_nom.to_csv('results/beforeBalancing/re_timeseries/p_nom.csv')

prb_vector_onwind.to_csv('results/beforeBalancing/re_timeseries/prob_onwind.csv')
prb_vector_offwind.to_csv('results/beforeBalancing/re_timeseries/prob_offwind.csv')
prb_vector_solar.to_csv('results/beforeBalancing/re_timeseries/prob_solar.csv')