# Developed by Jan Fabian Martin


#adjusting installed generator capacity per carrier to 2020 values
ocgt_factor = 1.147
ccgt_factor = 1.147
coal_factor = 0.856
lignite_factor = 0.884
nuclear_factor = 0.512
oil_factor = 1.155
biomass_factor = 6.079 #calibrated to peak generation (according to smard data by Bundesnetzagentur) not installed capacity
solar_factor = 1.227
onwind_factor = 1.289
offwind_factor = 1 #manual adjustment follows later (approximate allocation to dc/ac link)
ror_factor = 0.7 #calibrated to peak generation (according to smard data by Bundesnetzagentur) not installed capacity

#adjusting total yearly load to 2020 data
load_factor = 1.0727
nu.loads_t.p_set = nu.loads_t.p_set * load_factor


#while keeping existing geographical allocation, generator capacities are multiplied with carrier specific factor (defined above)
for gen in nu.generators.index[(nu.generators['carrier'] == 'CCGT') | (nu.generators['carrier'] == 'OCGT')]:
    nu.generators.loc[gen, 'p_nom'] = ocgt_factor * nu.generators.loc[gen, 'p_nom']

for gen in nu.generators.index[(nu.generators['carrier'] == 'coal')]:
    nu.generators.loc[gen, 'p_nom'] = coal_factor * nu.generators.loc[gen, 'p_nom']

for gen in nu.generators.index[(nu.generators['carrier'] == 'lignite')]:
    nu.generators.loc[gen, 'p_nom'] = lignite_factor * nu.generators.loc[gen, 'p_nom']

for gen in nu.generators.index[(nu.generators['carrier'] == 'nuclear')]:
    nu.generators.loc[gen, 'p_nom'] = nuclear_factor * nu.generators.loc[gen, 'p_nom']

for gen in nu.generators.index[(nu.generators['carrier'] == 'biomass')]:
    nu.generators.loc[gen, 'p_nom'] = biomass_factor * nu.generators.loc[gen, 'p_nom']

for gen in nu.generators.index[(nu.generators['carrier'] == 'solar')]:
    nu.generators.loc[gen, 'p_nom'] = solar_factor * nu.generators.loc[gen, 'p_nom']

for gen in nu.generators.index[(nu.generators['carrier'] == 'onwind')]:
    nu.generators.loc[gen, 'p_nom'] = onwind_factor * nu.generators.loc[gen, 'p_nom']

for gen in nu.generators.index[(nu.generators['carrier'] == 'ror')]:
    nu.generators.loc[gen, 'p_nom'] = ror_factor * nu.generators.loc[gen, 'p_nom']



#offwind-ac and offwind-dc adjusted manually to 2020 values
#approximation according to Wikipedia (https://de.wikipedia.org/wiki/Liste_der_deutschen_Offshore-Windparks)
#bus DE0 0 4 connecting to Baltic Sea, bus DE0 5 connecting to North Sea wind farms
nu.generators.loc['DE0 4 offwind-ac', 'p_nom'] = nu.generators.p_nom['DE0 4 offwind-ac'] + 760
nu.generators.loc['DE0 5 offwind-dc', 'p_nom'] = 0.9 * 6645
nu.generators.loc['DE0 5 offwind-ac', 'p_nom'] = 0.1 * 6645


#---------------------------------------------------------------------------------------------------

#assigning carriers to categories (variable renewable energy and conventional carriers):
carriers_conventional = ['CCGT', 'OCGT', 'coal', 'lignite', 'nuclear', 'oil', 'biomass']
carriers_vre = ['onwind', 'solar', 'offwind-ac', 'offwind-dc']


#assigning generators to carrier categories
generators_all = pd.DataFrame(nu.generators.carrier)
generators_conventional = pd.DataFrame(generators_all[generators_all['carrier'].isin(carriers_conventional)])
generators_vre = pd.DataFrame(generators_all[generators_all['carrier'].isin(carriers_vre)])




#------------------------------------------------------------------------------------------------------

#dataframe with respective carrier and start-up time for conventional power plants:

start_up_time = []
carrier = []

for c in carriers_conventional:
    carrier.append(generators_conventional['carrier'] == c)
    start_up_time.append(int(generator_settings.loc[c, 'start_up_time [h]'] / snapshot_weight))

generators_conventional['start-up_time [sn]'] = np.select(carrier, start_up_time)


#-------------------------------------------------------------------------------------------------------

#assigning UC constraints from "generator_settings.xlsx" to PyPSA network generator objects:

for gen in generators_conventional.index:
    carrier = nu.generators.loc[gen, 'carrier']
    nu.generators.loc[gen, 'committable'] = generator_settings.loc[carrier]['committable']
    nu.generators_t.p_max_pu.loc[:,gen] = generator_settings.loc[carrier]['p_max_pu']
    nu.generators_t.p_min_pu.loc[:,gen] = generator_settings.loc[carrier]['p_min_pu']
    nu.generators.loc[gen, 'p_min_pu'] = generator_settings.loc[carrier]['p_min_pu']
    nu.generators.loc[gen, 'marginal_cost'] = generator_settings.loc[carrier]['marginal_cost [€/MWh]']
    nu.generators.loc[gen, 'start_up_cost'] = generator_settings.loc[carrier]['start_up_cost [€/MW]'] * \
                                              nu.generators.loc[gen, 'p_nom']
    nu.generators.loc[gen, 'min_up_time'] = int(generator_settings.loc[carrier]['min_up_time [h]'] / snapshot_weight)
    nu.generators.loc[gen, 'min_down_time'] = int(generator_settings.loc[carrier]['min_down_time [h]'] / snapshot_weight)
    nu.generators.loc[gen, 'ramp_limit_start_up'] = generator_settings.loc[carrier]['ramp_limit_start_up [p.u.]']
    nu.generators.loc[gen, 'ramp_limit_shut_down'] = generator_settings.loc[carrier]['ramp_limit_shut_down [p.u.]']
    nu.generators.loc[gen, 'ramp_limit_up'] = generator_settings.loc[carrier]['ramp_limit_up [p.u] per 15min'] * 4 * snapshot_weight
    nu.generators.loc[gen, 'ramp_limit_down'] = generator_settings.loc[carrier]['ramp_limit_down [p.u.] per 15min'] * 4 * snapshot_weight



#setting parameters "committable" and "extendable" (including vre)
nu.generators['committable'] = True
nu.generators['p_nom_extendable'] = False

# changing float64 data to int32
up = nu.generators['min_up_time'].astype(int)
down = nu.generators['min_down_time'].astype(int)
nu.generators['min_up_time'] = up
nu.generators['min_down_time'] = down
nu.generators.ramp_limit_down = nu.generators.ramp_limit_down.fillna(1)


#----------------------------------------------------------------------------------------------------------------------
# upscaling and interpolating PyPSA-EUR's hourly dataset to 15 minute snapshots:

dti = pd.date_range("2013-01-01", periods=nu.snapshots.size, freq="H") # int numbers (PyPSA-EUR network file) to datetime index

#load upscaling and interpolating
for key in nu.loads_t:
    nu.loads_t[key] = nu.loads_t[key].set_index(dti)
    nu.loads_t[key] = nu.loads_t[key].resample('15min').interpolate()
    nu.loads_t[key] = nu.loads_t[key][t1:t2]

#generator upscaling and interpolating
for key in nu.generators_t:
    nu.generators_t[key] = nu.generators_t[key].set_index(dti)
    nu.generators_t[key] = nu.generators_t[key].resample('15min').interpolate()
    nu.generators_t[key] = nu.generators_t[key][t1:t2]

#bus upscaling and interpolating
for key in nu.buses_t:
    nu.buses_t[key] = nu.buses_t[key].set_index(dti)
    nu.buses_t[key] = nu.buses_t[key].resample('15min').interpolate()
    nu.buses_t[key] = nu.buses_t[key][t1:t2]

#storage_unit upscaling and interpolating
for key in nu.storage_units_t:
    nu.storage_units_t[key] = nu.storage_units_t[key].set_index(dti)
    nu.storage_units_t[key] = nu.storage_units_t[key].resample('15min').interpolate()
    nu.storage_units_t[key] = nu.storage_units_t[key][t1:t2]

#store upscaling and interpolating
for key in nu.stores_t:
    nu.stores_t[key] = nu.stores_t[key].set_index(dti)
    nu.stores_t[key] = nu.stores_t[key].resample('15min').interpolate()
    nu.stores_t[key] = nu.stores_t[key][t1:t2]

#shunt-impedance upscaling and interpolating
for key in nu.shunt_impedances_t:
    nu.shunt_impedances_t[key] = nu.shunt_impedances_t[key].set_index(dti)
    nu.shunt_impedances_t[key] = nu.shunt_impedances_t[key].resample('15min').interpolate()
    nu.shunt_impedances_t[key] = nu.shunt_impedances_t[key][t1:t2]

#line upscaling and interpolating
for key in nu.lines_t:
    nu.lines_t[key] = nu.lines_t[key].set_index(dti)
    nu.lines_t[key] = nu.lines_t[key].resample('15min').interpolate()
    nu.lines_t[key] = nu.lines_t[key][t1:t2]

#transformer upscaling and interpolating
for key in nu.transformers_t:
    nu.transformers_t[key] = nu.transformers_t[key].set_index(dti)
    nu.transformers_t[key] = nu.transformers_t[key].resample('15min').interpolate()
    nu.transformers_t[key] = nu.transformers_t[key][t1:t2]

#link upscaling and interpolating
for key in nu.links_t:
    nu.links_t[key] = nu.links_t[key].set_index(dti)
    nu.lines_t[key] = nu.links_t[key].resample('15min').interpolate()
    nu.lines_t[key] = nu.lines_t[key][t1:t2]


#general snapshot upscaling (cutting to predefined time-period between t1 and t2)
nu.snapshots = dti.to_series().resample('15T').asfreq().index
nu.snapshots = nu.snapshots[t1:t2]
nu.set_snapshots(nu.snapshots.to_series().index)

nu.snapshots.freq = None
nu.snapshot_weightings.values[:] = snapshot_weight #equalizing snapshot weightings

#----------------------------------------------------------------------------------------------------------------------

#introducing penalty term in order to avoid infeasibilities
#implemented as a generator assigned to each bus

for bus in nu.buses.index:
    nu.add("Generator", "penalty_term_{}".format(bus),
           bus=bus,
           p_nom=100000000000,
           p_min_pu=0,
           p_max_pu=1,
           carrier='penalty',
           ramp_limit_down=1.0,
           ramp_limit_up=1.0,
           min_down_time=0,
           min_up_time=0,
           marginal_cost=3000)

    penalty_terms = ['penalty_term_DE0 0', 'penalty_term_DE0 1', 'penalty_term_DE0 2', 'penalty_term_DE0 3', 'penalty_term_DE0 4', 'penalty_term_DE0 5']

    for penalty in penalty_terms:
        nu.generators_t.p_max_pu[penalty] = 1.0
        nu.generators_t.p_min_pu[penalty] = 0.0
        nu.generators_t.p[penalty] = 0.0


#---------------------------------------------------------------------------------------

#storing original renewable energy time series in df (to maintain realised values without forecasting uncertainty applied)
generation_vre = pd.DataFrame([])
for gen in generators_vre.index:
    generation_vre[gen] = nu.generators_t.p_max_pu[gen]

generation_vre.to_csv("results/re_timeseries/generation_vre.csv")

#--------------------------------------------------------------------------------------------------------
#dataframe to save total UC cost components
cost_df = pd.DataFrame()
cost_df.to_csv('results/cost_df.csv')

#dataframe to save UC cost components with simplified (constant) balancing approach
cost_df_c = pd.DataFrame()
cost_df_c.to_csv('results/cost_df_c.csv')
