# Developed by Jan Fabian Martin

#snapshot numbers to be translated in timestamp (later application)
t_snap = nu.generators_t.p_max_pu.index


#main optimization loop - rolling horizon approach
#iterative process through all snapshots within optimization time period (s1-s2)
#continuous re-optimization of snapshots every 'auction_frequency' hour
for i in range(s1, s2, auction_frequency):

    if i > s1: #first rolling horizon iteration is skipped as i-tbr snapshot is accessed, however not existent if i=0

        #start-up time implementation (between auction clearing and start-up)
        #fixing generator status (if zero generation) for carrier specific start-up time; considering time before realtime
        for gen, column in generators_conventional.iterrows():
            for k in range(i-tbr, i + column['start-up_time [sn]']-tbr):
                if k < nu.snapshots.size and nu.generators_t.p[gen][i-tbr-1] == 0:
                    if nu.generators_t.p[gen][k] == 0:
                        nu.generators_t.p_max_pu.loc[t_snap[k], gen] = 0


        #applying probability distribution to variable renewable energy generation (realised generation time series)
        for gen in generators_vre.index:
            generation = generation_vre[gen][i:min(i+horizon,nu.snapshots.size)].reset_index(drop=True) #restoring original time series

            carrier = nu.generators.carrier[gen]
            p = prob_matrices[carrier][i][tbr:tbr + len(generation)].reset_index(drop=True).multiply(generation)
            p.index = t_snap[i:min(i+horizon,nu.snapshots.size)]
            a = np.array(p.values.tolist())
            nu.generators_t.p_max_pu.loc[t_snap[i]:t_snap[min(i+horizon,nu.snapshots.size)-1], gen] = np.where(a > 1.0, 1.0, a).tolist()



    #optimal power flow calculation over optimization horizon
    nu.lopf(nu.snapshots[i:min(i+horizon,nu.snapshots.size)], solver_name='gurobi')
    print("If at snapshot: ", i, "of ", s2-auction_frequency)