
#importing VRE availability time series
timeseries_onwind = read.csv("Rdata/timeseries_onwind.csv")
timeseries_offwind = read.csv("Rdata/timeseries_offwind.csv")
timeseries_solar = read.csv("Rdata/timeseries_solar.csv")


#importing generator's rated power
p_nom = read.csv("Rdata/p_nom.csv")


#RMSE over forecasting lead-time [%/rated power] (literatur values)
prob_onwind = read.csv("Rdata/prob_onwind.csv")
prob_offwind = read.csv("Rdata/prob_offwind.csv") 
prob_solar = read.csv("Rdata/prob_solar.csv") 


#-------------------------------------------------------

#proximity function:

rmseDifference <- function(sd1){
  
  forecastRelativeError=rnorm(35037, mean = 1, sd = sd1)
  
  forecast=pmin(nominalPower,pmax(0,pReal*forecastRelativeError))

  
  absoluteForecastError=(forecast-pReal)/nominalPower
  
  #snapshots of zero solar availability excluded from calculation
  #(referenced RMSE literature based on daytime values)
  if (carrier == 'solar'){
    rmseSynth = sd(absoluteForecastError[absoluteForecastError!=0])
  }else {
    rmseSynth = sd(absoluteForecastError)
  }
  
  rmseSynth[is.na(rmseSynth)] <- 0.0 
  
  return(rmseSynth-rmseReal)
}


#-------------------------------------------------------

#rmse onwind:

carrier = 'onwind'
nominalPower= p_nom[7,]$p_nom + p_nom[17,]$p_nom + p_nom[26,]$p_nom + p_nom[36,]$p_nom + p_nom[47,]$p_nom + p_nom[58,]$p_nom

pReal= (timeseries_onwind$DE0.0.onwind * p_nom[07,]$p_nom) +
  (timeseries_onwind$DE0.1.onwind * p_nom[17,]$p_nom) +
  (timeseries_onwind$DE0.2.onwind * p_nom[26,]$p_nom) +
  (timeseries_onwind$DE0.3.onwind * p_nom[36,]$p_nom) +
  (timeseries_onwind$DE0.4.onwind * p_nom[47,]$p_nom) +
  (timeseries_onwind$DE0.5.onwind * p_nom[58,]$p_nom)


c= 1
synthCorrectSd_onwind <- vector()

for (r in prob_onwind$RMSE....){

  rmseReal = r/100 #literature value

  result=uniroot(rmseDifference, lower=0, upper=1, extendInt = 'yes')
  synthCorrectSd_onwind[c]=result$root
  
  c = c+1
}



#rmse offwind:

carrier='offwind'
nominalPower= p_nom[44,]$p_nom + p_nom[45,]$p_nom + p_nom[55,]$p_nom + p_nom[56,]$p_nom

pReal= (timeseries_offwind$DE0.4.offwind.ac * p_nom[44,]$p_nom) +
  (timeseries_offwind$DE0.4.offwind.dc * p_nom[45,]$p_nom) +
  (timeseries_offwind$DE0.5.offwind.ac * p_nom[55,]$p_nom) +
  (timeseries_offwind$DE0.5.offwind.dc * p_nom[56,]$p_nom)


c= 1
synthCorrectSd_offwind <- vector()

for (r in prob_offwind$RMSE....){
  
  rmseReal = r/100 #literature value

  result=uniroot(rmseDifference, lower=0, upper=1, extendInt = 'yes')
  synthCorrectSd_offwind[c]=result$root
  
  c = c+1
}



#rmse solar:

carrier = 'solar'
nominalPower= p_nom[9,]$p_nom + p_nom[19,]$p_nom + p_nom[28,]$p_nom + p_nom[38,]$p_nom + p_nom[49,]$p_nom + p_nom[60,]$p_nom

pReal= (timeseries_solar$DE0.0.solar * p_nom[9,]$p_nom) +
  (timeseries_solar$DE0.1.solar * p_nom[19,]$p_nom) +
  (timeseries_solar$DE0.2.solar * p_nom[28,]$p_nom) +
  (timeseries_solar$DE0.3.solar * p_nom[38,]$p_nom) +
  (timeseries_solar$DE0.4.solar * p_nom[49,]$p_nom) +
  (timeseries_solar$DE0.5.solar * p_nom[60,]$p_nom)


c= 1
synthCorrectSd_solar <- vector()

for (r in prob_solar$RMSE....){
  
  rmseReal = r/100 #literature value

  result=uniroot(rmseDifference, lower=0, upper=1, extendInt = 'yes')
  synthCorrectSd_solar[c]=result$root
  
  c = c+1
}



# rmse per carrier merged in one df
synthCorrectSd <- data.frame(matrix(ncol = 3, nrow = 145))
cn = c("onwind", "offwind", "solar")
colnames(synthCorrectSd) <- cn
synthCorrectSd$onwind = synthCorrectSd_onwind
synthCorrectSd$offwind = synthCorrectSd_offwind
synthCorrectSd$solar = synthCorrectSd_solar

write.csv(synthCorrectSd,"synthCorrectSd.csv", row.names = TRUE)  
