"""
Created on Monday December 06 2021

@author: Masterarbeit
"""

#-----------------------------------------------------------------------------------------------------------------------


#introducing negative penalty terms
#to avoid infeasibility in case of downramping ability of conventional generators is not sufficient
#(should not be utilised)
for bus in nu.buses.index:
    nu.add("Generator", "penalty_negative_{}".format(bus),
           bus=bus,
           p_nom=100000000000,
           p_min_pu=-1,
           p_max_pu=0,
           carrier='penalty_negative',
           ramp_limit_down=1.0,
           ramp_limit_up=1.0,
           min_down_time=0,
           min_up_time=0,
           marginal_cost=-300)

penalty_negative = ['penalty_negative_DE0 0', 'penalty_negative_DE0 1', 'penalty_negative_DE0 2', 'penalty_negative_DE0 3', 'penalty_negative_DE0 4', 'penalty_negative_DE0 5']

for penalty in penalty_negative:
    nu.generators_t.p_max_pu[penalty] = 0.0
    nu.generators_t.p_min_pu[penalty] = -1
    nu.generators_t.p[penalty] = 0


#-----------------------------------------------------------------------------------------------------------------------

#snapshot numbers to be translated in timestamp (later application)
t_snap = nu.generators_t.p_max_pu.index


#releasing UC constraints (only p_min/p_max and ramp rate applies)
#committable = False for all generators
nu.generators.committable = False


#adjusting renewable generation p_max to real value (availability vre)
for gen in generators_vre.index:
    nu.generators_t.p_max_pu.loc[t_snap[a1]:t_snap[a2-1], gen] = generation_vre[gen][a1:a2].tolist()
    nu.generators_t.p_min_pu.loc[t_snap[a1]:t_snap[a2-1], gen] = 0



#_t.p_min not defined for before (to avoid p_min = nan)
for gen in nu.generators.index[(nu.generators['carrier'] == 'ror')]:
    nu.generators_t.p_min_pu[gen] = 0  # nu.generators.p_min_pu[gen]


#singular very low dispatch values (e.g. 0.00013e-15) appear as result of first-state optimization
nu.generators_t.p[nu.generators_t.p < 1] = 0


#for start-up/shut down detection
#(as problem with stept from 0 - p_min or from p_min - 0 -> ramp rate violation if not in unit commitment optimization)
startup = False
down = False

#-----------------------------------------------------------------------------------------------------------------------

#setting constraints for each generator and snapshot
#balancing dispatch optimization for each snapshot separately
#within time period under analyis (a1-a2)

for i in range(a1, a2):

    for gen in generators_conventional.index:

        # exception for flexible oil and OCGT generators
        if gen not in nu.generators.index[(nu.generators['carrier'] == 'oil') | (nu.generators['carrier'] == 'OCGT')]:

            #in case of start-up/shut-down, ramp limit to p_min (start-up/shut-down step defined in UC optimization would
            #violates ramping constraints
            if (nu.generators_t.p.loc[t_snap[i + 1], gen] < 1) or (nu.generators_t.p.loc[t_snap[i - 1], gen] < 1):
                nu.generators_t.p_max_pu.loc[t_snap[i], gen] = nu.generators.p_min_pu[gen]
                nu.generators_t.p_min_pu.loc[t_snap[i], gen] = nu.generators.p_min_pu[gen]
            else:
                #1. version: p_max is set that, given the ramp rate of a generator, the generation of the following snapshot remains unchanged (based on energy within the snapshot, not based on power ramping)
                # -> see figure "balancing_ramping_approach.pdf"
                #not exceed nominal power (p_nom)
                #not fall below minimum power (p_min)
                nu.generators_t.p_max_pu.loc[t_snap[i], gen] = min((nu.generators_t.p.loc[t_snap[i+1], gen]/nu.generators.loc[gen, 'p_nom']) + (0.25 * nu.generators.loc[gen, 'ramp_limit_up']),1)
                nu.generators_t.p_min_pu.loc[t_snap[i], gen] = max((nu.generators_t.p.loc[t_snap[i+1], gen]/nu.generators.loc[gen, 'p_nom']) - (0.25* nu.generators.loc[gen, 'ramp_limit_up']), nu.generators.p_min_pu[gen])


                #2. version: allowing for a constant factor of flexibility (e.g. +5% of generator capacity to generation determined in first-state dispatch)
                #nu.generators_t.p_max_pu.loc[t_snap[i], gen] = min((nu.generators_t.p.loc[t_snap[i], gen] / nu.generators.loc[gen, 'p_nom'])+0.05, 1)
                #nu.generators_t.p_min_pu.loc[t_snap[i], gen] = max((nu.generators_t.p.loc[t_snap[i], gen]/nu.generators.loc[gen, 'p_nom']) - 0.05, nu.generators.p_min_pu[gen])


            # exception when down-ramping:  if new set p_max constraint does not allow for full ramp_limit down-ramping as given as result from first-state-dispatch
            if ((nu.generators_t.p.loc[t_snap[i - 1], gen] / nu.generators.loc[gen, 'p_nom']) - nu.generators_t.p_max_pu.loc[t_snap[i], gen]) > nu.generators.loc[gen, 'ramp_limit_down']:
                nu.generators_t.p_max_pu.loc[t_snap[i], gen] = (nu.generators_t.p.loc[t_snap[i - 1], gen] / nu.generators.loc[gen, 'p_nom']) - nu.generators.loc[gen, 'ramp_limit_down']


            # exception when up-ramping:  if new set p_max constraint does not allow for full ramp_limit up-ramping as given as result from first-state-dispatch
            if (nu.generators_t.p_min_pu.loc[t_snap[i], gen] - (nu.generators_t.p.loc[t_snap[i-1], gen] / nu.generators.loc[gen, 'p_nom'])) > nu.generators.loc[gen, 'ramp_limit_up']:
                nu.generators_t.p_min_pu.loc[t_snap[i], gen] = (nu.generators_t.p.loc[t_snap[i - 1], gen] / nu.generators.loc[gen, 'p_nom']) + nu.generators.loc[gen, 'ramp_limit_up']


            #generators fixed at zero generation according to dispatch decision in first-state (as start-up delay applies)
            if nu.generators_t.p[gen][i] == 0:
                nu.generators_t.p_max_pu.loc[t_snap[i], gen] = 0
                nu.generators_t.p_min_pu.loc[t_snap[i], gen] = 0


            #start-up: if change between 0 and p_min detected -> ramping to be increased for one snapshot to p_min
            #(different rule within UC optimization: 0->p_min_pu or p_min_pu-> is regular start-up/shut-down)
            if (nu.generators_t.p.loc[t_snap[i-1], gen] == 0) and (nu.generators_t.p_min_pu.loc[t_snap[i], gen] >= nu.generators.loc[gen, 'ramp_limit_up'] ):
                nu.generators.loc[gen, 'ramp_limit_up'] = nu.generators.loc[gen, 'p_min_pu']
                startup=True
                print(gen)

            #shut-down: if change between p_min and 0 detected -> ramping to be increased for one snapshot(to p_min)
            if (nu.generators_t.p.loc[t_snap[i], gen] == 0) and (nu.generators_t.p.loc[t_snap[i-1], gen] > nu.generators.loc[gen, 'ramp_limit_down']):
               nu.generators.loc[gen, 'ramp_limit_down'] = nu.generators.loc[gen, 'p_min_pu']
               down = True
               print(gen)


    #exception for flexible oil and OCGT generators
    #allowing for full flexibility between 0-100% generation (only constrained by rated power)
    for gen in nu.generators.index[(nu.generators['carrier'] == 'oil') | (nu.generators['carrier'] == 'OCGT')]:
        nu.generators_t.p_max_pu.loc[t_snap[i], gen] = 1
        nu.generators_t.p_min_pu.loc[t_snap[i], gen] = 0  # nu.generators.p_min_pu[gen]


        #marginal cost adjustment in order to include start-up cost (approximately):

        #if zero generation in previous snapshot -> marginal cost [€/MWh] = marginal cost[€/MWh] + start-up_cost[€/MW] * (1/expected_on_period_balancing[1/h))
        if nu.generators_t.p[gen][i-1] < 1:
            nu.generators.loc[gen, 'marginal_cost'] = generator_settings.loc[nu.generators.carrier[gen]]['marginal_cost [€/MWh]'] +\
                                                      (1/expected_on_period_balancing) * snapshot_weight * nu.generators.loc[gen, 'start_up_cost']/nu.generators.loc[gen, 'p_nom']

        #if active generation in previous snapshot -> only marginal cost [€/MWh] applied
        else:
            nu.generators.loc[gen, 'marginal_cost'] = generator_settings.loc[nu.generators.carrier[gen]]['marginal_cost [€/MWh]']

        #simplification of start-up cost implementation: possible misconception if e.g. generation in snapshot t = 100MW, in snapshot t+1 = 1000MW -> start-up cost only applied to 100MW (so far not too common)


    #balancing dispatch optimization for each snapshot separately
    nu.lopf(nu.snapshots[i], solver_name='gurobi')
    print("At snapshot: ", i)


    #adjusting released ramping constraints (in case of start-up/shut-down)
    if startup == True:
        for gen in generators_conventional.index:
            carrier = nu.generators.loc[gen, 'carrier']
            nu.generators.loc[gen, 'ramp_limit_up'] = generator_settings.loc[carrier]['ramp_limit_up [p.u] per 15min'] * 4 * snapshot_weight
        startup = False

    if down == True:
        for gen in generators_conventional.index:
            carrier = nu.generators.loc[gen, 'carrier']
            nu.generators.loc[gen, 'ramp_limit_down'] = generator_settings.loc[carrier]['ramp_limit_down [p.u.] per 15min'] * 4 * snapshot_weight
        down = False