% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfq_transformer.R
\name{lfq_transformer}
\alias{lfq_transformer}
\title{Run Pairwise Protein Quantification on each level of LFQ Maxquant output}
\usage{
lfq_transformer(
  ma_tables,
  output_folder,
  imputeStDev = 0.3,
  imputePosition = 1.8,
  protein_only = FALSE
)
}
\arguments{
\item{output_folder}{An output folder to store produced files.}

\item{imputePosition}{The Position parameter for MNAR Imputation}

\item{protein_only}{Boolean, TRUE means LFQ will only process protein level data}

\item{mq_folder}{A maxquant txt output folder.}

\item{imputStDev}{The Standard Deviation parameter for MNAR Imputation}
}
\value{
A string describing the type of experiment
}
\description{
Run Pairwise Protein Quantification on each level of LFQ Maxquant output
}
\examples{
\dontrun{
tmp =  lfq_transformer(mq_folder = upload_folder,
 output_folder = output_folder,
 imputeStDev=0.3,
 imputePosition=1.8)
# get each of the produced quantification files.
prot = tmp[[1]]
prot_int = tmp[[2]]
pept = tmp[[3]]
pept_int = tmp[[4]]
mod_pept = tmp[[5]]
mod_pept_int = tmp[[6]]
expdes = tmp[[7]]
evidence = tmp[[8]]
msms = tmp[[9]]
}
}
