% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantitative_analysis.R
\name{lfq_quant_analysis}
\alias{lfq_quant_analysis}
\title{Run Pairwise Protein Quantification on a level of LFQ Maxquant output}
\usage{
lfq_quant_analysis(
  dt,
  des,
  id_var,
  output_folder,
  quant_fn,
  dt_int_fn,
  conditions_dict = conditions_dict,
  imputeStDev = imputeStDev,
  imputePosition = imputePosition
)
}
\arguments{
\item{dt}{A maxquant txt output text file (eg: proteinGroups.txt)}

\item{des}{An experiment design file.}

\item{id_var}{A column in dt identifying the unit (eg: majority.protein.id)}

\item{output_folder}{An output folder to store produced files}

\item{quant_fn}{A quantitative results file name}

\item{dt_int_fn}{An intensity results file name}

\item{conditions_dict}{A table with original and R-safe condition names}

\item{imputePosition}{The Position parameter for MNAR Imputation}

\item{imputStDev}{The Standard Deviation parameter for MNAR Imputation}
}
\value{
a list containing the quantitative results first and intentisty results second.
}
\description{
Run Pairwise Protein Quantification on a level of LFQ Maxquant output
}
\examples{
\dontrun{
#producing results per modified peptide id
mod_pep_list <- lfq_quant_analysis(mod_pept, expdes, id_var = "id", output_folder,
 "modificationSpecificPeptides_quant.txt",
 "modificationSpecificPeptides_quant_intensities.txt",
 conditions_dict=conditions_dict,
 imputeStDev = imputeStDev,
 imputePosition = imputePosition)

mod_pept <- mod_pep_list[[1]]
mod_pept_int <- mod_pep_list[[2]]
}
}
