#' HER2 Targetted Therapy processed MaxQuant Data
#' @format List containing the maxquant output.txt folder as data.tables.
#' @details The data can be used to run the LFQProcessing limma lfq pipeline `lfq_transformer`. 
#' @details The raw data has been processed in MaxQuant as described here: https://www.biorxiv.org/content/10.1101/2021.03.03.433806v1
#' @references PRIDE Project PXD002057 https://www.ebi.ac.uk/pride/archive/projects/PXD002057
"example_lfq_her2_targetted_therapy_tables"


#' TMT Data processed with MaxQuant
#' @format a proteinGroups data.table 
#' @details The data can be used to run the LFQProcessing limma tmt pipeline `tmt_transformer`. 
#' @details The processed data was published as part of http://doi.org/10.1021/acs.jproteome.0c00209
#' @details The original raw data was published as part of https://pubs.acs.org/doi/10.1021/pr401278j
#' @references PRIDE Project PXD019880 https://www.ebi.ac.uk/pride/archive/projects/PXD019880
"protein_groups_tmt_PXD019880"

#' TMT Data processed with MaxQuant
#' @format  an experiment desing (des) data.table
#' @details The data can be used to run the LFQProcessing limma tmt pipeline `tmt_transformer`. 
#' @details The processed data was published as part of http://doi.org/10.1021/acs.jproteome.0c00209
#' @details The original raw data was published as part of https://pubs.acs.org/doi/10.1021/pr401278j
#' @references PRIDE Project PXD019880 https://www.ebi.ac.uk/pride/archive/projects/PXD019880
"des_tmt_PXD019880"

