%%====================================================%%%
function [Time,output] = solveswFull(A,B,C,J,swTimes,u)

p=size(A,2);
x0=zeros(size(A{1},1),1);
tspan=linspace(swTimes(1),swTimes(2),20);
rhs = @(t,x) double(A{1})*x+double(B{1})*u(t);
options = odeset('RelTol',10^(-10));
[TI,XI] = ode23(rhs,tspan,x0,options');
Y=double(C{1})*XI';   % the output
x0 = XI(size(XI,1),:)';    % the initial condition
Time= TI';
output= Y;
  for k=2:p
      x0=double(J{k-1}*x0);
      tspan=linspace(swTimes(k),swTimes(k+1),20);     
      rhs = @(t,x) double(A{k})*x+double(B{k})*u(t);
      options = odeset('RelTol',10^(-10));
      [TI,XI] = ode23(rhs,tspan,x0,options');
      Y=double(C{k})*XI';   % the output
      x0 = XI(size(XI,1),:)';    % the initial condition
      Time=[Time TI'];
      output=[output Y];
   end

end


