%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%       Model reduction of switched linear system with known sw signal
%       
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all
clc
close all
%%
swMode  = [0 1 2];                %  mode sequence
swTimes = [0 2 5 6];              % switching times,  [t_0, s_1, s_2, t_f]
[A,B,C,J,u] = getExampleData(swMode);   % set example as swMode

%% ---------   solve full order system ---------------------------%%
tic; [TimesFOM,y] = solveswFull(A,B,C,J,swTimes,u); toc

%% ---------   solve reduced system ---------------------------%%
 r=[2,3,2];                        % choose reduced order
 [Ar,Br,Cr,Jr,sv,P,Q,W,V] = morSLS(A,B,C,J,swTimes,r);

 %  solve reduced system
tic; [TimesROM,yr] = solveswFull(Ar,Br,Cr,Jr, swTimes,u); toc
%%
error=norm(y-yr)
 FOMcompareROM(TimesFOM,TimesROM,y,yr);
%%

  