%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [P,Q] = Gramians(A,B,C,J,swTimes)
%%
p=size(A,2);  % number of Modes
g= (swTimes(1)+swTimes(2))/2;
intPart = @(x) (expm(double(A{1}).*(x-swTimes(1)))*double(B{1}))*(expm(double(A{1}).*(x-swTimes(1)))*double(B{1}))';
P{1} = integral(intPart,swTimes(1), g, 'ArrayValued',true);
fullP{1}=zeros(size(A{1},1));  jump= eye(size(A{1},1));
for i=2:p
    k1=i-1;
    intPart =@(x) (expm(double(A{k1}).*(x-swTimes(k1)))*double(B{k1}))*(expm(double(A{k1}).*(x-swTimes(k1)))*double(B{k1}))';
    part1= expm(double(A{k1}).*(swTimes(i)-swTimes(i-1)))*jump;
    fullP{i} =double(part1*fullP{i-1}*part1') + integral(intPart,swTimes(i-1), swTimes(i), 'ArrayValued',true);
  
   g= (swTimes(i)+swTimes(i+1))/2;
   intPart =@(x) (expm(double(A{i}).*(x-swTimes(i)))*double(B{i}))*(expm(double(A{i}).*(x-swTimes(i)))*double(B{i}))';
   part1= expm(double(A{i}).*(g-swTimes(i)))*J{i-1};
   P{i} = double(part1*fullP{i}*part1')+ integral(intPart,swTimes(i), g, 'ArrayValued',true);    % half gramian
   jump=J{i-1};
end

gm= (swTimes(p)+swTimes(p+1))/2;
intPart = @(x) (double(C{p})*expm(double(A{p}).*(swTimes(p+1)-x)))'*double(C{p})*expm(double(A{p}).*(swTimes(p+1)-x));
Q{p} = integral(intPart,gm, swTimes(p+1),'ArrayValued',true);
fullQ{p+1}=zeros(size(A{p},1));  jump= eye(size(A{p},1));

for i=p:-1:2
    intPart = @(x) (double(C{i})*expm(double(A{i}).*(swTimes(i+1)-x)))'*double(C{i})*expm(double(A{i}).*(swTimes(i+1)-x));
    part1 =jump*expm(double(A{i}).*(swTimes(i+1)-swTimes(i)));
    fullQ{i} = part1'*fullQ{i+1}*part1 + integral(intPart,swTimes(i),swTimes(i+1),'ArrayValued',true);
    
    gm= (swTimes(i-1)+swTimes(i))/2;
    intPart = @(x) (double(C{i-1})*expm(double(A{i-1}).*(swTimes(i)-x)))'*double(C{i-1})*expm(double(A{i-1}).*(swTimes(i)-x));
    part1 =J{i-1}*expm(double(A{i-1}).*(swTimes(i)-gm));
    Q{i-1} = double(part1'*fullQ{i}*part1) + integral(intPart,gm, swTimes(i),'ArrayValued',true);   
    jump=J{i-1};


end
end












