%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function FOMcompareROM(TimesFOM,TimesROM,outputFOM,outputROM)
%% compute output and absolute error of full and reduced systems

% figure(20)
% plot(TimesFOM,outputFOM,'r--','LineWidth',1.5)
% hold on
% plot(TimesROM,outputROM,'b-','LineWidth',1) 
%  xlabel('Time(sec)')
%  ylabel('Output')
% legend('Original','Reduced')
% grid on
% hold off

 figure('InvertHardcopy','off','Color',[1 1 1]);
plot(TimesFOM,outputFOM,'r--','LineWidth',1.5)
hold on
plot(TimesROM,outputROM,'b-','LineWidth',1) 
 xlabel('Time(sec)')
 ylabel('Output')
legend('Original','Reduced')
grid on
hold off

% 
% figure(21)
% err=abs(outputFOM-outputROM);             
% plot(TimesROM,err,'m-.','LineWidth',1)
%  xlabel('Time(sec)')
%  ylabel('$|y-\widehat{y}|$','FontSize',11,'Interpreter','latex')
% title('absolute model reduction error')


% 
figure(22)
Relerr=abs(outputFOM-outputROM)/abs(max(outputFOM));             
plot(TimesROM,Relerr,'m-.','LineWidth',1)
 xlabel('Time(sec)')
 ylabel('$|\frac{y-\widehat{y}}{\max y}|$','FontSize',11,'Interpreter','latex')


% 
%  figure('InvertHardcopy','off','Color',[1 1 1]);
% subplot(2,1,1)
% plot(TimesROM,err,'m-.','LineWidth',1)
%  xlabel('Time(sec)')
%  ylabel('$|y-\widehat{y}|$','FontSize',11,'Interpreter','latex')
% hold off
% grid on
% %
% subplot(2,1,2)
% plot(TimesROM,Relerr,'m-.','LineWidth',1)
%  xlabel('Time(sec)')
%  ylabel('$|\frac{y-\widehat{y}}{\max y}|$','FontSize',11,'Interpreter','latex')
% grid on




end