#!/usr/bin/env python3

__copyright__ = "Copyright (C) 2021 Davide Rossi"
__license__ = "GPL-3.0-or-later"

import csv
import sys
from itertools import permutations
from statistics import variance, mean
from collections import defaultdict
from math import factorial
import logging

def main():
    zones = ["Africa", "Australia and New Zealand", "Central and South America", "Central and South Asia",
             "China", "East Asia", "Europe", "North America", "Pacific", "Russia", "Southeast Asia",
             "West Asia"]
    years = set()
    commits = {}
    ratios = {}

    csv_reader = csv.reader(sys.stdin, delimiter='\t')
    for csv_record in csv_reader:
        year, zone, cnt = csv_record
        if zone in zones:
            years.add(year)
            commits[(year, zone)] = int(cnt)

    years = sorted(years)
    for year in years:
        total = 0
        for zone in zones:
            if (year, zone) in commits:
                total += commits[(year, zone)]
        for zone in zones:
            cnt = 0
            if (year, zone) in commits:
                cnt = float(commits[(year, zone)]) / total
            ratios[(year, zone)] = cnt
    #organize the zones in order to "flatten" the bars
    bars = [0] * len(years)
    zones_left = zones.copy()
    flattest_zones = []
    while len(zones_left) > 0:
        zones_var = {}
        for zone in zones_left:
            pos = 0
            new_bars = []
            for year in years:
                new_bars.append(bars[pos] + ratios[(year, zone)])
                pos += 1
            zones_var[zone] = variance(new_bars)
        selected_zone = min(zones_var, key=zones_var.get)
        pos = 0
        for year in years:
            bars[pos] += ratios[(year, selected_zone)]
            pos += 1
        flattest_zones.append(selected_zone)
        zones_left.remove(selected_zone)

    for zone in flattest_zones:
        print(f"\t{zone}", end='')
    print()
    for year in years:
        print(f"{year}", end='')
        for zone in flattest_zones:
            print(f"\t{ratios[(year, zone)]:.10f}", end='')
        print()

if __name__ == "__main__":
    main() #pylint: disable=no-value-for-parameter
