\t on
\timing on
\a
\f '\t'
\set FETCH_COUNT 1000

\set pct 100
\set seed 1

\set start_year 1971
\set end_year 2020

\o commit_zones_7120.tab

select extract(year from c.author_date) as year,
case when c.author_tz = 0 then 
          coalesce(c_c.zone, 'unknown') 
     else case when coalesce(c_c.zone, '') <> '' then
          c_c.zone
     else coalesce(cc.zone, 'unknown') 
     end
end as zone_,
count(*) as cnt
from commit c tablesample bernoulli(:pct) repeatable (:seed)
join person p on p.id = c.author and extract(year from c.author_date) between :start_year and :end_year
left join commit_zone cc on cc.commit = c.id
left join country_by_email ce on ce.person = p.id
left join country_zone c_c on c_c.country = ce.country
group by year, zone_
order by year, zone_;
