\t on
\timing on
\a
\f '\t'
\set FETCH_COUNT 1000

\set start_year 1971
\set end_year 2020
\set pct 100
\set seed 1
\set threshold 5

\o author_zones_7120_t5.tab

select year, zone, count(*)
from(
select pid, year, zone
from (
select c.id as cid, p.id as pid, extract(year from author_date) as year, cc.zone as zone
from commit c tablesample bernoulli(:pct) repeatable (:seed)
join person p on p.id = c.author
join country_by_email ce on ce.person = p.id
join country_zone cc on cc.country = ce.country
where extract(year from author_date) between :start_year and :end_year
and c.author_tz = 0
union
select c.id as cid, p.id as pid, extract(year from author_date) as year, cc.zone as zone
from commit c tablesample bernoulli(:pct) repeatable (:seed)
join commit_zone cc on cc.commit = c.id
join person p on p.id = c.author
where extract(year from c.author_date) between :start_year and :end_year
and c.author_tz <> 0) as inside
group by pid, year, zone
having count(cid) >= :threshold) as inside2
group by year, zone
order by year, zone;
