#!/bin/bash

# SPDX-FileCopyrightText: 2021-2022 Davide Rossi <daviderossi@unibo.it>
# SPDX-FileCopyrightText: 2020-2021 Stefano Zacchiroli <zack@upsilon.cc>
# SPDX-License-Identifier: GPL-3.0-or-later

DB="zones-commit"
psql="psql ${DB}"
logfile="import_data.log"

info () {
    echo "I: $1" >> "$logfile"
}

touch "$logfile"
truncate --size 0 "$logfile"
info "starting data import at $(date)"
info "creating DB schema"
$psql -f schema.sql          >> import_data.log 2>&1
info "importing data"
$psql -f import_data.sql     >> import_data.log 2>&1
info "creating DB indexes"
$psql -f schema_indexes.sql  >> import_data.log 2>&1
info "data import completed at $(date)"
