#!/bin/bash

# SPDX-FileCopyrightText: 2021 Davide Rossi <daviderossi@unibo.it>
# SPDX-License-Identifier: GPL-3.0-or-later

DB="zones-commit"
psql="psql ${DB}"
logfile="${0##*/}";logfile="${logfile%.*}.log"

touch "$logfile"
truncate --size 0 "$logfile"

$psql -f query_commit_zones.sql >> "$logfile" 2>&1 #creates commit_zones_7120.tab
cat commit_zones_7120.tab | ./tab_to_grid.py > commit_zones_7120.grid

$psql -f query_author_zones.sql >> "$logfile" 2>&1 #creates author_zones_7120_t5.tab
cat author_zones_7120_t5.tab | ./tab_to_grid.py > author_zones_7120_t5.grid
