#!/usr/bin/env python3

__copyright__ = "Copyright (C) 2021 Davide Rossi"
__license__ = "GPL-3.0-or-later"

import sys
import matplotlib.pyplot as plt
import matplotlib.ticker as tck
import numpy as np
import pandas as pd
from pandas import DataFrame, Series
import click

@click.command(help = f'A script to create (multiple) stacked chart(s) from a matrix tabbed input(s)')
@click.option('--file', '-f', multiple=True)
@click.option('-w', default=25, help="chart width")
@click.option('-h', default=10, help="chart height")
@click.option('-s', "--start_year", type=int, help="start year")
@click.option('-e', "--end_year", type=int, help="end year")
@click.option("-o", "--output", type=str, help="output filename")

def main(file, w, h, output, start_year, end_year):
    #colors = [ '#E53935', '#1E88E5', '#7CB342', '#757575', '#D81B60', '#C0CA33', '#6D4C41', '#8E24AA', '#00ACC1', '#F4511E', '#00897B', '#FFB300', '#3949AB', '#FDD835' ]
    colors = [ '#546E7A', '#3949AB', '#00897B', '#C0CA33', '#00ACC1', '#8E24AA', '#6D4C41', '#FDD835', '#FB8C00', '#7CB342', '#1E88E5', '#E53935']
    files = file
    fig, axes = plt.subplots(len(files), squeeze=False, sharex=True)
    i = 0
    for file in files:
        df = pd.read_table(file, index_col=0)
        print(df)
        #fill missing rows with zeros
        if start_year is None:
            start_year = min(df.index)
        if end_year is None:
            end_year = max(df.index)
        for year in range(start_year, end_year+1):
            if not year in df.index:
                df2 = pd.DataFrame(dict.fromkeys(df.columns.values, 0), index=[year])
                df = pd.concat([df, df2])
        df = df.sort_index()
        if i == 0:
            df0 = df
            df.plot.bar(ax=axes[i, 0], figsize=(w,h), color=colors, stacked=True)
            handles, labels = axes[i, 0].get_legend_handles_labels()
            #reverse le order of entries in the legend
            labels = list(reversed(labels))
            handles = list(reversed(handles))
            axes[i, 0].legend(handles, labels, bbox_to_anchor=(1,1, ), fontsize=int(h*1.6))
        else:
            df = df.reindex(columns=df0.columns)
            df.plot.bar(ax=axes[i, 0], figsize=(w,h), color=colors, stacked=True, legend=False)
        i += 1
    plt.tight_layout()
    if output is not None:
        plt.savefig(output)#, bbox_inches='tight')
    else:
        plt.show()

if __name__ == "__main__":
    main() #pylint: disable=no-value-for-parameter
