# READ ME

This file briefly explains how to reproduce the "proof of concept" section of paper *Exemplifying parametric timed specifications over signals with bounded behavior* by Étienne André, Masaki Waga, Natuski Urabe, and Ichiro Hasuo, published in the proceedings of the 14th NASA Formal Methods Symposium (NFM 2022)


## Information about this artifact
Author       : Étienne André
Last modified: 2022/03/22


## What does this package contain?

### A binary of IMITATOR

The exact version used is IMITATOR 3.3-alpha "Cheese Caramel au beurre salé"
Build     : `HEAD/5374eb9`
Build date: 2022-03-24 06:58:47 UTC

Source can be downloaded on [v3.3.0-alpha](https://github.com/imitator-model-checker/imitator/releases/tag/v3.3.0-alpha)

The binary of IMITATOR comes without dependencies, and would run on any Linux/Unix system (64 bits).
On other OS, it is advised to compile from source, or use a virtual machine, or Docker.


### Models

In `models`.


### Expected results

In `results`.

The `.res` are the "official" results; IMITATOR in addition provide .ps export for graphical representation (such graphics contain less information, e.g., no action).


## How to reproduce the figures from the paper?

### OS

We ran all experiments on a Dell XPS 13 running Linux Mint 20 Ulyana 64 bits.

### Command
As of now, the generic command to run exemplification is as follows:

```
imitator [model.imi] [property.imiprop] -no-merge -comparison equality
```
where `[model.imi]` must be replaced with the actual model, and `[property.imiprop]` with the actual property.

For our experiments, please therefore run:

```
imitator-v3.3.0-alpha-amd64 models/exBool.imi models/exBool.imiprop -no-merge -comparison equality
imitator-v3.3.0-alpha-amd64 models/ex-nonparam-2signals-2.imi models/ex-nonparam-2signals-2.imiprop -no-merge -comparison equality
imitator-v3.3.0-alpha-amd64 models/ex-param-actions.imi models/ex-param-actions.imiprop -no-merge -comparison equality
```

This will generate 3 `.res` files, and a number of graphical `.ps` files, corresponding to the paper figures.
Total execution time was around 3 seconds for all experiments on our device.
