# Replication Package README

This is the replication package for the paper: "Understanding Code Snippets in Code Reviews: A Preliminary Study of the OpenStack Community", including dataset and so on (see the description below).

## File Organization

- **Data of Code Snippets in Code Review.xlsx** is the dataset of our paper, which contains 10,790 review comments collected from the Nova project and Neutron project of OpenStack community. Among all the review comments, 626 review comments contain code snippets. For the rows of review comments with code snippets, we filled them with blue color as an indicator.
- **Examples for Each Purpose.xlsx** contains six review comment examples for the six detailed purposes mentioned in our paper (see Section 4.2).
- **README.md** 



## How To Read Dataset

The dataset excel file contains 2 sheets for Nova and Neutron respectively.  Each sheet has 13 columns for 13 data items. We listed them with descriptions and sources in a table below. 

| Data Item |                         Description                          |  Source  |
| :-------: | :----------------------------------------------------------: | :------: |
|  Author   | The author of the message as an [AccountInfo](https://review.opendev.org/Documentation/rest-api-accounts.html#account-info) entity. |  Gerrit  |
| Change_id | The code change id of the review comment, which consists of community, project, branch  and commit information, which could be used to locate the code change. |  Gerrit  |
|  Updated  |       The timestamp of when this comment was written.        |  Gerrit  |
| Patch_set | The specific patchset number of the review comment within the code change. |  Gerrit  |
|   Line    | The line number in the file at which the review comment is added. |  Gerrit  |
|   File    | The related file of the review comment within the code change. |  Gerrit  |
|  Message  |                     The comment message.                     |  Gerrit  |
|   Label   | Whether the review comment contains the code snippets (i.e., Yes or No). | Manually |
| Reviewer  | Whether the review comment is provided by reviewer (i.e., Yes or No). | Manually |
|  Purpose  | The high-level purpose behind the code snippets provided by reviewer. | Manually |
|  Detail   | The detailed purpose behind the code snippets provided by reviewer. | Manually |
| Accepted  | Whether the developer accepted the code snippets with suggestion purpose (i.e., Yes or No). | Manually |
| Evidence  | The url which could be used to prove the code snippets were accepted by the developer. | Manually |