# Experimental Information

## Structure

All experiments were conducted inside a compartment with a 3.7 m by 3.7 m footprint and 2.4 m ceiling height. A single ventilation opening was present at the front of the compartment in the form of a 0.9 m by 2.0 m doorway. The door was either open or closed for the entire duration of each experiment. A dimensioned floor plan view and image of the compartment are presented below.

<img src="_images_for_README/compartment_floor_plan+image.png" alt="compartment_floor_plan+image" width="750"/>

## Instrumentation

Various types of instrumentation were installed throughout the compartment to measure gas temperature, oxygen concentration, pressure, radiative and total heat flux, and gas velocity. A dimensioned schematic of the sensor group locations is presented below.

<img src="_images_for_README/instrumentation.png" alt="instrumentation" width="750"/>

With respect to the labeling of sensor groups, the compartment was divided into the labeled quadrants displayed below.

<img src="_images_for_README/quadrants.jpg" alt="quadrants" width="250"/>

A vertical array of type K, bare-bead thermocouples was installed in the center of each quadrant. Each array contained a total of eight thermocouples that were positioned 25 mm below the ceiling and at 0.3 m increments below the ceiling.

To measure oxygen concentration, gas sampling probes were positioned 0.6 m and 1.8 m below the ceiling alongside the thermocouple array in each quadrant.

Three pressure taps were positioned 0.3 m, 1.2 m, and 2.1 m below the ceiling in the back right corner of the compartment.

Total and radiative heat flux to the right side wall were measured by gauges centered along the wall and positioned 0.65 m and 1.3 m below the ceiling. Additionally, a pair of gauges at identical heights were used to measure the total heat flux from the fire plume during experiments in which the fuel load was against a wall (i.e., at the corner, back, or side location). These two gauges were flush with the interior side of the wall adjacent to the fuel source and were aligned with the centerline of the fire plume.

Seven bi-directional probes (BDPs) paired with thermocouples were utilized to measure gas velocity through the compartment doorway during open door experiments. The probes were horizontally-centered in the doorway and spaced 25 cm apart between the top of the doorway and the floor. Additionally, during experiments in which the fuel load was against a wall (i.e., at the corner, back, or side location), two BDPs paired with thermocouples located 0.65 m and 1.3 m below the ceiling were positioned over each fuel load to measure the gas velocity and temperature within the fire plume.

Heat release rate data were also collected during most open door experiments with a fire size larger than 100 kW via oxygen consumption calorimetry. The laboratory calorimeter was designed for a maximum fire size of 10 MW. The smoke collection exhaust hood had a diameter of 7.6 m and was positioned approximately 7.6 m above the floor.
