(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    403144,       8296]
NotebookOptionsPosition[    402151,       8261]
NotebookOutlinePosition[    402510,       8277]
CellTagsIndexPosition[    402467,       8274]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mFromQ", "[", "q_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"q", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"q", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", 
       RowBox[{"q", "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"q", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", 
       RowBox[{"q", "[", 
        RowBox[{"[", "4", "]"}], "]"}], ",", 
       RowBox[{"q", "[", 
        RowBox[{"[", "5", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"q", "[", 
        RowBox[{"[", "3", "]"}], "]"}], ",", 
       RowBox[{"q", "[", 
        RowBox[{"[", "5", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"q", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "-", 
        RowBox[{"q", "[", 
         RowBox[{"[", "4", "]"}], "]"}]}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"defectDetector", "[", "q_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "Q", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Q", "=", 
      RowBox[{"mFromQ", "[", "q", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"Tr", "[", 
         RowBox[{"Q", ".", "Q"}], "]"}], ")"}], "^", "3"}], "-", 
      RowBox[{"54", "*", 
       RowBox[{
        RowBox[{"Det", "[", "Q", "]"}], "^", "2"}]}]}]}]}], 
   "\[IndentingNewLine]", "]"}]}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"t1", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
    "\"\</Users/dmsussma/repos/landauDeGUI/data/test_x0y0z0.txt\>\"", ",", 
     "\"\<Data\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t2", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
    "\"\</Users/dmsussma/repos/landauDeGUI/data/test_x1y0z0.txt\>\"", ",", 
     "\"\<Data\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"test", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"t1", ",", "t2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"maxZ", "=", 
  RowBox[{
   RowBox[{"Max", "[", 
    RowBox[{"test", "[", 
     RowBox[{"[", 
      RowBox[{";;", ",", "3"}], "]"}], "]"}], "]"}], "+", 
   "1"}]}], "\[IndentingNewLine]", 
 RowBox[{"maxY", "=", 
  RowBox[{
   RowBox[{"Max", "[", 
    RowBox[{"test", "[", 
     RowBox[{"[", 
      RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}], "+", 
   "1"}]}], "\[IndentingNewLine]", 
 RowBox[{"maxX", "=", 
  RowBox[{
   RowBox[{"Max", "[", 
    RowBox[{"test", "[", 
     RowBox[{"[", 
      RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], "+", 
   "1"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"colloids", "=", 
   RowBox[{
    RowBox[{"Select", "[", 
     RowBox[{"test", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "9", "]"}], "]"}], ">", "0"}], "&"}]}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LC", "=", 
   RowBox[{"Select", "[", 
    RowBox[{"test", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "9", "]"}], "]"}], "\[LessEqual]", "0"}], "&"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Length", "[", "colloids", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eigs", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Max", "[", 
      RowBox[{"Eigenvalues", "[", 
       RowBox[{"mFromQ", "[", 
        RowBox[{"LC", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", 
           RowBox[{"4", ";;", "8"}]}], "]"}], "]"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "LC", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inds", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "eigs", "]"}]}], "}"}]}], "]"}]}], ";", 
  RowBox[{"lowE", "=", 
   RowBox[{"LC", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"Select", "[", 
       RowBox[{"inds", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"eigs", "[", 
           RowBox[{"[", "#", "]"}], "]"}], "<", ".25"}], "&"}]}], "]"}], ",", 
      
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"scale", " ", "=", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"0.25", "+", 
       RowBox[{"0.0375", " ", 
        RowBox[{"x", "/", "2"}]}]}], ")"}], "/.", 
     RowBox[{"x", "->", "maxX"}]}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Just", " ", "something", " ", "that", " ", "looks", " ", "reasonable", 
    " ", "for", " ", 
    RowBox[{"(", 
     RowBox[{"20", "^", "3"}], ")"}], " ", "and", " ", 
    RowBox[{"(", 
     RowBox[{"100", "^", "3"}], ")"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{
   RowBox[{"directors", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Graphics3D", "[", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"LC", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{"LC", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"{", 
               RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], "]"}], "+", 
           
           RowBox[{"scale", "*", 
            RowBox[{
             RowBox[{"Eigensystem", "[", 
              RowBox[{
               RowBox[{"mFromQ", "[", 
                RowBox[{"LC", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", 
                   RowBox[{"4", ";;", "8"}]}], "]"}], "]"}], "]"}], ",", 
               "1"}], "]"}], "[", 
             RowBox[{"[", 
              RowBox[{"2", ",", "1"}], "]"}], "]"}]}]}]}], "}"}], "]"}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "LC", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.762521976949741*^9, 3.7625219781708727`*^9}, {
   3.7625220245762653`*^9, 3.762522133953175*^9}, {3.762522256297463*^9, 
   3.7625222568540707`*^9}, {3.7625223410724373`*^9, 
   3.7625223432429533`*^9}, {3.7625225554082317`*^9, 3.762522555516851*^9}, {
   3.762523000026202*^9, 3.762523003807548*^9}, {3.7625267570546618`*^9, 
   3.762526766705731*^9}, {3.762527450446252*^9, 3.7625274507320766`*^9}, 
   3.762527556747759*^9, 3.7625427050046062`*^9, {3.7634834743756733`*^9, 
   3.7634834771748466`*^9}, {3.76348463595667*^9, 3.763484649649551*^9}}],

Cell[BoxData["28"], "Output",
 CellChangeTimes->{{3.762522125654653*^9, 3.7625221444366827`*^9}, 
   3.762522259927792*^9, {3.7625223445918627`*^9, 3.762522357718587*^9}, 
   3.762522557012878*^9, 3.762522700379319*^9, 3.762522840709778*^9, 
   3.762522898791173*^9, {3.762522972242889*^9, 3.76252300553859*^9}, 
   3.76252312311593*^9, 3.7625232065627823`*^9, 3.762523966315432*^9, 
   3.76252404818896*^9, 3.762525718265522*^9, 3.7625257545389977`*^9, {
   3.762525814745129*^9, 3.762525856694792*^9}, 3.7625258912366*^9, 
   3.762525945919256*^9, 3.7625264374995947`*^9, 3.762526638390891*^9, 
   3.762526767606439*^9, 3.762526801923031*^9, {3.762527452192519*^9, 
   3.7625274796050167`*^9}, 3.762527518671651*^9, {3.762527550794155*^9, 
   3.762527598113101*^9}, 3.762527687646084*^9, {3.762527728621429*^9, 
   3.762527744862341*^9}, 3.762540660702959*^9, 3.762540916677335*^9, 
   3.762541049207767*^9, 3.76254116115058*^9, 3.762541242775*^9, 
   3.762541282071519*^9, 3.7625414379583063`*^9, 3.762541725271796*^9, 
   3.76254178426587*^9, 3.762542283629744*^9, 3.762542450860387*^9, 
   3.762542565019545*^9, 3.762542672359927*^9, 3.76254270619464*^9, 
   3.762596059452726*^9, 3.7625978728975153`*^9, 3.763483250644239*^9, 
   3.763483485365818*^9, 3.7634836729632893`*^9, 3.763483779318405*^9, 
   3.763483833078062*^9, 3.763483877096431*^9, 3.763484007117145*^9, 
   3.763484183640839*^9, 3.76348424131101*^9, {3.763484624789782*^9, 
   3.763484637600459*^9}, 3.763484883126215*^9}],

Cell[BoxData["28"], "Output",
 CellChangeTimes->{{3.762522125654653*^9, 3.7625221444366827`*^9}, 
   3.762522259927792*^9, {3.7625223445918627`*^9, 3.762522357718587*^9}, 
   3.762522557012878*^9, 3.762522700379319*^9, 3.762522840709778*^9, 
   3.762522898791173*^9, {3.762522972242889*^9, 3.76252300553859*^9}, 
   3.76252312311593*^9, 3.7625232065627823`*^9, 3.762523966315432*^9, 
   3.76252404818896*^9, 3.762525718265522*^9, 3.7625257545389977`*^9, {
   3.762525814745129*^9, 3.762525856694792*^9}, 3.7625258912366*^9, 
   3.762525945919256*^9, 3.7625264374995947`*^9, 3.762526638390891*^9, 
   3.762526767606439*^9, 3.762526801923031*^9, {3.762527452192519*^9, 
   3.7625274796050167`*^9}, 3.762527518671651*^9, {3.762527550794155*^9, 
   3.762527598113101*^9}, 3.762527687646084*^9, {3.762527728621429*^9, 
   3.762527744862341*^9}, 3.762540660702959*^9, 3.762540916677335*^9, 
   3.762541049207767*^9, 3.76254116115058*^9, 3.762541242775*^9, 
   3.762541282071519*^9, 3.7625414379583063`*^9, 3.762541725271796*^9, 
   3.76254178426587*^9, 3.762542283629744*^9, 3.762542450860387*^9, 
   3.762542565019545*^9, 3.762542672359927*^9, 3.76254270619464*^9, 
   3.762596059452726*^9, 3.7625978728975153`*^9, 3.763483250644239*^9, 
   3.763483485365818*^9, 3.7634836729632893`*^9, 3.763483779318405*^9, 
   3.763483833078062*^9, 3.763483877096431*^9, 3.763484007117145*^9, 
   3.763484183640839*^9, 3.76348424131101*^9, {3.763484624789782*^9, 
   3.763484637600459*^9}, 3.763484883136204*^9}],

Cell[BoxData["56"], "Output",
 CellChangeTimes->{{3.762522125654653*^9, 3.7625221444366827`*^9}, 
   3.762522259927792*^9, {3.7625223445918627`*^9, 3.762522357718587*^9}, 
   3.762522557012878*^9, 3.762522700379319*^9, 3.762522840709778*^9, 
   3.762522898791173*^9, {3.762522972242889*^9, 3.76252300553859*^9}, 
   3.76252312311593*^9, 3.7625232065627823`*^9, 3.762523966315432*^9, 
   3.76252404818896*^9, 3.762525718265522*^9, 3.7625257545389977`*^9, {
   3.762525814745129*^9, 3.762525856694792*^9}, 3.7625258912366*^9, 
   3.762525945919256*^9, 3.7625264374995947`*^9, 3.762526638390891*^9, 
   3.762526767606439*^9, 3.762526801923031*^9, {3.762527452192519*^9, 
   3.7625274796050167`*^9}, 3.762527518671651*^9, {3.762527550794155*^9, 
   3.762527598113101*^9}, 3.762527687646084*^9, {3.762527728621429*^9, 
   3.762527744862341*^9}, 3.762540660702959*^9, 3.762540916677335*^9, 
   3.762541049207767*^9, 3.76254116115058*^9, 3.762541242775*^9, 
   3.762541282071519*^9, 3.7625414379583063`*^9, 3.762541725271796*^9, 
   3.76254178426587*^9, 3.762542283629744*^9, 3.762542450860387*^9, 
   3.762542565019545*^9, 3.762542672359927*^9, 3.76254270619464*^9, 
   3.762596059452726*^9, 3.7625978728975153`*^9, 3.763483250644239*^9, 
   3.763483485365818*^9, 3.7634836729632893`*^9, 3.763483779318405*^9, 
   3.763483833078062*^9, 3.763483877096431*^9, 3.763484007117145*^9, 
   3.763484183640839*^9, 3.76348424131101*^9, {3.763484624789782*^9, 
   3.763484637600459*^9}, 3.7634848831437263`*^9}],

Cell[BoxData["2053"], "Output",
 CellChangeTimes->{{3.762522125654653*^9, 3.7625221444366827`*^9}, 
   3.762522259927792*^9, {3.7625223445918627`*^9, 3.762522357718587*^9}, 
   3.762522557012878*^9, 3.762522700379319*^9, 3.762522840709778*^9, 
   3.762522898791173*^9, {3.762522972242889*^9, 3.76252300553859*^9}, 
   3.76252312311593*^9, 3.7625232065627823`*^9, 3.762523966315432*^9, 
   3.76252404818896*^9, 3.762525718265522*^9, 3.7625257545389977`*^9, {
   3.762525814745129*^9, 3.762525856694792*^9}, 3.7625258912366*^9, 
   3.762525945919256*^9, 3.7625264374995947`*^9, 3.762526638390891*^9, 
   3.762526767606439*^9, 3.762526801923031*^9, {3.762527452192519*^9, 
   3.7625274796050167`*^9}, 3.762527518671651*^9, {3.762527550794155*^9, 
   3.762527598113101*^9}, 3.762527687646084*^9, {3.762527728621429*^9, 
   3.762527744862341*^9}, 3.762540660702959*^9, 3.762540916677335*^9, 
   3.762541049207767*^9, 3.76254116115058*^9, 3.762541242775*^9, 
   3.762541282071519*^9, 3.7625414379583063`*^9, 3.762541725271796*^9, 
   3.76254178426587*^9, 3.762542283629744*^9, 3.762542450860387*^9, 
   3.762542565019545*^9, 3.762542672359927*^9, 3.76254270619464*^9, 
   3.762596059452726*^9, 3.7625978728975153`*^9, 3.763483250644239*^9, 
   3.763483485365818*^9, 3.7634836729632893`*^9, 3.763483779318405*^9, 
   3.763483833078062*^9, 3.763483877096431*^9, 3.763484007117145*^9, 
   3.763484183640839*^9, 3.76348424131101*^9, {3.763484624789782*^9, 
   3.763484637600459*^9}, 3.763484883242552*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.2576389999999999513846660192939452827`6.120155909867905", ",", "Null"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.762522125654653*^9, 3.7625221444366827`*^9}, 
   3.762522259927792*^9, {3.7625223445918627`*^9, 3.762522357718587*^9}, 
   3.762522557012878*^9, 3.762522700379319*^9, 3.762522840709778*^9, 
   3.762522898791173*^9, {3.762522972242889*^9, 3.76252300553859*^9}, 
   3.76252312311593*^9, 3.7625232065627823`*^9, 3.762523966315432*^9, 
   3.76252404818896*^9, 3.762525718265522*^9, 3.7625257545389977`*^9, {
   3.762525814745129*^9, 3.762525856694792*^9}, 3.7625258912366*^9, 
   3.762525945919256*^9, 3.7625264374995947`*^9, 3.762526638390891*^9, 
   3.762526767606439*^9, 3.762526801923031*^9, {3.762527452192519*^9, 
   3.7625274796050167`*^9}, 3.762527518671651*^9, {3.762527550794155*^9, 
   3.762527598113101*^9}, 3.762527687646084*^9, {3.762527728621429*^9, 
   3.762527744862341*^9}, 3.762540660702959*^9, 3.762540916677335*^9, 
   3.762541049207767*^9, 3.76254116115058*^9, 3.762541242775*^9, 
   3.762541282071519*^9, 3.7625414379583063`*^9, 3.762541725271796*^9, 
   3.76254178426587*^9, 3.762542283629744*^9, 3.762542450860387*^9, 
   3.762542565019545*^9, 3.762542672359927*^9, 3.76254270619464*^9, 
   3.762596059452726*^9, 3.7625978728975153`*^9, 3.763483250644239*^9, 
   3.763483485365818*^9, 3.7634836729632893`*^9, 3.763483779318405*^9, 
   3.763483833078062*^9, 3.763483877096431*^9, 3.763484007117145*^9, 
   3.763484183640839*^9, 3.76348424131101*^9, {3.763484624789782*^9, 
   3.763484637600459*^9}, 3.7634848851307087`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "lowE", "]"}]], "Input",
 CellChangeTimes->{{3.763483883525111*^9, 3.7634838881273117`*^9}}],

Cell[BoxData["104"], "Output",
 CellChangeTimes->{
  3.7634838884370613`*^9, 3.76348400950027*^9, 3.7634841860156116`*^9, 
   3.7634842437557077`*^9, {3.763484626797963*^9, 3.763484639613097*^9}, 
   3.763484885321162*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPointPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "maxX"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "maxY"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "maxZ"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"directors", "[", 
    RowBox[{"[", 
     RowBox[{";;", ";;", "111"}], "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.762522229106344*^9, {3.762522399838183*^9, 3.762522467628621*^9}, {
   3.762522574544939*^9, 3.762522582521708*^9}, {3.762522712702573*^9, 
   3.762522713588011*^9}, 3.762522855641254*^9, 3.762525860912611*^9, {
   3.762540673506947*^9, 3.7625406770254993`*^9}, {3.7634832668841057`*^9, 
   3.7634832801681957`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.763491004858492*^9, 3.7634910048766727`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"lowE", "=", 
   RowBox[{"LC", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"Select", "[", 
       RowBox[{"inds", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"eigs", "[", 
           RowBox[{"[", "#", "]"}], "]"}], "<", ".15"}], "&"}]}], "]"}], ",", 
      
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{3.763484657673913*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPointPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "maxX"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "maxY"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "maxZ"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"directors", "[", 
    RowBox[{"[", 
     RowBox[{";;", ";;", "11"}], "]"}], "]"}], ",", 
   RowBox[{"ListPointPlot3D", "[", 
    RowBox[{
     RowBox[{"{", "lowE", "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", 
         RowBox[{"PointSize", "[", "Large", "]"}]}], "}"}], "}"}]}]}], "]"}], 
   ",", 
   RowBox[{"ListPointPlot3D", "[", 
    RowBox[{
     RowBox[{"{", "colloids", "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Black", ",", 
         RowBox[{"PointSize", "[", "Large", "]"}]}], "}"}], "}"}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7625221561539373`*^9, 3.762522227528925*^9}, {
   3.762540942043007*^9, 3.762540980117207*^9}, {3.76254107562857*^9, 
   3.762541076766193*^9}, {3.762541150584153*^9, 3.76254115072899*^9}, {
   3.76254130321019*^9, 3.7625413257165003`*^9}, 3.762542295171218*^9, 
   3.762542465559394*^9, 3.762542575872443*^9, {3.762542684380315*^9, 
   3.762542690226201*^9}, 3.763483293032517*^9, 3.763484666372364*^9}],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[0.3315753, 0.4561011, 0.6388182], Point3DBox[{{0., 0., 0.}}]}, 
   Line3DBox[{{0, 1, 0}, {-0.07510448075940698, -0.2917524825698834, 
     0.12543859352050443`}}], 
   Line3DBox[{{11, 1, 0}, {11.087099603695123`, -0.2949369919836442, 
     0.07451070948866355}}], 
   Line3DBox[{{22, 1, 0}, {22.049288740669823`, -0.29686313903416317`, 
     0.0756083239970316}}], 
   Line3DBox[{{5, 2, 0}, {4.966096385453225, 0.7100658305541929, 
     0.15786191249576356`}}], 
   Line3DBox[{{16, 2, 0}, {16.02587072048422, 0.7086758002336078, 
     0.14769061215701468`}}], 
   Line3DBox[{{27, 2, 0}, {26.994895174113026`, 0.7006672555962525, 
     0.041332312697080834`}}], 
   Line3DBox[{{10, 3, 0}, {10.003956204650125`, 1.708242428476183, 
     0.14610518421896004`}}], 
   Line3DBox[{{21, 3, 0}, {21.080743955803374`, 1.7082512208335354`, 
     0.12192417776294903`}}], 
   Line3DBox[{{4, 4, 0}, {3.958816910906368, 2.715465386536382, 
     0.19563941317275368`}}], 
   Line3DBox[{{15, 4, 0}, {15.022531132983977`, 2.718834612409178, 
     0.2193344425431599}}], 
   Line3DBox[{{26, 4, 0}, {26.040344053104988`, 2.702714501078196, 
     0.07363892765562086}}], 
   Line3DBox[{{9, 5, 0}, {8.96020776532694, 3.712068995392607, 
     0.1721926404661805}}], 
   Line3DBox[{{20, 5, 0}, {19.99934081948568, 3.711040800945373, 
     0.16906729031217976`}}], 
   Line3DBox[{{3, 6, 0}, {2.9815613101244933`, 4.717103770278488, 
     0.2093735381608812}}], 
   Line3DBox[{{14, 6, 0}, {14.000030715274317`, 4.720121731381481, 
     0.2278412091230082}}], 
   Line3DBox[{{25, 6, 0}, {24.99078664413559, 4.706390986278128, 
     0.12841664102149297`}}], 
   Line3DBox[{{8, 7, 0}, {7.9788203292572994`, 5.714162993052209, 
     0.19019624893982132`}}], 
   Line3DBox[{{19, 7, 0}, {18.895873559645608`, 5.710371920554885, 
     0.1265586864890244}}], 
   Line3DBox[{{2, 8, 0}, {1.947943641224818, 6.717602633259631, 
     0.20675378905460182`}}], 
   Line3DBox[{{13, 8, 0}, {13.034433879169505`, 6.719387507002043, 
     0.22101120049196302`}}], 
   Line3DBox[{{24, 8, 0}, {23.95719145330142, 6.711202055427115, 
     0.16482501750117073`}}], 
   Line3DBox[{{7, 9, 0}, {6.9811932419524165`, 7.7210806317013, 
     0.2324038623650489}}], 
   Line3DBox[{{18, 9, 0}, {17.91155785985187, 7.7183235576590565`, 
     0.198704516793858}}], 
   Line3DBox[{{1, 10, 0}, {0.8964772913578212, 8.721281214801781, 
     0.2101459425651115}}], 
   Line3DBox[{{12, 10, 0}, {11.998533593895592`, 8.715148815807003, 
     0.19787694188811633`}}], 
   Line3DBox[{{23, 10, 0}, {22.974571521066963`, 8.715326826680801, 
     0.1974037239089803}}], 
   Line3DBox[{{6, 11, 0}, {5.986236822510099, 9.724565639700113, 
     0.2511528767738925}}], 
   Line3DBox[{{17, 11, 0}, {16.899166873502242`, 9.724301363701052, 
     0.22896652581914903`}}], 
   Line3DBox[{{0, 12, 0}, {-0.1266851422150978, 10.723092624136232`, 
     0.20846685157752057`}}], 
   Line3DBox[{{11, 12, 0}, {11.032667139137182`, 10.720281039628881`, 
     0.2263895768078922}}], 
   Line3DBox[{{22, 12, 0}, {21.966118897528602`, 10.719777511786056`, 
     0.22334379679458535`}}], 
   Line3DBox[{{5, 13, 0}, {4.925896072111438, 11.73324866869192, 
     0.28257684353232765`}}], 
   Line3DBox[{{16, 13, 0}, {15.928355098413935`, 11.730778326918243`, 
     0.2719252703524757}}], 
   Line3DBox[{{27, 13, 0}, {26.887046669275897`, 11.728485816005488`, 
     0.2459537049509534}}], 
   Line3DBox[{{10, 14, 0}, {10.013269777247473`, 12.726337011704329`, 
     0.26001250980970847`}}], 
   Line3DBox[{{21, 14, 0}, {20.994205254020823`, 12.7204829828747, 
     0.2297882151151584}}], 
   Line3DBox[{{4, 15, 0}, {3.8409619532651194`, 13.734261393958498`, 
     0.2502252602493813}}], 
   Line3DBox[{{15, 15, 0}, {14.921619053793684`, 13.738922854745532`, 
     0.30584450459120904`}}], 
   Line3DBox[{{26, 15, 0}, {25.91039716554886, 13.725357930231796`, 
     0.23928837421686908`}}], 
   Line3DBox[{{9, 16, 0}, {8.969033296745211, 14.731072880748338`, 
     0.28082918174080057`}}], 
   Line3DBox[{{20, 16, 0}, {19.979516472228077`, 14.722562937818953`, 
     0.24028103807057793`}}], 
   Line3DBox[{{3, 17, 0}, {2.862158764337453, 15.731438638279606`, 
     0.2484992259567805}}], 
   Line3DBox[{{14, 17, 0}, {13.971915768660113`, 15.733016203724867`, 
     0.28976427648401054`}}], 
   Line3DBox[{{25, 17, 0}, {24.920473242299533`, 15.719952563341211`, 
     0.2124948345558458}}], 
   Line3DBox[{{8, 18, 0}, {7.98716602817846, 16.720031063186198`, 
     0.22696874225107166`}}], 
   Line3DBox[{{19, 18, 0}, {18.991169526072287`, 16.723655629617845`, 
     0.24671252688906722`}}], 
   Line3DBox[{{2, 19, 0}, {1.8865272713270111`, 17.730554800409767`, 
     0.25618904169542356`}}], 
   Line3DBox[{{13, 19, 0}, {13.01374511160536, 17.724069775052744`, 
     0.24862247077246188`}}], 
   Line3DBox[{{24, 19, 0}, {23.970326645248797`, 17.719107488405854`, 
     0.22007695417706033`}}], 
   Line3DBox[{{7, 20, 0}, {6.99784544838202, 18.720447256871484`, 
     0.22965220543164835`}}], 
   Line3DBox[{{18, 20, 0}, {18.01465870526672, 18.72708815598252, 
     0.2635916533578576}}], 
   Line3DBox[{{1, 21, 0}, {0.8667064398536456, 19.72896517783837, 
     0.23812456336140597`}}], 
   Line3DBox[{{12, 21, 0}, {11.979868055135745`, 19.7116820848674, 
     0.1727184250286436}}], 
   Line3DBox[{{23, 21, 0}, {22.987324325877115`, 19.726192167510465`, 
     0.2593317049144728}}], 
   Line3DBox[{{6, 22, 0}, {6.01044097307008, 20.71864567063122, 
     0.21913938187653445`}}], 
   Line3DBox[{{17, 22, 0}, {17.00220368937815, 20.720239840718275`, 
     0.2284930600003904}}], 
   Line3DBox[{{0, 23, 0}, {-0.09603529268564054, 21.71295762037423, 
     0.15588180011156216`}}], 
   Line3DBox[{{11, 23, 0}, {10.9676784126926, 21.708577446234127`, 
     0.14554416037327825`}}], 
   Line3DBox[{{22, 23, 0}, {22.04959698227333, 21.72599659728362, 
     0.25388081695248227`}}], 
   Line3DBox[{{5, 24, 0}, {4.996248328472696, 22.71604223473443, 
     0.20356419620108926`}}], 
   Line3DBox[{{16, 24, 0}, {15.987238538297634`, 22.721251351583824`, 
     0.233749950308072}}], 
   Line3DBox[{{27, 24, 0}, {27.063063450169174`, 22.719070880122718`, 
     0.21270540920055517`}}], 
   Line3DBox[{{10, 25, 0}, {9.957558803805385, 23.712530133020834`, 
     0.17498596082607015`}}], 
   Line3DBox[{{21, 25, 0}, {21.015225616943457`, 23.71332466866793, 
     0.1850264098181746}}], 
   Line3DBox[{{4, 26, 0}, {4.007884126630949, 24.70717286081569, 
     0.13614635043134313`}}], 
   Line3DBox[{{15, 26, 0}, {14.961396257496885`, 24.709777867239403`, 
     0.15439105932484767`}}], 
   Line3DBox[{{26, 26, 0}, {26.03153177066821, 24.71326382044372, 
     0.18252603008733342`}}], 
   Line3DBox[{{9, 27, 0}, {9.010557980270297, 25.71046977815552, 
     0.1643177896709304}}], 
   Line3DBox[{{20, 27, 0}, {19.994704763337783`, 25.702278984335454`, 
     0.07676018480483698}}], 
   Line3DBox[{{3, 1, 1}, {2.9431760532077194`, -0.2922669649748886, 
     1.1296808787197932`}}], 
   Line3DBox[{{14, 1, 1}, {14.03233810750447, -0.29722598531142475`, 
     1.0784792318759162`}}], 
   Line3DBox[{{25, 1, 1}, {25.028908536912624`, -0.29815156863034153`, 
     1.0629825480284496`}}], 
   Line3DBox[{{8, 2, 1}, {8.007447085458136, 0.7071804100810661, 
     1.1362426102216892`}}], 
   Line3DBox[{{19, 2, 1}, {19.055865087931362`, 0.7103868489046778, 
     1.154197965201927}}], 
   Line3DBox[{{2, 3, 1}, {1.9458004130084996`, 1.7133865738084075`, 
     1.1780120678872175`}}], 
   Line3DBox[{{13, 3, 1}, {13.026839565208624`, 1.710955964067299, 
     1.166268190480761}}], 
   Line3DBox[{{24, 3, 1}, {24.081921115271733`, 1.7058958864483706`, 
     1.0926470407589353`}}], 
   Line3DBox[{{7, 4, 1}, {6.94469906200492, 2.711022368147387, 
     1.1596197695791304`}}], 
   Line3DBox[{{18, 4, 1}, {18.046006616512592`, 2.714619007424763, 
     1.188889108112036}}], 
   Line3DBox[{{1, 5, 1}, {0.979727274267702, 3.7191307985374915`, 
     1.2212760839679215`}}], 
   Line3DBox[{{12, 5, 1}, {11.996765631607078`, 3.7168067557846207`, 
     1.2083377950855518`}}], 
   Line3DBox[{{23, 5, 1}, {23.026622813624265`, 3.7075504226410985`, 
     1.1373510676315417`}}], 
   Line3DBox[{{6, 6, 1}, {5.948415898793118, 4.712944741062037, 
     1.1755785890785375`}}], 
   Line3DBox[{{17, 6, 1}, {16.966297357130795`, 4.712280865821656, 
     1.1750530300640512`}}], 
   Line3DBox[{{0, 7, 1}, {-0.09307842011626515, 5.721600784534243, 
     1.216868286305758}}], 
   Line3DBox[{{11, 7, 1}, {10.994683912166, 5.715085794704221, 
     1.197401175881145}}], 
   Line3DBox[{{22, 7, 1}, {21.975223164724593`, 5.70609874831524, 
     1.1233112295062653`}}], 
   Line3DBox[{{5, 8, 1}, {4.959944349248208, 6.717861087362316, 
     1.2109866193461227`}}], 
   Line3DBox[{{16, 8, 1}, {16.00206490123636, 6.71091500564592, 
     1.168094061507317}}], 
   Line3DBox[{{27, 8, 1}, {26.901998179416292`, 6.714649326755547, 
     1.1681347374943953`}}], 
   Line3DBox[{{10, 9, 1}, {9.982366421355335, 7.714899801930403, 
     1.1954649273544107`}}], 
   Line3DBox[{{21, 9, 1}, {20.941166564995356`, 7.713114511020263, 
     1.174540439952858}}], 
   Line3DBox[{{4, 10, 1}, {3.9411443938599544`, 8.720649915225488, 
     1.2231577428935367`}}], 
   Line3DBox[{{15, 10, 1}, {14.993691530556598`, 8.72709029205343, 
     1.2639338527522788`}}], 
   Line3DBox[{{26, 10, 1}, {25.919165393164786`, 8.722446837136655, 
     1.2265473071913655`}}], 
   Line3DBox[{{9, 11, 1}, {8.978977377428112, 9.7224848709483, 
     1.2398189825351977`}}], 
   Line3DBox[{{20, 11, 1}, {19.936096792308327`, 9.719017278161608, 
     1.2121312009069363`}}], 
   Line3DBox[{{3, 12, 1}, {2.898737245581773, 10.721517862312789`, 
     1.212671761600767}}], 
   Line3DBox[{{14, 12, 1}, {13.987450318846529`, 10.727342342954747`, 
     1.264924505221835}}], 
   Line3DBox[{{25, 12, 1}, {24.966781893420677`, 10.724163698470958`, 
     1.2472615803071347`}}], 
   Line3DBox[{{8, 13, 1}, {7.9732833737362725`, 11.731429537616643`, 
     1.2828695880605743`}}], 
   Line3DBox[{{19, 13, 1}, {18.917207089025304`, 11.723303933079022`, 
     1.2306349639600227`}}], 
   Line3DBox[{{2, 14, 1}, {1.8402018664772415`, 12.730574809889418`, 
     1.2302699355872544`}}], 
   Line3DBox[{{13, 14, 1}, {13.007878915434079`, 12.72820464534388, 
     1.2692108812189695`}}], 
   Line3DBox[{{24, 14, 1}, {23.962212977516746`, 12.725348889497639`, 
     1.2526592318260836`}}], 
   Line3DBox[{{7, 15, 1}, {6.912860536360941, 13.731452133753505`, 
     1.2705420945401351`}}], 
   Line3DBox[{{18, 15, 1}, {17.899039425505126`, 13.735315676753048`, 
     1.2835145938590555`}}], 
   Line3DBox[{{1, 16, 1}, {0.8373468359464712, 14.736286301060671`, 
     1.2580147967393636`}}], 
   Line3DBox[{{12, 16, 1}, {12.001018345052772`, 14.73420768427276, 
     1.2962579558749927`}}], 
   Line3DBox[{{23, 16, 1}, {22.990486330558284`, 14.723727753464003`, 
     1.2470599984127575`}}], 
   Line3DBox[{{6, 17, 1}, {5.917186966526174, 15.723552741361239`, 
     1.2320008564649205`}}], 
   Line3DBox[{{17, 17, 1}, {16.980413987841846`, 15.733295580548038`, 
     1.2916784220140571`}}], 
   Line3DBox[{{0, 18, 1}, {-0.10805762169269569`, 16.72978624794486, 
     1.2547166552939206`}}], 
   Line3DBox[{{11, 18, 1}, {11.07773880267758, 16.725523831916387`, 
     1.2442686544466275`}}], 
   Line3DBox[{{22, 18, 1}, {22.007861857935033`, 16.719326489649692`, 
     1.2231894958926848`}}], 
   Line3DBox[{{5, 19, 1}, {4.977613403509869, 17.7223684450636, 
     1.2390741519453445`}}], 
   Line3DBox[{{16, 19, 1}, {16.017538947170245`, 17.72541714169519, 
     1.2552076069549984`}}], 
   Line3DBox[{{27, 19, 1}, {26.86317487766949, 17.726641833920684`, 
     1.2232439624678841`}}], 
   Line3DBox[{{10, 20, 1}, {10.017280669571855`, 18.714259786667032`, 
     1.1912419469615592`}}], 
   Line3DBox[{{21, 20, 1}, {21.048459904753134`, 18.722349007644482`, 
     1.2350735616020694`}}], 
   Line3DBox[{{4, 21, 1}, {3.974595524469536, 19.719047788851363`, 
     1.2202635815935903`}}], 
   Line3DBox[{{15, 21, 1}, {15.007910539086222`, 19.72327943890595, 
     1.2447897715409286`}}], 
   Line3DBox[{{26, 21, 1}, {25.948077324502826`, 19.719925124083794`, 
     1.2207087397846343`}}], 
   Line3DBox[{{9, 22, 1}, {8.972942124134851, 20.711589355068252`, 
     1.1710727371039007`}}], 
   Line3DBox[{{20, 22, 1}, {20.01639070785727, 20.72506570930149, 
     1.2535229754815547`}}], 
   Line3DBox[{{3, 23, 1}, {2.9308086354819767`, 21.714103066108397`, 
     1.1779933439326058`}}], 
   Line3DBox[{{14, 23, 1}, {13.967514680938814`, 21.72027074954529, 
     1.226357570176296}}], 
   Line3DBox[{{25, 23, 1}, {25.024768939933566`, 21.72067810209421, 
     1.2296126763776316`}}], 
   Line3DBox[{{8, 24, 1}, {8.007095454833706, 22.718106872665942`, 
     1.2161010518586473`}}], 
   Line3DBox[{{19, 24, 1}, {18.99853817250616, 22.723069379430015`, 
     1.243815613345675}}], 
   Line3DBox[{{2, 25, 1}, {1.9594496348666475`, 23.706740200967655`, 
     1.1258362431669375`}}], 
   Line3DBox[{{13, 25, 1}, {12.948828883269544`, 23.709392185280315`, 
     1.1473532673442821`}}], 
   Line3DBox[{{24, 25, 1}, {24.062589262122533`, 23.719944333207543`, 
     1.2180368642672084`}}], 
   Line3DBox[{{7, 26, 1}, {7.003177650070878, 24.716144265604875`, 
     1.204216443512216}}], 
   Line3DBox[{{18, 26, 1}, {17.976476047300608`, 24.709779999646905`, 
     1.1574133867822272`}}], 
   Line3DBox[{{1, 27, 1}, {0.9867076344259887, 25.704658417097463`, 
     1.1091489652768067`}}], 
   Line3DBox[{{12, 27, 1}, {12.016307196031057`, 25.7008565161707, 
     1.0442750921114095`}}], 
   Line3DBox[{{23, 27, 1}, {22.96866778364505, 25.704438754864018`, 
     1.1026613477409484`}}], 
   Line3DBox[{{6, 1, 2}, {5.963655079208853, -0.29441304841918314`, 
     2.114777640744363}}], 
   Line3DBox[{{17, 1, 2}, {17.004831448059452`, -0.2931474888687742, 
     2.133214973415272}}], 
   Line3DBox[{{0, 2, 2}, {-0.04879729556944633, 0.7121295235646448, 
     2.1703187008853657`}}], 
   Line3DBox[{{11, 2, 2}, {11.045005845348129`, 0.7084032643380072, 
     2.1405430407803445`}}], 
   Line3DBox[{{22, 2, 2}, {22.06927833225405, 0.7071948054095676, 
     2.1177082899378417`}}], 
   Line3DBox[{{5, 3, 2}, {4.968802538722631, 1.7135133999080778`, 
     2.1843337901573503`}}], 
   Line3DBox[{{16, 3, 2}, {16.042724800545216`, 1.7125566720846532`, 
     2.1751121606988746`}}], 
   Line3DBox[{{27, 3, 2}, {26.98298859716413, 1.7049180612352113`, 
     2.1116843053378274`}}], 
   Line3DBox[{{10, 4, 2}, {9.957038448450142, 2.7149261235054762`, 
     2.1916753428059175`}}], 
   Line3DBox[{{21, 4, 2}, {21.0452767982897, 2.7109255652423814`, 
     2.1619787430219195`}}], 
   Line3DBox[{{4, 5, 2}, {3.9496551867570133`, 3.71402457436115, 
     2.1836643798685755`}}], 
   Line3DBox[{{15, 5, 2}, {15.016366348564855`, 3.7130811902868475`, 
     2.1832269626477947`}}], 
   Line3DBox[{{26, 5, 2}, {25.986771263370326`, 3.7065979127160045`, 
     2.130138545929283}}], 
   Line3DBox[{{9, 6, 2}, {8.93971991709934, 4.717247112176102, 
     2.202265519515656}}], 
   Line3DBox[{{20, 6, 2}, {19.94537452647327, 4.711783633138969, 
     2.165875404425569}}], 
   Line3DBox[{{3, 7, 2}, {2.967381914578034, 5.718785511532349, 
     2.2177739540073205`}}], 
   Line3DBox[{{14, 7, 2}, {14.018811908288072`, 5.717348946228989, 
     2.210837345758939}}], 
   Line3DBox[{{25, 7, 2}, {24.954592335139093`, 5.713696583527493, 
     2.1826517581164646`}}], 
   Line3DBox[{{8, 8, 2}, {7.9400068994102275`, 6.717403911762071, 
     2.2033423279063835`}}], 
   Line3DBox[{{19, 8, 2}, {18.905898077526697`, 6.713057674012955, 
     2.1578742466961685`}}], 
   Line3DBox[{{2, 9, 2}, {1.8931912539916715`, 7.718628357855244, 
     2.1915165958432348`}}], 
   Line3DBox[{{13, 9, 2}, {13.048218093436372`, 7.721170591728459, 
     2.2286271200125234`}}], 
   Line3DBox[{{24, 9, 2}, {23.93616832329891, 7.716543397732138, 
     2.1966333317231923`}}], 
   Line3DBox[{{7, 10, 2}, {6.96011988854721, 8.7244720169324, 
     2.247866780997406}}], 
   Line3DBox[{{18, 10, 2}, {17.931038374707246`, 8.72039714884867, 
     2.218771199115355}}], 
   Line3DBox[{{1, 11, 2}, {0.855813624189435, 9.722866003166775, 
     2.19529219944332}}], 
   Line3DBox[{{12, 11, 2}, {12.031934407611223`, 9.720962993422255, 
     2.230313980068865}}], 
   Line3DBox[{{23, 11, 2}, {22.970863543182475`, 9.718724909076622, 
     2.2179110099637223`}}], 
   Line3DBox[{{6, 12, 2}, {5.983754736575344, 10.72514031276268, 
     2.253907206028949}}], 
   Line3DBox[{{17, 12, 2}, {16.909153936028968`, 10.726769676331356`, 
     2.246234716381776}}], 
   Line3DBox[{{0, 13, 2}, {-0.14177493349241366`, 11.728108924848883`, 
     2.228457788626599}}], 
   Line3DBox[{{11, 13, 2}, {11.051005813992772`, 11.72301652339911, 
     2.2381419900547583`}}], 
   Line3DBox[{{22, 13, 2}, {21.986118983011632`, 11.716613188288928`, 
     2.206701738970577}}], 
   Line3DBox[{{5, 14, 2}, {4.889181037834638, 12.732291013182067`, 
     2.2657688513833794`}}], 
   Line3DBox[{{16, 14, 2}, {15.902715655385807`, 12.73294917601937, 
     2.274076569124385}}], 
   Line3DBox[{{27, 14, 2}, {26.901857616941296`, 12.724095970484317`, 
     2.228991222786381}}], 
   Line3DBox[{{10, 15, 2}, {10.029262544915374`, 13.731509827794309`, 
     2.2829777137561416`}}], 
   Line3DBox[{{21, 15, 2}, {20.99098625433947, 13.721408038648224`, 
     2.2347793618608502`}}], 
   Line3DBox[{{4, 16, 2}, {3.852530014350206, 14.731140657300465`, 
     2.2413474088871768`}}], 
   Line3DBox[{{15, 16, 2}, {14.965144952797791`, 14.734838942325963`, 
     2.2969050754528215`}}], 
   Line3DBox[{{26, 16, 2}, {25.920666517310245`, 14.721404223623558`, 
     2.2211312713223483`}}], 
   Line3DBox[{{9, 17, 2}, {9.021830664827144, 15.728623636167995`, 
     2.2704173876852476`}}], 
   Line3DBox[{{20, 17, 2}, {19.97493497367064, 15.72292764151543, 
     2.2417807594697488`}}], 
   Line3DBox[{{3, 18, 2}, {2.9023903475425397`, 16.72561298079725, 
     2.237508065199194}}], 
   Line3DBox[{{14, 18, 2}, {14.033412403894209`, 16.72970780608464, 
     2.2743015737171683`}}], 
   Line3DBox[{{25, 18, 2}, {24.937276636577884`, 16.71665448025053, 
     2.19771205481704}}], 
   Line3DBox[{{8, 19, 2}, {8.054419180672829, 17.723008044397464`, 
     2.237339626066335}}], 
   Line3DBox[{{19, 19, 2}, {19.0317577834107, 17.726553099981146`, 
     2.2594695281246127`}}], 
   Line3DBox[{{2, 20, 2}, {1.9021187630111926`, 18.72636032357913, 
     2.2413736482967477`}}], 
   Line3DBox[{{13, 20, 2}, {13.025841225177196`, 18.72108378592983, 
     2.231744575923085}}], 
   Line3DBox[{{24, 20, 2}, {23.99899241575082, 18.71966878717693, 
     2.225279759954112}}], 
   Line3DBox[{{7, 21, 2}, {7.036396290668033, 19.7172225100499, 
     2.2077431618680325`}}], 
   Line3DBox[{{18, 21, 2}, {18.01530738808551, 19.730548977321803`, 
     2.2797495038266873`}}], 
   Line3DBox[{{1, 22, 2}, {0.8557497879936862, 20.721182512783837`, 
     2.1838959236260274`}}], 
   Line3DBox[{{12, 22, 2}, {12.007068367675295`, 20.711813052289113`, 
     2.1747124091921206`}}], 
   Line3DBox[{{23, 22, 2}, {23.035714394139465`, 20.729582029058577`, 
     2.2734276159430906`}}], 
   Line3DBox[{{6, 23, 2}, {6.00521690222447, 21.71761827808694, 
     2.2132367305003333`}}], 
   Line3DBox[{{17, 23, 2}, {16.975162382315908`, 21.725595711033947`, 
     2.2554932504249523`}}], 
   Line3DBox[{{0, 24, 2}, {-0.10674424636578916`, 22.709632353493106`, 
     2.1164345426239914`}}], 
   Line3DBox[{{11, 24, 2}, {10.975799994656494`, 22.714011553986822`, 
     2.188806982026569}}], 
   Line3DBox[{{22, 24, 2}, {22.025936328980027`, 22.725323191432487`, 
     2.25402035457652}}], 
   Line3DBox[{{5, 25, 2}, {4.997539360376595, 23.713712537526472`, 
     2.1883042993031676`}}], 
   Line3DBox[{{16, 25, 2}, {15.953623804610423`, 23.714785598770305`, 
     2.1899294378788867`}}], 
   Line3DBox[{{27, 25, 2}, {27.08065340599258, 23.722693162970316`, 
     2.2279962108874125`}}], 
   Line3DBox[{{10, 26, 2}, {10.012723909035097`, 24.713104916918766`, 
     2.1836821909718345`}}], 
   Line3DBox[{{21, 26, 2}, {21.012512225000144`, 24.708368694227758`, 
     2.146737909807377}}], 
   Line3DBox[{{4, 27, 2}, {4.002288830132431, 25.70449696664474, 
     2.1080122762649998`}}], 
   Line3DBox[{{15, 27, 2}, {14.978669156272726`, 25.70313877767679, 
     2.087726650114057}}], 
   Line3DBox[{{26, 27, 2}, {25.979319549361993`, 25.713488046464644`, 
     2.185632196485551}}], 
   Line3DBox[{{9, 1, 3}, {9.02768439559642, -0.29562252952243706`, 
     3.102936073532762}}], 
   Line3DBox[{{20, 1, 3}, {20.03629909472491, -0.2962220953824293, 
     3.09214475115022}}], 
   Line3DBox[{{3, 2, 3}, {2.933065701065694, 0.7127831527537876, 
     3.169093429179533}}], 
   Line3DBox[{{14, 2, 3}, {13.979793008107466`, 0.70367231259244, 
     3.095531169464329}}], 
   Line3DBox[{{25, 2, 3}, {25.008401986870567`, 0.7052479028065519, 
     3.1163890606105}}], 
   Line3DBox[{{8, 3, 3}, {7.978998856719627, 1.7138255401179838`, 
     3.187920756512209}}], 
   Line3DBox[{{19, 3, 3}, {19.045243176399318`, 1.7154029198082072`, 
     3.1943280642419443`}}], 
   Line3DBox[{{2, 4, 3}, {1.9500565955504803`, 2.71445308037379, 
     3.186747888318864}}], 
   Line3DBox[{{13, 4, 3}, {13.036470830887907`, 2.7137364035118727`, 
     3.1849211692688915`}}], 
   Line3DBox[{{24, 4, 3}, {24.00743317482395, 2.711580198985803, 
     3.172971570688866}}], 
   Line3DBox[{{7, 5, 3}, {6.95712723847163, 3.716149071141008, 
     3.1997216032051505`}}], 
   Line3DBox[{{18, 5, 3}, {18.00246171803131, 3.7159027378649014`, 
     3.2027021492769103`}}], 
   Line3DBox[{{1, 6, 3}, {0.9505437239793388, 4.720325877158991, 
     3.223580446580784}}], 
   Line3DBox[{{12, 6, 3}, {12.000982107524148`, 4.712192278010031, 
     3.177624059878767}}], 
   Line3DBox[{{23, 6, 3}, {22.96098062178997, 4.713125046173103, 
     3.1800842617696676`}}], 
   Line3DBox[{{6, 7, 3}, {5.944637568588821, 5.7194319059903, 
     3.2169800861660067`}}], 
   Line3DBox[{{17, 7, 3}, {16.980986022647755`, 5.707044219792926, 
     3.133805153467142}}], 
   Line3DBox[{{0, 8, 3}, {-0.16753735557005378`, 6.725682684841859, 
     3.1950554146306636`}}], 
   Line3DBox[{{11, 8, 3}, {11.027683041761208`, 6.714716597544979, 
     3.193080875729554}}], 
   Line3DBox[{{22, 8, 3}, {21.935386710421984`, 6.71389518363207, 
     3.17821202014769}}], 
   Line3DBox[{{5, 9, 3}, {4.962269127063816, 7.717726063649377, 
     3.2105942387230773`}}], 
   Line3DBox[{{16, 9, 3}, {16.037346461462068`, 7.7171056307898915`, 
     3.206850862374949}}], 
   Line3DBox[{{27, 9, 3}, {26.913445993632482`, 7.719440748609177, 
     3.2065826896405123`}}], 
   Line3DBox[{{10, 10, 3}, {9.940812655630335, 8.720256124715071, 
     3.2207996194226354`}}], 
   Line3DBox[{{21, 10, 3}, {20.947371704103762`, 8.719415244600402, 
     3.2175613630891484`}}], 
   Line3DBox[{{4, 11, 3}, {3.9484662598387255`, 9.721406314773944, 
     3.2292214251003664`}}], 
   Line3DBox[{{15, 11, 3}, {14.973125828471552`, 9.723847555192085, 
     3.2463995059155764`}}], 
   Line3DBox[{{26, 11, 3}, {25.933962304812304`, 9.721836623550836, 
     3.2278977970897604`}}], 
   Line3DBox[{{9, 12, 3}, {8.947214886425577, 10.723963192437584`, 
     3.242783437513455}}], 
   Line3DBox[{{20, 12, 3}, {19.92177860863954, 10.722743268160398`, 
     3.2291214850337093`}}], 
   Line3DBox[{{3, 13, 3}, {2.88956557618944, 11.724899467753932`, 
     3.2278659050920635`}}], 
   Line3DBox[{{14, 13, 3}, {13.998700241452841`, 11.729197709463536`, 
     3.273970525777861}}], 
   Line3DBox[{{25, 13, 3}, {24.975197456275676`, 11.719132699012972`, 
     3.2208252501119556`}}], 
   Line3DBox[{{8, 14, 3}, {7.972286879025777, 12.728445244952137`, 
     3.269036220314367}}], 
   Line3DBox[{{19, 14, 3}, {18.905561582065793`, 12.724852032779353`, 
     3.2346892560624316`}}], 
   Line3DBox[{{2, 15, 3}, {1.838985348151376, 13.733631918147143`, 
     3.2457359622732924`}}], 
   Line3DBox[{{13, 15, 3}, {13.039339094330568`, 13.72520658353607, 
     3.251702564542894}}], 
   Line3DBox[{{24, 15, 3}, {23.95703115845695, 13.723939434868408`, 
     3.244587638225008}}], 
   Line3DBox[{{7, 16, 3}, {6.947172270415471, 14.727542512358587`, 
     3.2608853639671014`}}], 
   Line3DBox[{{18, 16, 3}, {17.94841572317251, 14.733416079767705`, 
     3.2882780522224646`}}], 
   Line3DBox[{{1, 17, 3}, {0.8853265002636361, 15.728925437911673`, 
     3.2474256374553474`}}], 
   Line3DBox[{{12, 17, 3}, {12.048307697626743`, 15.731662211243986`, 
     3.2810438043499808`}}], 
   Line3DBox[{{23, 17, 3}, {22.96624600313778, 15.72126885174197, 
     3.2317483941055993`}}], 
   Line3DBox[{{6, 18, 3}, {5.970269124638598, 16.72036239687586, 
     3.227252458118603}}], 
   Line3DBox[{{17, 18, 3}, {17.042951761433578`, 16.728356411764192`, 
     3.266604071027638}}], 
   Line3DBox[{{0, 19, 3}, {-0.10026937318133149`, 17.725384827349426`, 
     3.23516422868024}}], 
   Line3DBox[{{11, 19, 3}, {11.10044431346444, 17.72203468172845, 
     3.2161378846656783`}}], 
   Line3DBox[{{22, 19, 3}, {21.971950772304556`, 17.72169244577195, 
     3.234825547224293}}], 
   Line3DBox[{{5, 20, 3}, {4.966637726761849, 18.718594821174353`, 
     3.2165357393207694`}}], 
   Line3DBox[{{16, 20, 3}, {16.02230061683726, 18.724788725637072`, 
     3.2516721840536933`}}], 
   Line3DBox[{{27, 20, 3}, {26.930006672617925`, 18.727179655064337`, 
     3.2550084383698854`}}], 
   Line3DBox[{{10, 21, 3}, {10.057125301194354`, 19.7153814810771, 
     3.1910286910487224`}}], 
   Line3DBox[{{21, 21, 3}, {21.041641851724943`, 19.729331949334508`, 
     3.2714197141013934`}}], 
   Line3DBox[{{4, 22, 3}, {3.9473141643549847`, 20.714968998626556`, 
     3.189524479240939}}], 
   Line3DBox[{{15, 22, 3}, {14.987463639993102`, 20.723166174652842`, 
     3.2440045534966924`}}], 
   Line3DBox[{{26, 22, 3}, {25.99013437261813, 20.726812842993933`, 
     3.262482633008676}}], 
   Line3DBox[{{9, 23, 3}, {8.997718226293202, 21.712690086691502`, 
     3.1811849348219026`}}], 
   Line3DBox[{{20, 23, 3}, {20.014129153562262`, 21.727966522023394`, 
     3.2678268058398006`}}], 
   Line3DBox[{{3, 24, 3}, {2.927764821190687, 22.707231929442017`, 
     3.1163305406510946`}}], 
   Line3DBox[{{14, 24, 3}, {13.967240319170028`, 22.713635529441284`, 
     3.1849141752168144`}}], 
   Line3DBox[{{25, 24, 3}, {25.06238655617338, 22.72818438076364, 
     3.2619025549231155`}}], 
   Line3DBox[{{8, 25, 3}, {8.03021218400931, 23.71772931744261, 
     3.211823324001859}}], 
   Line3DBox[{{19, 25, 3}, {19.008373613881457`, 23.713744788825135`, 
     3.1883544910960926`}}], 
   Line3DBox[{{2, 26, 3}, {1.946991092532141, 24.704043220044284`, 
     3.0876702926644595`}}], 
   Line3DBox[{{13, 26, 3}, {12.977789639434725`, 24.704729753011215`, 
     3.10854348045449}}], 
   Line3DBox[{{24, 26, 3}, {24.002696147698813`, 24.716669109334937`, 
     3.2074959176764692`}}], 
   Line3DBox[{{7, 27, 3}, {7.004456673307443, 25.716814735453564`, 
     3.208364380146711}}], 
   Line3DBox[{{18, 27, 3}, {18.013613017515173`, 25.702535390481184`, 
     3.0800017049838355`}}], 
   Line3DBox[{{1, 1, 4}, {0.9768232839451904, -0.29325433589254457`, 
     4.130215446580074}}], 
   Line3DBox[{{12, 1, 4}, {11.97076159329838, -0.29772642247986614`, 
     4.071072132169781}}], 
   Line3DBox[{{23, 1, 4}, {23.01058647974157, -0.29354356644955626`, 
     4.1289688650165}}], 
   Line3DBox[{{6, 2, 4}, {5.942455190786914, 0.7114682151347149, 
     4.1624020761089975`}}], 
   Line3DBox[{{17, 2, 4}, {16.978613333153287`, 0.7086958986180119, 
     4.148581049381285}}], 
   Line3DBox[{{0, 3, 4}, {-0.019660178276673705`, 1.7104182582983292`, 
     4.163071790509014}}], 
   Line3DBox[{{11, 3, 4}, {10.991230202567253`, 1.7165915599506218`, 
     4.206847447803954}}], 
   Line3DBox[{{22, 3, 4}, {21.993483285124988`, 1.715084310718518, 
     4.197355526564451}}], 
   Line3DBox[{{5, 4, 4}, {4.961107806750966, 2.716913830849042, 
     4.205371078386899}}], 
   Line3DBox[{{16, 4, 4}, {16.01997926388688, 2.7087900435351395`, 
     4.149591702111283}}], 
   Line3DBox[{{27, 4, 4}, {26.97191811677947, 2.709895313028351, 
     4.157611244803703}}], 
   Line3DBox[{{10, 5, 4}, {9.94203713095122, 3.7187897493418625`, 
     4.212463171914915}}], 
   Line3DBox[{{21, 5, 4}, {20.96237660873708, 3.718422915838307, 
     4.214813076374528}}], 
   Line3DBox[{{4, 6, 4}, {3.951813449268039, 4.714321818329874, 
     4.186305312607973}}], 
   Line3DBox[{{15, 6, 4}, {15.01425533854516, 4.70755375339466, 
     4.139210218585892}}], 
   Line3DBox[{{26, 6, 4}, {25.951070541232653`, 4.713050331577378, 
     4.17710578480569}}], 
   Line3DBox[{{9, 7, 4}, {8.913365574703338, 5.7192253362524585`, 
     4.205209008223056}}], 
   Line3DBox[{{20, 7, 4}, {19.89274452237206, 5.720263696850234, 
     4.201918936505152}}], 
   Line3DBox[{{3, 8, 4}, {2.9204610360043026`, 6.716753416380608, 
     4.192228402780782}}], 
   Line3DBox[{{14, 8, 4}, {14.04961732549657, 6.718464572667889, 
     4.212614838389216}}], 
   Line3DBox[{{25, 8, 4}, {24.9370845237767, 6.7169249616858995`, 
     4.1993993202266875`}}], 
   Line3DBox[{{8, 9, 4}, {7.888625046186592, 7.718816950394105, 
     4.190172587576655}}], 
   Line3DBox[{{19, 9, 4}, {18.921753885760182`, 7.715180502294945, 
     4.181979130460883}}], 
   Line3DBox[{{2, 10, 4}, {1.8868479817249086`, 8.719156197830372, 
     4.1914047418532885`}}], 
   Line3DBox[{{13, 10, 4}, {13.033169585637953`, 8.72206107643498, 
     4.2361607211754}}], 
   Line3DBox[{{24, 10, 4}, {23.945270907923227`, 8.715903005906965, 
     4.195191281162056}}], 
   Line3DBox[{{7, 11, 4}, {6.91599587509875, 9.72610459029744, 
     4.245221924261112}}], 
   Line3DBox[{{18, 11, 4}, {17.920937885545836`, 9.72384358317409, 
     4.234891425667467}}], 
   Line3DBox[{{1, 12, 4}, {0.8589993346205035, 10.724475875169285`, 
     4.207742675773126}}], 
   Line3DBox[{{12, 12, 4}, {12.020562904042265`, 10.717915122911384`, 
     4.214092351376728}}], 
   Line3DBox[{{23, 12, 4}, {22.992767815095277`, 10.715588008858518`, 
     4.200582981614787}}], 
   Line3DBox[{{6, 13, 4}, {5.935731218278898, 11.731425237917424`, 
     4.27674464168837}}], 
   Line3DBox[{{17, 13, 4}, {16.919695022984452`, 11.724058295364216`, 
     4.235635050528698}}], 
   Line3DBox[{{0, 14, 4}, {-0.11862080314464549`, 12.732794085775947`, 
     4.264798557429791}}], 
   Line3DBox[{{11, 14, 4}, {11.060530247494501`, 12.722320649877227`, 
     4.232102493325913}}], 
   Line3DBox[{{22, 14, 4}, {21.966606506295065`, 12.715833219490646`, 
     4.199500762941948}}], 
   Line3DBox[{{5, 15, 4}, {4.907272356527968, 13.728024591849119`, 
     4.251952664593018}}], 
   Line3DBox[{{16, 15, 4}, {15.967805142063893`, 13.72662355131109, 
     4.259761257786632}}], 
   Line3DBox[{{27, 15, 4}, {26.88931615363228, 13.725697144977937`, 
     4.232166577775236}}], 
   Line3DBox[{{10, 16, 4}, {10.026728287375818`, 14.732684528603398`, 
     4.288439065684185}}], 
   Line3DBox[{{21, 16, 4}, {20.93496379717039, 14.71972300652333, 
     4.216011833694}}], 
   Line3DBox[{{4, 17, 4}, {3.890970274914093, 15.721002767782842`, 
     4.205617603887748}}], 
   Line3DBox[{{15, 17, 4}, {15.041357692934243`, 15.725569341580934`, 
     4.253211449418665}}], 
   Line3DBox[{{26, 17, 4}, {25.962621391561676`, 15.718265881900638`, 
     4.213917016927742}}], 
   Line3DBox[{{9, 18, 4}, {9.077458640925384, 16.722061496640528`, 
     4.225551192808512}}], 
   Line3DBox[{{20, 18, 4}, {19.974828417932876`, 16.723453812533002`, 
     4.244532661866893}}], 
   Line3DBox[{{3, 19, 4}, {2.9154072198448344`, 17.71892857063307, 
     4.204205911778754}}], 
   Line3DBox[{{14, 19, 4}, {14.090728835857936`, 17.725286314752495`, 
     4.23848123403443}}], 
   Line3DBox[{{25, 19, 4}, {25.002921336015554`, 17.716852085672354`, 
     4.208621417290972}}], 
   Line3DBox[{{8, 20, 4}, {8.075828672518439, 18.717641766413575`, 
     4.199517851775723}}], 
   Line3DBox[{{19, 20, 4}, {19.0333216880988, 18.731712867001065`, 
     4.283438553079119}}], 
   Line3DBox[{{2, 21, 4}, {1.8966534910043467`, 19.722204078313883`, 
     4.215770900727461}}], 
   Line3DBox[{{13, 21, 4}, {13.022620533513619`, 19.717729483700627`, 
     4.2127689697603765`}}], 
   Line3DBox[{{24, 21, 4}, {23.999441278126564`, 19.724981932411733`, 
     4.253630863960506}}], 
   Line3DBox[{{7, 22, 4}, {7.031461579381301, 20.71371438213468, 
     4.185686505421538}}], 
   Line3DBox[{{18, 22, 4}, {18.03898566458478, 20.72810667334662, 
     4.266021584784921}}], 
   Line3DBox[{{1, 23, 4}, {0.8584091778183237, 21.716213073226587`, 
     4.14779433588469}}], 
   Line3DBox[{{12, 23, 4}, {12.011708191824692`, 21.713314573087402`, 
     4.185212122753731}}], 
   Line3DBox[{{23, 23, 4}, {23.038322561679056`, 21.731789462908775`, 
     4.283149103613519}}], 
   Line3DBox[{{6, 24, 4}, {6.019947988671075, 22.715218531011327`, 
     4.19732879843369}}], 
   Line3DBox[{{17, 24, 4}, {17.00819263325053, 22.718657405516602`, 
     4.219303525559842}}], 
   Line3DBox[{{0, 25, 4}, {-0.13009307358255037`, 23.709942088783656`, 
     4.093948804750056}}], 
   Line3DBox[{{11, 25, 4}, {11.003542904354882`, 23.71177956830506, 
     4.174572527026559}}], 
   Line3DBox[{{22, 25, 4}, {22.0112920194216, 23.7217680685749, 
     4.2366339362446555`}}], 
   Line3DBox[{{5, 26, 4}, {4.982835722054625, 24.709866541052847`, 
     4.158937238140299}}], 
   Line3DBox[{{16, 26, 4}, {15.99325322185291, 24.70516968958664, 
     4.115624167973126}}], 
   Line3DBox[{{27, 26, 4}, {27.04912218284604, 24.72193790281701, 
     4.232689249637073}}], 
   Line3DBox[{{10, 27, 4}, {10.027961587056241`, 25.710743260753475`, 
     4.164423872830917}}], 
   Line3DBox[{{21, 27, 4}, {21.009497124203666`, 25.705513304835446`, 
     4.119222483927371}}], 
   Line3DBox[{{4, 1, 5}, {3.9795377753316052`, -0.2951911243442533, 
     5.109823716844269}}], 
   Line3DBox[{{15, 1, 5}, {14.93674359788228, -0.29691892624232574`, 
     5.063244970911323}}], 
   Line3DBox[{{26, 1, 5}, {25.96319667647694, -0.2914782212765641, 
     5.143977495970656}}], 
   Line3DBox[{{9, 2, 5}, {8.974195027819007, 0.7136243540519371, 
     5.185934937336805}}], 
   Line3DBox[{{20, 2, 5}, {20.007164896340086`, 0.7110268475169532, 
     5.168810178716666}}], 
   Line3DBox[{{3, 3, 5}, {2.940969969879079, 1.7140032538766106`, 
     5.18090833177048}}], 
   Line3DBox[{{14, 3, 5}, {13.985767248812733`, 1.707784501103398, 
     5.14133836423649}}], 
   Line3DBox[{{25, 3, 5}, {24.979626509094352`, 1.7137489201941674`, 
     5.187464878221624}}], 
   Line3DBox[{{8, 4, 5}, {7.917542218044175, 2.7209226089201355`, 
     5.217167543208583}}], 
   Line3DBox[{{19, 4, 5}, {18.957421246937432`, 2.719808691479953, 
     5.222029870461983}}], 
   Line3DBox[{{2, 5, 5}, {1.9543464239147204`, 3.7137026167432983`, 
     5.182632945597411}}], 
   Line3DBox[{{13, 5, 5}, {13.001345439872225`, 3.7124799140571465`, 
     5.179694791480603}}], 
   Line3DBox[{{24, 5, 5}, {23.997567533338874`, 3.715520529325823, 
     5.200266254078239}}], 
   Line3DBox[{{7, 6, 5}, {6.9150409770491015`, 4.721363940278813, 
     5.218796232142845}}], 
   Line3DBox[{{18, 6, 5}, {17.933603180116553`, 4.712772404363241, 
     5.169223459781949}}], 
   Line3DBox[{{1, 7, 5}, {0.9001320153845871, 5.721724154756874, 
     5.2145629257742945`}}], 
   Line3DBox[{{12, 7, 5}, {11.979270476616072`, 5.713712135227088, 
     5.187173224041844}}], 
   Line3DBox[{{23, 7, 5}, {22.951207342904706`, 5.718604951752737, 
     5.213649261503466}}], 
   Line3DBox[{{6, 8, 5}, {5.8983065724042865`, 6.717690043583379, 
     5.187988357242247}}], 
   Line3DBox[{{17, 8, 5}, {16.987552307412443`, 6.707420174261203, 
     5.138139237880868}}], 
   Line3DBox[{{0, 9, 5}, {-0.17454719877429067`, 7.7276854213192046`, 
     5.201863538749219}}], 
   Line3DBox[{{11, 9, 5}, {10.959503573074993`, 7.721305899494237, 
     5.23087103919302}}], 
   Line3DBox[{{22, 9, 5}, {21.936564194734583`, 7.718313195804491, 
     5.207977966528742}}], 
   Line3DBox[{{5, 10, 5}, {4.924739737265647, 8.717979178619217, 
     5.201887360672479}}], 
   Line3DBox[{{16, 10, 5}, {16.013031640132414`, 8.716053262597772, 
     5.2032509578566195`}}], 
   Line3DBox[{{27, 10, 5}, {26.858579786179835`, 8.727789867336526, 
     5.226895794300913}}], 
   Line3DBox[{{10, 11, 5}, {9.906923086027513, 9.718501741236746, 
     5.19773442004898}}], 
   Line3DBox[{{21, 11, 5}, {20.947145333701062`, 9.720660403678925, 
     5.22471444442995}}], 
   Line3DBox[{{4, 12, 5}, {3.9261196416079738`, 10.728545940107804`, 
     5.2606650460409226`}}], 
   Line3DBox[{{15, 12, 5}, {14.98724846707336, 10.71956385007289, 
     5.224322679120638}}], 
   Line3DBox[{{26, 12, 5}, {25.901479423212873`, 10.724825236676134`, 
     5.232858366676947}}], 
   Line3DBox[{{9, 13, 5}, {8.98200936107475, 11.71968289967209, 
     5.224642960092225}}], 
   Line3DBox[{{20, 13, 5}, {19.91683722429113, 11.720636847477238`, 
     5.2152065907527305`}}], 
   Line3DBox[{{3, 14, 5}, {2.8838506152530954`, 12.726881639806962`, 
     5.235963898430051}}], 
   Line3DBox[{{14, 14, 5}, {14.081265389827523`, 12.724460752215759`, 
     5.237477501625302}}], 
   Line3DBox[{{25, 14, 5}, {24.90500714320083, 12.722342109942854`, 
     5.2203784770159185`}}], 
   Line3DBox[{{8, 15, 5}, {7.994097890938105, 13.7265360188321, 
     5.261255916251905}}], 
   Line3DBox[{{19, 15, 5}, {18.91597170440441, 13.722659620954337`, 
     5.226585086885218}}], 
   Line3DBox[{{2, 16, 5}, {1.8651271039986144`, 14.727002927259479`, 
     5.226467999324989}}], 
   Line3DBox[{{13, 16, 5}, {13.066809443716153`, 14.725041659053627`, 
     5.244985156859775}}], 
   Line3DBox[{{24, 16, 5}, {23.94796655950779, 14.716943705593255`, 
     5.202630369031335}}], 
   Line3DBox[{{7, 17, 5}, {6.952949189320761, 15.723895487796984`, 
     5.243605203453316}}], 
   Line3DBox[{{18, 17, 5}, {17.998000732949, 15.723214429012193`, 
     5.24457025299206}}], 
   Line3DBox[{{1, 18, 5}, {0.9196624906688109, 16.720992763613474`, 
     5.218372099557989}}], 
   Line3DBox[{{12, 18, 5}, {12.081949914448002`, 16.727537548784188`, 
     5.253226226461265}}], 
   Line3DBox[{{23, 18, 5}, {22.969310125884203`, 16.717021294279238`, 
     5.207421725703536}}], 
   Line3DBox[{{6, 19, 5}, {5.96999764738568, 17.71880698687053, 
     5.218275793311666}}], 
   Line3DBox[{{17, 19, 5}, {17.07614849852769, 17.72618645407173, 
     5.248194392325105}}], 
   Line3DBox[{{0, 20, 5}, {-0.08326332437355624, 18.719443654273242`, 
     5.207948705774267}}], 
   Line3DBox[{{11, 20, 5}, {11.096050110830664`, 18.720599542749024`, 
     5.20954437762777}}], 
   Line3DBox[{{22, 20, 5}, {22.007744190641493`, 18.724433459641745`, 
     5.250738965120658}}], 
   Line3DBox[{{5, 21, 5}, {4.981953610059235, 19.712844049266756`, 
     5.1813942840943525`}}], 
   Line3DBox[{{16, 21, 5}, {16.035583185504418`, 19.722069023465536`, 
     5.235852191261872}}], 
   Line3DBox[{{27, 21, 5}, {27.00076151971255, 19.72262422933033, 
     5.241475797118045}}], 
   Line3DBox[{{10, 22, 5}, {10.04007299717691, 20.714247673517352`, 
     5.187710175115045}}], 
   Line3DBox[{{21, 22, 5}, {21.02677590897691, 20.732819428599104`, 
     5.289026729148984}}], 
   Line3DBox[{{4, 23, 5}, {3.947262966499159, 21.714726716891747`, 
     5.187860035733151}}], 
   Line3DBox[{{15, 23, 5}, {14.999291248560475`, 21.716597284723807`, 
     5.207067544760373}}], 
   Line3DBox[{{26, 23, 5}, {26.02292078577046, 21.724604518259422`, 
     5.250681077737007}}], 
   Line3DBox[{{9, 24, 5}, {9.008377259938527, 22.71317160584135, 
     5.184397683019581}}], 
   Line3DBox[{{20, 24, 5}, {20.022785773120724`, 22.726677421812152`, 
     5.261018046158391}}], 
   Line3DBox[{{3, 25, 5}, {2.9418548753459124`, 23.706697880963684`, 
     5.118274144998551}}], 
   Line3DBox[{{14, 25, 5}, {13.96322278511614, 23.709282172389592`, 
     5.150648351979216}}], 
   Line3DBox[{{25, 25, 5}, {25.073395392469376`, 23.72926873916965, 
     5.264301303653202}}], 
   Line3DBox[{{8, 26, 5}, {8.015175592878254, 24.714224106303583`, 
     5.191180680430777}}], 
   Line3DBox[{{19, 26, 5}, {19.008178430827357`, 24.70593345911913, 
     5.123793784342454}}], 
   Line3DBox[{{2, 27, 5}, {1.9688548035715943`, 25.70167463305176, 
     5.05814824398162}}], 
   Line3DBox[{{13, 27, 5}, {12.984684475366064`, 25.702529015224236`, 
     5.07958943629777}}], 
   Line3DBox[{{24, 27, 5}, {24.01797149318868, 25.712438367114764`, 
     5.178499487266709}}], 
   Line3DBox[{{7, 1, 6}, {6.967287954598373, -0.2898338884148577, 
     6.158929111185619}}], 
   Line3DBox[{{18, 1, 6}, {17.955947178875615`, -0.29394664348755617`, 
     6.117309133311394}}], 
   Line3DBox[{{1, 2, 6}, {1.005328027550006, 0.7060551629543217, 
     6.125213301231381}}], 
   Line3DBox[{{12, 2, 6}, {11.958873948865712`, 0.7128756379300532, 
     6.17781879676832}}], 
   Line3DBox[{{23, 2, 6}, {22.95404910739838, 0.7113548979130773, 
     6.165173594549791}}], 
   Line3DBox[{{6, 3, 6}, {5.948402158119499, 1.7185688587059895`, 
     6.212771926802396}}], 
   Line3DBox[{{17, 3, 6}, {16.96586181022166, 1.7107536645502917`, 
     6.163335453983993}}], 
   Line3DBox[{{0, 4, 6}, {-0.038833687393909855`, 2.7102555663045402`, 
     6.15827583667436}}], 
   Line3DBox[{{11, 4, 6}, {10.95041464126885, 2.7180730428665187`, 
     6.210248825856407}}], 
   Line3DBox[{{22, 4, 6}, {21.953191389181303`, 2.717109718577233, 
     6.204942625591255}}], 
   Line3DBox[{{5, 5, 6}, {4.947530595727222, 3.718818573498057, 
     6.214058669531757}}], 
   Line3DBox[{{16, 5, 6}, {15.96762091029905, 3.7068970851934235`, 
     6.129755332333101}}], 
   Line3DBox[{{27, 5, 6}, {26.934889741278862`, 3.711572570154238, 
     6.160360257639821}}], 
   Line3DBox[{{10, 6, 6}, {9.928842663507075, 4.716272367451587, 
     6.192301843191585}}], 
   Line3DBox[{{21, 6, 6}, {20.89445774811291, 4.724220225667057, 
     6.226377561762621}}], 
   Line3DBox[{{4, 7, 6}, {3.9196483266083306`, 5.7199499863247825`, 
     6.212168732553208}}], 
   Line3DBox[{{15, 7, 6}, {14.98157955440954, 5.70793287649105, 
     6.142208422857282}}], 
   Line3DBox[{{26, 7, 6}, {25.887231595022243`, 5.711640892169125, 
     6.131962479925194}}], 
   Line3DBox[{{9, 8, 6}, {8.884478643449764, 6.720420952102882, 
     6.198323665666756}}], 
   Line3DBox[{{20, 8, 6}, {19.887074499455814`, 6.71647779828953, 
     6.172680598340263}}], 
   Line3DBox[{{3, 9, 6}, {2.9190227863843137`, 7.714060892692446, 
     6.1726363321322895`}}], 
   Line3DBox[{{14, 9, 6}, {14.0070755087442, 7.716564882347007, 
     6.206746791876094}}], 
   Line3DBox[{{25, 9, 6}, {24.90165597583361, 7.717966993256716, 
     6.191624170008725}}], 
   Line3DBox[{{8, 10, 6}, {7.886543180388171, 8.719337801484492, 
     6.192436699662498}}], 
   Line3DBox[{{19, 10, 6}, {18.923233234674484`, 8.718873845125952, 
     6.206936316385246}}], 
   Line3DBox[{{2, 11, 6}, {1.905757705271428, 9.720609402095127, 
     6.210423591540737}}], 
   Line3DBox[{{13, 11, 6}, {13.029175035735987`, 9.715992286364802, 
     6.201179046163148}}], 
   Line3DBox[{{24, 11, 6}, {23.9556276073866, 9.71526020539908, 
     6.193583963546952}}], 
   Line3DBox[{{7, 12, 6}, {6.912248722507263, 10.723227434965544`, 
     6.228367095864814}}], 
   Line3DBox[{{18, 12, 6}, {17.921885456890912`, 10.71802954645925, 
     6.201121541370844}}], 
   Line3DBox[{{1, 13, 6}, {0.8708733459752498, 11.725626765641268`, 
     6.222034156765207}}], 
   Line3DBox[{{12, 13, 6}, {12.060541674076449`, 11.715510792131138`, 
     6.190845960314717}}], 
   Line3DBox[{{23, 13, 6}, {22.980823688444797`, 11.7107610498709, 
     6.16581676195473}}], 
   Line3DBox[{{6, 14, 6}, {5.9395060530452835`, 12.727255755790289`, 
     6.257803357644724}}], 
   Line3DBox[{{17, 14, 6}, {16.976176292810077`, 12.716925477576545`, 
     6.207731078280441}}], 
   Line3DBox[{{0, 15, 6}, {-0.09327162557546204, 13.72988948313281, 
     6.260997468964493}}], 
   Line3DBox[{{11, 15, 6}, {11.074847850485998`, 13.721967359356286`, 
     6.225899023297755}}], 
   Line3DBox[{{22, 15, 6}, {21.95596502137102, 13.710891372550641`, 
     6.162048965725722}}], 
   Line3DBox[{{5, 16, 6}, {4.91321010301283, 14.722843142604788`, 
     6.226578629595432}}], 
   Line3DBox[{{16, 16, 6}, {16.044231015954434`, 14.722730413893302`, 
     6.237962227327081}}], 
   Line3DBox[{{27, 16, 6}, {26.907776734541407`, 14.731619467155095`, 
     6.269639932517844}}], 
   Line3DBox[{{10, 17, 6}, {10.055244885119722`, 15.720779978951988`, 
     6.224820240232134}}], 
   Line3DBox[{{21, 17, 6}, {20.98077454104197, 15.717197727318199`, 
     6.209877847640621}}], 
   Line3DBox[{{4, 18, 6}, {3.9233986785928088`, 16.714700082535238`, 
     6.179266170048186}}], 
   Line3DBox[{{15, 18, 6}, {15.083506837433521`, 16.722556651007014`, 
     6.226197034055345}}], 
   Line3DBox[{{26, 18, 6}, {26.017611764860558`, 16.71913649610244, 
     6.22153670152316}}], 
   Line3DBox[{{9, 19, 6}, {9.062969477322083, 17.715887902724432`, 
     6.192590151763612}}], 
   Line3DBox[{{20, 19, 6}, {20.024046481130323`, 17.722458802298327`, 
     6.239395603385317}}], 
   Line3DBox[{{3, 20, 6}, {2.940944839135249, 18.715213177610877`, 
     6.1893021631955}}], 
   Line3DBox[{{14, 20, 6}, {14.07458042504135, 18.724124934544438`, 
     6.237866722240448}}], 
   Line3DBox[{{25, 20, 6}, {25.055036337683596`, 18.722600299138897`, 
     6.234991501493868}}], 
   Line3DBox[{{8, 21, 6}, {8.05822013336014, 19.712489124785478`, 
     6.1700769304634315`}}], 
   Line3DBox[{{19, 21, 6}, {19.047533313685754`, 19.727821713516487`, 
     6.263254613425722}}], 
   Line3DBox[{{2, 22, 6}, {1.8925034440086932`, 20.72044406430781, 
     6.202931263941484}}], 
   Line3DBox[{{13, 22, 6}, {13.04625286105, 20.7188734726771, 
     6.215813562674475}}], 
   Line3DBox[{{24, 22, 6}, {24.040738024739156`, 20.728182835799437`, 
     6.266123118471862}}], 
   Line3DBox[{{7, 23, 6}, {7.032275798141449, 21.717667648733382`, 
     6.211144532842699}}], 
   Line3DBox[{{18, 23, 6}, {18.023904076545787`, 21.72839136798944, 
     6.269146952649885}}], 
   Line3DBox[{{1, 24, 6}, {0.8886731516031715, 22.710180803284736`, 
     6.1182064829475165`}}], 
   Line3DBox[{{12, 24, 6}, {12.022766011582686`, 22.712782823132862`, 
     6.18042629601811}}], 
   Line3DBox[{{23, 24, 6}, {23.049618030049135`, 22.727793672618642`, 
     6.262733917994769}}], 
   Line3DBox[{{6, 25, 6}, {5.995855272755737, 23.715027300132878`, 
     6.197048171349713}}], 
   Line3DBox[{{17, 25, 6}, {17.008398069978917`, 23.710198715081997`, 
     6.162302550332709}}], 
   Line3DBox[{{0, 26, 6}, {-0.04386451988214223, 24.704052967889602`, 
     6.09272105402635}}], 
   Line3DBox[{{11, 26, 6}, {10.989546249526363`, 24.710597009630455`, 
     6.165319834040287}}], 
   Line3DBox[{{22, 26, 6}, {22.022864416929835`, 24.714726951814747`, 
     6.19377928177967}}], 
   Line3DBox[{{5, 27, 6}, {4.971729746322157, 25.704834511376458`, 
     6.108384269317704}}], 
   Line3DBox[{{16, 27, 6}, {15.9911221858689, 25.700176269040465`, 
     6.019479549550487}}], 
   Line3DBox[{{27, 27, 6}, {27.03722107328899, 25.71077820265656, 
     6.1628549936531485`}}], 
   Line3DBox[{{10, 1, 7}, {9.99334417507134, -0.2857836061450847, 
     7.191614764992316}}], 
   Line3DBox[{{21, 1, 7}, {20.95761120754689, -0.2934310534088569, 
     7.123447561142458}}], 
   Line3DBox[{{4, 2, 7}, {3.9561983820538016`, 0.7098334188913182, 
     7.153465342196962}}], 
   Line3DBox[{{15, 2, 7}, {14.92919558552311, 0.7082394314648626, 
     7.127833362110069}}], 
   Line3DBox[{{26, 2, 7}, {25.930181014940892`, 0.7106720539059088, 
     7.150860056827872}}], 
   Line3DBox[{{9, 3, 7}, {8.95433562592974, 1.722621243178241, 
     7.23710393619944}}], 
   Line3DBox[{{20, 3, 7}, {19.937915514921354`, 1.7201594617265357`, 
     7.21943954362058}}], 
   Line3DBox[{{3, 4, 7}, {2.9194548752295604`, 2.7191025012435333`, 
     7.206915636323458}}], 
   Line3DBox[{{14, 4, 7}, {13.954963085791771`, 2.707590535707215, 
     7.1328512437466705`}}], 
   Line3DBox[{{25, 4, 7}, {24.95095757887404, 2.709924003149456, 
     7.152639324160517}}], 
   Line3DBox[{{8, 5, 7}, {7.9362087880657874`, 3.721004814213959, 
     7.223834751582715}}], 
   Line3DBox[{{19, 5, 7}, {18.88423032944657, 3.7203771855559182`, 
     7.1978960235430645`}}], 
   Line3DBox[{{2, 6, 7}, {1.9355369162114873`, 4.719411979198367, 
     7.21433345937541}}], 
   Line3DBox[{{13, 6, 7}, {12.946694425321459`, 4.711938958095733, 
     7.167503038887913}}], 
   Line3DBox[{{24, 6, 7}, {23.937170107601652`, 4.711451864479784, 
     7.1603000532395065`}}], 
   Line3DBox[{{7, 7, 7}, {6.905062488429313, 5.721371227491954, 
     7.2146982324364455`}}], 
   Line3DBox[{{18, 7, 7}, {17.89554245902936, 5.708811112359092, 
     7.109178196390131}}], 
   Line3DBox[{{1, 8, 7}, {0.9119358067588463, 6.718365744351423, 
     7.199143999700975}}], 
   Line3DBox[{{12, 8, 7}, {11.943075843021589`, 6.71602419419413, 
     7.195360616444217}}], 
   Line3DBox[{{23, 8, 7}, {22.95005391292704, 6.712709438593192, 
     7.174322686128475}}], 
   Line3DBox[{{6, 9, 7}, {5.887411971193344, 7.716487357010931, 
     7.172971763755375}}], 
   Line3DBox[{{17, 9, 7}, {16.97395344608359, 7.708415544514841, 
     7.145365647173552}}], 
   Line3DBox[{{0, 10, 7}, {-0.1354234534513906, 8.724619560955736, 
     7.212285713034478}}], 
   Line3DBox[{{11, 10, 7}, {10.943835159207115`, 8.71605605292059, 
     7.195789303632387}}], 
   Line3DBox[{{22, 10, 7}, {21.95835106011224, 8.70931595953719, 
     7.149666541019767}}], 
   Line3DBox[{{5, 11, 7}, {4.912034641516108, 9.7187041639478, 
     7.201353113266457}}], 
   Line3DBox[{{16, 11, 7}, {15.966595824248918`, 9.717729976708549, 
     7.211347458963981}}], 
   Line3DBox[{{27, 11, 7}, {26.833883912609622`, 9.718114594659811, 
     7.138474738078581}}], 
   Line3DBox[{{10, 12, 7}, {9.95686086563084, 10.713974116930448`, 
     7.185138983364002}}], 
   Line3DBox[{{21, 12, 7}, {20.936283995417206`, 10.713204433548874`, 
     7.173486140431254}}], 
   Line3DBox[{{4, 13, 7}, {3.9443072700298405`, 11.727918896962217`, 
     7.262122084385594}}], 
   Line3DBox[{{15, 13, 7}, {15.068031403576946`, 11.718298264446114`, 
     7.206427685172089}}], 
   Line3DBox[{{26, 13, 7}, {25.85454952848523, 11.719562226662156`, 
     7.171240383513219}}], 
   Line3DBox[{{9, 14, 7}, {9.013087036066981, 12.718372302500553`, 
     7.217391753498722}}], 
   Line3DBox[{{20, 14, 7}, {19.95446258641376, 12.71107587801203, 
     7.163097981966111}}], 
   Line3DBox[{{3, 15, 7}, {2.913077226170332, 13.723048185998755`, 
     7.227680688923508}}], 
   Line3DBox[{{14, 15, 7}, {14.108958107691683`, 13.723786434671588`, 
     7.222277003848787}}], 
   Line3DBox[{{25, 15, 7}, {24.85859543519956, 13.724022948916062`, 
     7.204663905368618}}], 
   Line3DBox[{{8, 16, 7}, {7.9915203711562635`, 14.722558421689573`, 
     7.240979480243526}}], 
   Line3DBox[{{19, 16, 7}, {18.98085814125664, 14.71851728065424, 
     7.217797220510371}}], 
   Line3DBox[{{2, 17, 7}, {1.910640515415102, 15.721668806061295`, 
     7.218824681235842}}], 
   Line3DBox[{{13, 17, 7}, {13.06657322826248, 15.721029181644269`, 
     7.223162835331478}}], 
   Line3DBox[{{24, 17, 7}, {23.935959001525216`, 15.712255456678342`, 
     7.166170820722682}}], 
   Line3DBox[{{7, 18, 7}, {6.9837584242526045`, 16.715646666996385`, 
     7.200431352886087}}], 
   Line3DBox[{{18, 18, 7}, {18.044760457348637`, 16.721687661797294`, 
     7.232194029761043}}], 
   Line3DBox[{{1, 19, 7}, {0.9283322845738445, 17.715593444413223`, 
     7.187519435076214}}], 
   Line3DBox[{{12, 19, 7}, {12.096320894801455`, 17.723854668242442`, 
     7.228419301850873}}], 
   Line3DBox[{{23, 19, 7}, {23.036305867036493`, 17.71535608807182, 
     7.195887476793696}}], 
   Line3DBox[{{6, 20, 7}, {5.996374190668729, 18.714868266413895`, 
     7.196018572682957}}], 
   Line3DBox[{{17, 20, 7}, {17.06819278239251, 18.726182508837315`, 
     7.250477032155779}}], 
   Line3DBox[{{0, 21, 7}, {-0.08176872426249018, 19.716208243213522`, 
     7.187596910794322}}], 
   Line3DBox[{{11, 21, 7}, {11.068193274637128`, 19.72311630561069, 
     7.234345275815368}}], 
   Line3DBox[{{22, 21, 7}, {22.04556776037297, 19.72385202877999, 
     7.243659464756953}}], 
   Line3DBox[{{5, 22, 7}, {5.007017470516366, 20.7144253612622, 
     7.19299897238517}}], 
   Line3DBox[{{16, 22, 7}, {16.039067151678385`, 20.723693823478243`, 
     7.2439596307427845`}}], 
   Line3DBox[{{27, 22, 7}, {27.076315881307945`, 20.726930452122776`, 
     7.2519321585821706`}}], 
   Line3DBox[{{10, 23, 7}, {10.046291125794557`, 21.712937826080857`, 
     7.176997435402891}}], 
   Line3DBox[{{21, 23, 7}, {21.058106705419846`, 21.72658246242535, 
     7.255012520834881}}], 
   Line3DBox[{{4, 24, 7}, {3.988528769060899, 22.71597538148171, 
     7.202852630990324}}], 
   Line3DBox[{{15, 24, 7}, {15.005566398956985`, 22.714555658761416`, 
     7.193911992358271}}], 
   Line3DBox[{{26, 24, 7}, {26.05851285574198, 22.724674054313915`, 
     7.245193755982518}}], 
   Line3DBox[{{9, 25, 7}, {9.026525796936905, 23.71153855086739, 
     7.170773171768761}}], 
   Line3DBox[{{20, 25, 7}, {19.99644386263784, 23.714852739616198`, 
     7.195918026263715}}], 
   Line3DBox[{{3, 26, 7}, {2.9428115496992877`, 24.707121984061004`, 
     7.123271720414068}}], 
   Line3DBox[{{14, 26, 7}, {13.96780813653439, 24.70475282832716, 
     7.106294158824081}}], 
   Line3DBox[{{25, 26, 7}, {25.06619731172588, 24.71750987162459, 
     7.202081633356142}}], 
   Line3DBox[{{8, 27, 7}, {7.996222522513615, 25.710990094645382`, 
     7.168639243835825}}], 
   Line3DBox[{{19, 27, 7}, {18.960512577554518`, 25.70345399037624, 
     7.086076642576907}}], 
   Line3DBox[{{2, 1, 8}, {2.0003371233457528`, -0.29828304438070385`, 
     8.066790890257733}}], 
   Line3DBox[{{13, 1, 8}, {12.93976179770122, -0.2890728207095399, 
     8.157043375828977}}], 
   Line3DBox[{{24, 1, 8}, {23.899417339603307`, -0.2922149127890945, 
     8.1003182316082}}], 
   Line3DBox[{{7, 2, 8}, {6.983152598066231, 0.7152617974829232, 
     8.19789875199524}}], 
   Line3DBox[{{18, 2, 8}, {17.9077577964448, 0.7130050092689908, 
     8.158541066341096}}], 
   Line3DBox[{{1, 3, 8}, {0.9696539627803841, 1.7101341800439076`, 
     8.159139198609468}}], 
   Line3DBox[{{12, 3, 8}, {11.965088862068955`, 1.7192979461337239`, 
     8.220416563967094}}], 
   Line3DBox[{{23, 3, 8}, {22.89325830569504, 1.7127483273298776`, 
     8.146933120517048}}], 
   Line3DBox[{{6, 4, 8}, {5.956140605450975, 2.724828475092946, 
     8.249025973697545}}], 
   Line3DBox[{{17, 4, 8}, {16.914665838770492`, 2.710748952594537, 
     8.143352075991851}}], 
   Line3DBox[{{0, 5, 8}, {-0.029534277254625343`, 3.7142736183068066`, 
     8.189829918308932}}], 
   Line3DBox[{{11, 5, 8}, {10.936920690558456`, 3.7183554155985385`, 
     8.208346250253713}}], 
   Line3DBox[{{22, 5, 8}, {21.918917945851256`, 3.721461932499638, 
     8.220830501623894}}], 
   Line3DBox[{{5, 6, 8}, {4.913970661619222, 4.723679670578728, 
     8.231528334429596}}], 
   Line3DBox[{{16, 6, 8}, {15.911414833990111`, 4.7063816176542135`, 
     8.09329603003382}}], 
   Line3DBox[{{27, 6, 8}, {26.862755159266335`, 4.709712311799596, 
     8.079508083679876}}], 
   Line3DBox[{{10, 7, 8}, {9.908611348445673, 5.720440370517259, 
     8.210654382734067}}], 
   Line3DBox[{{21, 7, 8}, {20.89459359216977, 5.71756147985674, 
     8.185043052398873}}], 
   Line3DBox[{{4, 8, 8}, {3.8998076735023965`, 6.720328591586363, 
     8.205918877715613}}], 
   Line3DBox[{{15, 8, 8}, {14.93616128591366, 6.7098036525901135`, 
     8.146006861872959}}], 
   Line3DBox[{{26, 8, 8}, {25.896297257004576`, 6.707474257873209, 
     8.092859824654226}}], 
   Line3DBox[{{9, 9, 8}, {8.882422429976353, 7.71832817356088, 
     8.183010503358533}}], 
   Line3DBox[{{20, 9, 8}, {19.912682510001744`, 7.71060446746799, 
     8.140836133953254}}], 
   Line3DBox[{{3, 10, 8}, {2.919647466303882, 8.719136647012341, 
     8.207201692323746}}], 
   Line3DBox[{{14, 10, 8}, {13.994357411156741`, 8.712915725255113, 
     8.182708048250694}}], 
   Line3DBox[{{25, 10, 8}, {24.95993042093019, 8.721554133874779, 
     8.232315725297495}}], 
   Line3DBox[{{8, 11, 8}, {7.902614200787744, 9.719761612923493, 
     8.203729424402894}}], 
   Line3DBox[{{19, 11, 8}, {18.91899697332638, 9.713541663461875, 
     8.168711167446837}}], 
   Line3DBox[{{2, 12, 8}, {1.9317910692088993`, 10.722739298846864`, 
     8.23227708249015}}], 
   Line3DBox[{{13, 12, 8}, {13.052988554440274`, 10.712058674129644`, 
     8.168521079434118}}], 
   Line3DBox[{{24, 12, 8}, {23.826096491001437`, 10.725040723446952`, 
     8.185030842535273}}], 
   Line3DBox[{{7, 13, 8}, {6.935421606700311, 11.722330553037445`, 
     8.23106366096214}}], 
   Line3DBox[{{18, 13, 8}, {17.99337973964878, 11.709126206793767`, 
     8.153626241789077}}], 
   Line3DBox[{{1, 14, 8}, {0.945198077070113, 12.72327821198265, 
     8.23870112116404}}], 
   Line3DBox[{{12, 14, 8}, {12.0931088040615, 12.715977551222995`, 
     8.180602053263351}}], 
   Line3DBox[{{23, 14, 8}, {22.922502538155467`, 12.706517684186224`, 
     8.104391772112024}}], 
   Line3DBox[{{6, 15, 8}, {5.966434101975642, 13.723784575229843`, 
     8.24524991349345}}], 
   Line3DBox[{{17, 15, 8}, {17.05394701573493, 13.716887872843468`, 
     8.201774598592435}}], 
   Line3DBox[{{0, 16, 8}, {-0.07223582569594052, 14.72195782648993, 
     8.226694040979654}}], 
   Line3DBox[{{11, 16, 8}, {11.08090769326204, 14.715797115913725`, 
     8.185140210855208}}], 
   Line3DBox[{{22, 16, 8}, {21.955748233911628`, 14.706522716624212`, 
     8.122304123351805}}], 
   Line3DBox[{{5, 17, 8}, {4.962118938112891, 15.717325957033395`, 
     8.208116132603916}}], 
   Line3DBox[{{16, 17, 8}, {16.084178887892556`, 15.719363007339398`, 
     8.207081645401956}}], 
   Line3DBox[{{27, 17, 8}, {27.019868973457438`, 15.724856605321541`, 
     8.252219243717926}}], 
   Line3DBox[{{10, 18, 8}, {10.08554712156361, 16.71193396381738, 
     8.15351734893807}}], 
   Line3DBox[{{21, 18, 8}, {21.005455278504606`, 16.71615267296806, 
     8.20422115661552}}], 
   Line3DBox[{{4, 19, 8}, {3.97824596794911, 17.71277201312717, 
     8.180474020016336}}], 
   Line3DBox[{{15, 19, 8}, {15.085678573532995`, 17.72197535762765, 
     8.22206349435775}}], 
   Line3DBox[{{26, 19, 8}, {26.17907312207784, 17.726391764903084`, 
     8.189353849822545}}], 
   Line3DBox[{{9, 20, 8}, {9.042375177460041, 18.709303631297946`, 
     8.149356044921381}}], 
   Line3DBox[{{20, 20, 8}, {20.070145100059623`, 18.723541764253692`, 
     8.236080573815489}}], 
   Line3DBox[{{3, 21, 8}, {2.959367696380656, 19.714849870156065`, 
     8.191672010645009}}], 
   Line3DBox[{{14, 21, 8}, {14.066557572110547`, 19.726150569536827`, 
     8.250754298275025}}], 
   Line3DBox[{{25, 21, 8}, {25.131893048440237`, 19.725666856401332`, 
     8.220633775517433}}], 
   Line3DBox[{{8, 22, 8}, {8.064474869729318, 20.712653005836717`, 
     8.16905829702249}}], 
   Line3DBox[{{19, 22, 8}, {19.025416748143897`, 20.728516117864107`, 
     8.269597341200596}}], 
   Line3DBox[{{2, 23, 8}, {1.9124530854543798`, 21.714854580974148`, 
     8.17531910822956}}], 
   Line3DBox[{{13, 23, 8}, {13.055143044389677`, 21.7200413069131, 
     8.220601424851955}}], 
   Line3DBox[{{24, 23, 8}, {24.082041998671315`, 21.726894344430804`, 
     8.249942193740363}}], 
   Line3DBox[{{7, 24, 8}, {7.068493731161642, 22.7170991504845, 
     8.198680696354636}}], 
   Line3DBox[{{18, 24, 8}, {18.008821363457752`, 22.717473771605476`, 
     8.212246689083393}}], 
   Line3DBox[{{1, 25, 8}, {0.9405072167980333, 23.706556522448984`, 
     8.116036973106068}}], 
   Line3DBox[{{12, 25, 8}, {12.007019312220253`, 23.712013648333663`, 
     8.176187080051829}}], 
   Line3DBox[{{23, 25, 8}, {23.06050196166346, 23.721561321764888`, 
     8.227890453128978}}], 
   Line3DBox[{{6, 26, 8}, {5.989676915481091, 24.713184927248996`, 
     8.184391980484078}}], 
   Line3DBox[{{17, 26, 8}, {16.984241260422095`, 24.704449494451467`, 
     8.106304043666523}}], 
   Line3DBox[{{0, 27, 8}, {0.06543423169163967, 25.703684627480545`, 
     8.072696741967395}}], 
   Line3DBox[{{11, 27, 8}, {10.97131186469485, 25.703805436370363`, 
     8.095166402210477}}], 
   Line3DBox[{{22, 27, 8}, {22.022156029211374`, 25.709610530418804`, 
     8.156218203688132}}], 
   Line3DBox[{{5, 1, 9}, {4.987829618131036, -0.29531341037237135`, 
     9.109613186773586}}], 
   Line3DBox[{{16, 1, 9}, {15.967219004760276`, -0.29430196610145076`, 
     9.117080429180168}}], 
   Line3DBox[{{27, 1, 9}, {26.946377205407728`, -0.2920095692343647, 
     9.133550997401546}}], 
   Line3DBox[{{10, 2, 9}, {9.968750489927944, 0.7212172937590122, 
     9.231815138287455}}], 
   Line3DBox[{{21, 2, 9}, {20.871865946953697`, 0.7142621709498926, 
     9.143038104711454}}], 
   Line3DBox[{{4, 3, 9}, {3.9477627114937186`, 1.7166731997534668`, 
     9.200857136936943}}], 
   Line3DBox[{{15, 3, 9}, {14.904579212995904`, 1.713788955890562, 
     9.16296018967351}}], 
   Line3DBox[{{26, 3, 9}, {25.901128759491485`, 1.707598138894599, 
     9.099608770756417}}], 
   Line3DBox[{{9, 4, 9}, {8.966307691215665, 2.7235742950092288`, 
     9.244135716288286}}], 
   Line3DBox[{{20, 4, 9}, {19.880220272630513`, 2.7175757995426655`, 
     9.17618452540634}}], 
   Line3DBox[{{3, 5, 9}, {2.9454505843398766`, 3.72279024464172, 
     9.236134711698178}}], 
   Line3DBox[{{14, 5, 9}, {13.921085095016945`, 3.713446939367833, 
     9.168978282478902}}], 
   Line3DBox[{{25, 5, 9}, {24.90667793337743, 3.7077993502167117`, 
     9.107277549286605}}], 
   Line3DBox[{{8, 6, 9}, {7.955314464169312, 4.720406788626618, 
     9.225043143185214}}], 
   Line3DBox[{{19, 6, 9}, {18.87317683399902, 4.714348188146445, 
     9.14496655905125}}], 
   Line3DBox[{{2, 7, 9}, {1.9708662364322675`, 5.722892996236779, 
     9.241140881559533}}], 
   Line3DBox[{{13, 7, 9}, {12.906286035227229`, 5.718975142835394, 
     9.200481939667814}}], 
   Line3DBox[{{24, 7, 9}, {23.938371105761654`, 5.706507552515709, 
     9.114364188870715}}], 
   Line3DBox[{{7, 8, 9}, {6.876126976804858, 6.720078109042598, 
     9.190933043689467}}], 
   Line3DBox[{{18, 8, 9}, {17.924875226807867`, 6.707214387232749, 
     9.114287479081632}}], 
   Line3DBox[{{1, 9, 9}, {0.9828637972845639, 7.718585568517448, 
     9.218365302520214}}], 
   Line3DBox[{{12, 9, 9}, {11.949917287480941`, 7.715208431232796, 
     9.191839377426637}}], 
   Line3DBox[{{23, 9, 9}, {22.991159746430665`, 7.7072798001085285`, 
     9.137099725416881}}], 
   Line3DBox[{{6, 10, 9}, {5.876321428086852, 8.71958708515968, 
     9.18774018845107}}], 
   Line3DBox[{{17, 10, 9}, {16.958583367506847`, 8.712519659783332, 
     9.175154320838805}}], 
   Line3DBox[{{0, 11, 9}, {-0.051899411989986585`, 9.723224990099583, 
     9.239064897316368}}], 
   Line3DBox[{{11, 11, 9}, {10.990439530948743`, 9.71148445902953, 
     9.17215196225747}}], 
   Line3DBox[{{22, 11, 9}, {21.95636674239979, 9.704818376931488, 
     9.102959711036934}}], 
   Line3DBox[{{5, 12, 9}, {4.916894962088997, 10.721731630200987`, 
     9.22163828064029}}], 
   Line3DBox[{{16, 12, 9}, {16.01216203686818, 10.716279991966758`, 
     9.204731594616833}}], 
   Line3DBox[{{27, 12, 9}, {26.706731736811474`, 10.864617291564155`, 
     8.438840636546736}}], 
   Line3DBox[{{10, 13, 9}, {10.013010619339873`, 11.714332884787165`, 
     9.192069759839235}}], 
   Line3DBox[{{21, 13, 9}, {20.963963235538323`, 11.703248531786757`, 
     9.084480656329907}}], 
   Line3DBox[{{4, 14, 9}, {3.968965476655304, 12.719946589546312`, 
     9.22472232809993}}], 
   Line3DBox[{{15, 14, 9}, {15.102773333745922`, 12.718836967940666`, 
     9.195086973310072}}], 
   Line3DBox[{{26, 14, 9}, {26.101415317896333`, 12.828855263117143`, 
     9.555099034918607}}], 
   Line3DBox[{{9, 15, 9}, {9.04065990263567, 13.716089624213437`, 
     9.19980220035141}}], 
   Line3DBox[{{20, 15, 9}, {20.00363418943457, 13.705538581040136`, 
     9.119818310335145}}], 
   Line3DBox[{{3, 16, 9}, {2.9432247879050575`, 14.719634331591505`, 
     9.217808012828833}}], 
   Line3DBox[{{14, 16, 9}, {14.121760261328399`, 14.71977553503822, 
     9.190262340137423}}], 
   Line3DBox[{{25, 16, 9}, {24.605679315369578`, 14.978444398346424`, 
     9.700667788900557}}], 
   Line3DBox[{{8, 17, 9}, {8.026845274481115, 15.71166707105579, 
     9.17169040577757}}], 
   Line3DBox[{{19, 17, 9}, {19.023506193323854`, 15.718806750070051`, 
     9.219069201873193}}], 
   Line3DBox[{{2, 18, 9}, {1.9758059854809757`, 16.715144882515073`, 
     9.196372036538428}}], 
   Line3DBox[{{13, 18, 9}, {13.06005614929944, 16.71694637265801, 
     9.200416187709202}}], 
   Line3DBox[{{24, 18, 9}, {24.00900604799763, 16.70159516367725, 
     9.063747722415467}}], 
   Line3DBox[{{7, 19, 9}, {7.03041083406407, 17.71135280804626, 
     9.168711575895879}}], 
   Line3DBox[{{18, 19, 9}, {18.060308250346907`, 17.729118007054858`, 
     9.26687426805122}}], 
   Line3DBox[{{1, 20, 9}, {0.9541936521201044, 18.712832429480425`, 
     9.176355957927822}}], 
   Line3DBox[{{12, 20, 9}, {12.06586401367775, 18.71981102404403, 
     9.21628249476798}}], 
   Line3DBox[{{23, 20, 9}, {23.123540032709013`, 18.722028611875302`, 
     9.203781725021871}}], 
   Line3DBox[{{6, 21, 9}, {6.029035069146389, 19.71633950237475, 
     9.203402781682467}}], 
   Line3DBox[{{17, 21, 9}, {17.041031181262376`, 19.7263466764446, 
     9.25714519937284}}], 
   Line3DBox[{{0, 22, 9}, {-0.09003242328584421, 20.715501759705134`, 
     9.178769218370133}}], 
   Line3DBox[{{11, 22, 9}, {11.068522819328225`, 20.718956424150246`, 
     9.210314003350682}}], 
   Line3DBox[{{22, 22, 9}, {22.10508114880218, 20.730285186745252`, 
     9.258422609629797}}], 
   Line3DBox[{{5, 23, 9}, {5.016735124901834, 21.72264119549734, 
     9.240986348480686}}], 
   Line3DBox[{{16, 23, 9}, {16.038489481239367`, 21.719867863290023`, 
     9.22311493091291}}], 
   Line3DBox[{{27, 23, 9}, {27.10180648597451, 21.720508177661127`, 
     9.206242856801087}}], 
   Line3DBox[{{10, 24, 9}, {10.038628624177333`, 22.715215696439884`, 
     9.194517666857585}}], 
   Line3DBox[{{21, 24, 9}, {21.02288855870933, 22.72316914091402, 
     9.243267488921084}}], 
   Line3DBox[{{4, 25, 9}, {3.994969247618406, 23.716802321521516`, 
     9.208274841202456}}], 
   Line3DBox[{{15, 25, 9}, {14.992185204980567`, 23.710554367642516`, 
     9.165132946963984}}], 
   Line3DBox[{{26, 25, 9}, {26.0635310195589, 23.713270886254854`, 
     9.174045963453446}}], 
   Line3DBox[{{9, 26, 9}, {8.990282980407164, 24.710935362017, 
     9.167981959245587}}], 
   Line3DBox[{{20, 26, 9}, {19.970750668237766`, 24.70830968486312, 
     9.143807532393312}}], 
   Line3DBox[{{3, 27, 9}, {2.943327123528922, 25.709541160565443`, 
     9.14664299777932}}], 
   Line3DBox[{{14, 27, 9}, {13.928286723683511`, 25.70571006347449, 
     9.098340053939143}}], 
   Line3DBox[{{25, 27, 9}, {25.0709815415749, 25.70807293921732, 
     9.12604003480276}}], 
   Line3DBox[{{8, 1, 10}, {7.9794698253851655`, -0.29102691837766503`, 
     10.151089403846049`}}], 
   Line3DBox[{{19, 1, 10}, {18.842782680878656`, -0.2861730434809233, 
     10.10507909778503}}], 
   Line3DBox[{{2, 2, 10}, {1.983956268087144, 0.7055851357549587, 
     10.11930112274325}}], 
   Line3DBox[{{13, 2, 10}, {12.923876656465394`, 0.7164825458905331, 
     10.191802454534516`}}], 
   Line3DBox[{{24, 2, 10}, {23.87854780570071, 0.706768847057297, 
     10.052939111801903`}}], 
   Line3DBox[{{7, 3, 10}, {6.97355660681923, 1.717310378770851, 
     10.209781034767467`}}], 
   Line3DBox[{{18, 3, 10}, {17.868553938723498`, 1.7152872364634604`, 
     10.149114211868621`}}], 
   Line3DBox[{{1, 4, 10}, {0.9847788972409396, 2.718446400824508, 
     10.217689435828063`}}], 
   Line3DBox[{{12, 4, 10}, {11.914956654267765`, 2.726890597100197, 
     10.248917812931847`}}], 
   Line3DBox[{{23, 4, 10}, {22.917497294715204`, 2.7075089985916136`, 
     10.112518064767556`}}], 
   Line3DBox[{{6, 5, 10}, {5.950665687889089, 3.722867411358549, 
     10.2376940821277}}], 
   Line3DBox[{{17, 5, 10}, {16.875600580596565`, 3.712549145613456, 
     10.130365187037972`}}], 
   Line3DBox[{{0, 6, 10}, {0.01919954805841973, 4.719535387770133, 
     10.22370014345406}}], 
   Line3DBox[{{11, 6, 10}, {10.935697773814951`, 4.72213665390994, 
     10.230066278335533`}}], 
   Line3DBox[{{22, 6, 10}, {21.92655915658392, 4.70867022357524, 
     10.13066694699546}}], 
   Line3DBox[{{5, 7, 10}, {4.905644997864939, 5.725519575593328, 
     10.238320753138035`}}], 
   Line3DBox[{{16, 7, 10}, {15.899473107877974`, 5.70828362065352, 
     10.10659802666235}}], 
   Line3DBox[{{27, 7, 10}, {26.890751316724543`, 5.704892976213621, 
     9.97238619653565}}], 
   Line3DBox[{{10, 8, 10}, {9.912123485283962, 6.721120493015445, 
     10.216205746399824`}}], 
   Line3DBox[{{21, 8, 10}, {20.950675062802173`, 6.705792619219768, 
     10.112224356110435`}}], 
   Line3DBox[{{4, 9, 10}, {3.9076991185182894`, 7.724469194016672, 
     10.233456013555491`}}], 
   Line3DBox[{{15, 9, 10}, {14.948226507072098`, 7.714658683384713, 
     10.187662476887965`}}], 
   Line3DBox[{{26, 9, 10}, {25.936232481706735`, 10.298224651560602`, 
     10.023376434524385`}}], 
   Line3DBox[{{9, 10, 10}, {8.920646245390225, 8.716034048243268, 
     10.187441767914095`}}], 
   Line3DBox[{{20, 10, 10}, {19.946407256430337`, 8.703612317047105, 
     10.080664696892129`}}], 
   Line3DBox[{{3, 11, 10}, {2.938306662371413, 9.726365862787125, 
     10.253081047528777`}}], 
   Line3DBox[{{14, 11, 10}, {14.032222137950727`, 9.711519733854859, 
     10.169647686634484`}}], 
   Line3DBox[{{25, 11, 10}, {25.50302356531519, 10.71887658114763, 
     11.165305503338224`}}], 
   Line3DBox[{{8, 12, 10}, {7.928363142980462, 10.718932428063216`, 
     10.209126843920984`}}], 
   Line3DBox[{{19, 12, 10}, {18.96902650434227, 10.70428179169789, 
     10.100771857386421`}}], 
   Line3DBox[{{4, 13, 10}, {3.9428044225831944`, 11.720743180068064`, 
     10.224121963630495`}}], 
   Line3DBox[{{15, 13, 10}, {15.05560794945285, 11.714879031013023`, 
     10.188074057295582`}}], 
   Line3DBox[{{0, 14, 10}, {-0.008858585939540569, 12.723441037326486`, 
     10.245598738337709`}}], 
   Line3DBox[{{11, 14, 10}, {11.043560469214748`, 12.713839276779632`, 
     10.184100732119814`}}], 
   Line3DBox[{{22, 14, 10}, {22.119830402661922`, 12.705579408190191`, 
     9.989229387360654}}], 
   Line3DBox[{{7, 15, 10}, {6.999019889418347, 13.718574698402287`, 
     10.21897085607098}}], 
   Line3DBox[{{18, 15, 10}, {18.039932199461308`, 13.713349979231163`, 
     10.181485931966455`}}], 
   Line3DBox[{{3, 16, 10}, {2.9790670334530738`, 14.718192704880664`, 
     10.215712468555703`}}], 
   Line3DBox[{{14, 16, 10}, {14.107754408313154`, 14.717159265840774`, 
     10.180855296496672`}}], 
   Line3DBox[{{25, 16, 10}, {25.11823532999838, 14.95955008050215, 
     10.770379368724978`}}], 
   Line3DBox[{{10, 17, 10}, {10.07373163341609, 15.708643750992247`, 
     10.130240870629846`}}], 
   Line3DBox[{{21, 17, 10}, {20.99445454631007, 15.70602230566194, 
     10.124863823819897`}}], 
   Line3DBox[{{4, 18, 10}, {3.98676918852881, 16.712422955618287`, 
     10.178802406049423`}}], 
   Line3DBox[{{15, 18, 10}, {15.043113182992823`, 16.71746282651745, 
     10.207941463127545`}}], 
   Line3DBox[{{26, 18, 10}, {27.099206735466268`, 17.3592502522972, 
     10.266803885886963`}}], 
   Line3DBox[{{9, 19, 10}, {9.061543523213894, 17.706725840174684`, 
     10.116851796214444`}}], 
   Line3DBox[{{20, 19, 10}, {20.030232961305607`, 17.720746538058194`, 
     10.229339373332607`}}], 
   Line3DBox[{{3, 20, 10}, {2.9850783551514253`, 18.71386145157127, 
     10.188745804617357`}}], 
   Line3DBox[{{14, 20, 10}, {14.056794925925733`, 18.71832959080737, 
     10.209988805866159`}}], 
   Line3DBox[{{25, 20, 10}, {25.277142923534036`, 18.73235868574442, 
     10.079229403174528`}}], 
   Line3DBox[{{8, 21, 10}, {8.021141945191312, 19.7076315919816, 
     10.139057240406643`}}], 
   Line3DBox[{{19, 21, 10}, {19.044173234194258`, 19.727807197691504`, 
     10.263769215670216`}}], 
   Line3DBox[{{2, 22, 10}, {1.9355630530688392`, 20.72122170746452, 
     10.224886545640757`}}], 
   Line3DBox[{{13, 22, 10}, {13.088437113013509`, 20.717626345457703`, 
     10.194156347250532`}}], 
   Line3DBox[{{24, 22, 10}, {24.16290190126466, 20.73109943875453, 
     10.230985575816522`}}], 
   Line3DBox[{{7, 23, 10}, {7.014329415229621, 21.712891938761523`, 
     10.182064566992324`}}], 
   Line3DBox[{{18, 23, 10}, {18.010418707183437`, 21.723491904540673`, 
     10.245801816037694`}}], 
   Line3DBox[{{1, 24, 10}, {0.9339198764140826, 22.714221742424495`, 
     10.180021358768823`}}], 
   Line3DBox[{{12, 24, 10}, {12.068861268954207`, 22.711870585250228`, 
     10.161185410302634`}}], 
   Line3DBox[{{23, 24, 10}, {23.10184665707722, 22.721419433272988`, 
     10.211799416501147`}}], 
   Line3DBox[{{6, 25, 10}, {6.003029364321065, 23.716517314029, 
     10.20655027902301}}], 
   Line3DBox[{{17, 25, 10}, {17.00544646731972, 23.71444003834003, 
     10.193147407361705`}}], 
   Line3DBox[{{0, 26, 10}, {0.035448971260091375`, 24.704368584385676`, 
     10.100412177099308`}}], 
   Line3DBox[{{11, 26, 10}, {10.951375883274277`, 24.70927872354291, 
     10.147221879398487`}}], 
   Line3DBox[{{22, 26, 10}, {22.008440555605567`, 24.709250548046384`, 
     10.154578812592495`}}], 
   Line3DBox[{{5, 27, 10}, {4.9904548649095055`, 25.710895613181055`, 
     10.167686523848092`}}], 
   Line3DBox[{{16, 27, 10}, {15.950272111146727`, 25.710259259800292`, 
     10.15522873490211}}], 
   Line3DBox[{{27, 27, 10}, {27.053654562141723`, 25.705715880790834`, 
     10.109315171519475`}}], 
   Line3DBox[{{10, 1, 11}, {9.926596466880778, -0.28231967269865343`, 
     11.200669325846363`}}], 
   Line3DBox[{{21, 1, 11}, {20.871840192696364`, -0.2916972446172035, 
     11.071367303719693`}}], 
   Line3DBox[{{4, 2, 11}, {3.9996907208061017`, 0.7068707605723386, 
     11.133479116282727`}}], 
   Line3DBox[{{15, 2, 11}, {14.9239866009234, 0.7094834682455513, 
     11.137073135330349`}}], 
   Line3DBox[{{26, 2, 11}, {25.914749626057976`, 0.7041138367368123, 
     11.058407410538043`}}], 
   Line3DBox[{{9, 3, 11}, {8.958457906597891, 1.7228889267229106`, 
     11.239293879965226`}}], 
   Line3DBox[{{20, 3, 11}, {19.876272409359242`, 1.713392955360808, 
     11.139046021155004`}}], 
   Line3DBox[{{3, 4, 11}, {2.9484085038785737`, 2.719472909872938, 
     11.218148318761965`}}], 
   Line3DBox[{{14, 4, 11}, {13.899772270819126`, 2.7211732333347403`, 
     11.211084113953945`}}], 
   Line3DBox[{{25, 4, 11}, {24.875444230437832`, 2.7067940340039787`, 
     11.045871448430082`}}], 
   Line3DBox[{{8, 5, 11}, {7.970845436570563, 3.7220726692960264`, 
     11.236752505522238`}}], 
   Line3DBox[{{19, 5, 11}, {18.912651590294402`, 3.7088933037634533`, 
     11.124152141564501`}}], 
   Line3DBox[{{2, 6, 11}, {1.9750624655583235`, 4.723144408678069, 
     11.24293603743762}}], 
   Line3DBox[{{13, 6, 11}, {12.916289975685062`, 4.719833130242455, 
     11.210155698005936`}}], 
   Line3DBox[{{24, 6, 11}, {23.88270814078117, 4.707511429374101, 
     11.075603667651851`}}], 
   Line3DBox[{{7, 7, 11}, {6.904820428981353, 5.727916168715584, 
     11.250486677181579`}}], 
   Line3DBox[{{18, 7, 11}, {17.90338542277578, 5.707609653617772, 
     11.10194516195392}}], 
   Line3DBox[{{1, 8, 11}, {0.997206126663498, 6.717780650906437, 
     11.214256236973064`}}], 
   Line3DBox[{{12, 8, 11}, {11.943943420698405`, 6.716645580076564, 
     11.199647421170384`}}], 
   Line3DBox[{{23, 8, 11}, {23.001694903126833`, 6.7028872825970325`, 
     11.086577858918325`}}], 
   Line3DBox[{{6, 9, 11}, {5.868257359747142, 7.729296085190803, 
     11.240739356208714`}}], 
   Line3DBox[{{17, 9, 11}, {16.899411998943872`, 7.712615212433929, 
     11.150074857277945`}}], 
   Line3DBox[{{0, 10, 11}, {-0.01460529992095762, 8.717460581663268, 
     11.211847411187142`}}], 
   Line3DBox[{{11, 10, 11}, {10.959262314351712`, 8.711244541926241, 
     11.16567984262763}}], 
   Line3DBox[{{22, 10, 11}, {22.007575133130405`, 11.29995836632194, 
     10.992868156784558`}}], 
   Line3DBox[{{5, 11, 11}, {4.924897642921045, 9.728042468799607, 
     11.257844283985099`}}], 
   Line3DBox[{{16, 11, 11}, {15.979001519280027`, 9.709584649382597, 
     11.156164293929244`}}], 
   Line3DBox[{{1, 12, 11}, {0.9746182071051547, 10.724927153742518`, 
     11.252081338710921`}}], 
   Line3DBox[{{12, 12, 11}, {12.019417755989926`, 10.710140144867568`, 
     11.16088662116551}}], 
   Line3DBox[{{23, 12, 11}, {23.926940698316802`, 11.151238609682594`, 
     11.33224244778538}}], 
   Line3DBox[{{9, 13, 11}, {8.96599826110815, 11.71498303068465, 
     11.193843417024988`}}], 
   Line3DBox[{{20, 13, 11}, {19.98220473499597, 11.70069901288013, 
     11.038733363044884`}}], 
   Line3DBox[{{6, 14, 11}, {5.9772694733506855`, 12.717627231171889`, 
     11.212140059692578`}}], 
   Line3DBox[{{17, 14, 11}, {17.030475875148845`, 12.712470781243908`, 
     11.177030313458577`}}], 
   Line3DBox[{{3, 15, 11}, {3.0133713733542478`, 13.717958560828976`, 
     11.214920810120637`}}], 
   Line3DBox[{{14, 15, 11}, {14.092824290847215`, 13.71615277345035, 
     11.181988873037572`}}], 
   Line3DBox[{{0, 16, 11}, {0.01902444282738908, 14.721078583381095`, 
     11.232374871035143`}}], 
   Line3DBox[{{11, 16, 11}, {11.03016740167934, 14.711123264627352`, 
     11.166993080368805`}}], 
   Line3DBox[{{22, 16, 11}, {22.039065778360207`, 14.706219585208588`, 
     11.120855712580228`}}], 
   Line3DBox[{{8, 17, 11}, {8.041809702631447, 15.707661890354824`, 
     11.134588852155757`}}], 
   Line3DBox[{{19, 17, 11}, {19.009775054572565`, 15.7181565803373, 
     11.216291229076768`}}], 
   Line3DBox[{{4, 18, 11}, {4.010157449297791, 16.710384656997753`, 
     11.163673740462436`}}], 
   Line3DBox[{{15, 18, 11}, {15.03218147716075, 16.717097882210055`, 
     11.207669229058688`}}], 
   Line3DBox[{{26, 18, 11}, {26.988395266426267`, 17.207936605763337`, 
     11.29276334609449}}], 
   Line3DBox[{{9, 19, 11}, {9.049005279957496, 17.706510304847836`, 
     11.120344883860714`}}], 
   Line3DBox[{{20, 19, 11}, {20.02179886357176, 17.72131219948641, 
     11.23341447762445}}], 
   Line3DBox[{{3, 20, 11}, {2.9910097375994367`, 18.712819387445215`, 
     11.181893501382161`}}], 
   Line3DBox[{{14, 20, 11}, {14.040943655013765`, 18.713842002212164`, 
     11.184719305543561`}}], 
   Line3DBox[{{25, 20, 11}, {24.66173442418568, 21.255203185209382`, 
     11.006431489658953`}}], 
   Line3DBox[{{8, 21, 11}, {7.993120528720866, 19.708624747571537`, 
     11.149340651834137`}}], 
   Line3DBox[{{19, 21, 11}, {19.041545671471493`, 19.726037742831224`, 
     11.25552715020408}}], 
   Line3DBox[{{2, 22, 11}, {1.931912252784014, 20.724524757845426`, 
     11.241923469985418`}}], 
   Line3DBox[{{13, 22, 11}, {13.079405833003491`, 20.71446485821026, 
     11.176335228779305`}}], 
   Line3DBox[{{24, 22, 11}, {24.153579228391457`, 20.726957363939395`, 
     11.213952955993953`}}], 
   Line3DBox[{{7, 23, 11}, {7.007761555171418, 21.709495607977868`, 
     11.156646648329623`}}], 
   Line3DBox[{{18, 23, 11}, {18.023616166436593`, 21.72088736316835, 
     11.230896381479727`}}], 
   Line3DBox[{{1, 24, 11}, {0.9431700423162435, 22.719549991019953`, 
     11.2172973318121}}], 
   Line3DBox[{{12, 24, 11}, {12.051457555510703`, 22.711086091325644`, 
     11.161409590813719`}}], 
   Line3DBox[{{23, 24, 11}, {23.101798576991108`, 22.716108345102647`, 
     11.176802907802779`}}], 
   Line3DBox[{{6, 25, 11}, {6.0090089683106465`, 23.714541783053342`, 
     11.19369050305654}}], 
   Line3DBox[{{17, 25, 11}, {17.009424708169963`, 23.717229370357934`, 
     11.210738431719527`}}], 
   Line3DBox[{{0, 26, 11}, {0.033528789956126195`, 24.70541216073503, 
     11.1136580251075}}], 
   Line3DBox[{{11, 26, 11}, {10.945331267171362`, 24.70847904812081, 
     11.137785922749693`}}], 
   Line3DBox[{{22, 26, 11}, {22.030174628436864`, 24.707028399475018`, 
     11.131582415369845`}}], 
   Line3DBox[{{5, 27, 11}, {5.018206842964736, 25.711206650072974`, 
     11.169352331112181`}}], 
   Line3DBox[{{16, 27, 11}, {15.957455210481797`, 25.715332191177122`, 
     11.194469951044049`}}], 
   Line3DBox[{{27, 27, 11}, {27.051086169039667`, 25.704228816658688`, 
     11.091472639379806`}}], 
   Line3DBox[{{10, 1, 12}, {9.915380979391793, -0.28357863501521474`, 
     12.187791131536574`}}], 
   Line3DBox[{{21, 1, 12}, {20.888250164715082`, -0.2936373003458521, 
     12.063360156783968`}}], 
   Line3DBox[{{4, 2, 12}, {4.00091001335242, 0.7079192099452507, 
     12.143270387195656`}}], 
   Line3DBox[{{15, 2, 12}, {14.912726184325841`, 0.7085666104599291, 
     12.12076043010323}}], 
   Line3DBox[{{26, 2, 12}, {25.907251058710283`, 0.7037723528833069, 
     12.034518411608259`}}], 
   Line3DBox[{{9, 3, 12}, {8.948589578216367, 1.721310769646536, 
     12.228715589127837`}}], 
   Line3DBox[{{20, 3, 12}, {19.903265356149255`, 1.7089644124440855`, 
     12.117768927749315`}}], 
   Line3DBox[{{3, 4, 12}, {2.9357196023634584`, 2.72144905299759, 
     12.226220039781909`}}], 
   Line3DBox[{{14, 4, 12}, {13.894638874952664`, 2.7215461161044616`, 
     12.210842832653075`}}], 
   Line3DBox[{{25, 4, 12}, {24.850139205731928`, 2.709158968411753, 
     12.035653520296503`}}], 
   Line3DBox[{{8, 5, 12}, {7.953230181600811, 3.722236324839115, 
     12.23480326770779}}], 
   Line3DBox[{{19, 5, 12}, {18.95038876383646, 3.705927742436458, 
     12.113647338071436`}}], 
   Line3DBox[{{2, 6, 12}, {1.972582249356246, 4.723412164772466, 
     12.244073279772111`}}], 
   Line3DBox[{{13, 6, 12}, {12.922854497003454`, 4.719434165826247, 
     12.210237284310582`}}], 
   Line3DBox[{{24, 6, 12}, {23.8780626099379, 4.706943435251998, 
     12.055999939883364`}}], 
   Line3DBox[{{7, 7, 12}, {6.901121399157005, 5.726918780906744, 
     12.243900044869536`}}], 
   Line3DBox[{{18, 7, 12}, {17.903989397038536`, 5.708112377722657, 
     12.108666165505033`}}], 
   Line3DBox[{{1, 8, 12}, {0.998224501725701, 6.717028150086504, 
     12.209714281667749`}}], 
   Line3DBox[{{12, 8, 12}, {11.955134464318498`, 6.715918447032003, 
     12.197791933696262`}}], 
   Line3DBox[{{23, 8, 12}, {22.987340084245538`, 6.702436734704872, 
     12.07854488582801}}], 
   Line3DBox[{{6, 9, 12}, {5.890599678555876, 7.729238339289698, 
     12.25138888467217}}], 
   Line3DBox[{{17, 9, 12}, {16.898925624833225`, 7.713167370975177, 
     12.15442070962701}}], 
   Line3DBox[{{0, 10, 12}, {-0.0034218396950221946`, 8.715363736958004, 
     12.199243475904726`}}], 
   Line3DBox[{{11, 10, 12}, {10.95451054674751, 8.71311006412442, 
     12.178451681373232`}}], 
   Line3DBox[{{22, 10, 12}, {21.98494175798122, 8.701069415349801, 
     11.949476880464527`}}], 
   Line3DBox[{{7, 11, 12}, {6.921188223341101, 9.723535360431637, 
     12.233295365988003`}}], 
   Line3DBox[{{18, 11, 12}, {17.92014795127355, 9.706855630911978, 
     12.106776828058017`}}], 
   Line3DBox[{{4, 12, 12}, {3.9617446440803663`, 10.721933271074088`, 
     12.234695471102622`}}], 
   Line3DBox[{{15, 12, 12}, {15.004987108456236`, 10.710052124717654`, 
     12.161274944749042`}}], 
   Line3DBox[{{2, 13, 12}, {1.9884156445141503`, 11.720934269414883`, 
     12.232070376288608`}}], 
   Line3DBox[{{13, 13, 12}, {13.022690009721948`, 11.70912609980607, 
     12.152084638464673`}}], 
   Line3DBox[{{0, 14, 12}, {0.03920312639880072, 12.721736142178134`, 
     12.233462255336747`}}], 
   Line3DBox[{{11, 14, 12}, {10.994357390411052`, 12.717731156205009`, 
     12.213903653988618`}}], 
   Line3DBox[{{22, 14, 12}, {21.945240629721, 12.70496148103318, 
     11.900618685061666`}}], 
   Line3DBox[{{9, 15, 12}, {8.996765493112502, 13.710012890458632`, 
     12.161005575003799`}}], 
   Line3DBox[{{20, 15, 12}, {20.01943499831966, 13.706680712692595`, 
     12.130182571487058`}}], 
   Line3DBox[{{7, 16, 12}, {7.024197103620539, 14.708390564213019`, 
     12.145463279085869`}}], 
   Line3DBox[{{18, 16, 12}, {18.003386679044958`, 14.717844410377406`, 
     12.2146289225724}}], 
   Line3DBox[{{5, 17, 12}, {5.037629144740114, 15.709564019592465`, 
     12.152836605352816`}}], 
   Line3DBox[{{16, 17, 12}, {16.019716467388243`, 15.723432004722332`, 
     12.244919199628129`}}], 
   Line3DBox[{{2, 18, 12}, {2.0351543264969605`, 16.713748284844375`, 
     12.185258464280993`}}], 
   Line3DBox[{{13, 18, 12}, {13.052761175956235`, 16.710800054876675`, 
     12.158681315238212`}}], 
   Line3DBox[{{24, 18, 12}, {24.23761287532104, 16.770782728530484`, 
     12.350092874824245`}}], 
   Line3DBox[{{9, 19, 12}, {9.030943607046938, 17.70661677549788, 
     12.127288364587757`}}], 
   Line3DBox[{{20, 19, 12}, {20.02339285742501, 17.72134188833544, 
     12.233422808859629`}}], 
   Line3DBox[{{3, 20, 12}, {2.995968304795964, 18.715193783944464`, 
     12.198133118430112`}}], 
   Line3DBox[{{14, 20, 12}, {14.026823437418173`, 18.7141147969391, 
     12.189155353490454`}}], 
   Line3DBox[{{25, 20, 12}, {25.35806273444496, 18.791909019810387`, 
     12.3198550637184}}], 
   Line3DBox[{{8, 21, 12}, {7.985661370599451, 19.710247193419843`, 
     12.162271690770517`}}], 
   Line3DBox[{{19, 21, 12}, {19.055493800332066`, 19.724549894400273`, 
     12.245249803772289`}}], 
   Line3DBox[{{2, 22, 12}, {1.9502531506267795`, 20.727062119172384`, 
     12.259141664985659`}}], 
   Line3DBox[{{13, 22, 12}, {13.054737944587366`, 20.714555250280625`, 
     12.1861062944697}}], 
   Line3DBox[{{24, 22, 12}, {24.128259706194722`, 20.721513906998645`, 
     12.197541787399473`}}], 
   Line3DBox[{{7, 23, 12}, {7.01490266960851, 21.709920247427206`, 
     12.15959994498828}}], 
   Line3DBox[{{18, 23, 12}, {18.047843490825134`, 21.71744607369766, 
     12.206800450947549`}}], 
   Line3DBox[{{1, 24, 12}, {0.9560685818961314, 22.7216862466975, 
     12.232344525696357`}}], 
   Line3DBox[{{12, 24, 12}, {12.03331454727641, 22.71003806677398, 
     12.157760425226211`}}], 
   Line3DBox[{{23, 24, 12}, {23.084063514136282`, 22.71274419579333, 
     12.160952850634285`}}], 
   Line3DBox[{{6, 25, 12}, {6.028211041433505, 23.712559113824433`, 
     12.178045223875039`}}], 
   Line3DBox[{{17, 25, 12}, {17.021615567063723`, 23.71943354641726, 
     12.22289532345709}}], 
   Line3DBox[{{0, 26, 12}, {0.03614996258827487, 24.707641315118007`, 
     12.136022828286123`}}], 
   Line3DBox[{{11, 26, 12}, {10.936411650451527`, 24.708785382108836`, 
     12.136825919861245`}}], 
   Line3DBox[{{22, 26, 12}, {22.04822568548266, 24.705221529092285`, 
     12.105938635698253`}}], 
   Line3DBox[{{5, 27, 12}, {5.047217006441668, 25.710162366677956`, 
     12.155207712336967`}}], 
   Line3DBox[{{16, 27, 12}, {15.980919949397949`, 25.71719543627581, 
     12.209877113943874`}}], 
   Line3DBox[{{27, 27, 12}, {27.049287149227226`, 25.704352336933926`, 
     12.094169581673057`}}], 
   Line3DBox[{{10, 1, 13}, {9.90047905640245, -0.2862351651453161, 
     13.160295607329257`}}], 
   Line3DBox[{{21, 1, 13}, {20.91122698994336, -0.2951149478984101, 
     13.069257666836117`}}], 
   Line3DBox[{{4, 2, 13}, {3.989224987709134, 0.7085121708576227, 
     13.148131989412287`}}], 
   Line3DBox[{{15, 2, 13}, {14.897601531941579`, 0.7084612263169185, 
     13.106967984988458`}}], 
   Line3DBox[{{26, 2, 13}, {25.89607836715259, 0.704356311715602, 
     13.022532803534634`}}], 
   Line3DBox[{{9, 3, 13}, {8.937812349449505, 1.7191100871679643`, 
     13.213198797661125`}}], 
   Line3DBox[{{20, 3, 13}, {19.926680614996545`, 1.7054422410315475`, 
     13.093511905537714`}}], 
   Line3DBox[{{3, 4, 13}, {2.9381329629819217`, 2.7218013498367926`, 
     13.22886826003524}}], 
   Line3DBox[{{14, 4, 13}, {13.87946637546002, 2.7247086727292276`, 
     13.221593492556094`}}], 
   Line3DBox[{{25, 4, 13}, {24.835427980519643`, 2.7105757723616923`, 
     13.017355448237106`}}], 
   Line3DBox[{{8, 5, 13}, {7.939617768665707, 3.7225222898422725`, 
     13.233248121512826`}}], 
   Line3DBox[{{19, 5, 13}, {18.968721988283477`, 3.7039878768123815`, 
     13.096820775321119`}}], 
   Line3DBox[{{2, 6, 13}, {1.9954322056426077`, 4.721162542918163, 
     13.233567749527138`}}], 
   Line3DBox[{{13, 6, 13}, {12.931517555926828`, 4.720758267808926, 
     13.221022047485189`}}], 
   Line3DBox[{{24, 6, 13}, {23.887368555407825`, 4.705301377491928, 
     13.032705268150286`}}], 
   Line3DBox[{{7, 7, 13}, {6.893341180484555, 5.724580954449936, 
     13.227881887098853`}}], 
   Line3DBox[{{18, 7, 13}, {17.908033382955484`, 5.707616866967303, 
     13.106244900122203`}}], 
   Line3DBox[{{1, 8, 13}, {1.0086261995777295`, 6.7158049983074255`, 
     13.201912818584294`}}], 
   Line3DBox[{{12, 8, 13}, {11.955812567916295`, 6.71704400569265, 
     13.20511310908055}}], 
   Line3DBox[{{23, 8, 13}, {22.95589504269826, 6.7014569837233315`, 
     13.042904400945638`}}], 
   Line3DBox[{{6, 9, 13}, {5.93131218209694, 7.726917720141951, 
     13.254054113100239`}}], 
   Line3DBox[{{17, 9, 13}, {16.90761318807477, 7.71051714571499, 
     13.136742990633063`}}], 
   Line3DBox[{{0, 10, 13}, {0.007738860624384059, 8.7147266645034, 
     13.194968107898912`}}], 
   Line3DBox[{{11, 10, 13}, {10.946467977901378`, 8.71528670739692, 
     13.191431654694275`}}], 
   Line3DBox[{{22, 10, 13}, {21.927732703357535`, 8.702660263371307, 
     12.958926339337943`}}], 
   Line3DBox[{{7, 11, 13}, {6.93692428035354, 9.721976676370714, 
     13.22951653066965}}], 
   Line3DBox[{{18, 11, 13}, {17.9102608253893, 9.706872889352168, 
     13.098839042122949`}}], 
   Line3DBox[{{4, 12, 13}, {3.985845783132603, 10.719705552426518`, 
     13.225046185609495`}}], 
   Line3DBox[{{15, 12, 13}, {14.985159253089458`, 10.710291093331946`, 
     13.162575177355674`}}], 
   Line3DBox[{{2, 13, 13}, {2.002722544454285, 11.718432132563185`, 
     13.218120124943002`}}], 
   Line3DBox[{{13, 13, 13}, {12.977408691066628`, 11.711131800982015`, 
     13.168250997978653`}}], 
   Line3DBox[{{0, 14, 13}, {0.05354449780919002, 12.71763706037896, 
     13.206587216063452`}}], 
   Line3DBox[{{11, 14, 13}, {10.97084162642626, 12.716982486164833`, 
     13.207402624001622`}}], 
   Line3DBox[{{22, 14, 13}, {22.166226011336363`, 15.289321099569916`, 
     13.00447385281681}}], 
   Line3DBox[{{9, 15, 13}, {8.971420783501337, 13.71063365298832, 
     13.163455350411299`}}], 
   Line3DBox[{{20, 15, 13}, {20.008592094492002`, 13.708521217123165`, 
     13.14835339325815}}], 
   Line3DBox[{{7, 16, 13}, {7.02172622354245, 14.707858104006364`, 
     13.141057760610877`}}], 
   Line3DBox[{{18, 16, 13}, {17.99384274510759, 14.717862806818832`, 
     13.214677213680696`}}], 
   Line3DBox[{{5, 17, 13}, {5.044658423450633, 15.710913215991894`, 
     13.162052116649381`}}], 
   Line3DBox[{{16, 17, 13}, {16.00600285926694, 15.725517441206364`, 
     13.256238508057333`}}], 
   Line3DBox[{{2, 18, 13}, {2.023517453149762, 16.71391737826771, 
     13.188250948139839`}}], 
   Line3DBox[{{13, 18, 13}, {13.029955825364912`, 16.710217606155293`, 
     13.159887538773104`}}], 
   Line3DBox[{{24, 18, 13}, {23.099984373236495`, 17.63879170331691, 
     13.865736933478523`}}], 
   Line3DBox[{{9, 19, 13}, {9.021591986930336, 17.70639922364347, 
     13.127007155350316`}}], 
   Line3DBox[{{20, 19, 13}, {20.03447222592429, 17.721787104477922`, 
     13.234485520578325`}}], 
   Line3DBox[{{3, 20, 13}, {3.010711702064912, 18.72094337546807, 
     13.232162466130635`}}], 
   Line3DBox[{{14, 20, 13}, {14.016057825038509`, 18.714381204288774`, 
     13.192162583166056`}}], 
   Line3DBox[{{25, 20, 13}, {25.396671352723114`, 18.77669812356429, 
     13.190221862670121`}}], 
   Line3DBox[{{8, 21, 13}, {7.986405675205999, 19.713939862694833`, 
     13.189379295510387`}}], 
   Line3DBox[{{19, 21, 13}, {19.08425030129291, 19.722973943246323`, 
     13.228268125466968`}}], 
   Line3DBox[{{2, 22, 13}, {1.978099881418444, 20.730513033316264`, 
     13.279147319933838`}}], 
   Line3DBox[{{13, 22, 13}, {13.042496150229816`, 20.716811825679688`, 
     13.204015162427082`}}], 
   Line3DBox[{{24, 22, 13}, {24.101851797229596`, 20.717531934015234`, 
     13.186820424821263`}}], 
   Line3DBox[{{7, 23, 13}, {7.017696328338548, 21.711884773296518`, 
     13.174487829655744`}}], 
   Line3DBox[{{18, 23, 13}, {18.075210457220543`, 21.716027049254002`, 
     13.189094814517201`}}], 
   Line3DBox[{{1, 24, 13}, {0.9930278399189275, 22.72264652577445, 
     13.241494287443253`}}], 
   Line3DBox[{{12, 24, 13}, {12.01412012899869, 22.710913282501703`, 
     13.167499423063264`}}], 
   Line3DBox[{{23, 24, 13}, {23.074243325623232`, 22.711341372157715`, 
     13.154424316375506`}}], 
   Line3DBox[{{6, 25, 13}, {6.032342835877597, 23.711616689321527`, 
     13.170359577754155`}}], 
   Line3DBox[{{17, 25, 13}, {17.04214618375263, 23.720782875023083`, 
     13.22765598248428}}], 
   Line3DBox[{{0, 26, 13}, {0.031224157356452998`, 24.710042672146578`, 
     13.158224980058902`}}], 
   Line3DBox[{{11, 26, 13}, {10.919022863659924`, 24.709258965068805`, 
     13.132023801395453`}}], 
   Line3DBox[{{22, 26, 13}, {22.05757883894182, 24.7044960185423, 
     13.091400827859294`}}], 
   Line3DBox[{{5, 27, 13}, {5.057472376756822, 25.708954781880248`, 
     13.141064420319386`}}], 
   Line3DBox[{{16, 27, 13}, {15.990580614414943`, 25.715800941608485`, 
     13.201851563287342`}}], 
   Line3DBox[{{27, 27, 13}, {27.05140316563244, 25.705504828079516`, 
     13.107888666863188`}}], 
   Line3DBox[{{10, 1, 14}, {9.873630970897496, -0.2875857271735758, 
     14.127097850739437`}}], 
   Line3DBox[{{21, 1, 14}, {20.930557224044733`, -0.2958788205795324, 
     14.0766536577146}}], 
   Line3DBox[{{4, 2, 14}, {3.974529894359878, 0.7087477726157416, 
     14.14838786673402}}], 
   Line3DBox[{{15, 2, 14}, {14.88547827348251, 0.7092483858036831, 
     14.104139543906514`}}], 
   Line3DBox[{{26, 2, 14}, {25.895742475088777`, 0.7044790385902036, 
     14.02749194513348}}], 
   Line3DBox[{{9, 3, 14}, {8.917538829393418, 1.718707013510708, 
     14.203687108368554`}}], 
   Line3DBox[{{20, 3, 14}, {19.938092303115543`, 1.704370948101703, 
     14.086676392077559`}}], 
   Line3DBox[{{3, 4, 14}, {2.947986789948672, 2.720275156803666, 
     14.222708220966979`}}], 
   Line3DBox[{{14, 4, 14}, {13.854056568130975`, 2.725674831954546, 
     14.211650373919387`}}], 
   Line3DBox[{{25, 4, 14}, {24.837203986175073`, 2.7103737304384317`, 
     14.019014277252344`}}], 
   Line3DBox[{{8, 5, 14}, {7.9256033797219665`, 3.723262595397731, 
     14.233252529634019`}}], 
   Line3DBox[{{19, 5, 14}, {18.970314750250772`, 3.703886148283244, 
     14.095956601311642`}}], 
   Line3DBox[{{2, 6, 14}, {2.0161075781754576`, 4.7198114300394485`, 
     14.225516676251845`}}], 
   Line3DBox[{{13, 6, 14}, {12.914866125512445`, 4.722190729390708, 
     14.22350769865865}}], 
   Line3DBox[{{24, 6, 14}, {23.89476217632603, 4.704542695354893, 
     14.026746444810458`}}], 
   Line3DBox[{{7, 7, 14}, {6.9006118451883705`, 5.722510825689972, 
     14.219416052748706`}}], 
   Line3DBox[{{18, 7, 14}, {17.896982546778986`, 5.7087905810669035`, 
     14.110297963672554`}}], 
   Line3DBox[{{1, 8, 14}, {1.015487080716322, 6.714621811736202, 
     14.193811928081224`}}], 
   Line3DBox[{{12, 8, 14}, {11.956682827414399`, 6.717264846229827, 
     14.206674013464196`}}], 
   Line3DBox[{{23, 8, 14}, {23.038558685500167`, 9.298923582044777, 
     13.963795638654117`}}], 
   Line3DBox[{{6, 9, 14}, {5.971186299129315, 7.720997450209916, 
     14.230916106568165`}}], 
   Line3DBox[{{17, 9, 14}, {16.89149259142896, 7.710922552851142, 
     14.128473645302764`}}], 
   Line3DBox[{{0, 10, 14}, {0.016845431325698365`, 8.714465814102432, 
     14.192660552091317`}}], 
   Line3DBox[{{11, 10, 14}, {10.941063507358223`, 8.715624978165895, 
     14.192112709427896`}}], 
   Line3DBox[{{22, 10, 14}, {21.910086733163283`, 8.70318890473274, 
     13.985979028618537`}}], 
   Line3DBox[{{7, 11, 14}, {6.954646095788533, 9.717785628868267, 
     14.209450065256695`}}], 
   Line3DBox[{{18, 11, 14}, {17.898404099308138`, 9.709219677731037, 
     14.116466444119496`}}], 
   Line3DBox[{{4, 12, 14}, {4.0031201469246005`, 10.719346310746298`, 
     14.223419768337658`}}], 
   Line3DBox[{{15, 12, 14}, {14.958601436294362`, 10.713879095222282`, 
     14.1848761131592}}], 
   Line3DBox[{{2, 13, 14}, {2.0182776266151796`, 11.716849948217193`, 
     14.207826545405284`}}], 
   Line3DBox[{{13, 13, 14}, {12.941328160859086`, 11.714024909843795`, 
     14.181178593629499`}}], 
   Line3DBox[{{0, 14, 14}, {0.06239413359009639, 12.71632931041089, 
     14.195694999382606`}}], 
   Line3DBox[{{11, 14, 14}, {10.957615177952553`, 12.716062401926168`, 
     14.199268088545066`}}], 
   Line3DBox[{{22, 14, 14}, {21.79145325592338, 12.722028207039552`, 
     14.115309808483476`}}], 
   Line3DBox[{{9, 15, 14}, {8.962768308146849, 13.711409336377042`, 
     14.16777336721154}}], 
   Line3DBox[{{20, 15, 14}, {19.992062383291124`, 13.710607448313347`, 
     14.165541058036858`}}], 
   Line3DBox[{{7, 16, 14}, {7.020058428581096, 14.709972963464619`, 
     14.159461294521899`}}], 
   Line3DBox[{{18, 16, 14}, {17.983865722764886`, 14.720250431817366`, 
     14.227992824085456`}}], 
   Line3DBox[{{5, 17, 14}, {5.043936143624011, 15.71053552911463, 
     14.159219953547801`}}], 
   Line3DBox[{{16, 17, 14}, {15.992893978247952`, 15.725138380232728`, 
     14.254317429405118`}}], 
   Line3DBox[{{2, 18, 14}, {2.0216833343639746`, 16.714712281204484`, 
     14.193817731191658`}}], 
   Line3DBox[{{13, 18, 14}, {13.006905329812854`, 16.71098635013726, 
     14.16851150372518}}], 
   Line3DBox[{{24, 18, 14}, {23.42841708344548, 17.208501433905695`, 
     14.858383940538085`}}], 
   Line3DBox[{{9, 19, 14}, {9.013297872109629, 17.707391615866502`, 
     14.137792350532031`}}], 
   Line3DBox[{{20, 19, 14}, {20.03066904973623, 17.722512339160428`, 
     14.238924016772936`}}], 
   Line3DBox[{{3, 20, 14}, {3.0132285689144327`, 18.72279160607803, 
     14.241999428635149`}}], 
   Line3DBox[{{14, 20, 14}, {14.003466244478798`, 18.71352723204349, 
     14.187018187499305`}}], 
   Line3DBox[{{25, 20, 14}, {25.17974002047841, 18.72894984802818, 
     14.205243845731937`}}], 
   Line3DBox[{{8, 21, 14}, {8.000251342428257, 19.71873231365069, 
     14.219893275804587`}}], 
   Line3DBox[{{19, 21, 14}, {19.100224997616913`, 19.72021762448731, 
     14.205212137018721`}}], 
   Line3DBox[{{2, 22, 14}, {2.002058377158417, 20.733783139322597`, 
     14.294432716965591`}}], 
   Line3DBox[{{13, 22, 14}, {13.03567621624352, 20.717789714879054`, 
     14.211338572732487`}}], 
   Line3DBox[{{24, 22, 14}, {24.0994088212813, 20.71507926935451, 
     14.170577261699574`}}], 
   Line3DBox[{{7, 23, 14}, {7.020347812115019, 21.71458813819429, 
     14.193138064791269`}}], 
   Line3DBox[{{18, 23, 14}, {18.10363799592226, 21.7180703461938, 
     14.189513926911829`}}], 
   Line3DBox[{{1, 24, 14}, {1.009080584775818, 22.72379339247996, 
     14.247415112518043`}}], 
   Line3DBox[{{12, 24, 14}, {12.002400082698978`, 22.714149473986666`, 
     14.191265951894907`}}], 
   Line3DBox[{{23, 24, 14}, {23.08067756186364, 22.71094776951013, 
     14.147768325702195`}}], 
   Line3DBox[{{6, 25, 14}, {6.032314874707359, 23.710734078337243`, 
     14.163551619104592`}}], 
   Line3DBox[{{17, 25, 14}, {17.063531744398652`, 23.72065310253508, 
     14.221890138132697`}}], 
   Line3DBox[{{0, 26, 14}, {0.014843245618607484`, 24.710367399746648`, 
     14.163179148249055`}}], 
   Line3DBox[{{11, 26, 14}, {10.914153006405519`, 24.709270668709866`, 
     14.129027466215964`}}], 
   Line3DBox[{{22, 26, 14}, {22.06902044605818, 24.704182749432153`, 
     14.078062994797255`}}], 
   Line3DBox[{{5, 27, 14}, {5.057222236542504, 25.708776519123685`, 
     14.139526119700681`}}], 
   Line3DBox[{{16, 27, 14}, {15.969815949831359`, 25.71216956044324, 
     14.174876190679164`}}], 
   Line3DBox[{{27, 27, 14}, {27.04761734982366, 25.7065350307025, 
     14.1211650163867}}], 
   Line3DBox[{{10, 1, 15}, {9.851515035204535, -0.2872834118926815, 
     15.104180769317692`}}], 
   Line3DBox[{{21, 1, 15}, {20.941653850475458`, -0.2963028172917299, 
     15.078706624353888`}}], 
   Line3DBox[{{4, 2, 15}, {3.9681446605212938`, 0.7095687754069364, 
     15.154183306301114`}}], 
   Line3DBox[{{15, 2, 15}, {14.879429993057393`, 0.709001960958431, 
     15.093738661269953`}}], 
   Line3DBox[{{26, 2, 15}, {25.907702379081265`, 0.7040796299834389, 
     15.045514214800217`}}], 
   Line3DBox[{{9, 3, 15}, {8.902160260776235, 1.7192378695305586`, 
     15.200189286886195`}}], 
   Line3DBox[{{20, 3, 15}, {19.96336653366277, 1.7036075555564727`, 
     15.089580238523101`}}], 
   Line3DBox[{{3, 4, 15}, {2.958853597172074, 2.721258474670723, 
     15.230493134242382`}}], 
   Line3DBox[{{14, 4, 15}, {13.841873712042496`, 2.7241576260040157`, 
     15.192930852310024`}}], 
   Line3DBox[{{25, 4, 15}, {24.85626020457529, 2.70832336284034, 
     15.03017177865449}}], 
   Line3DBox[{{8, 5, 15}, {7.9232860740856905`, 3.725843779979795, 
     15.246253732062351`}}], 
   Line3DBox[{{19, 5, 15}, {18.967279418666138`, 3.7035220149451646`, 
     15.089856540247931`}}], 
   Line3DBox[{{2, 6, 15}, {2.0180057522061863`, 4.720373074193194, 
     15.228540420139883`}}], 
   Line3DBox[{{13, 6, 15}, {12.897115859743918`, 4.723142783505505, 
     15.221473480059574`}}], 
   Line3DBox[{{24, 6, 15}, {23.897412877669407`, 4.704470631726847, 
     15.032856327757278`}}], 
   Line3DBox[{{7, 7, 15}, {6.9111202720159435`, 5.720833419122371, 
     15.214087020436358`}}], 
   Line3DBox[{{18, 7, 15}, {17.88271967696312, 5.710841837753933, 
     15.119651822145375`}}], 
   Line3DBox[{{1, 8, 15}, {1.0242885972554936`, 6.712562055884221, 
     15.178643791088009`}}], 
   Line3DBox[{{12, 8, 15}, {11.948399605823223`, 6.716760571318813, 
     15.201578689346825`}}], 
   Line3DBox[{{23, 8, 15}, {23.0336934856556, 9.298644081714654, 
     14.95112978359083}}], 
   Line3DBox[{{6, 9, 15}, {5.994179998771299, 7.71506566020579, 
     15.19725584909785}}], 
   Line3DBox[{{17, 9, 15}, {16.872166609697047`, 7.711699232796429, 
     15.118066750384438`}}], 
   Line3DBox[{{0, 10, 15}, {0.012137331537146733`, 8.71228974254302, 
     15.177918458916526`}}], 
   Line3DBox[{{11, 10, 15}, {10.944841775935465`, 8.715229253638979, 
     15.190582527040101`}}], 
   Line3DBox[{{22, 10, 15}, {22.092572241860033`, 11.296540483412866`, 
     14.979673787648927`}}], 
   Line3DBox[{{7, 11, 15}, {6.978922863215611, 9.712681399746726, 
     15.179907130895145`}}], 
   Line3DBox[{{18, 11, 15}, {17.89061174567524, 9.711902210772491, 
     15.137252669201672`}}], 
   Line3DBox[{{4, 12, 15}, {4.031906071374596, 10.716439705640305`, 
     15.203604944322805`}}], 
   Line3DBox[{{15, 12, 15}, {14.93482195360185, 10.718488443389557`, 
     15.208518470504654`}}], 
   Line3DBox[{{2, 13, 15}, {2.037494650805421, 11.715893353493012`, 
     15.19915891031424}}], 
   Line3DBox[{{13, 13, 15}, {12.931075684526652`, 11.717223120395149`, 
     15.199331171390149`}}], 
   Line3DBox[{{0, 14, 15}, {0.07520539409626613, 12.717056328325802`, 
     15.195958373156015`}}], 
   Line3DBox[{{11, 14, 15}, {10.942737360231952`, 12.717110320404606`, 
     15.202274714372365`}}], 
   Line3DBox[{{22, 14, 15}, {21.874221925581676`, 12.71648233393673, 
     15.163591799608394`}}], 
   Line3DBox[{{9, 15, 15}, {8.966783911112264, 13.71124845021139, 
     15.167380208974823`}}], 
   Line3DBox[{{20, 15, 15}, {19.99659562941056, 13.712125453905028`, 
     15.177108903733155`}}], 
   Line3DBox[{{7, 16, 15}, {7.035210042768043, 14.711439492778252`, 
     15.168440114333574`}}], 
   Line3DBox[{{18, 16, 15}, {17.97806522451982, 14.722436339877534`, 
     15.23947851669643}}], 
   Line3DBox[{{5, 17, 15}, {5.031615128137066, 15.710152470264239`, 
     15.159040352450042`}}], 
   Line3DBox[{{16, 17, 15}, {15.993848476369429`, 15.727972620222106`, 
     15.268157610096017`}}], 
   Line3DBox[{{2, 18, 15}, {2.025956772027461, 16.716973663581804`, 
     15.207773111935154`}}], 
   Line3DBox[{{13, 18, 15}, {13.000342418399626`, 16.71118157244241, 
     15.170138013205806`}}], 
   Line3DBox[{{24, 18, 15}, {23.446043037496235`, 16.88358556750585, 
     15.369797915911334`}}], 
   Line3DBox[{{9, 19, 15}, {9.012321169463684, 17.710081913746286`, 
     15.161119581487187`}}], 
   Line3DBox[{{20, 19, 15}, {20.02671203385025, 17.721655370262575`, 
     15.234779630438984`}}], 
   Line3DBox[{{3, 20, 15}, {3.011123966130094, 18.72370689155814, 
     15.246884909869676`}}], 
   Line3DBox[{{14, 20, 15}, {14.008623020463919`, 18.713117686393026`, 
     15.184009658560738`}}], 
   Line3DBox[{{25, 20, 15}, {24.827099910454447`, 21.26557196418693, 
     14.758270476566938`}}], 
   Line3DBox[{{8, 21, 15}, {8.00057560080794, 19.719698672340076`, 
     15.225451056941289`}}], 
   Line3DBox[{{19, 21, 15}, {19.09742176627705, 19.716630040792346`, 
     15.182949575727314`}}], 
   Line3DBox[{{2, 22, 15}, {2.0189646481552987`, 20.73306934969432, 
     15.290735394192671`}}], 
   Line3DBox[{{13, 22, 15}, {13.037118786066197`, 20.717137427957187`, 
     15.20708891079116}}], 
   Line3DBox[{{24, 22, 15}, {24.089585930613286`, 20.713885347010432`, 
     15.166983413552597`}}], 
   Line3DBox[{{7, 23, 15}, {7.014783317326094, 21.71861364897378, 
     15.218701789961916`}}], 
   Line3DBox[{{18, 23, 15}, {18.110641090749127`, 21.716818505455528`, 
     15.176645976734434`}}], 
   Line3DBox[{{1, 24, 15}, {1.0175622707836514`, 22.724239145566813`, 
     15.249250494364247`}}], 
   Line3DBox[{{12, 24, 15}, {11.991743516419398`, 22.715749314726143`, 
     15.201573827300356`}}], 
   Line3DBox[{{23, 24, 15}, {23.081212423094346`, 22.7115272236005, 
     15.15245473693036}}], 
   Line3DBox[{{6, 25, 15}, {6.03433170577728, 23.712153908469702`, 
     15.173993616286802`}}], 
   Line3DBox[{{17, 25, 15}, {17.066693117010225`, 23.719881573087314`, 
     15.216445931405634`}}], 
   Line3DBox[{{0, 26, 15}, {-0.019816843536891414`, 24.71233873286388, 
     15.177583089931556`}}], 
   Line3DBox[{{11, 26, 15}, {10.915557059104389`, 24.710521099501477`, 
     15.141822265184349`}}], 
   Line3DBox[{{22, 26, 15}, {22.079482737891325`, 24.704106979291666`, 
     15.06590730806771}}], 
   Line3DBox[{{5, 27, 15}, {5.0573286877393695`, 25.709719307285507`, 
     15.147949841400015`}}], 
   Line3DBox[{{16, 27, 15}, {15.956189476359386`, 25.71051674356443, 
     15.159102386502056`}}], 
   Line3DBox[{{27, 27, 15}, {27.042061647753606`, 25.70831538959912, 
     15.14064737836797}}], 
   Line3DBox[{{10, 1, 16}, {9.844352062578077, -0.28719051568205733`, 
     16.0944155491138}}], 
   Line3DBox[{{21, 1, 16}, {20.95420588972358, -0.2973159951895048, 
     16.069814812822603`}}], 
   Line3DBox[{{4, 2, 16}, {3.9695414802479188`, 0.7121327292937703, 
     16.174557072667362`}}], 
   Line3DBox[{{15, 2, 16}, {14.883685838971166`, 0.7081054514577898, 
     16.086484052813663`}}], 
   Line3DBox[{{26, 2, 16}, {25.923050824716658`, 0.7038250071267211, 
     16.06331834073292}}], 
   Line3DBox[{{9, 3, 16}, {8.879394325673161, 1.7224321478891143`, 
     16.208025610377536`}}], 
   Line3DBox[{{20, 3, 16}, {19.960516144661387`, 1.7039512855604404`, 
     16.093267116215547`}}], 
   Line3DBox[{{3, 4, 16}, {2.976627371490644, 2.7233816285720662`, 
     16.24433430780235}}], 
   Line3DBox[{{14, 4, 16}, {13.836363372488542`, 2.72406999766365, 
     16.187685064069143`}}], 
   Line3DBox[{{25, 4, 16}, {24.873082518343452`, 2.707120726371184, 
     16.04852975037011}}], 
   Line3DBox[{{8, 5, 16}, {7.919606616070491, 3.7270923548991415`, 
     16.251481671030216`}}], 
   Line3DBox[{{19, 5, 16}, {18.954149852575984`, 3.7041914079111593`, 
     16.093690216404557`}}], 
   Line3DBox[{{2, 6, 16}, {2.0146364366919722`, 4.7215567754600585`, 
     16.23530553828773}}], 
   Line3DBox[{{13, 6, 16}, {12.885724036602797`, 4.723939446483819, 
     16.22047781736406}}], 
   Line3DBox[{{24, 6, 16}, {23.890024086633943`, 4.70560208554346, 
     16.04938965002774}}], 
   Line3DBox[{{7, 7, 16}, {6.91610104370515, 5.719327945720233, 
     16.20697839143127}}], 
   Line3DBox[{{18, 7, 16}, {17.87313441935826, 5.712490696757518, 
     16.127377072161728`}}], 
   Line3DBox[{{1, 8, 16}, {1.0144390093993085`, 6.711873665683008, 
     16.174705643430986`}}], 
   Line3DBox[{{12, 8, 16}, {11.934558908641375`, 6.716846709706273, 
     16.198078512641256`}}], 
   Line3DBox[{{23, 8, 16}, {22.96197096501821, 6.702718241310363, 
     16.07492550346495}}], 
   Line3DBox[{{6, 9, 16}, {5.987971013009619, 7.712194402396403, 
     16.177234438676084`}}], 
   Line3DBox[{{17, 9, 16}, {16.863582973542492`, 7.713818862795929, 
     16.130875808279967`}}], 
   Line3DBox[{{0, 10, 16}, {-0.011104431287029736`, 8.712108291929088, 
     16.176668163198645`}}], 
   Line3DBox[{{11, 10, 16}, {10.943375961056823`, 8.713982666295966, 
     16.181529985474935`}}], 
   Line3DBox[{{22, 10, 16}, {21.941068616807204`, 8.702546828486872, 
     16.056056755217472`}}], 
   Line3DBox[{{7, 11, 16}, {6.991554753274401, 9.710170869191636, 
     16.1620786572189}}], 
   Line3DBox[{{18, 11, 16}, {17.89691997419306, 9.713832997743848, 
     16.158584206612968`}}], 
   Line3DBox[{{4, 12, 16}, {4.047033888368361, 10.714688783614486`, 
     16.189110788636032`}}], 
   Line3DBox[{{15, 12, 16}, {14.924161519596359`, 10.720485769507254`, 
     16.217006587127262`}}], 
   Line3DBox[{{2, 13, 16}, {2.0486383918217186`, 11.716573606298777`, 
     16.201124336647936`}}], 
   Line3DBox[{{13, 13, 16}, {12.917588041481968`, 11.722453329141485`, 
     16.226014983732387`}}], 
   Line3DBox[{{0, 14, 16}, {0.08465069855056993, 12.716738709633805`, 
     16.189933461724337`}}], 
   Line3DBox[{{11, 14, 16}, {10.932093710565523`, 12.718935467545746`, 
     16.210386310255696`}}], 
   Line3DBox[{{22, 14, 16}, {21.862674701163275`, 12.725504784912426`, 
     16.216341648829534`}}], 
   Line3DBox[{{9, 15, 16}, {8.974436334443366, 13.710583059278733`, 
     16.1635556540885}}], 
   Line3DBox[{{20, 15, 16}, {20.001656377217515`, 13.714723197659023`, 
     16.195091767583012`}}], 
   Line3DBox[{{7, 16, 16}, {7.045476853605848, 14.710626852051313`, 
     16.159526615757382`}}], 
   Line3DBox[{{18, 16, 16}, {17.983471226355725`, 14.722395116841128`, 
     16.239692641043526`}}], 
   Line3DBox[{{5, 17, 16}, {5.035610745843825, 15.712976992700893`, 
     16.179732171475255`}}], 
   Line3DBox[{{16, 17, 16}, {15.992279831170036`, 15.727409430857154`, 
     16.265431050033566`}}], 
   Line3DBox[{{2, 18, 16}, {2.0263593586401027`, 16.719421457051073`, 
     16.222314595901583`}}], 
   Line3DBox[{{13, 18, 16}, {12.98796859366935, 16.712139897097597`, 
     16.176837780504965`}}], 
   Line3DBox[{{24, 18, 16}, {24.62117161088095, 17.13230062014791, 
     16.742457821051044`}}], 
   Line3DBox[{{9, 19, 16}, {8.99704728910294, 17.712866870257272`, 
     16.18242693829873}}], 
   Line3DBox[{{20, 19, 16}, {20.042925290623593`, 17.720690946438545`, 
     16.226992874118483`}}], 
   Line3DBox[{{3, 20, 16}, {3.004728659918851, 18.725553143545298`, 
     16.256442683358475`}}], 
   Line3DBox[{{14, 20, 16}, {14.014842993463981`, 18.715709767240316`, 
     16.20094348355471}}], 
   Line3DBox[{{25, 20, 16}, {25.235548941603124`, 18.780041753533265`, 
     16.38238537235027}}], 
   Line3DBox[{{8, 21, 16}, {7.986287514080406, 19.71963353688563, 
     16.224663499175787`}}], 
   Line3DBox[{{19, 21, 16}, {19.083710704803174`, 19.714879408260092`, 
     16.177362855715113`}}], 
   Line3DBox[{{2, 22, 16}, {2.0172334745513245`, 20.7315051268254, 
     16.283943240956077`}}], 
   Line3DBox[{{13, 22, 16}, {13.028381575567328`, 20.720276694386445`, 
     16.22694216716564}}], 
   Line3DBox[{{24, 22, 16}, {24.087296684006944`, 20.716178306916714`, 
     16.184881446689907`}}], 
   Line3DBox[{{7, 23, 16}, {7.0155428028385725`, 21.723126316246315`, 
     16.243622693970035`}}], 
   Line3DBox[{{18, 23, 16}, {18.117885536962223`, 21.717203223730113`, 
     16.174743901085876`}}], 
   Line3DBox[{{1, 24, 16}, {1.0043414108739641`, 22.724439180777495`, 
     16.25085005205508}}], 
   Line3DBox[{{12, 24, 16}, {11.974863832307507`, 22.71711234772531, 
     16.208728159851194`}}], 
   Line3DBox[{{23, 24, 16}, {23.082253793238415`, 22.714164800988016`, 
     16.172806696860118`}}], 
   Line3DBox[{{6, 25, 16}, {6.031173768398367, 23.71351140171405, 
     16.184323852618423`}}], 
   Line3DBox[{{17, 25, 16}, {17.08137670842144, 23.71853284911915, 
     16.203026531615475`}}], 
   Line3DBox[{{0, 26, 16}, {-0.0542065150585493, 24.7141634137896, 
     16.18353726403102}}], 
   Line3DBox[{{11, 26, 16}, {10.899783070277467`, 24.71202981039819, 
     16.14522175351533}}], 
   Line3DBox[{{22, 26, 16}, {22.082840057836577`, 24.7047038974723, 
     16.073113142417615`}}], 
   Line3DBox[{{5, 27, 16}, {5.053009669242079, 25.711235070023392`, 
     16.162095435559536`}}], 
   Line3DBox[{{16, 27, 16}, {15.972916926168352`, 25.709917140280332`, 
     16.15796430663081}}], 
   Line3DBox[{{27, 27, 16}, {27.03644656171861, 25.70955889880325, 
     16.15307975856076}}], 
   Line3DBox[{{10, 1, 17}, {10.152031924502998`, 2.2882206354273187`, 
     16.914128652094245`}}], 
   Line3DBox[{{21, 1, 17}, {20.972251074355015`, -0.2988700672328868, 
     17.04654616602885}}], 
   Line3DBox[{{4, 2, 17}, {3.9814594522674485`, 0.7146404595205262, 
     17.193667498017025`}}], 
   Line3DBox[{{15, 2, 17}, {14.893118151270148`, 0.7081372665881245, 
     17.09832064093407}}], 
   Line3DBox[{{26, 2, 17}, {25.924210966685234`, 0.7055518730625432, 
     17.093059492247285`}}], 
   Line3DBox[{{9, 3, 17}, {8.860695537659435, 1.7238117354841045`, 
     17.204787158493676`}}], 
   Line3DBox[{{20, 3, 17}, {19.948389706724353`, 1.704951680277735, 
     17.100926840892498`}}], 
   Line3DBox[{{3, 4, 17}, {2.9884655892819545`, 2.722725742598196, 
     17.241738347698615`}}], 
   Line3DBox[{{14, 4, 17}, {13.847249969732104`, 2.721867789748302, 
     17.181784161494527`}}], 
   Line3DBox[{{25, 4, 17}, {24.869410658027743`, 2.709422222419466, 
     17.08576376728282}}], 
   Line3DBox[{{8, 5, 17}, {7.9279435503993865`, 3.7256346523258457`, 
     17.24657824056126}}], 
   Line3DBox[{{19, 5, 17}, {18.94710076150189, 3.7072290913372266`, 
     17.126273703840297`}}], 
   Line3DBox[{{2, 6, 17}, {2.0222361062043057`, 4.721574704466703, 
     17.23480698311906}}], 
   Line3DBox[{{13, 6, 17}, {12.88382230406073, 4.724978524492426, 
     17.225439526172167`}}], 
   Line3DBox[{{24, 6, 17}, {23.88559590012103, 4.707941144801033, 
     17.086577229297422`}}], 
   Line3DBox[{{7, 7, 17}, {6.909126387187945, 5.717811765286299, 
     17.19425580366169}}], 
   Line3DBox[{{18, 7, 17}, {17.885279014092596`, 5.712791944304247, 
     17.14118964814884}}], 
   Line3DBox[{{1, 8, 17}, {1.0069611443793147`, 6.712066490128989, 
     17.176575243509017`}}], 
   Line3DBox[{{12, 8, 17}, {11.93243045861542, 6.715166403221769, 
     17.186110143912117`}}], 
   Line3DBox[{{23, 8, 17}, {22.920748396720118`, 6.7084896138686485`, 
     17.125379846436402`}}], 
   Line3DBox[{{6, 9, 17}, {5.988217612872134, 7.7090269929470745`, 
     17.152479081890913`}}], 
   Line3DBox[{{17, 9, 17}, {16.866311284735083`, 7.7165708825808, 
     17.157914622411575`}}], 
   Line3DBox[{{0, 10, 17}, {-0.024311112204086337`, 8.710810020508857, 
     17.165523915501744`}}], 
   Line3DBox[{{11, 10, 17}, {10.94575431298175, 8.713321492188742, 
     17.17752696408296}}], 
   Line3DBox[{{22, 10, 17}, {21.865828245433175`, 8.711376126647522, 
     17.10698809888262}}], 
   Line3DBox[{{5, 11, 17}, {5.046533698322709, 9.71320288586171, 
     17.178851340408116`}}], 
   Line3DBox[{{16, 11, 17}, {15.90496539875557, 9.716998935361612, 
     17.186753025954268`}}], 
   Line3DBox[{{1, 12, 17}, {1.009102282704497, 10.71810262009736, 
     17.216000592240658`}}], 
   Line3DBox[{{12, 12, 17}, {11.913625240796575`, 10.720237058498634`, 
     17.211533010502674`}}], 
   Line3DBox[{{23, 12, 17}, {23.679719108300088`, 11.02009401165475, 
     17.517461291128964`}}], 
   Line3DBox[{{9, 13, 17}, {8.950267800759187, 11.715228387629102`, 
     17.192064084108807`}}], 
   Line3DBox[{{20, 13, 17}, {19.936363293764717`, 11.712384620957002`, 
     17.167323056604516`}}], 
   Line3DBox[{{6, 14, 17}, {6.052964695053302, 12.712810818558719`, 
     17.174180229240964`}}], 
   Line3DBox[{{17, 14, 17}, {16.96242914087957, 12.723149978259963`, 
     17.24133473129125}}], 
   Line3DBox[{{3, 15, 17}, {3.1017978770858026`, 13.718975862110339`, 
     17.196505344367203`}}], 
   Line3DBox[{{14, 15, 17}, {13.918004223001011`, 13.722244816312804`, 
     17.224985295330235`}}], 
   Line3DBox[{{0, 16, 17}, {0.10294913638568598`, 14.719738073239489`, 
     17.20082548196109}}], 
   Line3DBox[{{11, 16, 17}, {10.960622843267679`, 14.713352867816324`, 
     17.181627632179687`}}], 
   Line3DBox[{{22, 16, 17}, {22.33386948665869, 14.745740304726374`, 
     17.073237850121178`}}], 
   Line3DBox[{{8, 17, 17}, {8.020454685061425, 15.708416820168157`, 
     17.146268572955716`}}], 
   Line3DBox[{{19, 17, 17}, {18.984366603187155`, 15.723487317496247`, 
     17.24550146295116}}], 
   Line3DBox[{{4, 18, 17}, {4.004546893070505, 16.71618240693012, 
     17.204430216669806`}}], 
   Line3DBox[{{15, 18, 17}, {14.981069878006695`, 16.716675401112184`, 
     17.206687262236322`}}], 
   Line3DBox[{{26, 18, 17}, {26.780384131660657`, 16.962601352096144`, 
     17.069315599827856`}}], 
   Line3DBox[{{9, 19, 17}, {8.974299410532943, 17.713783534286655`, 
     17.187047274850272`}}], 
   Line3DBox[{{20, 19, 17}, {20.058578758890683`, 17.720736460926517`, 
     17.223726007884686`}}], 
   Line3DBox[{{3, 20, 17}, {2.9936937456414254`, 18.724818755412233`, 
     17.252731131061378`}}], 
   Line3DBox[{{14, 20, 17}, {14.014514455964866`, 18.71750336327701, 
     17.2121124875208}}], 
   Line3DBox[{{25, 20, 17}, {25.093035201032457`, 18.744168707144137`, 
     17.322850143646903`}}], 
   Line3DBox[{{8, 21, 17}, {7.965056788425382, 19.7216291167305, 
     17.233552685220303`}}], 
   Line3DBox[{{19, 21, 17}, {19.08041021835784, 19.715710693392463`, 
     17.184757066758415`}}], 
   Line3DBox[{{2, 22, 17}, {1.994227111633263, 20.729195842197935`, 
     17.273904118758537`}}], 
   Line3DBox[{{13, 22, 17}, {13.031487019225318`, 20.723225287504317`, 
     17.242600290914652`}}], 
   Line3DBox[{{24, 22, 17}, {24.0942606094727, 20.720186963365506`, 
     17.207830528946612`}}], 
   Line3DBox[{{7, 23, 17}, {7.010214322664797, 21.725216001907462`, 
     17.25460052203345}}], 
   Line3DBox[{{18, 23, 17}, {18.106171543496576`, 21.718588005790558`, 
     17.191600898869858`}}], 
   Line3DBox[{{1, 24, 17}, {0.9591710218975595, 22.727262541697613`, 
     17.261672231581983`}}], 
   Line3DBox[{{12, 24, 17}, {11.978569461697568`, 22.718673552002798`, 
     17.21850232422321}}], 
   Line3DBox[{{23, 24, 17}, {23.073783112120438`, 22.718304230328343`, 
     17.204479843435966`}}], 
   Line3DBox[{{6, 25, 17}, {6.01586648144641, 23.716987031506576`, 
     17.208868325612585`}}], 
   Line3DBox[{{17, 25, 17}, {17.089456247500785`, 23.717393154923993`, 
     17.19213864980075}}], 
   Line3DBox[{{0, 26, 17}, {-0.08714934489669646, 24.716087898996726`, 
     17.184322295399767`}}], 
   Line3DBox[{{11, 26, 17}, {10.911901024597299`, 24.712645202160864`, 
     17.157975298744944`}}], 
   Line3DBox[{{22, 26, 17}, {22.070361151480913`, 24.704817314011702`, 
     17.086897170715865`}}], 
   Line3DBox[{{5, 27, 17}, {5.036323731042652, 25.71306390570411, 
     17.180211197658707`}}], 
   Line3DBox[{{16, 27, 17}, {16.002359702785274`, 25.708781865450618`, 
     17.150831564380855`}}], 
   Line3DBox[{{27, 27, 17}, {27.03959506846968, 25.710590913513983`, 
     17.160799372636127`}}], 
   Line3DBox[{{10, 1, 18}, {9.860227875340456, -0.28989524637970465`, 
     18.081449410895342`}}], 
   Line3DBox[{{21, 1, 18}, {20.991277026312783`, -0.29983723442547516`, 
     18.018629914953777`}}], 
   Line3DBox[{{4, 2, 18}, {3.985818693094988, 0.716447795201945, 
     18.205651715510758`}}], 
   Line3DBox[{{15, 2, 18}, {14.909688721279036`, 0.7072262883535199, 
     18.102859143548677`}}], 
   Line3DBox[{{26, 2, 18}, {25.92859052677261, 0.70705698579671, 
     18.114887114840165`}}], 
   Line3DBox[{{9, 3, 18}, {8.850311996620851, 1.7234086275477394`, 
     18.19469969035624}}], 
   Line3DBox[{{20, 3, 18}, {19.950939156534027`, 1.7044705397763489`, 
     18.095898129966248`}}], 
   Line3DBox[{{3, 4, 18}, {2.984242959233798, 2.7225776410916334`, 
     18.240715252170023`}}], 
   Line3DBox[{{14, 4, 18}, {13.862311620094198`, 2.7177834064585857`, 
     18.164202671372813`}}], 
   Line3DBox[{{25, 4, 18}, {24.87073462498885, 2.7111311469544552`, 
     18.110034278623928`}}], 
   Line3DBox[{{8, 5, 18}, {7.929808939577695, 3.7266817679683717`, 
     18.252455728817235`}}], 
   Line3DBox[{{19, 5, 18}, {18.94748668204752, 3.709783134675643, 
     18.15027571949657}}], 
   Line3DBox[{{2, 6, 18}, {2.020771071459698, 4.720120621699881, 
     18.226886182021996`}}], 
   Line3DBox[{{13, 6, 18}, {12.88038926877585, 4.7223404603878105`, 
     18.208036953001123`}}], 
   Line3DBox[{{24, 6, 18}, {23.888941823952468`, 4.710190507379184, 
     18.118564557428552`}}], 
   Line3DBox[{{7, 7, 18}, {6.912456216629952, 5.717852676903471, 
     18.19604674919433}}], 
   Line3DBox[{{18, 7, 18}, {17.892776149177294`, 5.7134877781480995`, 
     18.15293576704106}}], 
   Line3DBox[{{1, 8, 18}, {1.0117285965706853`, 6.71175022740132, 
     18.173997021301897`}}], 
   Line3DBox[{{12, 8, 18}, {11.919622720010768`, 6.715408169923292, 
     18.182656297350267`}}], 
   Line3DBox[{{23, 8, 18}, {22.917981889739035`, 6.710078246507637, 
     18.139193747907033`}}], 
   Line3DBox[{{6, 9, 18}, {5.992939484931367, 7.708686331478669, 
     18.149863800221887`}}], 
   Line3DBox[{{17, 9, 18}, {16.89134864990406, 7.715575272860535, 
     18.168665362285925`}}], 
   Line3DBox[{{0, 10, 18}, {-0.03256080683739481, 8.71060310787587, 
     18.162466761027396`}}], 
   Line3DBox[{{11, 10, 18}, {10.945109852750967`, 8.713011664177811, 
     18.175065973828758`}}], 
   Line3DBox[{{22, 10, 18}, {21.880301555471785`, 8.715221332913416, 
     18.158164657799226`}}], 
   Line3DBox[{{5, 11, 18}, {5.037561040095653, 9.712431673957301, 
     18.17537666332364}}], 
   Line3DBox[{{16, 11, 18}, {15.91335152224596, 9.71859665478884, 
     18.20123992691451}}], 
   Line3DBox[{{27, 11, 18}, {26.612335755426393`, 10.051308608473489`, 
     18.799813151381414`}}], 
   Line3DBox[{{10, 12, 18}, {9.945922880125252, 10.714768712890546`, 
     18.187766354124022`}}], 
   Line3DBox[{{21, 12, 18}, {20.927914907395774`, 10.715537715431367`, 
     18.186976947629827`}}], 
   Line3DBox[{{6, 13, 18}, {6.042895754428206, 11.711626700426734`, 
     18.168089842639976`}}], 
   Line3DBox[{{17, 13, 18}, {16.96123788398041, 11.719192183608419`, 
     18.219154821603162`}}], 
   Line3DBox[{{2, 14, 18}, {2.069065025715227, 12.71880188035003, 
     18.209192257094603`}}], 
   Line3DBox[{{13, 14, 18}, {12.921530770474394`, 12.724362512116638`, 
     18.237889847459456`}}], 
   Line3DBox[{{24, 14, 18}, {23.15564106593927, 13.112314240271067`, 
     18.43482408218301}}], 
   Line3DBox[{{9, 15, 18}, {8.98425432923445, 13.71180775571204, 
     18.174105759837207`}}], 
   Line3DBox[{{20, 15, 18}, {20.00963477885896, 13.716129355555502`, 
     18.20391993372402}}], 
   Line3DBox[{{5, 16, 18}, {5.06075764423302, 14.713157213983363`, 
     18.1741957311308}}], 
   Line3DBox[{{16, 16, 18}, {16.00895395841147, 14.727422541871043`, 
     18.26545515570583}}], 
   Line3DBox[{{1, 17, 18}, {1.0377667944959716`, 15.716099657580093`, 
     18.200433480156246`}}], 
   Line3DBox[{{12, 17, 18}, {11.990176265135595`, 15.712853463675618`, 
     18.182091428303085`}}], 
   Line3DBox[{{23, 17, 18}, {23.58255570407299, 15.861841930852739`, 
     18.235000130397843`}}], 
   Line3DBox[{{6, 18, 18}, {6.026615176065314, 16.707890056941242`, 
     18.140511663045118`}}], 
   Line3DBox[{{17, 18, 18}, {16.986484247955126`, 16.723955403562265`, 
     18.24804739939923}}], 
   Line3DBox[{{0, 19, 18}, {-0.010617131209151198`, 17.724016953596493`, 
     18.24850461125644}}], 
   Line3DBox[{{11, 19, 18}, {10.986334139674506`, 17.716021772195106`, 
     18.203010233201592`}}], 
   Line3DBox[{{22, 19, 18}, {22.143299508194264`, 17.731303187901585`, 
     18.244690927340194`}}], 
   Line3DBox[{{5, 20, 18}, {5.0155067656231465`, 18.714983385484494`, 
     18.196193375624702`}}], 
   Line3DBox[{{16, 20, 18}, {16.023620232380008`, 18.717876179822884`, 
     18.213542956701342`}}], 
   Line3DBox[{{27, 20, 18}, {27.029649302564213`, 18.721180912182614`, 
     18.23182463089881}}], 
   Line3DBox[{{10, 21, 18}, {9.959458031175851, 19.725886736855642`, 
     18.25493477880332}}], 
   Line3DBox[{{21, 21, 18}, {21.11383076467291, 19.71739059457466, 
     18.178761489500484`}}], 
   Line3DBox[{{4, 22, 18}, {3.977735261378233, 20.727123275626106`, 
     18.263228277282835`}}], 
   Line3DBox[{{15, 22, 18}, {15.06634910175277, 20.725449201945597`, 
     18.24722067040498}}], 
   Line3DBox[{{26, 22, 18}, {26.012059051162513`, 20.722846720413738`, 
     18.242351149630267`}}], 
   Line3DBox[{{9, 23, 18}, {8.982798499953608, 21.727220146548298`, 
     18.264074900442314`}}], 
   Line3DBox[{{20, 23, 18}, {20.090339448954275`, 21.715977086600272`, 
     18.18199984018431}}], 
   Line3DBox[{{3, 24, 18}, {2.951648647752687, 22.73021300623586, 
     18.27441417092287}}], 
   Line3DBox[{{14, 24, 18}, {14.063116528258272`, 22.72743257352881, 
     18.25804737732656}}], 
   Line3DBox[{{25, 24, 18}, {25.038308002170936`, 22.718528627704163`, 
     18.215322128347037`}}], 
   Line3DBox[{{8, 25, 18}, {7.956934308016296, 23.718385482000304`, 
     18.213563979702496`}}], 
   Line3DBox[{{19, 25, 18}, {19.076540367273495`, 23.712286359468422`, 
     18.16104394483043}}], 
   Line3DBox[{{2, 26, 18}, {1.9499889204597183`, 24.717589138585662`, 
     18.207174502412226`}}], 
   Line3DBox[{{13, 26, 18}, {12.987891444902376`, 24.711886465722973`, 
     18.174976871916805`}}], 
   Line3DBox[{{24, 26, 18}, {24.056945557329218`, 24.70792242812857, 
     18.13150190784658}}], 
   Line3DBox[{{7, 27, 18}, {6.9586057849666805`, 25.71365481433702, 
     18.183310071418486`}}], 
   Line3DBox[{{18, 27, 18}, {18.039656369204206`, 25.711486964769378`, 
     18.167813975646578`}}], 
   Line3DBox[{{1, 1, 19}, {0.9724198512116982, -0.2934674811298059, 
     19.127205387671005`}}], 
   Line3DBox[{{12, 1, 19}, {11.859885056678712`, -0.28931864322347045`, 
     19.08958369770478}}], 
   Line3DBox[{{23, 1, 19}, {23.006798785875013`, -0.2999811972711981, 
     19.001631947293305`}}], 
   Line3DBox[{{6, 2, 19}, {5.941442379269397, 0.7194953716802597, 
     19.216515361824733`}}], 
   Line3DBox[{{17, 2, 19}, {16.97058696974853, 0.7043672249137194, 
     19.102325880273025`}}], 
   Line3DBox[{{0, 3, 19}, {-0.012660269276265016`, 1.7080065207172643`, 
     19.143501104778828`}}], 
   Line3DBox[{{11, 3, 19}, {10.843450477340681`, 1.7171906122693832`, 
     19.141040142177108`}}], 
   Line3DBox[{{22, 3, 19}, {21.958957064895888`, 1.7018080161994842`, 
     19.054891262274804`}}], 
   Line3DBox[{{5, 4, 19}, {4.932623050360309, 2.7246636620420164`, 
     19.242852983801253`}}], 
   Line3DBox[{{16, 4, 19}, {15.910405324381014`, 2.713641727501039, 
     19.165091456090913`}}], 
   Line3DBox[{{27, 4, 19}, {26.850632931626084`, 2.7151464402162517`, 
     19.12977214183488}}], 
   Line3DBox[{{10, 5, 19}, {9.862860665693976, 3.7237976115982088`, 
     19.20615592842231}}], 
   Line3DBox[{{21, 5, 19}, {20.951932694861252`, 3.706343797421393, 
     19.118925033977703`}}], 
   Line3DBox[{{4, 6, 19}, {3.9583830239621083`, 4.722163109610758, 
     19.235373976611296`}}], 
   Line3DBox[{{15, 6, 19}, {14.860955592996474`, 4.7246918465947, 
     19.21037054627253}}], 
   Line3DBox[{{26, 6, 19}, {25.848924587794915`, 4.714931723905547, 
     19.125601535033198`}}], 
   Line3DBox[{{9, 7, 19}, {8.900299849684153, 5.719372788839014, 
     19.20013451991356}}], 
   Line3DBox[{{20, 7, 19}, {19.92914433561404, 5.712173884589056, 
     19.16273712326935}}], 
   Line3DBox[{{3, 8, 19}, {3.005909099923484, 6.716097102446943, 
     19.203858853604544`}}], 
   Line3DBox[{{14, 8, 19}, {13.888114522087442`, 6.715489775275817, 
     19.165876829036804`}}], 
   Line3DBox[{{25, 8, 19}, {24.849978848807233`, 6.7185229739829, 
     19.15909206763747}}], 
   Line3DBox[{{8, 9, 19}, {7.922701082476399, 7.714046711952788, 
     19.174209696372635`}}], 
   Line3DBox[{{19, 9, 19}, {18.910524178673953`, 7.717156184497478, 
     19.19054086812272}}], 
   Line3DBox[{{2, 10, 19}, {1.9852355834812727`, 8.71434988280494, 
     19.192056731621655`}}], 
   Line3DBox[{{13, 10, 19}, {12.912287828757133`, 8.716330065391075, 
     19.18573657151186}}], 
   Line3DBox[{{24, 10, 19}, {23.85708246788051, 8.711897775955563, 
     19.101819641644678`}}], 
   Line3DBox[{{7, 11, 19}, {6.9901198728608644`, 9.711650666041484, 
     19.17337351809421}}], 
   Line3DBox[{{18, 11, 19}, {17.920178283006198`, 9.71884471657483, 
     19.20559580065735}}], 
   Line3DBox[{{1, 12, 19}, {0.9994450217777004, 10.718296066774094`, 
     19.21733549998198}}], 
   Line3DBox[{{12, 12, 19}, {11.945906906318145`, 10.717723110464206`, 
     19.20697805627249}}], 
   Line3DBox[{{23, 12, 19}, {23.138284643502537`, 13.291286817702835`, 
     18.941214697429867`}}], 
   Line3DBox[{{6, 13, 19}, {6.030424541953878, 11.714887969349064`, 
     19.19380767766816}}], 
   Line3DBox[{{17, 13, 19}, {16.950402925352993`, 11.720326613166083`, 
     19.223553468359302`}}], 
   Line3DBox[{{0, 14, 19}, {0.05564625607563663, 12.718086049789529`, 
     19.2088064137917}}], 
   Line3DBox[{{11, 14, 19}, {10.97333907255767, 12.714548234480405`, 
     19.192101414545736`}}], 
   Line3DBox[{{22, 14, 19}, {21.931415613714773`, 12.715332369732772`, 
     19.186883016086174`}}], 
   Line3DBox[{{5, 15, 19}, {5.030640930228977, 13.716306234427453`, 
     19.202956767871584`}}], 
   Line3DBox[{{16, 15, 19}, {15.997419866624298`, 13.723666750869857`, 
     19.246914519776894`}}], 
   Line3DBox[{{27, 15, 19}, {27.234490916219972`, 13.88690705907657, 
     18.370684407410124`}}], 
   Line3DBox[{{10, 16, 19}, {10.02103414014933, 14.712829648972333`, 
     19.180969755438557`}}], 
   Line3DBox[{{21, 16, 19}, {21.017680956353857`, 14.718395185186798`, 
     19.217201478885464`}}], 
   Line3DBox[{{4, 17, 19}, {4.030985718750472, 15.712939972435816`, 
     19.180322962154012`}}], 
   Line3DBox[{{15, 17, 19}, {15.017306035111373`, 15.719428744585914`, 
     19.22324372545699}}], 
   Line3DBox[{{26, 17, 19}, {27.234606958084118`, 16.762167765083767`, 
     18.66957377966476}}], 
   Line3DBox[{{9, 18, 19}, {8.988667955480466, 16.712257074531617`, 
     19.177735035018824`}}], 
   Line3DBox[{{20, 18, 19}, {20.056309065742386`, 16.724422166509274`, 
     19.244398199302537`}}], 
   Line3DBox[{{3, 19, 19}, {2.988684374716678, 17.71913806162686, 
     19.22195641791004}}], 
   Line3DBox[{{14, 19, 19}, {14.000663107582888`, 17.716989336385755`, 
     19.209483167200773`}}], 
   Line3DBox[{{25, 19, 19}, {25.10407126604618, 17.769666322698125`, 
     19.406753259458846`}}], 
   Line3DBox[{{8, 20, 19}, {7.912869251052497, 18.71689481553964, 
     19.18986657999445}}], 
   Line3DBox[{{19, 20, 19}, {19.080915316806824`, 18.719793987628137`, 
     19.211010135758897`}}], 
   Line3DBox[{{2, 21, 19}, {1.928821565942308, 19.72822402793182, 
     19.25984516042276}}], 
   Line3DBox[{{13, 21, 19}, {13.025966901795998`, 19.727530681743303`, 
     19.264853835362935`}}], 
   Line3DBox[{{24, 21, 19}, {24.096221783635293`, 19.72890758746394, 
     19.255079295802897`}}], 
   Line3DBox[{{7, 22, 19}, {6.955314874097631, 20.72564762781957, 
     19.253040058174975`}}], 
   Line3DBox[{{18, 22, 19}, {18.092310515666064`, 20.7201690032792, 
     19.208593836270662`}}], 
   Line3DBox[{{1, 23, 19}, {0.8996908339020879, 21.726195071823206`, 
     19.239497549359598`}}], 
   Line3DBox[{{12, 23, 19}, {12.035905047723658`, 21.724088229590237`, 
     19.246495398897807`}}], 
   Line3DBox[{{23, 23, 19}, {23.066689123974918`, 21.7263186946801, 
     19.25157204380067}}], 
   Line3DBox[{{6, 24, 19}, {5.981528888505267, 22.729740984750865`, 
     19.27586382912308}}], 
   Line3DBox[{{17, 24, 19}, {17.08823958482809, 22.720220213941733`, 
     19.210659618498706`}}], 
   Line3DBox[{{0, 25, 19}, {-0.13437107766872158`, 23.725507940897096`, 
     19.21820725187258}}], 
   Line3DBox[{{11, 25, 19}, {10.932113726193963`, 23.724208735766965`, 
     19.240308351780385`}}], 
   Line3DBox[{{22, 25, 19}, {22.02012147871272, 23.70973768121532, 
     19.15753816940283}}], 
   Line3DBox[{{5, 26, 19}, {4.98936121029185, 24.7209367108989, 
     19.232129099053573`}}], 
   Line3DBox[{{16, 26, 19}, {16.05417612458543, 24.711939595285717`, 
     19.167228410660925`}}], 
   Line3DBox[{{27, 26, 19}, {27.04259388704061, 24.715489724793365`, 
     19.195497093777238`}}], 
   Line3DBox[{{10, 27, 19}, {9.919403665070487, 25.710123004437264`, 
     19.140433497122242`}}], 
   Line3DBox[{{21, 27, 19}, {21.05098426162239, 25.705395486974616`, 
     19.106769658242083`}}], 
   Line3DBox[{{4, 1, 20}, {4.015916831120939, -0.282544600458404, 
     20.211721520687107`}}], 
   Line3DBox[{{15, 1, 20}, {14.94167430782026, -0.29417116704377233`, 
     20.108254810628964`}}], 
   Line3DBox[{{26, 1, 20}, {25.97214584560098, -0.29443293718200003`, 
     20.11690815720512}}], 
   Line3DBox[{{9, 2, 20}, {8.849903847114577, 0.7147532010448925, 
     20.124947231520533`}}], 
   Line3DBox[{{20, 2, 20}, {19.9831113223198, 0.7021517867206479, 
     20.07283397458472}}], 
   Line3DBox[{{3, 3, 20}, {2.9679912742579897`, 1.721331292958291, 
     20.23233979234874}}], 
   Line3DBox[{{14, 3, 20}, {13.875090499381663`, 1.7116320809510457`, 
     20.12043970201202}}], 
   Line3DBox[{{25, 3, 20}, {24.919821133706108`, 1.7080670902167703`, 
     20.120335805223807`}}], 
   Line3DBox[{{8, 4, 20}, {7.933382004808458, 2.7165390992399754`, 
     20.195678713550876`}}], 
   Line3DBox[{{19, 4, 20}, {18.96223642393426, 2.7126553146600845`, 
     20.176967718665868`}}], 
   Line3DBox[{{2, 5, 20}, {1.9511603250190703`, 3.718924788731928, 
     20.21554811347405}}], 
   Line3DBox[{{13, 5, 20}, {12.85611171849296, 3.7175904386514365`, 
     20.157231928712765`}}], 
   Line3DBox[{{24, 5, 20}, {23.898671273983343`, 3.71165470014953, 
     20.14106338163054}}], 
   Line3DBox[{{7, 6, 20}, {6.930716831839786, 4.7207366415746534`, 
     20.220647008590618`}}], 
   Line3DBox[{{18, 6, 20}, {17.933443697702874`, 4.71840676545246, 
     20.207578996496533`}}], 
   Line3DBox[{{1, 7, 20}, {0.9822015696681476, 5.715320973191316, 
     20.198199429756027`}}], 
   Line3DBox[{{12, 7, 20}, {11.884623972444892`, 5.7171616748340846`, 
     20.176108499939982`}}], 
   Line3DBox[{{23, 7, 20}, {22.933445921334055`, 5.714749163746047, 
     20.183577892245882`}}], 
   Line3DBox[{{6, 8, 20}, {5.9335768524165085`, 6.7159779514479565`, 
     20.192029540168473`}}], 
   Line3DBox[{{17, 8, 20}, {16.911462467032152`, 6.721827283260722, 
     20.220080920207316`}}], 
   Line3DBox[{{0, 9, 20}, {-0.03240455310751146, 7.711024606198242, 
     20.165808260082255`}}], 
   Line3DBox[{{11, 9, 20}, {10.926474211876448`, 7.713763819338675, 
     20.173753981360367`}}], 
   Line3DBox[{{22, 9, 20}, {21.935722126287697`, 7.716043356392583, 
     20.19319340642838}}], 
   Line3DBox[{{5, 10, 20}, {4.984573535051087, 8.715951818291922, 
     20.202440833903037`}}], 
   Line3DBox[{{16, 10, 20}, {15.922098308058386`, 8.721154249156651, 
     20.220192806291546`}}], 
   Line3DBox[{{27, 10, 20}, {26.801458798653, 8.760706419460043, 
     20.33872232374047}}], 
   Line3DBox[{{10, 11, 20}, {9.936942322130207, 9.717170156757813, 
     20.20092616193243}}], 
   Line3DBox[{{21, 11, 20}, {20.91790463458557, 9.723296218576854, 
     20.230841515930972`}}], 
   Line3DBox[{{4, 12, 20}, {3.9619564078197103`, 10.716403953185452`, 
     20.202321214152363`}}], 
   Line3DBox[{{15, 12, 20}, {14.975703532632682`, 10.716752253779546`, 
     20.20660325141099}}], 
   Line3DBox[{{26, 12, 20}, {25.78217532402488, 10.840695598461787`, 
     20.54641167182854}}], 
   Line3DBox[{{9, 13, 20}, {8.95402699618227, 11.71956561707226, 
     20.219941523902218`}}], 
   Line3DBox[{{20, 13, 20}, {19.893245496349515`, 11.727764937796357`, 
     20.244992698768822`}}], 
   Line3DBox[{{3, 14, 20}, {3.0050754829663577`, 12.7195496142496, 
     20.224546318394022`}}], 
   Line3DBox[{{14, 14, 20}, {14.00251631997617, 12.720047525822622`, 
     20.227410052506446`}}], 
   Line3DBox[{{25, 14, 20}, {25.07121142231421, 12.731523286763226`, 
     20.275491853433127`}}], 
   Line3DBox[{{8, 15, 20}, {7.990558803462432, 13.714628150688302`, 
     20.194242304364845`}}], 
   Line3DBox[{{19, 15, 20}, {18.978608148940907`, 13.725673292247775`, 
     20.25619100417001}}], 
   Line3DBox[{{2, 16, 20}, {1.9882778391809561`, 14.718864765955034`, 
     20.22035222493609}}], 
   Line3DBox[{{13, 16, 20}, {13.036468127269597`, 14.716542681284531`, 
     20.203488050580738`}}], 
   Line3DBox[{{24, 16, 20}, {24.04408081039353, 14.746785421941448`, 
     20.342797467167674`}}], 
   Line3DBox[{{7, 17, 20}, {7.007229702163671, 15.709577343370617`, 
     20.157343886643833`}}], 
   Line3DBox[{{18, 17, 20}, {17.99911244771448, 15.72781547901742, 
     20.267480385866445`}}], 
   Line3DBox[{{1, 18, 20}, {0.9635341320022737, 16.71790217368986, 
     20.21188535636515}}], 
   Line3DBox[{{12, 18, 20}, {11.988340941997203`, 16.715183452424284`, 
     20.19776376170095}}], 
   Line3DBox[{{23, 18, 20}, {23.067980612776406`, 16.731104913510002`, 
     20.274379109569374`}}], 
   Line3DBox[{{6, 19, 20}, {6.001642969474682, 17.706689863261943`, 
     20.131704938638954`}}], 
   Line3DBox[{{17, 19, 20}, {17.009960612848392`, 17.71867124570871, 
     20.219311216352494`}}], 
   Line3DBox[{{0, 20, 20}, {-0.09030732127266995, 18.728622108823085`, 
     20.255817993016713`}}], 
   Line3DBox[{{11, 20, 20}, {10.956574877388366`, 18.725375725399658`, 
     20.25188731076758}}], 
   Line3DBox[{{22, 20, 20}, {22.103436270205826`, 18.721374866393496`, 
     20.210757457081964`}}], 
   Line3DBox[{{5, 21, 20}, {4.99546311034397, 19.718076039763666`, 
     20.215986982950913`}}], 
   Line3DBox[{{16, 21, 20}, {16.05542872364694, 19.720586213436786`, 
     20.22366944213917}}], 
   Line3DBox[{{27, 21, 20}, {27.009966679162755`, 19.726058154428696`, 
     20.258791111533693`}}], 
   Line3DBox[{{10, 22, 20}, {9.947034246834145, 20.727858963387124`, 
     20.26239628800173}}], 
   Line3DBox[{{21, 22, 20}, {21.084026861815424`, 20.720624852540006`, 
     20.214799251756546`}}], 
   Line3DBox[{{4, 23, 20}, {3.9529625258906593`, 21.730638408575693`, 
     20.276601927408613`}}], 
   Line3DBox[{{15, 23, 20}, {15.069856755339503`, 21.729079742193104`, 
     20.26435153116539}}], 
   Line3DBox[{{26, 23, 20}, {26.009190511861355`, 21.720876980017774`, 
     20.231861670491863`}}], 
   Line3DBox[{{9, 24, 20}, {8.926398075450894, 22.72646823272703, 
     20.25039887070283}}], 
   Line3DBox[{{20, 24, 20}, {20.04840979567495, 22.71815021625667, 
     20.210991998900166`}}], 
   Line3DBox[{{3, 25, 20}, {2.931892814307701, 23.724192496691412`, 
     20.24015958394073}}], 
   Line3DBox[{{14, 25, 20}, {14.057842707737668`, 23.718405179681056`, 
     20.210164073269496`}}], 
   Line3DBox[{{25, 25, 20}, {25.04995149024348, 23.720885166146775`, 
     20.226649708667555`}}], 
   Line3DBox[{{8, 26, 20}, {7.9250687314316135`, 24.724602688375573`, 
     20.24030606003993}}], 
   Line3DBox[{{19, 26, 20}, {19.04692583275982, 24.71153352149716, 
     20.166289205886283`}}], 
   Line3DBox[{{2, 27, 20}, {1.9298692600286151`, 25.71252109099343, 
     20.165770136557594`}}], 
   Line3DBox[{{13, 27, 20}, {13.000442787628641`, 25.703542020382947`, 
     20.095898441209364`}}], 
   Line3DBox[{{24, 27, 20}, {24.046593589080516`, 25.70669866089453, 
     20.123291052897617`}}], 
   Line3DBox[{{7, 1, 21}, {6.924340785282493, -0.28932294193262376`, 
     21.14806091528332}}], 
   Line3DBox[{{18, 1, 21}, {17.9862969170553, -0.2963855233101371, 
     21.09589995031132}}], 
   Line3DBox[{{1, 2, 21}, {0.9483161809112659, 0.7147704707602021, 
     21.18845116082012}}], 
   Line3DBox[{{12, 2, 21}, {11.883049648974792`, 0.7095539414453287, 
     21.10522160118433}}], 
   Line3DBox[{{23, 2, 21}, {22.965213409794615`, 0.7018971515823387, 
     21.060982686656434`}}], 
   Line3DBox[{{6, 3, 21}, {5.92652838166988, 1.7242486025179076`, 
     21.238872964402507`}}], 
   Line3DBox[{{17, 3, 21}, {16.9611111775535, 1.7100989379416687`, 
     21.15698060258998}}], 
   Line3DBox[{{0, 4, 21}, {-0.05709780454767312, 2.712830019178765, 
     21.173012372934707`}}], 
   Line3DBox[{{11, 4, 21}, {10.884492777357998`, 2.712689921443931, 
     21.13960960986085}}], 
   Line3DBox[{{22, 4, 21}, {21.96129164308113, 2.7054993486614425`, 
     21.113003215833405`}}], 
   Line3DBox[{{5, 5, 21}, {4.899271753528188, 3.720015004561656, 
     21.203696420723137`}}], 
   Line3DBox[{{16, 5, 21}, {15.88016469119927, 3.723966814660246, 
     21.217666737643384`}}], 
   Line3DBox[{{27, 5, 21}, {26.90249256126439, 3.709245912994642, 
     21.120192288730124`}}], 
   Line3DBox[{{10, 6, 21}, {9.866312409764095, 4.721549680588366, 
     21.194145329619865`}}], 
   Line3DBox[{{21, 6, 21}, {20.95030409440983, 4.715978682199056, 
     21.197026831676045`}}], 
   Line3DBox[{{4, 7, 21}, {3.9480035616863614`, 5.714251930230427, 
     21.18479250928139}}], 
   Line3DBox[{{15, 7, 21}, {14.861974204093716`, 5.726841119218754, 
     21.22364110523847}}], 
   Line3DBox[{{26, 7, 21}, {25.89833793151509, 5.712118336758357, 
     21.145002225215023`}}], 
   Line3DBox[{{9, 8, 21}, {8.892486584444885, 6.71441693441691, 
     21.160365354617696`}}], 
   Line3DBox[{{20, 8, 21}, {19.953176047380857`, 6.722312702708276, 
     21.235207754550082`}}], 
   Line3DBox[{{3, 9, 21}, {2.9681609019539295`, 7.713927337486573, 
     21.187091898732252`}}], 
   Line3DBox[{{14, 9, 21}, {13.905572110329668`, 7.717431652313468, 
     21.190004755637972`}}], 
   Line3DBox[{{25, 9, 21}, {24.91923877260521, 7.723310547071158, 
     21.23139071919578}}], 
   Line3DBox[{{8, 10, 21}, {7.9262405091520005`, 8.714847343254164, 
     21.181499824707807`}}], 
   Line3DBox[{{19, 10, 21}, {18.92265509877975, 8.72296787906117, 
     21.230665836971372`}}], 
   Line3DBox[{{2, 11, 21}, {1.9165104437593132`, 9.718582795288597, 
     21.202483188112858`}}], 
   Line3DBox[{{13, 11, 21}, {12.939664865604508`, 9.71722728158547, 
     21.202123290218807`}}], 
   Line3DBox[{{24, 11, 21}, {23.925879869141717`, 9.718867538146057, 
     21.20786010051379}}], 
   Line3DBox[{{7, 12, 21}, {6.969714906976884, 10.717285398084492`, 
     21.209107778844597`}}], 
   Line3DBox[{{18, 12, 21}, {17.893918359744408`, 10.728617485536274`, 
     21.249666152124345`}}], 
   Line3DBox[{{1, 13, 21}, {0.9662789041490031, 11.721309307909177`, 
     21.231976295459038`}}], 
   Line3DBox[{{12, 13, 21}, {12.008780930980095`, 11.717067460566605`, 
     21.20977844149031}}], 
   Line3DBox[{{23, 13, 21}, {22.932776129134513`, 11.714362705893132`, 
     21.180603707568338`}}], 
   Line3DBox[{{6, 14, 21}, {5.989932095362412, 12.720252454319272`, 
     21.22835248328049}}], 
   Line3DBox[{{17, 14, 21}, {16.962224491625722`, 12.721106150904431`, 
     21.230224963269805`}}], 
   Line3DBox[{{0, 15, 21}, {-0.011214484963076641`, 13.720269280705237`, 
     21.228393348021175`}}], 
   Line3DBox[{{11, 15, 21}, {11.018354320308967`, 13.714320236817107`, 
     21.191548076127056`}}], 
   Line3DBox[{{22, 15, 21}, {21.974746508800585`, 13.716562051481121`, 
     21.20530293101632}}], 
   Line3DBox[{{5, 16, 21}, {4.970935750331679, 14.714902509249088`, 
     21.194112618489694`}}], 
   Line3DBox[{{16, 16, 21}, {16.00030891756358, 14.72344346657451, 
     21.24577087203051}}], 
   Line3DBox[{{27, 16, 21}, {26.916985864312263`, 14.734833730247988`, 
     21.287163652222556`}}], 
   Line3DBox[{{10, 17, 21}, {10.013248138866272`, 15.715254356303056`, 
     21.198123996068897`}}], 
   Line3DBox[{{21, 17, 21}, {21.01823938206744, 15.722118128787237`, 
     21.238086640044262`}}], 
   Line3DBox[{{4, 18, 21}, {3.984932007849481, 16.71120933365099, 
     21.169680800163796`}}], 
   Line3DBox[{{15, 18, 21}, {15.0096314351042, 16.722339340945027`, 
     21.23977171593215}}], 
   Line3DBox[{{26, 18, 21}, {26.02147321985546, 16.73259798410289, 
     21.288497887217527`}}], 
   Line3DBox[{{9, 19, 21}, {8.927488160507444, 17.717888397389807`, 
     21.20231626624107}}], 
   Line3DBox[{{20, 19, 21}, {20.03981663703071, 17.72232006051795, 
     21.2365345802641}}], 
   Line3DBox[{{3, 20, 21}, {2.9748622770771167`, 18.718743177253852`, 
     21.218515557919112`}}], 
   Line3DBox[{{14, 20, 21}, {14.02038043678695, 18.72255795768339, 
     21.240263327035855`}}], 
   Line3DBox[{{25, 20, 21}, {25.040644331125616`, 18.725122651614345`, 
     21.251069283108297`}}], 
   Line3DBox[{{8, 21, 21}, {7.91821250366101, 19.717556496417668`, 
     21.19659467328001}}], 
   Line3DBox[{{19, 21, 21}, {19.080318341436552`, 19.718024512186847`, 
     21.200219411334434`}}], 
   Line3DBox[{{2, 22, 21}, {1.9061373286781187`, 20.726688632385788`, 
     21.2446793003847}}], 
   Line3DBox[{{13, 22, 21}, {13.011640141848995`, 20.726821085871034`, 
     21.262449918489455`}}], 
   Line3DBox[{{24, 22, 21}, {24.049649471300974`, 20.724555610772352`, 
     21.246528984071336`}}], 
   Line3DBox[{{7, 23, 21}, {6.934798730784591, 21.72533381611651, 
     21.24693099067674}}], 
   Line3DBox[{{18, 23, 21}, {18.075325927295424`, 21.72460549244368, 
     21.240197532818822`}}], 
   Line3DBox[{{1, 24, 21}, {0.8840738444122423, 22.723158017006167`, 
     21.215024828601294`}}], 
   Line3DBox[{{12, 24, 21}, {11.967167760907254`, 22.72584533459507, 
     21.255835753371212`}}], 
   Line3DBox[{{23, 24, 21}, {23.02094297967467, 22.72205593337406, 
     21.23752969115019}}], 
   Line3DBox[{{6, 25, 21}, {5.95630186161996, 23.728356984287664`, 
     21.266485484205337`}}], 
   Line3DBox[{{17, 25, 21}, {17.043771582325597`, 23.7130587411242, 
     21.178511189520112`}}], 
   Line3DBox[{{0, 26, 21}, {-0.12220872697362031`, 24.717454459113437`, 
     21.173614407822285`}}], 
   Line3DBox[{{11, 26, 21}, {10.90282091615579, 24.71981755719966, 
     21.204179183094052`}}], 
   Line3DBox[{{22, 26, 21}, {22.012261681411857`, 24.710230011192973`, 
     21.1623053515497}}], 
   Line3DBox[{{5, 27, 21}, {4.981008630723828, 25.71015080518442, 
     21.161022925469048`}}], 
   Line3DBox[{{16, 27, 21}, {15.994971027770907`, 25.70199417375641, 
     21.071802398817972`}}], 
   Line3DBox[{{27, 27, 21}, {27.068629256338355`, 25.71784447802498, 
     21.203389386752125`}}], 
   Line3DBox[{{10, 1, 22}, {9.92319749334289, -0.29385860671409825`, 
     22.100156281895025`}}], 
   Line3DBox[{{21, 1, 22}, {21.000269355843184`, -0.2982755921453515, 
     22.066935896849653`}}], 
   Line3DBox[{{4, 2, 22}, {3.956799644112421, 0.7246797945530095, 
     22.24837895005381}}], 
   Line3DBox[{{15, 2, 22}, {14.94320884659283, 0.7079049838797578, 
     22.131397238220273`}}], 
   Line3DBox[{{26, 2, 22}, {25.961925985171554`, 0.7072346134405063, 
     22.13155996620753}}], 
   Line3DBox[{{9, 3, 22}, {8.898775236837043, 1.7144274249768947`, 
     22.16448921445209}}], 
   Line3DBox[{{20, 3, 22}, {19.983618824480185`, 1.708805436668337, 
     22.150160769548325`}}], 
   Line3DBox[{{3, 4, 22}, {2.8929670195338177`, 2.7247413073304836`, 
     22.22860272934364}}], 
   Line3DBox[{{14, 4, 22}, {13.896062625797494`, 2.711934620205761, 
     22.14172014542544}}], 
   Line3DBox[{{25, 4, 22}, {24.94206974603272, 2.705149163303881, 
     22.100026978274105`}}], 
   Line3DBox[{{8, 5, 22}, {7.947933529993417, 3.715119563156547, 
     22.190712730875607`}}], 
   Line3DBox[{{19, 5, 22}, {18.983582599372518`, 3.715447004925122, 
     22.19913330158664}}], 
   Line3DBox[{{2, 6, 22}, {1.9327331036137219`, 4.7178240396169695`, 
     22.2037154173508}}], 
   Line3DBox[{{13, 6, 22}, {12.852210642665874`, 4.719149725061849, 
     22.16607491998983}}], 
   Line3DBox[{{24, 6, 22}, {23.923855920346313`, 4.708957322554912, 
     22.13195030939377}}], 
   Line3DBox[{{7, 7, 22}, {6.918354148650256, 5.7140174040525205`, 
     22.171996272859495`}}], 
   Line3DBox[{{18, 7, 22}, {17.951390373028957`, 5.722652210487458, 
     22.23668487233695}}], 
   Line3DBox[{{1, 8, 22}, {0.9528037256222149, 6.713837169653149, 
     22.183187569226284`}}], 
   Line3DBox[{{12, 8, 22}, {11.899099493979431`, 6.713938622940858, 
     22.160826684109125`}}], 
   Line3DBox[{{23, 8, 22}, {22.95038910799728, 6.715910372674783, 
     22.19660261542126}}], 
   Line3DBox[{{6, 9, 22}, {5.937263917415302, 7.716514384775669, 
     22.19679649248436}}], 
   Line3DBox[{{17, 9, 22}, {16.928485845949805`, 7.723236617014626, 
     22.234010661377273`}}], 
   Line3DBox[{{0, 10, 22}, {-0.11076995102097625`, 8.719481146635962, 
     22.194939693572298`}}], 
   Line3DBox[{{11, 10, 22}, {10.969431830872024`, 8.714123496006973, 
     22.188645708975415`}}], 
   Line3DBox[{{22, 10, 22}, {21.96274533898564, 8.716389567094524, 
     22.202376744634655`}}], 
   Line3DBox[{{5, 11, 22}, {4.955693214749991, 9.716979450254438, 
     22.20468311535495}}], 
   Line3DBox[{{16, 11, 22}, {15.940982569273979`, 9.719707802714721, 
     22.217643820130345`}}], 
   Line3DBox[{{27, 11, 22}, {26.89298460504348, 9.741708092096525, 
     22.308624658358553`}}], 
   Line3DBox[{{10, 12, 22}, {9.960844123334343, 10.719221962166575`, 
     22.219258831352597`}}], 
   Line3DBox[{{21, 12, 22}, {20.915949970052846`, 10.724337576920961`, 
     22.235840994761293`}}], 
   Line3DBox[{{4, 13, 22}, {3.9610389689371726`, 11.721795712160374`, 
     22.233828647960248`}}], 
   Line3DBox[{{15, 13, 22}, {14.990741745070881`, 11.714674545832155`, 
     22.19455786178895}}], 
   Line3DBox[{{26, 13, 22}, {25.901213312481776`, 11.744667872057912`, 
     22.32308271220473}}], 
   Line3DBox[{{9, 14, 22}, {8.982554579279682, 12.727642341836434`, 
     22.266085788813342`}}], 
   Line3DBox[{{20, 14, 22}, {19.939519950282822`, 12.72423430809485, 
     22.242413000773432`}}], 
   Line3DBox[{{3, 15, 22}, {2.9714580242401674`, 13.719655480478755`, 
     22.223390391359246`}}], 
   Line3DBox[{{14, 15, 22}, {14.008964401340817`, 13.721620682339292`, 
     22.23593634668262}}], 
   Line3DBox[{{25, 15, 22}, {24.960254050230592`, 13.732359520311178`, 
     22.285495838378115`}}], 
   Line3DBox[{{8, 16, 22}, {7.9515180258868625`, 14.721923195935862`, 
     22.23274273586793}}], 
   Line3DBox[{{19, 16, 22}, {18.999151401950233`, 14.727419409168247`, 
     22.26558975831093}}], 
   Line3DBox[{{2, 17, 22}, {1.9619631152918824`, 15.715064953348909`, 
     22.19363657012419}}], 
   Line3DBox[{{13, 17, 22}, {13.03210042654363, 15.719025563133552`, 
     22.219257963847166`}}], 
   Line3DBox[{{24, 17, 22}, {24.036758906937862`, 15.720649274113754`, 
     22.227838765215818`}}], 
   Line3DBox[{{7, 18, 22}, {6.951853567470887, 16.713232691486724`, 
     22.178638782956607`}}], 
   Line3DBox[{{18, 18, 22}, {17.99298403994495, 16.72615526573879, 
     22.259365320155744`}}], 
   Line3DBox[{{1, 19, 22}, {0.93475286611768, 17.715114579592047`, 
     22.18658045970365}}], 
   Line3DBox[{{12, 19, 22}, {11.981953540533041`, 17.72417309586971, 
     22.24887755221801}}], 
   Line3DBox[{{23, 19, 22}, {23.060762606015114`, 17.71619710548224, 
     22.19534081431711}}], 
   Line3DBox[{{6, 20, 22}, {5.950748903178624, 18.71475972707695, 
     22.189028490758854`}}], 
   Line3DBox[{{17, 20, 22}, {17.036952513942204`, 18.718510348532114`, 
     22.21545019121382}}], 
   Line3DBox[{{0, 21, 22}, {-0.10969064485210463`, 19.722444504517334`, 
     22.21405587680316}}], 
   Line3DBox[{{11, 21, 22}, {10.949272597949948`, 19.72733126266051, 
     22.260271042722703`}}], 
   Line3DBox[{{22, 21, 22}, {22.073589577075303`, 19.720231622040295`, 
     22.216281004529435`}}], 
   Line3DBox[{{5, 22, 22}, {4.9724458567459635`, 20.723346301237047`, 
     22.24371315644504}}], 
   Line3DBox[{{16, 22, 22}, {16.038750159438045`, 20.718833680503565`, 
     22.217051346301936`}}], 
   Line3DBox[{{27, 22, 22}, {26.995903845956487`, 20.71693806967001, 
     22.209129874623244`}}], 
   Line3DBox[{{10, 23, 22}, {9.94501482619164, 21.726782261141647`, 
     22.256696747384314`}}], 
   Line3DBox[{{21, 23, 22}, {21.04394058235705, 21.717730999083773`, 
     22.209416891657337`}}], 
   Line3DBox[{{4, 24, 22}, {3.948323439898876, 22.72623846872316, 
     22.254678414035034`}}], 
   Line3DBox[{{15, 24, 22}, {15.057372690948785`, 22.72160249670416, 
     22.228928368491676`}}], 
   Line3DBox[{{26, 24, 22}, {26.024091397287105`, 22.7190298959566, 
     22.22030705191571}}], 
   Line3DBox[{{9, 25, 22}, {8.918908216448791, 23.72455097110643, 
     22.238020791812254`}}], 
   Line3DBox[{{20, 25, 22}, {20.00628036235433, 23.71453474210464, 
     22.193751458814408`}}], 
   Line3DBox[{{3, 26, 22}, {2.9296994515470876`, 24.718300506392943`, 
     22.20567994791578}}], 
   Line3DBox[{{14, 26, 22}, {14.012305841752847`, 24.707957650314363`, 
     22.143091344523594`}}], 
   Line3DBox[{{25, 26, 22}, {25.06347478246256, 24.717617099873134`, 
     22.203629687063398`}}], 
   Line3DBox[{{8, 27, 22}, {7.920830116520138, 25.722372660216337`, 
     22.22671680614173}}], 
   Line3DBox[{{19, 27, 22}, {18.98046760757763, 25.704684309311094`, 
     22.108516114477887`}}], 
   Line3DBox[{{2, 1, 23}, {1.9711369628466617`, -0.2867907451768186, 
     23.182582866703243`}}], 
   Line3DBox[{{13, 1, 23}, {12.93255930045482, -0.29553781732825946`, 
     23.083866059387493`}}], 
   Line3DBox[{{24, 1, 23}, {23.960655981786086`, -0.29733179000377263`, 
     23.073363988961823`}}], 
   Line3DBox[{{7, 2, 23}, {6.92237574941069, 0.7132001524374261, 
     23.16769206311983}}], 
   Line3DBox[{{18, 2, 23}, {17.991136757064865`, 0.707097179454867, 
     23.13536520805256}}], 
   Line3DBox[{{1, 3, 23}, {0.9115105353045435, 1.7196090545632188`, 
     23.206805806208187`}}], 
   Line3DBox[{{12, 3, 23}, {11.920865104343392`, 1.7070591336072571`, 
     23.109734152846784`}}], 
   Line3DBox[{{23, 3, 23}, {22.954200516216165`, 1.7051126655831883`, 
     23.105684428616797`}}], 
   Line3DBox[{{6, 4, 23}, {5.933901353096289, 2.7162356200298747`, 
     23.19385557922696}}], 
   Line3DBox[{{17, 4, 23}, {16.942799580948222`, 2.7231466753588096`, 
     23.237431462559282`}}], 
   Line3DBox[{{0, 5, 23}, {-0.07968549816781904, 3.718830428156128, 
     23.205559600999653`}}], 
   Line3DBox[{{11, 5, 23}, {10.885618417822354`, 3.7156650488852896`, 
     23.16553122667253}}], 
   Line3DBox[{{22, 5, 23}, {21.971429522144263`, 3.7066371946811567`, 
     23.12804835654106}}], 
   Line3DBox[{{5, 6, 23}, {4.922721158257485, 4.713374080987909, 
     23.16917956479796}}], 
   Line3DBox[{{16, 6, 23}, {15.890906644722463`, 4.725819941010523, 
     23.233588991837934`}}], 
   Line3DBox[{{27, 6, 23}, {26.92835752886086, 4.70895126161524, 
     23.13438940227636}}], 
   Line3DBox[{{10, 7, 23}, {9.908827128289357, 5.712024093980551, 
     23.151015141550154`}}], 
   Line3DBox[{{21, 7, 23}, {20.95384445967678, 5.71568700623915, 
     23.195984183429463`}}], 
   Line3DBox[{{4, 8, 23}, {3.9344494966511014`, 6.71233443992599, 
     23.16619427460052}}], 
   Line3DBox[{{15, 8, 23}, {14.913871557586116`, 6.725596008869068, 
     23.241818855337854`}}], 
   Line3DBox[{{26, 8, 23}, {25.966819687538575`, 6.717168685758197, 
     23.20794923915612}}], 
   Line3DBox[{{9, 9, 23}, {8.943140661534086, 7.70906567160978, 
     23.142322083363446`}}], 
   Line3DBox[{{20, 9, 23}, {19.947694955503746`, 7.715584186660451, 
     23.19375293743206}}], 
   Line3DBox[{{3, 10, 23}, {2.911891062587038, 8.721160335961333, 
     23.21634677910574}}], 
   Line3DBox[{{14, 10, 23}, {13.94298188869424, 8.720831532380476, 
     23.224670795679017`}}], 
   Line3DBox[{{25, 10, 23}, {24.967648586855315`, 8.724944950037926, 
     23.251372245153984`}}], 
   Line3DBox[{{8, 11, 23}, {7.932223315280865, 9.713437184249226, 
     23.17367337774088}}], 
   Line3DBox[{{19, 11, 23}, {18.92780031464322, 9.723787976683639, 
     23.236791209670336`}}], 
   Line3DBox[{{2, 12, 23}, {1.8965699164017813`, 10.723884033957415`, 
     23.22545566974034}}], 
   Line3DBox[{{13, 12, 23}, {12.962350193397523`, 10.720678721954654`, 
     23.22785863951849}}], 
   Line3DBox[{{24, 12, 23}, {23.97262329662009, 10.724025369663503`, 
     23.247263541286795`}}], 
   Line3DBox[{{7, 13, 23}, {6.958928590566041, 11.723724745439698`, 
     23.243792153122588`}}], 
   Line3DBox[{{18, 13, 23}, {17.930019657364717`, 11.725688325601716`, 
     23.247452031991838`}}], 
   Line3DBox[{{1, 14, 23}, {0.9325318076667932, 12.723918682351366`, 
     23.23888179874452}}], 
   Line3DBox[{{12, 14, 23}, {12.02710659914982, 12.7202731550428, 
     23.227078036318844`}}], 
   Line3DBox[{{23, 14, 23}, {22.987774880502343`, 12.713302056202332`, 
     23.1850917282866}}], 
   Line3DBox[{{6, 15, 23}, {5.9548397488820894`, 13.72279726137391, 
     23.238146417493493`}}], 
   Line3DBox[{{17, 15, 23}, {16.978022928786846`, 13.722612568178263`, 
     23.24041288934822}}], 
   Line3DBox[{{0, 16, 23}, {-0.04769370544647899, 14.720663954886525`, 
     23.225886241577918`}}], 
   Line3DBox[{{11, 16, 23}, {11.003197906551582`, 14.72025821963863, 
     23.228584227345628`}}], 
   Line3DBox[{{22, 16, 23}, {22.018003591169553`, 14.716262788817543`, 
     23.204192662283656`}}], 
   Line3DBox[{{5, 17, 23}, {4.9210409436127645`, 15.717234966697056`, 
     23.195651058647112`}}], 
   Line3DBox[{{16, 17, 23}, {15.978045437080764`, 15.725379316953305`, 
     23.254676484027485`}}], 
   Line3DBox[{{27, 17, 23}, {26.923362609585915`, 15.732538462948494`, 
     23.278689724398927`}}], 
   Line3DBox[{{10, 18, 23}, {9.962198465589038, 16.722346668028955`, 
     23.237008454067485`}}], 
   Line3DBox[{{21, 18, 23}, {21.029202782248223`, 16.71740071832232, 
     23.209967331146682`}}], 
   Line3DBox[{{4, 19, 23}, {3.9673231704694207`, 17.71486193334324, 
     23.193267623883436`}}], 
   Line3DBox[{{15, 19, 23}, {14.999630834895086`, 17.721277106508907`, 
     23.234238394331282`}}], 
   Line3DBox[{{26, 19, 23}, {25.96964394436851, 17.725465285797355`, 
     23.254243529276327`}}], 
   Line3DBox[{{9, 20, 23}, {8.927418854289371, 18.724417512395714`, 
     23.240044359660036`}}], 
   Line3DBox[{{20, 20, 23}, {20.042574295376788`, 18.715808669476598`, 
     23.197585566228167`}}], 
   Line3DBox[{{3, 21, 23}, {2.9683908073354637`, 19.722424582578384`, 
     23.238331516462}}], 
   Line3DBox[{{14, 21, 23}, {13.990295454875941`, 19.721972399849502`, 
     23.237805119914377`}}], 
   Line3DBox[{{25, 21, 23}, {25.015238052557724`, 19.721404193667695`, 
     23.234436698884128`}}], 
   Line3DBox[{{8, 22, 23}, {7.947004585780393, 20.721367241152784`, 
     23.228669530271198`}}], 
   Line3DBox[{{19, 22, 23}, {19.07805539234266, 20.719913344373524`, 
     23.21280392339724}}], 
   Line3DBox[{{2, 23, 23}, {1.9126060893757493`, 21.721704288670843`, 
     23.21982351735718}}], 
   Line3DBox[{{13, 23, 23}, {13.017507028440013`, 21.72718448188454, 
     23.263882854311667`}}], 
   Line3DBox[{{24, 23, 23}, {24.027456558343147`, 21.720567732479296`, 
     23.228690205804217`}}], 
   Line3DBox[{{7, 24, 23}, {6.956972032777712, 22.724789219208276`, 
     23.24896999535945}}], 
   Line3DBox[{{18, 24, 23}, {18.022368221187914`, 22.71881910688314, 
     23.219260534052914`}}], 
   Line3DBox[{{1, 25, 23}, {0.8846829651118434, 23.718954174757812`, 
     23.18874208617626}}], 
   Line3DBox[{{12, 25, 23}, {11.942590798752702`, 23.717657293052717`, 
     23.205672957753965`}}], 
   Line3DBox[{{23, 25, 23}, {23.024485164719728`, 23.71770905521165, 
     23.212439190410933`}}], 
   Line3DBox[{{6, 26, 23}, {5.970488138701963, 24.719781509239642`, 
     23.22398586106717}}], 
   Line3DBox[{{17, 26, 23}, {16.989593982644372`, 24.707820069864923`, 
     23.141995573729975`}}], 
   Line3DBox[{{0, 27, 23}, {-0.08514020698189945, 25.71019518247501, 
     23.13840042573782}}], 
   Line3DBox[{{11, 27, 23}, {10.910814112141974`, 25.710833792457723`, 
     23.141761654681513`}}], 
   Line3DBox[{{22, 27, 23}, {22.009859580117094`, 25.70171339498172, 
     23.065989998560532`}}], 
   Line3DBox[{{5, 1, 24}, {4.921036369831647, -0.28908958381146266`, 
     24.14836707862402}}], 
   Line3DBox[{{16, 1, 24}, {15.967085606124789`, -0.2956273865025456, 
     24.101322840566233`}}], 
   Line3DBox[{{27, 1, 24}, {26.988429815174484`, -0.2996587811562179, 
     24.027444186754888`}}], 
   Line3DBox[{{10, 2, 24}, {9.960597403443685, 0.7040712636896862, 
     24.094953387458123`}}], 
   Line3DBox[{{21, 2, 24}, {21.040691399134648`, 0.703903037967132, 
     24.092069946484372`}}], 
   Line3DBox[{{4, 3, 24}, {3.9185281885423273`, 1.7255667252152511`, 
     24.243273862260676`}}], 
   Line3DBox[{{15, 3, 24}, {14.949091022312453`, 1.7149924813562376`, 
     24.190168222949602`}}], 
   Line3DBox[{{26, 3, 24}, {25.965449818853997`, 1.7061335799876989`, 
     24.121309406672893`}}], 
   Line3DBox[{{9, 4, 24}, {8.925342078243139, 2.7129421033996604`, 
     24.167057371934483`}}], 
   Line3DBox[{{20, 4, 24}, {19.983551359323975`, 2.7115449117798858`, 
     24.172084072068305`}}], 
   Line3DBox[{{3, 5, 24}, {2.9144705046054744`, 3.7204136290727012`, 
     24.212939955749654`}}], 
   Line3DBox[{{14, 5, 24}, {13.933629601020398`, 3.7166908262590503`, 
     24.196755011960583`}}], 
   Line3DBox[{{25, 5, 24}, {24.94845120768011, 3.705010246715828, 
     24.10170673969487}}], 
   Line3DBox[{{8, 6, 24}, {7.934970673364672, 4.710617423829458, 
     24.15252461750541}}], 
   Line3DBox[{{19, 6, 24}, {18.97133003043028, 4.712811073056152, 
     24.17978514732318}}], 
   Line3DBox[{{2, 7, 24}, {1.9419383381006483`, 5.718305615698775, 
     24.209495462166103`}}], 
   Line3DBox[{{13, 7, 24}, {12.927816208351276`, 5.717697853200305, 
     24.201223021883948`}}], 
   Line3DBox[{{24, 7, 24}, {23.98035827378533, 5.708179811036072, 
     24.14427335851262}}], 
   Line3DBox[{{7, 8, 24}, {6.92660125082861, 6.709761022465144, 
     24.141053197304718`}}], 
   Line3DBox[{{18, 8, 24}, {17.95097157377164, 6.715442230640858, 
     24.193668661896123`}}], 
   Line3DBox[{{1, 9, 24}, {0.9025349691520524, 7.724663680847525, 
     24.23241738491865}}], 
   Line3DBox[{{12, 9, 24}, {11.958353100723157`, 7.711368095727169, 
     24.166413193800256`}}], 
   Line3DBox[{{23, 9, 24}, {22.99501158155746, 7.71354111637744, 
     24.187079278462477`}}], 
   Line3DBox[{{6, 10, 24}, {5.902524616662781, 8.71491092792358, 
     24.170424841126604`}}], 
   Line3DBox[{{17, 10, 24}, {16.938267599066656`, 8.72211419770193, 
     24.230644720208424`}}], 
   Line3DBox[{{0, 11, 24}, {-0.12344657185111152`, 9.725992055965593, 
     24.22729870750937}}], 
   Line3DBox[{{11, 11, 24}, {10.959726705326784`, 9.714995059041751, 
     24.192718352652392`}}], 
   Line3DBox[{{22, 11, 24}, {21.977681809520714`, 9.715983073572586, 
     24.20199611635283}}], 
   Line3DBox[{{5, 12, 24}, {4.925764238641884, 10.720738479789029`, 
     24.219041125460713`}}], 
   Line3DBox[{{16, 12, 24}, {15.93358933176015, 10.72349575017809, 
     24.23691036982483}}], 
   Line3DBox[{{27, 12, 24}, {26.909708595894443`, 10.730908674020473`, 
     24.266935701374262`}}], 
   Line3DBox[{{10, 13, 24}, {9.990984960637205, 11.72612483830931, 
     24.25915401114551}}], 
   Line3DBox[{{21, 13, 24}, {20.969091340174376`, 11.716363228802209`, 
     24.20327639896627}}], 
   Line3DBox[{{4, 14, 24}, {3.9295182788576732`, 12.726114778268922`, 
     24.24949703172578}}], 
   Line3DBox[{{15, 14, 24}, {14.949123727098495`, 12.728110206919538`, 
     24.264022648864433`}}], 
   Line3DBox[{{26, 14, 24}, {25.90594397611151, 12.73037781134063, 
     24.26308356549598}}], 
   Line3DBox[{{9, 15, 24}, {8.957915552529943, 13.734256770927951`, 
     24.293467165692178`}}], 
   Line3DBox[{{20, 15, 24}, {19.9740428264398, 13.719824597919775`, 
     24.224671237699667`}}], 
   Line3DBox[{{3, 16, 24}, {2.9320349015377336`, 14.7219510619542, 
     24.227972931180478`}}], 
   Line3DBox[{{14, 16, 24}, {13.977195229131361`, 14.721616572348953`, 
     24.234980327544218`}}], 
   Line3DBox[{{25, 16, 24}, {24.958434938818833`, 14.72217306468401, 
     24.235437187100835`}}], 
   Line3DBox[{{8, 17, 24}, {7.923097366267958, 15.72388479704711, 
     24.2358303918446}}], 
   Line3DBox[{{19, 17, 24}, {18.99303598416675, 15.72933383673281, 
     24.274515944912704`}}], 
   Line3DBox[{{2, 18, 24}, {1.9491461059284898`, 16.71617558693828, 
     24.198012014495315`}}], 
   Line3DBox[{{13, 18, 24}, {12.989439519931869`, 16.720150588438973`, 
     24.22775855634338}}], 
   Line3DBox[{{24, 18, 24}, {24.025015731028358`, 16.716420360176684`, 
     24.204444421376962`}}], 
   Line3DBox[{{7, 19, 24}, {6.918477315204805, 17.717166148956917`, 
     24.194142634374213`}}], 
   Line3DBox[{{18, 19, 24}, {18.015462801856433`, 17.722362004417448`, 
     24.23958725759637}}], 
   Line3DBox[{{1, 20, 24}, {0.8813846577690897, 18.723837200848127`, 
     24.217575068995277`}}], 
   Line3DBox[{{12, 20, 24}, {11.982637980630527`, 18.71877720229117, 
     24.219469138865986`}}], 
   Line3DBox[{{23, 20, 24}, {23.04063940367919, 18.718467926645243`, 
     24.21453201120498}}], 
   Line3DBox[{{6, 21, 24}, {5.936110002294895, 19.7226160027072, 
     24.2328265269541}}], 
   Line3DBox[{{17, 21, 24}, {17.043582665298796`, 19.72015140021351, 
     24.223803737479983`}}], 
   Line3DBox[{{0, 22, 24}, {-0.11963452794323864`, 20.721666752853945`, 
     24.20384231397044}}], 
   Line3DBox[{{11, 22, 24}, {10.97955512405612, 20.720076225399378`, 
     24.22666525596071}}], 
   Line3DBox[{{22, 22, 24}, {22.06619867133238, 20.7213775380521, 
     24.225260595125114`}}], 
   Line3DBox[{{5, 23, 24}, {4.964162172318068, 21.723189495119435`, 
     24.241806916223823`}}], 
   Line3DBox[{{16, 23, 24}, {16.025206925652302`, 21.719718296891607`, 
     24.22415033255615}}], 
   Line3DBox[{{27, 23, 24}, {26.96947471398631, 21.715594242053427`, 
     24.198418889895773`}}], 
   Line3DBox[{{10, 24, 24}, {9.954996197236115, 22.719458186074633`, 
     24.21951610538983}}], 
   Line3DBox[{{21, 24, 24}, {21.01567249667315, 22.71872653634178, 
     24.219300442711127`}}], 
   Line3DBox[{{4, 25, 24}, {3.97599595518104, 23.71629771139278, 
     24.20379460261968}}], 
   Line3DBox[{{15, 25, 24}, {14.991081925779616`, 23.71618867010614, 
     24.204325566653697`}}], 
   Line3DBox[{{26, 25, 24}, {26.035304158016675`, 23.717151636609337`, 
     24.20749383839678}}], 
   Line3DBox[{{9, 26, 24}, {8.926809509244746, 24.719178999150923`, 
     24.21009692012729}}], 
   Line3DBox[{{20, 26, 24}, {19.986047510604266`, 24.707531722542427`, 
     24.139036253565454`}}], 
   Line3DBox[{{3, 27, 24}, {2.9783084686670738`, 25.704151005903896`, 
     24.101512866024684`}}], 
   Line3DBox[{{14, 27, 24}, {13.995469284194588`, 25.702395564720092`, 
     24.07875406120448}}], 
   Line3DBox[{{25, 27, 24}, {25.05717513833701, 25.705813464367488`, 
     24.10868401236454}}], 
   Line3DBox[{{8, 1, 25}, {7.979408416477513, -0.29778131581447087`, 
     25.073072860973806`}}], 
   Line3DBox[{{19, 1, 25}, {19.065520378770433`, -0.2948223783373629, 
     25.09561426945051}}], 
   Line3DBox[{{2, 2, 25}, {1.9152983513755322`, 0.7151071172182126, 
     25.178538260597005`}}], 
   Line3DBox[{{13, 2, 25}, {12.995451645883959`, 0.7058141872386765, 
     25.122728947368365`}}], 
   Line3DBox[{{24, 2, 25}, {24.00968896308133, 0.7025778999708749, 
     25.081252805184956`}}], 
   Line3DBox[{{7, 3, 25}, {6.936011916559764, 1.71252385111548, 
     25.168257811798238`}}], 
   Line3DBox[{{18, 3, 25}, {17.99152233041017, 1.71603610938035, 
     25.203383521218353`}}], 
   Line3DBox[{{1, 4, 25}, {0.9171044892273469, 2.720669333109007, 
     25.21550261958034}}], 
   Line3DBox[{{12, 4, 25}, {11.968538213199624`, 2.7129934661722848`, 
     25.180622085737316`}}], 
   Line3DBox[{{23, 4, 25}, {22.97710977567899, 2.705614138239749, 
     25.11849590079706}}], 
   Line3DBox[{{6, 5, 25}, {5.962907904952308, 3.711651584036075, 
     25.16965416460617}}], 
   Line3DBox[{{17, 5, 25}, {16.963374679302092`, 3.718860282478417, 
     25.217576676306297`}}], 
   Line3DBox[{{0, 6, 25}, {-0.09443657447307674, 4.722261620459446, 
     25.220150782080992`}}], 
   Line3DBox[{{11, 6, 25}, {10.952081478752387`, 4.713374723957261, 
     25.17971982185999}}], 
   Line3DBox[{{22, 6, 25}, {21.978679852392894`, 4.705442367494299, 
     25.116901614305558`}}], 
   Line3DBox[{{5, 7, 25}, {4.970260565081215, 5.713087588906035, 
     25.181581970974623`}}], 
   Line3DBox[{{16, 7, 25}, {15.942266352928655`, 5.716471108243087, 
     25.198041435111723`}}], 
   Line3DBox[{{27, 7, 25}, {26.93648194517001, 5.710810398466085, 
     25.154776057604014`}}], 
   Line3DBox[{{10, 8, 25}, {9.97498542305828, 6.711141437483455, 
     25.167981775107346`}}], 
   Line3DBox[{{21, 8, 25}, {20.965862008964482`, 6.706743636322372, 
     25.127759834750115`}}], 
   Line3DBox[{{4, 9, 25}, {3.9103070677038954`, 7.718499485246046, 
     25.199277717222667`}}], 
   Line3DBox[{{15, 9, 25}, {14.956850573307117`, 7.7194362800280985`, 
     25.21976051981145}}], 
   Line3DBox[{{26, 9, 25}, {26.01875814953754, 7.716230588146474, 
     25.203922115071368`}}], 
   Line3DBox[{{9, 10, 25}, {8.97642379643947, 8.712753360237686, 
     25.18011177375814}}], 
   Line3DBox[{{20, 10, 25}, {19.93784712630339, 8.716171836435802, 
     25.194736403198352`}}], 
   Line3DBox[{{3, 11, 25}, {2.890680946174699, 9.726102394312917, 
     25.23501964746689}}], 
   Line3DBox[{{14, 11, 25}, {13.930334863502647`, 9.723801398803825, 
     25.23762133545145}}], 
   Line3DBox[{{25, 11, 25}, {24.969353570036503`, 9.720091758918882, 
     25.225600733028795`}}], 
   Line3DBox[{{8, 12, 25}, {7.9494132217478475`, 10.719934789574573`, 
     25.221074727014592`}}], 
   Line3DBox[{{19, 12, 25}, {18.927543810747895`, 10.721927048833287`, 
     25.22645006543402}}], 
   Line3DBox[{{2, 13, 25}, {1.8856758354540941`, 11.726585384330237`, 
     25.23525560992145}}], 
   Line3DBox[{{13, 13, 25}, {12.96962897600632, 11.729682051938736`, 
     25.274535811388965`}}], 
   Line3DBox[{{24, 13, 25}, {23.97592183626612, 11.7200437033716, 
     25.226124126869546`}}], 
   Line3DBox[{{7, 14, 25}, {6.917943527769694, 12.731498574532491`, 
     25.272343292467458`}}], 
   Line3DBox[{{18, 14, 25}, {17.930686402259155`, 12.723976642646978`, 
     25.23866297714087}}], 
   Line3DBox[{{1, 15, 25}, {0.907292819216468, 13.728787346707257`, 
     25.255780704392645`}}], 
   Line3DBox[{{12, 15, 25}, {11.971070745402603`, 13.720970733809246`, 
     25.23075362284476}}], 
   Line3DBox[{{23, 15, 25}, {22.991489673226347`, 13.7167075292985, 
     25.20757651355355}}], 
   Line3DBox[{{6, 16, 25}, {5.904757953964048, 14.73205069012252, 
     25.270616888327588`}}], 
   Line3DBox[{{17, 16, 25}, {16.93244856925283, 14.728105198769217`, 
     25.26023147159042}}], 
   Line3DBox[{{0, 17, 25}, {-0.09392300231019556, 15.72951174363334, 
     25.258917091114988`}}], 
   Line3DBox[{{11, 17, 25}, {10.973468886311688`, 15.721455620192769`, 
     25.233710010204526`}}], 
   Line3DBox[{{22, 17, 25}, {22.047766766418427`, 15.713218652750582`, 
     25.178639582391188`}}], 
   Line3DBox[{{5, 18, 25}, {4.9101823274768766`, 16.72265615901737, 
     25.224333451821764`}}], 
   Line3DBox[{{16, 18, 25}, {15.953204088980488`, 16.727275372086087`, 
     25.260733895405345`}}], 
   Line3DBox[{{27, 18, 25}, {26.910586759995006`, 16.727202881137163`, 
     25.24898346677294}}], 
   Line3DBox[{{10, 19, 25}, {9.953726713344889, 17.719633823311845`, 
     25.220275365247897`}}], 
   Line3DBox[{{21, 19, 25}, {21.053256185460953`, 17.716252183263112`, 
     25.19787703690278}}], 
   Line3DBox[{{4, 20, 25}, {3.958636822660142, 18.723708588167856`, 
     25.24365820249659}}], 
   Line3DBox[{{15, 20, 25}, {14.97725411447919, 18.72678604987753, 
     25.261550878234814`}}], 
   Line3DBox[{{26, 20, 25}, {25.94528589819444, 18.71940669377016, 
     25.216995739826704`}}], 
   Line3DBox[{{9, 21, 25}, {8.950145727955878, 19.718721094966547`, 
     25.214100254729473`}}], 
   Line3DBox[{{20, 21, 25}, {20.044169893676283`, 19.72106738951291, 
     25.22886764368365}}], 
   Line3DBox[{{3, 22, 25}, {2.9467695557410263`, 20.721796071195417`, 
     25.23100051123865}}], 
   Line3DBox[{{14, 22, 25}, {13.995009893908822`, 20.722276083868625`, 
     25.239576069312236`}}], 
   Line3DBox[{{25, 22, 25}, {24.988999057830217`, 20.71497358448708, 
     25.196433425631678`}}], 
   Line3DBox[{{8, 23, 25}, {7.936232042843488, 21.723258507082118`, 
     25.236357373275936`}}], 
   Line3DBox[{{19, 23, 25}, {19.014219665257514`, 21.71711241510702, 
     25.209755204100937`}}], 
   Line3DBox[{{2, 24, 25}, {1.9354336138570762`, 22.71863469872034, 
     25.20960473863185}}], 
   Line3DBox[{{13, 24, 25}, {12.996671514516569`, 22.715968778957404`, 
     25.20310771667331}}], 
   Line3DBox[{{24, 24, 25}, {24.04322968109676, 22.715916213585942`, 
     25.198141424595686`}}], 
   Line3DBox[{{7, 25, 25}, {6.964578619240914, 23.719933131244694`, 
     25.223995842149147`}}], 
   Line3DBox[{{18, 25, 25}, {17.98337271579116, 23.714004993558866`, 
     25.18957947364709}}], 
   Line3DBox[{{1, 26, 25}, {0.951691773123799, 24.707591632899206`, 
     25.131707736537894`}}], 
   Line3DBox[{{12, 26, 25}, {11.9649013931121, 24.709419630417344`, 
     25.152218255943307`}}], 
   Line3DBox[{{23, 26, 25}, {23.03212853367246, 24.70788573300241, 
     25.139314314933305`}}], 
   Line3DBox[{{6, 27, 25}, {5.996946694782178, 25.71166289188649, 
     25.173718661015343`}}], 
   Line3DBox[{{17, 27, 25}, {16.96831754688643, 25.703577811016192`, 
     25.09102598571361}}], 
   Line3DBox[{{0, 1, 26}, {-0.09231114725031583, -0.293607255558757, 
     26.089771490235332`}}], 
   Line3DBox[{{11, 1, 26}, {11.05239905724247, -0.29719188161699095`, 
     26.067435606819192`}}], 
   Line3DBox[{{22, 1, 26}, {22.07042283142782, -0.29707581084309265`, 
     26.051331917355785`}}], 
   Line3DBox[{{5, 2, 26}, {4.937447395276715, 0.7129832025201857, 
     26.172264142081676`}}], 
   Line3DBox[{{16, 2, 26}, {16.00386703186498, 0.7075391680927665, 
     26.139749933990025`}}], 
   Line3DBox[{{27, 2, 26}, {26.977345990142698`, 0.7011483346368643, 
     26.04971063488626}}], 
   Line3DBox[{{10, 3, 26}, {9.982606750766978, 1.7056526403582124`, 
     26.11984317865215}}], 
   Line3DBox[{{21, 3, 26}, {21.04266344559761, 1.707172378291361, 
     26.129524402939843`}}], 
   Line3DBox[{{4, 4, 26}, {3.950639591821716, 2.718113986944906, 
     26.210551180567077`}}], 
   Line3DBox[{{15, 4, 26}, {14.983025642689377`, 2.7205103332553984`, 
     26.229386276589686`}}], 
   Line3DBox[{{26, 4, 26}, {25.98902598534888, 2.703499617717899, 
     26.094690705693864`}}], 
   Line3DBox[{{9, 5, 26}, {8.92995315340473, 3.7114241047129113`, 
     26.157052861696748`}}], 
   Line3DBox[{{20, 5, 26}, {19.99171918453406, 3.7092606072266143`, 
     26.154671419590727`}}], 
   Line3DBox[{{3, 6, 26}, {2.9348322545151015`, 4.716214482123328, 
     26.194030690970628`}}], 
   Line3DBox[{{14, 6, 26}, {13.994879313734792`, 4.717854159897942, 
     26.21465279704947}}], 
   Line3DBox[{{25, 6, 26}, {24.975191949077523`, 4.705413344237222, 
     26.115887666860516`}}], 
   Line3DBox[{{8, 7, 26}, {7.967281782699142, 5.7111398547500265`, 
     26.16664046400221}}], 
   Line3DBox[{{19, 7, 26}, {18.935777182051815`, 5.706664253833785, 
     26.114708662896376`}}], 
   Line3DBox[{{2, 8, 26}, {1.9483567776741855`, 6.719911635976577, 
     26.220696075813873`}}], 
   Line3DBox[{{13, 8, 26}, {12.995878907280519`, 6.716312849804833, 
     26.20525671004527}}], 
   Line3DBox[{{24, 8, 26}, {23.987534664675866`, 6.709923792600142, 
     26.15983740024179}}], 
   Line3DBox[{{7, 9, 26}, {6.951723665415901, 7.713702478202114, 
     26.181956261051226`}}], 
   Line3DBox[{{18, 9, 26}, {17.93003583329722, 7.714471773308617, 
     26.180339107675774`}}], 
   Line3DBox[{{1, 10, 26}, {0.9049358709783869, 8.722542730344207, 
     26.221507867979742`}}], 
   Line3DBox[{{12, 10, 26}, {11.97617264649039, 8.717609939725538, 
     26.211915054996076`}}], 
   Line3DBox[{{23, 10, 26}, {22.994935026621224`, 8.713942298392379, 
     26.189815526710532`}}], 
   Line3DBox[{{6, 11, 26}, {5.943384756277063, 9.722763520433604, 
     26.235503056122493`}}], 
   Line3DBox[{{17, 11, 26}, {16.913703480716098`, 9.721340022103648, 
     26.218132005183982`}}], 
   Line3DBox[{{0, 12, 26}, {-0.11965784553799495`, 10.726372261354554`, 
     26.231418200135796`}}], 
   Line3DBox[{{11, 12, 26}, {10.981413524476372`, 10.721017548128694`, 
     26.23207419230253}}], 
   Line3DBox[{{22, 12, 26}, {21.977052299506727`, 10.717124128989301`, 
     26.209052392047095`}}], 
   Line3DBox[{{5, 13, 26}, {4.911193620722927, 11.730620133394678`, 
     26.266060484207546`}}], 
   Line3DBox[{{16, 13, 26}, {15.913823736590555`, 11.729062282893173`, 
     26.259405032449397`}}], 
   Line3DBox[{{27, 13, 26}, {26.90582773125745, 11.727012584995665`, 
     26.246240989765024`}}], 
   Line3DBox[{{10, 14, 26}, {9.97729662376707, 12.727328006012273`, 
     26.264179015871676`}}], 
   Line3DBox[{{21, 14, 26}, {21.012089016934272`, 12.718562959010587`, 
     26.2185702762268}}], 
   Line3DBox[{{4, 15, 26}, {3.865489803184056, 13.73187986177658, 
     26.25254370311839}}], 
   Line3DBox[{{15, 15, 26}, {14.901198886629201`, 13.734193122657265`, 
     26.279233395689925`}}], 
   Line3DBox[{{26, 15, 26}, {25.926948509114187`, 13.722252389696454`, 
     26.228088851202628`}}], 
   Line3DBox[{{9, 16, 26}, {8.95535457870527, 14.729807248015863`, 
     26.27316141595105}}], 
   Line3DBox[{{20, 16, 26}, {20.00069437131858, 14.721527110779473`, 
     26.235598364545655`}}], 
   Line3DBox[{{3, 17, 26}, {2.880072460974642, 15.730097463008804`, 
     26.250928140961992`}}], 
   Line3DBox[{{14, 17, 26}, {13.953086838959512`, 15.72617731654168, 
     26.255293804132087`}}], 
   Line3DBox[{{25, 17, 26}, {24.944483109078643`, 15.718390411795172`, 
     26.210700589092383`}}], 
   Line3DBox[{{8, 18, 26}, {7.932563726321725, 16.724255810380065`, 
     26.240684672639045`}}], 
   Line3DBox[{{19, 18, 26}, {19.00032812103848, 16.722913232691777`, 
     26.243000578400164`}}], 
   Line3DBox[{{2, 19, 26}, {1.8894159213707729`, 17.7270221866422, 
     26.239371360552}}], 
   Line3DBox[{{13, 19, 26}, {12.990273876654516`, 17.724403166985276`, 
     26.250515712336515`}}], 
   Line3DBox[{{24, 19, 26}, {23.98351100340169, 17.714580739896803`, 
     26.193456555192462`}}], 
   Line3DBox[{{7, 20, 26}, {6.956117533792527, 18.718228177642533`, 
     26.212450757988695`}}], 
   Line3DBox[{{18, 20, 26}, {18.016964837949416`, 18.71991782468254, 
     26.226057113818328`}}], 
   Line3DBox[{{1, 21, 26}, {0.8697633806576427, 19.726987849918554`, 
     26.229081838492906`}}], 
   Line3DBox[{{12, 21, 26}, {11.964065382171317`, 19.717130112108258`, 
     26.207252391981694`}}], 
   Line3DBox[{{23, 21, 26}, {23.006852863363918`, 19.718528109075955`, 
     26.218592843055923`}}], 
   Line3DBox[{{6, 22, 26}, {5.992654564200461, 20.721898799632786`, 
     26.237493928749345`}}], 
   Line3DBox[{{17, 22, 26}, {17.010777401705404`, 20.71988211461397, 
     26.226234495882654`}}], 
   Line3DBox[{{0, 23, 26}, {-0.09095701652887912, 21.718598661775964`, 
     26.1993424980826}}], 
   Line3DBox[{{11, 23, 26}, {10.969063745092193`, 21.711931386568054`, 
     26.1729803318987}}], 
   Line3DBox[{{22, 23, 26}, {22.06567850448411, 21.720524262261392`, 
     26.22051795978328}}], 
   Line3DBox[{{5, 24, 26}, {5.000949879586451, 22.719672325618642`, 
     26.22530011971145}}], 
   Line3DBox[{{16, 24, 26}, {15.986068181052271`, 22.722674814169014`, 
     26.241342648660883`}}], 
   Line3DBox[{{27, 24, 26}, {27.013345203710124`, 22.717536070617978`, 
     26.212386853105265`}}], 
   Line3DBox[{{10, 25, 26}, {9.954849060822468, 23.71362507173157, 
     26.182211241732713`}}], 
   Line3DBox[{{21, 25, 26}, {21.026099180112904`, 23.712332879200506`, 
     26.176726395338605`}}], 
   Line3DBox[{{4, 26, 26}, {4.0005869861639205`, 24.708033821874736`, 
     26.14430194048466}}], 
   Line3DBox[{{15, 26, 26}, {14.977841796697302`, 24.711187278415192`, 
     26.168732873820005`}}], 
   Line3DBox[{{26, 26, 26}, {26.03870259408072, 24.711308655122874`, 
     26.16666351385413}}], 
   Line3DBox[{{9, 27, 26}, {8.970537146095129, 25.709113470175694`, 
     26.150810833025822`}}], 
   Line3DBox[{{20, 27, 26}, {19.96271362125277, 25.702350805125565`, 
     26.068675272126487`}}], 
   Line3DBox[{{3, 1, 27}, {2.9395785607024227`, -0.29371595999949673`, 
     27.11246450335901}}], 
   Line3DBox[{{14, 1, 27}, {14.025782888993755`, -0.296808091165333, 
     27.08731561901093}}], 
   Line3DBox[{{25, 1, 27}, {25.013475067186686`, -0.2992534473902453, 
     27.041939265716945`}}], 
   Line3DBox[{{8, 2, 27}, {7.988225532802749, 0.7049157907003785, 
     27.112330996367856`}}], 
   Line3DBox[{{19, 2, 27}, {19.051080324917333`, 0.7098903300972605, 
     27.151683354491468`}}], 
   Line3DBox[{{2, 3, 27}, {1.937958539827483, 1.7161685307302081`, 
     27.194750136668063`}}], 
   Line3DBox[{{13, 3, 27}, {13.006359700184046`, 1.7135339093989925`, 
     27.186988106432814`}}], 
   Line3DBox[{{24, 3, 27}, {24.082017101284812`, 1.704667715112287, 
     27.073399365286168`}}], 
   Line3DBox[{{7, 4, 27}, {6.928938947230411, 2.712552425425134, 
     27.165617237933052`}}], 
   Line3DBox[{{18, 4, 27}, {18.005799138796778`, 2.713454588430838, 
     27.18645984543475}}], 
   Line3DBox[{{1, 5, 27}, {0.9588406400682525, 3.7168173156070035`, 
     27.20432353159632}}], 
   Line3DBox[{{12, 5, 27}, {12.015997773844557`, 3.7167851633679674`, 
     27.207614436587257`}}], 
   Line3DBox[{{23, 5, 27}, {23.02581933256332, 3.7048440754397816`, 
     27.10910771348787}}], 
   Line3DBox[{{6, 6, 27}, {5.980608008372264, 4.712376454073062, 
     27.17790321704581}}], 
   Line3DBox[{{17, 6, 27}, {16.958947449948692`, 4.713946471174621, 
     27.18542116688791}}], 
   Line3DBox[{{0, 7, 27}, {-0.09274447346119243, 5.7213539487493446`, 
     27.215552170630485`}}], 
   Line3DBox[{{11, 7, 27}, {10.993913948257662`, 5.714865387472997, 
     27.195938734453556`}}], 
   Line3DBox[{{22, 7, 27}, {21.974444477161853`, 5.703961043095853, 
     27.098132244646084`}}], 
   Line3DBox[{{5, 8, 27}, {4.970466722322859, 6.713025487485587, 
     27.181175024901155`}}], 
   Line3DBox[{{16, 8, 27}, {15.959808725757913`, 6.712830907028314, 
     27.177708715524158`}}], 
   Line3DBox[{{27, 8, 27}, {26.935186133202453`, 6.7104578956600065`, 
     27.151262433555495`}}], 
   Line3DBox[{{10, 9, 27}, {9.990396193335108, 7.715368856810899, 
     27.199074339999427`}}], 
   Line3DBox[{{21, 9, 27}, {20.955011012199456`, 7.71048566238859, 
     27.15852054778889}}], 
   Line3DBox[{{4, 10, 27}, {3.920108072652034, 8.724114254210033, 
     27.236078045642977`}}], 
   Line3DBox[{{15, 10, 27}, {14.956688390840911`, 8.723863718698368, 
     27.244131718663706`}}], 
   Line3DBox[{{26, 10, 27}, {25.961331007634072`, 8.720027071628236, 
     27.223995561707845`}}], 
   Line3DBox[{{9, 11, 27}, {8.995198870787112, 9.720376316522541, 
     27.229216443218768`}}], 
   Line3DBox[{{20, 11, 27}, {19.91585670415789, 9.721037208909442, 
     27.217195959379254`}}], 
   Line3DBox[{{3, 12, 27}, {2.913576808125553, 10.72477770157832, 
     27.237358634800508`}}], 
   Line3DBox[{{14, 12, 27}, {13.950853453743127`, 10.725561399155154`, 
     27.25177543499645}}], 
   Line3DBox[{{25, 12, 27}, {24.9577961185871, 10.724883493604825`, 
     27.249593123928225`}}], 
   Line3DBox[{{8, 13, 27}, {7.971895545934692, 11.729908765089842`, 
     27.275823122065717`}}], 
   Line3DBox[{{19, 13, 27}, {18.90320592568876, 11.722590373016377`, 
     27.221032920778317`}}], 
   Line3DBox[{{2, 14, 27}, {1.8494623437053828`, 12.732821495258277`, 
     27.248187532236923`}}], 
   Line3DBox[{{13, 14, 27}, {12.973331118330469`, 12.730496904301676`, 
     27.27865868147766}}], 
   Line3DBox[{{24, 14, 27}, {23.979691562502257`, 12.724804183918197`, 
     27.2519190306703}}], 
   Line3DBox[{{7, 15, 27}, {6.892901291519532, 13.737791630037739`, 
     27.292164161797828`}}], 
   Line3DBox[{{18, 15, 27}, {17.91879053049279, 13.728850604151942`, 
     27.259969681881323`}}], 
   Line3DBox[{{1, 16, 27}, {0.8667905176598152, 14.737269012654615`, 
     27.27886499854304}}], 
   Line3DBox[{{12, 16, 27}, {11.952624202337768`, 14.73061611323316, 
     27.276441823558912`}}], 
   Line3DBox[{{23, 16, 27}, {22.992272158253442`, 14.719540342625447`, 
     27.224417794076537`}}], 
   Line3DBox[{{6, 17, 27}, {5.882368116946755, 15.731947486937262`, 
     27.261161950147077`}}], 
   Line3DBox[{{17, 17, 27}, {16.946198670578163`, 15.734048121937372`, 
     27.290639397505135`}}], 
   Line3DBox[{{0, 18, 27}, {-0.10692062633348107`, 16.73051740567276, 
     27.258808659755886`}}], 
   Line3DBox[{{11, 18, 27}, {10.992599230455916`, 16.7190134244183, 
     27.22140149455147}}], 
   Line3DBox[{{22, 18, 27}, {22.028054302040854`, 16.713434475237918`, 
     27.184288107675638`}}], 
   Line3DBox[{{5, 19, 27}, {4.961113355230915, 17.72518033216381, 
     27.251639908115997`}}], 
   Line3DBox[{{16, 19, 27}, {16.001502540659533`, 17.730638906239932`, 
     27.280571124707826`}}], 
   Line3DBox[{{27, 19, 27}, {26.865776140236527`, 17.724331199468615`, 
     27.21131272280914}}], 
   Line3DBox[{{10, 20, 27}, {9.961984106321824, 18.713436330382223`, 
     27.182506755621507`}}], 
   Line3DBox[{{21, 20, 27}, {21.044787150566613`, 18.71847892768792, 
     27.213770560097075`}}], 
   Line3DBox[{{4, 21, 27}, {3.9901695581976373`, 19.723454329106154`, 
     27.24563084606}}], 
   Line3DBox[{{15, 21, 27}, {14.98378775993738, 19.72373337143671, 
     27.246740057728456`}}], 
   Line3DBox[{{26, 21, 27}, {25.91968826436462, 19.71729493467071, 
     27.195493581730503`}}], 
   Line3DBox[{{9, 22, 27}, {8.922743366263546, 20.71452768366663, 
     27.177742331717116`}}], 
   Line3DBox[{{20, 22, 27}, {20.022040658075166`, 20.722196662337346`, 
     27.238186564797005`}}], 
   Line3DBox[{{3, 23, 27}, {2.9492973387689623`, 21.717562873681093`, 
     27.20684355726731}}], 
   Line3DBox[{{14, 23, 27}, {14.000817457887303`, 21.718528514334484`, 
     27.218701081819045`}}], 
   Line3DBox[{{25, 23, 27}, {25.015091745036884`, 21.714681137314372`, 
     27.19423609462782}}], 
   Line3DBox[{{8, 24, 27}, {7.949890914944779, 22.71813020442248, 
     27.210473054762296`}}], 
   Line3DBox[{{19, 24, 27}, {18.999942834152595`, 22.718403434793597`, 
     27.21796843987885}}], 
   Line3DBox[{{2, 25, 27}, {1.9945497725285457`, 23.708816989320503`, 
     27.15105207033714}}], 
   Line3DBox[{{13, 25, 27}, {12.971925085918565`, 23.7083352889289, 
     27.144270833410403`}}], 
   Line3DBox[{{24, 25, 27}, {24.033122762045423`, 23.714767599043643`, 
     27.192563127743703`}}], 
   Line3DBox[{{7, 26, 27}, {6.975220784223808, 24.712205854029254`, 
     27.175989283960668`}}], 
   Line3DBox[{{18, 26, 27}, {17.961290469888347`, 24.708872661596956`, 
     27.14660071045805}}], 
   Line3DBox[{{1, 27, 27}, {0.999904894590687, 25.70437189343098, 
     27.10652605513836}}], 
   Line3DBox[{{12, 27, 27}, {11.992084303986882`, 25.701823078898958`, 
     27.068366828778633`}}], 
   Line3DBox[{{23, 27, 27}, {22.99198222279267, 25.7030849785039, 
     27.0891467456861}}], 
   Line3DBox[{{34, 1, 0}, {33.964487091681406`, -0.29934801995634963`, 
     0.020822016671495285`}}], 
   Line3DBox[{{45, 1, 0}, {44.91769929620459, -0.2911885163186039, 
     0.12672335807475751`}}], 
   Line3DBox[{{28, 2, 0}, {27.962126715474227`, 0.7012405481244772, 
     0.04230248790817286}}], 
   Line3DBox[{{39, 2, 0}, {38.896584465475286`, 0.7041891348892397, 
     0.013395114029759231`}}], 
   Line3DBox[{{50, 2, 0}, {49.95820202996931, 0.7060442872185049, 
     0.1180319577972259}}], 
   Line3DBox[{{33, 3, 0}, {32.931828460254145`, 1.7035970331515256`, 
     0.06849809278478905}}], 
   Line3DBox[{{44, 3, 0}, {43.87383907016622, 1.7134125324667056`, 
     0.13702593976959238`}}], 
   Line3DBox[{{55, 3, 0}, {54.91831364410345, 1.7106830818966936`, 
     0.14487658179614654`}}], 
   Line3DBox[{{38, 4, 0}, {37.818005441479826`, 2.7138578422340283`, 
     0.052118429428905204`}}], 
   Line3DBox[{{49, 4, 0}, {48.871442852163106`, 2.719522984844946, 
     0.18398824255817584`}}], 
   Line3DBox[{{32, 5, 0}, {31.880916251009083`, 3.7062812832398366`, 
     0.045944995709054276`}}], 
   Line3DBox[{{43, 5, 0}, {42.866731778936774`, 3.7186504393754887`, 
     0.17430686946306617`}}], 
   Line3DBox[{{54, 5, 0}, {53.92251553030752, 3.713610532888236, 
     0.17087508847221738`}}], 
   Line3DBox[{{37, 6, 0}, {36.81339020386676, 4.716629438791069, 
     0.09020413853802602}}], 
   Line3DBox[{{48, 6, 0}, {47.84249157901777, 4.73258837943556, 
     0.24260849403494728`}}], 
   Line3DBox[{{31, 7, 0}, {30.819241353256793`, 5.716938770266211, 
     0.10526249275777878`}}], 
   Line3DBox[{{42, 7, 0}, {41.88586754626483, 5.724658737982259, 
     0.22467409374333464`}}], 
   Line3DBox[{{53, 7, 0}, {52.87120775331737, 5.723191754071546, 
     0.20778176128703957`}}], 
   Line3DBox[{{36, 8, 0}, {35.79968495890456, 6.7214430657676445`, 
     0.12315051862372406`}}], 
   Line3DBox[{{47, 8, 0}, {46.86706929673693, 6.722840990088468, 
     0.202963769012548}}], 
   Line3DBox[{{30, 9, 0}, {29.859801833753764`, 7.7122227192384205`, 
     0.10942645628688802`}}], 
   Line3DBox[{{41, 9, 0}, {40.85489396330753, 7.730710890794668, 
     0.24051901248786695`}}], 
   Line3DBox[{{52, 9, 0}, {51.87684310188135, 7.724295038580515, 
     0.2177366066041817}}], 
   Line3DBox[{{35, 10, 0}, {34.8001864448641, 8.723246400553634, 
     0.1413321954994904}}], 
   Line3DBox[{{46, 10, 0}, {45.86730782566729, 8.731921484582129, 
     0.2537117766412585}}], 
   Line3DBox[{{29, 11, 0}, {28.861703586652183`, 9.722673489970466, 
     0.1982702419197137}}], 
   Line3DBox[{{40, 11, 0}, {39.86037070363243, 9.733536175324344, 
     0.2580175195288238}}], 
   Line3DBox[{{51, 11, 0}, {50.89814033319523, 9.724656425472677, 
     0.23048508669823417`}}], 
   Line3DBox[{{34, 12, 0}, {33.801894396302245`, 10.723663082183291`, 
     0.14737110300765185`}}], 
   Line3DBox[{{45, 12, 0}, {44.83594027303525, 10.738498001540155`, 
     0.267763167500805}}], 
   Line3DBox[{{28, 13, 0}, {27.858360272694174`, 11.729737335535921`, 
     0.23742567451173094`}}], 
   Line3DBox[{{39, 13, 0}, {38.832350871968636`, 11.734319462322098`, 
     0.24483983828964195`}}], 
   Line3DBox[{{50, 13, 0}, {49.91736230358735, 11.730653422073605`, 
     0.26819820327168176`}}], 
   Line3DBox[{{33, 14, 0}, {32.82396798011576, 12.727157335494176`, 
     0.197190971875462}}], 
   Line3DBox[{{44, 14, 0}, {43.857789123326995`, 12.73189432786492, 
     0.2483627807356183}}], 
   Line3DBox[{{55, 14, 0}, {54.86797886600936, 12.730745016369418`, 
     0.24811732448331378`}}], 
   Line3DBox[{{38, 15, 0}, {37.8479137843133, 13.726413976726125`, 
     0.2117744656929521}}], 
   Line3DBox[{{49, 15, 0}, {48.99784534631615, 13.724492298579296`, 
     0.2511482850508379}}], 
   Line3DBox[{{32, 16, 0}, {31.854806763281484`, 14.726586182738576`, 
     0.21756877997288532`}}], 
   Line3DBox[{{43, 16, 0}, {42.88548394514112, 14.72065065126535, 
     0.20037793559118966`}}], 
   Line3DBox[{{54, 16, 0}, {53.87659462099343, 14.739672200016336`, 
     0.29384511059498963`}}], 
   Line3DBox[{{37, 17, 0}, {36.9288538984952, 15.721177869295827`, 
     0.22260321260464772`}}], 
   Line3DBox[{{48, 17, 0}, {47.94794178245038, 15.717972921182524`, 
     0.20903710475483522`}}], 
   Line3DBox[{{31, 18, 0}, {30.85662813594391, 16.726660499796324`, 
     0.2192054420358631}}], 
   Line3DBox[{{42, 18, 0}, {41.91931325189793, 16.71815636213323, 
     0.20091425221023046`}}], 
   Line3DBox[{{53, 18, 0}, {52.84940723278117, 16.735389889900713`, 
     0.2609273613403641}}], 
   Line3DBox[{{36, 19, 0}, {35.94616125379117, 17.719086301972595`, 
     0.2153171790926584}}], 
   Line3DBox[{{47, 19, 0}, {46.91275827886434, 17.719937847501136`, 
     0.20935560138974138`}}], 
   Line3DBox[{{30, 20, 0}, {29.88622381489423, 18.7276218312837, 
     0.24105761858305577`}}], 
   Line3DBox[{{41, 20, 0}, {40.9495548471619, 18.723194760930223`, 
     0.23921469026610617`}}], 
   Line3DBox[{{52, 20, 0}, {51.87031365322306, 18.725580713621817`, 
     0.22144284582476606`}}], 
   Line3DBox[{{35, 21, 0}, {34.97687053403228, 19.722751774534434`, 
     0.24104356110278555`}}], 
   Line3DBox[{{46, 21, 0}, {45.894137226476474`, 19.724576879653313`, 
     0.22823000956716535`}}], 
   Line3DBox[{{29, 22, 0}, {28.957520991164884`, 20.724817693408834`, 
     0.24920998929662033`}}], 
   Line3DBox[{{40, 22, 0}, {39.936080557170705`, 20.71857429426664, 
     0.2094336780800981}}], 
   Line3DBox[{{51, 22, 0}, {50.91626310845536, 20.71332443784915, 
     0.16569288083147304`}}], 
   Line3DBox[{{34, 23, 0}, {34.020908638898675`, 21.72961395379955, 
     0.27510383937449917`}}], 
   Line3DBox[{{45, 23, 0}, {44.863073901530505`, 21.73559913098764, 
     0.2693356381890685}}], 
   Line3DBox[{{28, 24, 0}, {28.04158505177177, 22.721270202577678`, 
     0.23047947555780793`}}], 
   Line3DBox[{{39, 24, 0}, {38.97858270553515, 22.70926245492009, 
     0.15342062840078222`}}], 
   Line3DBox[{{50, 24, 0}, {49.925288340040524`, 22.711948845153056`, 
     0.1591929344021079}}], 
   Line3DBox[{{33, 25, 0}, {33.052136633103345`, 23.717174484708575`, 
     0.20405996375070687`}}], 
   Line3DBox[{{44, 25, 0}, {43.904221879003934`, 23.724762222669945`, 
     0.2336560780479897}}], 
   Line3DBox[{{55, 25, 0}, {54.94310336470499, 23.70847738402573, 
     0.13686528164251954`}}], 
   Line3DBox[{{38, 26, 0}, {38.05005892823398, 24.70303649652212, 
     0.07334694506556001}}], 
   Line3DBox[{{49, 26, 0}, {48.954862073365035`, 24.706472575238333`, 
     0.12144698007174463`}}], 
   Line3DBox[{{32, 27, 0}, {31.999968818581316`, 25.704911870013287`, 
     0.11290143752511599`}}], 
   Line3DBox[{{43, 27, 0}, {42.90911384404256, 25.70939981391605, 
     0.12684977861767976`}}], 
   Line3DBox[{{54, 27, 0}, {53.91164556694233, 25.705248419866795`, 
     0.07623542419129398}}], 
   Line3DBox[{{37, 1, 1}, {36.933128647389466`, -0.29785523493344646`, 
     1.033166419099546}}], 
   Line3DBox[{{48, 1, 1}, {47.910474985379786`, -0.29087109486395657`, 
     1.1250483434595682`}}], 
   Line3DBox[{{31, 2, 1}, {30.97180029427796, 0.7011880520794422, 
     1.0478779754792948`}}], 
   Line3DBox[{{42, 2, 1}, {41.926669957384114`, 0.705396309614563, 
     1.0928654386214756`}}], 
   Line3DBox[{{53, 2, 1}, {52.959303698788055`, 0.7053177184933361, 
     1.1101889332935333`}}], 
   Line3DBox[{{36, 3, 1}, {35.877974908075444`, 1.7073429985549384`, 
     1.0644030554854864`}}], 
   Line3DBox[{{47, 3, 1}, {46.834610601719085`, 1.7260192316533574`, 
     1.1990460972216606`}}], 
   Line3DBox[{{30, 4, 1}, {29.919054070486787`, 2.7055083868381162`, 
     1.087972836425719}}], 
   Line3DBox[{{41, 4, 1}, {40.88919918688695, 2.7105735845141328`, 
     1.122893038292469}}], 
   Line3DBox[{{52, 4, 1}, {51.92383149701997, 2.711448987783636, 
     1.1543847404051466`}}], 
   Line3DBox[{{35, 5, 1}, {34.8697887280488, 3.7091070902529832`, 
     1.0814893871723985`}}], 
   Line3DBox[{{46, 5, 1}, {45.835741914065856`, 3.732171024913937, 
     1.2358579469457727`}}], 
   Line3DBox[{{29, 6, 1}, {28.862154822658056`, 4.711989549277117, 
     1.109671262927909}}], 
   Line3DBox[{{40, 6, 1}, {39.86996728653223, 4.713523436034464, 
     1.1344230032235423`}}], 
   Line3DBox[{{51, 6, 1}, {50.86816046587374, 4.729062543966068, 
     1.2394500367328605`}}], 
   Line3DBox[{{34, 7, 1}, {33.84198838096967, 5.712349590203617, 
     1.083598746417748}}], 
   Line3DBox[{{45, 7, 1}, {44.89296573945288, 5.729147296946319, 
     1.2519465701498722`}}], 
   Line3DBox[{{28, 8, 1}, {27.886727605165994`, 6.712752305424699, 
     1.1419955540823075`}}], 
   Line3DBox[{{39, 8, 1}, {38.8557622723209, 6.7172871764116024`, 
     1.154412726534609}}], 
   Line3DBox[{{50, 8, 1}, {49.846583354393736`, 6.732784863274782, 
     1.2462298318754415`}}], 
   Line3DBox[{{33, 9, 1}, {32.799419554260226`, 7.717818214314521, 
     1.0760089023945778`}}], 
   Line3DBox[{{44, 9, 1}, {43.902580896155285`, 7.73253756260456, 
     1.2721185182924932`}}], 
   Line3DBox[{{55, 9, 1}, {54.84958707095384, 7.725084049779574, 
     1.2048542668564721`}}], 
   Line3DBox[{{38, 10, 1}, {37.846073311796, 8.728675659470476, 
     1.223698448442797}}], 
   Line3DBox[{{49, 10, 1}, {48.894727055778446`, 8.727122980716961, 
     1.242284339147322}}], 
   Line3DBox[{{32, 11, 1}, {31.833775032042443`, 9.715738024594629, 
     1.1141947396135248`}}], 
   Line3DBox[{{43, 11, 1}, {42.8781943511133, 9.737218841193371, 
     1.2838082607365053`}}], 
   Line3DBox[{{54, 11, 1}, {53.87501710125338, 9.720637585737467, 
     1.1939357831686437`}}], 
   Line3DBox[{{37, 12, 1}, {36.8326614274302, 10.728820809810179`, 
     1.2147120596488592`}}], 
   Line3DBox[{{48, 12, 1}, {47.92755783082444, 10.726687695955794`, 
     1.251848979538878}}], 
   Line3DBox[{{31, 13, 1}, {30.79774038145482, 11.727586757908515`, 
     1.173365475387097}}], 
   Line3DBox[{{42, 13, 1}, {41.860256500193685`, 11.734152771851578`, 
     1.2609646513435067`}}], 
   Line3DBox[{{53, 13, 1}, {52.91378986110925, 11.729408025731155`, 
     1.2610820692350182`}}], 
   Line3DBox[{{36, 14, 1}, {35.835601983960686`, 12.72755488568863, 
     1.2094199689319507`}}], 
   Line3DBox[{{47, 14, 1}, {46.94564184299444, 12.723461901294163`, 
     1.2397825542433103`}}], 
   Line3DBox[{{30, 15, 1}, {29.85685293129755, 13.728163074830738`, 
     1.2279029453471215`}}], 
   Line3DBox[{{41, 15, 1}, {40.871493059980814`, 13.724854939468344`, 
     1.2179243927802108`}}], 
   Line3DBox[{{52, 15, 1}, {51.94431217740295, 13.731997117893988`, 
     1.281189539964145}}], 
   Line3DBox[{{35, 16, 1}, {34.88990370679998, 14.72530926022019, 
     1.230309192485267}}], 
   Line3DBox[{{46, 16, 1}, {45.956772121561464`, 14.718644707437212`, 
     1.21508129799458}}], 
   Line3DBox[{{29, 17, 1}, {28.857771631125, 15.731841328316438`, 
     1.2480819915288928`}}], 
   Line3DBox[{{40, 17, 1}, {39.903336729790595`, 15.722663203858689`, 
     1.2215105447058308`}}], 
   Line3DBox[{{51, 17, 1}, {50.93952897101552, 15.730196049304636`, 
     1.2719212780420155`}}], 
   Line3DBox[{{34, 18, 1}, {33.92112211365626, 16.72384030400499, 
     1.2349355429982234`}}], 
   Line3DBox[{{45, 18, 1}, {44.8879892268161, 16.721969805834604`, 
     1.209981926584888}}], 
   Line3DBox[{{28, 19, 1}, {27.846964367443633`, 17.728689270954597`, 
     1.2243861078189098`}}], 
   Line3DBox[{{39, 19, 1}, {38.986905043674035`, 17.71867663007468, 
     1.2191778816442052`}}], 
   Line3DBox[{{50, 19, 1}, {49.9236931448926, 17.723993482179704`, 
     1.2366107147695247`}}], 
   Line3DBox[{{33, 20, 1}, {32.92594459443541, 18.7250308542227, 
     1.24283631158163}}], 
   Line3DBox[{{44, 20, 1}, {43.91372459344657, 18.727664502480152`, 
     1.2524261000272454`}}], 
   Line3DBox[{{55, 20, 1}, {54.85417137144143, 18.727505410705486`, 
     1.2224669218308934`}}], 
   Line3DBox[{{38, 21, 1}, {38.010518583671164`, 19.72015724895441, 
     1.2277979192038644`}}], 
   Line3DBox[{{49, 21, 1}, {48.92936261659252, 19.724072900590812`, 
     1.2387894408440294`}}], 
   Line3DBox[{{32, 22, 1}, {31.972512076121287`, 20.72462450684204, 
     1.2503233219117487`}}], 
   Line3DBox[{{43, 22, 1}, {42.903707152255606`, 20.729486647633966`, 
     1.2579215170025497`}}], 
   Line3DBox[{{54, 22, 1}, {53.899083513291615`, 20.71395596472474, 
     1.1609552796380471`}}], 
   Line3DBox[{{37, 23, 1}, {37.0121497754434, 21.720167433026848`, 
     1.2277739745264764`}}], 
   Line3DBox[{{48, 23, 1}, {47.89143341657243, 21.72283753188441, 
     1.2169546657708745`}}], 
   Line3DBox[{{31, 24, 1}, {31.004309724426065`, 22.72092109441894, 
     1.2322468074547641`}}], 
   Line3DBox[{{42, 24, 1}, {41.9191088337597, 22.722908931586062`, 
     1.22911792204372}}], 
   Line3DBox[{{53, 24, 1}, {52.90379054899575, 22.70918430453463, 
     1.12057604188942}}], 
   Line3DBox[{{36, 25, 1}, {36.03189016377498, 23.71434123232142, 
     1.1899066890491314`}}], 
   Line3DBox[{{47, 25, 1}, {46.89526925470566, 23.721356126202824`, 
     1.210003130907713}}], 
   Line3DBox[{{30, 26, 1}, {30.040863502600306`, 24.715155115982302`, 
     1.193658973891687}}], 
   Line3DBox[{{41, 26, 1}, {40.936222361262, 24.71110247674384, 
     1.1570846502403747`}}], 
   Line3DBox[{{52, 26, 1}, {51.91846746345271, 24.70551734587052, 
     1.0875619988468883`}}], 
   Line3DBox[{{35, 27, 1}, {35.049985609723954`, 25.70220514162869, 
     1.0568325998482622`}}], 
   Line3DBox[{{46, 27, 1}, {45.922492015804806`, 25.712286527922128`, 
     1.160581836504471}}], 
   Line3DBox[{{29, 1, 2}, {28.96437816016695, -0.2984812109299042, 
     2.0517458151826724`}}], 
   Line3DBox[{{40, 1, 2}, {39.92999512663601, -0.29740928134403566`, 
     2.0427606640224907`}}], 
   Line3DBox[{{51, 1, 2}, {51.00194850878237, -0.296974131794699, 
     2.0886245156201784`}}], 
   Line3DBox[{{34, 2, 2}, {33.969819070081115`, 0.7013592432940712, 
     2.0511985985304695`}}], 
   Line3DBox[{{45, 2, 2}, {44.85795172620558, 0.7199268988698149, 
     2.176734670268668}}], 
   Line3DBox[{{28, 3, 2}, {27.94517280876676, 1.7064368164305923`, 
     2.116996876946579}}], 
   Line3DBox[{{39, 3, 2}, {38.867020168113676`, 1.7079191513753715`, 
     2.053323962052208}}], 
   Line3DBox[{{50, 3, 2}, {49.92860379121784, 1.7118758292643295`, 
     2.160120898505079}}], 
   Line3DBox[{{33, 4, 2}, {32.90609636022867, 2.7050161976116107`, 
     2.0648001388069988`}}], 
   Line3DBox[{{44, 4, 2}, {43.86669113734272, 2.7176946452798627`, 
     2.167097948500525}}], 
   Line3DBox[{{55, 4, 2}, {54.94772352840554, 2.7135406732961194`, 
     2.1796929916669887`}}], 
   Line3DBox[{{38, 5, 2}, {37.82397160985268, 3.713884347037868, 
     2.0701465114451962`}}], 
   Line3DBox[{{49, 5, 2}, {48.88183254590685, 3.7282635883473123`, 
     2.2423281908278314`}}], 
   Line3DBox[{{32, 6, 2}, {31.8824902012067, 4.706692345272332, 
     2.0595546590148794`}}], 
   Line3DBox[{{43, 6, 2}, {42.91976951224285, 4.714242777121907, 
     2.174331387452356}}], 
   Line3DBox[{{54, 6, 2}, {53.90470332191567, 4.72123138676605, 
     2.2137039469776187`}}], 
   Line3DBox[{{37, 7, 2}, {36.82628661452671, 5.716221904034104, 
     2.1083395589135594`}}], 
   Line3DBox[{{48, 7, 2}, {47.871041922066325`, 5.733700600097384, 
     2.264302183006359}}], 
   Line3DBox[{{31, 8, 2}, {30.875878596491553`, 6.71260661314351, 
     2.1311950634333092`}}], 
   Line3DBox[{{42, 8, 2}, {41.93716614962968, 6.724168015792021, 
     2.241463569342403}}], 
   Line3DBox[{{53, 8, 2}, {52.8409667812009, 6.729131911149153, 
     2.2227167170622684`}}], 
   Line3DBox[{{36, 9, 2}, {35.821273370579284`, 7.719573602181143, 
     2.1362535566674623`}}], 
   Line3DBox[{{47, 9, 2}, {46.896081726426935`, 7.724727479637544, 
     2.229958672865325}}], 
   Line3DBox[{{30, 10, 2}, {29.85310566675583, 8.719073992046464, 
     2.1662847467718302`}}], 
   Line3DBox[{{41, 10, 2}, {40.903448233414444`, 8.727415972913072, 
     2.2474017994526774`}}], 
   Line3DBox[{{52, 10, 2}, {51.86709571506986, 8.72324848381986, 
     2.2055286281249424`}}], 
   Line3DBox[{{35, 11, 2}, {34.785836275941, 9.724497824462773, 
     2.1312558550959855`}}], 
   Line3DBox[{{46, 11, 2}, {45.8887753929618, 9.732501370218476, 
     2.26660140714399}}], 
   Line3DBox[{{29, 12, 2}, {28.822452140367062`, 10.72764810385917, 
     2.19899097951062}}], 
   Line3DBox[{{40, 12, 2}, {39.88455271909886, 10.727653137613157`, 
     2.240427509047718}}], 
   Line3DBox[{{51, 12, 2}, {50.935493338853135`, 10.722131363380074`, 
     2.2299796473838804`}}], 
   Line3DBox[{{34, 13, 2}, {33.81442613734204, 11.725662715048834`, 
     2.177839325464013}}], 
   Line3DBox[{{45, 13, 2}, {44.87678333820073, 11.73196488553326, 
     2.258659240574097}}], 
   Line3DBox[{{28, 14, 2}, {27.87722745829571, 12.727917140499812`, 
     2.2381850154172036`}}], 
   Line3DBox[{{39, 14, 2}, {38.86514586777118, 12.72722822815162, 
     2.227741914909731}}], 
   Line3DBox[{{50, 14, 2}, {49.992942016671435`, 12.729171300106172`, 
     2.2737601146944058`}}], 
   Line3DBox[{{33, 15, 2}, {32.86044467730113, 13.726090801929088`, 
     2.2183567424576984`}}], 
   Line3DBox[{{44, 15, 2}, {43.91620119003405, 13.726689616980044`, 
     2.24831115146498}}], 
   Line3DBox[{{55, 15, 2}, {54.8642024138039, 13.737339900991662`, 
     2.2779361256756077`}}], 
   Line3DBox[{{38, 16, 2}, {37.89050187369351, 14.721197201187206`, 
     2.206575802271063}}], 
   Line3DBox[{{49, 16, 2}, {49.020583937297374`, 14.726664389611674`, 
     2.261137367763263}}], 
   Line3DBox[{{32, 17, 2}, {31.86912976052202, 15.727801255186137`, 
     2.233202345856571}}], 
   Line3DBox[{{43, 17, 2}, {42.90548708702334, 15.722611329145732`, 
     2.2221384542438103`}}], 
   Line3DBox[{{54, 17, 2}, {53.875154805038314`, 15.738342778487118`, 
     2.287462576171875}}], 
   Line3DBox[{{37, 18, 2}, {36.94473341855615, 16.71840963672433, 
     2.2108832514318038`}}], 
   Line3DBox[{{48, 18, 2}, {47.9130489820579, 16.72756229760207, 
     2.251677996644733}}], 
   Line3DBox[{{31, 19, 2}, {30.8951094960013, 17.722325372033257`, 
     2.2157441244181357`}}], 
   Line3DBox[{{42, 19, 2}, {41.93188497000551, 17.730162493525523`, 
     2.2699500876820173`}}], 
   Line3DBox[{{53, 19, 2}, {52.85499519367996, 17.731005279206265`, 
     2.2421280750795396`}}], 
   Line3DBox[{{36, 20, 2}, {35.97650046410016, 18.7224417204841, 
     2.239358756373905}}], 
   Line3DBox[{{47, 20, 2}, {46.91103718418114, 18.726294163733808`, 
     2.244456662954853}}], 
   Line3DBox[{{30, 21, 2}, {29.96798368142842, 19.71944776801198, 
     2.2217226567034256`}}], 
   Line3DBox[{{41, 21, 2}, {40.940931044025476`, 19.725889618572715`, 
     2.2513037890269514`}}], 
   Line3DBox[{{52, 21, 2}, {51.87767030841822, 19.72195493867367, 
     2.2040496698769316`}}], 
   Line3DBox[{{35, 22, 2}, {34.963433646010344`, 20.72720146983938, 
     2.2620053499012274`}}], 
   Line3DBox[{{46, 22, 2}, {45.866622786629094`, 20.738618562926902`, 
     2.284828701434414}}], 
   Line3DBox[{{29, 23, 2}, {29.02073039147833, 21.71733581391654, 
     2.210577388643738}}], 
   Line3DBox[{{40, 23, 2}, {39.928432149726966`, 21.717606890355366`, 
     2.200863025824231}}], 
   Line3DBox[{{51, 23, 2}, {50.92925177528016, 21.71177485892424, 
     2.159595346421282}}], 
   Line3DBox[{{34, 24, 2}, {34.007310992985815`, 22.72289408346183, 
     2.2427900890167543`}}], 
   Line3DBox[{{45, 24, 2}, {44.87338578066655, 22.733950656161753`, 
     2.2666231393358918`}}], 
   Line3DBox[{{28, 25, 2}, {28.075573752001237`, 23.72308931652048, 
     2.2319217851438777`}}], 
   Line3DBox[{{39, 25, 2}, {38.97389976322065, 23.711683273013456`, 
     2.1719266954453094`}}], 
   Line3DBox[{{50, 25, 2}, {49.9566755090653, 23.707666395595435`, 
     2.134152314225129}}], 
   Line3DBox[{{33, 26, 2}, {33.02078775022564, 24.71218226418967, 
     2.176333062052803}}], 
   Line3DBox[{{44, 26, 2}, {43.882136934267365`, 24.724749409254642`, 
     2.223258210464301}}], 
   Line3DBox[{{55, 26, 2}, {54.88764267714306, 24.70922013095333, 
     2.106128043722133}}], 
   Line3DBox[{{38, 27, 2}, {38.02272203018289, 25.70624627230238, 
     2.1252397756820263`}}], 
   Line3DBox[{{49, 27, 2}, {48.99890637510415, 25.702802698536107`, 
     2.0853109902614304`}}], 
   Line3DBox[{{32, 1, 3}, {31.994170624624505`, -0.2995385563421922, 
     3.0341402835779583`}}], 
   Line3DBox[{{43, 1, 3}, {42.92099902271995, -0.2876460676062593, 
     3.1603946700078653`}}], 
   Line3DBox[{{54, 1, 3}, {54.01919666625347, -0.2980244620437267, 
     3.0690216193728217`}}], 
   Line3DBox[{{37, 2, 3}, {36.924281605839084`, 0.7043331851197092, 
     3.074257858867963}}], 
   Line3DBox[{{48, 2, 3}, {47.896076897540986`, 0.712979258888135, 
     3.1509224990621294`}}], 
   Line3DBox[{{31, 3, 3}, {30.94671561736516, 1.7037501138189088`, 
     3.0830482217915134`}}], 
   Line3DBox[{{42, 3, 3}, {41.910664137081525`, 1.7115312558513356`, 
     3.1478762961010798`}}], 
   Line3DBox[{{53, 3, 3}, {52.99405776994701, 1.7059189882315362`, 
     3.1237700484055284`}}], 
   Line3DBox[{{36, 4, 3}, {35.850872891761114`, 2.709789432980219, 
     3.0558372486679026`}}], 
   Line3DBox[{{47, 4, 3}, {46.83519586705236, 2.728911829631466, 
     3.217196825281932}}], 
   Line3DBox[{{30, 5, 3}, {29.915737449362098`, 3.707133327272839, 
     3.106750124643462}}], 
   Line3DBox[{{41, 5, 3}, {40.88943668561943, 3.7141388324272264`, 
     3.156002600111561}}], 
   Line3DBox[{{52, 5, 3}, {51.912719500702686`, 3.7171144017387765`, 
     3.1912763869806087`}}], 
   Line3DBox[{{35, 6, 3}, {34.854200463104846`, 4.710256917192008, 
     3.0728373214093914`}}], 
   Line3DBox[{{46, 6, 3}, {45.88461463325548, 4.722092626431752, 
     3.208899405746246}}], 
   Line3DBox[{{29, 7, 3}, {28.89263079089167, 5.714642826459438, 
     3.1622614845342873`}}], 
   Line3DBox[{{40, 7, 3}, {39.87815374497434, 5.716016519150811, 
     3.162910745632762}}], 
   Line3DBox[{{51, 7, 3}, {50.84151913674862, 5.732858114190474, 
     3.2433829435481827`}}], 
   Line3DBox[{{34, 8, 3}, {33.826728102872686`, 6.716083848124396, 
     3.107406538994805}}], 
   Line3DBox[{{45, 8, 3}, {44.92140631638872, 6.725035624761821, 
     3.241430890256259}}], 
   Line3DBox[{{28, 9, 3}, {27.883128443817576`, 7.716986929946276, 
     3.1738346956933974`}}], 
   Line3DBox[{{39, 9, 3}, {38.89832458766972, 7.715740279646164, 
     3.174181173506654}}], 
   Line3DBox[{{50, 9, 3}, {49.86595945413252, 7.728764153935661, 
     3.236627461940982}}], 
   Line3DBox[{{33, 10, 3}, {32.804430548117196`, 8.721588880119315, 
     3.1319757479830046`}}], 
   Line3DBox[{{44, 10, 3}, {43.900383966153136`, 8.733717868980044, 
     3.2767782694869267`}}], 
   Line3DBox[{{55, 10, 3}, {54.809623358137316`, 8.729326878405573, 
     3.1978548768430075`}}], 
   Line3DBox[{{38, 11, 3}, {37.86627748193388, 9.723129251199094, 
     3.2042532227864946`}}], 
   Line3DBox[{{49, 11, 3}, {48.9203981243906, 9.720540911950078, 
     3.2159814422720823`}}], 
   Line3DBox[{{32, 12, 3}, {31.812862200841405`, 10.724330861409824`, 
     3.166275954288874}}], 
   Line3DBox[{{43, 12, 3}, {42.87157605441114, 10.732179742682344`, 
     3.2571752035760557`}}], 
   Line3DBox[{{54, 12, 3}, {53.89256135575324, 10.724123108569962`, 
     3.224933536043962}}], 
   Line3DBox[{{37, 13, 3}, {36.876484086312296`, 11.722319220142516`, 
     3.2056104176559774`}}], 
   Line3DBox[{{48, 13, 3}, {47.97040440809549, 11.726634898227065`, 
     3.2601257744373355`}}], 
   Line3DBox[{{31, 14, 3}, {30.814013724253616`, 12.731333712305341`, 
     3.214231080147214}}], 
   Line3DBox[{{42, 14, 3}, {41.89115375803026, 12.725019150289691`, 
     3.2292952866524907`}}], 
   Line3DBox[{{53, 14, 3}, {52.96255078507096, 12.726458628424457`, 
     3.2582439373667516`}}], 
   Line3DBox[{{36, 15, 3}, {35.898986863014066`, 13.724080372853683`, 
     3.227652039786741}}], 
   Line3DBox[{{47, 15, 3}, {47.00349648684223, 13.727021025229671`, 
     3.2636518620689854`}}], 
   Line3DBox[{{30, 16, 3}, {29.896291069394227`, 14.728929917921747`, 
     3.252240568026212}}], 
   Line3DBox[{{41, 16, 3}, {40.90707098966841, 14.722053091454274`, 
     3.2195811876669156`}}], 
   Line3DBox[{{52, 16, 3}, {51.93803324603115, 14.732638028088736`, 
     3.2827609477204325`}}], 
   Line3DBox[{{35, 17, 3}, {34.92156210173885, 15.71983755291865, 
     3.21220651544913}}], 
   Line3DBox[{{46, 17, 3}, {45.92722735386796, 15.725380076206156`, 
     3.2450473257203902`}}], 
   Line3DBox[{{29, 18, 3}, {28.910792801060353`, 16.72486152264669, 
     3.2367782490652837`}}], 
   Line3DBox[{{40, 18, 3}, {39.924158012588926`, 16.72953546585448, 
     3.264892167539821}}], 
   Line3DBox[{{51, 18, 3}, {50.922336681595375`, 16.735442370832263`, 
     3.291311536826229}}], 
   Line3DBox[{{34, 19, 3}, {33.95468990420829, 17.722103499652924`, 
     3.2343662296919957`}}], 
   Line3DBox[{{45, 19, 3}, {44.916237966268795`, 17.72909060587717, 
     3.2603329284503775`}}], 
   Line3DBox[{{28, 20, 3}, {27.911715967627877`, 18.726867815514456`, 
     3.247669882010691}}], 
   Line3DBox[{{39, 20, 3}, {39.00943893894984, 18.72413626662617, 
     3.2491638824005165`}}], 
   Line3DBox[{{50, 20, 3}, {49.90036959418665, 18.73104428797817, 
     3.264244551816361}}], 
   Line3DBox[{{33, 21, 3}, {32.956884352086526`, 19.72778262057075, 
     3.2638256628593467`}}], 
   Line3DBox[{{44, 21, 3}, {43.90377393823445, 19.734410892811862`, 
     3.281113423378931}}], 
   Line3DBox[{{55, 21, 3}, {54.872128613600346`, 19.720606565082065`, 
     3.1918367723589984`}}], 
   Line3DBox[{{38, 22, 3}, {37.99814568245515, 20.71795898825136, 
     3.215330921376761}}], 
   Line3DBox[{{49, 22, 3}, {48.90923600305945, 20.722586284324322`, 
     3.2235533400847154`}}], 
   Line3DBox[{{32, 23, 3}, {31.98582905011885, 21.721749102255288`, 
     3.236376451014695}}], 
   Line3DBox[{{43, 23, 3}, {42.88379870064336, 21.732126385920303`, 
     3.262666626635955}}], 
   Line3DBox[{{54, 23, 3}, {53.849293747253746`, 21.717186701713537`, 
     3.1472333763879408`}}], 
   Line3DBox[{{37, 24, 3}, {36.988493625699206`, 22.715098663439672`, 
     3.1972210907989633`}}], 
   Line3DBox[{{48, 24, 3}, {47.92032488159946, 22.716630289318978`, 
     3.1913480107405627`}}], 
   Line3DBox[{{31, 25, 3}, {31.002178121765915`, 23.719468487242498`, 
     3.224130097533897}}], 
   Line3DBox[{{42, 25, 3}, {41.931318312733545`, 23.719786323084353`, 
     3.215257444174079}}], 
   Line3DBox[{{53, 25, 3}, {52.883016152090065`, 23.709966378076675`, 
     3.1101273518957715`}}], 
   Line3DBox[{{36, 26, 3}, {35.98799468832241, 24.71016760379349, 
     3.161827878277201}}], 
   Line3DBox[{{47, 26, 3}, {46.94998723518562, 24.7113143636806, 
     3.1636705657706603`}}], 
   Line3DBox[{{30, 27, 3}, {30.00532060052388, 25.71404764441842, 
     3.1905209447390384`}}], 
   Line3DBox[{{41, 27, 3}, {40.94376338093963, 25.71088626888033, 
     3.1581873285550373`}}], 
   Line3DBox[{{52, 27, 3}, {51.919086978010576`, 25.705392183014645`, 
     3.086276781772112}}], 
   Line3DBox[{{35, 1, 4}, {35.028666609835035`, -0.29946207437020145`, 
     4.02401130471381}}], 
   Line3DBox[{{46, 1, 4}, {45.84367099279314, -0.2813018544444754, 
     4.154359318807989}}], 
   Line3DBox[{{29, 2, 4}, {28.961186355573815`, 0.7031209928942403, 
     4.0812301787191}}], 
   Line3DBox[{{40, 2, 4}, {39.89039397675244, 0.7080233356529131, 
     4.093716692485541}}], 
   Line3DBox[{{51, 2, 4}, {51.01669298735633, 0.7027787463843622, 
     4.083296838721492}}], 
   Line3DBox[{{34, 3, 4}, {33.95448693739101, 1.7022479621930238`, 
     4.061385743457178}}], 
   Line3DBox[{{45, 3, 4}, {44.85004850393693, 1.724108476499586, 
     4.1990360999624}}], 
   Line3DBox[{{28, 4, 4}, {27.938293983933026`, 2.708427292338018, 
     4.134284430980814}}], 
   Line3DBox[{{39, 4, 4}, {38.84579252932293, 2.7153204275510756`, 
     4.125771428074217}}], 
   Line3DBox[{{50, 4, 4}, {49.90913434594287, 2.7144033300974932`, 
     4.170248745218148}}], 
   Line3DBox[{{33, 5, 4}, {32.930726652839596`, 3.7045332638810007`, 
     4.083469389493283}}], 
   Line3DBox[{{44, 5, 4}, {43.85686151581003, 3.7168614198233896`, 
     4.151877445350358}}], 
   Line3DBox[{{55, 5, 4}, {54.93967001373915, 3.712111772858308, 
     4.166445808441058}}], 
   Line3DBox[{{38, 6, 4}, {37.831832534715495`, 4.71749377132742, 
     4.129990295929424}}], 
   Line3DBox[{{49, 6, 4}, {48.85818007782732, 4.7280850088661825`, 
     4.228296660080681}}], 
   Line3DBox[{{32, 7, 4}, {31.912473024109282`, 5.706620923511324, 
     4.097517142045519}}], 
   Line3DBox[{{43, 7, 4}, {42.88754150343475, 5.716004482602266, 
     4.169436117320976}}], 
   Line3DBox[{{54, 7, 4}, {53.859383969796035`, 5.727614652022069, 
     4.2264125842367415`}}], 
   Line3DBox[{{37, 8, 4}, {36.84021497244263, 6.717864809644288, 
     4.143520377020181}}], 
   Line3DBox[{{48, 8, 4}, {47.85197157682877, 6.729501634356599, 
     4.232210010186652}}], 
   Line3DBox[{{31, 9, 4}, {30.844687983758483`, 7.718124191799287, 
     4.150574200847167}}], 
   Line3DBox[{{42, 9, 4}, {41.93961089448348, 7.716914380805379, 
     4.200111093522754}}], 
   Line3DBox[{{53, 9, 4}, {52.82443055978969, 7.725174691396952, 
     4.1843795113600795`}}], 
   Line3DBox[{{36, 10, 4}, {35.84509416092854, 8.720842640849325, 
     4.172512699683935}}], 
   Line3DBox[{{47, 10, 4}, {46.89101199887124, 8.722911653391002, 
     4.217179581373236}}], 
   Line3DBox[{{30, 11, 4}, {29.82162401814587, 9.726613070303909, 
     4.1914882147202155`}}], 
   Line3DBox[{{41, 11, 4}, {40.926833228807666`, 9.720602451522016, 
     4.2186058932001}}], 
   Line3DBox[{{52, 11, 4}, {51.8987887890903, 9.716275117601054, 
     4.178344377808787}}], 
   Line3DBox[{{35, 12, 4}, {34.83249390235738, 10.722794147964182`, 
     4.17517682146334}}], 
   Line3DBox[{{46, 12, 4}, {45.91939397794803, 10.726704806140035`, 
     4.2494434174358355`}}], 
   Line3DBox[{{29, 13, 4}, {28.80224355872529, 11.733672851349894`, 
     4.217503890829688}}], 
   Line3DBox[{{40, 13, 4}, {39.887922209625145`, 11.727083279513202`, 
     4.239001237674255}}], 
   Line3DBox[{{51, 13, 4}, {51.000228625179176`, 11.72117554007212, 
     4.233683436342184}}], 
   Line3DBox[{{34, 14, 4}, {33.84093788217625, 12.731733670000771`, 
     4.237064883236023}}], 
   Line3DBox[{{45, 14, 4}, {44.91207720593622, 12.731266311032291`, 
     4.269414937897671}}], 
   Line3DBox[{{28, 15, 4}, {27.886637274017318`, 13.728532662500232`, 
     4.246007524334167}}], 
   Line3DBox[{{39, 15, 4}, {38.88646686137438, 13.724647708970421`, 
     4.22491500661232}}], 
   Line3DBox[{{50, 15, 4}, {49.99066395799517, 13.724628342237658`, 
     4.251674338970467}}], 
   Line3DBox[{{33, 16, 4}, {32.86309002254081, 14.732705098348424`, 
     4.255380677264447}}], 
   Line3DBox[{{44, 16, 4}, {43.90803025752688, 14.726425518570176`, 
     4.244027881030389}}], 
   Line3DBox[{{55, 16, 4}, {54.89522712682038, 14.735663234633709`, 
     4.283681491798095}}], 
   Line3DBox[{{38, 17, 4}, {37.917042764757674`, 15.724065444480898`, 
     4.234753289973161}}], 
   Line3DBox[{{49, 17, 4}, {48.9731334353819, 15.725060956242931`, 
     4.252603686452576}}], 
   Line3DBox[{{32, 18, 4}, {31.897931691508884`, 16.729982057541243`, 
     4.258140438975742}}], 
   Line3DBox[{{43, 18, 4}, {42.887783873384386`, 16.735810682422894`, 
     4.281483410259506}}], 
   Line3DBox[{{54, 18, 4}, {53.889561374625195`, 16.734778135931567`, 
     4.277519269076084}}], 
   Line3DBox[{{37, 19, 4}, {36.97692193503187, 17.72452374248542, 
     4.250255308502992}}], 
   Line3DBox[{{48, 19, 4}, {47.85464445941155, 17.73526329703534, 
     4.263273316145632}}], 
   Line3DBox[{{31, 20, 4}, {30.944605589276872`, 18.721869335326815`, 
     4.230897083746679}}], 
   Line3DBox[{{42, 20, 4}, {41.95016640970821, 18.731720467320944`, 
     4.281040282283565}}], 
   Line3DBox[{{53, 20, 4}, {52.848481475955545`, 18.729245495905502`, 
     4.228528175932293}}], 
   Line3DBox[{{36, 21, 4}, {35.989110058436886`, 19.722533737096395`, 
     4.240751648625397}}], 
   Line3DBox[{{47, 21, 4}, {46.87697972988445, 19.733768484047577`, 
     4.267439266282132}}], 
   Line3DBox[{{30, 22, 4}, {29.965654199435487`, 20.7184667123581, 
     4.215621888149897}}], 
   Line3DBox[{{41, 22, 4}, {40.94831066205379, 20.719465001836717`, 
     4.218078726201442}}], 
   Line3DBox[{{52, 22, 4}, {51.88703434821337, 20.71700291238559, 
     4.176514120368184}}], 
   Line3DBox[{{35, 23, 4}, {34.98354618899822, 21.72294326855026, 
     4.242601271147584}}], 
   Line3DBox[{{46, 23, 4}, {45.866006521410725`, 21.736758181322294`, 
     4.2761627332559256`}}], 
   Line3DBox[{{29, 24, 4}, {29.003704899787028`, 22.71833071064722, 
     4.217508865215898}}], 
   Line3DBox[{{40, 24, 4}, {39.94061490486814, 22.71295730892502, 
     4.173189265910598}}], 
   Line3DBox[{{51, 24, 4}, {50.93980468372855, 22.708066397040643`, 
     4.131468967606183}}], 
   Line3DBox[{{34, 25, 4}, {33.95889755683244, 23.715612659309922`, 
     4.196620823517568}}], 
   Line3DBox[{{45, 25, 4}, {44.88904198998838, 23.724775442210564`, 
     4.226915506797121}}], 
   Line3DBox[{{28, 26, 4}, {28.04162696555736, 24.718719839110477`, 
     4.215843334503072}}], 
   Line3DBox[{{39, 26, 4}, {38.97420078847608, 24.711202608324733`, 
     4.168332064372105}}], 
   Line3DBox[{{50, 26, 4}, {50.01469793944006, 24.704344340916762`, 
     4.105168358653171}}], 
   Line3DBox[{{33, 27, 4}, {32.955309310823196`, 25.706422298586407`, 
     4.121076309435104}}], 
   Line3DBox[{{44, 27, 4}, {43.88163471013107, 25.716788192686614`, 
     4.171339183276224}}], 
   Line3DBox[{{55, 27, 4}, {54.93848241143662, 25.70511094986699, 
     4.0973546821831235`}}], 
   Line3DBox[{{38, 1, 5}, {37.929335573960365`, -0.2947912317152459, 
     5.092315790446732}}], 
   Line3DBox[{{49, 1, 5}, {48.97711075408739, -0.29735595579554475`, 
     5.0796467600306565`}}], 
   Line3DBox[{{32, 2, 5}, {31.998534486807014`, 0.7006133380714958, 
     5.03990181792075}}], 
   Line3DBox[{{43, 2, 5}, {42.85684309882939, 0.7199231059136488, 
     5.175810258157675}}], 
   Line3DBox[{{54, 2, 5}, {54.03367685415052, 0.7017690060228237, 
     5.058840086433971}}], 
   Line3DBox[{{37, 3, 5}, {36.90290103212322, 1.7067124340300563`, 
     5.089325596246553}}], 
   Line3DBox[{{48, 3, 5}, {47.85904281638958, 1.717059152888739, 
     5.155543740478553}}], 
   Line3DBox[{{31, 4, 5}, {30.971791939931194`, 2.7016549854705465`, 
     5.059199059060661}}], 
   Line3DBox[{{42, 4, 5}, {41.83483724315636, 2.7209834426242434`, 
     5.163822799727257}}], 
   Line3DBox[{{53, 4, 5}, {52.99708196834378, 2.7064140399991654`, 
     5.128945140195248}}], 
   Line3DBox[{{36, 5, 5}, {35.84025778760742, 3.7139797660465343`, 
     5.103123146975823}}], 
   Line3DBox[{{47, 5, 5}, {46.80595379588527, 3.73091917711528, 
     5.204401408152947}}], 
   Line3DBox[{{30, 6, 5}, {29.88962453743318, 4.710431386674736, 
     5.12177868774755}}], 
   Line3DBox[{{41, 6, 5}, {40.85279086592614, 4.717187151859687, 
     5.15073376360777}}], 
   Line3DBox[{{52, 6, 5}, {51.90624347233556, 4.717663654715208, 
     5.191893749460348}}], 
   Line3DBox[{{35, 7, 5}, {34.84406372130568, 5.713852636994125, 
     5.107279250649893}}], 
   Line3DBox[{{46, 7, 5}, {45.853383516270576`, 5.726901594655301, 
     5.218458364471593}}], 
   Line3DBox[{{29, 8, 5}, {28.835655343441378`, 6.720130677928566, 
     5.157877649719762}}], 
   Line3DBox[{{40, 8, 5}, {39.88228827422718, 6.715414684972528, 
     5.1611971402703904`}}], 
   Line3DBox[{{51, 8, 5}, {50.83872725166884, 6.730471912239949, 
     5.228669051325323}}], 
   Line3DBox[{{34, 9, 5}, {33.840483716414994`, 7.719908679234578, 
     5.160999272583034}}], 
   Line3DBox[{{45, 9, 5}, {44.911560623813564`, 7.722959275091027, 
     5.226595374321098}}], 
   Line3DBox[{{28, 10, 5}, {27.84316323727662, 8.725278777151505, 
     5.20121638570973}}], 
   Line3DBox[{{39, 10, 5}, {38.872283377339414`, 8.71873261349493, 
     5.179003766928641}}], 
   Line3DBox[{{50, 10, 5}, {49.88891828794599, 8.722628966144521, 
     5.21443902423331}}], 
   Line3DBox[{{33, 11, 5}, {32.80630778457968, 9.726625654469787, 
     5.176071297578772}}], 
   Line3DBox[{{44, 11, 5}, {43.902211574288756`, 9.730989347561021, 
     5.264668448805879}}], 
   Line3DBox[{{55, 11, 5}, {54.852444354876944`, 9.727381478620124, 
     5.220611492522986}}], 
   Line3DBox[{{38, 12, 5}, {37.88753227534749, 10.71929053444318, 
     5.1927025577013755`}}], 
   Line3DBox[{{49, 12, 5}, {49.00362491202776, 10.720251399702647`, 
     5.228539668438009}}], 
   Line3DBox[{{32, 13, 5}, {31.7807828327555, 11.741691184389285`, 
     5.242080065560251}}], 
   Line3DBox[{{43, 13, 5}, {42.91155388647433, 11.729104978291241`, 
     5.258849625841144}}], 
   Line3DBox[{{54, 13, 5}, {53.945417910528704`, 11.726132340373288`, 
     5.253538914697747}}], 
   Line3DBox[{{37, 14, 5}, {36.90202308501822, 12.727365879447216`, 
     5.246582479782108}}], 
   Line3DBox[{{48, 14, 5}, {48.025018827361656`, 12.72292880795252, 
     5.241791705233819}}], 
   Line3DBox[{{31, 15, 5}, {30.844105015638192`, 13.739322611674362`, 
     5.276386100257011}}], 
   Line3DBox[{{42, 15, 5}, {41.91123142505923, 13.725456389317404`, 
     5.2401223116896}}], 
   Line3DBox[{{53, 15, 5}, {52.990738165114784`, 13.728929756037294`, 
     5.272570455712179}}], 
   Line3DBox[{{36, 16, 5}, {35.93357321263351, 14.726238137923563`, 
     5.251233358930968}}], 
   Line3DBox[{{47, 16, 5}, {46.97065157856329, 14.727257584024848`, 
     5.263183230348947}}], 
   Line3DBox[{{30, 17, 5}, {29.923968970863704`, 15.7316572281874, 
     5.274819751472133}}], 
   Line3DBox[{{41, 17, 5}, {40.89841166396036, 15.728501596199733`, 
     5.250941465513515}}], 
   Line3DBox[{{52, 17, 5}, {51.92947450284451, 15.731387290489689`, 
     5.275041719598825}}], 
   Line3DBox[{{35, 18, 5}, {34.967316250015024`, 16.72576554168896, 
     5.255457076119825}}], 
   Line3DBox[{{46, 18, 5}, {45.92357159882936, 16.726654763462317`, 
     5.250500714732101}}], 
   Line3DBox[{{29, 19, 5}, {28.95520374440837, 17.72765039925283, 
     5.262906426249885}}], 
   Line3DBox[{{40, 19, 5}, {39.9375947255373, 17.729322925075373`, 
     5.267367449365525}}], 
   Line3DBox[{{51, 19, 5}, {50.87768468234771, 17.732962632185533`, 
     5.263922851662008}}], 
   Line3DBox[{{34, 20, 5}, {33.98255345036917, 18.72717301082618, 
     5.263831524910665}}], 
   Line3DBox[{{45, 20, 5}, {44.9428347816815, 18.734956204072297`, 
     5.2939325300122855`}}], 
   Line3DBox[{{28, 21, 5}, {27.980726251922803`, 19.720990365538196`, 
     5.231868233246689}}], 
   Line3DBox[{{39, 21, 5}, {38.98361322767128, 19.717791553709187`, 
     5.21371236265867}}], 
   Line3DBox[{{50, 21, 5}, {49.90227988311029, 19.723648484512076`, 
     5.226666247303705}}], 
   Line3DBox[{{33, 22, 5}, {32.984257982763054`, 20.72405906727211, 
     5.248449039206807}}], 
   Line3DBox[{{44, 22, 5}, {43.889422372582544`, 20.737137067073256`, 
     5.288010070925293}}], 
   Line3DBox[{{55, 22, 5}, {54.84913169582171, 20.719102032292188`, 
     5.162908413276794}}], 
   Line3DBox[{{38, 23, 5}, {37.949586181353425`, 21.712584004370946`, 
     5.173258480565664}}], 
   Line3DBox[{{49, 23, 5}, {48.9363295184472, 21.718396704463505`, 
     5.208420398830898}}], 
   Line3DBox[{{32, 24, 5}, {31.977503120461158`, 22.7168087771311, 
     5.207157370043245}}], 
   Line3DBox[{{43, 24, 5}, {42.894079574403676`, 22.728002186578383`, 
     5.246581479621073}}], 
   Line3DBox[{{54, 24, 5}, {53.879337718601995`, 22.70812024007385, 
     5.080543775308706}}], 
   Line3DBox[{{37, 25, 5}, {36.938005074475505`, 23.709631790622215`, 
     5.145280808905986}}], 
   Line3DBox[{{48, 25, 5}, {47.97294727899381, 23.71363782337865, 
     5.185850748839348}}], 
   Line3DBox[{{31, 26, 5}, {30.96248619095906, 24.711045568626993`, 
     5.1648914430015465`}}], 
   Line3DBox[{{42, 26, 5}, {41.92455420871339, 24.71272316279002, 
     5.165003869529786}}], 
   Line3DBox[{{53, 26, 5}, {52.960683821838686`, 24.70368541562745, 
     5.089569729696004}}], 
   Line3DBox[{{36, 27, 5}, {35.97642802012921, 25.707372156070818`, 
     5.136226351576938}}], 
   Line3DBox[{{47, 27, 5}, {46.99674730338597, 25.70688343265102, 
     5.133562581632442}}], 
   Line3DBox[{{30, 1, 6}, {29.972002543241373`, -0.29756427617878667`, 
     6.074451941543992}}], 
   Line3DBox[{{41, 1, 6}, {40.89537794925654, -0.2913387563607779, 
     6.1072307923072096`}}], 
   Line3DBox[{{52, 1, 6}, {52.03079112166812, -0.2996057038180071, 
     5.991229513689549}}], 
   Line3DBox[{{35, 2, 6}, {35.01142476374133, 0.7008603161952986, 
     6.045886345869727}}], 
   Line3DBox[{{46, 2, 6}, {45.825033684511, 0.721881693566033, 
     6.160624976895166}}], 
   Line3DBox[{{29, 3, 6}, {28.967978063578585`, 1.7059798297607915`, 
     6.1203594391890945`}}], 
   Line3DBox[{{40, 3, 6}, {39.85433637707284, 1.719043836323817, 
     6.16713292822101}}], 
   Line3DBox[{{51, 3, 6}, {51.00349512452986, 1.7021784655573808`, 
     6.075146848513606}}], 
   Line3DBox[{{34, 4, 6}, {33.924891328122754`, 2.703823987203309, 
     6.065470842818063}}], 
   Line3DBox[{{45, 4, 6}, {44.79493710759695, 2.72632203271946, 
     6.160292376061396}}], 
   Line3DBox[{{28, 5, 6}, {27.936400758000854`, 3.710030917087537, 
     6.148104360324449}}], 
   Line3DBox[{{39, 5, 6}, {38.81667815249301, 3.7205668760239803`, 
     6.139441677770984}}], 
   Line3DBox[{{50, 5, 6}, {49.88630264889074, 3.7147756479347738`, 
     6.158969422246098}}], 
   Line3DBox[{{33, 6, 6}, {32.91630948586485, 4.7053871595968, 
     6.083507432644962}}], 
   Line3DBox[{{44, 6, 6}, {43.81812281139168, 4.7210857423798345`, 
     6.145941803194953}}], 
   Line3DBox[{{55, 6, 6}, {54.93299032284374, 4.716446867252059, 
     6.19493860207861}}], 
   Line3DBox[{{38, 7, 6}, {37.820173409649335`, 5.719804428594924, 
     6.136973341777456}}], 
   Line3DBox[{{49, 7, 6}, {48.838062231479185`, 5.731390079864277, 
     6.233248857788705}}], 
   Line3DBox[{{32, 8, 6}, {31.87250697324349, 6.7121334530766985`, 
     6.123066183187409}}], 
   Line3DBox[{{43, 8, 6}, {42.88007193498093, 6.714938907263624, 
     6.155676739290025}}], 
   Line3DBox[{{54, 8, 6}, {53.86505229965684, 6.725893969758434, 
     6.220097573530854}}], 
   Line3DBox[{{37, 9, 6}, {36.83405685087815, 7.721901834262221, 
     6.170082186007962}}], 
   Line3DBox[{{48, 9, 6}, {47.849096225315414`, 7.728336293458801, 
     6.22382910501506}}], 
   Line3DBox[{{31, 10, 6}, {30.827742889387345`, 8.72180854159293, 
     6.162954237436726}}], 
   Line3DBox[{{42, 10, 6}, {41.886292424620464`, 8.717383266871057, 
     6.178787312746024}}], 
   Line3DBox[{{53, 10, 6}, {52.87384064047486, 8.719935118604713, 
     6.188461442801108}}], 
   Line3DBox[{{36, 11, 6}, {35.83952188648955, 9.725291768898469, 
     6.198407914776934}}], 
   Line3DBox[{{47, 11, 6}, {46.899977134552294`, 9.720579812987241, 
     6.207555803223779}}], 
   Line3DBox[{{30, 12, 6}, {29.75303721677428, 10.742061247904646`, 
     6.2158691262737475`}}], 
   Line3DBox[{{41, 12, 6}, {40.86689691372811, 10.727463775782866`, 
     6.230076349241064}}], 
   Line3DBox[{{52, 12, 6}, {51.96705795496109, 10.718380289667355`, 
     6.215327053004308}}], 
   Line3DBox[{{35, 13, 6}, {34.86656146411859, 11.728097028058508`, 
     6.233360208922226}}], 
   Line3DBox[{{46, 13, 6}, {45.955542981262234`, 11.727023873183155`, 
     6.259914128202629}}], 
   Line3DBox[{{29, 14, 6}, {28.779529391592668`, 12.755863707494356`, 
     6.305806469027082}}], 
   Line3DBox[{{40, 14, 6}, {39.87292996850828, 12.725501849494036`, 
     6.2225031942547515`}}], 
   Line3DBox[{{51, 14, 6}, {51.01925416204564, 12.723634432394658`, 
     6.24600856707727}}], 
   Line3DBox[{{34, 15, 6}, {33.888951247249935`, 13.73343540601455, 
     6.271076195515445}}], 
   Line3DBox[{{45, 15, 6}, {44.916630337381434`, 13.732276946441246`, 
     6.275549920759439}}], 
   Line3DBox[{{28, 16, 6}, {27.910658029622795`, 14.738555049353414`, 
     6.301288315102579}}], 
   Line3DBox[{{39, 16, 6}, {38.87929110175622, 14.72753350947809, 
     6.237188516550922}}], 
   Line3DBox[{{50, 16, 6}, {49.99517347304748, 14.71891731854444, 
     6.220915974778211}}], 
   Line3DBox[{{33, 17, 6}, {32.915584753181236`, 15.73231714323165, 
     6.2754164859992265`}}], 
   Line3DBox[{{44, 17, 6}, {43.911723399373116`, 15.73058131394224, 
     6.266051576332774}}], 
   Line3DBox[{{55, 17, 6}, {54.921725861714066`, 15.729827547779012`, 
     6.265584451530042}}], 
   Line3DBox[{{38, 18, 6}, {37.9208878939053, 16.729957803362275`, 
     6.265958819047009}}], 
   Line3DBox[{{49, 18, 6}, {48.93021257776295, 16.727445368183645`, 
     6.256387255416968}}], 
   Line3DBox[{{32, 19, 6}, {31.96602295736511, 17.724772225189252`, 
     6.2502792099336535`}}], 
   Line3DBox[{{43, 19, 6}, {42.9375398961729, 17.72816232565326, 
     6.261777893532239}}], 
   Line3DBox[{{54, 19, 6}, {53.90308780736204, 17.726952297303, 
     6.244862356388235}}], 
   Line3DBox[{{37, 20, 6}, {36.96219407849074, 18.718209467500685`, 
     6.2135034966785305`}}], 
   Line3DBox[{{48, 20, 6}, {47.8831180670024, 18.73563874474979, 
     6.278799623315487}}], 
   Line3DBox[{{31, 21, 6}, {30.983003183383687`, 19.720699874276914`, 
     6.230439355470814}}], 
   Line3DBox[{{42, 21, 6}, {41.935138612940136`, 19.723237559284954`, 
     6.235946329592195}}], 
   Line3DBox[{{53, 21, 6}, {52.87335766000009, 19.721924105252548`, 
     6.201205678311645}}], 
   Line3DBox[{{36, 22, 6}, {35.97023749114185, 20.711524134823396`, 
     6.170129767894607}}], 
   Line3DBox[{{47, 22, 6}, {46.87813644447119, 20.733349783411608`, 
     6.265982147240111}}], 
   Line3DBox[{{30, 23, 6}, {29.994665639209902`, 21.716072166130154`, 
     6.203717603582136}}], 
   Line3DBox[{{41, 23, 6}, {40.92148485725731, 21.71521062356583, 
     6.182075892314159}}], 
   Line3DBox[{{52, 23, 6}, {51.914848432143074`, 21.71116564781894, 
     6.147157137541946}}], 
   Line3DBox[{{35, 24, 6}, {34.9328149979412, 22.712311613037944`, 
     6.16536261240502}}], 
   Line3DBox[{{46, 24, 6}, {45.8733412120296, 22.726719332407953`, 
     6.229595063026679}}], 
   Line3DBox[{{29, 25, 6}, {29.039993025629535`, 23.714635578403637`, 
     6.190365074515384}}], 
   Line3DBox[{{40, 25, 6}, {39.91001047423062, 23.710571959053983`, 
     6.138842401570691}}], 
   Line3DBox[{{51, 25, 6}, {50.99334463977004, 23.70745615130246, 
     6.138874423038811}}], 
   Line3DBox[{{34, 26, 6}, {33.92645413004859, 24.70786783411618, 
     6.122415157972666}}], 
   Line3DBox[{{45, 26, 6}, {44.91071907455684, 24.71635480219185, 
     6.185159181506329}}], 
   Line3DBox[{{28, 27, 6}, {28.05353149917761, 25.70998746149856, 
     6.151664198494145}}], 
   Line3DBox[{{39, 27, 6}, {38.98461581767242, 25.705149318374236`, 
     6.114564563576212}}], 
   Line3DBox[{{50, 27, 6}, {50.042442706766174`, 25.704009053022613`, 
     6.092768971078807}}], 
   Line3DBox[{{33, 1, 7}, {33.013352646961714`, -0.2994336622341278, 
     7.035970324879255}}], 
   Line3DBox[{{44, 1, 7}, {43.844687565707524`, -0.283663819804407, 
     7.134481394546988}}], 
   Line3DBox[{{55, 1, 7}, {55.0183812208171, -0.2997667018912491, 
     7.01639058803147}}], 
   Line3DBox[{{38, 2, 7}, {37.890937169424724`, 0.7088352795599451, 
     7.104875944228712}}], 
   Line3DBox[{{49, 2, 7}, {48.927598675698746`, 0.7040515055608885, 
     7.072632967724207}}], 
   Line3DBox[{{32, 3, 7}, {31.990835979116543`, 1.700148738667888, 
     7.017398825666292}}], 
   Line3DBox[{{43, 3, 7}, {42.809833454138406`, 1.721438561797382, 
     7.138265446067791}}], 
   Line3DBox[{{54, 3, 7}, {54.014988879770954`, 1.703563549614701, 
     7.095015070360325}}], 
   Line3DBox[{{37, 4, 7}, {36.87898692375553, 2.7097991817992724`, 
     7.103622797163667}}], 
   Line3DBox[{{48, 4, 7}, {47.81939449270346, 2.7218068863728937`, 
     7.153635982147421}}], 
   Line3DBox[{{31, 5, 7}, {30.941428594771544`, 3.7028744972865955`, 
     7.063520238507582}}], 
   Line3DBox[{{42, 5, 7}, {41.8131726846459, 3.7187826282209233`, 
     7.116522961209773}}], 
   Line3DBox[{{53, 5, 7}, {52.97211060380365, 3.708292927072206, 
     7.143927132008226}}], 
   Line3DBox[{{36, 6, 7}, {35.84734930039939, 4.711663700981939, 
     7.082990026773634}}], 
   Line3DBox[{{47, 6, 7}, {46.7880318748946, 4.730982504945018, 
     7.18618300455111}}], 
   Line3DBox[{{30, 7, 7}, {29.84847885669289, 5.71249176426491, 
     7.096767174419954}}], 
   Line3DBox[{{41, 7, 7}, {40.835291281999055`, 5.716851949598672, 
     7.1280707576527815`}}], 
   Line3DBox[{{52, 7, 7}, {51.91298191130133, 5.716800780746773, 
     7.189281842624004}}], 
   Line3DBox[{{35, 8, 7}, {34.842564089871395`, 6.713781108601196, 
     7.104186839911807}}], 
   Line3DBox[{{46, 8, 7}, {45.85129390037161, 6.723300644844073, 
     7.194744069172213}}], 
   Line3DBox[{{29, 9, 7}, {28.810968314734687`, 7.72001429356971, 
     7.12610952898138}}], 
   Line3DBox[{{40, 9, 7}, {39.861402965376264`, 7.715126403744723, 
     7.1410344058715385`}}], 
   Line3DBox[{{51, 9, 7}, {50.86824013249202, 7.724615351140143, 
     7.214553803897525}}], 
   Line3DBox[{{34, 10, 7}, {33.84121280362336, 8.72085818919441, 
     7.1690646447837}}], 
   Line3DBox[{{45, 10, 7}, {44.920416654314955`, 8.719441395550332, 
     7.209370847205368}}], 
   Line3DBox[{{28, 11, 7}, {27.776458757058002`, 9.72669264692519, 
     7.136812635781822}}], 
   Line3DBox[{{39, 11, 7}, {38.821227944485415`, 9.723506654735235, 
     7.1691309896555255`}}], 
   Line3DBox[{{50, 11, 7}, {49.92467833170573, 9.721397132006043, 
     7.222488993532256}}], 
   Line3DBox[{{33, 12, 7}, {32.78057798889987, 10.736214147755662`, 
     7.211422091352416}}], 
   Line3DBox[{{44, 12, 7}, {43.908783627005135`, 10.731078580827148`, 
     7.267428504954162}}], 
   Line3DBox[{{55, 12, 7}, {54.90561603429151, 10.722425002210603`, 
     7.221119406747942}}], 
   Line3DBox[{{38, 13, 7}, {37.89630790330786, 11.72448524018217, 
     7.228713896758485}}], 
   Line3DBox[{{49, 13, 7}, {49.011760506233166`, 11.717019400765825`, 
     7.209338177315685}}], 
   Line3DBox[{{32, 14, 7}, {31.78551609457325, 12.744406812616987`, 
     7.259773751773064}}], 
   Line3DBox[{{43, 14, 7}, {42.88626711842653, 12.732638609912827`, 
     7.2661953015462615`}}], 
   Line3DBox[{{54, 14, 7}, {54.002399423120664`, 12.715426009178199`, 
     7.19965947228428}}], 
   Line3DBox[{{37, 15, 7}, {36.92390174196384, 13.729905691846486`, 
     7.266588641018165}}], 
   Line3DBox[{{48, 15, 7}, {47.99977456827498, 13.722853098135005`, 
     7.2426844458080915`}}], 
   Line3DBox[{{31, 16, 7}, {30.85260488413062, 14.75006799010168, 
     7.325491398426129}}], 
   Line3DBox[{{42, 16, 7}, {41.86856612581205, 14.72561063533415, 
     7.2205830545225975`}}], 
   Line3DBox[{{53, 16, 7}, {52.98143981229696, 14.721870175304815`, 
     7.236726996046262}}], 
   Line3DBox[{{36, 17, 7}, {35.94134182619208, 15.729140717491534`, 
     7.2673497759632255`}}], 
   Line3DBox[{{47, 17, 7}, {46.95658006489699, 15.723323238027925`, 
     7.241269879338781}}], 
   Line3DBox[{{30, 18, 7}, {29.998413840822625`, 16.726253881456657`, 
     7.25993904976904}}], 
   Line3DBox[{{41, 18, 7}, {40.88798024211801, 16.72247394982975, 
     7.213022921256064}}], 
   Line3DBox[{{52, 18, 7}, {51.939205955617275`, 16.726608227663814`, 
     7.254514200613837}}], 
   Line3DBox[{{35, 19, 7}, {34.98317884199457, 17.7214721798345, 
     7.234699087570039}}], 
   Line3DBox[{{46, 19, 7}, {45.9274155214693, 17.728140045676128`, 
     7.259043915318821}}], 
   Line3DBox[{{29, 20, 7}, {29.068112668020458`, 18.723247380319986`, 
     7.235081714719273}}], 
   Line3DBox[{{40, 20, 7}, {39.93146586374638, 18.721771982232276`, 
     7.226795517507661}}], 
   Line3DBox[{{51, 20, 7}, {50.87011120620567, 18.729475650949286`, 
     7.242686587424837}}], 
   Line3DBox[{{34, 21, 7}, {33.96693046014317, 19.719372328546807`, 
     7.221131573146026}}], 
   Line3DBox[{{45, 21, 7}, {44.9199175803534, 19.736663778142905`, 
     7.295919577938654}}], 
   Line3DBox[{{28, 22, 7}, {28.057717701626967`, 20.722903564212398`, 
     7.235994408021687}}], 
   Line3DBox[{{39, 22, 7}, {38.94493539887867, 20.713419381741762`, 
     7.177983713933614}}], 
   Line3DBox[{{50, 22, 7}, {49.89648105755722, 20.726432037035455`, 
     7.239391880116826}}], 
   Line3DBox[{{33, 23, 7}, {32.973421466157276`, 21.7189653115523, 
     7.219644504899327}}], 
   Line3DBox[{{44, 23, 7}, {43.88222700081416, 21.731099888392666`, 
     7.256947518815939}}], 
   Line3DBox[{{55, 23, 7}, {54.90263512005304, 21.710436940076157`, 
     7.1324658243954735`}}], 
   Line3DBox[{{38, 24, 7}, {37.899854169779346`, 22.710507726402145`, 
     7.131074364468611}}], 
   Line3DBox[{{49, 24, 7}, {48.951314372825344`, 22.718519883870393`, 
     7.213162899377577}}], 
   Line3DBox[{{32, 25, 7}, {31.97059278009175, 23.709370196337034`, 
     7.153003023872602}}], 
   Line3DBox[{{43, 25, 7}, {42.90132453170851, 23.7188153339838, 
     7.197050763820947}}], 
   Line3DBox[{{54, 25, 7}, {53.97875043068438, 23.705006030729926`, 
     7.111978012833068}}], 
   Line3DBox[{{37, 26, 7}, {36.94270257812784, 24.70557779918798, 
     7.105774153231187}}], 
   Line3DBox[{{48, 26, 7}, {48.004044725974374`, 24.712602485162844`, 
     7.180530548614093}}], 
   Line3DBox[{{31, 27, 7}, {30.9632186770973, 25.70262338397784, 
     7.073898920725634}}], 
   Line3DBox[{{42, 27, 7}, {41.91389103941706, 25.706415769313757`, 
     7.09604730619445}}], 
   Line3DBox[{{53, 27, 7}, {53.077541487011864`, 25.705537870983132`, 
     7.091406314514387}}], 
   Line3DBox[{{36, 1, 8}, {36.01066815577564, -0.29907691652355295`, 
     8.047805390993112}}], 
   Line3DBox[{{47, 1, 8}, {46.85857139557447, -0.2874539391908777, 
     8.111625733198666}}], 
   Line3DBox[{{30, 2, 8}, {29.979740749105453`, 0.7020461105019102, 
     8.070037586266036}}], 
   Line3DBox[{{41, 2, 8}, {40.830487481365225`, 0.7149739547211602, 
     8.099867757465166}}], 
   Line3DBox[{{52, 2, 8}, {52.02645229540352, 0.700513656989225, 
     8.025209529872013}}], 
   Line3DBox[{{35, 3, 8}, {34.96415785938456, 1.7014089726572519`, 
     8.048751252917326}}], 
   Line3DBox[{{46, 3, 8}, {45.7721947714352, 1.7270875876264569`, 
     8.133412024435229}}], 
   Line3DBox[{{29, 4, 8}, {28.955464946093212`, 2.705765168762092, 
     8.113898334421991}}], 
   Line3DBox[{{40, 4, 8}, {39.78181096440409, 2.7253400964000214`, 
     8.13279937838793}}], 
   Line3DBox[{{51, 4, 8}, {50.96421333500285, 2.7034018622160074`, 
     8.08690560225592}}], 
   Line3DBox[{{34, 5, 8}, {33.90639570384542, 3.7052582527009195`, 
     8.069871621867039}}], 
   Line3DBox[{{45, 5, 8}, {44.7586223403551, 3.7270737653951995`, 
     8.106750300604713}}], 
   Line3DBox[{{28, 6, 8}, {27.880524234888025`, 4.707781921331441, 
     8.076798298894223}}], 
   Line3DBox[{{39, 6, 8}, {38.78804946918969, 4.721209292633037, 
     8.09884988235263}}], 
   Line3DBox[{{50, 6, 8}, {49.885642901857054`, 4.716939065422371, 
     8.17514877180587}}], 
   Line3DBox[{{33, 7, 8}, {32.87192684842346, 5.7088927555832525`, 
     8.08148221437741}}], 
   Line3DBox[{{44, 7, 8}, {43.795630843941844`, 5.723036189793011, 
     8.132652461242632}}], 
   Line3DBox[{{55, 7, 8}, {54.95532604457799, 5.719460876433583, 
     8.219599159203096}}], 
   Line3DBox[{{38, 8, 8}, {37.80534478983003, 6.721872893310021, 
     8.136016353053558}}], 
   Line3DBox[{{49, 8, 8}, {48.8275652845895, 6.731900564339815, 
     8.228451505137569}}], 
   Line3DBox[{{32, 9, 8}, {31.85625009926403, 7.716469413352309, 
     8.147936470074942}}], 
   Line3DBox[{{43, 9, 8}, {42.86008686054839, 7.716844470417345, 
     8.15471328420744}}], 
   Line3DBox[{{54, 9, 8}, {53.888492864497124`, 7.724907447772768, 
     8.227387646952485}}], 
   Line3DBox[{{37, 10, 8}, {36.79403388099738, 8.72906431342126, 
     8.179723227223496}}], 
   Line3DBox[{{48, 10, 8}, {47.87310692935041, 8.723972698546078, 
     8.21366439704673}}], 
   Line3DBox[{{31, 11, 8}, {30.543644658185233`, 9.803559245451586, 
     8.224208213169701}}], 
   Line3DBox[{{42, 11, 8}, {41.85585359169474, 9.721595915611141, 
     8.186828290123781}}], 
   Line3DBox[{{53, 11, 8}, {52.91298007666677, 9.721757005810774, 
     8.220277962468426}}], 
   Line3DBox[{{36, 12, 8}, {35.86291958757293, 10.726553552578284`, 
     8.222582807237758}}], 
   Line3DBox[{{47, 12, 8}, {46.92864985374402, 10.722648527932844`, 
     8.230829749896149}}], 
   Line3DBox[{{30, 13, 8}, {29.69969844399924, 11.749550201962908`, 
     8.190247938366005}}], 
   Line3DBox[{{41, 13, 8}, {40.85217936806748, 11.725529393346136`, 
     8.209460577556742}}], 
   Line3DBox[{{52, 13, 8}, {51.99011430117173, 11.717719464667638`, 
     8.21367943669532}}], 
   Line3DBox[{{35, 14, 8}, {34.897279963053066`, 12.736743512647257`, 
     8.289191357358462}}], 
   Line3DBox[{{46, 14, 8}, {45.92869135195735, 12.729258932466468`, 
     8.264824877981786}}], 
   Line3DBox[{{29, 15, 8}, {28.67983700423271, 13.853890938315988`, 
     8.523382914191044}}], 
   Line3DBox[{{40, 15, 8}, {39.840839480777966`, 13.726383648992973`, 
     8.206323337430645}}], 
   Line3DBox[{{51, 15, 8}, {51.00065638174389, 13.717872575779351`, 
     8.2148228042465}}], 
   Line3DBox[{{34, 16, 8}, {33.8954122368411, 14.742289080493531`, 
     8.311808663689146}}], 
   Line3DBox[{{45, 16, 8}, {44.91427538036431, 14.728999560688527`, 
     8.259247319867264}}], 
   Line3DBox[{{28, 17, 8}, {28.028731455634574`, 15.738593944694395`, 
     8.313096258514012}}], 
   Line3DBox[{{39, 17, 8}, {38.864011424196185`, 15.725113485304558`, 
     8.214875503253765}}], 
   Line3DBox[{{50, 17, 8}, {49.94218610947521, 15.721756129966701`, 
     8.229674035939386}}], 
   Line3DBox[{{33, 18, 8}, {32.94224177804383, 16.73552494339263, 
     8.296254652308187}}], 
   Line3DBox[{{44, 18, 8}, {43.91919961442675, 16.725394642869922`, 
     8.242595303471697}}], 
   Line3DBox[{{55, 18, 8}, {54.94471273687535, 16.723053344097327`, 
     8.23738272160198}}], 
   Line3DBox[{{38, 19, 8}, {37.91152688314873, 17.726453340553533`, 
     8.245461634084377}}], 
   Line3DBox[{{49, 19, 8}, {48.8912273734783, 17.73387257500414, 
     8.274025289695896}}], 
   Line3DBox[{{32, 20, 8}, {31.987333449009785`, 18.721861363751785`, 
     8.23706789115264}}], 
   Line3DBox[{{43, 20, 8}, {42.9313091573203, 18.722346737332654`, 
     8.229964581028113}}], 
   Line3DBox[{{54, 20, 8}, {53.90619935473892, 18.724962853229993`, 
     8.235545565242068}}], 
   Line3DBox[{{37, 21, 8}, {36.9391479409426, 19.714495544925292`, 
     8.183780637966985}}], 
   Line3DBox[{{48, 21, 8}, {47.869408118498214`, 19.734724457645473`, 
     8.268372059658379}}], 
   Line3DBox[{{31, 22, 8}, {31.02038754565519, 20.720531431632285`, 
     8.229225937758425}}], 
   Line3DBox[{{42, 22, 8}, {41.91349771105305, 20.7239835782676, 
     8.233022414106838}}], 
   Line3DBox[{{53, 22, 8}, {52.904348524160525`, 20.715711396651336`, 
     8.177351567454215}}], 
   Line3DBox[{{36, 23, 8}, {35.937532918180445`, 21.712187498471252`, 
     8.166243269323068}}], 
   Line3DBox[{{47, 23, 8}, {46.90143625115725, 21.727121715042443`, 
     8.245083779752093}}], 
   Line3DBox[{{30, 24, 8}, {30.05425539353082, 22.713747904992196`, 
     8.180587652847166}}], 
   Line3DBox[{{41, 24, 8}, {40.879078130295945`, 22.720239117032353`, 
     8.19388136540973}}], 
   Line3DBox[{{52, 24, 8}, {51.96944095260657, 22.709472580899778`, 
     8.153639595068862}}], 
   Line3DBox[{{35, 25, 8}, {34.92490533295748, 23.71062094164431, 
     8.147859510534738}}], 
   Line3DBox[{{46, 25, 8}, {45.95057713734348, 23.715732665594793`, 
     8.19548604662886}}], 
   Line3DBox[{{29, 26, 8}, {29.07063824854504, 24.709818724479973`, 
     8.142977320369367}}], 
   Line3DBox[{{40, 26, 8}, {39.93088642432621, 24.706630913164542`, 
     8.111443792451606}}], 
   Line3DBox[{{51, 26, 8}, {51.078440363085186`, 24.70764995028764, 
     8.116954941954235}}], 
   Line3DBox[{{34, 27, 8}, {33.94754132680143, 25.7032086543381, 
     8.0747013615849}}], 
   Line3DBox[{{45, 27, 8}, {44.92957793054669, 25.707729337204658`, 
     8.122789519961602}}], 
   Line3DBox[{{28, 1, 9}, {27.96338036004217, -0.2937483937426624, 
     9.121959401677936}}], 
   Line3DBox[{{39, 1, 9}, {38.84036690995144, -0.2891592878621885, 
     9.05084886508276}}], 
   Line3DBox[{{50, 1, 9}, {49.98044757378649, -0.29910915335446964`, 
     9.043967150235122}}], 
   Line3DBox[{{33, 2, 9}, {32.98858405719621, 0.700078525800949, 
     8.991407144475353}}], 
   Line3DBox[{{44, 2, 9}, {43.7725136822391, 0.7245729261100398, 
     9.107404629416429}}], 
   Line3DBox[{{55, 2, 9}, {55.02710981354097, 0.7017765758951005, 
     9.062297665406682}}], 
   Line3DBox[{{38, 3, 9}, {37.83944239375778, 1.7123554123757312`, 
     9.078693526034206}}], 
   Line3DBox[{{49, 3, 9}, {48.90918557859925, 1.7066570548241404`, 
     9.09495665868953}}], 
   Line3DBox[{{32, 4, 9}, {31.956317812520506`, 2.700836656117601, 
     9.016323982642472}}], 
   Line3DBox[{{43, 4, 9}, {42.74859464389265, 2.727649019917933, 
     9.08898500100995}}], 
   Line3DBox[{{54, 4, 9}, {54.01077119335463, 2.7061679670916536`, 
     9.12602639411636}}], 
   Line3DBox[{{37, 5, 9}, {37.15762776113642, 6.289334767426091, 
     8.94737541995009}}], 
   Line3DBox[{{48, 5, 9}, {47.81146330514175, 3.7252564078608534`, 
     9.171705238685698}}], 
   Line3DBox[{{31, 6, 9}, {31.1079997618462, 7.294290211522542, 
     8.943884941431929}}], 
   Line3DBox[{{42, 6, 9}, {41.76845271410546, 4.723010483884191, 
     9.075389854258951}}], 
   Line3DBox[{{53, 6, 9}, {52.983095326853565`, 4.710400689646502, 
     9.163241694311207}}], 
   Line3DBox[{{36, 7, 9}, {35.82756192701265, 5.714234881036449, 
     9.08410213933698}}], 
   Line3DBox[{{47, 7, 9}, {46.79831572645595, 5.729133250481834, 
     9.184989618017172}}], 
   Line3DBox[{{30, 8, 9}, {29.85949982217401, 6.7112496090841685`, 
     9.096861395535873}}], 
   Line3DBox[{{41, 8, 9}, {40.83506900039225, 6.71754630191558, 
     9.134574431590796}}], 
   Line3DBox[{{52, 8, 9}, {51.932038503741914`, 6.7169215213002555`, 
     9.197714067592349}}], 
   Line3DBox[{{35, 9, 9}, {34.826212333266966`, 7.720667231542303, 
     9.152004981634994}}], 
   Line3DBox[{{46, 9, 9}, {45.84809363033454, 7.721715761881762, 
     9.181421777726754}}], 
   Line3DBox[{{29, 10, 9}, {29.600568503271273`, 9.776012396384925, 
     7.869006177600745}}], 
   Line3DBox[{{40, 10, 9}, {39.82162905838227, 8.722058276322123, 
     9.158267994457582}}], 
   Line3DBox[{{51, 10, 9}, {50.911554217825895`, 8.721710889341058, 
     9.219440864896171}}], 
   Line3DBox[{{34, 11, 9}, {33.80514036278318, 9.741648884480455, 
     9.261882018959765}}], 
   Line3DBox[{{45, 11, 9}, {44.877096581928896`, 9.725931871036522, 
     9.227255698687499}}], 
   Line3DBox[{{28, 12, 9}, {27.882373954833547`, 10.84630828690859, 
     8.41249719605545}}], 
   Line3DBox[{{39, 12, 9}, {38.84876323709694, 10.725463442099894`, 
     9.20660107483446}}], 
   Line3DBox[{{50, 12, 9}, {49.9630077572257, 10.719620188799317`, 
     9.221943941219914}}], 
   Line3DBox[{{33, 13, 9}, {32.72437317693592, 11.747207339117645`, 
     9.211045974249485}}], 
   Line3DBox[{{44, 13, 9}, {43.87075633829425, 11.733097501684565`, 
     9.26125492468277}}], 
   Line3DBox[{{55, 13, 9}, {54.970221957083865`, 11.722468234233741`, 
     9.238800870220837}}], 
   Line3DBox[{{38, 14, 9}, {37.92155957289349, 12.721289776064534`, 
     9.220787822576927}}], 
   Line3DBox[{{49, 14, 9}, {48.98410309958876, 12.71725075292493, 
     9.210479589712767}}], 
   Line3DBox[{{32, 15, 9}, {31.62603858332397, 13.783059710901398`, 
     9.263076398801308}}], 
   Line3DBox[{{43, 15, 9}, {42.87704261882429, 13.725681736239395`, 
     9.225819496635184}}], 
   Line3DBox[{{54, 15, 9}, {53.99107977862973, 13.715894074500422`, 
     9.202465803896798}}], 
   Line3DBox[{{37, 16, 9}, {36.9393764209768, 14.723122445763742`, 
     9.236449768775632}}], 
   Line3DBox[{{48, 16, 9}, {47.93911611262623, 14.722775236608964`, 
     9.234499586436666}}], 
   Line3DBox[{{31, 17, 9}, {32.132991353456234`, 16.561873070729177`, 
     9.463006897185274}}], 
   Line3DBox[{{42, 17, 9}, {41.87916515646122, 15.717386958743653`, 
     9.174076784741969}}], 
   Line3DBox[{{53, 17, 9}, {52.974497116731364`, 15.72127104054033, 
     9.232812910260954}}], 
   Line3DBox[{{36, 18, 9}, {35.96337991740915, 16.723527888840465`, 
     9.243470571081916}}], 
   Line3DBox[{{47, 18, 9}, {46.902415889909264`, 16.722586316220244`, 
     9.22066178180653}}], 
   Line3DBox[{{30, 19, 9}, {30.062679530663424`, 17.729417681678317`, 
     9.267753335747868}}], 
   Line3DBox[{{41, 19, 9}, {40.899917274642156`, 17.7252083590916, 
     9.234285553022398}}], 
   Line3DBox[{{52, 19, 9}, {51.90372023328119, 17.72230011930613, 
     9.21957509283942}}], 
   Line3DBox[{{35, 20, 9}, {34.96430512279894, 18.717188539451023`, 
     9.207655080423757}}], 
   Line3DBox[{{46, 20, 9}, {45.8983211919907, 18.728120140619087`, 
     9.248963939764367}}], 
   Line3DBox[{{29, 21, 9}, {29.108239817832725`, 19.72332406667304, 
     9.219960685349172}}], 
   Line3DBox[{{40, 21, 9}, {39.929768054149186`, 19.717770847200878`, 
     9.202375575339651}}], 
   Line3DBox[{{51, 21, 9}, {50.87076723575757, 19.725460111100453`, 
     9.221013493366788}}], 
   Line3DBox[{{34, 22, 9}, {33.965017172049784`, 20.717390589949996`, 
     9.209019862692022}}], 
   Line3DBox[{{45, 22, 9}, {44.9133220178435, 20.728715663247936`, 
     9.257532643635988}}], 
   Line3DBox[{{28, 23, 9}, {28.086211039774163`, 21.71699719688613, 
     9.190975034554283}}], 
   Line3DBox[{{39, 23, 9}, {38.92914633386262, 21.713115552971765`, 
     9.170024051215492}}], 
   Line3DBox[{{50, 23, 9}, {49.942837121347694`, 21.717841672850582`, 
     9.206887480108369}}], 
   Line3DBox[{{33, 24, 9}, {32.99011038743512, 22.71146988474681, 
     9.172024235644024}}], 
   Line3DBox[{{44, 24, 9}, {43.92188838607803, 22.717615102263057`, 
     9.19846296840145}}], 
   Line3DBox[{{55, 24, 9}, {54.95202297475208, 22.707926624567452`, 
     9.135072564004318}}], 
   Line3DBox[{{38, 25, 9}, {37.92879561114361, 23.709104552202774`, 
     9.136084083801128}}], 
   Line3DBox[{{49, 25, 9}, {49.01426601102152, 23.71005857681273, 
     9.160771905739576}}], 
   Line3DBox[{{32, 26, 9}, {32.01006550218423, 24.703422522836007`, 
     9.093731165451166}}], 
   Line3DBox[{{43, 26, 9}, {42.92049525635327, 24.708869866278345`, 
     9.12908126716752}}], 
   Line3DBox[{{54, 26, 9}, {54.105614674752495`, 24.707145683532282`, 
     9.08586767067831}}], 
   Line3DBox[{{37, 27, 9}, {36.93838353146537, 25.703706995259815`, 
     9.076340399966062}}], 
   Line3DBox[{{48, 27, 9}, {48.01116150365108, 25.70596678044773, 
     9.123909029257083}}], 
   Line3DBox[{{31, 1, 10}, {30.996931269170467`, -0.299887809583659, 
     9.983199244454681}}], 
   Line3DBox[{{42, 1, 10}, {41.81985989349004, -0.28655115759036875`, 
     10.04832867605741}}], 
   Line3DBox[{{53, 1, 10}, {53.03562118314061, -0.2991744955436695, 
     10.029610157725271`}}], 
   Line3DBox[{{36, 2, 10}, {35.948460375967265`, 0.7011147188345248, 
     10.015514300701229`}}], 
   Line3DBox[{{47, 2, 10}, {46.78772745173186, 0.720901322748938, 
     10.094058168737927`}}], 
   Line3DBox[{{30, 3, 10}, {29.95795737339428, 1.7021571963267603`, 
     10.061939280764925`}}], 
   Line3DBox[{{41, 3, 10}, {40.73648331884002, 1.7285719643805197`, 
     10.063479988903758`}}], 
   Line3DBox[{{52, 3, 10}, {52.02127162109726, 1.7020031899314338`, 
     10.068933295204285`}}], 
   Line3DBox[{{35, 4, 10}, {34.904494884205505`, 2.7036201476811748`, 
     10.016674872080515`}}], 
   Line3DBox[{{46, 4, 10}, {45.75407948029147, 2.7280609472854427`, 
     10.108139466273345`}}], 
   Line3DBox[{{29, 5, 10}, {28.921239070726685`, 3.7044358488986457`, 
     10.072871437484327`}}], 
   Line3DBox[{{40, 5, 10}, {39.754021483774984`, 3.7267076823501077`, 
     10.090671072396358`}}], 
   Line3DBox[{{51, 5, 10}, {50.928551553460586`, 3.7078208951407308`, 
     10.12315957312447}}], 
   Line3DBox[{{34, 6, 10}, {33.89894566675987, 4.7047374755009574`, 
     10.045640052166481`}}], 
   Line3DBox[{{45, 6, 10}, {44.74932604079512, 4.729507932290022, 
     10.114072223010579`}}], 
   Line3DBox[{{28, 7, 10}, {27.877358953718836`, 5.705880470268038, 
     10.014622466733993`}}], 
   Line3DBox[{{39, 7, 10}, {38.784450839881586`, 5.721152882173963, 
     10.089936693291934`}}], 
   Line3DBox[{{50, 7, 10}, {49.87458468890472, 5.720647301788317, 
     10.193720606341607`}}], 
   Line3DBox[{{33, 8, 10}, {32.86191025613001, 6.710284451548178, 
     10.086977162057275`}}], 
   Line3DBox[{{44, 8, 10}, {43.7991316353963, 6.724011223982896, 
     10.14664427564623}}], 
   Line3DBox[{{55, 8, 10}, {54.99569783802542, 6.716952808405608, 
     10.209216145514844`}}], 
   Line3DBox[{{38, 9, 10}, {37.78635181936674, 7.726707833068218, 
     10.151926010091318`}}], 
   Line3DBox[{{49, 9, 10}, {48.88039677866927, 7.7244650551643055`, 
     10.220693620094274`}}], 
   Line3DBox[{{32, 10, 10}, {32.11326906473553, 8.77513324811456, 
     10.420561005205604`}}], 
   Line3DBox[{{43, 10, 10}, {42.83047007229676, 8.723536349152761, 
     10.178606135613185`}}], 
   Line3DBox[{{54, 10, 10}, {53.950915636095665`, 8.719385949320536, 
     10.218216356908554`}}], 
   Line3DBox[{{37, 11, 10}, {36.818178688075115`, 9.730787360941514, 
     10.21457000578857}}], 
   Line3DBox[{{48, 11, 10}, {47.89311472592508, 9.726841840923345, 
     10.240091316299601`}}], 
   Line3DBox[{{34, 12, 10}, {33.87233111019179, 10.725745542083416`, 
     10.223553642454897`}}], 
   Line3DBox[{{45, 12, 10}, {44.878523565235895`, 10.733249633886015`, 
     10.265682114089541`}}], 
   Line3DBox[{{31, 13, 10}, {31.728690887172036`, 12.34565171094235, 
     10.854890582214916`}}], 
   Line3DBox[{{42, 13, 10}, {41.84267812938212, 11.725738668990475`, 
     10.20373485052668}}], 
   Line3DBox[{{53, 13, 10}, {52.9876915525367, 11.715619451518574`, 
     10.200537050949686`}}], 
   Line3DBox[{{39, 14, 10}, {38.89122223639889, 12.720145817111641`, 
     10.200351363082737`}}], 
   Line3DBox[{{50, 14, 10}, {49.99895409679436, 12.719387244367748`, 
     10.223673592984184`}}], 
   Line3DBox[{{36, 15, 10}, {35.965048365663215`, 13.727614316977084`, 
     10.264221605656116`}}], 
   Line3DBox[{{47, 15, 10}, {46.95717333842968, 13.727041678104593`, 
     10.260274831238002`}}], 
   Line3DBox[{{33, 16, 10}, {32.89157055676412, 14.76338481022364, 
     10.386038765221748`}}], 
   Line3DBox[{{44, 16, 10}, {43.91080595685639, 14.72228596502086, 
     10.222466328879278`}}], 
   Line3DBox[{{55, 16, 10}, {54.982988194032835`, 14.722085078257653`, 
     10.238000107659609`}}], 
   Line3DBox[{{38, 17, 10}, {37.9211714969293, 15.72002422829283, 
     10.213185578654533`}}], 
   Line3DBox[{{49, 17, 10}, {48.92138340006552, 15.719766277172639`, 
     10.21170981354282}}], 
   Line3DBox[{{32, 18, 10}, {31.85984381717662, 16.814932596622487`, 
     10.515724242079482`}}], 
   Line3DBox[{{43, 18, 10}, {42.91511425301149, 16.719511197659372`, 
     10.2077085386749}}], 
   Line3DBox[{{54, 18, 10}, {53.985236904561134`, 16.72333248737767, 
     10.244749082179654`}}], 
   Line3DBox[{{37, 19, 10}, {36.91386574794738, 17.721407998041233`, 
     10.218594105937026`}}], 
   Line3DBox[{{48, 19, 10}, {47.87095211838639, 17.725336129247705`, 
     10.22040567336123}}], 
   Line3DBox[{{31, 20, 10}, {30.983234578323277`, 18.71574759295108, 
     10.20103401608946}}], 
   Line3DBox[{{42, 20, 10}, {41.90733662772966, 18.724377511334616`, 
     10.23281057933569}}], 
   Line3DBox[{{53, 20, 10}, {52.935038689367424`, 18.72281897075263, 
     10.233642133724912`}}], 
   Line3DBox[{{36, 21, 10}, {35.94279845698912, 19.71884171784169, 
     10.212982251688608`}}], 
   Line3DBox[{{47, 21, 10}, {46.89801430232922, 19.72651864904325, 
     10.240508141724913`}}], 
   Line3DBox[{{30, 22, 10}, {30.06202859041269, 20.721638024868344`, 
     10.227910321198735`}}], 
   Line3DBox[{{41, 22, 10}, {40.91396704892954, 20.719801780508742`, 
     10.20902356360354}}], 
   Line3DBox[{{52, 22, 10}, {51.90804575652535, 20.716876992193086`, 
     10.18745603202762}}], 
   Line3DBox[{{35, 23, 10}, {34.946484196157215`, 21.71796354907832, 
     10.208611114869747`}}], 
   Line3DBox[{{46, 23, 10}, {45.94540759167467, 21.720418713041237`, 
     10.222915676923359`}}], 
   Line3DBox[{{29, 24, 10}, {29.059385277427, 22.71204858291518, 
     10.166296530493348`}}], 
   Line3DBox[{{40, 24, 10}, {39.89730908258718, 22.716383134039926`, 
     10.178275957166827`}}], 
   Line3DBox[{{51, 24, 10}, {50.999934300203236`, 22.709511805076378`, 
     10.156972018036047`}}], 
   Line3DBox[{{34, 25, 10}, {33.991539255945405`, 23.70817181267433, 
     10.145287130334777`}}], 
   Line3DBox[{{45, 25, 10}, {44.95236990238679, 23.70947596034347, 
     10.149261772969338`}}], 
   Line3DBox[{{28, 26, 10}, {28.056621923504586`, 24.709607807466476`, 
     10.147247910773519`}}], 
   Line3DBox[{{39, 26, 10}, {38.91137880206625, 24.708809143774264`, 
     10.122361987871376`}}], 
   Line3DBox[{{50, 26, 10}, {50.06837427146752, 24.706340401311408`, 
     10.108488717026969`}}], 
   Line3DBox[{{33, 27, 10}, {32.9874000630169, 25.70400859029106, 
     10.1012299735684}}], 
   Line3DBox[{{44, 27, 10}, {43.95587719242186, 25.703387789808172`, 
     10.08276445029651}}], 
   Line3DBox[{{55, 27, 10}, {55.10458212753511, 25.705474347201957`, 
     10.057148165745133`}}], 
   Line3DBox[{{38, 1, 11}, {38.149672882053906`, 2.2913484477590575`, 
     10.995850922036263`}}], 
   Line3DBox[{{49, 1, 11}, {48.91913541560132, -0.29570177764491046`, 
     11.06795456127331}}], 
   Line3DBox[{{32, 2, 11}, {31.964063318534027`, 0.701485171133944, 
     10.949326593363267`}}], 
   Line3DBox[{{43, 2, 11}, {42.73961789849938, 0.7284193463028665, 
     11.072689767927095`}}], 
   Line3DBox[{{54, 2, 11}, {54.055406912668566`, 0.7024369059812878, 
     11.057097207191996`}}], 
   Line3DBox[{{37, 3, 11}, {36.833073007483044`, 1.711118694662949, 
     11.030337434332928`}}], 
   Line3DBox[{{48, 3, 11}, {47.8499215039396, 1.7122052076403038`, 
     11.095189378564498`}}], 
   Line3DBox[{{31, 4, 11}, {30.935241646068263`, 2.7017114315882695`, 
     11.015910648241737`}}], 
   Line3DBox[{{42, 4, 11}, {41.70747077248603, 2.7345054468761716`, 
     11.054315624492423`}}], 
   Line3DBox[{{53, 4, 11}, {53.046222105663105`, 2.7062371496295303`, 
     11.11849558620196}}], 
   Line3DBox[{{36, 5, 11}, {35.81962209324978, 3.713556646259531, 
     11.050272342032013`}}], 
   Line3DBox[{{47, 5, 11}, {46.772112626439146`, 3.728349561861198, 
     11.144818880512627`}}], 
   Line3DBox[{{30, 6, 11}, {29.9335726912537, 4.7025580070455515`, 
     11.047240740585982`}}], 
   Line3DBox[{{41, 6, 11}, {40.75210941494196, 4.725470748599868, 
     11.064229628404696`}}], 
   Line3DBox[{{52, 6, 11}, {51.94879207955021, 4.7106632165483715`, 
     11.158077220755606`}}], 
   Line3DBox[{{35, 7, 11}, {34.843240514752395`, 5.710604875415763, 
     11.053727799911266`}}], 
   Line3DBox[{{46, 7, 11}, {45.77892182668472, 5.72647614189661, 
     11.138785532837673`}}], 
   Line3DBox[{{29, 8, 11}, {29.106773472899373`, 6.7044460291209065`, 
     10.98819601658672}}], 
   Line3DBox[{{40, 8, 11}, {39.79882193118701, 6.720782182021072, 
     11.114582541400972`}}], 
   Line3DBox[{{51, 8, 11}, {50.908034123208665`, 6.718021112988149, 
     11.195121528186556`}}], 
   Line3DBox[{{34, 9, 11}, {33.80330496179955, 7.724400597148973, 
     11.155425948262911`}}], 
   Line3DBox[{{45, 9, 11}, {44.81239468628393, 7.724409555159162, 
     11.16635282773746}}], 
   Line3DBox[{{28, 10, 11}, {28.03985478770544, 8.84042895837342, 
     10.413649767359129`}}], 
   Line3DBox[{{39, 10, 11}, {38.79471091446975, 8.728406281499902, 
     11.175800473359002`}}], 
   Line3DBox[{{50, 10, 11}, {49.91992412669088, 8.718427064315982, 
     11.20287598437476}}], 
   Line3DBox[{{36, 11, 11}, {35.84209498218558, 9.726500746529373, 
     11.2080039825551}}], 
   Line3DBox[{{47, 11, 11}, {46.89144192995262, 9.726694158274196, 
     11.238552675219816`}}], 
   Line3DBox[{{34, 12, 11}, {34.01740682102645, 10.704982777005949`, 
     11.112371681176919`}}], 
   Line3DBox[{{45, 12, 11}, {44.875548043910406`, 10.732055486407889`, 
     11.258511936043854`}}], 
   Line3DBox[{{32, 13, 11}, {32.827021392285545`, 13.040555323053962`, 
     12.002193036532418`}}], 
   Line3DBox[{{43, 13, 11}, {42.85295488109272, 11.728690784384693`, 
     11.22836508335807}}], 
   Line3DBox[{{54, 13, 11}, {53.99467362594924, 11.717175030080417`, 
     11.210551006386329`}}], 
   Line3DBox[{{41, 14, 11}, {40.86401127956887, 12.717523242391751`, 
     11.16358616723347}}], 
   Line3DBox[{{52, 14, 11}, {52.02583365624931, 12.713747423044303`, 
     11.186780433877908`}}], 
   Line3DBox[{{39, 15, 11}, {38.89483653365691, 13.717371255309748`, 
     11.183859045578435`}}], 
   Line3DBox[{{50, 15, 11}, {50.00444249409197, 13.717166597870394`, 
     11.210520133542667`}}], 
   Line3DBox[{{37, 16, 11}, {36.91964957002227, 14.72016975030781, 
     11.213490843773734`}}], 
   Line3DBox[{{48, 16, 11}, {47.933803085746185`, 14.721254265200134`, 
     11.22456026869067}}], 
   Line3DBox[{{34, 17, 11}, {34.09582395345416, 18.2905791433647, 
     10.876617486423497`}}], 
   Line3DBox[{{45, 17, 11}, {44.90954177630986, 15.721070954145805`, 
     11.214843676744987`}}], 
   Line3DBox[{{28, 18, 11}, {28.060194881350764`, 16.924889461569176`, 
     11.728363855785107`}}], 
   Line3DBox[{{39, 18, 11}, {38.895085825087286`, 16.720553254800368`, 
     11.204961074598202`}}], 
   Line3DBox[{{50, 18, 11}, {49.920157997062326`, 16.71719469276664, 
     11.195027685985409`}}], 
   Line3DBox[{{33, 19, 11}, {33.021856171034, 17.70515049572762, 
     11.11352122741277}}], 
   Line3DBox[{{44, 19, 11}, {43.90779252340922, 17.718338292781645`, 
     11.19708132714921}}], 
   Line3DBox[{{55, 19, 11}, {55.006785389155965`, 17.7171669311303, 
     11.210459677630546`}}], 
   Line3DBox[{{38, 20, 11}, {37.896574428048176`, 18.722433481266098`, 
     11.217087404693537`}}], 
   Line3DBox[{{49, 20, 11}, {48.88495998460728, 18.72441297615277, 
     11.222808302024431`}}], 
   Line3DBox[{{32, 21, 11}, {31.97736992231937, 19.70917999425639, 
     11.15255029451376}}], 
   Line3DBox[{{43, 21, 11}, {42.9161355783616, 19.723685480279624`, 
     11.232353191357898`}}], 
   Line3DBox[{{54, 21, 11}, {53.955999111989975`, 19.719093769649586`, 
     11.217584813127706`}}], 
   Line3DBox[{{37, 22, 11}, {36.94878826475309, 20.717005889541163`, 
     11.203232553251043`}}], 
   Line3DBox[{{48, 22, 11}, {47.94305945226227, 20.71834852970538, 
     11.210064948801477`}}], 
   Line3DBox[{{31, 23, 11}, {31.021662899368128`, 21.720186722752988`, 
     11.227175470007714`}}], 
   Line3DBox[{{42, 23, 11}, {41.91647404687584, 21.71906258391544, 
     11.20548175400583}}], 
   Line3DBox[{{53, 23, 11}, {52.967920671726105`, 21.71544864502261, 
     11.197227617546956`}}], 
   Line3DBox[{{36, 24, 11}, {35.96594651621997, 22.71290206199351, 
     11.179497237365622`}}], 
   Line3DBox[{{47, 24, 11}, {46.97635635803452, 22.71049284634912, 
     11.163132703275016`}}], 
   Line3DBox[{{30, 25, 11}, {30.008438854121, 23.712515137602654`, 
     11.179754039840036`}}], 
   Line3DBox[{{41, 25, 11}, {40.89114216538779, 23.718633227869404`, 
     11.190392140392287`}}], 
   Line3DBox[{{52, 25, 11}, {52.041625561558185`, 23.707790107482882`, 
     11.135870917807544`}}], 
   Line3DBox[{{35, 26, 11}, {34.94794002519254, 24.70847497846887, 
     11.138754739674239`}}], 
   Line3DBox[{{46, 26, 11}, {45.99623908830528, 24.704221290106386`, 
     11.104610661644315`}}], 
   Line3DBox[{{29, 27, 11}, {29.049693624987484`, 25.702214278294893`, 
     11.057295411456357`}}], 
   Line3DBox[{{40, 27, 11}, {39.92627614752587, 25.708519273960583`, 
     11.129005146583658`}}], 
   Line3DBox[{{51, 27, 11}, {51.0997971137599, 25.706005157474777`, 
     11.074952542340577`}}], 
   Line3DBox[{{34, 1, 12}, {33.971859744966615`, -0.2988735563675131, 
     11.953787332733706`}}], 
   Line3DBox[{{45, 1, 12}, {44.823564993711855`, -0.28555931459446726`, 
     12.078790463988392`}}], 
   Line3DBox[{{28, 2, 12}, {27.90819695991758, 0.7055476264951706, 
     12.077235060428142`}}], 
   Line3DBox[{{39, 2, 12}, {38.77014294360601, 0.7206230701704788, 
     12.018984336856464`}}], 
   Line3DBox[{{50, 2, 12}, {49.97582481822304, 0.7027394705201253, 
     12.080812618071974`}}], 
   Line3DBox[{{33, 3, 12}, {32.93344065064376, 1.7024163556734102`, 
     11.957028625930738`}}], 
   Line3DBox[{{44, 3, 12}, {43.69876554102197, 1.7377651839412003`, 
     12.077595553050568`}}], 
   Line3DBox[{{55, 3, 12}, {55.05982088506966, 1.7048545484567843`, 
     12.094972212022265`}}], 
   Line3DBox[{{38, 4, 12}, {37.7682083437046, 2.7218115273293453`, 
     12.050068517091015`}}], 
   Line3DBox[{{49, 4, 12}, {48.864867148141514`, 2.7136789774155634`, 
     12.130833249619208`}}], 
   Line3DBox[{{32, 5, 12}, {31.91553644852628, 3.7028648271376583`, 
     12.01750005130931}}], 
   Line3DBox[{{43, 5, 12}, {42.69868777911468, 3.7382202420384223`, 
     12.084396610972103`}}], 
   Line3DBox[{{54, 5, 12}, {54.059558287382565`, 3.712844993676889, 
     12.172292774373764`}}], 
   Line3DBox[{{37, 6, 12}, {36.79343200056766, 4.717080288317577, 
     12.038035180914678`}}], 
   Line3DBox[{{48, 6, 12}, {47.8270616793359, 4.720914199776195, 
     12.155022104590634`}}], 
   Line3DBox[{{31, 7, 12}, {31.076092017046076`, 8.29773533375037, 
     12.009644090297941`}}], 
   Line3DBox[{{42, 7, 12}, {41.7551403049305, 5.726333329068114, 
     12.088413466665203`}}], 
   Line3DBox[{{53, 7, 12}, {53.02483978170869, 5.710270684401793, 
     12.161187089220087`}}], 
   Line3DBox[{{36, 8, 12}, {35.82775173098049, 6.714039136542436, 
     12.081456684656667`}}], 
   Line3DBox[{{47, 8, 12}, {46.851339908419206`, 6.718450907353873, 
     12.159787672581702`}}], 
   Line3DBox[{{30, 9, 12}, {30.272713919591734`, 7.816063855263138, 
     11.537482623843676`}}], 
   Line3DBox[{{41, 9, 12}, {40.79551172325805, 7.723313764434478, 
     12.135117728639294`}}], 
   Line3DBox[{{52, 9, 12}, {51.963135711125396`, 7.7120728095264, 
     12.172871559964472`}}], 
   Line3DBox[{{38, 10, 12}, {37.815976542943844`, 8.72448167256148, 
     12.170846023136448`}}], 
   Line3DBox[{{49, 10, 12}, {48.91447462511763, 8.719885068407162, 
     12.209740726050743`}}], 
   Line3DBox[{{36, 11, 12}, {35.84020652185071, 9.726565995152907, 
     12.206958642342007`}}], 
   Line3DBox[{{47, 11, 12}, {46.908691075297966`, 9.72495384037025, 
     12.236474038920091`}}], 
   Line3DBox[{{35, 12, 12}, {34.911771854632995`, 10.717903617014125`, 
     12.196073096317763`}}], 
   Line3DBox[{{46, 12, 12}, {45.91259492939837, 10.72611221155642, 
     12.24407018680586}}], 
   Line3DBox[{{34, 13, 12}, {33.9962642495175, 11.719498990983212`, 
     12.224283771315093`}}], 
   Line3DBox[{{45, 13, 12}, {44.9045752044719, 11.731230248028456`, 
     12.26667850472149}}], 
   Line3DBox[{{33, 14, 12}, {32.088283300947, 13.353467446880305`, 
     12.6639038472734}}], 
   Line3DBox[{{44, 14, 12}, {43.87859087206465, 12.73075344224775, 
     12.253521200865022`}}], 
   Line3DBox[{{55, 14, 12}, {55.03087237057892, 12.717268174419466`, 
     12.20891615633471}}], 
   Line3DBox[{{43, 15, 12}, {42.857309180626096`, 13.725636784549863`, 
     12.213629878935484`}}], 
   Line3DBox[{{54, 15, 12}, {54.03021160325771, 13.715926351802358`, 
     12.200604399336093`}}], 
   Line3DBox[{{42, 16, 12}, {41.8685247863198, 14.71966851393328, 
     12.182935928603246`}}], 
   Line3DBox[{{53, 16, 12}, {53.03219335229101, 14.71739278909563, 
     12.209481098441788`}}], 
   Line3DBox[{{40, 17, 12}, {39.90632926573876, 15.71786223319666, 
     12.193257704838654`}}], 
   Line3DBox[{{51, 17, 12}, {50.98454399532186, 15.712761449448676`, 
     12.181047026746958`}}], 
   Line3DBox[{{37, 18, 12}, {36.877310629161954`, 16.721727743222175`, 
     12.202403942242961`}}], 
   Line3DBox[{{48, 18, 12}, {47.904865698901, 16.717024269646785`, 
     12.186876269437928`}}], 
   Line3DBox[{{31, 19, 12}, {31.619790945234605`, 18.1646625498373, 
     11.220211228241345`}}], 
   Line3DBox[{{42, 19, 12}, {41.90644788042209, 17.717493344371295`, 
     12.190852506377446`}}], 
   Line3DBox[{{53, 19, 12}, {53.00937568610948, 17.715267488640727`, 
     12.19843001478221}}], 
   Line3DBox[{{36, 20, 12}, {35.90770665862347, 18.725936791262864`, 
     12.241339759012028`}}], 
   Line3DBox[{{47, 20, 12}, {46.90387626890861, 18.718967689387483`, 
     12.199289857965292`}}], 
   Line3DBox[{{30, 21, 12}, {29.929316309778358`, 19.713580862114416`, 
     12.17357885129923}}], 
   Line3DBox[{{41, 21, 12}, {40.92776254939321, 19.7173665269326, 
     12.19908069845391}}], 
   Line3DBox[{{52, 21, 12}, {51.9756641970279, 19.718518002375113`, 
     12.21728243936645}}], 
   Line3DBox[{{35, 22, 12}, {34.96385510219933, 20.716762388119697`, 
     12.204926274105379`}}], 
   Line3DBox[{{46, 22, 12}, {45.96028123915536, 20.715356277909425`, 
     12.195225324510519`}}], 
   Line3DBox[{{29, 23, 12}, {28.98195501797569, 21.714977125020592`, 
     12.195935166326521`}}], 
   Line3DBox[{{40, 23, 12}, {39.93261062959507, 21.71323774123628, 
     12.172341411673807`}}], 
   Line3DBox[{{51, 23, 12}, {51.002726895933456`, 21.720318879219924`, 
     12.228929668583207`}}], 
   Line3DBox[{{34, 24, 12}, {33.97648888672543, 22.712870918004953`, 
     12.180958431235398`}}], 
   Line3DBox[{{45, 24, 12}, {44.982610571383276`, 22.708301198140262`, 
     12.145642758304344`}}], 
   Line3DBox[{{28, 25, 12}, {27.98440302970947, 23.70967696232956, 
     12.157553778040038`}}], 
   Line3DBox[{{39, 25, 12}, {38.91532231966813, 23.712669966987868`, 
     12.160034610502223`}}], 
   Line3DBox[{{50, 25, 12}, {50.05061933102307, 23.707529084381083`, 
     12.130217570265971`}}], 
   Line3DBox[{{33, 26, 12}, {32.968246019968234`, 24.707852182794593`, 
     12.13908883220246}}], 
   Line3DBox[{{44, 26, 12}, {43.95224174042614, 24.70478178165874, 
     12.10064251347898}}], 
   Line3DBox[{{55, 26, 12}, {55.05033774025276, 24.705600819456972`, 
     12.109530239275674`}}], 
   Line3DBox[{{38, 27, 12}, {37.957456840372174`, 25.705634630364436`, 
     12.113174067069608`}}], 
   Line3DBox[{{49, 27, 12}, {49.044241330079885`, 25.703703666285225`, 
     12.087512969955286`}}], 
   Line3DBox[{{32, 1, 13}, {31.91566666013877, -0.2940686372223711, 
     12.909037095773687`}}], 
   Line3DBox[{{43, 1, 13}, {42.79106987547704, -0.28138109098863273`, 
     13.066413121622176`}}], 
   Line3DBox[{{54, 1, 13}, {54.06260964051996, -0.2983884871262674, 
     13.016351434552492`}}], 
   Line3DBox[{{37, 2, 13}, {36.82182542171202, 0.7125713871703248, 
     12.972046708255384`}}], 
   Line3DBox[{{48, 2, 13}, {47.868636984765864`, 0.7104751391178075, 
     13.099344810611122`}}], 
   Line3DBox[{{31, 3, 13}, {31.076022953825895`, 4.297624139533458, 
     13.019801590634088`}}], 
   Line3DBox[{{42, 3, 13}, {41.71841824378277, 1.7329135918369651`, 
     13.072137014175253`}}], 
   Line3DBox[{{53, 3, 13}, {53.07418258927104, 1.7047163512307657`, 
     13.082080525583748`}}], 
   Line3DBox[{{36, 4, 13}, {35.798989734992254`, 2.7156353350436353`, 
     13.001510222844734`}}], 
   Line3DBox[{{47, 4, 13}, {46.76851453533446, 2.7258707646973312`, 
     13.114057754649199`}}], 
   Line3DBox[{{30, 5, 13}, {29.92177259316043, 3.7026305600141534`, 
     13.026702228558044`}}], 
   Line3DBox[{{41, 5, 13}, {40.76912191243577, 3.722894043188564, 
     13.07546975393779}}], 
   Line3DBox[{{52, 5, 13}, {51.960792085697136`, 3.7092275270509485`, 
     13.149563239243502`}}], 
   Line3DBox[{{35, 6, 13}, {34.81371802434312, 4.713802336460494, 
     13.031537213746367`}}], 
   Line3DBox[{{46, 6, 13}, {45.78010698252411, 4.724063890032813, 
     13.116765166668623`}}], 
   Line3DBox[{{29, 7, 13}, {28.955261208572193`, 5.700837121314592, 
     12.986799424731348`}}], 
   Line3DBox[{{40, 7, 13}, {39.78314739385027, 5.722085729934014, 
     13.099549312241669`}}], 
   Line3DBox[{{51, 7, 13}, {50.90460809729554, 5.71289765903949, 
     13.155781734463313`}}], 
   Line3DBox[{{34, 8, 13}, {33.83661140675064, 6.713583494543269, 
     13.091851739692231`}}], 
   Line3DBox[{{45, 8, 13}, {44.80913832697735, 6.719374205202402, 
     13.116487748154107`}}], 
   Line3DBox[{{28, 9, 13}, {27.974136517071408`, 7.711492806340875, 
     12.829470553453406`}}], 
   Line3DBox[{{39, 9, 13}, {38.793316834959825`, 7.725112420353822, 
     13.14813415727943}}], 
   Line3DBox[{{50, 9, 13}, {49.91866733769654, 7.715494088501399, 
     13.182837527241482`}}], 
   Line3DBox[{{36, 10, 13}, {35.80864238577853, 8.732434008630634, 
     13.216006298526834`}}], 
   Line3DBox[{{47, 10, 13}, {46.908750813171885`, 8.720510394350237, 
     13.211139610062684`}}], 
   Line3DBox[{{34, 11, 13}, {33.74815380501359, 9.760749776234857, 
     13.301384102050699`}}], 
   Line3DBox[{{45, 11, 13}, {44.900841609252936`, 9.723078083305563, 
     13.222795942983382`}}], 
   Line3DBox[{{33, 12, 13}, {33.79452832047365, 11.001501612001636`, 
     12.751553391792148`}}], 
   Line3DBox[{{44, 12, 13}, {43.886203925587274`, 10.73362987622648, 
     13.27084527513341}}], 
   Line3DBox[{{55, 12, 13}, {54.9784281502776, 10.715613165043854`, 
     13.199712577197545`}}], 
   Line3DBox[{{43, 13, 13}, {42.88095990404268, 11.732253757393854`, 
     13.262009388977711`}}], 
   Line3DBox[{{54, 13, 13}, {54.027542418064854`, 11.71294692729018, 
     13.180930382289297`}}], 
   Line3DBox[{{42, 14, 13}, {41.85529691947693, 12.725220303273463`, 
     13.209756390369712`}}], 
   Line3DBox[{{53, 14, 13}, {53.0592659490451, 12.714630989193884`, 
     13.1852405283492}}], 
   Line3DBox[{{41, 15, 13}, {40.87710552640672, 13.719538236694007`, 
     13.187921848308115`}}], 
   Line3DBox[{{52, 15, 13}, {52.05837065054359, 13.713129962440537`, 
     13.174809535171343`}}], 
   Line3DBox[{{40, 16, 13}, {39.89759801896245, 14.71965833927869, 
     13.200596774901749`}}], 
   Line3DBox[{{51, 16, 13}, {51.0318017360846, 14.711176259289019`, 
     13.167098817954399`}}], 
   Line3DBox[{{38, 17, 13}, {37.886368463671, 15.719920299094483`, 
     13.196172967763529`}}], 
   Line3DBox[{{49, 17, 13}, {48.9575404211744, 15.710893447236664`, 
     13.162485321763484`}}], 
   Line3DBox[{{35, 18, 13}, {34.92915718371604, 16.720641122730022`, 
     13.219595442874992`}}], 
   Line3DBox[{{46, 18, 13}, {45.86979079906083, 16.719796146799833`, 
     13.18472590030157}}], 
   Line3DBox[{{29, 19, 13}, {28.688750211689417`, 17.763358838600578`, 
     13.252670154963546`}}], 
   Line3DBox[{{40, 19, 13}, {39.89006774069903, 17.717791618408302`, 
     13.18400153407236}}], 
   Line3DBox[{{51, 19, 13}, {50.9772051091889, 17.71087573356017, 
     13.166249868056731`}}], 
   Line3DBox[{{34, 20, 13}, {33.949500646763006`, 18.722311914243097`, 
     13.234441828259182`}}], 
   Line3DBox[{{45, 20, 13}, {44.91426422515245, 18.71657295282673, 
     13.188319917946542`}}], 
   Line3DBox[{{28, 21, 13}, {27.997810025983398`, 19.708047575815577`, 
     13.144409617608403`}}], 
   Line3DBox[{{39, 21, 13}, {38.89921430650034, 19.717626959481457`, 
     13.188046879625844`}}], 
   Line3DBox[{{50, 21, 13}, {49.94871630740269, 19.713344713295857`, 
     13.178572551277808`}}], 
   Line3DBox[{{33, 22, 13}, {32.935806195672384`, 20.72026534596678, 
     13.219450155507865`}}], 
   Line3DBox[{{44, 22, 13}, {43.96445804875551, 20.71683011586879, 
     13.205455148780539`}}], 
   Line3DBox[{{55, 22, 13}, {54.99644717245795, 20.71857989099067, 
     13.218974614151907`}}], 
   Line3DBox[{{38, 23, 13}, {37.945405428501005`, 21.718147048799466`, 
     13.209457499892757`}}], 
   Line3DBox[{{49, 23, 13}, {48.98918824027068, 21.713469327931833`, 
     13.186338229248292`}}], 
   Line3DBox[{{32, 24, 13}, {31.953818116517667`, 22.71807019585751, 
     13.211005239008953`}}], 
   Line3DBox[{{43, 24, 13}, {42.95879816700903, 22.706167277713817`, 
     13.11957966256732}}], 
   Line3DBox[{{54, 24, 13}, {54.01063645136214, 22.713041734894112`, 
     13.183371998347798`}}], 
   Line3DBox[{{37, 25, 13}, {36.96415807244135, 23.7158415317235, 
     13.199129065137729`}}], 
   Line3DBox[{{48, 25, 13}, {48.00960049133929, 23.706386125929193`, 
     13.128339297869193`}}], 
   Line3DBox[{{31, 26, 13}, {30.948663959748416`, 24.71029505772706, 
     13.155002493038142`}}], 
   Line3DBox[{{42, 26, 13}, {41.93336285214427, 24.708234638755194`, 
     13.130006699880152`}}], 
   Line3DBox[{{53, 26, 13}, {53.06099474098067, 24.704445690353204`, 
     13.088423256716293`}}], 
   Line3DBox[{{36, 27, 13}, {35.99083365281, 25.70656344166704, 
     13.130145486464121`}}], 
   Line3DBox[{{47, 27, 13}, {47.045926896079905`, 25.70266929221616, 
     13.069453256637455`}}], 
   Line3DBox[{{30, 1, 14}, {29.899341067807136`, -0.29606144531261935`, 
     13.990381822212303`}}], 
   Line3DBox[{{41, 1, 14}, {40.75172498909685, -0.2757711384794441, 
     14.027704172680378`}}], 
   Line3DBox[{{52, 1, 14}, {52.07598620807859, -0.29693227767261, 
     14.046826950709749`}}], 
   Line3DBox[{{35, 2, 14}, {34.88679911549596, 0.7059946436043252, 
     13.94769610562486}}], 
   Line3DBox[{{46, 2, 14}, {45.81898575070383, 0.7150094512190261, 
     14.077673232811023`}}], 
   Line3DBox[{{29, 3, 14}, {28.86493281000698, 1.7078544906743296`, 
     14.046009096023433`}}], 
   Line3DBox[{{40, 3, 14}, {39.74874498273052, 1.7261080967479563`, 
     14.063799178096598`}}], 
   Line3DBox[{{51, 3, 14}, {51.00654277317808, 1.7034909719385656`, 
     14.09498174705876}}], 
   Line3DBox[{{34, 4, 14}, {33.82926272963971, 2.711643939617709, 
     13.968576343526898`}}], 
   Line3DBox[{{45, 4, 14}, {45.25848620319382, 5.272014283151428, 
     13.92813522269426}}], 
   Line3DBox[{{28, 5, 14}, {27.83079386743895, 3.711544535911018, 
     14.035380810660273`}}], 
   Line3DBox[{{39, 5, 14}, {38.78123173447059, 3.720777109101266, 
     14.075691752509362`}}], 
   Line3DBox[{{50, 5, 14}, {49.874003192318376`, 3.717018006404517, 
     14.167576873594777`}}], 
   Line3DBox[{{33, 6, 14}, {32.84364567118114, 4.709558891624183, 
     14.017750202066356`}}], 
   Line3DBox[{{44, 6, 14}, {43.75313044158204, 4.728341299841617, 
     14.109268346001992`}}], 
   Line3DBox[{{55, 6, 14}, {55.01799089619878, 4.718252444727688, 
     14.216331995339146`}}], 
   Line3DBox[{{38, 7, 14}, {37.80182697099887, 5.718436861714451, 
     14.091232522513701`}}], 
   Line3DBox[{{49, 7, 14}, {48.861977993605585`, 5.716969554924765, 
     14.157425546722585`}}], 
   Line3DBox[{{32, 8, 14}, {31.932301121493218`, 6.706316381823658, 
     13.89137422998619}}], 
   Line3DBox[{{43, 8, 14}, {42.79199587576116, 6.725271293561827, 
     14.14765164842322}}], 
   Line3DBox[{{54, 8, 14}, {54.005471149795355`, 6.716172337119828, 
     14.204344313704963`}}], 
   Line3DBox[{{37, 9, 14}, {36.811526407144015`, 7.722002086029723, 
     14.145598889705854`}}], 
   Line3DBox[{{48, 9, 14}, {47.922954168832355`, 7.7152107972577, 
     14.182703706630411`}}], 
   Line3DBox[{{34, 10, 14}, {33.70471220376568, 8.750137844479498, 
     14.20161773134504}}], 
   Line3DBox[{{45, 10, 14}, {44.875502549793495`, 8.721723338885086, 
     14.201268881203694`}}], 
   Line3DBox[{{32, 11, 14}, {32.920696660690815`, 10.372500425204787`, 
     14.669747670861655`}}], 
   Line3DBox[{{43, 11, 14}, {42.861648509589465`, 9.73042941275244, 
     14.243000800609927`}}], 
   Line3DBox[{{54, 11, 14}, {53.99675311514537, 9.71422814382094, 
     14.191781624762635`}}], 
   Line3DBox[{{42, 12, 14}, {41.85487245537982, 10.728765795737736`, 
     14.230003464552611`}}], 
   Line3DBox[{{53, 12, 14}, {52.998990992878035`, 10.713842796074902`, 
     14.189205255466653`}}], 
   Line3DBox[{{41, 13, 14}, {40.854803131587296`, 11.725071848510167`, 
     14.208509179514621`}}], 
   Line3DBox[{{52, 13, 14}, {52.02987500272958, 11.71237989694016, 
     14.176470831607029`}}], 
   Line3DBox[{{40, 14, 14}, {39.855430809343325`, 12.721564613087482`, 
     14.186286635598789`}}], 
   Line3DBox[{{51, 14, 14}, {51.04545526919541, 12.712756460687823`, 
     14.175891696795025`}}], 
   Line3DBox[{{39, 15, 14}, {38.90496912212191, 13.718080958452727`, 
     14.194043044627323`}}], 
   Line3DBox[{{50, 15, 14}, {50.02931240389537, 13.7098423710604, 
     14.156952462442696`}}], 
   Line3DBox[{{38, 16, 14}, {37.90514359928101, 14.7180519306736, 
     14.193936615400375`}}], 
   Line3DBox[{{49, 16, 14}, {48.98096242318251, 14.71114458757496, 
     14.1687877262469}}], 
   Line3DBox[{{36, 17, 14}, {35.905620469925346`, 15.71688101296687, 
     14.186274446497533`}}], 
   Line3DBox[{{47, 17, 14}, {46.90583320326782, 15.720067640164835`, 
     14.20713707693212}}], 
   Line3DBox[{{33, 18, 14}, {32.78449960142916, 16.748856058159458`, 
     14.279639795114223`}}], 
   Line3DBox[{{44, 18, 14}, {43.8652463768936, 16.71771271302149, 
     14.166074605864331`}}], 
   Line3DBox[{{55, 18, 14}, {55.069866399763725`, 16.720465949807632`, 
     14.21888650159929}}], 
   Line3DBox[{{38, 19, 14}, {37.855980077598694`, 17.722081195817086`, 
     14.190215119975333`}}], 
   Line3DBox[{{49, 19, 14}, {48.92869783803454, 17.709201951503378`, 
     14.13695400576969}}], 
   Line3DBox[{{32, 20, 14}, {31.824886908329972`, 18.720383815219385`, 
     14.148046697947864`}}], 
   Line3DBox[{{43, 20, 14}, {42.935616789901474`, 18.714120941151606`, 
     14.179916225706792`}}], 
   Line3DBox[{{54, 20, 14}, {54.030099380716685`, 18.71721472692123, 
     14.208700671902854`}}], 
   Line3DBox[{{37, 21, 14}, {36.92177159937432, 19.724744804039204`, 
     14.240009380046986`}}], 
   Line3DBox[{{48, 21, 14}, {47.93598541114319, 19.71262281136833, 
     14.169003273945533`}}], 
   Line3DBox[{{31, 22, 14}, {30.909620908718907`, 20.72295898705769, 
     14.2258270823495}}], 
   Line3DBox[{{42, 22, 14}, {41.94371471123124, 20.71362663550418, 
     14.179096435988878`}}], 
   Line3DBox[{{53, 22, 14}, {53.045631061893246`, 20.718742819505177`, 
     14.215169337083491`}}], 
   Line3DBox[{{36, 23, 14}, {35.96245495083099, 21.722435392820675`, 
     14.237526932716339`}}], 
   Line3DBox[{{47, 23, 14}, {46.98231208150776, 21.711432316164156`, 
     14.171115346223951`}}], 
   Line3DBox[{{30, 24, 14}, {29.92284451341392, 22.719560230035455`, 
     14.211000062518492`}}], 
   Line3DBox[{{41, 24, 14}, {40.91232237017324, 22.71419730143254, 
     14.170364472777056`}}], 
   Line3DBox[{{52, 24, 14}, {52.01050093492934, 22.716564224345923`, 
     14.206597047744706`}}], 
   Line3DBox[{{35, 25, 14}, {34.97339053352599, 23.718052690853714`, 
     14.214249930843776`}}], 
   Line3DBox[{{46, 25, 14}, {45.99475406312883, 23.70769641613193, 
     14.14115214227239}}], 
   Line3DBox[{{29, 26, 14}, {28.954349856380762`, 24.7112123687838, 
     14.164141725382933`}}], 
   Line3DBox[{{40, 26, 14}, {39.91276649666978, 24.71832929684921, 
     14.19927499738225}}], 
   Line3DBox[{{51, 26, 14}, {51.04081145214673, 24.704728650477932`, 
     14.102988137573991`}}], 
   Line3DBox[{{34, 27, 14}, {34.00734200414184, 25.706336964528244`, 
     14.12799236551131}}], 
   Line3DBox[{{45, 27, 14}, {45.01008795095421, 25.70041258077894, 
     14.031157231069171`}}], 
   Line3DBox[{{28, 1, 15}, {27.923581773214114`, -0.2944326176511429, 
     15.092760190683883`}}], 
   Line3DBox[{{39, 1, 15}, {38.80545605496847, -0.2840709876119154, 
     15.057570411019272`}}], 
   Line3DBox[{{50, 1, 15}, {50.038419481798634`, -0.2991652544361827, 
     15.02633600357104}}], 
   Line3DBox[{{33, 2, 15}, {32.878910178512996`, 0.7081414762003673, 
     14.91975780649509}}], 
   Line3DBox[{{44, 2, 15}, {43.802447497444504`, 0.7168716097451113, 
     15.067487353303852`}}], 
   Line3DBox[{{55, 2, 15}, {55.04262902646471, 0.701821788175748, 
     15.054000893024643`}}], 
   Line3DBox[{{38, 3, 15}, {37.751325325808885`, 1.7245708452199418`, 
     15.037965478437252`}}], 
   Line3DBox[{{49, 3, 15}, {48.864907385711035`, 1.7133484251882247`, 
     15.127584131454311`}}], 
   Line3DBox[{{32, 4, 15}, {31.84082732042221, 2.7099652431764336`, 
     14.97821963583435}}], 
   Line3DBox[{{43, 4, 15}, {42.73216908399905, 2.729992339542373, 
     15.073124160255247`}}], 
   Line3DBox[{{54, 4, 15}, {54.080855379147415`, 2.7094706775308177`, 
     15.13415094300884}}], 
   Line3DBox[{{37, 5, 15}, {36.75955680700293, 3.723607541598716, 
     15.054857661978087`}}], 
   Line3DBox[{{48, 5, 15}, {47.78110899591422, 3.726896010599201, 
     15.145921076277851`}}], 
   Line3DBox[{{31, 6, 15}, {30.877566618561517`, 4.706214445442551, 
     14.96639931655433}}], 
   Line3DBox[{{42, 6, 15}, {41.7811588171592, 4.724451583831987, 
     15.122820090799978`}}], 
   Line3DBox[{{53, 6, 15}, {52.99221541300044, 4.712709089013492, 
     15.181167079506107`}}], 
   Line3DBox[{{36, 7, 15}, {35.786898709348385`, 5.718774452111289, 
     15.055217165445962`}}], 
   Line3DBox[{{47, 7, 15}, {46.82443161577691, 5.720917194455978, 
     15.152062220893045`}}], 
   Line3DBox[{{30, 8, 15}, {29.88944695723914, 9.29527418765388, 
     14.993457559026}}], 
   Line3DBox[{{41, 8, 15}, {40.79630250435869, 6.725762547904137, 
     15.157563466405458`}}], 
   Line3DBox[{{52, 8, 15}, {51.95965222871418, 6.712458394903178, 
     15.174953343771895`}}], 
   Line3DBox[{{35, 9, 15}, {34.780289602644515`, 7.723741069238413, 
     15.11353626268812}}], 
   Line3DBox[{{46, 9, 15}, {45.87490396676073, 7.715843564279575, 
     15.159038457819527`}}], 
   Line3DBox[{{32, 10, 15}, {31.070137270012896`, 9.134486403696648, 
     14.723881333490528`}}], 
   Line3DBox[{{43, 10, 15}, {42.829158654703996`, 8.732069820467398, 
     15.230578174526293`}}], 
   Line3DBox[{{54, 10, 15}, {54.00440693390646, 8.712636765584184, 
     15.180766373001159`}}], 
   Line3DBox[{{41, 11, 15}, {40.8108410360454, 9.73117125009622, 
     15.210457809960191`}}], 
   Line3DBox[{{52, 11, 15}, {51.94897681857497, 9.715318041363995, 
     15.192324985668595`}}], 
   Line3DBox[{{40, 12, 15}, {39.8203745152162, 10.727325387099098`, 
     15.195023113742252`}}], 
   Line3DBox[{{51, 12, 15}, {50.97763002357662, 10.718528233214103`, 
     15.217553890071976`}}], 
   Line3DBox[{{39, 13, 15}, {38.852072425669874`, 11.723435963482775`, 
     15.19621848389908}}], 
   Line3DBox[{{50, 13, 15}, {49.97473148867045, 11.716668849347675`, 
     15.205967619058354`}}], 
   Line3DBox[{{38, 14, 15}, {37.876398273642884`, 12.720525129676044`, 
     15.19407902888009}}], 
   Line3DBox[{{49, 14, 15}, {48.983546091205945`, 12.714830691483, 
     15.19511308857002}}], 
   Line3DBox[{{37, 15, 15}, {36.87106047837806, 13.72342169289791, 
     15.209099080821193`}}], 
   Line3DBox[{{48, 15, 15}, {47.9661264796974, 13.717438664043405`, 
     15.209497026545828`}}], 
   Line3DBox[{{36, 16, 15}, {35.864682315669924`, 14.719764421119216`, 
     15.180792662670052`}}], 
   Line3DBox[{{47, 16, 15}, {46.92405352850651, 14.719329585187317`, 
     15.210036716055075`}}], 
   Line3DBox[{{34, 17, 15}, {33.99034141426275, 15.702143691244608`, 
     15.073998064470514`}}], 
   Line3DBox[{{45, 17, 15}, {44.85600183610372, 15.72160315670915, 
     15.186992085015634`}}], 
   Line3DBox[{{31, 18, 15}, {30.024090385745417`, 17.395931125122843`, 
     14.389507396269112`}}], 
   Line3DBox[{{42, 18, 15}, {41.909390777444784`, 16.711527635879865`, 
     15.147067792825666`}}], 
   Line3DBox[{{53, 18, 15}, {53.04828595496116, 16.711156829275527`, 
     15.162947070640676`}}], 
   Line3DBox[{{36, 19, 15}, {35.917073805597774`, 17.720032486684737`, 
     15.211675249236908`}}], 
   Line3DBox[{{47, 19, 15}, {46.8871591569074, 17.719269786976824`, 
     15.192346212803285`}}], 
   Line3DBox[{{30, 20, 15}, {30.329686965372364`, 21.25742996450664, 
     14.986718839493742`}}], 
   Line3DBox[{{41, 20, 15}, {40.91252808964223, 18.712280574360776`, 
     15.15532979665779}}], 
   Line3DBox[{{52, 20, 15}, {52.02302642014058, 18.713354217734288`, 
     15.184424550842255`}}], 
   Line3DBox[{{35, 21, 15}, {34.939905338289215`, 19.72872718910507, 
     15.265054846990516`}}], 
   Line3DBox[{{46, 21, 15}, {45.941979197692746`, 19.71856909440123, 
     15.211112341363389`}}], 
   Line3DBox[{{29, 22, 15}, {28.90527090690377, 20.717371238598005`, 
     15.189446191161363`}}], 
   Line3DBox[{{40, 22, 15}, {39.93196422400678, 20.711448837611744`, 
     15.158136128360594`}}], 
   Line3DBox[{{51, 22, 15}, {51.02032015992988, 20.71596643155064, 
     15.202101178115397`}}], 
   Line3DBox[{{34, 23, 15}, {33.93067808453613, 21.722174297487367`, 
     15.228814217291045`}}], 
   Line3DBox[{{45, 23, 15}, {44.975628730997904`, 21.716095976300206`, 
     15.202475922456742`}}], 
   Line3DBox[{{28, 24, 15}, {27.942413560581368`, 22.714124061118525`, 
     15.182227527560384`}}], 
   Line3DBox[{{39, 24, 15}, {38.95489029149094, 22.715046855205422`, 
     15.191990963018455`}}], 
   Line3DBox[{{50, 24, 15}, {50.03972164928492, 22.71389699128156, 
     15.185367854665943`}}], 
   Line3DBox[{{33, 25, 15}, {32.95339238352568, 23.717899586981464`, 
     15.209872011055037`}}], 
   Line3DBox[{{44, 25, 15}, {43.9533433243412, 23.70592538098377, 
     15.114865290816988`}}], 
   Line3DBox[{{55, 25, 15}, {54.959623969998205`, 23.715386564844202`, 
     15.195289780630002`}}], 
   Line3DBox[{{38, 26, 15}, {37.971419152285165`, 24.716876955844892`, 
     15.206829370984954`}}], 
   Line3DBox[{{49, 26, 15}, {49.046603869769456`, 24.7061763474158, 
     15.117679375152083`}}], 
   Line3DBox[{{32, 27, 15}, {31.963113511768416`, 25.708656556207018`, 
     15.14516024648236}}], 
   Line3DBox[{{43, 27, 15}, {42.97193865820493, 25.703698205685342`, 
     15.09388407294774}}], 
   Line3DBox[{{54, 27, 15}, {53.99570880844225, 25.701991446467627`, 
     15.071800979323516`}}], 
   Line3DBox[{{37, 1, 16}, {36.86443767338786, -0.29269064592679506`, 
     16.023953069466568`}}], 
   Line3DBox[{{48, 1, 16}, {47.9246898021763, -0.2972292385050932, 
     16.039047110920688`}}], 
   Line3DBox[{{31, 2, 16}, {31.138139711622525`, 3.292141984783942, 
     16.035867969435973`}}], 
   Line3DBox[{{42, 2, 16}, {41.769443345218036`, 0.7235403303478765, 
     16.086569860155503`}}], 
   Line3DBox[{{53, 2, 16}, {53.07202871337625, 0.7023613121876746, 
     16.03075224125278}}], 
   Line3DBox[{{36, 3, 16}, {35.78391411920271, 1.7181679827056686`, 
     15.985385912303343`}}], 
   Line3DBox[{{47, 3, 16}, {46.79228161801701, 1.7202277644853314`, 
     16.095058397799228`}}], 
   Line3DBox[{{30, 4, 16}, {29.82092684152723, 2.712407569646051, 
     16.006207834549706`}}], 
   Line3DBox[{{41, 4, 16}, {40.759367663935, 2.7248198864979467`, 
     16.077535520690805`}}], 
   Line3DBox[{{52, 4, 16}, {51.99498074923004, 2.7056380766659283`, 
     16.120838812244372`}}], 
   Line3DBox[{{35, 5, 16}, {34.746241299911844`, 3.7250836578358264`, 
     15.986041396477706`}}], 
   Line3DBox[{{46, 5, 16}, {45.73252115329939, 3.732789354845187, 
     16.112393271035387`}}], 
   Line3DBox[{{29, 6, 16}, {28.82550587473298, 4.712079624506287, 
     16.028511517592563`}}], 
   Line3DBox[{{40, 6, 16}, {39.78904243497789, 4.722223028880524, 
     16.11306156657627}}], 
   Line3DBox[{{51, 6, 16}, {50.87880818078292, 4.714974946404606, 
     16.154994046940555`}}], 
   Line3DBox[{{34, 7, 16}, {34.2420724098841, 8.27725243627374, 
     16.005211756488897`}}], 
   Line3DBox[{{45, 7, 16}, {44.80710041938466, 5.720982746928055, 
     16.130017760874125`}}], 
   Line3DBox[{{28, 8, 16}, {27.935573180985326`, 6.722388791678423, 
     16.231427710879075`}}], 
   Line3DBox[{{39, 8, 16}, {38.79271409359702, 6.7241163847900065`, 
     16.13839636355545}}], 
   Line3DBox[{{50, 8, 16}, {49.87082823464076, 6.7150151257448805`, 
     16.148756606473565`}}], 
   Line3DBox[{{33, 9, 16}, {32.605708443518516`, 7.762557665596397, 
     15.94281051221449}}], 
   Line3DBox[{{44, 9, 16}, {43.83730768017193, 7.724170594257451, 
     16.189183869586117`}}], 
   Line3DBox[{{55, 9, 16}, {54.996761403331675`, 7.709313942724211, 
     16.1553029717858}}], 
   Line3DBox[{{41, 10, 16}, {40.78607118090707, 8.734866752738432, 
     16.208979250249655`}}], 
   Line3DBox[{{52, 10, 16}, {51.949557757845604`, 8.71628476637826, 
     16.198823487480524`}}], 
   Line3DBox[{{39, 11, 16}, {38.78509410881838, 9.730920143059258, 
     16.18235069136886}}], 
   Line3DBox[{{50, 11, 16}, {49.956453582290635`, 9.718691764137116, 
     16.215297269408197`}}], 
   Line3DBox[{{38, 12, 16}, {37.81308581655561, 10.727346919822056`, 
     16.188194648013454`}}], 
   Line3DBox[{{49, 12, 16}, {48.94878086601937, 10.718360657701968`, 
     16.21160623003149}}], 
   Line3DBox[{{37, 13, 16}, {36.842796495185226`, 11.72525878296851, 
     16.200803106736494`}}], 
   Line3DBox[{{48, 13, 16}, {47.938642647328294`, 11.718952616433452`, 
     16.212492061805662`}}], 
   Line3DBox[{{36, 14, 16}, {35.828825669016844`, 12.726169065834288`, 
     16.195074600025166`}}], 
   Line3DBox[{{47, 14, 16}, {46.95089680215033, 12.720630288056165`, 
     16.225393025894075`}}], 
   Line3DBox[{{35, 15, 16}, {34.806661370726026`, 13.722362575081123`, 
     16.142347409098733`}}], 
   Line3DBox[{{46, 15, 16}, {45.93896989764124, 13.720033502995019`, 
     16.219000212673134`}}], 
   Line3DBox[{{34, 16, 16}, {33.72926874023159, 14.729015037664784`, 
     15.96391938883613}}], 
   Line3DBox[{{45, 16, 16}, {44.89315413321012, 14.71887023344839, 
     16.193107436431998`}}], 
   Line3DBox[{{32, 17, 16}, {30.83910565029494, 17.202555081027544`, 
     15.451095866318358`}}], 
   Line3DBox[{{43, 17, 16}, {42.88417235399662, 15.715594561856552`, 
     16.163971420951498`}}], 
   Line3DBox[{{54, 17, 16}, {54.06739111150394, 15.716171565224288`, 
     16.192984424634755`}}], 
   Line3DBox[{{40, 18, 16}, {39.91482482877725, 16.710482473692934`, 
     16.141030987921393`}}], 
   Line3DBox[{{51, 18, 16}, {50.96412993974761, 16.70618340572335, 
     16.121457643447677`}}], 
   Line3DBox[{{34, 19, 16}, {33.99940071177226, 17.720468617550843`, 
     16.229780508706384`}}], 
   Line3DBox[{{45, 19, 16}, {44.89174031053538, 17.715998297850067`, 
     16.172103075257525`}}], 
   Line3DBox[{{28, 20, 16}, {27.927836741966566`, 18.702005969249747`, 
     15.998009943038175`}}], 
   Line3DBox[{{39, 20, 16}, {38.902639490790854`, 18.713188952886966`, 
     16.156965793325778`}}], 
   Line3DBox[{{50, 20, 16}, {49.939088917859976`, 18.70982007117826, 
     16.147396035693163`}}], 
   Line3DBox[{{33, 21, 16}, {32.978242144613944`, 19.728919562710374`, 
     16.271810812273195`}}], 
   Line3DBox[{{44, 21, 16}, {43.94320803835849, 19.718300130591935`, 
     16.2098097182026}}], 
   Line3DBox[{{55, 21, 16}, {55.01116183531755, 19.720079447661114`, 
     16.227329701387347`}}], 
   Line3DBox[{{38, 22, 16}, {37.94012869483485, 20.71876917818553, 
     16.21180889511641}}], 
   Line3DBox[{{49, 22, 16}, {48.95240552527426, 20.718204347937593`, 
     16.211505726469746`}}], 
   Line3DBox[{{32, 23, 16}, {31.946071854327883`, 21.727403044236663`, 
     16.25997835157231}}], 
   Line3DBox[{{43, 23, 16}, {42.91690441133118, 21.71337841885358, 
     16.16643326011369}}], 
   Line3DBox[{{54, 23, 16}, {53.98208832303664, 21.721638082111365`, 
     16.235520654551678`}}], 
   Line3DBox[{{37, 24, 16}, {36.980756015807195`, 22.72359755841415, 
     16.245817973683902`}}], 
   Line3DBox[{{48, 24, 16}, {48.02293290914328, 22.715191367211396`, 
     16.196826976784443`}}], 
   Line3DBox[{{31, 25, 16}, {30.920694626423874`, 23.71733787249328, 
     16.1961849239414}}], 
   Line3DBox[{{42, 25, 16}, {41.90733381790683, 23.713028142503926`, 
     16.158481597384004`}}], 
   Line3DBox[{{53, 25, 16}, {52.965874990965524`, 23.716522441242233`, 
     16.20376663103561}}], 
   Line3DBox[{{36, 26, 16}, {35.987467005219074`, 24.712736537904526`, 
     16.181095839808084`}}], 
   Line3DBox[{{47, 26, 16}, {47.01770094412863, 24.704708454176266`, 
     16.10911685431003}}], 
   Line3DBox[{{30, 27, 16}, {29.918615620406133`, 25.71127705000156, 
     16.150232289822906`}}], 
   Line3DBox[{{41, 27, 16}, {40.947804508227655`, 25.716489804571026`, 
     16.19969278622053}}], 
   Line3DBox[{{52, 27, 16}, {52.004859257425615`, 25.70264290214257, 
     16.08271002512524}}], 
   Line3DBox[{{35, 1, 17}, {34.908094037822536`, -0.29636288271427746`, 
     16.968431496124065`}}], 
   Line3DBox[{{46, 1, 17}, {45.87086529000626, -0.29168397725604, 
     17.069833584863243`}}], 
   Line3DBox[{{29, 2, 17}, {28.88231895310512, 0.7082676207871141, 
     17.087055336968746`}}], 
   Line3DBox[{{40, 2, 17}, {39.769293575373936`, 0.7226986811354854, 
     17.072635297639863`}}], 
   Line3DBox[{{51, 2, 17}, {51.00760831128628, 0.7009774466179004, 
     17.049824887395964`}}], 
   Line3DBox[{{34, 3, 17}, {33.80355879051415, 1.7168117666998197`, 
     16.93043845073821}}], 
   Line3DBox[{{45, 3, 17}, {44.77236516402923, 1.7237979504714454`, 
     17.097420276286186`}}], 
   Line3DBox[{{28, 4, 17}, {27.819037588553265`, 2.7174245675542457`, 
     17.11069266339722}}], 
   Line3DBox[{{39, 4, 17}, {38.73607873941391, 2.7292351705878755`, 
     17.074177601335077`}}], 
   Line3DBox[{{50, 4, 17}, {49.889848118911004`, 2.709767633581074, 
     17.114747565279508`}}], 
   Line3DBox[{{33, 5, 17}, {32.7713929952465, 3.7203876746930638`, 
     16.981802904072087`}}], 
   Line3DBox[{{44, 5, 17}, {43.765375360885244`, 3.727855250542887, 
     17.12883716524734}}], 
   Line3DBox[{{55, 5, 17}, {55.00714670034443, 3.714805581604583, 
     17.19551018285361}}], 
   Line3DBox[{{38, 6, 17}, {37.781987025799864`, 4.721939153748459, 
     17.095030607486255`}}], 
   Line3DBox[{{49, 6, 17}, {48.819207017732836`, 4.721258957334862, 
     17.14877917652219}}], 
   Line3DBox[{{32, 7, 17}, {31.7084357639663, 5.7335677806115335`, 
     16.966240113138674`}}], 
   Line3DBox[{{43, 7, 17}, {42.828988942519466`, 5.723113040700957, 
     17.174111778439702`}}], 
   Line3DBox[{{54, 7, 17}, {53.972644215514315`, 5.712455463905677, 
     17.17742809424898}}], 
   Line3DBox[{{37, 8, 17}, {36.76737620230148, 6.723844563264647, 
     17.085518828541545`}}], 
   Line3DBox[{{48, 8, 17}, {47.871311838832916`, 6.71645661450212, 
     17.161107835688018`}}], 
   Line3DBox[{{31, 9, 17}, {30.124361106592634`, 8.33799344441461, 
     16.30357782293045}}], 
   Line3DBox[{{42, 9, 17}, {41.817872912654416`, 7.730151464753971, 
     17.210509908528145`}}], 
   Line3DBox[{{53, 9, 17}, {52.97285695927868, 7.711654672171594, 
     17.1715504928676}}], 
   Line3DBox[{{36, 10, 17}, {35.771825097831844`, 8.726059381015801, 
     17.122521481066418`}}], 
   Line3DBox[{{47, 10, 17}, {46.9107955295074, 8.720191473213784, 
     17.210077836073758`}}], 
   Line3DBox[{{33, 11, 17}, {33.41199212844618, 11.847429115399462`, 
     17.895615084995597`}}], 
   Line3DBox[{{44, 11, 17}, {43.86893368299761, 9.7383206808996, 
     17.2845820027721}}], 
   Line3DBox[{{55, 11, 17}, {54.984880863853625`, 9.715080437553459, 
     17.196858146299252`}}], 
   Line3DBox[{{42, 12, 17}, {41.81855595110954, 10.737309694585772`, 
     17.25038220730547}}], 
   Line3DBox[{{53, 12, 17}, {52.944890556311194`, 10.721789105336732`, 
     17.230520840664006`}}], 
   Line3DBox[{{40, 13, 17}, {39.82676602936996, 11.72521985449438, 
     17.186883846397766`}}], 
   Line3DBox[{{51, 13, 17}, {50.96036975074843, 11.719717687408965`, 
     17.222050992816538`}}], 
   Line3DBox[{{38, 14, 17}, {37.834025524802506`, 12.724086182095533`, 
     17.185732072791332`}}], 
   Line3DBox[{{49, 14, 17}, {48.97140285280144, 12.716822698496685`, 
     17.206490232405258`}}], 
   Line3DBox[{{36, 15, 17}, {35.82094711180541, 13.725128956188875`, 
     17.180676187919463`}}], 
   Line3DBox[{{47, 15, 17}, {46.93313513865481, 13.719648294316517`, 
     17.215008372094406`}}], 
   Line3DBox[{{34, 16, 17}, {34.169994288024064`, 17.28883712892352, 
     17.00089283109732}}], 
   Line3DBox[{{45, 16, 17}, {44.89104618795152, 14.719262526774337`, 
     17.19452658305652}}], 
   Line3DBox[{{31, 17, 17}, {30.248950246226627`, 16.370402762597806`, 
     16.145873788007602`}}], 
   Line3DBox[{{42, 17, 17}, {41.87382007128552, 15.717020768980708`, 
     17.16746019933929}}], 
   Line3DBox[{{53, 17, 17}, {53.04163749186493, 15.714322656035918`, 
     17.187883172446767`}}], 
   Line3DBox[{{36, 18, 17}, {35.88926055236763, 16.714161630084565`, 
     17.1560655669624}}], 
   Line3DBox[{{47, 18, 17}, {46.87075277708261, 16.721770455960183`, 
     17.19855575567558}}], 
   Line3DBox[{{30, 19, 17}, {29.679588225853184`, 18.481032348615464`, 
     18.148045674964422`}}], 
   Line3DBox[{{41, 19, 17}, {40.90897886866782, 17.71176444141912, 
     17.14887679221028}}], 
   Line3DBox[{{52, 19, 17}, {51.99061363988568, 17.710665311903888`, 
     17.165915515597252`}}], 
   Line3DBox[{{35, 20, 17}, {34.93105492005136, 18.72132294761277, 
     17.224124009533067`}}], 
   Line3DBox[{{46, 20, 17}, {45.90746028360121, 18.721041502645324`, 
     17.213779238779395`}}], 
   Line3DBox[{{29, 21, 17}, {28.897643748744102`, 19.72207622120648, 
     17.215485529497755`}}], 
   Line3DBox[{{40, 21, 17}, {39.92599877583383, 19.711875080210213`, 
     17.158927687450817`}}], 
   Line3DBox[{{51, 21, 17}, {50.96428449325149, 19.714358025735795`, 
     17.189338629412305`}}], 
   Line3DBox[{{34, 22, 17}, {33.9385479550942, 20.725885961726306`, 
     17.250713110249137`}}], 
   Line3DBox[{{45, 22, 17}, {44.94687501261338, 20.720725658833093`, 
     17.22502198947469}}], 
   Line3DBox[{{28, 23, 17}, {27.96935866482252, 21.7171500572547, 
     17.208223756994524`}}], 
   Line3DBox[{{39, 23, 17}, {38.92677694601321, 21.716687748455218`, 
     17.194288572489253`}}], 
   Line3DBox[{{50, 23, 17}, {50.016394077969096`, 21.718245538778326`, 
     17.216417964471248`}}], 
   Line3DBox[{{33, 24, 17}, {32.96092039130866, 22.722109036362575`, 
     17.235515326971182`}}], 
   Line3DBox[{{44, 24, 17}, {43.937892109894854`, 22.713519163587076`, 
     17.1763793285195}}], 
   Line3DBox[{{55, 24, 17}, {54.94098384288638, 22.721469129503674`, 
     17.227762829248867`}}], 
   Line3DBox[{{38, 25, 17}, {37.981298892411424`, 23.718650020768294`, 
     17.21861495671127}}], 
   Line3DBox[{{49, 25, 17}, {49.02520057133992, 23.71407247298387, 
     17.189090788951543`}}], 
   Line3DBox[{{32, 26, 17}, {31.953141284562268`, 24.71078570619322, 
     17.160408121464627`}}], 
   Line3DBox[{{43, 26, 17}, {42.943691158791, 24.710628971016543`, 
     17.156050197115686`}}], 
   Line3DBox[{{54, 26, 17}, {53.903010181875054`, 24.71383551263708, 
     17.162400389859638`}}], 
   Line3DBox[{{37, 27, 17}, {36.995795042487494`, 25.7064149840139, 
     17.12891906278189}}], 
   Line3DBox[{{48, 27, 17}, {47.97757174756439, 25.701567768139135`, 
     17.05975544123757}}], 
   Line3DBox[{{31, 1, 18}, {30.924646996229875`, -0.29755197748378914`, 
     17.973908036664}}], 
   Line3DBox[{{42, 1, 18}, {41.83522146138756, -0.28641014404965004`, 
     18.089425804435336`}}], 
   Line3DBox[{{53, 1, 18}, {53.01329478396116, -0.2997135689499344, 
     17.97616961169326}}], 
   Line3DBox[{{36, 2, 18}, {35.8405629710193, 0.7099872280374211, 
     18.02113958285375}}], 
   Line3DBox[{{47, 2, 18}, {46.83646243614445, 0.7145304367534331, 
     18.10403589368517}}], 
   Line3DBox[{{30, 3, 18}, {29.84792082823694, 1.710160657687699, 
     18.05644817569446}}], 
   Line3DBox[{{41, 3, 18}, {40.79611412677115, 1.7182091369450885`, 
     18.07377488791354}}], 
   Line3DBox[{{52, 3, 18}, {51.977388888805216`, 1.7020550719052234`, 
     18.069481661491235`}}], 
   Line3DBox[{{35, 4, 18}, {35.246630467653276`, 5.276390160541974, 
     18.0012531946229}}], 
   Line3DBox[{{46, 4, 18}, {45.74779963447739, 2.7303881019629097`, 
     18.12033538130125}}], 
   Line3DBox[{{29, 5, 18}, {28.801549783165495`, 3.7180289357950986`, 
     18.084662281918767`}}], 
   Line3DBox[{{40, 5, 18}, {39.79115067911346, 3.719822089185593, 
     18.08675527550581}}], 
   Line3DBox[{{51, 5, 18}, {50.8853867857734, 3.7154465997348973`, 
     18.1636654300456}}], 
   Line3DBox[{{34, 6, 18}, {34.26688678756573, 7.2723093778783685`, 
     17.999461868413604`}}], 
   Line3DBox[{{45, 6, 18}, {44.77619761744523, 4.729112841052119, 
     18.1573477765467}}], 
   Line3DBox[{{28, 7, 18}, {27.778474304293503`, 5.727470314382617, 
     18.146950894397676`}}], 
   Line3DBox[{{39, 7, 18}, {38.80956257980349, 5.720090354664942, 
     18.12475932336777}}], 
   Line3DBox[{{50, 7, 18}, {49.862750754154156`, 5.718929637667937, 
     18.173266763313524`}}], 
   Line3DBox[{{33, 8, 18}, {32.66227784843814, 6.744666871415152, 
     17.990917895518805`}}], 
   Line3DBox[{{44, 8, 18}, {43.84224625641111, 6.721289577899544, 
     18.173243795835127`}}], 
   Line3DBox[{{55, 8, 18}, {54.97656951323777, 6.710141318699746, 
     18.160360826152935`}}], 
   Line3DBox[{{38, 9, 18}, {37.783909866014135`, 7.724021500260651, 
     18.123223058706113`}}], 
   Line3DBox[{{49, 9, 18}, {48.907770604737486`, 7.716294671236589, 
     18.1832876633981}}], 
   Line3DBox[{{32, 10, 18}, {31.319508710852688`, 8.932128039458235, 
     17.70575336657267}}], 
   Line3DBox[{{43, 10, 18}, {42.83269467714463, 8.737651243309259, 
     18.261695520453827`}}], 
   Line3DBox[{{54, 10, 18}, {53.96130863699286, 8.711542270334117, 
     18.16846262877234}}], 
   Line3DBox[{{37, 11, 18}, {36.77249769164792, 9.731277258896512, 
     18.169071895657815`}}], 
   Line3DBox[{{48, 11, 18}, {47.915366367399336`, 9.7190362348854, 
     18.204863321988693`}}], 
   Line3DBox[{{34, 12, 18}, {33.6600801811005, 10.75475284325673, 
     18.154317968306135`}}], 
   Line3DBox[{{45, 12, 18}, {44.885121914719946`, 10.730309516896508`, 
     18.254340524963695`}}], 
   Line3DBox[{{31, 13, 18}, {30.48987705798657, 13.687840892513462`, 
     18.978084602996002`}}], 
   Line3DBox[{{42, 13, 18}, {41.83070838850151, 11.736062168974575`, 
     18.252589607028852`}}], 
   Line3DBox[{{53, 13, 18}, {52.962965007520936`, 11.719846112713222`, 
     18.223236274374543`}}], 
   Line3DBox[{{39, 14, 18}, {38.83184132944511, 12.724871504872098`, 
     18.189129538756017`}}], 
   Line3DBox[{{50, 14, 18}, {49.969283207765706`, 12.715885060747894`, 
     18.20026308063244}}], 
   Line3DBox[{{36, 15, 18}, {35.80967393894909, 13.727144809336583`, 
     18.18334572284632}}], 
   Line3DBox[{{47, 15, 18}, {46.91874344743594, 13.71869118737871, 
     18.204071309508283`}}], 
   Line3DBox[{{33, 16, 18}, {33.91884315118225, 15.857332748692066`, 
     18.908500588293542`}}], 
   Line3DBox[{{44, 16, 18}, {43.878786693581354`, 14.719058670958553`, 
     18.185732727058518`}}], 
   Line3DBox[{{55, 16, 18}, {55.06993717443465, 14.71897994183259, 
     18.20999143364638}}], 
   Line3DBox[{{38, 17, 18}, {37.868073099458655`, 15.716668896200957`, 
     18.16017668661663}}], 
   Line3DBox[{{49, 17, 18}, {48.90456786340812, 15.714907268666803`, 
     18.17154993203173}}], 
   Line3DBox[{{32, 18, 18}, {33.232621822976654`, 17.749941534536546`, 
     17.671192753468276`}}], 
   Line3DBox[{{43, 18, 18}, {42.876522473998776`, 16.716400952650876`, 
     18.164702113577924`}}], 
   Line3DBox[{{54, 18, 18}, {54.00071577906279, 16.718141551991543`, 
     18.21642182637082}}], 
   Line3DBox[{{37, 19, 18}, {36.9158919789168, 17.714305360947257`, 
     18.17295992570681}}], 
   Line3DBox[{{48, 19, 18}, {47.87967887890929, 17.71899487730078, 
     18.18587281522006}}], 
   Line3DBox[{{31, 20, 18}, {30.94691073019423, 18.762287029177507`, 
     18.394015394736364`}}], 
   Line3DBox[{{42, 20, 18}, {41.91922588153171, 18.71761909627759, 
     18.19742026125443}}], 
   Line3DBox[{{53, 20, 18}, {52.93043796742265, 18.717223815641372`, 
     18.199113998669176`}}], 
   Line3DBox[{{36, 21, 18}, {35.938139758225766`, 19.723775618791713`, 
     18.23963438671684}}], 
   Line3DBox[{{47, 21, 18}, {46.8967267422628, 19.727033126559167`, 
     18.242672564082994`}}], 
   Line3DBox[{{30, 22, 18}, {29.971965983374915`, 20.727370697062256`, 
     18.263872604140822`}}], 
   Line3DBox[{{41, 22, 18}, {40.92097699843198, 20.712155478493695`, 
     18.1587824097606}}], 
   Line3DBox[{{52, 22, 18}, {51.95673093608864, 20.718238189517432`, 
     18.212636895426655`}}], 
   Line3DBox[{{35, 23, 18}, {34.95710142875462, 21.727412433522996`, 
     18.262069834649544`}}], 
   Line3DBox[{{46, 23, 18}, {45.99208584727257, 21.720775000266435`, 
     18.23134555591856}}], 
   Line3DBox[{{29, 24, 18}, {28.959856663726487`, 22.718076853952326`, 
     18.212277083501885`}}], 
   Line3DBox[{{40, 24, 18}, {39.93403042729372, 22.71317813250667, 
     18.17244563438351}}], 
   Line3DBox[{{51, 24, 18}, {50.998670982373476`, 22.715442684148975`, 
     18.199776715374323`}}], 
   Line3DBox[{{34, 25, 18}, {33.97397031104264, 23.7166978983316, 
     18.206053806434753`}}], 
   Line3DBox[{{45, 25, 18}, {44.9696704325265, 23.711190409208733`, 
     18.1674812109501}}], 
   Line3DBox[{{28, 26, 18}, {27.999151973668347`, 24.71129148803991, 
     18.170966815648402`}}], 
   Line3DBox[{{39, 26, 18}, {38.981692355319026`, 24.715098902055523`, 
     18.196707901842583`}}], 
   Line3DBox[{{50, 26, 18}, {49.99445429440047, 24.707165181328424`, 
     18.136188754234105`}}], 
   Line3DBox[{{33, 27, 18}, {32.986705135461946`, 25.705842440330485`, 
     18.122390593295222`}}], 
   Line3DBox[{{44, 27, 18}, {43.94282598161053, 25.706680113728034`, 
     18.11855295607729}}], 
   Line3DBox[{{55, 27, 18}, {54.89957770154176, 25.70899466907475, 
     18.114980857080457`}}], 
   Line3DBox[{{38, 1, 19}, {37.865268158538235`, -0.292601493597497, 
     19.032073503797385`}}], 
   Line3DBox[{{49, 1, 19}, {48.91416752643959, -0.29394948118110764`, 
     19.091255282771154`}}], 
   Line3DBox[{{32, 2, 19}, {31.87779814859392, 0.7059966565592515, 
     18.97505897602162}}], 
   Line3DBox[{{43, 2, 19}, {42.819346539763245`, 0.7171595100410786, 
     19.1080953496985}}], 
   Line3DBox[{{54, 2, 19}, {53.97575190638624, 0.7008822915064239, 
     19.041294181605863`}}], 
   Line3DBox[{{37, 3, 19}, {36.77225208053246, 1.7211295320853173`, 
     19.051197768251036`}}], 
   Line3DBox[{{48, 3, 19}, {47.81629073800558, 1.7202701689639348`, 
     19.13617072597981}}], 
   Line3DBox[{{31, 4, 19}, {30.789955779696086`, 2.718110281270131, 
     19.051382628694718`}}], 
   Line3DBox[{{42, 4, 19}, {41.80625357243412, 2.717923837157749, 
     19.093504194970865`}}], 
   Line3DBox[{{53, 4, 19}, {52.956653578276544`, 2.7077223687546654`, 
     19.13468337501978}}], 
   Line3DBox[{{36, 5, 19}, {35.75382325395615, 3.7239529342000983`, 
     19.033179746393287`}}], 
   Line3DBox[{{47, 5, 19}, {46.774756262248424`, 3.729239815357899, 
     19.156313184767228`}}], 
   Line3DBox[{{30, 6, 19}, {29.75693148629586, 4.7258265170494616`, 
     19.08602111944954}}], 
   Line3DBox[{{41, 6, 19}, {40.813860692314194`, 4.72302383386678, 
     19.157111518552753`}}], 
   Line3DBox[{{52, 6, 19}, {51.88832856569496, 4.7184429704167625`, 
     19.187459517459217`}}], 
   Line3DBox[{{35, 7, 19}, {34.72903021523558, 5.729129282977205, 
     19.03824913539795}}], 
   Line3DBox[{{46, 7, 19}, {45.81972035473442, 5.720117233971998, 
     19.139281566359045`}}], 
   Line3DBox[{{29, 8, 19}, {28.73163419041775, 6.743298892151126, 
     19.196677700257744`}}], 
   Line3DBox[{{40, 8, 19}, {39.83785680111472, 6.722306146114637, 
     19.17665785801605}}], 
   Line3DBox[{{51, 8, 19}, {50.90195931103991, 6.7189268356375385`, 
     19.198089805034435`}}], 
   Line3DBox[{{34, 9, 19}, {33.67090938491468, 7.743473368618175, 
     19.053293448856394`}}], 
   Line3DBox[{{45, 9, 19}, {44.870167056962174`, 7.7231409572355885`, 
     19.206819708473077`}}], 
   Line3DBox[{{28, 10, 19}, {27.87492685564178, 8.769268220496397, 
     19.399569762970426`}}], 
   Line3DBox[{{39, 10, 19}, {38.790111372297275`, 8.731486244597916, 
     19.191884382680733`}}], 
   Line3DBox[{{50, 10, 19}, {49.93721935221554, 8.717254841350396, 
     19.201552594190115`}}], 
   Line3DBox[{{33, 11, 19}, {32.59042756898181, 9.767554630313558, 
     19.05769605262322}}], 
   Line3DBox[{{44, 11, 19}, {43.855308861614354`, 9.736282974509644, 
     19.26848417822746}}], 
   Line3DBox[{{55, 11, 19}, {54.977101353107145`, 9.713915994764704, 
     19.188317772524044`}}], 
   Line3DBox[{{38, 12, 19}, {37.79283137071693, 10.729025025317643`, 
     19.178055532832193`}}], 
   Line3DBox[{{49, 12, 19}, {48.94976616594532, 10.717361090096135`, 
     19.20570364293515}}], 
   Line3DBox[{{32, 13, 19}, {31.334406536582865`, 11.934762678062922`, 
     19.335044458853908`}}], 
   Line3DBox[{{43, 13, 19}, {42.849923664264594`, 11.733836058295497`, 
     19.25358621054692}}], 
   Line3DBox[{{54, 13, 19}, {53.99291184712736, 11.717867844341807`, 
     19.214678581875624`}}], 
   Line3DBox[{{37, 14, 19}, {36.80683409159497, 12.727739799989962`, 
     19.18450180297353}}], 
   Line3DBox[{{48, 14, 19}, {47.96562510190945, 12.712818307806431`, 
     19.17883416246055}}], 
   Line3DBox[{{31, 15, 19}, {31.88216289740814, 14.695466570793615`, 
     18.094987285762087`}}], 
   Line3DBox[{{42, 15, 19}, {41.85918374555329, 13.726906495075314`, 
     19.22226945404661}}], 
   Line3DBox[{{53, 15, 19}, {53.04069600588233, 13.714165622650386`, 
     19.187012804725118`}}], 
   Line3DBox[{{36, 16, 19}, {35.81632463636751, 14.722158108515913`, 
     19.152916516971988`}}], 
   Line3DBox[{{47, 16, 19}, {46.883929647789216`, 14.718105693873726`, 
     19.182413434973153`}}], 
   Line3DBox[{{30, 17, 19}, {30.55432694786884, 16.027516685120833`, 
     19.661058119342048`}}], 
   Line3DBox[{{41, 17, 19}, {40.84108915508563, 15.721860310526921`, 
     19.176369718382336`}}], 
   Line3DBox[{{52, 17, 19}, {51.99656144834624, 15.712857918626913`, 
     19.18235525416363}}], 
   Line3DBox[{{35, 18, 19}, {34.86844402824318, 16.714149284892734`, 
     19.138855913641617`}}], 
   Line3DBox[{{46, 18, 19}, {45.89239288264588, 16.71748132999973, 
     19.183211815654655`}}], 
   Line3DBox[{{29, 19, 19}, {28.878677856496132`, 17.756118348713404`, 
     19.357825900527278`}}], 
   Line3DBox[{{40, 19, 19}, {39.91877292231375, 17.71527568228412, 
     19.18134384279599}}], 
   Line3DBox[{{51, 19, 19}, {50.94915585216323, 17.71612944409357, 
     19.19771511906597}}], 
   Line3DBox[{{34, 20, 19}, {33.92961489965307, 18.719951875685545`, 
     19.215691300446252`}}], 
   Line3DBox[{{45, 20, 19}, {44.93281341372561, 18.718886099320443`, 
     19.210316751853977`}}], 
   Line3DBox[{{28, 21, 19}, {27.959343123859664`, 19.723423013296046`, 
     19.242277145930778`}}], 
   Line3DBox[{{39, 21, 19}, {38.95317109385444, 19.71211786623906, 
     19.170782502290418`}}], 
   Line3DBox[{{50, 21, 19}, {49.96456288260542, 19.71611689948579, 
     19.200968641645368`}}], 
   Line3DBox[{{33, 22, 19}, {32.97281385440185, 20.725077777884792`, 
     19.252654390510713`}}], 
   Line3DBox[{{44, 22, 19}, {43.940486852237065`, 20.7212987431429, 
     19.226674394132676`}}], 
   Line3DBox[{{55, 22, 19}, {54.90293221959926, 20.73072863725573, 
     19.26368172808402}}], 
   Line3DBox[{{38, 23, 19}, {37.969172559404846`, 21.715494466375464`, 
     19.197725069210502`}}], 
   Line3DBox[{{49, 23, 19}, {48.99794124719329, 21.71824193722291, 
     19.21700698155313}}], 
   Line3DBox[{{32, 24, 19}, {32.0057880492846, 22.71546119256194, 
     19.19981629230641}}], 
   Line3DBox[{{43, 24, 19}, {42.9127259878699, 22.715268827224925`, 
     19.178463050816408`}}], 
   Line3DBox[{{54, 24, 19}, {53.895130833637026`, 22.717911859224916`, 
     19.187756377335695`}}], 
   Line3DBox[{{37, 25, 19}, {37.008327654235515`, 23.716458974900643`, 
     19.206041469277007`}}], 
   Line3DBox[{{48, 25, 19}, {47.97048056313926, 23.712712340982613`, 
     19.1789387766499}}], 
   Line3DBox[{{31, 26, 19}, {30.972595921454584`, 24.708001277164673`, 
     19.14138004339707}}], 
   Line3DBox[{{42, 26, 19}, {41.97544954192152, 24.71030231201836, 
     19.16148420549066}}], 
   Line3DBox[{{53, 26, 19}, {52.89084753263256, 24.711635250410424`, 
     19.134914828253194`}}], 
   Line3DBox[{{36, 27, 19}, {36.05650090986221, 25.706266867430863`, 
     19.11429010839784}}], 
   Line3DBox[{{47, 27, 19}, {46.89053671239815, 25.710199444037332`, 
     19.120134568321497`}}], 
   Line3DBox[{{30, 1, 20}, {29.91678088612287, -0.29659149334157076`, 
     20.043875716287953`}}], 
   Line3DBox[{{41, 1, 20}, {40.844489199989, -0.2873247515622255, 
     20.092797495091155`}}], 
   Line3DBox[{{52, 1, 20}, {51.95353593877534, -0.2990800287063604, 
     19.984762873276324`}}], 
   Line3DBox[{{35, 2, 20}, {34.880283502341406`, 0.7055488665203093, 
     20.008013939200158`}}], 
   Line3DBox[{{46, 2, 20}, {45.8138739769886, 0.7219323489552048, 
     20.147987103866516`}}], 
   Line3DBox[{{29, 3, 20}, {28.876504593523915`, 1.7101268702664356`, 
     20.104767331600296`}}], 
   Line3DBox[{{40, 3, 20}, {39.818448261633414`, 1.7163246710847428`, 
     20.096003209479566`}}], 
   Line3DBox[{{51, 3, 20}, {50.91329662743118, 1.7041505402573143`, 
     20.057067529031677`}}], 
   Line3DBox[{{34, 4, 20}, {33.756655494560384`, 2.723364584273346, 
     20.031392148457574`}}], 
   Line3DBox[{{45, 4, 20}, {44.75505907167485, 2.7373579641999504`, 
     20.18904769520394}}], 
   Line3DBox[{{28, 5, 20}, {27.865124818898632`, 3.7121630742879272`, 
     20.115259439072684`}}], 
   Line3DBox[{{39, 5, 20}, {38.76544728282621, 3.725578238012268, 
     20.10408744131007}}], 
   Line3DBox[{{50, 5, 20}, {49.85752766451135, 3.717274831068397, 
     20.155941574346937`}}], 
   Line3DBox[{{33, 6, 20}, {32.718539268354554`, 4.7333130444416875`, 
     20.079271767736223`}}], 
   Line3DBox[{{44, 6, 20}, {43.81153536467247, 4.730725787843202, 
     20.2083843938125}}], 
   Line3DBox[{{55, 6, 20}, {54.97267359864788, 4.714398077359967, 
     20.19099990652719}}], 
   Line3DBox[{{38, 7, 20}, {37.78682009216747, 5.7213322471258445`, 
     20.097791127697096`}}], 
   Line3DBox[{{49, 7, 20}, {48.850525384966666`, 5.717897951368254, 
     20.154504615966374`}}], 
   Line3DBox[{{32, 8, 20}, {31.694966116245386`, 6.739531528569969, 
     20.09040775570943}}], 
   Line3DBox[{{43, 8, 20}, {42.82653348846486, 6.72839179735535, 
     20.207176128795457`}}], 
   Line3DBox[{{54, 8, 20}, {53.965476399825214`, 6.7102746101879, 
     20.15942565635744}}], 
   Line3DBox[{{37, 9, 20}, {36.75275572143618, 7.728414178729953, 
     20.109269235663284`}}], 
   Line3DBox[{{48, 9, 20}, {47.8671782474308, 7.723903355269662, 
     20.209608528816027`}}], 
   Line3DBox[{{31, 10, 20}, {30.737140047476075`, 8.745641036312126, 
     20.21791795606375}}], 
   Line3DBox[{{42, 10, 20}, {41.807194926910704`, 8.738927160372988, 
     20.250042990195883`}}], 
   Line3DBox[{{53, 10, 20}, {52.93554483372349, 8.714464298270364, 
     20.18232797678569}}], 
   Line3DBox[{{36, 11, 20}, {35.73171111995506, 9.736455371998979, 
     20.146547091045814`}}], 
   Line3DBox[{{47, 11, 20}, {46.86718303638968, 9.726285660452975, 
     20.223632366641368`}}], 
   Line3DBox[{{30, 12, 20}, {29.87540082436414, 10.822529037719049`, 
     20.536690952426103`}}], 
   Line3DBox[{{41, 12, 20}, {40.78404022647296, 10.736553455526696`, 
     20.216942862239392`}}], 
   Line3DBox[{{52, 12, 20}, {51.9529602403538, 10.717518780886822`, 
     20.207434769588904`}}], 
   Line3DBox[{{35, 13, 20}, {34.75747719777818, 11.739972945265944`, 
     20.208601322480696`}}], 
   Line3DBox[{{46, 13, 20}, {45.88921247698425, 11.721859863799315`, 
     20.20996170359599}}], 
   Line3DBox[{{29, 14, 20}, {28.861992519167483`, 12.8376492007609, 
     20.56559221594934}}], 
   Line3DBox[{{40, 14, 20}, {39.798878417696315`, 12.731427071137555`, 
     20.200680924078547`}}], 
   Line3DBox[{{51, 14, 20}, {51.000250382752995`, 12.715668814191439`, 
     20.20122957652406}}], 
   Line3DBox[{{34, 15, 20}, {33.78708834423203, 13.736543793662538`, 
     20.21987960684313}}], 
   Line3DBox[{{45, 15, 20}, {44.86805318221771, 13.721753897565419`, 
     20.196664533884302`}}], 
   Line3DBox[{{28, 16, 20}, {27.89898046712766, 14.708294927474698`, 
     20.106268808173702`}}], 
   Line3DBox[{{39, 16, 20}, {38.80346887520916, 14.729183230110515`, 
     20.19078850687633}}], 
   Line3DBox[{{50, 16, 20}, {49.96820228743455, 14.710397482459367`, 
     20.160979042823804`}}], 
   Line3DBox[{{33, 17, 20}, {32.80397853787661, 15.730951031881949`, 
     20.20270743179646}}], 
   Line3DBox[{{44, 17, 20}, {43.88154565515797, 15.72244443307207, 
     20.20933308768444}}], 
   Line3DBox[{{55, 17, 20}, {54.994364981122516`, 15.720924472304231`, 
     20.232237036262614`}}], 
   Line3DBox[{{38, 18, 20}, {37.8966930699176, 16.715348442217028`, 
     20.170288147804648`}}], 
   Line3DBox[{{49, 18, 20}, {48.91929384070246, 16.712109311101017`, 
     20.15755662251628}}], 
   Line3DBox[{{32, 19, 20}, {31.873641003246025`, 17.728637533510007`, 
     20.240147626971023`}}], 
   Line3DBox[{{43, 19, 20}, {42.92040652925211, 17.716977814784325`, 
     20.19369809410188}}], 
   Line3DBox[{{54, 19, 20}, {53.928392465082574`, 17.723278505865117`, 
     20.234210562010006`}}], 
   Line3DBox[{{37, 20, 20}, {36.96854104828189, 18.714313706048195`, 
     20.18979222297362}}], 
   Line3DBox[{{48, 20, 20}, {47.90413500698053, 18.72489861930024, 
     20.234363760105836`}}], 
   Line3DBox[{{31, 21, 20}, {30.963951781611513`, 19.7284832730575, 
     20.2682270289446}}], 
   Line3DBox[{{42, 21, 20}, {41.95404973079915, 19.71945615078087, 
     20.21930805499896}}], 
   Line3DBox[{{53, 21, 20}, {52.91513529626668, 19.722549581795604`, 
     20.225651082624648`}}], 
   Line3DBox[{{36, 22, 20}, {35.97685330064987, 20.725372195008802`, 
     20.254535241278138`}}], 
   Line3DBox[{{47, 22, 20}, {46.97482576528332, 20.718384707592183`, 
     20.216398937550203`}}], 
   Line3DBox[{{30, 23, 20}, {30.00023626641168, 21.717744561463256`, 
     20.214058250299125`}}], 
   Line3DBox[{{41, 23, 20}, {40.91913526315333, 21.712026271334473`, 
     20.156794670196845`}}], 
   Line3DBox[{{52, 23, 20}, {51.95795059178339, 21.716001305090593`, 
     20.198945215422665`}}], 
   Line3DBox[{{35, 24, 20}, {34.97171366997881, 22.72117280438952, 
     20.231950182800034`}}], 
   Line3DBox[{{46, 24, 20}, {45.99038393730343, 22.714533337040326`, 
     20.19360524207142}}], 
   Line3DBox[{{29, 25, 20}, {29.000797431658203`, 23.7149483768636, 
     20.196574896610045`}}], 
   Line3DBox[{{40, 25, 20}, {39.97816925626561, 23.708635802600107`, 
     20.14799300085385}}], 
   Line3DBox[{{51, 25, 20}, {50.9591385656522, 23.70888820911896, 
     20.146152956285516`}}], 
   Line3DBox[{{34, 26, 20}, {33.99849884922424, 24.71007008788903, 
     20.16148860141736}}], 
   Line3DBox[{{45, 26, 20}, {44.93806823273344, 24.7116021983114, 
     20.16185042726921}}], 
   Line3DBox[{{28, 27, 20}, {28.047694567439578`, 25.713489237794462`, 
     20.180597029228274`}}], 
   Line3DBox[{{39, 27, 20}, {39.0352174447549, 25.704187701934487`, 
     20.098133683142503`}}], 
   Line3DBox[{{50, 27, 20}, {49.92195793963097, 25.70403024236566, 
     20.066119770950557`}}], 
   Line3DBox[{{33, 1, 21}, {33.08503377436293, 2.2972159585931107`, 
     21.000118274903805`}}], 
   Line3DBox[{{44, 1, 21}, {43.875034566338094`, -0.28914812563884684`, 
     21.111717279556657`}}], 
   Line3DBox[{{55, 1, 21}, {54.91407274823192, -0.29622771973741413`, 
     21.049093848778945`}}], 
   Line3DBox[{{38, 2, 21}, {37.830322696750635`, 0.7120928570546747, 
     21.0500480160689}}], 
   Line3DBox[{{49, 2, 21}, {48.88047008101519, 0.7104549564043132, 
     21.11307598774843}}], 
   Line3DBox[{{32, 3, 21}, {31.815811103147293`, 1.715451957339832, 
     21.077529196913904`}}], 
   Line3DBox[{{43, 3, 21}, {42.80090831060874, 1.723066778794129, 
     21.140726855276927`}}], 
   Line3DBox[{{54, 3, 21}, {53.951735886361014`, 1.7040855987238088`, 
     21.09097494105309}}], 
   Line3DBox[{{37, 4, 21}, {36.794778905588316`, 2.7189910712177126`, 
     21.0830688075545}}], 
   Line3DBox[{{48, 4, 21}, {47.835357334072384`, 2.721584235199944, 
     21.168955393127703`}}], 
   Line3DBox[{{31, 5, 21}, {30.780095458471536`, 3.7217422614795086`, 
     21.087744780629027`}}], 
   Line3DBox[{{42, 5, 21}, {41.780947426826145`, 3.7266410326744905`, 
     21.14343259921519}}], 
   Line3DBox[{{53, 5, 21}, {52.934129304938025`, 3.709124705047798, 
     21.138931725729286`}}], 
   Line3DBox[{{36, 6, 21}, {35.758192838689546`, 4.723648773091343, 
     21.04956654423849}}], 
   Line3DBox[{{47, 6, 21}, {46.822586534863056`, 4.723202473050667, 
     21.168263298327854`}}], 
   Line3DBox[{{30, 7, 21}, {29.77687146313499, 5.726181512412926, 
     21.132665431510468`}}], 
   Line3DBox[{{41, 7, 21}, {40.80512340927666, 5.726527859542096, 
     21.174045459192747`}}], 
   Line3DBox[{{52, 7, 21}, {51.89822121715994, 5.713425809019943, 
     21.15610230769469}}], 
   Line3DBox[{{35, 8, 21}, {34.73779155662797, 6.728810224666609, 
     21.072960861509852`}}], 
   Line3DBox[{{46, 8, 21}, {45.86627877854594, 6.719607667509657, 
     21.180870422769377`}}], 
   Line3DBox[{{29, 9, 21}, {28.76902866530352, 7.7385656442723585`, 
     21.213156301193553`}}], 
   Line3DBox[{{40, 9, 21}, {39.81464024753603, 7.73079075268534, 
     21.211541127673676`}}], 
   Line3DBox[{{51, 9, 21}, {50.921700483349134`, 7.717347242788378, 
     21.19664966338559}}], 
   Line3DBox[{{34, 10, 21}, {33.704307602244974`, 8.740909218775036, 
     21.13136365762338}}], 
   Line3DBox[{{45, 10, 21}, {44.850494608896184`, 8.730263660184777, 
     21.23540978183486}}], 
   Line3DBox[{{28, 11, 21}, {27.859377754107033`, 9.754602281820574, 
     21.345267877905684`}}], 
   Line3DBox[{{39, 11, 21}, {38.79103900190109, 9.729269103991575, 
     21.177702817093966`}}], 
   Line3DBox[{{50, 11, 21}, {49.96824243437987, 9.720707533348245, 
     21.228915359453996`}}], 
   Line3DBox[{{33, 12, 21}, {32.69142660174531, 10.756899475637693`, 
     21.2224489699228}}], 
   Line3DBox[{{44, 12, 21}, {43.83345227320849, 10.732413018267371`, 
     21.23555275087025}}], 
   Line3DBox[{{55, 12, 21}, {54.97163692889247, 10.717368817129485`, 
     21.209887553050518`}}], 
   Line3DBox[{{38, 13, 21}, {37.77825999651807, 11.728722194702938`, 
     21.15711178381941}}], 
   Line3DBox[{{49, 13, 21}, {48.95789690245466, 11.722475449322708`, 
     21.236977533943353`}}], 
   Line3DBox[{{32, 14, 21}, {31.746125256739944`, 12.769743963472585`, 
     21.33469045298977}}], 
   Line3DBox[{{43, 14, 21}, {42.833463267116784`, 12.727763644138605`, 
     21.208998017754}}], 
   Line3DBox[{{54, 14, 21}, {54.0131685099459, 12.720349586598385`, 
     21.228738737049238`}}], 
   Line3DBox[{{37, 15, 21}, {36.795379873904544`, 13.72678131675871, 
     21.1644529982761}}], 
   Line3DBox[{{48, 15, 21}, {47.95459931985624, 13.712793207014077`, 
     21.176174488315926`}}], 
   Line3DBox[{{31, 16, 21}, {30.81524458043031, 14.751853953097962`, 
     21.313044534439502`}}], 
   Line3DBox[{{42, 16, 21}, {41.83142795735295, 14.729734553178577`, 
     21.219109929143738`}}], 
   Line3DBox[{{53, 16, 21}, {53.02298316986274, 14.717501031201946`, 
     21.21134845382683}}], 
   Line3DBox[{{36, 17, 21}, {35.83385031751506, 15.721246083403324`, 
     21.164871779873984`}}], 
   Line3DBox[{{47, 17, 21}, {46.903719387527396`, 15.712758752534308`, 
     21.154077949379094`}}], 
   Line3DBox[{{30, 18, 21}, {29.893535831729665`, 16.742816944167433`, 
     21.313298811044657`}}], 
   Line3DBox[{{41, 18, 21}, {40.896212431596865`, 16.721185996684937`, 
     21.20943468091572}}], 
   Line3DBox[{{52, 18, 21}, {51.96393611159719, 16.71854525249238, 
     21.215808076872612`}}], 
   Line3DBox[{{35, 19, 21}, {34.908294609168365`, 17.71500744455642, 
     21.17431079641546}}], 
   Line3DBox[{{46, 19, 21}, {45.92642721795081, 17.72320721776775, 
     21.23321071369295}}], 
   Line3DBox[{{29, 20, 21}, {28.93903871976409, 18.733232993418333`, 
     21.28563100908011}}], 
   Line3DBox[{{40, 20, 21}, {39.93579937205984, 18.71623040100789, 
     21.194457954519045`}}], 
   Line3DBox[{{51, 20, 21}, {50.9604881738251, 18.715641758286356`, 
     21.197136304455974`}}], 
   Line3DBox[{{34, 21, 21}, {33.98767764611971, 19.718701249572483`, 
     21.219366523762705`}}], 
   Line3DBox[{{45, 21, 21}, {44.930480901403236`, 19.724944615074644`, 
     21.24372291706597}}], 
   Line3DBox[{{28, 22, 21}, {27.997347767188565`, 20.71699496972052, 
     21.209501928245704`}}], 
   Line3DBox[{{39, 22, 21}, {38.96732117860154, 20.708734773668283`, 
     21.146854383313915`}}], 
   Line3DBox[{{50, 22, 21}, {49.9708440194397, 20.715671317477003`, 
     21.199122485034493`}}], 
   Line3DBox[{{33, 23, 21}, {32.99243060363902, 21.717235655120707`, 
     21.21085146370164}}], 
   Line3DBox[{{44, 23, 21}, {43.93990519802034, 21.718404752335285`, 
     21.209528604105124`}}], 
   Line3DBox[{{55, 23, 21}, {54.86524706098033, 21.72221873469674, 
     21.197779380789715`}}], 
   Line3DBox[{{38, 24, 21}, {37.99584304991584, 22.709423236246778`, 
     21.156186864448507`}}], 
   Line3DBox[{{49, 24, 21}, {48.987286339909524`, 22.70979467653865, 
     21.158772120219805`}}], 
   Line3DBox[{{32, 25, 21}, {32.02755382738448, 23.713143996904513`, 
     21.182325022675382`}}], 
   Line3DBox[{{43, 25, 21}, {42.93913558190727, 23.709431081527075`, 
     21.143970098568627`}}], 
   Line3DBox[{{54, 25, 21}, {53.87548160155204, 23.71553888466179, 
     21.157018507291568`}}], 
   Line3DBox[{{37, 26, 21}, {37.037628759226806`, 24.708655249359236`, 
     21.14495796449866}}], 
   Line3DBox[{{48, 26, 21}, {47.91818361111408, 24.70843404417872, 
     21.1231400027332}}], 
   Line3DBox[{{31, 27, 21}, {31.022813945744748`, 25.70665876297219, 
     21.129413942382293`}}], 
   Line3DBox[{{42, 27, 21}, {41.99689880861049, 25.706244663037037`, 
     21.127230148517626`}}], 
   Line3DBox[{{53, 27, 21}, {52.922314608013856`, 25.70642941537473, 
     21.103150969283817`}}], 
   Line3DBox[{{36, 1, 22}, {35.890626379592945`, -0.29444924494600877`, 
     22.049381812621263`}}], 
   Line3DBox[{{47, 1, 22}, {46.85918592419577, -0.2851405467546164, 
     22.136327440901116`}}], 
   Line3DBox[{{30, 2, 22}, {29.88127667978442, 0.7090892963324178, 
     22.097233370781105`}}], 
   Line3DBox[{{41, 2, 22}, {40.83884382375949, 0.7145886659334098, 
     22.108380759882404`}}], 
   Line3DBox[{{52, 2, 22}, {51.954144884103016`, 0.7014733718570678, 
     22.04154400498052}}], 
   Line3DBox[{{35, 3, 22}, {34.83067304993371, 1.7121033049953653`, 
     22.051482880430168`}}], 
   Line3DBox[{{46, 3, 22}, {45.81198747312152, 1.7239834134497578`, 
     22.16258216564383}}], 
   Line3DBox[{{29, 4, 22}, {28.870972660904172`, 2.7104149226778707`, 
     22.101598593070623`}}], 
   Line3DBox[{{40, 4, 22}, {39.813786733348444`, 2.7207151197372816`, 
     22.136948218148895`}}], 
   Line3DBox[{{51, 4, 22}, {50.888396698277454`, 2.7101435394076594`, 
     22.1175372881805}}], 
   Line3DBox[{{34, 5, 22}, {33.752059422468584`, 3.7250597926480404`, 
     22.055253395286897`}}], 
   Line3DBox[{{45, 5, 22}, {44.80002266541762, 3.732451348495001, 
     22.208157348467896`}}], 
   Line3DBox[{{28, 6, 22}, {27.87548576793534, 4.712460350139915, 
     22.129374866382616`}}], 
   Line3DBox[{{39, 6, 22}, {38.802583459469666`, 4.721502244045794, 
     22.128336267458167`}}], 
   Line3DBox[{{50, 6, 22}, {49.84401058194523, 4.7203388765172285`, 
     22.167734046936644`}}], 
   Line3DBox[{{33, 7, 22}, {32.71857582083657, 5.733313942518556, 
     22.07941576143504}}], 
   Line3DBox[{{44, 7, 22}, {43.82800714608792, 5.7291501708200006`, 
     22.212976923342282`}}], 
   Line3DBox[{{55, 7, 22}, {54.93686070781972, 5.71184353687405, 
     22.163298365851645`}}], 
   Line3DBox[{{38, 8, 22}, {37.80546716829902, 6.722255496875954, 
     22.13973532884236}}], 
   Line3DBox[{{49, 8, 22}, {48.84435997130586, 6.724671453273606, 
     22.19827576597465}}], 
   Line3DBox[{{32, 9, 22}, {31.724968366026257`, 7.7326646783168, 
     22.090657502325353`}}], 
   Line3DBox[{{43, 9, 22}, {42.79991377712815, 7.736858585484725, 
     22.233322245731575`}}], 
   Line3DBox[{{54, 9, 22}, {53.91179382041398, 7.71728651766272, 
     22.19200466690424}}], 
   Line3DBox[{{37, 10, 22}, {36.79500127950653, 8.724606775825768, 
     22.14610834447935}}], 
   Line3DBox[{{48, 10, 22}, {47.88672393722353, 8.728463646955237, 
     22.245690529910064`}}], 
   Line3DBox[{{31, 11, 22}, {30.738367387805432`, 9.742729003163024, 
     22.202034691943737`}}], 
   Line3DBox[{{42, 11, 22}, {41.788837377269225`, 9.73512327353773, 
     22.213300758591135`}}], 
   Line3DBox[{{53, 11, 22}, {52.94850228671286, 9.720978454706787, 
     22.226830051364352`}}], 
   Line3DBox[{{36, 12, 22}, {35.76601952701707, 10.732646582613846`, 
     22.1704947321835}}], 
   Line3DBox[{{47, 12, 22}, {46.89650277027882, 10.72524899293247, 
     22.233019727534728`}}], 
   Line3DBox[{{30, 13, 22}, {29.788494999006893`, 11.756090834895708`, 
     22.312978631098755`}}], 
   Line3DBox[{{41, 13, 22}, {40.78250997087832, 11.732248739507332`, 
     22.188427250555502`}}], 
   Line3DBox[{{52, 13, 22}, {51.995802869855964`, 11.723750233057448`, 
     22.247323505711922`}}], 
   Line3DBox[{{35, 14, 22}, {34.813055921831726`, 12.725770993662744`, 
     22.17717886738148}}], 
   Line3DBox[{{46, 14, 22}, {45.894094797912864`, 12.723278879760093`, 
     22.220833125468616`}}], 
   Line3DBox[{{29, 15, 22}, {28.85239580735333, 13.74867447677109, 
     22.319995995645282`}}], 
   Line3DBox[{{40, 15, 22}, {39.81614926746795, 13.727083162483993`, 
     22.189424478132246`}}], 
   Line3DBox[{{51, 15, 22}, {51.009162370778995`, 13.717707956804569`, 
     22.213642614942327`}}], 
   Line3DBox[{{34, 16, 22}, {33.83744913961699, 14.727852410255071`, 
     22.212644604198914`}}], 
   Line3DBox[{{45, 16, 22}, {44.890748745228564`, 14.719459226231871`, 
     22.195651450411663`}}], 
   Line3DBox[{{28, 17, 22}, {27.901857068814007`, 15.733995364239329`, 
     22.278568173506436`}}], 
   Line3DBox[{{39, 17, 22}, {38.860988761427386`, 15.720792680363374`, 
     22.185214764364467`}}], 
   Line3DBox[{{50, 17, 22}, {49.94023437633148, 15.714519498754262`, 
     22.184303963995678`}}], 
   Line3DBox[{{33, 18, 22}, {32.86108151817309, 16.723597507096724`, 
     22.203711392703518`}}], 
   Line3DBox[{{44, 18, 22}, {43.919353073131404`, 16.724552033615556`, 
     22.238177577098348`}}], 
   Line3DBox[{{55, 18, 22}, {54.94249607153085, 16.719029772789995`, 
     22.21402937932014}}], 
   Line3DBox[{{38, 19, 22}, {37.93324588985966, 17.715103869861537`, 
     22.18597264189815}}], 
   Line3DBox[{{49, 19, 22}, {48.91552447082465, 17.720225569870216`, 
     22.212229340470472`}}], 
   Line3DBox[{{32, 20, 22}, {31.936200983679548`, 18.72286382931135, 
     22.234206932082035`}}], 
   Line3DBox[{{43, 20, 22}, {42.96662339484909, 18.72627845900771, 
     22.257913625543175`}}], 
   Line3DBox[{{54, 20, 22}, {53.89512323745187, 18.72356548579371, 
     22.22297039180209}}], 
   Line3DBox[{{37, 21, 22}, {36.99051823643104, 19.713958275883613`, 
     22.189754525615008`}}], 
   Line3DBox[{{48, 21, 22}, {47.925371504775754`, 19.718680576114757`, 
     22.20652147993599}}], 
   Line3DBox[{{31, 22, 22}, {30.970794673880192`, 20.717387389905053`, 
     22.209885543455623`}}], 
   Line3DBox[{{42, 22, 22}, {41.963458421385006`, 20.716607720039615`, 
     22.20388469479195}}], 
   Line3DBox[{{53, 22, 22}, {52.90144165310445, 20.71529609410942, 
     22.172690840656646`}}], 
   Line3DBox[{{36, 23, 22}, {35.99189092895419, 21.716691306761923`, 
     22.207492266907362`}}], 
   Line3DBox[{{47, 23, 22}, {46.97605449078593, 21.720069646371524`, 
     22.226285002704476`}}], 
   Line3DBox[{{30, 24, 22}, {30.01583549049002, 22.71255206739392, 
     22.179518962979582`}}], 
   Line3DBox[{{41, 24, 22}, {40.941225413803124`, 22.707248426297305`, 
     22.12385038032479}}], 
   Line3DBox[{{52, 24, 22}, {51.918588831798814`, 22.707965159208825`, 
     22.118398445402978`}}], 
   Line3DBox[{{35, 25, 22}, {34.99449282768324, 23.713542345986024`, 
     22.18707318215589}}], 
   Line3DBox[{{46, 25, 22}, {45.96827951788236, 23.713356736490912`, 
     22.183147272654843`}}], 
   Line3DBox[{{29, 26, 22}, {29.047152268616962`, 24.712033121912174`, 
     22.170052887399702`}}], 
   Line3DBox[{{40, 26, 22}, {39.97046784337805, 24.704387892684533`, 
     22.102553006308113`}}], 
   Line3DBox[{{51, 26, 22}, {50.91674709598748, 24.70477167543357, 
     22.073841324570466`}}], 
   Line3DBox[{{34, 27, 22}, {33.99774341056996, 25.704914221651833`, 
     22.112905865766447`}}], 
   Line3DBox[{{45, 27, 22}, {44.95587824688369, 25.70682434767161, 
     22.125499016438305`}}], 
   Line3DBox[{{28, 1, 23}, {27.95542856862837, -0.29749716867119647`, 
     23.067189915878142`}}], 
   Line3DBox[{{39, 1, 23}, {38.89969234062006, -0.2953444637520306, 
     23.04495657567788}}], 
   Line3DBox[{{50, 1, 23}, {49.996926984038836`, -0.29915352134959416`, 
     23.046804749095074`}}], 
   Line3DBox[{{33, 2, 23}, {32.89053863438551, 0.7067452716417402, 
     23.074232183160778`}}], 
   Line3DBox[{{44, 2, 23}, {43.838260103438785`, 0.7195298852227503, 
     23.155680734269545`}}], 
   Line3DBox[{{55, 2, 23}, {54.9134209234609, 0.7079648216363175, 
     23.11466979278068}}], 
   Line3DBox[{{38, 3, 23}, {37.82736699467971, 1.713533102558606, 
     23.072116345315045`}}], 
   Line3DBox[{{49, 3, 23}, {48.873248475925536`, 1.7116761409802606`, 
     23.118977667758646`}}], 
   Line3DBox[{{32, 4, 23}, {31.813524454262893`, 2.7166729280566306`, 
     23.0910960880571}}], 
   Line3DBox[{{43, 4, 23}, {42.81010120201171, 2.7263459029586006`, 
     23.17816758294443}}], 
   Line3DBox[{{54, 4, 23}, {53.92712670437376, 2.706316534246155, 
     23.105226295286354`}}], 
   Line3DBox[{{37, 5, 23}, {36.78254858983045, 3.72153035756525, 
     23.09072076712657}}], 
   Line3DBox[{{48, 5, 23}, {47.83255492336924, 3.722397262484911, 
     23.172317704853764`}}], 
   Line3DBox[{{31, 6, 23}, {30.77932847804383, 4.722646307446391, 
     23.098344412740165`}}], 
   Line3DBox[{{42, 6, 23}, {41.81493062756683, 4.726690174238379, 
     23.185557039764337`}}], 
   Line3DBox[{{53, 6, 23}, {52.89252859700916, 4.7127222583209045`, 
     23.14617083606777}}], 
   Line3DBox[{{36, 7, 23}, {35.77566208005694, 5.720706959730337, 
     23.05551409544632}}], 
   Line3DBox[{{47, 7, 23}, {46.849628617546564`, 5.720579425783116, 
     23.17456071038347}}], 
   Line3DBox[{{30, 8, 23}, {29.786337312545804`, 6.72452792307978, 
     23.13236025455804}}], 
   Line3DBox[{{41, 8, 23}, {40.81893171028819, 6.730435015049546, 
     23.213117393585303`}}], 
   Line3DBox[{{52, 8, 23}, {51.87151825200238, 6.721734332599131, 
     23.198819827923895`}}], 
   Line3DBox[{{35, 9, 23}, {34.764065268394724`, 7.725441392572361, 
     23.099172368402012`}}], 
   Line3DBox[{{46, 9, 23}, {45.86416320593379, 7.72747515214196, 
     23.228536379952264`}}], 
   Line3DBox[{{29, 10, 23}, {28.840732590526557`, 8.722924224664938, 
     23.183606525842546`}}], 
   Line3DBox[{{40, 10, 23}, {39.79770469614186, 8.737268248767322, 
     23.23363461743884}}], 
   Line3DBox[{{51, 10, 23}, {50.90382792920447, 8.725181683843871, 
     23.235773606647886`}}], 
   Line3DBox[{{34, 11, 23}, {33.76367326139248, 9.730103911016105, 
     23.146675136961047`}}], 
   Line3DBox[{{45, 11, 23}, {44.863161137952964`, 9.729612596213782, 
     23.23956412530883}}], 
   Line3DBox[{{28, 12, 23}, {27.874775747080253`, 10.740792010323062`, 
     23.297849165206916`}}], 
   Line3DBox[{{39, 12, 23}, {38.77649897465553, 10.73178944335494, 
     23.178014818720232`}}], 
   Line3DBox[{{50, 12, 23}, {49.92888078860289, 10.726392838319681`, 
     23.25073263745842}}], 
   Line3DBox[{{33, 13, 23}, {32.768852050090906`, 11.737470528016777`, 
     23.20637334524251}}], 
   Line3DBox[{{44, 13, 23}, {43.84708703760603, 11.729916405709488`, 
     23.23131210397641}}], 
   Line3DBox[{{55, 13, 23}, {54.922904972833784`, 11.72680772018779, 
     23.251073247106945`}}], 
   Line3DBox[{{38, 14, 23}, {37.79443302544025, 12.725505426677048`, 
     23.15298954716155}}], 
   Line3DBox[{{49, 14, 23}, {48.95798303315431, 12.720775248029646`, 
     23.227637010267387`}}], 
   Line3DBox[{{32, 15, 23}, {31.8314649541445, 13.739086341391323`, 
     23.267754895104762`}}], 
   Line3DBox[{{43, 15, 23}, {42.870192226118476`, 13.723068966879293`, 
     23.206390596910822`}}], 
   Line3DBox[{{54, 15, 23}, {53.952982047845914`, 13.726554391908248`, 
     23.257148975123496`}}], 
   Line3DBox[{{37, 16, 23}, {36.82197509535245, 14.72060882599391, 
     23.146510604396237`}}], 
   Line3DBox[{{48, 16, 23}, {47.92349531065618, 14.716742441676733`, 
     23.193383224491196`}}], 
   Line3DBox[{{31, 17, 23}, {30.850416836566787`, 15.731322902150497`, 
     23.241004768852147`}}], 
   Line3DBox[{{42, 17, 23}, {41.89803178107576, 15.72370930753174, 
     23.225132295880236`}}], 
   Line3DBox[{{53, 17, 23}, {52.9380575029991, 15.718715539671232`, 
     23.21088683881483}}], 
   Line3DBox[{{36, 18, 23}, {35.904888831864234`, 16.714884267124503`, 
     23.17155587664585}}], 
   Line3DBox[{{47, 18, 23}, {46.893708309657576`, 16.721846888739886`, 
     23.212194959271518`}}], 
   Line3DBox[{{30, 19, 23}, {29.89901086518466, 17.72743459718327, 
     23.245720349591032`}}], 
   Line3DBox[{{41, 19, 23}, {40.93506092009121, 17.72483200025586, 
     23.24439617085611}}], 
   Line3DBox[{{52, 19, 23}, {51.92924471050338, 17.718279917870507`, 
     23.205395521066592`}}], 
   Line3DBox[{{35, 20, 23}, {34.92639187510389, 18.719273214256848`, 
     23.210524925434704`}}], 
   Line3DBox[{{46, 20, 23}, {45.91934206353918, 18.72282580759355, 
     23.228736484927126`}}], 
   Line3DBox[{{29, 21, 23}, {28.92563558047291, 19.724201800813557`, 
     23.238346151764667`}}], 
   Line3DBox[{{40, 21, 23}, {39.95535483043809, 19.715607856673643`, 
     23.1958152981672}}], 
   Line3DBox[{{51, 21, 23}, {50.93648638860738, 19.71616197227997, 
     23.19423166515224}}], 
   Line3DBox[{{34, 22, 23}, {33.998285528851156`, 20.71949419710731, 
     23.22428096073191}}], 
   Line3DBox[{{45, 22, 23}, {44.90499036214672, 20.72701379069339, 
     23.245925353776666`}}], 
   Line3DBox[{{28, 23, 23}, {27.99403627615476, 21.712569196591026`, 
     23.180239730447035`}}], 
   Line3DBox[{{39, 23, 23}, {38.97377875008586, 21.70707330548345, 
     23.132864625312568`}}], 
   Line3DBox[{{50, 23, 23}, {49.955912113738194`, 21.710803059970583`, 
     23.161330431424936`}}], 
   Line3DBox[{{33, 24, 23}, {33.03084653650863, 22.715714561213126`, 
     23.19914668690549}}], 
   Line3DBox[{{44, 24, 23}, {43.95429559782506, 22.71351133995526, 
     23.18126785483954}}], 
   Line3DBox[{{55, 24, 23}, {54.8814340618917, 22.718272475503152`, 
     23.181979865006213`}}], 
   Line3DBox[{{38, 25, 23}, {38.01332665468829, 23.70444776684119, 
     23.106615249528566`}}], 
   Line3DBox[{{49, 25, 23}, {48.94607282544889, 23.706859346324922`, 
     23.121979955967042`}}], 
   Line3DBox[{{32, 26, 23}, {32.03432639853377, 24.711881652836716`, 
     23.171967502933054`}}], 
   Line3DBox[{{43, 26, 23}, {42.94612811796116, 24.708475741990625`, 
     23.138068502197005`}}], 
   Line3DBox[{{54, 26, 23}, {53.89960811878536, 24.709968608301242`, 
     23.12546106415119}}], 
   Line3DBox[{{37, 27, 23}, {37.03286322420876, 25.7025828691849, 
     23.075025310143484`}}], 
   Line3DBox[{{48, 27, 23}, {47.94784881709172, 25.703964899296697`, 
     23.087024547492344`}}], 
   Line3DBox[{{31, 1, 24}, {30.96068450464455, -0.2978275871164464, 
     24.064014419816626`}}], 
   Line3DBox[{{42, 1, 24}, {41.90983632650596, -0.29271618877575634`, 
     24.103708086758665`}}], 
   Line3DBox[{{53, 1, 24}, {52.96823444484023, -0.2989363678103276, 
     24.041895845678358`}}], 
   Line3DBox[{{36, 2, 24}, {35.86921127938205, 0.707006424398966, 
     24.032587175599804`}}], 
   Line3DBox[{{47, 2, 24}, {46.86427040124365, 0.7113712909024852, 
     24.104945348210936`}}], 
   Line3DBox[{{30, 3, 24}, {29.8882626420836, 1.7102728615366927`, 
     24.118822014614768`}}], 
   Line3DBox[{{41, 3, 24}, {40.85087879749142, 1.7137422870673569`, 
     24.115342805946803`}}], 
   Line3DBox[{{52, 3, 24}, {51.92072219318577, 1.7040449051980522`, 
     24.064926278220767`}}], 
   Line3DBox[{{35, 4, 24}, {34.801866705185674`, 2.7157574590978086`, 
     24.03826608972838}}], 
   Line3DBox[{{46, 4, 24}, {45.821945194641785`, 2.7215587833366595`, 
     24.154546244940487`}}], 
   Line3DBox[{{29, 5, 24}, {28.855561947560904`, 3.7131652512111817`, 
     24.114865043930777`}}], 
   Line3DBox[{{40, 5, 24}, {39.816125572796196`, 3.7226344207203246`, 
     24.156612170318823`}}], 
   Line3DBox[{{51, 5, 24}, {50.872664475390835`, 3.7169578161698507`, 
     24.16609761793858}}], 
   Line3DBox[{{34, 6, 24}, {33.738430683541424`, 4.727769711245164, 
     24.054877910512154`}}], 
   Line3DBox[{{45, 6, 24}, {44.84074767595453, 4.727555662489412, 
     24.21336378611039}}], 
   Line3DBox[{{28, 7, 24}, {27.88358892313772, 5.715136548100676, 
     24.159919889810865`}}], 
   Line3DBox[{{39, 7, 24}, {38.821907360912675`, 5.719768549984905, 
     24.138890051102152`}}], 
   Line3DBox[{{50, 7, 24}, {49.81195941948084, 5.727767139505478, 
     24.18990599978923}}], 
   Line3DBox[{{33, 8, 24}, {32.73935168259266, 6.728448676662791, 
     24.072247399621823`}}], 
   Line3DBox[{{44, 8, 24}, {43.8341993348536, 6.735580662309408, 
     24.25249530275056}}], 
   Line3DBox[{{55, 8, 24}, {54.87346742015565, 6.719466897045374, 
     24.184998590468496`}}], 
   Line3DBox[{{38, 9, 24}, {37.814928844115954`, 7.724456937162117, 
     24.169524517713203`}}], 
   Line3DBox[{{49, 9, 24}, {48.816294072876126`, 7.731023148583935, 
     24.214359237985505`}}], 
   Line3DBox[{{32, 10, 24}, {31.7635589402247, 8.725423643588, 
     24.09772787180658}}], 
   Line3DBox[{{43, 10, 24}, {42.81482709560508, 8.736485946927726, 
     24.243399328608007`}}], 
   Line3DBox[{{54, 10, 24}, {53.90177400385241, 8.725678971607401, 
     24.237608018124895`}}], 
   Line3DBox[{{37, 11, 24}, {36.81949021456624, 9.722751474240964, 
     24.161407623144083`}}], 
   Line3DBox[{{48, 11, 24}, {47.88241609170512, 9.731592604096699, 
     24.25945462518118}}], 
   Line3DBox[{{31, 12, 24}, {30.787033733848492`, 10.73364511184637, 
     24.202461519136087`}}], 
   Line3DBox[{{42, 12, 24}, {41.81922485515691, 10.732245737550254`, 
     24.223873797143526`}}], 
   Line3DBox[{{53, 12, 24}, {52.9475184374994, 10.728393912958627`, 
     24.265072905059764`}}], 
   Line3DBox[{{36, 13, 24}, {35.80586810046711, 11.721695959523023`, 
     24.13509842961332}}], 
   Line3DBox[{{47, 13, 24}, {46.88063562207787, 11.727787981116556`, 
     24.239225258473635`}}], 
   Line3DBox[{{30, 14, 24}, {29.818745223303893`, 12.733837982200178`, 
     24.232336933366025`}}], 
   Line3DBox[{{41, 14, 24}, {40.828997941447355`, 12.728612954407863`, 
     24.210554687127253`}}], 
   Line3DBox[{{52, 14, 24}, {51.960819279061425`, 12.72504103692857, 
     24.250887452038864`}}], 
   Line3DBox[{{35, 15, 24}, {34.835943567590846`, 13.720242458948864`, 
     24.15907898386628}}], 
   Line3DBox[{{46, 15, 24}, {45.93323377198711, 13.713192939214764`, 
     24.17224940960768}}], 
   Line3DBox[{{29, 16, 24}, {28.876576711420498`, 14.727509418497725`, 
     24.235657403499705`}}], 
   Line3DBox[{{40, 16, 24}, {39.84554706392126, 14.727562520605609`, 
     24.216903553611058`}}], 
   Line3DBox[{{51, 16, 24}, {50.94291697401651, 14.717502648844645`, 
     24.204797637740445`}}], 
   Line3DBox[{{34, 17, 24}, {33.87965280441147, 15.723470685484987`, 
     24.214451536944384`}}], 
   Line3DBox[{{45, 17, 24}, {44.92435751807, 15.716326201269668`, 
     24.19094447721971}}], 
   Line3DBox[{{28, 18, 24}, {27.902930689316904`, 16.728642327623305`, 
     24.25343089356355}}], 
   Line3DBox[{{39, 18, 24}, {38.924153317606596`, 16.717751330738295`, 
     24.20021396291593}}], 
   Line3DBox[{{50, 18, 24}, {49.90183543712228, 16.71963019356125, 
     24.202526238682864`}}], 
   Line3DBox[{{33, 19, 24}, {32.88232694255148, 17.72582545584772, 
     24.229417267408206`}}], 
   Line3DBox[{{44, 19, 24}, {43.95363721094562, 17.7279671318268, 
     24.264164482999075`}}], 
   Line3DBox[{{55, 19, 24}, {54.863145619051366`, 17.725805894624965`, 
     24.2184038924623}}], 
   Line3DBox[{{38, 20, 24}, {37.977299266011975`, 18.71472050344899, 
     24.193755754551933`}}], 
   Line3DBox[{{49, 20, 24}, {48.90462414138293, 18.724919237810628`, 
     24.23467529799198}}], 
   Line3DBox[{{32, 21, 24}, {31.92028844284646, 19.72598593614896, 
     24.2460370556764}}], 
   Line3DBox[{{43, 21, 24}, {42.914170537619796`, 19.727096956224244`, 
     24.24970211159288}}], 
   Line3DBox[{{54, 21, 24}, {53.8812124690111, 19.71930342206023, 
     24.188959778087607`}}], 
   Line3DBox[{{37, 22, 24}, {37.022726297916606`, 20.714590548827363`, 
     24.19288871978181}}], 
   Line3DBox[{{48, 22, 24}, {47.902793993060506`, 20.72226498143204, 
     24.218961673678333`}}], 
   Line3DBox[{{31, 23, 24}, {30.97795988661118, 21.721850265145576`, 
     24.2363207326778}}], 
   Line3DBox[{{42, 23, 24}, {41.92278189770081, 21.714184164685314`, 
     24.175256960864072`}}], 
   Line3DBox[{{53, 23, 24}, {52.891820657553744`, 21.713268490433535`, 
     24.150396981873662`}}], 
   Line3DBox[{{36, 24, 24}, {36.019340998369245`, 22.712349995099338`, 
     24.177717164791144`}}], 
   Line3DBox[{{47, 24, 24}, {46.926539601556776`, 22.71679399463829, 
     24.19489976311994}}], 
   Line3DBox[{{30, 25, 24}, {30.0226305662922, 23.71399347422046, 
     24.188878461243533`}}], 
   Line3DBox[{{41, 25, 24}, {40.9148297176801, 23.70577999708727, 
     24.087980719877258`}}], 
   Line3DBox[{{52, 25, 24}, {51.90393722656823, 23.707249951958055`, 
     24.09782257841699}}], 
   Line3DBox[{{35, 26, 24}, {35.02390059778429, 24.704038099689612`, 
     24.09955658877967}}], 
   Line3DBox[{{46, 26, 24}, {45.946667063533084`, 24.713272848273807`, 
     24.17745093659493}}], 
   Line3DBox[{{29, 27, 24}, {29.039791745214202`, 25.712851786807384`, 
     24.177949695947657`}}], 
   Line3DBox[{{40, 27, 24}, {39.973788843959106`, 25.70063521158404, 
     24.03105031278018}}], 
   Line3DBox[{{51, 27, 24}, {50.931554988432204`, 25.701852465890177`, 
     24.011325196513585`}}], 
   Line3DBox[{{34, 1, 25}, {33.97226535255017, -0.2992917663286332, 
     25.032736757344818`}}], 
   Line3DBox[{{45, 1, 25}, {44.895971435405905`, -0.2896385936465844, 
     25.126532033595257`}}], 
   Line3DBox[{{28, 2, 25}, {27.963203579676314`, 0.7021044331354156, 
     25.064133618053415`}}], 
   Line3DBox[{{39, 2, 25}, {38.87348215472582, 0.7065361796388889, 
     25.030734024207995`}}], 
   Line3DBox[{{50, 2, 25}, {49.97162913669675, 0.7032436968813298, 
     25.087282211460458`}}], 
   Line3DBox[{{33, 3, 25}, {32.8415357386879, 1.7129239400181158`, 
     25.091237567417824`}}], 
   Line3DBox[{{44, 3, 25}, {43.84158592476619, 1.7189990707765685`, 
     25.154730734169156`}}], 
   Line3DBox[{{55, 3, 25}, {54.90658113434748, 1.7104820887318934`, 
     25.13570730289464}}], 
   Line3DBox[{{38, 4, 25}, {37.816757172370735`, 2.7139836344312034`, 
     25.050832800549003`}}], 
   Line3DBox[{{49, 4, 25}, {48.87087285935401, 2.7154799403768997`, 
     25.152756007981537`}}], 
   Line3DBox[{{32, 5, 25}, {31.802473928434665`, 3.717312788200681, 
     25.075478260038604`}}], 
   Line3DBox[{{43, 5, 25}, {42.835555103985605`, 3.7240450153676408`, 
     25.18680672730566}}], 
   Line3DBox[{{54, 5, 25}, {53.89511043352447, 3.714200767047968, 
     25.160369920448144`}}], 
   Line3DBox[{{37, 6, 25}, {36.7839388445863, 4.719549534647804, 
     25.061352937180256`}}], 
   Line3DBox[{{48, 6, 25}, {47.84344567069545, 4.725721204693884, 
     25.204216291733044`}}], 
   Line3DBox[{{31, 7, 25}, {30.766769014142756`, 5.7241183250324195`, 
     25.087916202818253`}}], 
   Line3DBox[{{42, 7, 25}, {41.836644858127364`, 5.726304717940243, 
     25.202522655726437`}}], 
   Line3DBox[{{53, 7, 25}, {52.853595838537984`, 5.722493141891158, 
     25.19115974730963}}], 
   Line3DBox[{{36, 8, 25}, {35.79689000934743, 6.719018970808022, 
     25.088509516705106`}}], 
   Line3DBox[{{47, 8, 25}, {46.82864137191464, 6.726061911407579, 
     25.19421114029374}}], 
   Line3DBox[{{30, 9, 25}, {29.83511187164627, 7.716378215119028, 
     25.12299194488661}}], 
   Line3DBox[{{41, 9, 25}, {40.83602393530147, 7.730942712263867, 
     25.229358781497012`}}], 
   Line3DBox[{{52, 9, 25}, {51.85785606420558, 7.726642578552138, 
     25.21989992896889}}], 
   Line3DBox[{{35, 10, 25}, {34.79959979207418, 8.721181372320771, 
     25.120260858819087`}}], 
   Line3DBox[{{46, 10, 25}, {45.84136170296349, 8.73298646222184, 
     25.243947916162913`}}], 
   Line3DBox[{{29, 11, 25}, {28.863795044188226`, 9.723205604210671, 
     25.203086880160374`}}], 
   Line3DBox[{{40, 11, 25}, {39.81958839644302, 9.736093462672534, 
     25.244932476823497`}}], 
   Line3DBox[{{51, 11, 25}, {50.887256989219985`, 9.724660376788844, 
     25.225383803739053`}}], 
   Line3DBox[{{34, 12, 25}, {33.78915623454806, 10.72553099497661, 
     25.145854934111743`}}], 
   Line3DBox[{{45, 12, 25}, {44.829072393239336`, 10.740593598981508`, 
     25.273275081777907`}}], 
   Line3DBox[{{28, 13, 25}, {27.866055950298698`, 11.729153552496177`, 
     25.238764106214752`}}], 
   Line3DBox[{{39, 13, 25}, {38.80542533144581, 11.729585027238167`, 
     25.195413651876162`}}], 
   Line3DBox[{{50, 13, 25}, {49.90431379858748, 11.729895457979705`, 
     25.260151116081904`}}], 
   Line3DBox[{{33, 14, 25}, {32.81101891603998, 12.730568253256589`, 
     25.20695214486752}}], 
   Line3DBox[{{44, 14, 25}, {43.86579285124329, 12.727883293854397`, 
     25.231748845019467`}}], 
   Line3DBox[{{55, 14, 25}, {54.9044717013185, 12.73373100150009, 
     25.278275344917674`}}], 
   Line3DBox[{{38, 15, 25}, {37.84803898763918, 13.722909778823244`, 
     25.18960067957942}}], 
   Line3DBox[{{49, 15, 25}, {48.951090056290184`, 13.721536547988627`, 
     25.230519021508997`}}], 
   Line3DBox[{{32, 16, 25}, {31.8542723117556, 14.730789389442835`, 
     25.24055740879892}}], 
   Line3DBox[{{43, 16, 25}, {42.9034035023831, 14.718291283554509`, 
     25.194658374687044`}}], 
   Line3DBox[{{54, 16, 25}, {53.88979997656742, 14.729920272394686`, 
     25.254466973026894`}}], 
   Line3DBox[{{37, 17, 25}, {36.912075213295935`, 15.718188430230413`, 
     25.198061433620655`}}], 
   Line3DBox[{{48, 17, 25}, {47.91972511870851, 15.719267484520527`, 
     25.208038859897034`}}], 
   Line3DBox[{{31, 18, 25}, {30.867111312528273`, 16.726628461373096`, 
     25.225533858560066`}}], 
   Line3DBox[{{42, 18, 25}, {41.959657348634735`, 16.72015764714218, 
     25.224446034298186`}}], 
   Line3DBox[{{53, 18, 25}, {52.88097498427407, 16.723551166323393`, 
     25.215665065870827`}}], 
   Line3DBox[{{36, 19, 25}, {35.9453416887698, 17.718130447755247`, 
     25.20933924629964}}], 
   Line3DBox[{{47, 19, 25}, {46.90255161774304, 17.720830859934903`, 
     25.21030959060543}}], 
   Line3DBox[{{30, 20, 25}, {29.917123395076196`, 18.725102610428657`, 
     25.240349983192182`}}], 
   Line3DBox[{{41, 20, 25}, {40.982141034107904`, 18.727177128532567`, 
     25.263823795755165`}}], 
   Line3DBox[{{52, 20, 25}, {51.90469277324295, 18.723509301553904`, 
     25.226909738240728`}}], 
   Line3DBox[{{35, 21, 25}, {34.99637658004994, 19.725313500793654`, 
     25.255266918281492`}}], 
   Line3DBox[{{46, 21, 25}, {45.88411100021005, 19.724675417827783`, 
     25.223868152792992`}}], 
   Line3DBox[{{29, 22, 25}, {28.976547555954436`, 20.721621922512167`, 
     25.23494568280095}}], 
   Line3DBox[{{40, 22, 25}, {39.94985850403539, 20.71628417525076, 
     25.19889573065003}}], 
   Line3DBox[{{51, 22, 25}, {50.92942572168393, 20.714433702488172`, 
     25.179829268868836`}}], 
   Line3DBox[{{34, 23, 25}, {34.018478290031844`, 21.726899992815696`, 
     25.262440325607212`}}], 
   Line3DBox[{{45, 23, 25}, {44.873666969424235`, 21.72473806384645, 
     25.21851077681303}}], 
   Line3DBox[{{28, 24, 25}, {27.991092024806854`, 22.716542373347934`, 
     25.20653611927846}}], 
   Line3DBox[{{39, 24, 25}, {38.961566178548736`, 22.707111357575865`, 
     25.130237474097637`}}], 
   Line3DBox[{{50, 24, 25}, {49.954682632798395`, 22.706886636543345`, 
     25.12571461919656}}], 
   Line3DBox[{{33, 25, 25}, {33.00808694544844, 23.713098889260017`, 
     25.18390250811099}}], 
   Line3DBox[{{44, 25, 25}, {43.90420195740538, 23.71801586899206, 
     25.193234114169467`}}], 
   Line3DBox[{{55, 25, 25}, {54.902732858467594`, 23.714773898759006`, 
     25.169508028916}}], 
   Line3DBox[{{38, 26, 25}, {38.00818351803138, 24.700395263947463`, 
     25.03099290342077}}], 
   Line3DBox[{{49, 26, 25}, {48.935998038299644`, 24.704585810567927`, 
     25.088350589791737`}}], 
   Line3DBox[{{32, 27, 25}, {32.02422955865778, 25.703193306816512`, 
     25.087780003427618`}}], 
   Line3DBox[{{43, 27, 25}, {42.938448439032555`, 25.706419682420627`, 
     25.11340796847541}}], 
   Line3DBox[{{54, 27, 25}, {53.91637493552291, 25.70533801608804, 
     25.082808188027183`}}], 
   Line3DBox[{{37, 1, 26}, {37.12128923524963, 2.294329429955649, 
     26.000498159860232`}}], 
   Line3DBox[{{48, 1, 26}, {47.96637188363899, -0.2957126349943908, 
     26.099989585987263`}}], 
   Line3DBox[{{31, 2, 26}, {30.965170944150834`, 0.7026441495876272, 
     26.07519796718957}}], 
   Line3DBox[{{42, 2, 26}, {41.89958812749836, 0.7073282721922578, 
     26.094431244761786`}}], 
   Line3DBox[{{53, 2, 26}, {52.927503517087736`, 0.7038791026232796, 
     26.069389331663572`}}], 
   Line3DBox[{{36, 3, 26}, {35.85121511989622, 1.7095810112366268`, 
     26.051786995388966`}}], 
   Line3DBox[{{47, 3, 26}, {46.865720526558995`, 1.7143955942626599`, 
     26.13852918451051}}], 
   Line3DBox[{{30, 4, 26}, {29.883735204172396`, 2.71029053667503, 
     26.114594927728863`}}], 
   Line3DBox[{{41, 4, 26}, {40.85666019162581, 2.7132523856664994`, 
     26.117193328915484`}}], 
   Line3DBox[{{52, 4, 26}, {51.914854499026106`, 2.70981647451279, 
     26.13482104518694}}], 
   Line3DBox[{{35, 5, 26}, {34.799287233089366`, 3.717048365133987, 
     26.061233061279854`}}], 
   Line3DBox[{{46, 5, 26}, {45.841232363845755`, 3.723466513696197, 
     26.18776340446171}}], 
   Line3DBox[{{29, 6, 26}, {28.84729439982, 4.715105717113351, 
     26.12541005334051}}], 
   Line3DBox[{{40, 6, 26}, {39.849271282520625`, 4.716076894731081, 
     26.13719443678095}}], 
   Line3DBox[{{51, 6, 26}, {50.87271422336131, 4.723927120560898, 
     26.213158010465207`}}], 
   Line3DBox[{{34, 7, 26}, {33.78842285913279, 5.719352404881529, 
     26.071950334118267`}}], 
   Line3DBox[{{45, 7, 26}, {44.85025255763167, 5.730534135165238, 
     26.236711050699945`}}], 
   Line3DBox[{{28, 8, 26}, {27.895096274588564`, 6.712805152911205, 
     26.148743517582627`}}], 
   Line3DBox[{{39, 8, 26}, {38.80603576233852, 6.723528578511658, 
     26.151652842478914`}}], 
   Line3DBox[{{50, 8, 26}, {49.81685160757634, 6.728532101947966, 
     26.19956465262108}}], 
   Line3DBox[{{33, 9, 26}, {32.773078404821916`, 7.721897410175211, 
     26.07042981985637}}], 
   Line3DBox[{{44, 9, 26}, {43.831753415928986`, 7.736949112420763, 
     26.257673324839292`}}], 
   Line3DBox[{{55, 9, 26}, {54.87355499790221, 7.726878760725734, 
     26.230594821176123`}}], 
   Line3DBox[{{38, 10, 26}, {37.841329437921004`, 8.727698812693127, 
     26.21464701606837}}], 
   Line3DBox[{{49, 10, 26}, {48.84198356884335, 8.729344581466464, 
     26.224645531528843`}}], 
   Line3DBox[{{32, 11, 26}, {31.802287763753693`, 9.720231371511643, 
     26.114464532391096`}}], 
   Line3DBox[{{43, 11, 26}, {42.81352992232621, 9.740724566265254, 
     26.26354182234419}}], 
   Line3DBox[{{54, 11, 26}, {53.89936987701233, 9.723208996214156, 
     26.222886318555048`}}], 
   Line3DBox[{{37, 12, 26}, {36.84506257032983, 10.722363424094661`, 
     26.183409849234124`}}], 
   Line3DBox[{{48, 12, 26}, {47.87213814468758, 10.73290715298042, 
     26.26101161466089}}], 
   Line3DBox[{{31, 13, 26}, {30.793150498064094`, 11.729248468692195`, 
     26.18001063642944}}], 
   Line3DBox[{{42, 13, 26}, {41.82001072155949, 11.736131492081862`, 
     26.245438901438312`}}], 
   Line3DBox[{{53, 13, 26}, {52.90094967855389, 11.731148038220846`, 
     26.264959870377794`}}], 
   Line3DBox[{{36, 14, 26}, {35.83192994853433, 12.72200146224909, 
     26.168737059672324`}}], 
   Line3DBox[{{47, 14, 26}, {46.90358949899179, 12.723691379665686`, 
     26.227467186547127`}}], 
   Line3DBox[{{30, 15, 26}, {29.8415466638003, 13.72646442548551, 
     26.207363643614872`}}], 
   Line3DBox[{{41, 15, 26}, {40.846301937878124`, 13.728349669719222`, 
     26.22199626842983}}], 
   Line3DBox[{{52, 15, 26}, {51.919150238444196`, 13.7288231920852, 
     26.259947762206004`}}], 
   Line3DBox[{{35, 16, 26}, {34.877719337055936`, 14.722902609060068`, 
     26.209927829323263`}}], 
   Line3DBox[{{46, 16, 26}, {45.92835818120914, 14.715135704587016`, 
     26.184367004025223`}}], 
   Line3DBox[{{29, 17, 26}, {28.861258641669888`, 15.73028973464108, 
     26.242046849867734`}}], 
   Line3DBox[{{40, 17, 26}, {39.897676235946754`, 15.720948384061987`, 
     26.208702685838812`}}], 
   Line3DBox[{{51, 17, 26}, {50.91015706895946, 15.719867818773897`, 
     26.207821669542295`}}], 
   Line3DBox[{{34, 18, 26}, {33.9099787068275, 16.723466511517643`, 
     26.228819622319882`}}], 
   Line3DBox[{{45, 18, 26}, {44.91594136064896, 16.715543178769295`, 
     26.1819472988103}}], 
   Line3DBox[{{28, 19, 26}, {27.86302917686952, 17.727609611332706`, 
     26.228608163542013`}}], 
   Line3DBox[{{39, 19, 26}, {38.989364283302, 17.719933150750546`, 
     26.22652978387598}}], 
   Line3DBox[{{50, 19, 26}, {49.918407632161106`, 17.721369565492555`, 
     26.220106559333765`}}], 
   Line3DBox[{{33, 20, 26}, {32.966977043935444`, 18.727639557105796`, 
     26.26459098195295}}], 
   Line3DBox[{{44, 20, 26}, {43.929087921048186`, 18.725781924469825`, 
     26.24766867595825}}], 
   Line3DBox[{{55, 20, 26}, {54.82863725359598, 18.73101729281536, 
     26.2243160672159}}], 
   Line3DBox[{{38, 21, 26}, {38.00866626714418, 19.718875659421347`, 
     26.220556840271843`}}], 
   Line3DBox[{{49, 21, 26}, {48.92771121514774, 19.721094412224417`, 
     26.221753983371165`}}], 
   Line3DBox[{{32, 22, 26}, {31.977786977509858`, 20.728945917560104`, 
     26.27189722533473}}], 
   Line3DBox[{{43, 22, 26}, {42.87661445409009, 20.726669153642224`, 
     26.231094272482697`}}], 
   Line3DBox[{{54, 22, 26}, {53.89645055075731, 20.71355902575176, 
     26.156035673282656`}}], 
   Line3DBox[{{37, 23, 26}, {37.02682417103498, 21.714809868367787`, 
     26.193821540091566`}}], 
   Line3DBox[{{48, 23, 26}, {47.911776909242775`, 21.71726126236889, 
     26.19182809293164}}], 
   Line3DBox[{{31, 24, 26}, {31.011509757740438`, 22.72189153175678, 
     26.237289420079623`}}], 
   Line3DBox[{{42, 24, 26}, {41.89236828139004, 22.718842553924844`, 
     26.192486393065188`}}], 
   Line3DBox[{{53, 24, 26}, {52.90965373054825, 22.70886292707234, 
     26.12166597925446}}], 
   Line3DBox[{{36, 25, 26}, {36.0409369511135, 23.70589498968871, 
     26.116689281087613`}}], 
   Line3DBox[{{47, 25, 26}, {46.93004069648244, 23.713373648662508`, 
     26.1723320280601}}], 
   Line3DBox[{{30, 26, 26}, {30.028091880195916`, 24.70997766602954, 
     26.158282102982188`}}], 
   Line3DBox[{{41, 26, 26}, {40.93532602221231, 24.703449387138207`, 
     26.06909258198116}}], 
   Line3DBox[{{52, 26, 26}, {51.91382603041373, 24.704601729742684`, 
     26.06721137091366}}], 
   Line3DBox[{{35, 27, 26}, {35.037770964310525`, 25.700868837667066`, 
     26.028837082212625`}}], 
   Line3DBox[{{46, 27, 26}, {45.929475839360656`, 25.715607450059384`, 
     26.188048186439428`}}], 
   Line3DBox[{{29, 1, 27}, {28.958975094502005`, -0.2992963214898723, 
     26.987915874389614`}}], 
   Line3DBox[{{40, 1, 27}, {39.946029370460565`, -0.2988488562898708, 
     26.9911219562058}}], 
   Line3DBox[{{51, 1, 27}, {51.01645054374359, -0.29932005484360524`, 
     27.03868817250467}}], 
   Line3DBox[{{34, 2, 27}, {33.94465603230069, 0.7017614510920271, 
     27.038906495198354`}}], 
   Line3DBox[{{45, 2, 27}, {44.890545286251346`, 0.7118226699935246, 
     27.136450841315064`}}], 
   Line3DBox[{{28, 3, 27}, {27.943927272937305`, 1.702447627412396, 
     27.056689414109087`}}], 
   Line3DBox[{{39, 3, 27}, {38.870302841846176`, 1.7065929045667654`, 
     27.01663528327941}}], 
   Line3DBox[{{50, 3, 27}, {49.91964676786684, 1.7099367557440386`, 
     27.13885310189383}}], 
   Line3DBox[{{33, 4, 27}, {32.88098914949801, 2.706919388056243, 
     27.06147315249727}}], 
   Line3DBox[{{44, 4, 27}, {43.85292714368773, 2.7198599215657495`, 
     27.172078338330255`}}], 
   Line3DBox[{{55, 4, 27}, {54.9379694223767, 2.71156715703102, 
     27.161533329683355`}}], 
   Line3DBox[{{38, 5, 27}, {37.82761638094815, 3.7134847134887368`, 
     27.071849185488986`}}], 
   Line3DBox[{{49, 5, 27}, {48.8627255642407, 3.726363218594841, 
     27.221370906712856`}}], 
   Line3DBox[{{32, 6, 27}, {31.836463971087177`, 4.712089600696595, 
     27.06740007873562}}], 
   Line3DBox[{{43, 6, 27}, {42.85944611832507, 4.726697187221008, 
     27.221234159467336`}}], 
   Line3DBox[{{54, 6, 27}, {53.87398136394755, 4.722834429872025, 
     27.207285816801736`}}], 
   Line3DBox[{{37, 7, 27}, {36.79642215658982, 5.719439713706329, 
     27.093388515567657`}}], 
   Line3DBox[{{48, 7, 27}, {47.82836328176441, 5.72885862454763, 
     27.211519362154807`}}], 
   Line3DBox[{{31, 8, 27}, {30.80528234933498, 6.717283299681679, 
     27.081993312190537`}}], 
   Line3DBox[{{42, 8, 27}, {41.86355880966793, 6.729198989460658, 
     27.23758912684076}}], 
   Line3DBox[{{53, 8, 27}, {52.85396769008986, 6.725801235196426, 
     27.21234893980275}}], 
   Line3DBox[{{36, 9, 27}, {35.80101139481635, 7.724737065486645, 
     27.155267455905776`}}], 
   Line3DBox[{{47, 9, 27}, {46.86338502963201, 7.724685307401562, 
     27.211916928804442`}}], 
   Line3DBox[{{30, 10, 27}, {29.848154452762998`, 8.716075810101222, 
     27.135947064613624`}}], 
   Line3DBox[{{41, 10, 27}, {40.84173330456193, 8.736219659398042, 
     27.260405268424254`}}], 
   Line3DBox[{{52, 10, 27}, {51.904937773961855`, 8.722251385930921, 
     27.219821865211856`}}], 
   Line3DBox[{{35, 11, 27}, {34.81356591739314, 9.72282430194715, 
     27.15512758989216}}], 
   Line3DBox[{{46, 11, 27}, {45.83994513351504, 9.737087744076248, 
     27.263505357729333`}}], 
   Line3DBox[{{29, 12, 27}, {28.840707402121186`, 10.724656381741307`, 
     27.19525502202976}}], 
   Line3DBox[{{40, 12, 27}, {39.8369391662483, 10.732652472627384`, 
     27.239251769813137`}}], 
   Line3DBox[{{51, 12, 27}, {50.91019640180979, 10.728964204172364`, 
     27.257688415488353`}}], 
   Line3DBox[{{34, 13, 27}, {33.79657937719206, 11.72901906212688, 
     27.182284134744616`}}], 
   Line3DBox[{{45, 13, 27}, {44.83208449121636, 11.7393900778097, 
     27.269568184297214`}}], 
   Line3DBox[{{28, 14, 27}, {27.898992784014748`, 12.726468489798258`, 
     27.240655427618368`}}], 
   Line3DBox[{{39, 14, 27}, {38.81849803494533, 12.73141144574752, 
     27.218495118254154`}}], 
   Line3DBox[{{50, 14, 27}, {49.93371421298809, 12.73237827046865, 
     27.280608883074226`}}], 
   Line3DBox[{{33, 15, 27}, {32.84865935024161, 13.729327534377607`, 
     27.22910149026101}}], 
   Line3DBox[{{44, 15, 27}, {43.871350697942525`, 13.723091701653523`, 
     27.207254806202492`}}], 
   Line3DBox[{{55, 15, 27}, {54.8811656349697, 13.737613977357286`, 
     27.286809908343756`}}], 
   Line3DBox[{{38, 16, 27}, {37.86421613574976, 14.72387573801659, 
     27.207532190723676`}}], 
   Line3DBox[{{49, 16, 27}, {48.98766610365936, 14.720084690348376`, 
     27.22729864742326}}], 
   Line3DBox[{{32, 17, 27}, {31.869513741970724`, 15.728681363619154`, 
     27.238164357652998`}}], 
   Line3DBox[{{43, 17, 27}, {42.92571377316988, 15.71769215603218, 
     27.200419933644202`}}], 
   Line3DBox[{{54, 17, 27}, {53.884861915522826`, 15.732608477652171`, 
     27.265446700080787`}}], 
   Line3DBox[{{37, 18, 27}, {36.94672284394569, 16.7194949790234, 
     27.217872522123553`}}], 
   Line3DBox[{{48, 18, 27}, {47.91596269140921, 16.71701238568937, 
     27.19204299594188}}], 
   Line3DBox[{{31, 19, 27}, {30.888185165717406`, 17.725641313038775`, 
     27.231316622404925`}}], 
   Line3DBox[{{42, 19, 27}, {41.95309270729244, 17.721246534687307`, 
     27.229323528757142`}}], 
   Line3DBox[{{53, 19, 27}, {52.85054007853068, 17.73146343497902, 
     27.2418195920085}}], 
   Line3DBox[{{36, 20, 27}, {35.97259711658041, 18.720345698126145`, 
     27.22745098301838}}], 
   Line3DBox[{{47, 20, 27}, {46.917934512259556`, 18.720065156816744`, 
     27.21220757038188}}], 
   Line3DBox[{{30, 21, 27}, {29.94860176152247, 19.725530297389348`, 
     27.25116766951366}}], 
   Line3DBox[{{41, 21, 27}, {40.95386573158874, 19.723046103497776`, 
     27.239291402866762`}}], 
   Line3DBox[{{52, 21, 27}, {51.90071846208946, 19.717754156615655`, 
     27.18970707249252}}], 
   Line3DBox[{{35, 22, 27}, {35.01152276151434, 20.727007160151633`, 
     27.26335613845489}}], 
   Line3DBox[{{46, 22, 27}, {45.85911970542438, 20.726949183545525`, 
     27.222473282272013`}}], 
   Line3DBox[{{29, 23, 27}, {28.98798791936817, 21.72384398178487, 
     27.247551059565907`}}], 
   Line3DBox[{{40, 23, 27}, {39.94211497953134, 21.71530957675986, 
     27.190315109332946`}}], 
   Line3DBox[{{51, 23, 27}, {50.953258597474246`, 21.710348344361247`, 
     27.156888012283112`}}], 
   Line3DBox[{{34, 24, 27}, {34.03563043407164, 22.722731741708397`, 
     27.239408163036696`}}], 
   Line3DBox[{{45, 24, 27}, {44.88484209967658, 22.72777254751209, 
     27.24119694676596}}], 
   Line3DBox[{{28, 25, 27}, {28.038967056568396`, 23.718624914026922`, 
     27.215776406379103`}}], 
   Line3DBox[{{39, 25, 27}, {38.988488882969236`, 23.703041096877236`, 
     27.08811979230173}}], 
   Line3DBox[{{50, 25, 27}, {49.9380952121952, 23.706856099837516`, 
     27.11809593862366}}], 
   Line3DBox[{{33, 26, 27}, {33.036388810940295`, 24.706909295731215`, 
     27.128811043672542`}}], 
   Line3DBox[{{44, 26, 27}, {43.90271289246612, 24.720364786377193`, 
     27.2075305730831}}], 
   Line3DBox[{{55, 26, 27}, {54.948869640784636`, 24.707568426295705`, 
     27.13040825763252}}], 
   Line3DBox[{{38, 27, 27}, {38.046616076506254`, 25.700876593387278`, 
     26.98973765123759}}], 
   Line3DBox[{{49, 27, 27}, {48.972105478794056`, 25.702872817959292`, 
     27.081749429954115`}}], 
   {RGBColor[0, 0, 1], PointSize[Large], Point3DBox[CompressedData["
1:eJyF1FtqwzAUhGGTrqQmGCOE0CWQW3NZQ5dQKPStW8jSU6jGJX87NBCEv0yO
T2TlPL99vr6vhmH4+Ho/DXodr9/r1Nexr7u+BuPReIJvUX/d14Nx5Wfjwbiu
J+Oqpz7VXzD5gHwx3v6po33a97XCWUe+xXVCvsBZn/kGZ58ZdejKV7jqa3+L
yRfkm8mrjr63N87zwDxd+WQ8Gy/wHa7p6rPBg/FoPMEPxpXPxgv8aFz1K5z7
uYFH48l4hp/6qvM29vVs/GL82tcZ/oL+WZ+ufqpxXa/hnGPnv/3GPpXX7+J8
k8dHX+pk5HXfAlefzeTpqq9+Jng0nuGqXx996d+57jubvPZP3oyPqEfX7+C5
irgv57l8MnnOeTnm9q98Qp5zm31mOOczz1uBR+MZzuco5/9Cn6sfzm2eczrm
87I/zjm3ef7l3Getmg+cqyfj7IfOOcznLufzonN+yn/m5x0WfpFS
     "]]}, 
   {GrayLevel[0], PointSize[Large], Point3DBox[CompressedData["
1:eJyF3cuOZOlWZWEXJSSaNKpBgwa4UCmVOjrKTC4FnIrAuN96PAIS7XqFemQe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     "]]}},
  AutomaticImageSize->True,
  Axes->True,
  AxesLabel->{None, None, None},
  BoxRatios->{1, 1, 0.4},
  FaceGridsStyle->Automatic,
  ImageSize->{421.2647842662672, 345.7888766359859},
  PlotRange->{{0, 56}, {0, 28}, {0, 28}},
  PlotRangePadding->{{Automatic, Automatic}, {Automatic, Automatic}, {
    Automatic, Automatic}},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{-2.7781365652799854`, 0.7332074674873786, -1.7872783874581721`},
  
  ViewVertical->{-0.16158588282046127`, -0.22610376729847237`, \
-2.4015191661823283`}]], "Output",
 CellChangeTimes->{
  3.763483505384389*^9, 3.76348368542356*^9, 3.76348378228654*^9, 
   3.763483837358118*^9, 3.7634841901065397`*^9, 3.763484248029972*^9, {
   3.763484628980213*^9, 3.763484667330143*^9}, 3.763484889835682*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPointPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "maxX"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "maxY"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "maxZ"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"directors", "[", 
    RowBox[{"[", 
     RowBox[{";;", ";;", "121"}], "]"}], "]"}], ",", 
   RowBox[{"ListPointPlot3D", "[", 
    RowBox[{
     RowBox[{"{", "lowE", "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Black", ",", 
         RowBox[{"PointSize", "[", "Large", "]"}]}], "}"}], "}"}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.763483314099983*^9, {3.763483893774988*^9, 3.7634838946027327`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.763491018477477*^9, 3.7634910184907093`*^9}}]
},
WindowSize->{886, 755},
WindowMargins->{{Automatic, 111}, {Automatic, 49}},
FrontEndVersion->"10.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (September 9, \
2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1608, 51, 114, "Input"],
Cell[CellGroupData[{
Cell[2191, 75, 5410, 162, 369, "Input"],
Cell[7604, 239, 1493, 21, 28, "Output"],
Cell[9100, 262, 1493, 21, 28, "Output"],
Cell[10596, 285, 1495, 21, 28, "Output"],
Cell[12094, 308, 1495, 21, 28, "Output"],
Cell[13592, 331, 1604, 25, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15233, 361, 130, 2, 28, "Input"],
Cell[15366, 365, 222, 4, 28, "Output"]
}, Open  ]],
Cell[15603, 372, 963, 25, 46, "Input"],
Cell[16569, 399, 94, 1, 28, InheritFromParent],
Cell[16666, 402, 463, 16, 28, "Input"],
Cell[CellGroupData[{
Cell[17154, 422, 1671, 43, 63, "Input"],
Cell[18828, 467, 382158, 7756, 361, "Output"]
}, Open  ]],
Cell[401001, 8226, 1049, 30, 63, "Input"],
Cell[402053, 8258, 94, 1, 28, InheritFromParent]
}
]
*)

(* End of internal cache information *)
