(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    360028,       6689]
NotebookOptionsPosition[    354640,       6599]
NotebookOutlinePosition[    354982,       6614]
CellTagsIndexPosition[    354939,       6611]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Helpful functions -- run this cell first!", "Chapter",
 CellChangeTimes->{{3.7778953569256163`*^9, 3.77789536002927*^9}, {
  3.777897160736435*^9, 
  3.77789716951394*^9}},ExpressionUUID->"80329862-79f8-4d19-8170-\
b56ed24eabb3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Set", " ", "a", " ", "simple", " ", "nematic", " ", "Q"}], "-", 
    RowBox[{
    "tensor", " ", "with", " ", "desired", " ", "direction", " ", "and", " ", 
     "strength"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Q", "[", 
     RowBox[{"n_", ",", "S_"}], "]"}], ":=", 
    RowBox[{"3", 
     FractionBox["S", "2"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"TensorProduct", "[", 
        RowBox[{"n", ",", "n"}], "]"}], "-", 
       FractionBox[
        RowBox[{"IdentityMatrix", "[", "3", "]"}], "3"]}], ")"}]}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"objectQvalue", "[", 
      RowBox[{"boundaryType_", ",", "S0_", ",", "direction_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "vec", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"vec", " ", "=", " ", "direction"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Norm", "[", "vec", "]"}], "\[NotEqual]", "1"}], ",", 
          RowBox[{"vec", "=", 
           RowBox[{"1.0", 
            FractionBox["vec", 
             RowBox[{"Norm", "[", "vec", "]"}]]}]}], ",", 
          RowBox[{"vec", "=", 
           RowBox[{"1.0", " ", "vec"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"boundaryType", "\[Equal]", "0"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{"for", " ", "oriented", " ", "anchoring"}], ",", " ", 
            RowBox[{
             RowBox[{"the", " ", "Q"}], "-", 
             RowBox[{
             "tensor", " ", "is", " ", "the", " ", "target", " ", "Q"}], "-", 
             "tensor"}]}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"q", "=", 
           RowBox[{"Q", "[", 
            RowBox[{"vec", ",", "S0"}], "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{
            "for", " ", "degenerate", " ", "planar", " ", "anchoring"}], ",", 
            " ", 
            RowBox[{
             RowBox[{"the", " ", "Q"}], "-", 
             RowBox[{
             "tensor", " ", "takes", " ", "a", " ", "simpler", " ", "but", 
              " ", "more", " ", "specialized", " ", "form"}]}]}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"q", "=", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"q", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", 
            RowBox[{"vec", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", 
           RowBox[{
            RowBox[{"q", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", 
            RowBox[{"vec", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", 
           RowBox[{
            RowBox[{"q", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "3"}], "]"}], "]"}], "=", 
            RowBox[{"vec", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}]}]}], "\[IndentingNewLine]", 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Chop", "[", "q", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"writeBoundaryFile", "[", 
      RowBox[{
      "fname_", ",", "objects_", ",", "boundaries_", ",", "nEntries_"}], 
      "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"str", ",", "firstLine", ",", "writeString"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"str", "=", 
         RowBox[{"OpenWrite", "[", "fname", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"firstLine", " ", "=", " ", 
         RowBox[{"IntegerString", "[", 
          RowBox[{"Length", "[", "objects", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"WriteLine", "[", 
         RowBox[{"str", ",", "firstLine"}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"loop", " ", "over", " ", "objects"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"Do", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"writeString", "=", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"IntegerString", "[", 
               RowBox[{"boundaries", "[", 
                RowBox[{"[", 
                 RowBox[{"oo", ",", "1"}], "]"}], "]"}], "]"}], "<>", 
              "\"\< \>\"", "<>", 
              RowBox[{"ToString", "[", 
               RowBox[{"boundaries", "[", 
                RowBox[{"[", 
                 RowBox[{"oo", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
              "\"\< \>\"", "<>", 
              RowBox[{"ToString", "[", 
               RowBox[{"boundaries", "[", 
                RowBox[{"[", 
                 RowBox[{"oo", ",", "3"}], "]"}], "]"}], "]"}], "<>", 
              "\"\< \>\"", "<>", 
              RowBox[{"IntegerString", "[", 
               RowBox[{"nEntries", "[", 
                RowBox[{"[", "oo", "]"}], "]"}], "]"}]}], "}"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"WriteLine", "[", 
            RowBox[{"str", ",", 
             RowBox[{"writeString", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Do", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"WriteLine", "[", 
               RowBox[{"str", ",", 
                RowBox[{"objects", "[", 
                 RowBox[{"[", 
                  RowBox[{"oo", ",", "i"}], "]"}], "]"}]}], "]"}], ";"}], 
             "\[IndentingNewLine]", ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", 
               RowBox[{"nEntries", "[", 
                RowBox[{"[", "oo", "]"}], "]"}]}], "}"}]}], "]"}], ";"}], 
          "\[IndentingNewLine]", ",", 
          RowBox[{"{", 
           RowBox[{"oo", ",", "1", ",", 
            RowBox[{"Length", "[", "objects", "]"}]}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Close", "[", "str", "]"}]}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"getFileString", "[", 
     RowBox[{"position_", ",", "q_"}], "]"}], ":=", 
    RowBox[{"ToString", "[", 
     RowBox[{
      RowBox[{"IntegerString", "[", 
       RowBox[{"position", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}], "<>", "\"\< \>\"", "<>", 
      RowBox[{"IntegerString", "[", 
       RowBox[{"position", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "<>", "\"\< \>\"", "<>", 
      RowBox[{"IntegerString", "[", 
       RowBox[{"position", "[", 
        RowBox[{"[", "3", "]"}], "]"}], "]"}], "<>", "\"\< \>\"", "<>", 
      RowBox[{"ToString", "[", 
       RowBox[{"q", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}], "]"}], "<>", "\"\< \>\"", "<>", 
      RowBox[{"ToString", "[", 
       RowBox[{"q", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}], "]"}], "<>", "\"\< \>\"", "<>", 
      RowBox[{"ToString", "[", 
       RowBox[{"q", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "3"}], "]"}], "]"}], "]"}], "<>", "\"\< \>\"", "<>", 
      RowBox[{"ToString", "[", 
       RowBox[{"q", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "2"}], "]"}], "]"}], "]"}], "<>", "\"\< \>\"", "<>", 
      RowBox[{"ToString", "[", 
       RowBox[{"q", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "3"}], "]"}], "]"}], "]"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.777895330534238*^9, 3.7778953469462843`*^9}, {
  3.7778966637985*^9, 3.777896778629077*^9}, {3.777897157081265*^9, 
  3.777897157485136*^9}, {3.7778976582641478`*^9, 3.7778976830937*^9}, {
  3.7778977264137373`*^9, 3.777897733838831*^9}, {3.777897796395417*^9, 
  3.7778977976082134`*^9}, {3.7778980009159937`*^9, 3.777898005870691*^9}},
 CellLabel->"In[66]:=",ExpressionUUID->"0b382618-4e01-4187-b2b2-b7910692c338"]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 1: Creating a sphere with oriented anchoring", "Chapter",
 CellChangeTimes->{{3.7778034706809425`*^9, 3.77780347871329*^9}, {
  3.777895369190738*^9, 3.7778953697981324`*^9}, {3.777897216400483*^9, 
  3.777897219114209*^9}},ExpressionUUID->"98b88dd6-fd7e-479b-9143-\
e603b1abb960"],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", 
  RowBox[{
  "We", " ", "start", " ", "out", " ", "with", " ", "a", " ", "simple", " ", 
   "example", " ", "of", " ", "a", " ", "custom", " ", "boundary", " ", 
   RowBox[{"file", ":", "\[IndentingNewLine]", " ", 
    RowBox[{
    "adding", " ", "a", " ", "sphere", " ", "with", " ", "normal", " ", 
     "oriented", " ", "anchoring", " ", "to", " ", "the", " ", "middle", " ", 
     "of", " ", "a", " ", "small", " ", "simulation", " ", "domain"}]}]}], 
  "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.777895513629097*^9, 3.777895560768922*^9}},
 CellLabel->
  "In[146]:=",ExpressionUUID->"1550ad8b-865e-40ca-becb-159fd5e5d8ed"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"output", " ", "file", " ", "name"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
    "fileName", "=", 
     "\"\<C:\\\\Users\\\\dmsussm\\\\Desktop\\\\oneSphereExample.txt\>\""}], 
    ";"}], "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
       "Size", " ", "of", " ", "the", " ", "domain", " ", "into", " ", 
        "which", " ", "the", " ", "object", " ", "will", " ", "be", " ", 
        "put"}], "..."}], " ", "each", " ", "line", " ", "is", " ", "the", 
      " ", "maximum", " ", "INDEX", " ", "of", " ", "the", " ", "system", " ",
       "in", " ", "that", " ", "dimension"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
      "so", " ", "writing", " ", "\"\<49\>\"", " ", "below", " ", "means", 
       " ", "I", " ", "intend", " ", "to", " ", "load", " ", "this", " ", 
       "file", " ", "with", " ", "the", " ", "flag"}], " ", "-", 
      RowBox[{"l", " ", "50"}]}], ",", " ", 
     RowBox[{
     "for", " ", "lattice", " ", "sites", " ", "indexed", " ", "0", " ", "to",
       " ", "49"}]}], "*)"}], "\n", 
   RowBox[{
    RowBox[{"xMax", "=", "49"}], ";", 
    RowBox[{"yMax", "=", "49"}], ";", 
    RowBox[{"zMax", "=", "49"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7778953821800013`*^9, 3.7778953905994673`*^9}, {
   3.7778954411929817`*^9, 3.7778954593434405`*^9}, 3.7778957252066593`*^9, {
   3.7778962888362164`*^9, 3.777896349578627*^9}, {3.7778965993350534`*^9, 
   3.777896608749861*^9}, {3.7778968619420767`*^9, 3.7778968679001617`*^9}},
 CellLabel->
  "In[147]:=",ExpressionUUID->"01ed2569-4221-4a69-a1f5-40046ae6c2b1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "There", " ", "are", " ", "many", " ", "ways", " ", "to", " ", "do", " ",
       "this"}], "..."}], " ", 
    RowBox[{"here", "'"}], "s", " ", "one", " ", "way", " ", "to", " ", 
    "identify", " ", "lattice", " ", "sites", " ", "that", " ", "are", " ", 
    "inside", " ", "the", " ", "sphere"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"desiredRadius", "=", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sphereCenter", "=", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["xMax", "2"], ",", 
       FractionBox["yMax", "2"], ",", 
       FractionBox["zMax", "2"]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "define", " ", "a", " ", "region", " ", "and", " ", "a", " ", "member", 
     " ", "function", " ", "for", " ", "that", " ", "region"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"region", "=", 
     RowBox[{"Ball", "[", 
      RowBox[{"sphereCenter", ",", "desiredRadius"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"memberFunction", "=", 
     RowBox[{"RegionMember", "[", "region", "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7778954017306232`*^9, 3.7778954393339567`*^9}, {
  3.777895606934286*^9, 3.7778957683761187`*^9}, {3.777895960864843*^9, 
  3.7778959816910963`*^9}},
 CellLabel->
  "In[149]:=",ExpressionUUID->"a04581c7-afe2-48a9-9ccc-0dde6c0a43fb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "We", " ", "now", " ", "store", " ", "the", " ", "necessary", " ", 
    "information", " ", "as", " ", "entries", " ", "in", " ", 
    "\"\<objectString\>\""}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"bType", "=", "0"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{
      "when", " ", "defining", " ", "the", " ", "boundary", " ", "type"}], 
      ",", " ", 
      RowBox[{
      "0", " ", "is", " ", "oriented", " ", "and", " ", "1", " ", "is", " ", 
       "planar", " ", "degenerate"}]}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"Wb", "=", "5.3"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"strength", " ", "of", " ", "anchoring"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"s0", " ", "=", " ", "0.53"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "target", " ", "degree", " ", "of", " ", "nematic", " ", "order"}], 
     "*)"}], "\[IndentingNewLine]", 
    RowBox[{"objectString", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"Do", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"currentLatticeSite", "=", 
              RowBox[{"{", 
               RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
              "is", " ", "the", " ", "current", " ", "site", " ", "inside", 
               " ", "the", " ", "desired", " ", 
               RowBox[{"sphere", "?"}]}], "*)"}], "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"memberFunction", "[", "currentLatticeSite", "]"}], 
               ",", "\[IndentingNewLine]", 
               RowBox[{"(*", 
                RowBox[{"Find", " ", "the", " ", "outward", " ", "normal"}], 
                "*)"}], "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"vec", "=", 
                 RowBox[{"currentLatticeSite", "-", "sphereCenter"}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"q", "=", 
                 RowBox[{"objectQvalue", "[", 
                  RowBox[{"bType", ",", "s0", ",", "vec"}], "]"}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"AppendTo", "[", 
                 RowBox[{"objectString", ",", 
                  RowBox[{"getFileString", "[", 
                   RowBox[{"currentLatticeSite", ",", "q"}], "]"}]}], "]"}], 
                ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], 
            "\[IndentingNewLine]", ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"Floor", "[", 
               RowBox[{
                RowBox[{"Floor", "[", 
                 RowBox[{"sphereCenter", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "]"}], "-", 
                "desiredRadius"}], "]"}], ",", 
              RowBox[{"Ceiling", "[", 
               RowBox[{
                RowBox[{"Ceiling", "[", 
                 RowBox[{"sphereCenter", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "]"}], "+", 
                "desiredRadius"}], "]"}]}], "}"}]}], "]"}], ";"}], 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", 
           RowBox[{"Floor", "[", 
            RowBox[{
             RowBox[{"Floor", "[", 
              RowBox[{"sphereCenter", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], "-", "desiredRadius"}], 
            "]"}], ",", 
           RowBox[{"Ceiling", "[", 
            RowBox[{
             RowBox[{"Ceiling", "[", 
              RowBox[{"sphereCenter", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], "+", "desiredRadius"}], 
            "]"}]}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"Floor", "[", 
         RowBox[{
          RowBox[{"Floor", "[", 
           RowBox[{"sphereCenter", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "]"}], "-", "desiredRadius"}], 
         "]"}], ",", 
        RowBox[{"Ceiling", "[", 
         RowBox[{
          RowBox[{"Ceiling", "[", 
           RowBox[{"sphereCenter", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "]"}], "+", "desiredRadius"}], 
         "]"}]}], "}"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7778958414046183`*^9, 3.7778958491299095`*^9}, {
  3.777895879296153*^9, 3.777895910234329*^9}, {3.7778959897076254`*^9, 
  3.7778961456651344`*^9}, {3.777896359956803*^9, 3.7778965446135545`*^9}, {
  3.7778966143678284`*^9, 3.777896650681612*^9}, {3.777896792790214*^9, 
  3.7778968553068757`*^9}, {3.7778969278496933`*^9, 3.777896945662019*^9}, {
  3.777897109290005*^9, 3.7778971157517233`*^9}, {3.7778977026363783`*^9, 
  3.777897719518205*^9}, {3.7778977914446898`*^9, 3.7778977923073387`*^9}},
 CellLabel->
  "In[153]:=",ExpressionUUID->"8f12e304-8924-4777-a678-e763725d412a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Save", " ", "to", " ", "file"}], "..."}], " ", "we", " ", 
    "call", " ", "a", " ", "function", " ", "that", " ", "can", " ", "be", 
    " ", "used", " ", "with", " ", "any", " ", "number", " ", "of", " ", 
    "objects", " ", "in", " ", "these", " ", "arrays"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"objects", "=", 
     RowBox[{"{", "objectString", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"boundaries", "=", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"bType", ",", "Wb", ",", "s0"}], "}"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nEntries", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Length", "[", 
        RowBox[{"objects", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "objects", "]"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"writeBoundaryFile", "[", 
    RowBox[{"fileName", ",", "objects", ",", "boundaries", ",", "nEntries"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.751971728917067*^9, 3.7519718004426813`*^9}, {
  3.777896907057308*^9, 3.7778969174993525`*^9}, {3.7778969520907955`*^9, 
  3.777896954776627*^9}, {3.7778970445014315`*^9, 3.777897084624995*^9}},
 CellLabel->
  "In[155]:=",ExpressionUUID->"738be8c1-929f-4ac9-abf0-2d36a7c1140a"],

Cell[BoxData["\<\"C:\\\\Users\\\\dmsussm\\\\Desktop\\\\oneSphereExample.txt\"\
\>"], "Output",
 CellChangeTimes->{
  3.751971810604162*^9, {3.771423547636361*^9, 3.771423568781148*^9}, 
   3.777896956379323*^9, 3.7778970912183466`*^9, 3.777897121585231*^9, 
   3.7778977542930784`*^9, 3.7778979624888496`*^9},
 CellLabel->
  "Out[158]=",ExpressionUUID->"f7cb39aa-1d44-4bd6-8c32-4ce28f5f2db6"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Example 2: Creating two spheres with different anchoring conditions\
\>", "Chapter",
 CellChangeTimes->{{3.7778034706809425`*^9, 3.77780347871329*^9}, {
  3.777895369190738*^9, 3.7778953697981324`*^9}, {3.7778971969645095`*^9, 
  3.777897224754072*^9}},ExpressionUUID->"d92ffe8c-b1ae-40d7-9513-\
e281ddc975d0"],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
   "This", " ", "creates", " ", "two", " ", "smaller", " ", "spheres"}], ",", 
   " ", 
   RowBox[{
   "one", " ", "with", " ", "oriented", " ", "and", " ", "one", " ", "with", 
    " ", "degenerate", " ", "planar", " ", "anchoring"}]}], 
  "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.777895513629097*^9, 3.777895560768922*^9}, {
  3.777897242877722*^9, 3.777897269550642*^9}},
 CellLabel->
  "In[130]:=",ExpressionUUID->"773a61c6-b085-4a87-8cbd-157f2334b42a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"output", " ", "file", " ", "name"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
    "fileName", "=", 
     "\"\<C:\\\\Users\\\\dmsussm\\\\Desktop\\\\twoSphereExample.txt\>\""}], 
    ";"}], "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Size", " ", "of", " ", "the", " ", "domain", " ", "into", " ", "which", 
      " ", "the", " ", "object", " ", "will", " ", "be", " ", "put"}], 
     "..."}], "*)"}], "\n", 
   RowBox[{
    RowBox[{"xMax", "=", "40"}], ";", 
    RowBox[{"yMax", "=", "40"}], ";", 
    RowBox[{"zMax", "=", "40"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7778953821800013`*^9, 3.7778953905994673`*^9}, {
   3.7778954411929817`*^9, 3.7778954593434405`*^9}, 3.7778957252066593`*^9, {
   3.7778962888362164`*^9, 3.777896349578627*^9}, {3.7778965993350534`*^9, 
   3.777896608749861*^9}, {3.7778968619420767`*^9, 3.7778968679001617`*^9}, {
   3.7778972741902037`*^9, 3.7778972743527656`*^9}, {3.777899746246645*^9, 
   3.777899747789527*^9}, {3.777899788185421*^9, 3.77789978927849*^9}, {
   3.777899957991063*^9, 3.777899962230728*^9}, {3.777900234327339*^9, 
   3.77790023774518*^9}, {3.7779003461940956`*^9, 
   3.777900355119018*^9}},ExpressionUUID->"a5a5a19f-b249-4e78-85a5-\
48e8af46ec42"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"We", "'"}], "ll", " ", "make", " ", "the", " ", "spheres", " ", 
     "the", " ", "same", " ", "size"}], ",", " ", 
    RowBox[{"but", " ", "locate", " ", "them", " ", "separately"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"desiredRadius", "=", "5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sphereCenter1", "=", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["xMax", "3"], ",", 
       FractionBox["yMax", "3"], ",", 
       FractionBox["zMax", "3"]}], "}"}]}], ";", 
    RowBox[{"sphereCenter2", "=", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{"2", "xMax"}], "3"], ",", 
       FractionBox[
        RowBox[{"2", "yMax"}], "3"], ",", 
       FractionBox[
        RowBox[{"2", "zMax"}], "3"]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "define", " ", "a", " ", "region", " ", "and", " ", "a", " ", "member", 
     " ", "function", " ", "for", " ", "that", " ", "region"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"region1", "=", 
     RowBox[{"Ball", "[", 
      RowBox[{"sphereCenter1", ",", "desiredRadius"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"memberFunction1", "=", 
     RowBox[{"RegionMember", "[", "region1", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"region2", "=", 
     RowBox[{"Ball", "[", 
      RowBox[{"sphereCenter2", ",", "desiredRadius"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"memberFunction2", "=", 
     RowBox[{"RegionMember", "[", "region2", "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7778954017306232`*^9, 3.7778954393339567`*^9}, {
   3.777895606934286*^9, 3.7778957683761187`*^9}, {3.777895960864843*^9, 
   3.7778959816910963`*^9}, {3.777897284407854*^9, 3.7778973005266943`*^9}, {
   3.7778973439334793`*^9, 3.7778974344881296`*^9}, 3.777899751048807*^9, 
   3.777899796339567*^9},
 CellLabel->
  "In[150]:=",ExpressionUUID->"d5d1ada7-ee2f-43cd-9349-3d562c136a05"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "We", " ", "now", " ", "store", " ", "the", " ", "necessary", " ", 
    "information", " ", "as", " ", "entries", " ", "in", " ", 
    "\"\<objectString\>\""}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Here", " ", 
    RowBox[{"we", "'"}], "re", " ", "just", " ", "making", " ", "the", " ", 
    "boundary", " ", "types", " ", "and", " ", "info", " ", "very", " ", 
    RowBox[{"explicit", ":"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"bType1", "=", "0"}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "when", " ", "defining", " ", "the", " ", "boundary", " ", "type"}], ",",
      " ", 
     RowBox[{
     "0", " ", "is", " ", "oriented", " ", "and", " ", "1", " ", "is", " ", 
      "planar", " ", "degenerate"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Wb1", "=", "5.3"}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"strength", " ", "of", " ", "anchoring"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"s0", "=", " ", "0.53"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "target", " ", "degree", " ", "of", " ", "nematic", " ", "order", " ", 
      "for", " ", "both", " ", "surfaces"}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"bType2", "=", "1"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{
      "when", " ", "defining", " ", "the", " ", "boundary", " ", "type"}], 
      ",", " ", 
      RowBox[{
      "0", " ", "is", " ", "oriented", " ", "and", " ", "1", " ", "is", " ", 
       "planar", " ", "degenerate"}]}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"Wb2", "=", "1.5"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"strength", " ", "of", " ", "anchoring"}], "*)"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"boundaries", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"bType1", ",", "Wb1", ",", "s0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"bType2", ",", "Wb2", ",", "s0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"objectString1", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"objectString2", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"Do", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"currentLatticeSite", "=", 
              RowBox[{"{", 
               RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
              "is", " ", "the", " ", "current", " ", "site", " ", "inside", 
               " ", "the", " ", "desired", " ", 
               RowBox[{"sphere", "?"}]}], "*)"}], "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"memberFunction1", "[", "currentLatticeSite", "]"}], 
               ",", "\[IndentingNewLine]", 
               RowBox[{"(*", 
                RowBox[{"Find", " ", "the", " ", "outward", " ", "normal"}], 
                "*)"}], "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"vec", "=", 
                 RowBox[{"currentLatticeSite", "-", "sphereCenter1"}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"q", "=", 
                 RowBox[{"objectQvalue", "[", 
                  RowBox[{
                   RowBox[{"boundaries", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
                   RowBox[{"boundaries", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", "vec"}], 
                  "]"}]}], ";", "\[IndentingNewLine]", 
                RowBox[{"AppendTo", "[", 
                 RowBox[{"objectString1", ",", 
                  RowBox[{"getFileString", "[", 
                   RowBox[{"currentLatticeSite", ",", "q"}], "]"}]}], "]"}], 
                ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"memberFunction2", "[", "currentLatticeSite", "]"}], 
               ",", "\[IndentingNewLine]", 
               RowBox[{"(*", 
                RowBox[{"Find", " ", "the", " ", "outward", " ", "normal"}], 
                "*)"}], "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"vec", "=", 
                 RowBox[{"currentLatticeSite", "-", "sphereCenter2"}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"q", "=", 
                 RowBox[{"objectQvalue", "[", 
                  RowBox[{
                   RowBox[{"boundaries", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", 
                   RowBox[{"boundaries", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", "vec"}], 
                  "]"}]}], ";", "\[IndentingNewLine]", 
                RowBox[{"AppendTo", "[", 
                 RowBox[{"objectString2", ",", 
                  RowBox[{"getFileString", "[", 
                   RowBox[{"currentLatticeSite", ",", "q"}], "]"}]}], "]"}], 
                ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], 
            "\[IndentingNewLine]", ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "0", ",", "xMax"}], "}"}]}], "]"}], ";"}], 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", "0", ",", "yMax"}], "}"}]}], "]"}], ";"}], 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "zMax"}], "}"}]}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7778958414046183`*^9, 3.7778958491299095`*^9}, {
  3.777895879296153*^9, 3.777895910234329*^9}, {3.7778959897076254`*^9, 
  3.7778961456651344`*^9}, {3.777896359956803*^9, 3.7778965446135545`*^9}, {
  3.7778966143678284`*^9, 3.777896650681612*^9}, {3.777896792790214*^9, 
  3.7778968553068757`*^9}, {3.7778969278496933`*^9, 3.777896945662019*^9}, {
  3.777897109290005*^9, 3.7778971157517233`*^9}, {3.777897450196088*^9, 
  3.7778975300064497`*^9}, {3.777897571232114*^9, 3.777897608478419*^9}, {
  3.7778977701356745`*^9, 3.7778977843367124`*^9}, {3.7778978144171467`*^9, 
  3.777897833664632*^9}, {3.7778978721027527`*^9, 3.777897892257844*^9}, {
  3.7778988404715633`*^9, 3.777898850397036*^9}, {3.7778997554909153`*^9, 
  3.7778997786100492`*^9}, {3.777900042518499*^9, 3.7779000606110315`*^9}},
 CellLabel->
  "In[156]:=",ExpressionUUID->"37dfd0ce-5e7b-434a-84ff-5e324da8d2ab"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Save", " ", "to", " ", "file"}], "..."}], " ", "we", " ", 
    "call", " ", "a", " ", "function", " ", "that", " ", "can", " ", "be", 
    " ", "used", " ", "with", " ", "any", " ", "number", " ", "of", " ", 
    "objects", " ", "in", " ", "these", " ", "arrays"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"objects", "=", 
     RowBox[{"{", 
      RowBox[{"objectString1", ",", "objectString2"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "we", " ", "already", " ", "defined", " ", "boundaries", " ", "in", " ",
        "the", " ", "cell", " ", "above", " ", "\[IndentingNewLine]", 
       "boundaries"}], "=", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"bType", ",", "Wb", ",", "s0"}], "}"}], "}"}]}], ";"}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"nEntries", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Length", "[", 
       RowBox[{"objects", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "objects", "]"}]}], "}"}]}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"writeBoundaryFile", "[", 
    RowBox[{"fileName", ",", "objects", ",", "boundaries", ",", "nEntries"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.751971728917067*^9, 3.7519718004426813`*^9}, {
   3.777896907057308*^9, 3.7778969174993525`*^9}, {3.7778969520907955`*^9, 
   3.777896954776627*^9}, {3.7778970445014315`*^9, 3.777897084624995*^9}, {
   3.777897925111862*^9, 3.777897950097029*^9}, 3.7779001144719105`*^9},
 CellLabel->
  "In[162]:=",ExpressionUUID->"e8a7ad6c-1d6e-46f2-825e-1e7c399c8513"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"540", ",", "540"}], "}"}]], "Output",
 CellChangeTimes->{
  3.751971810604162*^9, {3.771423547636361*^9, 3.771423568781148*^9}, 
   3.777896956379323*^9, 3.7778970912183466`*^9, 3.777897121585231*^9, {
   3.7778979553918056`*^9, 3.7778979697174935`*^9}, 3.777898012774214*^9, 
   3.7778998011985703`*^9, 3.777900114866824*^9, {3.7779002187709303`*^9, 
   3.7779002438208895`*^9}},
 CellLabel->
  "Out[163]=",ExpressionUUID->"0205a6c4-4032-4762-92ff-83c0517e0d57"],

Cell[BoxData["\<\"C:\\\\Users\\\\dmsussm\\\\Desktop\\\\twoSphereExample.txt\"\
\>"], "Output",
 CellChangeTimes->{
  3.751971810604162*^9, {3.771423547636361*^9, 3.771423568781148*^9}, 
   3.777896956379323*^9, 3.7778970912183466`*^9, 3.777897121585231*^9, {
   3.7778979553918056`*^9, 3.7778979697174935`*^9}, 3.777898012774214*^9, 
   3.7778998011985703`*^9, 3.777900114866824*^9, {3.7779002187709303`*^9, 
   3.7779002438547974`*^9}},
 CellLabel->
  "Out[164]=",ExpressionUUID->"353a2926-4002-4ca6-b156-413ebc9c6354"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 3: This example creates the \[OpenCurlyDoubleQuote]Landau deGUI\
\[CloseCurlyDoubleQuote] logo", "Chapter",
 CellChangeTimes->{{3.771424927307824*^9, 3.771424943850831*^9}, {
  3.777897225945928*^9, 
  3.777897226846512*^9}},ExpressionUUID->"da86dbe3-c203-4c50-bda6-\
bfe4d1c116e6"],

Cell[BoxData[
 RowBox[{"(*", " ", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"This", " ", "is", " ", "a", " ", "rougher", " ", 
    RowBox[{"example", " ", "--"}], " ", "not", " ", "using", " ", "all", " ",
     "of", " ", "the", " ", "functions", " ", "of", " ", "convenience", " ", 
    "defined", " ", 
    RowBox[{"above", " ", "--"}], " ", "that", " ", "reproduces", " ", "the", 
    " ", "\"\<landau DeGUI\>\"", " ", 
    RowBox[{"logo", ".", " ", "It"}], " ", "uses", " ", "the", " ", "same", 
    " ", "basic", " ", "ideas"}], ",", " ", 
   RowBox[{"though", ":", " ", 
    RowBox[{"define", " ", "regions"}]}], ",", " ", 
   RowBox[{
   "identify", " ", "sites", " ", "in", " ", "those", " ", "regions"}], ",", 
   " ", 
   RowBox[{"and", " ", "construct", " ", "the", " ", "output", " ", 
    RowBox[{"file", "."}]}]}], "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.777898627825963*^9, 3.777898689511651*^9}, {
  3.7778987527663574`*^9, 
  3.7778987586456184`*^9}},ExpressionUUID->"3d9321c2-2733-44f7-8990-\
918af0e16fe8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rotateList", "[", 
   RowBox[{"vertices_", ",", "angle_", ",", "vec_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"mean", ",", "temp"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"mean", "=", 
      RowBox[{"Mean", "[", "vertices", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"temp", "  ", "=", " ", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"RotationMatrix", "[", 
           RowBox[{"angle", ",", "vec"}], "]"}], ".", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"vertices", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "-", "mean"}], ")"}]}], "+", 
         "mean"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "vertices", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", "temp"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.750088844875846*^9, 3.750088845172799*^9}, {
  3.7778986174637012`*^9, 
  3.7778986194504223`*^9}},ExpressionUUID->"915d89bd-8aa0-44d1-9bd5-\
5b7394283d82"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"output", " ", "file", " ", "name"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
    "fname", "=", 
     "\"\</Users/dmsussma/repos/landauDeGUI/assets/boundaryInput.txt\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"intended", " ", "size", " ", "of", " ", "the", " ", "system"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xMax", "=", "80"}], ";", 
    RowBox[{"yMax", "=", "80"}], ";", 
    RowBox[{"zMax", "=", "80"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.750012582005846*^9, 3.750012585732149*^9}, {
  3.750012617076477*^9, 3.750012618103561*^9}, {3.75001454799739*^9, 
  3.750014595163249*^9}, {3.7500156517104197`*^9, 3.750015653742323*^9}, {
  3.750070088350958*^9, 3.750070091967595*^9}, {3.7500714096932898`*^9, 
  3.750071411381496*^9}, {3.751971450252893*^9, 3.751971487255351*^9}, {
  3.751971576681939*^9, 3.751971580956708*^9}, {3.771423467793673*^9, 
  3.7714234725228367`*^9}},ExpressionUUID->"f244984e-08ab-4746-bfef-\
f9ee86150ca6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"example", ":", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "a", " ", "floating", " ", "pyramid", " ", "over", " ", "a", " ", 
       "mountain"}], "..."}], " ", "directors", " ", "set", " ", "by", " ", 
     "direction", " ", "from", " ", "surfaces", " ", "to", " ", "a", " ", 
     "fixed", " ", "point", " ", "inside", " ", "the", " ", "surface"}]}], 
   "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"pyrSites", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{".35", "xMax"}], ",", 
         RowBox[{".35", "yMax"}], ",", 
         RowBox[{".75", "zMax"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{".35", "xMax"}], ",", 
         RowBox[{".65", "yMax"}], ",", 
         RowBox[{".75", "zMax"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{".65", "xMax"}], ",", 
         RowBox[{".65", "yMax"}], ",", 
         RowBox[{".75", "zMax"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{".65", "xMax"}], ",", 
         RowBox[{".35", "yMax"}], ",", 
         RowBox[{".75", "zMax"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{".5", "xMax"}], ",", 
         RowBox[{".5", "yMax"}], ",", 
         RowBox[{".5", "zMax"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pyrSites2", "=", 
     RowBox[{"rotateList", "[", 
      RowBox[{"pyrSites", ",", "Pi", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"region", "=", 
     RowBox[{"Pyramid", "[", "pyrSites", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"region2", "=", 
     RowBox[{"Pyramid", "[", "pyrSites2", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mf", "=", 
     RowBox[{"RegionMember", "[", "region", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mf2", "=", 
     RowBox[{"RegionMember", "[", "region2", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"center", "=", 
     RowBox[{
      RowBox[{"Mean", "[", 
       RowBox[{"pyrSites", "[", 
        RowBox[{"[", 
         RowBox[{";;", "4"}], "]"}], "]"}], "]"}], "+", 
      RowBox[{"{", 
       RowBox[{"0.1", ",", "0.1", ",", "0.1"}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"center2", "=", 
     RowBox[{
      RowBox[{"Mean", "[", 
       RowBox[{"pyrSites2", "[", 
        RowBox[{"[", ";;", "]"}], "]"}], "]"}], "+", 
      RowBox[{"{", 
       RowBox[{"0.1", ",", "0.1", ",", "0.1"}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datak", "=", 
     RowBox[{"GeoElevationData", "[", 
      RowBox[{"GeoBoundingBox", "[", 
       RowBox[{"GeoDisk", "[", 
        RowBox[{
         RowBox[{"Entity", "[", 
          RowBox[{"\"\<Mountain\>\"", ",", "\"\<MountKatahdin\>\""}], "]"}], 
         ",", 
         TemplateBox[{"7"},
          "QuantityUnit",
          DisplayFunction->(TooltipBox[
            StyleBox[
             RowBox[{#, "\[InvisibleSpace]", 
               StyleBox[
                RowBox[{" ", "\"mi\""}], "QuantityUnitTraditionalLabel"]}], 
             ShowStringCharacters -> False], "Unit: miles"]& ),
          InterpretationFunction->(RowBox[{"Quantity", "[", 
             RowBox[{#, ",", "\"Miles\""}], "]"}]& )]}], "]"}], "]"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"coords", "=", 
     RowBox[{"datak", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xLength", "=", 
     RowBox[{"Length", "[", "coords", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"yLength", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"coords", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"maxHeightAllowed", "=", 
     RowBox[{"0.3", "*", "zMax"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"desiredX", "=", "99"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"desiredY", "=", "99"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"intCoords", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"xx", "-", "1"}], ")"}], "*", 
              FractionBox["xMax", 
               RowBox[{"xLength", "-", "1"}]]}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"yy", "-", "1"}], ")"}], "*", 
              FractionBox["yMax", 
               RowBox[{"yLength", "-", "1"}]]}]}], "}"}], ",", 
           RowBox[{
            RowBox[{"coords", "[", 
             RowBox[{"[", 
              RowBox[{"xx", ",", "yy"}], "]"}], "]"}], "*", 
            FractionBox["maxHeightAllowed", 
             RowBox[{"Max", "[", "coords", "]"}]]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"xx", ",", "1", ",", "xLength"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"yy", ",", "1", ",", "yLength"}], "}"}]}], "]"}], ",", 
       "1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mountain", "=", 
     RowBox[{"Interpolation", "[", "intCoords", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mountainCenter", "=", 
     RowBox[{"{", 
      RowBox[{"50", ",", "50", ",", "0.5"}], "}"}]}], ";"}], "\n", 
   RowBox[{"(*", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"Plot3D", "[", 
       RowBox[{
        RowBox[{"mountain", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", 
          RowBox[{"xMax", "-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", "0", ",", 
          RowBox[{"yMax", "-", "1"}]}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
      RowBox[{"Graphics3D", "[", "region", "]"}], ",", 
      RowBox[{"Graphics3D", "[", "region2", "]"}], ",", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{"Sphere", "[", 
        RowBox[{"center2", ",", "10"}], "]"}], "]"}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "450"}]}], "]"}], "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.750014630790736*^9, 3.7500147166427927`*^9}, {
   3.750014747816923*^9, 3.750014819806225*^9}, {3.75001500438275*^9, 
   3.750015024903627*^9}, 3.750015655316156*^9, {3.750015692940016*^9, 
   3.75001575089968*^9}, {3.7500700739637423`*^9, 3.750070075060296*^9}, {
   3.750070254859579*^9, 3.750070315171937*^9}, {3.750070361828335*^9, 
   3.750070506264127*^9}, {3.750070553055152*^9, 3.750070553228775*^9}, 
   3.750070874260705*^9, {3.750084750791799*^9, 3.7500847527855253`*^9}, {
   3.750084784470031*^9, 3.750084853794511*^9}, {3.750084885653459*^9, 
   3.750085056277625*^9}, 3.7500877476799707`*^9, {3.750088856481936*^9, 
   3.750088867644267*^9}, {3.750088944357609*^9, 3.750088979844986*^9}, {
   3.75008906124651*^9, 3.750089070175157*^9}, {3.750089104997857*^9, 
   3.750089111259543*^9}, {3.75008916067653*^9, 3.750089245698999*^9}, {
   3.750096677715369*^9, 3.750096689698371*^9}, {3.7500974019175797`*^9, 
   3.750097414929408*^9}, {3.7714249670290127`*^9, 
   3.771424973122198*^9}},ExpressionUUID->"920d5cb4-8911-488d-8752-\
0893445c0f1e"],

Cell[BoxData[
 RowBox[{"Pyramid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"28.`", ",", "28.`", ",", "60.`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"28.`", ",", "52.`", ",", "60.`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"52.`", ",", "52.`", ",", "60.`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"52.`", ",", "28.`", ",", "60.`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"40.`", ",", "40.`", ",", "40.`"}], "}"}]}], "}"}], 
  "]"}]], "Output",
 CellChangeTimes->{{3.750085016576893*^9, 3.7500850571039753`*^9}, 
   3.7500874682634487`*^9, 3.750088858013464*^9, {3.750088956519161*^9, 
   3.750088980169153*^9}, {3.750089062594055*^9, 3.750089070680232*^9}, 
   3.7500891118081713`*^9, {3.750089168591642*^9, 3.750089180016696*^9}, {
   3.750089213103774*^9, 3.750089246412774*^9}, {3.750096686314311*^9, 
   3.750096690106711*^9}, 3.750096726711129*^9, {3.7500974107612677`*^9, 
   3.750097416049629*^9}, {3.75197156293267*^9, 3.7519715832441187`*^9}, 
   3.771423485449917*^9},ExpressionUUID->"cbc4e67d-20ed-4421-8ed0-\
37bc0972d5e4"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"bType", "=", "0"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"0", " ", "is", " ", "homeotropic"}], ",", " ", 
    RowBox[{"1", " ", "is", " ", "planar", " ", "degenerate"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Wb", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s0", " ", "=", " ", "0.53"}], ";"}]}], "Input",
 CellChangeTimes->{{3.751971707045347*^9, 
  3.751971707689142*^9}},ExpressionUUID->"4e027222-1ade-41d5-9bb1-\
636cd29f5060"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"objectString1", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"objectString2", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Do", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"z", ">", "maxHeightAllowed"}], "&&", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"x", "<", 
                 RowBox[{".3", "*", "xMax"}]}], "||", 
                RowBox[{"y", "<", 
                 RowBox[{".3", "*", "yMax"}]}], "||", 
                RowBox[{"x", ">", 
                 RowBox[{".7", "*", "xMax"}]}], "||", 
                RowBox[{"y", ">", 
                 RowBox[{".7", "yMax"}]}]}], ")"}]}], ",", 
             RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"mf", "[", 
                RowBox[{"{", 
                 RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"vec", "=", 
                 FractionBox[
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"x", ",", "y", ",", "z"}], "}"}], "-", "center"}], 
                  RowBox[{"Norm", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "y", ",", "z"}], "}"}], "-", "center"}],
                    "]"}]]}], ";", "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"bType", "\[Equal]", "0"}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"q", "=", 
                   RowBox[{"Q", "[", 
                    RowBox[{"vec", ",", "s0"}], "]"}]}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"q", "=", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";", 
                   "\[IndentingNewLine]", 
                   RowBox[{
                    RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", 
                    RowBox[{"vec", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", 
                   RowBox[{
                    RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", 
                    RowBox[{"vec", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ";", 
                   RowBox[{
                    RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "3"}], "]"}], "]"}], "=", 
                    RowBox[{"vec", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}]}], 
                 "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
                RowBox[{"q", "=", 
                 RowBox[{"Chop", "[", "q", "]"}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"AppendTo", "[", 
                 RowBox[{"entriesString", ",", 
                  RowBox[{"ToString", "[", 
                   RowBox[{
                    RowBox[{"IntegerString", "[", "x", "]"}], "<>", 
                    "\"\< \>\"", "<>", 
                    RowBox[{"IntegerString", "[", "y", "]"}], "<>", 
                    "\"\< \>\"", "<>", 
                    RowBox[{"IntegerString", "[", "z", "]"}], "<>", 
                    "\"\< \>\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], "]"}], "<>", 
                    "\"\< \>\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
                    "\"\< \>\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "3"}], "]"}], "]"}], "]"}], "<>", 
                    "\"\< \>\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
                    "\"\< \>\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "3"}], "]"}], "]"}], "]"}]}], "]"}]}], 
                 "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], 
            "\[IndentingNewLine]", "\[IndentingNewLine]", "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"mf2", "[", 
              RowBox[{"{", 
               RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"vec", "=", 
               FractionBox[
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"x", ",", "y", ",", "z"}], "}"}], "-", "center2"}], 
                RowBox[{"Norm", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"x", ",", "y", ",", "z"}], "}"}], "-", "center2"}],
                  "]"}]]}], ";", "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"bType", "\[Equal]", "0"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"q", "=", 
                 RowBox[{"Q", "[", 
                  RowBox[{"vec", ",", "s0"}], "]"}]}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"q", "=", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"q", "[", 
                   RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", 
                  RowBox[{"vec", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], ";", 
                 RowBox[{
                  RowBox[{"q", "[", 
                   RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", 
                  RowBox[{"vec", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], ";", 
                 RowBox[{
                  RowBox[{"q", "[", 
                   RowBox[{"[", 
                    RowBox[{"1", ",", "3"}], "]"}], "]"}], "=", 
                  RowBox[{"vec", "[", 
                   RowBox[{"[", "3", "]"}], "]"}]}]}]}], 
               "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
              RowBox[{"q", "=", 
               RowBox[{"Chop", "[", "q", "]"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"AppendTo", "[", 
               RowBox[{"objectString1", ",", 
                RowBox[{"ToString", "[", 
                 RowBox[{
                  RowBox[{"IntegerString", "[", "x", "]"}], "<>", "\"\< \>\"",
                   "<>", 
                  RowBox[{"IntegerString", "[", "y", "]"}], "<>", "\"\< \>\"",
                   "<>", 
                  RowBox[{"IntegerString", "[", "z", "]"}], "<>", "\"\< \>\"",
                   "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], "]"}], "<>", 
                  "\"\< \>\"", "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
                  "\"\< \>\"", "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "3"}], "]"}], "]"}], "]"}], "<>", 
                  "\"\< \>\"", "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
                  "\"\< \>\"", "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "3"}], "]"}], "]"}], "]"}]}], "]"}]}], 
               "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
           "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"z", "<", 
               RowBox[{"mountain", "[", 
                RowBox[{"x", ",", "y"}], "]"}]}], " ", "&&", " ", 
              RowBox[{"z", " ", "<", "maxHeightAllowed"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"vec", "=", 
               FractionBox[
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"x", ",", "y", ",", "z"}], "}"}], "-", 
                 "mountainCenter"}], 
                RowBox[{"Norm", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"x", ",", "y", ",", "z"}], "}"}], "-", 
                  "mountainCenter"}], "]"}]]}], ";", "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"bType", "\[Equal]", "0"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"q", "=", 
                 RowBox[{"Q", "[", 
                  RowBox[{"vec", ",", "s0"}], "]"}]}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"q", "=", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"q", "[", 
                   RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", 
                  RowBox[{"vec", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], ";", 
                 RowBox[{
                  RowBox[{"q", "[", 
                   RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", 
                  RowBox[{"vec", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], ";", 
                 RowBox[{
                  RowBox[{"q", "[", 
                   RowBox[{"[", 
                    RowBox[{"1", ",", "3"}], "]"}], "]"}], "=", 
                  RowBox[{"vec", "[", 
                   RowBox[{"[", "3", "]"}], "]"}]}]}]}], 
               "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
              RowBox[{"q", "=", 
               RowBox[{"Chop", "[", "q", "]"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"AppendTo", "[", 
               RowBox[{"objectString2", ",", 
                RowBox[{"ToString", "[", 
                 RowBox[{
                  RowBox[{"IntegerString", "[", "x", "]"}], "<>", "\"\< \>\"",
                   "<>", 
                  RowBox[{"IntegerString", "[", "y", "]"}], "<>", "\"\< \>\"",
                   "<>", 
                  RowBox[{"IntegerString", "[", "z", "]"}], "<>", "\"\< \>\"",
                   "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], "]"}], "<>", 
                  "\"\< \>\"", "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
                  "\"\< \>\"", "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "3"}], "]"}], "]"}], "]"}], "<>", 
                  "\"\< \>\"", "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
                  "\"\< \>\"", "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "3"}], "]"}], "]"}], "]"}]}], "]"}]}], 
               "]"}]}]}], "\[IndentingNewLine]", "]"}], ";"}], 
          "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]",
           ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "0", ",", 
            RowBox[{"xMax", "-", "1"}]}], "}"}]}], "]"}], ";"}], 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "0", ",", 
         RowBox[{"yMax", "-", "1"}]}], "}"}]}], "]"}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", 
      RowBox[{"zMax", "-", "1"}]}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.750014823481539*^9, 3.750014979678172*^9}, {
   3.750015346422739*^9, 3.750015392239377*^9}, {3.750015575474299*^9, 
   3.750015578974351*^9}, {3.7500156421872*^9, 3.750015677923223*^9}, {
   3.750070513842593*^9, 3.750070520970639*^9}, {3.750070643615939*^9, 
   3.7500707433903637`*^9}, {3.75008508479072*^9, 3.75008515272917*^9}, 
   3.750087499502234*^9, {3.750087600704711*^9, 3.750087603402117*^9}, {
   3.750089286167399*^9, 3.750089289990952*^9}, {3.750096702662065*^9, 
   3.750096710062134*^9}, {3.750097246128092*^9, 3.7500972691972237`*^9}, {
   3.750098403791252*^9, 3.750098406564053*^9}, {3.7519716294573183`*^9, 
   3.7519716757521267`*^9}, {3.751971808524619*^9, 
   3.751971808726926*^9}},ExpressionUUID->"00c3f3b1-dcf7-4872-af81-\
348d50420cea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"in", " ", "this", " ", "example"}], ",", " ", 
    RowBox[{
    "use", " ", "the", " ", "same", " ", "boundary", " ", "type", " ", "for", 
     " ", "both", " ", "objects"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"boundaries", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"bType", ",", "Wb", ",", "s0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"bType", ",", "Wb", ",", "s0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"objects", "=", 
     RowBox[{"{", 
      RowBox[{"objectString1", ",", "objectString2"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"nEntries", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Length", "[", 
       RowBox[{"objects", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "objects", "]"}]}], "}"}]}], 
     "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.751971728917067*^9, 
  3.7519718004426813`*^9}},ExpressionUUID->"f4cf07de-5d50-4702-b2c0-\
4f52b9989ebb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4261", ",", "57643"}], "}"}]], "Output",
 CellChangeTimes->{
  3.751971810604162*^9, {3.771423547636361*^9, 
   3.771423568781148*^9}},ExpressionUUID->"947d4de7-274e-4809-ba6f-\
1415144138cd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"str", "=", 
   RowBox[{"OpenWrite", "[", "fname", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"firstLine", " ", "=", " ", 
   RowBox[{"IntegerString", "[", 
    RowBox[{"Length", "[", "objects", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"WriteLine", "[", 
    RowBox[{"str", ",", "firstLine"}], "]"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"loop", " ", "over", " ", "objects"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"writeString", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"IntegerString", "[", 
         RowBox[{"boundaries", "[", 
          RowBox[{"[", 
           RowBox[{"oo", ",", "1"}], "]"}], "]"}], "]"}], "<>", "\"\< \>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{"boundaries", "[", 
          RowBox[{"[", 
           RowBox[{"oo", ",", "2"}], "]"}], "]"}], "]"}], "<>", "\"\< \>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{"boundaries", "[", 
          RowBox[{"[", 
           RowBox[{"oo", ",", "3"}], "]"}], "]"}], "]"}], "<>", "\"\< \>\"", "<>", 
        RowBox[{"IntegerString", "[", 
         RowBox[{"nEntries", "[", 
          RowBox[{"[", "oo", "]"}], "]"}], "]"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"WriteLine", "[", 
      RowBox[{"str", ",", 
       RowBox[{"writeString", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"WriteLine", "[", 
         RowBox[{"str", ",", 
          RowBox[{"objects", "[", 
           RowBox[{"[", 
            RowBox[{"oo", ",", "i"}], "]"}], "]"}]}], "]"}], ";"}], 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"nEntries", "[", 
          RowBox[{"[", "oo", "]"}], "]"}]}], "}"}]}], "]"}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"oo", ",", "1", ",", 
      RowBox[{"Length", "[", "objects", "]"}]}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Close", "[", "str", "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.750096946759932*^9, 3.750096987853281*^9}, {
  3.750097311790306*^9, 3.750097328015991*^9}, {3.751971832462133*^9, 
  3.751971980340933*^9}},ExpressionUUID->"83b04093-6dcc-47ae-a5f0-\
1943cb3f1d31"],

Cell[BoxData["\<\"/Users/dmsussma/repos/landauDeGUI/assets/boundaryInput.txt\"\
\>"], "Output",
 CellChangeTimes->{3.75009733657839*^9, 3.750097535816422*^9, 
  3.750098438913988*^9, 3.751971984798131*^9, 
  3.771423571259346*^9},ExpressionUUID->"790a812d-5fb3-4693-ac3a-\
1f2862c8015f"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 4: words", "Chapter",
 CellChangeTimes->{{3.767961890238359*^9, 3.767961890624943*^9}, {
  3.7778972279954505`*^9, 
  3.777897229014675*^9}},ExpressionUUID->"f19e16e5-2704-419c-8934-\
42358d218cf3"],

Cell[BoxData[
 RowBox[{"(*", " ", "\[IndentingNewLine]", 
  RowBox[{"An", " ", "even", " ", "rougher", " ", 
   RowBox[{"example", ":", " ", 
    RowBox[{
    "do", " ", "you", " ", "want", " ", "to", " ", "create", " ", "colloidal",
      " ", "inclusions", " ", "in", " ", "the", " ", "shape", " ", "of", " ", 
     RowBox[{"words", "?", " ", "Here"}], " ", "we", " ", "use", " ", "the", 
     " ", "\"\<extrusion\>\"", " ", "technique", " ", "of", " ", "generating",
      " ", "letter", " ", "shapes", " ", "that", " ", "enclose", " ", "a", 
     " ", 
     RowBox[{"volume", "."}]}]}]}], " ", "\[IndentingNewLine]", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.7778987705567026`*^9, 
  3.7778988210335894`*^9}},ExpressionUUID->"4f2f0c60-925c-4fe7-8e6f-\
d5c0b6a89bc2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"xMax", "=", "100"}], ";", 
  RowBox[{"yMax", "=", "100"}], ";", 
  RowBox[{"zMax", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"wordHeight", "=", "12."}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.7679594952296247`*^9, 3.767959500556974*^9}, {
  3.767961040597707*^9, 3.767961043654697*^9}, {3.767961101215221*^9, 
  3.767961148243095*^9}, {3.767961216319359*^9, 
  3.7679612434480124`*^9}},ExpressionUUID->"d3b149e8-b10c-4b57-89c0-\
8ba7f6ea01fc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"word", "=", 
   RowBox[{"Text", "[", 
    RowBox[{"Style", "[", 
     RowBox[{"\"\<DAN!\>\"", ",", "\"\<Title\>\""}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"text", "=", 
   RowBox[{"BoundaryDiscretizeGraphics", "[", 
    RowBox[{"word", ",", "_Text"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"elongate", "[", 
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_"}], "}"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"d", "=", 
       RowBox[{"0.05", " ", 
        RowBox[{"(", 
         RowBox[{"b", "-", "a"}], ")"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "-", "d"}], ",", 
       RowBox[{"b", "+", "d"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"full", "=", 
   RowBox[{"DiscretizeGraphics", "[", 
    RowBox[{"Rectangle", "@@", 
     RowBox[{"Transpose", "[", 
      RowBox[{"elongate", "/@", 
       RowBox[{"RegionBounds", "[", "text", "]"}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diff", "=", 
   RowBox[{"RegionDifference", "[", 
    RowBox[{"full", ",", "text"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"extruded", "=", 
   RowBox[{"RegionProduct", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"RegionDifference", "[", 
      RowBox[{"full", ",", "diff"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"0.5", "*", "zMax"}], "-", 
          RowBox[{"0.5", "*", "wordHeight"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"0.5", "*", "zMax"}], "+", 
          RowBox[{"0.5", "*", "wordHeight"}]}], "}"}]}], "}"}], "]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf2", "=", 
   RowBox[{"RegionMember", "[", "extruded", "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.7679598042618017`*^9, 3.767959875319599*^9}, {
   3.767960457690639*^9, 3.767960523807685*^9}, {3.767960558238578*^9, 
   3.767960631903101*^9}, {3.767960694165283*^9, 3.76796072344699*^9}, {
   3.767960915445133*^9, 3.7679609220255947`*^9}, {3.767960979189866*^9, 
   3.767960983104154*^9}, {3.7679610151940937`*^9, 3.7679611141623077`*^9}, {
   3.767961156911872*^9, 3.767961241767557*^9}, 3.767961276006513*^9, {
   3.767961314431527*^9, 
   3.767961316155978*^9}},ExpressionUUID->"676fab0e-df86-48df-924a-\
b889d6bf07a6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"extruded", ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"Sphere", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "1"}], "]"}], "]"}], 
   ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"Sphere", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"xMax", ",", "yMax", ",", "zMax"}], "}"}], ",", "1"}], "]"}], 
    "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.76796061072497*^9, 3.7679606131358232`*^9}, {
  3.7679607298927*^9, 3.767960753838354*^9}, {3.767960799363212*^9, 
  3.767960802576723*^9}},ExpressionUUID->"08070d1a-5289-43ef-a711-\
59bebad4da6f"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJxsnXlYTs/7+Nt3CVHa973sKdEzCGEke7KFhCRbyB5C9uxlqywRIVuKeAZF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    "], 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], 
     PrismBox[CompressedData["
1:eJxMnXeYVEXTxTfMEGZglhwlC0rYVYEluDOz5oSioogJFQMK5ow5izknwIBZ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      "]]}], SphereBox[{0, 0, 0}, 1], SphereBox[{100, 100, 100}, 1]},
  Boxed->False,
  ImageSize->{366.7622520527235, 296.5851454332545},
  ImageSizeRaw->Automatic,
  Lighting->{{"Ambient", 
     GrayLevel[0.45]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{2, 0, 2}]}, {"Directional", 
     GrayLevel[0.33], 
     ImageScaled[{2, 2, 2}]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{0, 2, 2}]}},
  Method->{"ShrinkWrap" -> True},
  ViewPoint->{-0.20813736527075224`, -3.3064631501892414`, 0.688462252864158},
  ViewVertical->{0.026525578458390674`, 0.0409188111646051, 
   1.3490770357324855`}]], "Output",
 CellChangeTimes->{
  3.767960637471795*^9, {3.7679607007986927`*^9, 3.767960754532509*^9}, 
   3.7679608030514307`*^9, 3.767961065251234*^9, 3.767961250276219*^9, 
   3.7679612818474092`*^9, 
   3.767961321050619*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztWD1PG0EQXd/eGWPLsQyBFAQ40+WPJFUkwj+wEAGKCETocykcF4E6RZQq
soQSKJzSUkThgpI/EMn07uPKXm5m7WHPN6c4sZ2YaC3d6M3HvrezPu8uPC8f
7+28Kh/vb5f9Z0flw7397df+04OjMCRTQqQOwueJL9wQKyFi5lAIiy2+r/gU
rVSNRkO1Wi30tBUnaN2gVqupbrerwk/Q6XQiWQnZADLhI25mpy+LLTbxCzBS
vft0mQ0qH78LCT4g9LCyYFQuQaWEXA5cD9BPI78CeQeiHrhpcpdQB9APo3wN
8sJFLeOToWFFYtFaZhX6LuZkJHdtKPjRPHrzYPMQciCGriShRUC6BYbbxToI
fTFUSrpyoICeH6XVq4hkVJJhBCRTJ5m6s9+Tz1JXD8YX3WTK1389hzQzrPgv
ZuNFX7vB6/4oaS7pSYr7k1WJxJDbYYrXGG6sm/s/RfnNYvq6/FY2W5Ibf0Gj
RDv4xtSYS3ECwP40ed1RqPTYQaPq/eer1QmSM6s4NrNxVMYI1plhpZFJh6a7
yn852MBjPjemFrPROkmbvcvofdWpLTC4FBmiWGQo8Ixb6R9Z4TdPs3GSNsOY
ylAbSJYj0QLDg1PChjDOHSR3++65IYWLvUyvUIFUchDLg7tAWY+ZHF6/7q56
Q6L9K9IbotXHOK5L+LCHOormSTT7p6JvwXh0h8xEmxzhdpF4JvcFPpDAwyTG
NFFc6DHfqJC7C7lG5Sz8bWCxxRaPgOcQyqBarQb1eh29l0a+/2NXlUpFtdtt
/J/QbjwfNJtN1ev10DPzs9CjxRbfAyxSt5zkfwM=\
\>"],ExpressionUUID->"0630f773-5546-436c-9dfc-da534586f805"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionBounds", "[", "text", "]"}]], "Input",
 CellChangeTimes->{{3.767961814895656*^9, 
  3.767961819328803*^9}},ExpressionUUID->"85434125-a9ae-4ae3-9881-\
8a610e34ffe9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "36.731113250625`"}], ",", "36.731113250625`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "11.365088069999999`"}], ",", "11.365088070000002`"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7679618198011637`*^9},ExpressionUUID->"392c3a97-e0f6-49d9-a05f-\
9efed7c191c6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mf2", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "36"}], ",", 
    RowBox[{"-", "11"}], ",", "50"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.767961821276229*^9, 
  3.7679618535490017`*^9}},ExpressionUUID->"4d57db87-2197-4266-ac3b-\
832760d0bb65"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.767961842899691*^9, 
  3.767961854031692*^9}},ExpressionUUID->"095597eb-24b5-49a8-8645-\
4e8ae84e26e1"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Q", "[", 
   RowBox[{"n_", ",", "S_"}], "]"}], ":=", 
  RowBox[{"3", 
   FractionBox["S", "2"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"TensorProduct", "[", 
      RowBox[{"n", ",", "n"}], "]"}], "-", 
     FractionBox[
      RowBox[{"IdentityMatrix", "[", "3", "]"}], "3"]}], 
    ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "fname", "=", 
   "\"\</Users/dmsussma/repos/landauDeGUI/data/namedBoundaryInput.txt\>\""}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.767961667654587*^9, 
  3.7679616725169897`*^9}},ExpressionUUID->"4c74c783-63f1-4254-b56b-\
139f272cae8c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"xOffset", "=", 
   RowBox[{"xMax", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yOffset", "=", 
   RowBox[{"xMax", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zOffset", "=", "0"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7679613360028753`*^9, 
  3.767961410408394*^9}},ExpressionUUID->"10574ab0-c04e-4b6c-a3fb-\
04591d793a49"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"bType", "=", "0"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"0", " ", "is", " ", "homeotropic"}], ",", " ", 
    RowBox[{"1", " ", "is", " ", "planar", " ", "degenerate"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Wb", "=", "5.8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s0", " ", "=", " ", "0.53"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"objectString1", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"center2", "=", 
   RowBox[{"{", 
    RowBox[{"50", ",", "50", ",", "50"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Print", "[", "z", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Do", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"z", ">", "56"}], " ", "||", " ", 
              RowBox[{"z", " ", "<", " ", "44"}]}], ",", 
             RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"mf2", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "-", "xOffset"}], ",", 
                RowBox[{"y", "-", "yOffset"}], ",", 
                RowBox[{"z", "-", "zOffset"}]}], "}"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"vec", "=", 
               FractionBox[
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"x", ",", "y", ",", "z"}], "}"}], "-", "center2"}], 
                RowBox[{"Norm", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"x", ",", "y", ",", "z"}], "}"}], "-", "center2"}],
                  "]"}]]}], ";", "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"bType", "\[Equal]", "0"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"q", "=", 
                 RowBox[{"Q", "[", 
                  RowBox[{"vec", ",", "s0"}], "]"}]}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"q", "=", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"q", "[", 
                   RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", 
                  RowBox[{"vec", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], ";", 
                 RowBox[{
                  RowBox[{"q", "[", 
                   RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", 
                  RowBox[{"vec", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], ";", 
                 RowBox[{
                  RowBox[{"q", "[", 
                   RowBox[{"[", 
                    RowBox[{"1", ",", "3"}], "]"}], "]"}], "=", 
                  RowBox[{"vec", "[", 
                   RowBox[{"[", "3", "]"}], "]"}]}]}]}], 
               "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
              RowBox[{"q", "=", 
               RowBox[{"Chop", "[", "q", "]"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"AppendTo", "[", 
               RowBox[{"objectString1", ",", 
                RowBox[{"ToString", "[", 
                 RowBox[{
                  RowBox[{"IntegerString", "[", "x", "]"}], "<>", "\"\< \>\"",
                   "<>", 
                  RowBox[{"IntegerString", "[", "y", "]"}], "<>", "\"\< \>\"",
                   "<>", 
                  RowBox[{"IntegerString", "[", "z", "]"}], "<>", "\"\< \>\"",
                   "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], "]"}], "<>", 
                  "\"\< \>\"", "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
                  "\"\< \>\"", "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "3"}], "]"}], "]"}], "]"}], "<>", 
                  "\"\< \>\"", "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
                  "\"\< \>\"", "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "3"}], "]"}], "]"}], "]"}]}], "]"}]}], 
               "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], 
          "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]",
           ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "0", ",", 
            RowBox[{"xMax", "-", "1"}]}], "}"}]}], "]"}], ";"}], 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "0", ",", 
         RowBox[{"yMax", "-", "1"}]}], "}"}]}], "]"}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "43", ",", "57"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.767961496268498*^9, 3.767961611837432*^9}, {
  3.767961725733766*^9, 3.767961728196822*^9}, {3.767961792830817*^9, 
  3.767961807489245*^9}, {3.767961868652997*^9, 
  3.767961870207437*^9}},ExpressionUUID->"4948405e-6e6b-46c0-ae4f-\
085952935414"],

Cell[CellGroupData[{

Cell[BoxData["43"], "Print",
 CellChangeTimes->{
  3.767961870575017*^9},ExpressionUUID->"7c70f6fd-6e88-4123-a151-\
e8b206347b61"],

Cell[BoxData["44"], "Print",
 CellChangeTimes->{
  3.76796187058304*^9},ExpressionUUID->"3d9bdec4-4b1f-4986-ac51-c9e94af2d047"],

Cell[BoxData["45"], "Print",
 CellChangeTimes->{
  3.767961881732935*^9},ExpressionUUID->"3a3789c7-7e1f-468f-b28e-\
e0fc175a7cc8"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"in", " ", "this", " ", "example"}], ",", " ", 
    RowBox[{
    "use", " ", "the", " ", "same", " ", "boundary", " ", "type", " ", "for", 
     " ", "both", " ", "objects"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"boundaries", "=", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"bType", ",", "Wb", ",", "s0"}], "}"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"objects", "=", 
     RowBox[{"{", "objectString1", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"nEntries", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Length", "[", 
       RowBox[{"objects", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "objects", "]"}]}], "}"}]}], "]"}]}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.7679616261821623`*^9, 3.7679616449395103`*^9}, 
   3.7679617428233643`*^9},ExpressionUUID->"636c0788-5d7d-4383-9839-\
179f4df69606"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"str", "=", 
   RowBox[{"OpenWrite", "[", "fname", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"firstLine", " ", "=", " ", 
   RowBox[{"IntegerString", "[", 
    RowBox[{"Length", "[", "objects", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteLine", "[", 
   RowBox[{"str", ",", "firstLine"}], "]"}], ";"}]}], "Input",ExpressionUUID->\
"d98d8551-f7c6-436f-a087-08b8f69dd86d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"str", "=", 
   RowBox[{"OpenWrite", "[", "fname", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"firstLine", " ", "=", " ", 
   RowBox[{"IntegerString", "[", 
    RowBox[{"Length", "[", "objects", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"WriteLine", "[", 
    RowBox[{"str", ",", "firstLine"}], "]"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"loop", " ", "over", " ", "objects"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"writeString", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"IntegerString", "[", 
         RowBox[{"boundaries", "[", 
          RowBox[{"[", 
           RowBox[{"oo", ",", "1"}], "]"}], "]"}], "]"}], "<>", "\"\< \>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{"boundaries", "[", 
          RowBox[{"[", 
           RowBox[{"oo", ",", "2"}], "]"}], "]"}], "]"}], "<>", "\"\< \>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{"boundaries", "[", 
          RowBox[{"[", 
           RowBox[{"oo", ",", "3"}], "]"}], "]"}], "]"}], "<>", "\"\< \>\"", "<>", 
        RowBox[{"IntegerString", "[", 
         RowBox[{"nEntries", "[", 
          RowBox[{"[", "oo", "]"}], "]"}], "]"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"WriteLine", "[", 
      RowBox[{"str", ",", 
       RowBox[{"writeString", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"WriteLine", "[", 
         RowBox[{"str", ",", 
          RowBox[{"objects", "[", 
           RowBox[{"[", 
            RowBox[{"oo", ",", "i"}], "]"}], "]"}]}], "]"}], ";"}], 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"nEntries", "[", 
          RowBox[{"[", "oo", "]"}], "]"}]}], "}"}]}], "]"}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"oo", ",", "1", ",", 
      RowBox[{"Length", "[", "objects", "]"}]}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Close", "[", "str", "]"}], "\[IndentingNewLine]"}], "Input",Expressi\
onUUID->"86dee495-1d97-4687-8ce3-f8a88cc2d9ca"]
}, Open  ]]
},
WindowSize->{975, 661},
WindowMargins->{{Automatic, 50}, {Automatic, 38}},
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 235, 4, 67, "Chapter",ExpressionUUID->"80329862-79f8-4d19-8170-b56ed24eabb3"],
Cell[818, 28, 8585, 212, 695, "Input",ExpressionUUID->"0b382618-4e01-4187-b2b2-b7910692c338"]
}, Closed]],
Cell[CellGroupData[{
Cell[9440, 245, 295, 4, 56, "Chapter",ExpressionUUID->"98b88dd6-fd7e-479b-9143-e603b1abb960"],
Cell[9738, 251, 700, 13, 86, "Input",ExpressionUUID->"1550ad8b-865e-40ca-becb-159fd5e5d8ed"],
Cell[10441, 266, 1669, 38, 162, "Input",ExpressionUUID->"01ed2569-4221-4a69-a1f5-40046ae6c2b1"],
Cell[12113, 306, 1509, 38, 142, "Input",ExpressionUUID->"a04581c7-afe2-48a9-9ccc-0dde6c0a43fb"],
Cell[13625, 346, 5169, 120, 371, "Input",ExpressionUUID->"8f12e304-8924-4777-a678-e763725d412a"],
Cell[CellGroupData[{
Cell[18819, 470, 1507, 38, 105, "Input",ExpressionUUID->"738be8c1-929f-4ac9-abf0-2d36a7c1140a"],
Cell[20329, 510, 392, 7, 70, "Output",ExpressionUUID->"f7cb39aa-1d44-4bd6-8c32-4ce28f5f2db6"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20770, 523, 320, 6, 102, "Chapter",ExpressionUUID->"d92ffe8c-b1ae-40d7-9513-e281ddc975d0"],
Cell[21093, 531, 555, 13, 67, "Input",ExpressionUUID->"773a61c6-b085-4a87-8cbd-157f2334b42a"],
Cell[21651, 546, 1295, 29, 124, "Input",ExpressionUUID->"a5a5a19f-b249-4e78-85a5-48e8af46ec42"],
Cell[22949, 577, 2119, 56, 180, "Input",ExpressionUUID->"d5d1ada7-ee2f-43cd-9349-3d562c136a05"],
Cell[25071, 635, 6922, 155, 599, "Input",ExpressionUUID->"37dfd0ce-5e7b-434a-84ff-5e324da8d2ab"],
Cell[CellGroupData[{
Cell[32018, 794, 1834, 45, 143, "Input",ExpressionUUID->"e8a7ad6c-1d6e-46f2-825e-1e7c399c8513"],
Cell[33855, 841, 503, 10, 32, "Output",ExpressionUUID->"0205a6c4-4032-4762-92ff-83c0517e0d57"],
Cell[34361, 853, 520, 9, 32, "Output",ExpressionUUID->"353a2926-4002-4ca6-b156-413ebc9c6354"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34930, 868, 296, 5, 67, "Chapter",ExpressionUUID->"da86dbe3-c203-4c50-bda6-bfe4d1c116e6"],
Cell[35229, 875, 1052, 21, 105, "Input",ExpressionUUID->"3d9321c2-2733-44f7-8990-918af0e16fe8"],
Cell[36284, 898, 1139, 30, 86, "Input",ExpressionUUID->"915d89bd-8aa0-44d1-9bd5-5b7394283d82"],
Cell[37426, 930, 1092, 25, 124, "Input",ExpressionUUID->"f244984e-08ab-4746-bfef-f9ee86150ca6"],
Cell[CellGroupData[{
Cell[38543, 959, 7575, 199, 518, "Input",ExpressionUUID->"920d5cb4-8911-488d-8752-0893445c0f1e"],
Cell[46121, 1160, 1083, 23, 32, "Output",ExpressionUUID->"cbc4e67d-20ed-4421-8ed0-37bc0972d5e4"]
}, Open  ]],
Cell[47219, 1186, 545, 15, 67, "Input",ExpressionUUID->"4e027222-1ade-41d5-9bb1-636cd29f5060"],
Cell[47767, 1203, 15178, 342, 1154, "Input",ExpressionUUID->"00c3f3b1-dcf7-4872-af81-348d50420cea"],
Cell[CellGroupData[{
Cell[62970, 1549, 1191, 35, 86, "Input",ExpressionUUID->"f4cf07de-5d50-4702-b2c0-4f52b9989ebb"],
Cell[64164, 1586, 232, 6, 32, "Output",ExpressionUUID->"947d4de7-274e-4809-ba6f-1415144138cd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64433, 1597, 2548, 66, 295, "Input",ExpressionUUID->"83b04093-6dcc-47ae-a5f0-1943cb3f1d31"],
Cell[66984, 1665, 287, 5, 32, "Output",ExpressionUUID->"790a812d-5fb3-4693-ac3a-1f2862c8015f"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[67320, 1676, 212, 4, 56, "Chapter",ExpressionUUID->"f19e16e5-2704-419c-8934-42358d218cf3"],
Cell[67535, 1682, 771, 15, 105, "Input",ExpressionUUID->"4f2f0c60-925c-4fe7-8e6f-d5c0b6a89bc2"],
Cell[68309, 1699, 526, 11, 67, "Input",ExpressionUUID->"d3b149e8-b10c-4b57-89c0-8ba7f6ea01fc"],
Cell[68838, 1712, 2520, 69, 181, "Input",ExpressionUUID->"676fab0e-df86-48df-924a-b889d6bf07a6"],
Cell[CellGroupData[{
Cell[71383, 1785, 663, 18, 28, "Input",ExpressionUUID->"08070d1a-5289-43ef-a711-59bebad4da6f"],
Cell[72049, 1805, 269678, 4430, 314, 268514, 4410, "CachedBoxData", "BoxData", "Output",ExpressionUUID->"0630f773-5546-436c-9dfc-da534586f805"]
}, Open  ]],
Cell[CellGroupData[{
Cell[341764, 6240, 194, 4, 28, "Input",ExpressionUUID->"85434125-a9ae-4ae3-9881-8a610e34ffe9"],
Cell[341961, 6246, 388, 12, 32, "Output",ExpressionUUID->"392c3a97-e0f6-49d9-a05f-9efed7c191c6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[342386, 6263, 284, 8, 28, "Input",ExpressionUUID->"4d57db87-2197-4266-ac3b-832760d0bb65"],
Cell[342673, 6273, 157, 3, 32, "Output",ExpressionUUID->"095597eb-24b5-49a8-8645-4e8ae84e26e1"]
}, Open  ]],
Cell[342845, 6279, 622, 20, 67, "Input",ExpressionUUID->"4c74c783-63f1-4254-b56b-139f272cae8c"],
Cell[343470, 6301, 405, 11, 67, "Input",ExpressionUUID->"10574ab0-c04e-4b6c-a3fb-04591d793a49"],
Cell[CellGroupData[{
Cell[343900, 6316, 6340, 151, 663, "Input",ExpressionUUID->"4948405e-6e6b-46c0-ae4f-085952935414"],
Cell[CellGroupData[{
Cell[350265, 6471, 130, 3, 22, "Print",ExpressionUUID->"7c70f6fd-6e88-4123-a151-e8b206347b61"],
Cell[350398, 6476, 127, 2, 22, "Print",ExpressionUUID->"3d9bdec4-4b1f-4986-ac51-c9e94af2d047"],
Cell[350528, 6480, 130, 3, 22, "Print",ExpressionUUID->"3a3789c7-7e1f-468f-b28e-e0fc175a7cc8"]
}, Open  ]]
}, Open  ]],
Cell[350685, 6487, 1094, 30, 105, "Input",ExpressionUUID->"636c0788-5d7d-4383-9839-179f4df69606"],
Cell[351782, 6519, 455, 12, 67, "Input",ExpressionUUID->"d98d8551-f7c6-436f-a087-08b8f69dd86d"],
Cell[352240, 6533, 2384, 63, 295, "Input",ExpressionUUID->"86dee495-1d97-4687-8ce3-f8a88cc2d9ca"]
}, Open  ]]
}
]
*)

