% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bLOO.R
\name{bLOO}
\alias{bLOO}
\title{Creates indices for bLOO CV}
\usage{
bLOO(tpoints, radius, min_train = 0)
}
\arguments{
\item{tpoints}{sf/sfc point object. Contains the training points samples.}

\item{radius}{Numeric. Positive radius of the exclusion buffer  (in the same units as the tpoints).}

\item{min_train}{Numeric, between 0 and 1. Minimum proportion of training
data that must be used in each CV fold. Defaults to 0 (i.e. no restrictions). If
positive and not met for a given iteration, the radius will be decreased by
1/10 until the condition is met.}
}
\value{
An object of class \emph{bLOO} consisting of a list of four elements:
indx_train, indx_test, and indx_exclude (indices of the observations to use as
training/test/excluded data in each bLOO CV fold), and radii (useful if min_train>0,
as the radius indicated by the user might have been reduced for a given iteration).
}
\description{
Function that computes the indices necessary for bLOO CV given a set of training
points and a buffer radius.
}
\details{
Euclidean distances are used for projected and non-defined CRS, otherwise the
function uses great circle distances.
}
\examples{
library("NNDM")
library("sf")

# Simulate 100 random points in a 100x100 square
set.seed(1234)
poly <- list(matrix(c(0,0,0,100,100,100,100,0,0,0), ncol=2, byrow=TRUE))
sample_poly <- sf::st_polygon(poly)
sim_points <- sf::st_sample(sample_poly, 100, type = "random")

# Compute bLOO with a radius of 40 and no training data size restrictions.
bLOO40 <- bLOO(sim_points, 40)
bLOO40

# Visualize results for the first iteration
plot(bLOO40, 1)

# Compute bLOO with a radius of 40 and a minimum training data size of 50\%.
bLOO40_mintrain <- bLOO(sim_points, 40, 0.5)
bLOO40_mintrain
}
