# Deformation Dilatometer Trials on Recyclable-Friendly Aluminium Alloys

## Overview

These folders contain methods and data for trials on recyclable-friendly aluminium alloys conducted by Christopher S. Daniel at The University of Manchester, using a DIL 805 A/D/T dilatometer in hot-compression mode. The tests include 9 combinations of three nominal strain rates (0.1 s-1, 1 s-1 and 10 s-1) and three nominal deformation temperatures (560°C, 520°C and 490°C) with some repeat tests. 

## Materials 

The material is a 6082.50 alloy prepared at two different homogenisations. One homogenisation at 590°C for 8h (labelled Hom1) and one at 520°C for 2h (labelled Hom2). For each homogenisation there were 19 x cylindrical samples (with dimensions 10 mm length and 5mm diameter) machined from homogenised cubic pieces supplied by SINTEF. Each of the samples came in a labelled bag with a number referring to its original position in the billet.

## Experiment 

a) Thermocouples - One K-type thermocouple attached to the centre of the sample and a second thermocouple spot-welded close to the the edge of the sample (about 1 - 2 mm from the edge). A setting of 5 (or 6) on the current and 2 on time was found to be optimum for spot-welding K-type thermocouples on these aluminium samples.

b) Dilatometer setup - Al2O3 stamps were used as they were found to reduce temperature homogeneity along the sample. Mo discs were also superglued to the ends of the sample to further reduce temperature inhomogeneity and friction, as well as prevent the sample sticking to the stamps after a test. Al2O3 transmission rods were used, as they were more durable under the high heat output by the Al samples to the Dilatometer chamber. The wider diameter copper induction coil was used to prevent friction and cracking of the AL2O3 transmission rods.

c) Environment - Samples were tested under high vacuum environment < 5 x 10-4 mbar.

d) Parameters kept constant between trials - Hold time before deformation: 10 min. Temperature during the hold time: 540°C. Heating rate to hold temp 25°C/s. Cooling rate after deformation 100 °C/s. Cooling strategy between hold time and deformation stage: quench at 50°C/s. Cooling strategy after the deformation stage: power off and quench with He gas applied.

e) Parameters to be varied between trials - Forging temperature: 560°C, 520°C and 490°C. Strain rate: 0.1 s-1, 1 s-1 and 10 s-1.

## Data Structure

`method` - contains the temperature and deformation profiles used for testing the high temperature deformation behaviour of aluminium alloys using the TA Instruments DIL 805 A/D/T Deformation Dilatometer.

`data_software` - contains metadata for the thermomechanical tests stored in the form of a `.PAR` and `.PAD` parameter file, along with a Windows `.D5D` data file. These files can be used to load and analyse data throughout an entire thermomechanical test using the TA Instruments DIL 805 A/D/T software.

`data_basic` folder - contains data recorded at a lower acquisition frequency throughout the entire thermomechanical test. The acquisition frequency varies at different stages during the test. This dataset includes recordings from a second thermocouple.

`data_deformation` - contains data recorded at a higher acquisition frequency during the high temperature deformation stage. The acquisition frequency is different for different strain rates, but should include a total of 12000 measurement points. This dataset does not include recordings from a second thermocouple.

`pictures` - contains images of the experiment and pictures of some of the samples showing the exact placement of K-type thermocouples along the length before and after the tests.