********************************************************************
*
*Paper : Parental Disabilty and Teenagers' Time Allocation
*
*File name :  mergerespondent.do
*
*This file creates variables for the number of minutes each respondent
*spends on each activity to merge into the respondent file
*
*Author - Sabrina Wulff Pabilonia
*
*Last Updated : May 24, 2021
********************************************************************
* Define the directory where original ATUS data is stored
global ATUSPATH "A:/ATUS"

*define the work file directory for the project
global PATH "X:/Charlene teens parentdisability"

version 17.0
clear
set more 1
cap log close

log using "$PATH/Log/mergerespondent.log", replace

*run for 2003-2019
forvalues YYYY = 2003/2019{

use "$PATH/Data/teen_activity_who_roster_`YYYY'.dta", clear
sort tucaseid

*convert string to numbers
split tustarttim, p(:) destring

*convert string to numbers
split tustoptime, p(:) destring

*calculate the number of activities
by tucaseid: egen byte noactivities = max(tuactivity_n)

*minutes for work and work-related activities on all jobs
gen phrswk = tuactdur24 if tutier1code==5
by tucaseid: egen minwk = sum(phrswk)
drop phrswk

*minutes in classes
gen phrsclass = tuactdur24 if tutier1code==6 & tutier2code==1
by tucaseid: egen minclass = sum(phrsclass)
drop phrsclass

*minutes on homework
gen phrshwk = tuactdur24 if tutier1code==6 & tutier2code==3
by tucaseid: egen minhwk = sum(phrshwk)
drop phrshwk 

*leisure variables
*all leisure 
gen pleisure = tuactdur24 if tutier1code==11 | tutier1code==12 | (tutier1code==13 & tutier2code==2) | (tutier1code==13 & tutier2code==3 & tutier3code==2) | (tutier1code==13 & tutier2code==4 & tutier3code==2) | tutier1code==14 | tutier1code==15 | (tutier1code==16 & tutier2code==1 & tutier3code<=2) 
by tucaseid: egen minallleisure = sum(pleisure)
drop pleisure

*create a socializing variable
gen psocial = tuactdur24 if (tutier1code==12 & tutier2code!=3) | (tutier1code==13 & tutier2code>=2) | tutier1code==14 | tutier1code==15 
by tucaseid: egen minsocial = sum(psocial)
drop psocial

*create relaxing but not TV
gen prelax = tuactdur24 if tutier1code==12 & tutier2code==3 & tutier3code!=3 & tutier3code!=4 & tutier3code!=7 & tutier3code!=8 
by tucaseid: egen minrelax = sum(prelax)
drop prelax

*create TV time (all types)
gen pTV = tuactdur24 if tutier1code==12 & tutier2code==3 & (tutier3code==3 | tutier3code==4)
by tucaseid: egen minTV = sum(pTV)
drop pTV

*create TV, games, and computer time variable
 gen pscreen = tuactdur24 if tutier1code==12 & tutier2code==3 & (tutier3code==3 | tutier3code==4 | tutier3code==7 | tutier3code==8)
by tucaseid: egen minscreen = sum(pscreen)
drop pscreen

*create sleep time variable
gen psleep = tuactdur24 if tutier1code==1 & tutier2code==1
by tucaseid: egen minsleep = sum(psleep)
drop psleep

*create household work
gen phousehold = tuactdur24 if tutier1code==2 | tutier1code==3 | tutier1code==7 
by tucaseid: egen minhousehold = sum(phousehold)
drop phousehold

*shopping - consumer purchases
gen pbuy = tuactdur24 if tutier1code==7 
by tucaseid: egen minbuy = sum(pbuy)
drop pbuy

*housework (cleaning and laundry)
gen phousework = tuactdur24 if tutier1code==2 & tutier2code==1
by tucaseid: egen minhousework = sum(phousework)
drop phousework

*food prep
gen pfoodprep = tuactdur24 if tutier1code==2 & tutier2code==2
by tucaseid: egen minfoodprep = sum(pfoodprep)
drop pfoodprep

*home maintenance (vehicle)
gen pmaintenance = tuactdur24 if tutier1code==2 & tutier2code>2 & tutier2code<=99 & tutier2code!=6 & tutier2code!=99
by tucaseid: egen minmaintenance = sum(pmaintenance)
drop pmaintenance

*create extracurricular activities
gen pextra = tuactdur24 if tutier1code==6 & tutier2code==2 
by tucaseid: egen minextra = sum(pextra)
drop pextra

*create participating in sports and exercise
gen psports = tuactdur24 if (tutier1code==13 & tutier2code==1) | (tutier1code==13 & tutier2code==3 & tutier3code==1) | (tutier1code==13 & tutier2code==4 & tutier3code==1)
by tucaseid: egen minsports = sum(psports)
drop psports

*create sports and extracurricular activities
gen minsportsextra = minsports + minextra

*create homework + extracurricular + sports
gen minhwk3 = minhwk + minextra + minsports

*schooling
gen minschool = minclass + minhwk3

*childcare time - caring for household children only
gen pchildcare = tuactdur24 if (tutier1code==3 & tutier2code<=3) 
by tucaseid: egen minchildcare = sum(pchildcare)
drop pchildcare

*household adult care
gen padultcare =  tuactdur24 if tutier1code==3 & tutier2code==4
by tucaseid: egen minadultcare = sum(padultcare)
drop padultcare

*household help adults
gen phelpadult = tuactdur24 if tutier1code==3 & tutier2code==5
by tucaseid: egen minhelpadult = sum(phelpadult)
drop phelpadult

*petcare
gen ppetcare = tuactdur24 if (tutier1code==2 & tutier2code==6) 
by tucaseid: egen minpetcare = sum(ppetcare)
drop ppetcare

*total care activities
gen totalcare = minchildcare + minadultcare + minhelpadult + minpetcare

*create how many missing minutes
gen missing = tuactdur24 if tutier1code==50
by tucaseid: egen minmissing = sum(missing)
drop missing

*how many minutes with a parent
gen timewmother = 0
gen timewfather = 0
gen timewparent = 0
gen timesibs = 0

for num 2/19: replace timewmother = tuactdur24 if withrosX==1 & relationX==24 & sexX==2 
by tucaseid: egen minmother = sum(timewmother)
for num 2/19: replace timewfather = tuactdur24 if withrosX==1 & relationX==24 & sexX==1
by tucaseid: egen minfather = sum(timewfather)
for num 2/19: replace timewparent = tuactdur24 if withrosX==1 & relationX==24
by tucaseid: egen minparent = sum(timewparent)

*time eating and drinking with both parents that occurs between 4:00-11 for two-parent households
gen time_familydinner = tuactdur24 if tustarttim1>=16 & tustarttim1<23 & tutier1code==11 & timewmother==tuactdur24 & timewfather==tuactdur24
by tucaseid: egen minfamilydinner = sum(time_familydinner)

drop timewmother timewfather time_familydinner timewparent

*minutes with siblings
for num 2/19: replace timesibs = tuactdur24 if withrosX==1 & relationX==25
by tucaseid: egen minsibs = sum(timesibs)
drop timesibs

*minutes with younger siblings
gen timesibs = 0
for num 2/19: replace timesibs = tuactdur24 if withrosX==1 & relationX==25 & ageX<15
by tucaseid: egen minsibsu15 = sum(timesibs)
drop timesibs

*TV time with younger siblings
gen timesibs = 0
for num 2/19: replace timesibs = tuactdur24 if tutier1code==12 & tutier2code==3 & (tutier3code==3 | tutier3code==4) & withrosX==1 & relationX==25 & ageX<15
by tucaseid: egen minTVsibsu15 = sum(timesibs)
drop timesibs

*TV time with mom
gen timewmother = 0
for num 2/19: replace timewmother = tuactdur24 if tutier1code==12 & tutier2code==3 & (tutier3code==3 | tutier3code==4) & withrosX==1 & relationX==24 & sexX==2 
by tucaseid: egen minTVmother = sum(timewmother)

drop timewmother

*Screen time with mom
gen timewmother = 0
for num 2/19: replace timewmother = tuactdur24 if tutier1code==12 & tutier2code==3 & (tutier3code==3 | tutier3code==4 | tutier3code==7 | tutier3code==8) & withrosX==1 & relationX==24 & sexX==2 
by tucaseid: egen minscreenmother = sum(timewmother)

*TV time with dad
gen timewfather = 0
for num 2/19: replace timewfather = tuactdur24 if tutier1code==12 & tutier2code==3 & (tutier3code==3 | tutier3code==4) & withrosX==1 & relationX==24 & sexX==1
by tucaseid: egen minTVfather = sum(timewfather)

drop timewfather

*Screen time with dad
gen timewfather = 0
for num 2/19: replace timewfather = tuactdur24 if tutier1code==12 & tutier2code==3 & (tutier3code==3 | tutier3code==4 | tutier3code==7 | tutier3code==8) & withrosX==1 & relationX==24 & sexX==1
by tucaseid: egen minscreenfather = sum(timewfather)

drop timewfather timewmother

sort tucaseid

*save summary data for each caseid
keep if tuactivity_n==1

*number of respondents
count

*number of respondents
count if tucaseid>0

*drop all unneeded variables for respondent file merg
drop tuactivity_n tutier1code tutier2code tutier3code tustarttim tustoptime tuactdur24 tuactdur tewhere lineno*

sort tucaseid

save "$PATH/Data/sumwkdata_`YYYY'.dta", replace

use "$ATUSPATH/atusresp_`YYYY'.dta", clear
destring tucaseid, replace
sort tucaseid

*only keep those in the using file
merge 1:1 tucaseid using "$PATH/Data/sumwkdata_`YYYY'.dta"
keep if _merge==3
drop _merge
sort tucaseid tulineno
save "$PATH/Data/newrespondent_`YYYY'.dta", replace

rm "$PATH/Data/sumwkdata_`YYYY'.dta"
rm "$PATH/Data/teen_activity_who_roster_`YYYY'.dta"
}

*use the 2004 weighting method in 2003 in order to pool
use "$PATH/Data/newrespondent_2003.dta"

rename tufinlwgt oldtufinlwgt 
rename tu06fwgt tufinlwgt
sort tucaseid tulineno
save "$PATH/Data/newrespondent_2003.dta", replace
use "$PATH/Data/newrespondent_2004.dta"

rename tufinlwgt oldtufinlwgt 
rename tu06fwgt tufinlwgt
sort tucaseid tulineno
save "$PATH/Data/newrespondent_2004.dta", replace
use "$PATH/Data/newrespondent_2005.dta"

rename tufinlwgt oldtufinlwgt 
rename tu06fwgt tufinlwgt
sort tucaseid tulineno
save "$PATH/Data/newrespondent_2005.dta", replace

