********************************************************************
*
*Paper : Parental Disabilty and Teenagers' Time Allocation
*
*File name :  mergecps.do
*
*merge in the ATUS-CPS file to obtain parental education, disability, 
*foreign born status, MSA status, extra adult in HH
*
*Author - Sabrina Wulff Pabilonia
*
*Last Updated : May 24, 2021
********************************************************************

# delimit cr

version 17.0 

clear 
clear matrix 
cap log close 
set more off  

* Define the directory where original ATUS data is stored
global ATUSPATH "A:/ATUS"

*define the work file directory for the project
global PATH "X:/Charlene teens parentdisability"

log using "$PATH/Log/mergecps", replace

*********
*2003****
*********

use "$ATUSPATH/atuscps_2003.dta", clear
sort tucaseid tulineno
merge m:1 tucaseid using "$PATH/Data/newrespondent_2003.dta"
keep if _merge==3
drop _merge

*reformat tucaseid to view the entire number in STATA editor
format tucaseid %15.0f

*lives in MSA
gen msa = (gemetsta==1)

******************************************************
*extra adult (age 19+) in household that is not parent
******************************************************
sort tucaseid tulineno
gen byte extra_adult = 0
for num 2/19: replace extra_adult = 1 if relationX~=24 & relationX~=. & ageX>18

**********************************
*the person does not have a parent
**********************************
gen byte dfather = (father==.)
gen byte dmother = (mother==.)

**************************************************************************
*what if father and mother exist but the person is not present in ATUSCPS*
**************************************************************************
sort tucaseid tulineno
gen byte mother_notmissing = 0 if mother~=1
for num 2/19: replace mother_notmissing = 1 if tulineno==X & relationX==24 & sexX==2  
by tucaseid: egen byte mother_notmissing_atuscps = max(mother_notmissing)
replace mother_notmissing_atuscps = 1 if dmother==1

gen byte father_notmissing = 0 if father~=1
for num 2/19: replace father_notmissing = 1 if tulineno==X & relationX==24 & sexX==1  
by tucaseid: egen byte father_notmissing_atuscps = max(father_notmissing)
replace father_notmissing_atuscps = 1 if dfather==1

***********************************************
*does the parent have a work-related disability
***********************************************
sort tucaseid tulineno
gen byte mother_workdisability = .
gen byte father_workdisability = .
for num 2/19: replace mother_workdisability = pudis if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_workdisability = pudis if tulineno==X & relationX==24 & sexX==1
by tucaseid: egen byte mother_wdisability = max(mother_workdisability)
by tucaseid: egen byte father_wdisability = max(father_workdisability)
drop mother_workdisability father_workdisability

*****************************************
*education level of the mother and father
*****************************************
sort tucaseid tulineno
gen temp_motheredu = 0
gen temp_fatheredu = 0
for num 2/19: replace temp_motheredu = peeduca if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace temp_fatheredu = peeduca if tulineno==X & relationX==24 & sexX==1
by tucaseid: egen byte motheredu = max(temp_motheredu)
by tucaseid: egen byte fatheredu = max(temp_fatheredu)
drop temp_motheredu temp_fatheredu

*******************************
*Foreign born mother or father*
*******************************
sort tucaseid tulineno
gen byte mother_citizenship = 0
gen byte father_citizenship = 0
gen byte mother_foreignborn = 0
gen byte father_foreignborn = 0
for num 2/19: replace mother_citizenship = prcitshp if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_citizenship = prcitshp if tulineno==X & relationX==24 & sexX==1
by tucaseid: egen byte mothercitizenship = max(mother_citizenship)
by tucaseid: egen byte fathercitizenship = max(father_citizenship)
replace mother_foreignborn = 1 if (mothercitizenship==4 | mothercitizenship==5)
replace father_foreignborn = 1 if (fathercitizenship==4 | fathercitizenship==5)
drop mother_citizenship father_citizenship mothercitizenship fathercitizenship

*************************
*mother and father works*
*************************
sort tucaseid tulineno
gen byte mother_w = 0
gen byte father_w = 0
gen byte mother_h = 0
gen byte father_h = 0
gen byte mother_FT = 0
gen byte mother_PT = 0
gen byte father_FT = 0
gen byte father_PT = 0
gen byte motheremp = 0
gen byte fatheremp = 0
gen byte motherfull = 0
gen byte motherpart = 0
gen byte fatherfull = 0
gen byte fatherpart = 0

for num 2/19: replace mother_w = pemlr if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_w = pemlr if tulineno==X & relationX==24 & sexX==1
*in some cases the parent is armed services so count as employed
for num 2/19: replace mother_w = 1 if tulineno==X & relationX==24 & sexX==2 & prpertyp==3 
for num 2/19: replace father_w = 1 if tulineno==X & relationX==24 & sexX==1 & prpertyp==3 
for num 2/19: replace mother_h = pehruslt if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_h = pehruslt if tulineno==X & relationX==24 & sexX==1
*if usual hours vary then asked about FT and PT
for num 2/19: replace mother_FT = 1 if tulineno==X & relationX==24 & sexX==2 & pehrftpt==1
for num 2/19: replace father_FT = 1 if tulineno==X & relationX==24 & sexX==1 & pehrftpt==1
for num 2/19: replace mother_PT = 1 if tulineno==X & relationX==24 & sexX==2 & pehrftpt==2
for num 2/19: replace father_PT = 1 if tulineno==X & relationX==24 & sexX==1 & pehrftpt==2

by tucaseid: egen byte motherwork = max(mother_w)
by tucaseid: egen byte fatherwork = max(father_w)
by tucaseid: egen byte motherhours = max(mother_h)
by tucaseid: egen byte fatherhours = max(father_h)
by tucaseid: egen byte motherfulltime = max(mother_FT)
by tucaseid: egen byte motherparttime = max(mother_PT)
by tucaseid: egen byte fatherfulltime = max(father_FT)
by tucaseid: egen byte fatherparttime = max(father_PT)
*if not in the labor force then hours would be zero
replace motherhours=0 if motherhours==-1
replace fatherhours=0 if fatherhours==-1
*every respondent has a value for employment status
replace motheremp = 1 if (motherwork==1 | motherwork==2)
replace fatheremp = 1 if (fatherwork==1 | fatherwork==2)
replace motherfull = 1 if (motherhours>34 & motheremp==1) | motherfulltime==1
replace motherpart = 1 if (motherhours>0 & motherhours<35 & motheremp==1) | motherparttime==1
replace fatherfull = 1 if (fatherhours>34 & fatheremp==1) | fatherfulltime==1
replace fatherpart = 1 if (fatherhours>0 & fatherhours<35 & fatheremp==1) | fatherparttime==1

drop mother_w father_w mother_h father_h mother_FT father_FT mother_PT father_PT motherwork fatherwork motherhours fatherhours

*save summary data for each caseid
drop if tulineno~=1
sort tucaseid

save "$PATH/Data/respondentcps_2003.dta", replace

*********
**2004***
*Jan-Apr*
*********

use "$ATUSPATH/atuscps_2004.dta", clear
sort tucaseid tulineno
merge m:1 tucaseid using "$PATH/Data/newrespondent_2004.dta"
keep if _merge==3
drop _merge

*reformat tucaseid to view the entire number in STATA editor
format tucaseid %15.0f

keep if hrmonth<5

*lives in MSA
gen msa = (gemetsta==1)

******************************************************
*extra adult (age 19+) in household that is not parent
******************************************************
sort tucaseid tulineno
gen byte extra_adult = 0
for num 2/19: replace extra_adult = 1 if relationX~=24 & relationX~=. & ageX>18

**********************************
*the person does not have a parent
**********************************
gen byte dfather = (father==.)
gen byte dmother = (mother==.)

**************************************************************************
*what if father and mother exist but the person is not present in ATUSCPS*
**************************************************************************
sort tucaseid tulineno
gen byte mother_notmissing = 0 if mother~=1
for num 2/19: replace mother_notmissing = 1 if tulineno==X & relationX==24 & sexX==2  
by tucaseid: egen byte mother_notmissing_atuscps = max(mother_notmissing)
replace mother_notmissing_atuscps = 1 if dmother==1

gen byte father_notmissing = 0 if father~=1
for num 2/19: replace father_notmissing = 1 if tulineno==X & relationX==24 & sexX==1  
by tucaseid: egen byte father_notmissing_atuscps = max(father_notmissing)
replace father_notmissing_atuscps = 1 if dfather==1

***********************************************
*does the parent have a work-related disability
***********************************************
sort tucaseid tulineno
gen byte mother_workdisability = .
gen byte father_workdisability = .
for num 2/19: replace mother_workdisability = pudis if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_workdisability = pudis if tulineno==X & relationX==24 & sexX==1
by tucaseid: egen byte mother_wdisability = max(mother_workdisability)
by tucaseid: egen byte father_wdisability = max(father_workdisability)
drop mother_workdisability father_workdisability

*****************************************
*education level of the mother and father
*****************************************
sort tucaseid tulineno
gen temp_motheredu = 0
gen temp_fatheredu = 0
for num 2/19: replace temp_motheredu = peeduca if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace temp_fatheredu = peeduca if tulineno==X & relationX==24 & sexX==1
by tucaseid: egen byte motheredu = max(temp_motheredu)
by tucaseid: egen byte fatheredu = max(temp_fatheredu)
drop temp_motheredu temp_fatheredu

*******************************
*Foreign born mother or father*
*******************************
sort tucaseid tulineno
gen byte mother_citizenship = 0
gen byte father_citizenship = 0
gen byte mother_foreignborn = 0
gen byte father_foreignborn = 0
for num 2/19: replace mother_citizenship = prcitshp if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_citizenship = prcitshp if tulineno==X & relationX==24 & sexX==1
by tucaseid: egen byte mothercitizenship = max(mother_citizenship)
by tucaseid: egen byte fathercitizenship = max(father_citizenship)
replace mother_foreignborn = 1 if (mothercitizenship==4 | mothercitizenship==5)
replace father_foreignborn = 1 if (fathercitizenship==4 | fathercitizenship==5)
drop mother_citizenship father_citizenship mothercitizenship fathercitizenship

*************************
*mother and father works*
*************************
sort tucaseid tulineno
gen byte mother_w = 0
gen byte father_w = 0
gen byte mother_h = 0
gen byte father_h = 0
gen byte mother_FT = 0
gen byte mother_PT = 0
gen byte father_FT = 0
gen byte father_PT = 0
gen byte motheremp = 0
gen byte fatheremp = 0
gen byte motherfull = 0
gen byte motherpart = 0
gen byte fatherfull = 0
gen byte fatherpart = 0

for num 2/19: replace mother_w = pemlr if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_w = pemlr if tulineno==X & relationX==24 & sexX==1
*in some cases the parent is armed services so count as employed
for num 2/19: replace mother_w = 1 if tulineno==X & relationX==24 & sexX==2 & prpertyp==3 
for num 2/19: replace father_w = 1 if tulineno==X & relationX==24 & sexX==1 & prpertyp==3 
for num 2/19: replace mother_h = pehruslt if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_h = pehruslt if tulineno==X & relationX==24 & sexX==1
*if usual hours vary then asked about FT and PT
for num 2/19: replace mother_FT = 1 if tulineno==X & relationX==24 & sexX==2 & pehrftpt==1
for num 2/19: replace father_FT = 1 if tulineno==X & relationX==24 & sexX==1 & pehrftpt==1
for num 2/19: replace mother_PT = 1 if tulineno==X & relationX==24 & sexX==2 & pehrftpt==2
for num 2/19: replace father_PT = 1 if tulineno==X & relationX==24 & sexX==1 & pehrftpt==2

by tucaseid: egen byte motherwork = max(mother_w)
by tucaseid: egen byte fatherwork = max(father_w)
by tucaseid: egen byte motherhours = max(mother_h)
by tucaseid: egen byte fatherhours = max(father_h)
by tucaseid: egen byte motherfulltime = max(mother_FT)
by tucaseid: egen byte motherparttime = max(mother_PT)
by tucaseid: egen byte fatherfulltime = max(father_FT)
by tucaseid: egen byte fatherparttime = max(father_PT)
*if not in the labor force then hours would be zero
replace motherhours=0 if motherhours==-1
replace fatherhours=0 if fatherhours==-1
*every respondent has a value for employment status
replace motheremp = 1 if (motherwork==1 | motherwork==2)
replace fatheremp = 1 if (fatherwork==1 | fatherwork==2)
replace motherfull = 1 if (motherhours>34 & motheremp==1) | motherfulltime==1
replace motherpart = 1 if (motherhours>0 & motherhours<35 & motheremp==1) | motherparttime==1
replace fatherfull = 1 if (fatherhours>34 & fatheremp==1) | fatherfulltime==1
replace fatherpart = 1 if (fatherhours>0 & fatherhours<35 & fatheremp==1) | fatherparttime==1

drop mother_w father_w mother_h father_h mother_FT father_FT mother_PT father_PT motherwork fatherwork motherhours fatherhours

*save summary data for each caseid
drop if tulineno~=1
sort tucaseid

save "$PATH/Data/respondentcps_2004A.dta", replace
 
*********
**2004***
*May-Dec*
*********  
use "$ATUSPATH/atuscps_2004.dta", clear
sort tucaseid tulineno
merge m:1 tucaseid using "$PATH/Data/newrespondent_2004.dta"
keep if _merge==3
drop _merge

*reformat tucaseid so I can see the entire number in STATA editor
format tucaseid %15.0f

keep if hrmonth>=5

*lives in MSA (metropolitan status variable name changes May 2004) 
gen msa = (gtmetsta==1)

******************************************************
*extra adult (age 19+) in household that is not parent
******************************************************
sort tucaseid tulineno
gen byte extra_adult = 0
for num 2/19: replace extra_adult = 1 if relationX~=24 & relationX~=. & ageX>18

**********************************
*the person does not have a parent
**********************************
gen byte dfather = (father==.)
gen byte dmother = (mother==.)

**************************************************************************
*what if father and mother exist but the person is not present in ATUSCPS*
**************************************************************************
sort tucaseid tulineno
gen byte mother_notmissing = 0 if mother~=1
for num 2/19: replace mother_notmissing = 1 if tulineno==X & relationX==24 & sexX==2  
by tucaseid: egen byte mother_notmissing_atuscps = max(mother_notmissing)
replace mother_notmissing_atuscps = 1 if dmother==1

gen byte father_notmissing = 0 if father~=1
for num 2/19: replace father_notmissing = 1 if tulineno==X & relationX==24 & sexX==1  
by tucaseid: egen byte father_notmissing_atuscps = max(father_notmissing)
replace father_notmissing_atuscps = 1 if dfather==1

***********************************************
*does the parent have a work-related disability
***********************************************
sort tucaseid tulineno
gen byte mother_workdisability = .
gen byte father_workdisability = .
for num 2/19: replace mother_workdisability = pudis if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_workdisability = pudis if tulineno==X & relationX==24 & sexX==1
by tucaseid: egen byte mother_wdisability = max(mother_workdisability)
by tucaseid: egen byte father_wdisability = max(father_workdisability)
drop mother_workdisability father_workdisability

*****************************************
*education level of the mother and father
*****************************************
sort tucaseid tulineno
gen temp_motheredu = 0
gen temp_fatheredu = 0
for num 2/19: replace temp_motheredu = peeduca if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace temp_fatheredu = peeduca if tulineno==X & relationX==24 & sexX==1
by tucaseid: egen byte motheredu = max(temp_motheredu)
by tucaseid: egen byte fatheredu = max(temp_fatheredu)
drop temp_motheredu temp_fatheredu

*******************************
*Foreign born mother or father*
*******************************
sort tucaseid tulineno
gen byte mother_citizenship = 0
gen byte father_citizenship = 0
gen byte mother_foreignborn = 0
gen byte father_foreignborn = 0
for num 2/19: replace mother_citizenship = prcitshp if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_citizenship = prcitshp if tulineno==X & relationX==24 & sexX==1
by tucaseid: egen byte mothercitizenship = max(mother_citizenship)
by tucaseid: egen byte fathercitizenship = max(father_citizenship)
replace mother_foreignborn = 1 if (mothercitizenship==4 | mothercitizenship==5)
replace father_foreignborn = 1 if (fathercitizenship==4 | fathercitizenship==5)
drop mother_citizenship father_citizenship mothercitizenship fathercitizenship

*************************
*mother and father works*
*************************
sort tucaseid tulineno
gen byte mother_w = 0
gen byte father_w = 0
gen byte mother_h = 0
gen byte father_h = 0
gen byte mother_FT = 0
gen byte mother_PT = 0
gen byte father_FT = 0
gen byte father_PT = 0
gen byte motheremp = 0
gen byte fatheremp = 0
gen byte motherfull = 0
gen byte motherpart = 0
gen byte fatherfull = 0
gen byte fatherpart = 0

for num 2/19: replace mother_w = pemlr if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_w = pemlr if tulineno==X & relationX==24 & sexX==1
*in some cases the parent is armed services so count as employed
for num 2/19: replace mother_w = 1 if tulineno==X & relationX==24 & sexX==2 & prpertyp==3 
for num 2/19: replace father_w = 1 if tulineno==X & relationX==24 & sexX==1 & prpertyp==3 
for num 2/19: replace mother_h = pehruslt if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_h = pehruslt if tulineno==X & relationX==24 & sexX==1
*if usual hours vary then asked about FT and PT
for num 2/19: replace mother_FT = 1 if tulineno==X & relationX==24 & sexX==2 & pehrftpt==1
for num 2/19: replace father_FT = 1 if tulineno==X & relationX==24 & sexX==1 & pehrftpt==1
for num 2/19: replace mother_PT = 1 if tulineno==X & relationX==24 & sexX==2 & pehrftpt==2
for num 2/19: replace father_PT = 1 if tulineno==X & relationX==24 & sexX==1 & pehrftpt==2

by tucaseid: egen byte motherwork = max(mother_w)
by tucaseid: egen byte fatherwork = max(father_w)
by tucaseid: egen byte motherhours = max(mother_h)
by tucaseid: egen byte fatherhours = max(father_h)
by tucaseid: egen byte motherfulltime = max(mother_FT)
by tucaseid: egen byte motherparttime = max(mother_PT)
by tucaseid: egen byte fatherfulltime = max(father_FT)
by tucaseid: egen byte fatherparttime = max(father_PT)
*if not in the labor force then hours would be zero
replace motherhours=0 if motherhours==-1
replace fatherhours=0 if fatherhours==-1
*every respondent has a value for employment status
replace motheremp = 1 if (motherwork==1 | motherwork==2)
replace fatheremp = 1 if (fatherwork==1 | fatherwork==2)
replace motherfull = 1 if (motherhours>34 & motheremp==1) | motherfulltime==1
replace motherpart = 1 if (motherhours>0 & motherhours<35 & motheremp==1) | motherparttime==1
replace fatherfull = 1 if (fatherhours>34 & fatheremp==1) | fatherfulltime==1
replace fatherpart = 1 if (fatherhours>0 & fatherhours<35 & fatheremp==1) | fatherparttime==1

drop mother_w father_w mother_h father_h mother_FT father_FT mother_PT father_PT motherwork fatherwork motherhours fatherhours

*save summary data for each caseid
drop if tulineno~=1

sort tucaseid
save "$PATH/Data/respondentcps_2004B.dta", replace

***********
*2005-2007*
***********

forvalues YYYY = 2005/2007{
use "$ATUSPATH/atuscps_`YYYY'.dta", clear
sort tucaseid tulineno
merge m:1 tucaseid using "$PATH/Data/newrespondent_`YYYY'.dta"
keep if _merge==3
drop _merge

*reformat tucaseid to view the entire number in STATA editor
format tucaseid %15.0f

*lives in MSA (metropolitan status variable name changes May 2004) 
gen msa = (gtmetsta==1)

******************************************************
*extra adult (age 19+) in household that is not parent
******************************************************
sort tucaseid tulineno
gen byte extra_adult = 0
for num 2/19: replace extra_adult = 1 if relationX~=24 & relationX~=. & ageX>18

**********************************
*the person does not have a parent
**********************************
gen byte dfather = (father==.)
gen byte dmother = (mother==.)

**************************************************************************
*what if father and mother exist but the person is not present in ATUSCPS*
**************************************************************************
sort tucaseid tulineno
gen byte mother_notmissing = 0 if mother~=1
for num 2/19: replace mother_notmissing = 1 if tulineno==X & relationX==24 & sexX==2  
by tucaseid: egen byte mother_notmissing_atuscps = max(mother_notmissing)
replace mother_notmissing_atuscps = 1 if dmother==1

gen byte father_notmissing = 0 if father~=1
for num 2/19: replace father_notmissing = 1 if tulineno==X & relationX==24 & sexX==1  
by tucaseid: egen byte father_notmissing_atuscps = max(father_notmissing)
replace father_notmissing_atuscps = 1 if dfather==1

***********************************************
*does the parent have a work-related disability
***********************************************
sort tucaseid tulineno
gen byte mother_workdisability = .
gen byte father_workdisability = .
for num 2/19: replace mother_workdisability = pudis if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_workdisability = pudis if tulineno==X & relationX==24 & sexX==1
by tucaseid: egen byte mother_wdisability = max(mother_workdisability)
by tucaseid: egen byte father_wdisability = max(father_workdisability)
drop mother_workdisability father_workdisability

*****************************************
*education level of the mother and father
*****************************************
sort tucaseid tulineno
gen temp_motheredu = 0
gen temp_fatheredu = 0
for num 2/19: replace temp_motheredu = peeduca if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace temp_fatheredu = peeduca if tulineno==X & relationX==24 & sexX==1
by tucaseid: egen byte motheredu = max(temp_motheredu)
by tucaseid: egen byte fatheredu = max(temp_fatheredu)
drop temp_motheredu temp_fatheredu

*******************************
*Foreign born mother or father*
*******************************
sort tucaseid tulineno
gen byte mother_citizenship = 0
gen byte father_citizenship = 0
gen byte mother_foreignborn = 0
gen byte father_foreignborn = 0
for num 2/19: replace mother_citizenship = prcitshp if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_citizenship = prcitshp if tulineno==X & relationX==24 & sexX==1
by tucaseid: egen byte mothercitizenship = max(mother_citizenship)
by tucaseid: egen byte fathercitizenship = max(father_citizenship)
replace mother_foreignborn = 1 if (mothercitizenship==4 | mothercitizenship==5)
replace father_foreignborn = 1 if (fathercitizenship==4 | fathercitizenship==5)
drop mother_citizenship father_citizenship mothercitizenship fathercitizenship

*************************
*mother and father works*
*************************
sort tucaseid tulineno
gen byte mother_w = 0
gen byte father_w = 0
gen byte mother_h = 0
gen byte father_h = 0
gen byte mother_FT = 0
gen byte mother_PT = 0
gen byte father_FT = 0
gen byte father_PT = 0
gen byte motheremp = 0
gen byte fatheremp = 0
gen byte motherfull = 0
gen byte motherpart = 0
gen byte fatherfull = 0
gen byte fatherpart = 0

for num 2/19: replace mother_w = pemlr if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_w = pemlr if tulineno==X & relationX==24 & sexX==1
*in some cases the parent is armed services so count as employed
for num 2/19: replace mother_w = 1 if tulineno==X & relationX==24 & sexX==2 & prpertyp==3 
for num 2/19: replace father_w = 1 if tulineno==X & relationX==24 & sexX==1 & prpertyp==3 
for num 2/19: replace mother_h = pehruslt if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_h = pehruslt if tulineno==X & relationX==24 & sexX==1
*if usual hours vary then asked about FT and PT
for num 2/19: replace mother_FT = 1 if tulineno==X & relationX==24 & sexX==2 & pehrftpt==1
for num 2/19: replace father_FT = 1 if tulineno==X & relationX==24 & sexX==1 & pehrftpt==1
for num 2/19: replace mother_PT = 1 if tulineno==X & relationX==24 & sexX==2 & pehrftpt==2
for num 2/19: replace father_PT = 1 if tulineno==X & relationX==24 & sexX==1 & pehrftpt==2

by tucaseid: egen byte motherwork = max(mother_w)
by tucaseid: egen byte fatherwork = max(father_w)
by tucaseid: egen byte motherhours = max(mother_h)
by tucaseid: egen byte fatherhours = max(father_h)
by tucaseid: egen byte motherfulltime = max(mother_FT)
by tucaseid: egen byte motherparttime = max(mother_PT)
by tucaseid: egen byte fatherfulltime = max(father_FT)
by tucaseid: egen byte fatherparttime = max(father_PT)
*if not in the labor force then hours would be zero
replace motherhours=0 if motherhours==-1
replace fatherhours=0 if fatherhours==-1
*every respondent has a value for employment status
replace motheremp = 1 if (motherwork==1 | motherwork==2)
replace fatheremp = 1 if (fatherwork==1 | fatherwork==2)
replace motherfull = 1 if (motherhours>34 & motheremp==1) | motherfulltime==1
replace motherpart = 1 if (motherhours>0 & motherhours<35 & motheremp==1) | motherparttime==1
replace fatherfull = 1 if (fatherhours>34 & fatheremp==1) | fatherfulltime==1
replace fatherpart = 1 if (fatherhours>0 & fatherhours<35 & fatheremp==1) | fatherparttime==1

drop mother_w father_w mother_h father_h mother_FT father_FT mother_PT father_PT motherwork fatherwork motherhours fatherhours

*save summary data for each caseid
drop if tulineno~=1
sort tucaseid

save "$PATH/Data/respondentcps_`YYYY'.dta", replace
 } 
  
***************** 
**2008 (Jan-May)*
*****************
use "$ATUSPATH/atuscps_2008.dta", clear
sort tucaseid tulineno
merge m:1 tucaseid using "$PATH/Data/newrespondent_2008.dta"
keep if _merge==3
drop _merge

*reformat tucaseid to view the entire number in STATA editor
format tucaseid %15.0f

*exclude June forward (any disability status variable added in June 2008)
keep if tumonth<6

*lives in MSA
gen msa = (gtmetsta==1)

******************************************************
*extra adult (age 19+) in household that is not parent
******************************************************
sort tucaseid tulineno
gen byte extra_adult = 0
for num 2/19: replace extra_adult = 1 if relationX~=24 & relationX~=. & ageX>18

**********************************
*the person does not have a parent
**********************************
gen byte dfather = (father==.)
gen byte dmother = (mother==.)

**************************************************************************
*what if father and mother exist but the person is not present in ATUSCPS*
**************************************************************************
sort tucaseid tulineno
gen byte mother_notmissing = 0 if mother~=1
for num 2/19: replace mother_notmissing = 1 if tulineno==X & relationX==24 & sexX==2  
by tucaseid: egen byte mother_notmissing_atuscps = max(mother_notmissing)
replace mother_notmissing_atuscps = 1 if dmother==1

gen byte father_notmissing = 0 if father~=1
for num 2/19: replace father_notmissing = 1 if tulineno==X & relationX==24 & sexX==1  
by tucaseid: egen byte father_notmissing_atuscps = max(father_notmissing)
replace father_notmissing_atuscps = 1 if dfather==1

***********************************************
*does the parent have a work-related disability
***********************************************
sort tucaseid tulineno
gen byte mother_workdisability = .
gen byte father_workdisability = .
for num 2/19: replace mother_workdisability = pudis if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_workdisability = pudis if tulineno==X & relationX==24 & sexX==1
by tucaseid: egen byte mother_wdisability = max(mother_workdisability)
by tucaseid: egen byte father_wdisability = max(father_workdisability)
drop mother_workdisability father_workdisability

*****************************************
*education level of the mother and father
*****************************************
sort tucaseid tulineno
gen temp_motheredu = 0
gen temp_fatheredu = 0
for num 2/19: replace temp_motheredu = peeduca if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace temp_fatheredu = peeduca if tulineno==X & relationX==24 & sexX==1
by tucaseid: egen byte motheredu = max(temp_motheredu)
by tucaseid: egen byte fatheredu = max(temp_fatheredu)
drop temp_motheredu temp_fatheredu

*******************************
*Foreign born mother or father*
*******************************
sort tucaseid tulineno
gen byte mother_citizenship = 0
gen byte father_citizenship = 0
gen byte mother_foreignborn = 0
gen byte father_foreignborn = 0
for num 2/19: replace mother_citizenship = prcitshp if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_citizenship = prcitshp if tulineno==X & relationX==24 & sexX==1
by tucaseid: egen byte mothercitizenship = max(mother_citizenship)
by tucaseid: egen byte fathercitizenship = max(father_citizenship)
replace mother_foreignborn = 1 if (mothercitizenship==4 | mothercitizenship==5)
replace father_foreignborn = 1 if (fathercitizenship==4 | fathercitizenship==5)
drop mother_citizenship father_citizenship mothercitizenship fathercitizenship

*************************
*mother and father works*
*************************
sort tucaseid tulineno
gen byte mother_w = 0
gen byte father_w = 0
gen byte mother_h = 0
gen byte father_h = 0
gen byte mother_FT = 0
gen byte mother_PT = 0
gen byte father_FT = 0
gen byte father_PT = 0
gen byte motheremp = 0
gen byte fatheremp = 0
gen byte motherfull = 0
gen byte motherpart = 0
gen byte fatherfull = 0
gen byte fatherpart = 0

for num 2/19: replace mother_w = pemlr if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_w = pemlr if tulineno==X & relationX==24 & sexX==1
*in some cases the parent is armed services so count as employed
for num 2/19: replace mother_w = 1 if tulineno==X & relationX==24 & sexX==2 & prpertyp==3 
for num 2/19: replace father_w = 1 if tulineno==X & relationX==24 & sexX==1 & prpertyp==3 
for num 2/19: replace mother_h = pehruslt if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_h = pehruslt if tulineno==X & relationX==24 & sexX==1
*if usual hours vary then asked about FT and PT
for num 2/19: replace mother_FT = 1 if tulineno==X & relationX==24 & sexX==2 & pehrftpt==1
for num 2/19: replace father_FT = 1 if tulineno==X & relationX==24 & sexX==1 & pehrftpt==1
for num 2/19: replace mother_PT = 1 if tulineno==X & relationX==24 & sexX==2 & pehrftpt==2
for num 2/19: replace father_PT = 1 if tulineno==X & relationX==24 & sexX==1 & pehrftpt==2

by tucaseid: egen byte motherwork = max(mother_w)
by tucaseid: egen byte fatherwork = max(father_w)
by tucaseid: egen byte motherhours = max(mother_h)
by tucaseid: egen byte fatherhours = max(father_h)
by tucaseid: egen byte motherfulltime = max(mother_FT)
by tucaseid: egen byte motherparttime = max(mother_PT)
by tucaseid: egen byte fatherfulltime = max(father_FT)
by tucaseid: egen byte fatherparttime = max(father_PT)
*if not in the labor force then hours would be zero
replace motherhours=0 if motherhours==-1
replace fatherhours=0 if fatherhours==-1
*every respondent has a value for employment status
replace motheremp = 1 if (motherwork==1 | motherwork==2)
replace fatheremp = 1 if (fatherwork==1 | fatherwork==2)
replace motherfull = 1 if (motherhours>34 & motheremp==1) | motherfulltime==1
replace motherpart = 1 if (motherhours>0 & motherhours<35 & motheremp==1) | motherparttime==1
replace fatherfull = 1 if (fatherhours>34 & fatheremp==1) | fatherfulltime==1
replace fatherpart = 1 if (fatherhours>0 & fatherhours<35 & fatheremp==1) | fatherparttime==1

drop mother_w father_w mother_h father_h mother_FT father_FT mother_PT father_PT motherwork fatherwork motherhours fatherhours

*save summary data for each caseid
drop if tulineno~=1
sort tucaseid
save "$PATH/Data/respondentcps_2008A.dta", replace
 
************** 
*2008 forward*
*June-Dec*****
**************
use "$ATUSPATH/atuscps_2008.dta", clear
sort tucaseid tulineno
merge m:1 tucaseid using "$PATH/Data/newrespondent_2008.dta"
keep if _merge==3
drop _merge

*reformat tucaseid to view the entire number in STATA editor
format tucaseid %15.0f

*keep if June or later (add NEW any disability variable)
keep if tumonth>5

*lives in MSA
gen msa = (gtmetsta==1)

******************************************************
*extra adult (age 19+) in household that is not parent
******************************************************
sort tucaseid tulineno
gen byte extra_adult = 0
for num 2/19: replace extra_adult = 1 if relationX~=24 & relationX~=. & ageX>18

**********************************
*the person does not have a parent
**********************************
gen byte dfather = (father==.)
gen byte dmother = (mother==.)

**************************************************************************
*what if father and mother exist but the person is not present in ATUSCPS*
**************************************************************************
sort tucaseid tulineno
gen byte mother_notmissing = 0 if mother~=1
for num 2/19: replace mother_notmissing = 1 if tulineno==X & relationX==24 & sexX==2  
by tucaseid: egen byte mother_notmissing_atuscps = max(mother_notmissing)
replace mother_notmissing_atuscps = 1 if dmother==1

gen byte father_notmissing = 0 if father~=1
for num 2/19: replace father_notmissing = 1 if tulineno==X & relationX==24 & sexX==1  
by tucaseid: egen byte father_notmissing_atuscps = max(father_notmissing)
replace father_notmissing_atuscps = 1 if dfather==1

***********************************************
*does the parent have a work-related disability
***********************************************
sort tucaseid tulineno
gen byte mother_workdisability = .
gen byte father_workdisability = .
for num 2/19: replace mother_workdisability = pudis if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_workdisability = pudis if tulineno==X & relationX==24 & sexX==1
by tucaseid: egen byte mother_wdisability = max(mother_workdisability)
by tucaseid: egen byte father_wdisability = max(father_workdisability)
drop mother_workdisability father_workdisability

*********************************************************
*does the parent have any disability - June 2008 forward*
*********************************************************
sort tucaseid tulineno
gen temp_mother_anydisability = 0 
gen temp_father_anydisability = 0 
for num 2/19: replace temp_mother_anydisability = prdisflg if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace temp_father_anydisability = prdisflg if tulineno==X & relationX==24 & sexX==1
by tucaseid: egen byte mother_anydisability = max(temp_mother_anydisability)
by tucaseid: egen byte father_anydisability = max(temp_father_anydisability)
drop temp_mother_anydisability temp_father_anydisability

*****************************************
*education level of the mother and father
*****************************************
sort tucaseid tulineno
gen temp_motheredu = 0
gen temp_fatheredu = 0
for num 2/19: replace temp_motheredu = peeduca if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace temp_fatheredu = peeduca if tulineno==X & relationX==24 & sexX==1
by tucaseid: egen byte motheredu = max(temp_motheredu)
by tucaseid: egen byte fatheredu = max(temp_fatheredu)
drop temp_motheredu temp_fatheredu

*******************************
*Foreign born mother or father*
*******************************
sort tucaseid tulineno
gen byte mother_citizenship = 0
gen byte father_citizenship = 0
gen byte mother_foreignborn = 0
gen byte father_foreignborn = 0
for num 2/19: replace mother_citizenship = prcitshp if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_citizenship = prcitshp if tulineno==X & relationX==24 & sexX==1
by tucaseid: egen byte mothercitizenship = max(mother_citizenship)
by tucaseid: egen byte fathercitizenship = max(father_citizenship)
replace mother_foreignborn = 1 if (mothercitizenship==4 | mothercitizenship==5)
replace father_foreignborn = 1 if (fathercitizenship==4 | fathercitizenship==5)
drop mother_citizenship father_citizenship mothercitizenship fathercitizenship

*************************
*mother and father works*
*************************
sort tucaseid tulineno
gen byte mother_w = 0
gen byte father_w = 0
gen byte mother_h = 0
gen byte father_h = 0
gen byte mother_FT = 0
gen byte mother_PT = 0
gen byte father_FT = 0
gen byte father_PT = 0
gen byte motheremp = 0
gen byte fatheremp = 0
gen byte motherfull = 0
gen byte motherpart = 0
gen byte fatherfull = 0
gen byte fatherpart = 0

for num 2/19: replace mother_w = pemlr if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_w = pemlr if tulineno==X & relationX==24 & sexX==1
*in some cases the parent is armed services so count as employed
for num 2/19: replace mother_w = 1 if tulineno==X & relationX==24 & sexX==2 & prpertyp==3 
for num 2/19: replace father_w = 1 if tulineno==X & relationX==24 & sexX==1 & prpertyp==3 
for num 2/19: replace mother_h = pehruslt if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_h = pehruslt if tulineno==X & relationX==24 & sexX==1
*if usual hours vary then asked about FT and PT
for num 2/19: replace mother_FT = 1 if tulineno==X & relationX==24 & sexX==2 & pehrftpt==1
for num 2/19: replace father_FT = 1 if tulineno==X & relationX==24 & sexX==1 & pehrftpt==1
for num 2/19: replace mother_PT = 1 if tulineno==X & relationX==24 & sexX==2 & pehrftpt==2
for num 2/19: replace father_PT = 1 if tulineno==X & relationX==24 & sexX==1 & pehrftpt==2

by tucaseid: egen byte motherwork = max(mother_w)
by tucaseid: egen byte fatherwork = max(father_w)
by tucaseid: egen byte motherhours = max(mother_h)
by tucaseid: egen byte fatherhours = max(father_h)
by tucaseid: egen byte motherfulltime = max(mother_FT)
by tucaseid: egen byte motherparttime = max(mother_PT)
by tucaseid: egen byte fatherfulltime = max(father_FT)
by tucaseid: egen byte fatherparttime = max(father_PT)
*if not in the labor force then hours would be zero
replace motherhours=0 if motherhours==-1
replace fatherhours=0 if fatherhours==-1
*every respondent has a value for employment status
replace motheremp = 1 if (motherwork==1 | motherwork==2)
replace fatheremp = 1 if (fatherwork==1 | fatherwork==2)
replace motherfull = 1 if (motherhours>34 & motheremp==1) | motherfulltime==1
replace motherpart = 1 if (motherhours>0 & motherhours<35 & motheremp==1) | motherparttime==1
replace fatherfull = 1 if (fatherhours>34 & fatheremp==1) | fatherfulltime==1
replace fatherpart = 1 if (fatherhours>0 & fatherhours<35 & fatheremp==1) | fatherparttime==1

drop mother_w father_w mother_h father_h mother_FT father_FT mother_PT father_PT motherwork fatherwork motherhours fatherhours

*save summary data for each caseid
drop if tulineno~=1
sort tucaseid

save "$PATH/Data/respondentcps_2008B.dta", replace

*************
*2009-2019***
*************

forvalues YYYY = 2009/2019{

use "$ATUSPATH/atuscps_`YYYY'.dta", clear
destring tucaseid, replace
sort tucaseid tulineno
merge m:1 tucaseid using "$PATH/Data/newrespondent_`YYYY'.dta"
keep if _merge==3
drop _merge

*reformat tucaseid to view the entire number in STATA editor
format tucaseid %15.0f

*lives in MSA
gen msa = (gtmetsta==1)

******************************************************
*extra adult (age 19+) in household that is not parent
******************************************************
sort tucaseid tulineno
gen byte extra_adult = 0
for num 2/19: replace extra_adult = 1 if relationX~=24 & relationX~=. & ageX>18

**********************************
*the person does not have a parent
**********************************
gen byte dfather = (father==.)
gen byte dmother = (mother==.)

**************************************************************************
*what if father and mother exist but the person is not present in ATUSCPS*
**************************************************************************
sort tucaseid tulineno
gen byte mother_notmissing = 0 if mother~=1
for num 2/19: replace mother_notmissing = 1 if tulineno==X & relationX==24 & sexX==2  
by tucaseid: egen byte mother_notmissing_atuscps = max(mother_notmissing)
replace mother_notmissing_atuscps = 1 if dmother==1

gen byte father_notmissing = 0 if father~=1
for num 2/19: replace father_notmissing = 1 if tulineno==X & relationX==24 & sexX==1  
by tucaseid: egen byte father_notmissing_atuscps = max(father_notmissing)
replace father_notmissing_atuscps = 1 if dfather==1

***********************************************
*does the parent have a work-related disability
***********************************************
sort tucaseid tulineno
gen byte mother_workdisability = .
gen byte father_workdisability = .
for num 2/19: replace mother_workdisability = pudis if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_workdisability = pudis if tulineno==X & relationX==24 & sexX==1
by tucaseid: egen byte mother_wdisability = max(mother_workdisability)
by tucaseid: egen byte father_wdisability = max(father_workdisability)
drop mother_workdisability father_workdisability

*********************************************************
*does the parent have any disability - June 2008 forward*
*********************************************************
sort tucaseid tulineno
gen temp_mother_anydisability = 0 
gen temp_father_anydisability = 0 
for num 2/19: replace temp_mother_anydisability = prdisflg if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace temp_father_anydisability = prdisflg if tulineno==X & relationX==24 & sexX==1
by tucaseid: egen byte mother_anydisability = max(temp_mother_anydisability)
by tucaseid: egen byte father_anydisability = max(temp_father_anydisability)
drop temp_mother_anydisability temp_father_anydisability

*****************************************
*education level of the mother and father
*****************************************
sort tucaseid tulineno
gen temp_motheredu = 0
gen temp_fatheredu = 0
for num 2/19: replace temp_motheredu = peeduca if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace temp_fatheredu = peeduca if tulineno==X & relationX==24 & sexX==1
by tucaseid: egen byte motheredu = max(temp_motheredu)
by tucaseid: egen byte fatheredu = max(temp_fatheredu)
drop temp_motheredu temp_fatheredu

*******************************
*Foreign born mother or father*
*******************************
sort tucaseid tulineno
gen byte mother_citizenship = 0
gen byte father_citizenship = 0
gen byte mother_foreignborn = 0
gen byte father_foreignborn = 0
for num 2/19: replace mother_citizenship = prcitshp if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_citizenship = prcitshp if tulineno==X & relationX==24 & sexX==1
by tucaseid: egen byte mothercitizenship = max(mother_citizenship)
by tucaseid: egen byte fathercitizenship = max(father_citizenship)
replace mother_foreignborn = 1 if (mothercitizenship==4 | mothercitizenship==5)
replace father_foreignborn = 1 if (fathercitizenship==4 | fathercitizenship==5)
drop mother_citizenship father_citizenship mothercitizenship fathercitizenship

*************************
*mother and father works*
*************************
sort tucaseid tulineno
gen byte mother_w = 0
gen byte father_w = 0
gen byte mother_h = 0
gen byte father_h = 0
gen byte mother_FT = 0
gen byte mother_PT = 0
gen byte father_FT = 0
gen byte father_PT = 0
gen byte motheremp = 0
gen byte fatheremp = 0
gen byte motherfull = 0
gen byte motherpart = 0
gen byte fatherfull = 0
gen byte fatherpart = 0

for num 2/19: replace mother_w = pemlr if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_w = pemlr if tulineno==X & relationX==24 & sexX==1
*in some cases the parent is armed services so count as employed
for num 2/19: replace mother_w = 1 if tulineno==X & relationX==24 & sexX==2 & prpertyp==3 
for num 2/19: replace father_w = 1 if tulineno==X & relationX==24 & sexX==1 & prpertyp==3 
for num 2/19: replace mother_h = pehruslt if tulineno==X & relationX==24 & sexX==2
for num 2/19: replace father_h = pehruslt if tulineno==X & relationX==24 & sexX==1
*if usual hours vary then asked about FT and PT
for num 2/19: replace mother_FT = 1 if tulineno==X & relationX==24 & sexX==2 & pehrftpt==1
for num 2/19: replace father_FT = 1 if tulineno==X & relationX==24 & sexX==1 & pehrftpt==1
for num 2/19: replace mother_PT = 1 if tulineno==X & relationX==24 & sexX==2 & pehrftpt==2
for num 2/19: replace father_PT = 1 if tulineno==X & relationX==24 & sexX==1 & pehrftpt==2

by tucaseid: egen byte motherwork = max(mother_w)
by tucaseid: egen byte fatherwork = max(father_w)
by tucaseid: egen byte motherhours = max(mother_h)
by tucaseid: egen byte fatherhours = max(father_h)
by tucaseid: egen byte motherfulltime = max(mother_FT)
by tucaseid: egen byte motherparttime = max(mother_PT)
by tucaseid: egen byte fatherfulltime = max(father_FT)
by tucaseid: egen byte fatherparttime = max(father_PT)
*if not in the labor force then hours would be zero
replace motherhours=0 if motherhours==-1
replace fatherhours=0 if fatherhours==-1
*every respondent has a value for employment status
replace motheremp = 1 if (motherwork==1 | motherwork==2)
replace fatheremp = 1 if (fatherwork==1 | fatherwork==2)
replace motherfull = 1 if (motherhours>34 & motheremp==1) | motherfulltime==1
replace motherpart = 1 if (motherhours>0 & motherhours<35 & motheremp==1) | motherparttime==1
replace fatherfull = 1 if (fatherhours>34 & fatheremp==1) | fatherfulltime==1
replace fatherpart = 1 if (fatherhours>0 & fatherhours<35 & fatheremp==1) | fatherparttime==1

drop mother_w father_w mother_h father_h mother_FT father_FT mother_PT father_PT motherwork fatherwork motherhours fatherhours

*save summary data for each caseid
drop if tulineno~=1
sort tucaseid

save "$PATH/Data/respondentcps_`YYYY'.dta", replace
}
   
log close 

