********************************************************************
*
*Paper : Parental Disabilty and Teenagers' Time Allocation
*
*File name :  atus_teen_parentdisability.do
*
*This file creates the tables for the paper
*
*Author - Sabrina Wulff Pabilonia
*
*Last Updated : May 24, 2021
********************************************************************

# delimit cr

version 17.0 

clear 
clear matrix 
cap log close 
set more off  

*define the work file directory for the project
global PATH "X:/Charlene teens parentdisability"

log using "$PATH/Log/atus_teen_parentdisability.log", replace 

use "$PATH/Data/atus_allyears.dta" 

svyset [pw=tufinlwgt] 

********************************************** 
*Sample restrictions 
*teenagers aged 15-17 who are unmarried 
*live with at least one parent 
*have no own household children 
*interviewed during the school year 
*have valid response on parents' disability 
********************************************** 

count 

*month dummies 
tabulate tumonth, gen(m) 

*control for time of year 
gen byte summer = (tumonth==6 | tumonth==7 | tumonth==8) 
tab summer 

gen byte schoolyear = (summer==0) 

*keep those interviewed during the school year 
keep if schoolyear==1 

count 

*drop those who do not live with at least one parent 
drop if (dmother==1 & dfather==1) 

count 

*drop if living with homosexual parents 
drop if (twomoms==1 | twodads==1) 

count 

*drop if married or unmarried partner living in household 
gen byte married2 = (trsppres==1 | trsppres==2) 
drop if married2==1 

count 

**drop if no information on mother or father from ATUSCPS file
keep if mother_notmissing_atuscps == 1 
keep if father_notmissing_atuscps == 1

count

*how many have parent with work-related disability (can't accept any work in next six months) 
gen parentdisabled = (mother_wdisability==1 | father_wdisability==1) 
*footnote X
svy: mean parentdisabled 

gen byte mdisabled = (mother_wdisability==1) 

gen byte fdisabled = (father_wdisability==1) 

*any disability 
gen byte parentanydisability = (mother_anydisability==1 | father_anydisability==1) 
replace parentanydisability = . if mother_anydisability==-2 | father_anydisability==-2 

tab tuyear 

*how many have own household children 
tab trohhchild 
drop if trohhchild==1 

count 

*how many have own children (in or out of HH) - teen parent 
tab ownchild 
drop if ownchild==1 

*count for sample of teenagers 15-17 
count 

*how many live with single mother 
gen byte singlemother = (dfather==1) 
tab singlemother 
*how many live with single father 
gen byte singlefather = (dmother==1) 
tab singlefather 

*how many live with two parents 
gen byte twoparents = (singlemother~=1 & singlefather~=1) 

*create day of the week dummies 
gen byte sunday = tudiaryday==1 
gen byte monday = tudiaryday==2 
gen byte tuesday = tudiaryday==3 
gen byte wed = tudiaryday==4 
gen byte thurs = tudiaryday==5 
gen byte friday = tudiaryday==6 
gen byte saturday = tudiaryday==7 
gen byte holiday = trholiday==1 

*weekend or holidays 
gen byte weekend = (sunday==1 | saturday==1 | holiday==1) 
gen byte weekday = (weekend~=1) 

*gender 
gen byte female = (sex1==2) 
gen byte male = (female==0) 

count if female==1 
count if male==1 

*REWEIGHT PROGRAM FOR EQUAL DAY OF THE WEEK REPRESENTATION FOR TEENAGER SAMPLE BY GENDER WITHIN YEAR
gen rewgtyr = 0
capture program drop reweight
program define reweight
	foreach x of num 2003/2019{
		quietly: tabstat tufinlwgt if female==1 & tuyear==`x', stat(sum) by(tudiaryday) format(%20.0g) save
		replace rewgtyr= 0 if tuyear==`x' & female==1 
		forvalues i = 1/7{
			scalar dayfac`i' = det(r(Stat`i'))/det(r(StatTotal))
			replace rewgtyr = (tufinlwgt/dayfac`i')/7 if tudiaryday==`i' & female==1 & tuyear==`x'
		}
		quietly: tabstat tufinlwgt if female==0 & tuyear==`x', stat(sum) by(tudiaryday) format(%20.0g) save
		replace rewgtyr= 0 if tuyear==`x' & female==0 
		forvalues i = 1/7{
			scalar dayfac`i' = det(r(Stat`i'))/det(r(StatTotal))
			replace rewgtyr = (tufinlwgt/dayfac`i') if tudiaryday==`i' & female==0 & tuyear==`x'
		}
	}
end
scalar drop _all

reweight
svyset [pw=rewgtyr]

*generate work status (employed at work or absent from work) 
gen byte employed = (telfs==1 | telfs==2) 

*create race/ethnicity variables 
*hispanic is not mutually exclusive 
gen byte hispanic = (pehspnon==1) 
*primary race category, other includes mixed race categories 
gen byte white = (ptdtrace==1) 
gen byte black = (ptdtrace==2) 
gen byte asian = (ptdtrace==4) 
gen byte other = (ptdtrace>=3 & asian~=1) 
gen byte nonwhite = (black==1 | asian==1 | other==1) 

*Census region 
quietly tab gereg, gen(reg) 

*education variables 
gen byte mbachelor = (motheredu==43 | motheredu==44 | motheredu==45 | motheredu==46) 
replace mbachelor = 0 if dmother==1 
gen byte fbachelor = (fatheredu==43 | fatheredu==44 | fatheredu==45 | fatheredu==46) 
replace fbachelor = 0 if dfather==1 

*household income - change categories 
*use hufaminc 2003-2009, use hefaminc 2010-2019 
gen byte incmis = 0 
gen byte inc30 = 0 
gen byte inc3075 = 0 
gen byte inc75 = 0 

replace incmis = 1 if hufaminc < 0 & tuyear<2010 
replace inc30 = 1 if (hufaminc>=1 & hufaminc<=8) & tuyear<2010 
replace inc3075 = 1 if (hufaminc>=8 & hufaminc<=13) & tuyear<2010  
replace inc75 = 1 if (hufaminc>=14) & tuyear<2010 

replace incmis = 1 if (hefaminc < 0) & tuyear>=2010 
replace inc30 = 1 if (hefaminc>=1 & hefaminc<=8) & tuyear>=2010 
replace inc3075 = 1 if (hefaminc>=8 & hefaminc<=13) & tuyear>=2010 
replace inc75 = 1 if hefaminc>=14 & tuyear>=2010 

*year dummies 
for num 2003/2019: gen byte yearX = (tuyear==X) 

*age dummies 
drop age2-age19 
for num 15/17: gen byte ageX = (age1==X) 

*create the highest degree of either parent is bachelor's degree 
gen byte parentbach = (fbachelor==1 | mbachelor==1) 
gen byte notparentbach = (parentbach==0) 

gen minhelpcareadult =  minadultcare + minhelpadult  

*interaction term between female and parent disability 
gen byte fparentdisabled = (female==1 & parentdisabled==1) 
gen byte fparentanydisability = (female==1 & parentanydisability==1) 

gen byte f_mdisabled = (female==1 & mdisabled==1) 

*School year results separately by gender 
gen byte fschoolyear = (schoolyear==1 & female==1) 
gen byte mschoolyear = (schoolyear==1 & male==1) 

*labels for time use activities 
label var minschool "Schooling-related activities" 
label var minclass "Class" 
label var minhwk "Homework" 
label var minextra "Extracurricular activities" 
label var minsports "Sports" 
label var minsportsextra "Extracurricular activities & playing sports"  
label var minwk "Work and work-related activities(not commuting)" 
label var minsleep "Sleep" 
label var minhousehold "Household production" 
label var minhousework "Housework (cleaning, laundry, etc.)" 
label var minbuy "Buying goods and services" 
label var minfoodprep "Food preparation and clean-up"  
label var minmaintenance "Home and vehicle maintenance" 
label var totalcare "Care activities" 
label var minchildcare "Primary childcare" 
label var minhelpcareadult "Caring/helping household adults" 
label var minpetcare "Pet care & veterinary services" 
label var minallleisure "Leisure" 
label var minsocial "Social activities" 
label var minrelax "Relaxing" 
label var minTV "TV"
label var minparent "Time with parent" 
label var minmother "Time with mother" 
label var minTVmother "Time watching TV with mother" 
label var minfather "Time with father" 
label var minTVfather "Time watching TV with father" 
label var minsibs "Time with siblings" 
label var minsibsu15 "Time with siblings under age 15"
label var minTVsibsu15 "Time watching TV with siblings under age 15"
label var minfamilydinner "Family dinner with both parents" 
label var employed "Employed" 
label var age15 "Age 15" 
label var age16 "Age 16" 
label var age17 "Age 17" 
label var white "White" 
label var nonwhite "Nonwhite" 
label var hispanic "Hispanic" 
label var singlemother "Single mother" 
label var singlefather "Single father" 
label var sibu15 "Number of siblings under age 15"
label var sibs15_18 "Number of sibligns age 15-18"
label var msa "Lives in metropolitan statistical area"
label var parentdisabled "Parent has work-related disability" 
label var extra_adult "Extra adult (age 19+) not parent in household" 
label var parentbach "At least one parent has bachelor's degree"
label var notparentbach "Parent does not have bachelor's degree"
label var fparentdisabled "Female and parent work-related disabled"
label var fparentanydisability "Female and parent has any disability"
label var fschoolyear "Female interviewed during school year"
label var mschoolyear "Male interviewed during school year"
label var f_mdisabled "Female and mother is disabled"
label var mdisabled "Mother has work-related disabled"
label var fdisabled "Father has work-related disabled"
label var parentanydisability "A parent has any disability"
label var twoparents "Lives in two-parent household"
label var incmis "Household income missing"
label var inc30 "Household income <$30,000"
label var inc3075 "Household income $30,000-$74,999"
label var inc75 "Household income $75,000+"
label var dfather "No father in the household"
label var dmother "No mother in the household"
label var motheremp "Mother is employed"
label var fatheremp "Father is employed"
label var schoolyear "Interviewed September-May"
label var rewgtyr "ATUS weight reweighted for equal day of the week representation by gender"
label define parentdisabled 0 "Parent not disabled" 1 "Parent disabled" 
label values parentdisabled parentdisabled 

*adjust the controls - collapse black asianother to nonwhite, remove parent is an immigrant, collapse income groups 
*add msa status and month of the year dummies 
 
*22 controls for Table 3 
global summarystats "age15 age16 age17 white nonwhite hispanic singlemother singlefather twoparents parentbach extra_adult sibu15 sibs15_18 incmis inc30 inc3075 inc75 msa reg2 reg3 reg4 weekday" 

global mycontrols "age15 age16 nonwhite hispanic singlemother singlefather parentbach extra_adult sibu15 sibs15_18 incmis inc3075 inc75 msa reg2 reg3 reg4 weekday m2-m5 m9-m12 year2003-year2018" 

global mycontrols_twoparents "age15 age16 nonwhite hispanic parentbach extra_adult sibu15 sibs15_18 incmis inc3075 inc75 msa reg2 reg3 reg4 weekday m2-m5 m9-m12 year2003-year2018" 

*17 daily minutes outcomes outcomes 
global timeuse "minschool minclass minhwk minsportsextra minwk minhousehold minhousework minbuy minfoodprep minchildcare minhelpcareadult minpetcare minallleisure minsleep minparent minmother minfather" 

keep schoolyear fschoolyear mschoolyear minschool minclass minhwk minsportsextra minwk minhousehold minhousework minbuy minfoodprep minchildcare minhelpcareadult minpetcare minallleisure minsleep minparent minmother minfather minfamilydinner minsibs minsibsu15 minTVsibsu15 parentdisabled mdisabled fdisabled parentanydisability singlemother singlefather twoparents sunday monda tuesday wed thurs friday saturday weekend weekday female male rewgtyr employed age15 age16 age17 white nonwhite hispanic singlemother singlefather twoparents parentbach extra_adult sibu15 sibs15_18 incmis inc30 inc3075 inc75 msa reg1 reg2 reg3 reg4 weekday m2-m5 m9-m12 year2003-year2018 tumonth tuyear motheremp fatheremp mother_anydisability father_anydisability dmother dfather minTV minTVmother minTVfather 

*create indicator for participation in activity 
foreach x of var minschool minclass minhwk minsportsextra minwk minhousehold minhousework minbuy minfoodprep minchildcare minhelpcareadult minpetcare minallleisure minsleep minparent minmother minfather minfamilydinner{ 
gen d`x' = (`x'>0) 
} 

*17 participation outcomes 
global dtimeuse "dminschool dminclass dminhwk dminsportsextra dminwk dminhousehold dminhousework dminbuy dminfoodprep dminchildcare dminhelpcareadult dminpetcare dminallleisure dminsleep dminparent dminmother dminfather" 

save "$PATH/Data/teensample.dta", replace

*text p.X - What % have a parent with a work-related disability 
svy: mean parentdisabled, over(female) 
svy: mean parentdisabled 

*time use means for teens by disability status 
foreach x of varlist $timeuse { 
svy, subpop(male): mean `x' 
} 

foreach x of varlist $timeuse { 
svy, subpop(female): mean `x' 
} 

*need this version to do the p-value tests for Table 1 
version 10.0 

*family dinner in two-parent households when father is disabled 
svy, subpop(if fschoolyear==1 & twoparents==1): mean minfamilydinner dminfamilydinner 
svy, subpop(if fschoolyear==1 & twoparents==1): mean minfamilydinner, over(fdisabled) coeflegend 
test _b[0] = _b[1] 
svy, subpop(if mschoolyear==1 & twoparents==1): mean minfamilydinner dminfamilydinner 
svy, subpop(if mschoolyear==1 & twoparents==1): mean minfamilydinner, over(fdisabled) coeflegend 
test _b[0] = _b[1] 

*does it matter more if father has disability 
svy, subpop(if fschoolyear==1 & twoparents==1): tobit minfamilydinner mdisabled fdisabled $mycontrols_twoparents, ll(0) 
margins, dydx(mdisabled fdisabled) predict(ystar(0,.)) post 
svy, subpop(if mschoolyear==1 & twoparents==1): tobit minfamilydinner mdisabled fdisabled $mycontrols_twoparents, ll(0) 
margins, dydx(mdisabled fdisabled) predict(ystar(0,.)) post 

****************************************************************************** 
*Table 1-3 - unadjusted means by parental disability status 
****************************************************************************** 
******** 
*Females 
******** 

*% engage in activity for female sample 
svy, subpop(fschoolyear): mean $dtimeuse 

*calculate 4 vectors and put in matrix then use frmttable 

*Get means for all females who live with parent with work-related disability 
svy, subpop(if fschoolyear==1 & parentdisabled==1): mean $timeuse $summarystats 

*Store results in matrix named mu_1 
mat define mu_1 = e(b)' 

*Get mean for all females who do not live with parent with work-related disability 
svy, subpop(if fschoolyear==1 & parentdisabled==0): mean $timeuse $summarystats 

*Store results in matrix named mu_2 
mat define mu_2 = e(b)' 

*calculate the difference between the two means 
matrix difference = mu_1 - mu_2 

*p-value from two-sided t-test 
mat V =J(39,1,.) 

local i = 1 
foreach x of var $timeuse $summarystats{ 
	svy, subpop(fschoolyear): mean `x', over(parentdisabled) coeflegend 
	test _b[_subpop_1] =  _b[_subpop_2] 
	matrix V[`i',1] = r(p) 
	local ++i 
} 

******** 
*Males 
******** 

*% engage in activity for female sample 
svy, subpop(mschoolyear): mean $dtimeuse 

*calculate 4 vectors and put in matrix then use frmttable 

*Get means for all females who live with parent with work-related disability 
svy, subpop(if mschoolyear==1 & parentdisabled==1): mean $timeuse $summarystats 

*Store results in matrix named mu_1_M 
mat define mu_1_M = e(b)' 

*Get mean for all females who do not live with parent with work-related disability 
svy, subpop(if mschoolyear==1 & parentdisabled==0): mean $timeuse $summarystats 

*Store results in matrix named mu_2_M 
mat define mu_2_M = e(b)' 

*calculate the difference between the two means 
matrix difference_M = mu_1_M - mu_2_M 

*p-value from two-sided t-test 
mat V_M =J(39,1,.) 

local i = 1 
foreach x of var $timeuse $summarystats{ 
	svy, subpop(mschoolyear): mean `x', over(parentdisabled) coeflegend 
	test _b[_subpop_1] =  _b[_subpop_2] 
	matrix V_M[`i',1] = r(p) 
	local ++i 
} 

*create matrix from submatrices 
matrix D = (mu_1, mu_2, difference, V, mu_1_M, mu_2_M, difference_M, V_M) 

frmttable using "$PATH/Tables/Table 1.doc", statmat(D) sd(3) varlabels replace ///
                ctitle("", Dmean_F, NoDmean_F, Diff_F, p-value_F, Dmean_M, NoDmean_M, Diff_M, p-value_M) 

clear matrix 

*number of observations - Table 1 	
count if fschoolyear==1 & parentdisabled==1  
count if fschoolyear==1 & parentdisabled==0  
count if mschoolyear==1 & parentdisabled==1  
count if mschoolyear==1 & parentdisabled==0  

tab mdisabled if schoolyear==1  
tab fdisabled if schoolyear==1 
tab parentdisabled if schoolyear==1 

********************************************************* 
*REDO TABLE 1 BUT FOR THOSE PARTICIPATING IN THE ACTIVITY 
********************************************************* 
*the labels are not showing up in the matrix 
*I need a matrix of labels 

*means for all  females who live with parent with work-related disability 
mat dmu_1 =J(17,1,.) 

local i = 1 
foreach x of var $timeuse { 
svy, subpop(if fschoolyear==1 & parentdisabled==1 & d`x'==1): mean `x' 
matrix dmu_1[`i',1] = e(b) 
	local ++i 
} 

*mean for all males who do not live with parent with work-related disability 
mat dmu_2 =J(17,1,.) 

local i = 1 
foreach x of var $timeuse { 
svy, subpop(if fschoolyear==1 & parentdisabled==0 & d`x'==1): mean `x' 
matrix dmu_2[`i',1] = e(b) 
	local ++i 
} 

*calculate the difference between the two means 
matrix difference = dmu_1 - dmu_2 

*p-value from two-sided t-test 
mat V =J(17,1,.) 

local i = 1 
foreach x of var $timeuse { 
	svy, subpop(if fschoolyear==1 & d`x'==1): mean `x', over(parentdisabled) coeflegend 
	test _b[_subpop_1] =  _b[_subpop_2] 
	matrix V[`i',1] = r(p) 
	local ++i 
} 

*means for all  males who live with parent with work-related disability 
mat dmu_3 =J(17,1,.) 

local i = 1 
foreach x of var $timeuse { 
svy, subpop(if mschoolyear==1 & parentdisabled==1 & d`x'==1): mean `x' 
matrix dmu_3[`i',1] = e(b) 
	local ++i 
} 

*mean for all males who do not live with parent with work-related disability 
mat dmu_4 =J(17,1,.) 

local i = 1 
foreach x of var $timeuse { 
svy, subpop(if mschoolyear==1 & parentdisabled==0 & d`x'==1): mean `x' 
matrix dmu_4[`i',1] = e(b) 
	local ++i 
} 

*calculate the difference between the two means 
matrix difference_M = dmu_3 - dmu_4 

*p-value from two-sided t-test 
mat V_M =J(17,1,.) 

local i = 1 
foreach x of var $timeuse { 
	svy, subpop(if mschoolyear==1 & d`x'==1): mean `x', over(parentdisabled) coeflegend 
	test _b[_subpop_1] =  _b[_subpop_2] 
	matrix V_M[`i',1] = r(p) 
	local ++i 
} 

*create matrix from submatrices 
matrix D = (dmu_1, dmu_2, difference, V, dmu_3, dmu_4, difference_M, V_M) 

frmttable using "$PATH/Tables/Table 1 participating.doc", statmat(D) sd(3) varlabels replace ///
                ctitle("", Dmean_F, NoDmean_F, Diff_F, p-value_F, Dmean_M, NoDmean_M, Diff_M, p-value_M) 

clear matrix 

version 17.0 

*does anyone in schoolyear sample have both parents disabled? - 15 
count if schoolyear==1 & fdisabled==1 & mdisabled==1 & female==1 
count if schoolyear==1 & fdisabled==1 & mdisabled==1 & male==1 

*June 2008 started asking about anydisability
*footnote 2
tab parentanydisability if schoolyear==1 & ((tuyear==2008 & tumonth>5) | tuyear>2008) 
svy: mean parentanydisability if schoolyear==1 & ((tuyear==2008 & tumonth>5) | tuyear>2008) 

*do these parents work? 
tab motheremp if mother_anydisability==1 & dmother==0 
tab fatheremp if father_anydisability==1 & dfather==0 

*restricted years for any disability questions 
gen byte restrictyears = ((tuyear==2008 & tumonth>5) | tuyear>2008) 

corr mother_anydisability mdisabled if schoolyear==1 & dmother==0 & restrictyears==1

corr father_anydisability fdisabled if schoolyear==1 & dfather==0 & restrictyears==1

*footnote 2 
*overlap for 37 percent of teenagers 
svy: tab parentanydisability parentdisabled if (parentanydisability==1 | parentdisabled==1) & schoolyear==1 & restrictyears==1

************
*Table 4
*Full Sample
************
*for tobit estimate average marginal effect for observed outcome including zeros (note that at the time of writing STATA output notation is wrong)
*GIRLS
*Tobit
svy, subpop(fschoolyear): tobit minschool parentdisabled $mycontrols, ll(0)
margins, dydx(parentdisabled) predict(ystar(0,.)) post
estimates store herearemargins
outreg2 [herearemargins] using "$PATH/Tables/Table4_girls.doc", bdec(3) ctitle(minschool) replace
foreach x of varlist minclass minhwk minsportsextra minwk minhousehold minhousework minbuy minfoodprep minchildcare minpetcare minsibs minsibsu15 minTVsibsu15 {
svy, subpop(fschoolyear): tobit `x' parentdisabled $mycontrols, ll(0)
margins, dydx(parentdisabled) predict(ystar(0,.)) post
estimates store herearemargins
outreg2 [herearemargins] using "$PATH/Tables/Table4_girls.doc", bdec(3) ctitle(`x') ap
}
*OLS
foreach x of varlist minallleisure minsleep minparent minTV minTVmother minTVfather {
svy, subpop(fschoolyear): reg `x' parentdisabled $mycontrols
outreg2 parentdisabled using "$PATH/Tables/Table4_girls.doc", bdec(3) ctitle(`x') ap
}

*BOYS
*Tobit 
svy, subpop(mschoolyear): tobit minschool parentdisabled $mycontrols, ll(0) 
margins, dydx(parentdisabled) predict(ystar(0,.)) post 
estimates store herearemargins 
outreg2 [herearemargins] using "$PATH/Tables/Table4_boys.doc", bdec(3) ctitle(minschool) replace 
*Tobit 
foreach x of varlist minclass minhwk minsportsextra minwk minhousehold minhousework minbuy minfoodprep minchildcare minpetcare minsibs minsibsu15 minTVsibsu15 { 
svy, subpop(mschoolyear): tobit  `x' parentdisabled $mycontrols, ll(0) 
margins, dydx(parentdisabled) predict(ystar(0,.)) post 
estimates store herearemargins 
outreg2 [herearemargins] using "$PATH/Tables/Table4_boys.doc", bdec(3) ctitle(`x') ap 
} 
*OLS 
foreach x of varlist minallleisure minsleep minparent minTV minTVmother minTVfather{ 
svy, subpop(mschoolyear): reg `x' parentdisabled $mycontrols 
outreg2 parentdisabled using "$PATH/Tables/Table4_boys.doc", bdec(3) ctitle(`x') ap 
} 

***********Try with heterosexual 2-parent families******************** 
*Table 6 
********************************************************************** 
*School year - does it matter if the mother or the father is disabled 
********************************************************************** 
*exclude the following smaller categories as the tobit doesn't estimate: extracurriculars, childcare, and adult care when we move to smaller sample 
*Tobit 
svy, subpop(if fschoolyear==1 & twoparents==1): tobit minschool mdisabled fdisabled $mycontrols_twoparents, ll(0) 
margins, dydx(mdisabled fdisabled) predict(ystar(0,.)) post 
estimates store herearemargins 
outreg2 [herearemargins] using "$PATH/Tables/Table6.doc", bdec(3) ctitle(minschool) replace 
foreach x of varlist minclass minhwk minsportsextra minwk minhousehold minhousework minbuy minfoodprep minchildcare minpetcare minsibs minsibsu15 minTVsibsu15 { 
svy, subpop(if fschoolyear==1 & twoparents==1): tobit `x' mdisabled fdisabled $mycontrols_twoparents, ll(0) 
margins, dydx(mdisabled fdisabled) predict(ystar(0,.)) post 
estimates store herearemargins 
outreg2 [herearemargins] using "$PATH/Tables/Table6.doc", bdec(3) ctitle(`x') ap 
} 
foreach x of varlist minallleisure minsleep minparent minmother minfather minTV  minTVmother minTVfather{ 
svy, subpop(if fschoolyear==1 & twoparents==1): reg  `x' mdisabled fdisabled $mycontrols_twoparents 
outreg2 mdisabled fdisabled using "$PATH/Tables/Table6.doc", bdec(3) ctitle(`x') ap 
} 

******** 
*Table 7 
******** 
******************************************************************************* 
**School year  - does it matter if the mother or the father is disabled (males) 
******************************************************************************* 

*Tobit 
svy, subpop(if mschoolyear==1 & twoparents==1): tobit minschool mdisabled fdisabled $mycontrols_twoparents, ll(0) 
margins, dydx(mdisabled fdisabled) predict(ystar(0,.)) post 
estimates store herearemargins 
outreg2 [herearemargins] using "$PATH/Tables/Table7.doc", bdec(3) ctitle(minschool) replace 
foreach x of varlist minclass minhwk minsportsextra minwk minhousehold minhousework minbuy minfoodprep minchildcare minpetcare minsibs minsibsu15 minTVsibsu15 { 
svy, subpop(if mschoolyear==1 & twoparents==1): tobit `x' mdisabled fdisabled $mycontrols_twoparents, ll(0) 
margins, dydx(mdisabled fdisabled) predict(ystar(0,.)) post 
estimates store herearemargins 
outreg2 [herearemargins]  using "$PATH/Tables/Table7.doc", bdec(3) ctitle(`x') ap 
} 
*OLS 
foreach x of varlist  minallleisure minsleep minparent minmother minfather minTV  minTVmother minTVfather{ 
svy, subpop(if mschoolyear==1 & twoparents==1): reg  `x' mdisabled fdisabled $mycontrols_twoparents  
outreg2 mdisabled fdisabled using "$PATH/Tables/Table7.doc", bdec(3) ctitle(`x') ap 
} 

******************************** 
*Table 8 single mother 
******************************** 
*GIRLS
*Tobit 
svy, subpop(if fschoolyear==1 & singlemother==1): tobit minschool mdisabled $mycontrols_twoparents, ll(0) 
margins, dydx(mdisabled) predict(ystar(0,.)) post 
estimates store herearemargins 
outreg2 [herearemargins] using "$PATH/Tables/Table8_girls.doc", bdec(3) ctitle(minschool) replace 
foreach x of varlist minclass minhwk minsportsextra minwk minhousehold minhousework minbuy minfoodprep minchildcare minpetcare minsibs minsibsu15 minTVsibsu15 { 
svy, subpop(if fschoolyear==1 & singlemother==1): tobit `x' mdisabled $mycontrols_twoparents, ll(0) 
margins, dydx(mdisabled) predict(ystar(0,.)) post 
estimates store herearemargins 
outreg2 [herearemargins] using "$PATH/Tables/Table8_girls.doc", bdec(3) ctitle(`x') ap 
} 
foreach x of varlist minallleisure minsleep minparent minTV minTVmother { 
svy, subpop(if fschoolyear==1 & singlemother==1): reg `x' mdisabled $mycontrols_twoparents 
outreg2 mdisabled using "$PATH/Tables/Table8_girls.doc", bdec(3) ctitle(`x') ap 
} 

*BOYS
*petcare model will not converge 
*Tobit 
svy, subpop(if mschoolyear==1 & singlemother==1): tobit minschool mdisabled $mycontrols_twoparents, ll(0) 
margins, dydx(mdisabled) predict(ystar(0,.)) post 
estimates store herearemargins 
outreg2 [herearemargins] using "$PATH/Tables/Table8_boys.doc", bdec(3) ctitle(minschool) replace 
foreach x of varlist minclass minhwk minsportsextra minwk minhousehold minhousework minbuy minfoodprep minchildcare minsibs minsibsu15 minTVsibsu15 { 
svy, subpop(if mschoolyear==1 & singlemother==1): tobit `x' mdisabled $mycontrols_twoparents, ll(0) 
margins, dydx(mdisabled) predict(ystar(0,.)) post 
estimates store herearemargins 
outreg2 [herearemargins] using "$PATH/Tables/Table8_boys.doc", bdec(3) ctitle(`x') ap 
} 
foreach x of varlist minallleisure minsleep minparent minTV minTVmother { 
svy, subpop(if mschoolyear==1 & singlemother==1): reg `x' mdisabled $mycontrols_twoparents 
outreg2 mdisabled using "$PATH/Tables/Table8_boys.doc", bdec(3) ctitle(`x') ap 
} 

***************************************************************************
*Analysis using families with siblings under age 15
*Do teens do more supervision of younger siblings when mother is disabled?
****************************************************************************
foreach x of varlist minsibsu15 minTVsibsu15 { 
svy, subpop(if fschoolyear==1 & sibu15>0): tobit `x' mdisabled fdisabled $mycontrols_twoparents, ll(0) 
margins, dydx(mdisabled) predict(ystar(0,.)) post 
}

foreach x of varlist minsibsu15 minTVsibsu15 { 
svy, subpop(if mschoolyear==1 & sibu15>0): tobit `x' mdisabled fdisabled $mycontrols_twoparents, ll(0) 
margins, dydx(mdisabled) predict(ystar(0,.)) post 
}

foreach x of varlist minsibsu15 minTVsibsu15 { 
svy, subpop(if fschoolyear==1 & twoparents==1 & sibu15>0): tobit `x' mdisabled fdisabled $mycontrols_twoparents, ll(0) 
margins, dydx(mdisabled) predict(ystar(0,.)) post 
}

foreach x of varlist minsibsu15 minTVsibsu15 { 
svy, subpop(if mschoolyear==1 & twoparents==1 & sibu15>0): tobit `x' mdisabled fdisabled $mycontrols_twoparents, ll(0) 
margins, dydx(mdisabled) predict(ystar(0,.)) post 
}

foreach x of varlist minsibsu15 minTVsibsu15 { 
svy, subpop(if fschoolyear==1 & singlemother==1 & sibu15>0): reg `x' mdisabled $mycontrols_twoparents 
}

foreach x of varlist minsibsu15 minTVsibsu15 { 
svy, subpop(if mschoolyear==1 & singlemother==1 & sibu15>0): reg `x' mdisabled $mycontrols_twoparents
}

**************************************** 
*Table 5 major categories on school days 
*include homework time too 
**************************************** 
*GIRLS
svy, subpop(if fschoolyear==1 & weekday==1): tobit minschool parentdisabled $mycontrols, ll(0) 
margins, dydx(parentdisabled) predict(ystar(0,.)) post 
estimates store herearemargins 
outreg2 [herearemargins] using "$PATH/Tables/Table5_schooldays_girls.doc", bdec(3) ctitle(minschool) replace 
foreach x of varlist minhwk minsportsextra minwk minhousehold minhousework minbuy minfoodprep{ 
svy, subpop(if fschoolyear==1 & weekday==1): tobit `x' parentdisabled $mycontrols, ll(0) 
margins, dydx(parentdisabled) predict(ystar(0,.)) post 
estimates store herearemargins 
outreg2 [herearemargins] using "$PATH/Tables/Table5_schooldays_girls.doc", bdec(3)  ctitle(`x') ap 
} 
*OLS 
foreach x of varlist minallleisure minsleep minparent{ 
svy, subpop(if fschoolyear==1 & weekday==1): reg `x' parentdisabled $mycontrols 
outreg2 parentdisabled using "$PATH/Tables/Table5_schooldays_girls.doc", bdec(3) ctitle(`x') ap 
} 

*BOYS
svy, subpop(if mschoolyear==1 & weekday==1): tobit minschool parentdisabled $mycontrols, ll(0) 
margins, dydx(parentdisabled) predict(ystar(0,.)) post 
estimates store herearemargins 
outreg2 [herearemargins] using "$PATH/Tables/Table5_schooldays_boys.doc", bdec(3) ctitle(minschool) replace 
foreach x of varlist minhwk minsportsextra minwk minhousehold minhousework minbuy minfoodprep{ 
svy, subpop(if mschoolyear==1 & weekday==1): tobit `x' parentdisabled $mycontrols, ll(0) 
margins, dydx(parentdisabled) predict(ystar(0,.)) post 
estimates store herearemargins 
outreg2 [herearemargins] using "$PATH/Tables/Table5_schooldays_boys.doc", bdec(3) ctitle(`x') ap 
} 
*OLS 
foreach x of varlist minallleisure minsleep minparent{ 
svy, subpop(if mschoolyear==1 & weekday==1): reg `x' parentdisabled $mycontrols 
outreg2 parentdisabled using "$PATH/Tables/Table5_schooldays_boys.doc", bdec(3) ctitle(`x') ap 
} 

*************** 
*Non-schooldays 
*************** 
*GIRLS
svy, subpop(if fschoolyear==1 & weekday==0): tobit minschool parentdisabled $mycontrols, ll(0) 
margins, dydx(parentdisabled) predict(ystar(0,.)) post 
estimates store herearemargins 
outreg2 [herearemargins] using "$PATH/Tables/Table5_nonschooldays_girls.doc", bdec(3) ctitle(minschool) replace 
foreach x of varlist minhwk minsportsextra minwk minhousehold minhousework minbuy minfoodprep{ 
svy, subpop(if fschoolyear==1 & weekday==0): tobit `x' parentdisabled $mycontrols, ll(0) 
margins, dydx(parentdisabled) predict(ystar(0,.)) post 
estimates store herearemargins 
outreg2 [herearemargins] using "$PATH/Tables/Table5_nonschooldays_girls.doc", bdec(3) ctitle(`x') ap 
} 
*OLS 
foreach x of varlist minallleisure minsleep minparent{ 
svy, subpop(if fschoolyear==1 & weekday==0): reg `x' parentdisabled $mycontrols 
outreg2 parentdisabled using "$PATH/Tables/Table5_nonschooldays_girls.doc", bdec(3) ctitle(`x') ap 
} 

*BOYS
svy, subpop(if mschoolyear==1 & weekday==0): tobit minschool parentdisabled $mycontrols, ll(0) 
margins, dydx(parentdisabled) predict(ystar(0,.)) post 
estimates store herearemargins 
outreg2 [herearemargins] using "$PATH/Tables/Table5_nonschooldays_boys.doc", bdec(3) ctitle(minschool) replace 
foreach x of varlist minhwk minsportsextra minwk minhousehold minhousework minbuy minfoodprep{ 
svy, subpop(if mschoolyear==1 & weekday==0): tobit `x' parentdisabled $mycontrols, ll(0) 
margins, dydx(parentdisabled) predict(ystar(0,.)) post 
estimates store herearemargins 
outreg2 [herearemargins] using "$PATH/Tables/Table5_nonschooldays_boys.doc", bdec(3) ctitle(`x') ap 
} 
*OLS 
foreach x of varlist minallleisure minsleep minparent{ 
svy, subpop(if mschoolyear==1 & weekday==0): reg `x' parentdisabled $mycontrols 
outreg2 parentdisabled using "$PATH/Tables/Table5_nonschooldays_boys.doc", bdec(3) ctitle(`x') ap 
} 

************************************************************* 
*Table A3
*Alternative type of disability  
*Smaller sample and different definition 
*restrict to June 2008 forward when they put this question in 
* ((tuyear==2008 & tumonth>5) | tuyear>2008) 
************************************************************* 

*GIRLS
*Tobit 
svy, subpop(if fschoolyear==1 & restrictyears==1): tobit minschool parentanydisability $mycontrols, ll(0) 
margins, dydx(parentanydisability) predict(ystar(0,.)) post 
estimates store herearemargins 
outreg2 [herearemargins] using "$PATH/Tables/TableA3_girls.doc", bdec(3) ctitle(minschool) replace 
foreach x of varlist minclass minhwk minsportsextra minwk minhousehold minhousework minbuy minfoodprep minchildcare minpetcare{ 
svy, subpop(if fschoolyear==1 & restrictyears==1): tobit `x' parentanydisability $mycontrols, ll(0) 
margins, dydx(parentanydisability) predict(ystar(0,.)) post 
estimates store herearemargins 
outreg2 [herearemargins] using "$PATH/Tables/TableA3_girls.doc", bdec(3) ctitle(`x') ap 
} 
*OLS 
foreach x of varlist minallleisure minsleep minparent{ 
svy, subpop(if fschoolyear==1 & restrictyears==1): reg `x' parentanydisability $mycontrols 
outreg2 parentanydisability using "$PATH/Tables/TableA3_girls.doc", bdec(3) ctitle(`x') ap 
} 

*BOYS
*note minwk won't converge for males 
*Tobit 
svy, subpop(if mschoolyear==1 & restrictyears==1): tobit minschool parentanydisability  $mycontrols, ll(0) 
margins, dydx(parentanydisability) predict(ystar(0,.)) post 
estimates store herearemargins 
outreg2 [herearemargins] using "$PATH/Tables/TableA3_boys.doc", bdec(3) ctitle(minschool) replace 
foreach x of varlist minclass minhwk minsportsextra minhousehold minhousework minbuy minfoodprep minchildcare minpetcare { 
svy, subpop(if mschoolyear==1 & restrictyears==1): tobit `x' parentanydisability $mycontrols, ll(0) 
margins, dydx(parentanydisability) predict(ystar(0,.)) post 
estimates store herearemargins 
outreg2 [herearemargins] using "$PATH/Tables/TableA3_boys.doc", bdec(3) ctitle(`x') ap 
} 
*OLS 
foreach x of varlist minallleisure minsleep minparent{ 
svy, subpop(if mschoolyear==1 & restrictyears==1): reg `x' parentanydisability $mycontrols 
outreg2 parentanydisability using "$PATH/Tables/TableA3_boys.doc", bdec(3) ctitle(`x') ap 
} 

log close 

