********************************************************************
*
*Paper : Parental Disabilty and Teenagers' Time Allocation
*
*File name : atus_allyears.do
*
*This file creates variables for the number of people who are 
*with you during an activity and merges onto the activity file
*
*Author - Sabrina Wulff Pabilonia
*
*Last Updated : May 24, 2021
********************************************************************

# delimit cr

version 17.0 

clear 
clear matrix 
cap log close 
set more off  

*define the work file directory for the project
global PATH "X:/Charlene teens parentdisability"

log using "$PATH/Log/atus_allyears.log", replace

append using "$PATH/Data/respondentcps_2003.dta"

append using "$PATH/Data/respondentcps_2004A.dta"
append using "$PATH/Data/respondentcps_2004B.dta"

forvalues YYYY = 2005/2007 {
append using "$PATH/Data/respondentcps_`YYYY'.dta"
}

append using "$PATH/Data/respondentcps_2008A.dta"
append using "$PATH/Data/respondentcps_2008B.dta"

forvalues YYYY = 2009/2019{
append using "$PATH/Data/respondentcps_`YYYY'.dta"
}

*reformat tucaseid to see the entire number in STATA editor
format tucaseid %15.0f

save "$PATH/Data/atus_allyears.dta", replace

log close
