*Author - Sabrina Wulff Pabilonia
*Paper : Parental Disabilty and Teenagers' Time Allocation
*Last Updated: 03-13-22
*mergerespondent_parents_of_teens.do
*This file creates variables for the number of minutes spent on activities for each respondent to merge into the respondent file

*define directories (use forward slash)
global DATA "X:/Charlene teens parentdisability/Data"
global LOG "X:/Charlene teens parentdisability/Log"
*original ATUS data stored
global ATUSPATH "A:/ATUS"

version 17.0
clear

set more 1
cap log close

log using "$LOG/mergerespondent_parents_of_teens.log", replace

*run for 2003-2019
forvalues YYYY = 2003/2019{

use "$DATA/parent_activity_who_roster_`YYYY'.dta", clear

*only keep those who live with teens aged 15-17
keep if parent_of_teen_15_17==1

sort tucaseid

*convert string to numbers
split tustarttim, p(:) destring

*convert string to numbers
split tustoptime, p(:) destring

*calculate the number of activities
by tucaseid: egen byte noactivities = max(tuactivity_n)

*minutes on children's educational activities
gen int phrskid_ed = tuactdur24 if tutier1code==3 & tutier2code==2
by tucaseid: egen int minkid_ed = sum (phrskid_ed)
drop phrskid_ed 

*minutes on work and work-related activities on all jobs
gen int phrswk = tuactdur24 if tutier1code==5
by tucaseid: egen int minwk = sum (phrswk)
drop phrswk

*minutes on all leisure 
gen int pleisure = tuactdur24 if tutier1code==11 | tutier1code==12 | (tutier1code==13 & tutier2code==2) | (tutier1code==13 & tutier2code==3 & tutier3code==2) | (tutier1code==13 & tutier2code==4 & tutier3code==2) | tutier1code==14 | tutier1code==15 | (tutier1code==16 & tutier2code==1 & tutier3code<=2) 
by tucaseid: egen int minallleisure = sum(pleisure)
drop pleisure

*minutes sleeping
gen int psleep = tuactdur24 if tutier1code==1 & tutier2code==1
by tucaseid: egen int minsleep = sum(psleep)
drop psleep

*minutes on personal care activities (includes sleeping)
gen int ppersonal_care = tuactdur24 if tutier1code==1 
by tucaseid: egen int minpersonal = sum(ppersonal_care)
drop ppersonal_care

*minutes on total household production
gen int phousehold = tuactdur24 if tutier1code==2 | tutier1code==3 | tutier1code==7 
by tucaseid: egen int minhousehold = sum(phousehold)
drop phousehold

*minutes on housework (cleaning and laundry)
gen int phousework = tuactdur24 if tutier1code==2 & tutier2code==1
by tucaseid: egen int minhousework = sum(phousework)
drop phousework

*minutes shopping - consumer purchases
gen int pbuy = tuactdur24 if tutier1code==7 
by tucaseid: egen int minbuy = sum(pbuy)
drop pbuy

*minutes on food prepartion and clean-up
gen int pfoodprep = tuactdur24 if tutier1code==2 & tutier2code==2
by tucaseid: egen int minfoodprep = sum(pfoodprep)
drop pfoodprep

*minutes caring for household children
gen int pchildcare = tuactdur24 if (tutier1code==3 & tutier2code<=3) 
by tucaseid: egen int minchildcare = sum(pchildcare)
drop pchildcare

*minutes caring for nonhousehold children
gen int pchildcare = tuactdur24 if (tutier1code==4 & tutier2code<=3) 
by tucaseid: egen int min_nonHHchildcare = sum(pchildcare)
drop pchildcare

*caring/helping household adults
gen int padultcare =  tuactdur24 if tutier1code==3 & (tutier2code==4 | tutier2code==5)
by tucaseid: egen int minadultcare = sum(padultcare)
drop padultcare

*petcare (non-veterinary)
gen int ppetcare = tuactdur24 if (tutier1code==2 & tutier2code==6) 
by tucaseid: egen int minpetcare = sum(ppetcare)
drop ppetcare

*create how many missing minutes
gen int missing = tuactdur24 if tutier1code==50
by tucaseid: egen int minmissing = sum(missing)
drop missing

*how many minutes with partner, teen girls, teen boys, or all household children (non work time)
*exclude time when working for consistency across years (added time working and someone present in 2010)
gen int timewpartner = 0
gen int timewteengirls = 0
gen int timewteenboys = 0
gen int timewHHchildren = 0
gen int timewchildren = 0
gen int phrsteengirl_ed = 0
gen int phrsteenboy_ed = 0

for num 2/19: replace timewpartner = tuactdur24 if withrosX==1 & (relationX==20 | relationX==21) & tutier1code~=5
by tucaseid: egen minpartner = sum(timewpartner)

for num 2/19: replace timewteengirls = tuactdur24 if withrosX==1 & relationX==22 & sexX==2 & (ageX>14 & ageX<18) & tutier1code~=5
by tucaseid: egen minteengirls = sum(timewteengirls)

for num 2/19: replace timewteenboys = tuactdur24 if withrosX==1 & relationX==22 & sexX==1  & (ageX>14 & ageX<18) & tutier1code~=5
by tucaseid: egen minteenboys = sum(timewteenboys)

*time with all household children
for num 2/19: replace timewHHchildren = tuactdur24 if withrosX==1 & relationX==22 & sexX==1 & tutier1code~=5
by tucaseid: egen minHHchildren = sum(timewHHchildren)

*time with all household and nonhousehold children
for num 2/19: replace timewchildren = tuactdur24 if withrosX==1 & (relationX==22 | relationX==40) & sexX==1 & tutier1code~=5
by tucaseid: egen minchildren = sum(timewchildren)

*hours on teen girls educational activities
for num 2/19: replace phrsteengirl_ed = tuactdur24 if tutier1code==3 & tutier2code==2 & withrosX==1 & relationX==22 & sexX==2 & (ageX>14 & ageX<18)
by tucaseid: egen minteengirl_ed = sum(phrsteengirl_ed)

*hours on teen boys educational activities
for num 2/19: replace phrsteenboy_ed = tuactdur24 if tutier1code==3 & tutier2code==2 & withrosX==1 & relationX==22 & sexX==1 & (ageX>14 & ageX<18)
by tucaseid: egen minteenboy_ed = sum(phrsteenboy_ed)

drop timewteengirls timewteenboys timewpartner timewHHchildren phrsteenboy_ed phrsteengirl_ed

sort tucaseid

*save summary data for each caseid
keep if tuactivity_n==1

*number of respondents
count

*drop all unneeded variables from respondent file merg
drop tuactivity_n tutier1code tutier2code tutier3code tustarttim tustoptime tuactdur24 tuactdur tewhere lineno*
 
sort tucaseid

save "$DATA/sumdata_parents_of_teens_`YYYY'.dta", replace

use "$ATUSPATH/atusresp_`YYYY'.dta", clear
destring tucaseid, replace
sort tucaseid

*only keep those in the using file
merge 1:1 tucaseid using "$DATA/sumdata_parents_of_teens_`YYYY'.dta"
keep if _merge==3
drop _merge
sort tucaseid tulineno

compress

save "$DATA/newrespondent_parents_of_teens_`YYYY'.dta", replace

*rm "$DATA/sumdata_parents_of_teens_`YYYY'.dta"
}

*use the 2004 weighting method in 2003 in order to pool
use "$DATA/newrespondent_parents_of_teens_2003.dta"

rename tufinlwgt oldtufinlwgt 
rename tu06fwgt tufinlwgt
sort tucaseid tulineno
save "$DATA/newrespondent_parents_of_teens_2003.dta", replace
use "$DATA/newrespondent_parents_of_teens_2004.dta"

rename tufinlwgt oldtufinlwgt 
rename tu06fwgt tufinlwgt
sort tucaseid tulineno
save "$DATA/newrespondent_parents_of_teens_2004.dta", replace
use "$DATA/newrespondent_parents_of_teens_2005.dta"

rename tufinlwgt oldtufinlwgt 
rename tu06fwgt tufinlwgt
sort tucaseid tulineno
save "$DATA/newrespondent_parents_of_teens_2005.dta", replace

