*Author - Sabrina Wulff Pabilonia
*Paper : Parental Disabilty and Teenagers' Time Allocation
*Last Updated: 03-13-2022
*mergecps_parents_of_teens.do
*merge in the ATUS-CPS file to obtain parental education, disability status, MSA status, extra adult in HH of both parents

version 17.0

*define directories (use forward slash)
global DATA "X:/Charlene teens parentdisability/Data"
global LOG "X:/Charlene teens parentdisability/Log"

*original ATUS data stored
global ATUSPATH "A:/ATUS"
clear
set more 1
cap log close

log using "$LOG/mergecps_parents_of_teens.log", replace

*this file has all the ATUS parents of teenagers aged 15-17 between 2003 and 2019
use "$PATH/Data/newrespondent_parents_of_teens_2003.dta", clear
foreach YYYY of num 2004/2019{
append using "$PATH/Data/newrespondent_parents_of_teens_`YYYY'.dta"
}
count
save "$ATUSPATH/newrespondent_parents_of_teens_2003_2019.dta", replace

*******************************************
*1.merge newrespondent and atus_cps files**
*******************************************
use "$ATUSPATH/atuscps_2003_2019.dta", clear
drop huprscnt huspnish hurespli huinttyp huhhnum hutypea hutypb hutypc hubus hubusl1 hubusl2 hubusl3 hubusl4 
sort tucaseid 
merge m:1 tucaseid using "$ATUSPATH/newrespondent_parents_of_teens_2003_2019.dta"
keep if _merge==3
drop _merge
sort tucaseid tulineno

*reformat tucaseid to view the entire number in STATA editor
format tucaseid %15.0f

save "$ATUSPATH/newrespondent_atuscps_parents_of_teens_2003_2019.dta", replace

*************************************************************************
*2. Use the matched data to calculate all the parent variables***********
*************************************************************************

use "$ATUSPATH/newrespondent_atuscps_parents_of_teens_2003_2019.dta", clear

count
*keep only those in heterosexual couples
keep if heterosexual_couple==1

count

*identify the spouse/partner in the household
gen byte idpartner = (partner==tulineno)

***********************************************************************
*the ATUS partner may not have been in final CPS month (ATUS-CPS file)*
*but they all were
***********************************************************************
count if partner==.

************************************************************
*does the parent and partner have a work-related disability*
************************************************************
gen byte self_workdisability = 0
gen byte partner_workdisability = 0
replace self_workdisability = 1 if tulineno==1 & (pudis==1 | pudis1==1 | pudis2==1)
replace self_workdisability = . if tulineno==1 & (pudis==-2 | pudis1==-2 | pudis2==-2 | pudis==-3 | pudis1==-3 | pudis2==-3)
replace partner_workdisability = 1 if idpartner==1 & (pudis==1 | pudis1==1 | pudis2==1)
replace partner_workdisability = . if idpartner==1 & (pudis==-2 | pudis1==-2 | pudis2==-2 | pudis==-3 | pudis1==-3 | pudis2==-3)
by tucaseid: egen byte self_wdisability = max(self_workdisability), missing
by tucaseid: egen byte partner_wdisability = max(partner_workdisability), missing

drop self_workdisability partner_workdisability

******************************************************
*self or partner may be missing workdisabilty status*
*2 self and 1 partner is missing**********************
******************************************************

gen byte self_no_workdisability = 0
gen byte partner_no_workdisability = 0
replace self_no_workdisability = 1 if tulineno==1 & (pudis==-2 | pudis1==-2 | pudis2==-2 | pudis==-3 | pudis1==-3 | pudis2==-3)
replace partner_no_workdisability = 1 if idpartner==1 & (pudis==-2 | pudis1==-2 | pudis2==-2 | pudis==-3 | pudis1==-3 | pudis2==-3)
by tucaseid: egen byte self_missing_wdisability = max(self_no_workdisability)
by tucaseid: egen byte partner_missing_wdisability = max(partner_no_workdisability)
drop self_no_workdisability partner_no_workdisability 

******************************
*education of self and partner
******************************

gen byte temp_ownedu = 0
gen byte temp_partneredu = 0
replace temp_ownedu = peeduca if tulineno==1  
replace temp_partneredu = peeduca if idpartner==1
by tucaseid: egen byte ownedu = max(temp_ownedu)
by tucaseid: egen byte partneredu = max(temp_partneredu)

drop temp_ownedu temp_partneredu

*************************
*employed status in ATUS*
*TELFS = 1 or 2
*************************

gen byte own_w = 0
gen byte own_atwork = 0

*employed
replace own_w = 1 if (telfs==1 | telfs==2) & tulineno==1  
*in some cases the partner is armed services so count as employed
replace own_w = 1 if tulineno==1 & prpertyp==3

*employed and at work
replace own_atwork = 1 if (telfs==1) & tulineno==1  
*in some cases the partner is armed services so count as employed
replace own_atwork = 1 if tulineno==1 & prpertyp==3

by tucaseid: egen byte ownemp = max(own_w)
by tucaseid: egen byte ownworking = max(own_atwork)

drop own_w own_atwork

*********************************************
*3. Calculate parent level variables*********
*********************************************
*keep only ATUS respondents
drop if tulineno~=1

*lives in MSA (metropolitan status variable changes in May 2004 CPS) 
gen byte msa = (gemetsta==1) if (hryear4<2004 | hrmonth<5 & hryear4==2004)
replace msa = (gtmetsta==1) if (hrmonth>4 & hryear==2004 | hryear>2004)

****************************************************************************************************
*extra adult (age 19+) in household that is not spouse or unmarried partner of the parent respondent
*it could be adult child
****************************************************************************************************

gen byte extra_adult = 0
for num 2/19: replace extra_adult = 1 if relationX~=20 & relationX~=21 & relationX~=. & ageX>18

sort tucaseid

save "$PATH/Data/atus_allyears_parents_of_teens.dta", replace
 
log close 

