*mergecps_full_files.do

*put together all atus-cps single year files and all newrespondent files
*can't use multi-use files as they don't have all flags and need disability flags

# delimit cr

version 17.0 

clear 
clear matrix 
cap log close 
set more off  

* Define the directory where original ATUS data is stored
global ATUSPATH "A:/ATUS"

*define the work file directory for the project
global PATH "X:/Charlene teens parentdisability"

log using "$PATH/Log/mergecps_fullfiles", replace

/*
*destring atus_cps files 2009-2019 (downloaded as str14)
foreach YYYY of num 2019{
use "$ATUSPATH/atuscps_`YYYY'.dta", clear
destring tucaseid, replace
save "$ATUSPATH/atuscps_`YYYY'.dta", replace
}
*/
****************************************************************
*Create person link to match ATUS-CPS to other basic CPS months*
*Following ATUS User Guide 2021 p. 108**************************
****************************************************************

use "$ATUSPATH/atuscps_2003.dta", clear
gen numhrsample=substr(hrsample,2,2) 
tokenize "`c(ALPHA)'"
forval b = 1/26 {
label def alphabet `b' "``b''", add
}
encode hrsersuf, gen(serstr) label(alphabet) 
drop hrsersuf
tostring serstr, gen(hrsersuf) format(%02.0f)
replace hrsersuf="00" if hrsersuf=="."
egen hrhhid2=concat(numhrsample hrsersuf huhhnum)
destring hrhhid2, replace
format hrhhid2 %12.0g
sort hrhhid hrhhid2 pulineno
drop numhrsample hrsersuf huhhnum 
save "$ATUSPATH/atuscps_linkid_2003.dta", replace

****************************************** 
*create identifiers for prior to May 2004   
****************************************** 
use "$ATUSPATH/atuscps_2004.dta", clear
keep if hrmonth<=4
*all values are -1
drop hrhhid2
gen numhrsample=substr(hrsample,2,2) 
tokenize "`c(ALPHA)'"
forval b = 1/26 {
label def alphabet `b' "``b''", add
}
encode hrsersuf, gen(serstr) label(alphabet) 
drop hrsersuf
tostring serstr, gen(hrsersuf) format(%02.0f)
replace hrsersuf="00" if hrsersuf=="."
egen hrhhid2=concat(numhrsample hrsersuf huhhnum)
destring hrhhid2, replace
format hrhhid2 %12.0g
sort hrhhid hrhhid2 pulineno
drop numhrsample hrsersuf huhhnum
save "$ATUSPATH/atuscps_linkid_Jan_April2004.dta", replace

use "$ATUSPATH/atuscps_2004.dta", clear
keep if hrmonth>4
sort hrhhid hrhhid2 pulineno
save "$ATUSPATH/atuscps_linkid_May_Dec2004.dta", replace

****************************
*combine ATUS-CPS 2003-2019*
****************************
use "$ATUSPATH/atuscps_linkid_2003.dta", clear
append using "$ATUSPATH/atuscps_linkid_Jan_April2004.dta"
append using "$ATUSPATH/atuscps_linkid_May_Dec2004.dta"
foreach YYYY of num 2005/2019{
append using "$ATUSPATH/atuscps_`YYYY'.dta"
}
save "$ATUSPATH/atuscps_2003_2019.dta", replace

*this file has all the ATUS teenagers aged 15-17 between 2003 and 2019
use "$PATH/Data/newrespondent_2003.dta", clear
foreach YYYY of num 2004/2019{
append using "$PATH/Data/newrespondent_`YYYY'.dta"
}
count
save "$ATUSPATH/newrespondent_2003_2019.dta", replace


*******************************************
*merge newrespondent and atus_cps files**
*******************************************
use "$ATUSPATH/atuscps_2003_2019.dta", clear
sort tucaseid 
merge m:1 tucaseid using "$ATUSPATH/newrespondent_2003_2019.dta"
keep if _merge==3
drop _merge
sort tucaseid tulineno

*reformat tucaseid to view the entire number in STATA editor
format tucaseid %15.0f

save "$ATUSPATH/newrespondent_atuscps_2003_2019.dta", replace

*************************************************************************
*2. Use the matched data to calculate all the parent variables***********
*************************************************************************

*this data set includes all teenagers and their family members
use "$ATUSPATH/newrespondent_atuscps_2003_2019.dta", clear

*identify the mother and the father of the teen in the family
gen byte idmother = (mother==tulineno)
gen byte idfather = (father==tulineno)

******************************************************
*what if father or mother are not present in ATUSCPS*
*there will be no information on work disability
******************************************************
 
by tucaseid: egen byte mother_notmissing_atuscps = max(idmother)
by tucaseid: egen byte father_notmissing_atuscps = max(idfather)

****************************************************
*the person does not have a parent on ATUS roster***
*this could be because single parent household******
****************************************************

gen byte dfather = (father==.)
gen byte dmother = (mother==.)

*these are not single headed households but rather they were on ATUS roster but not on ATUS-CPS file
*could be change in household status
gen mother_miss_atuscps = 1 if mother_notmissing_atuscps==0 & mother~=.
gen father_miss_atuscps = 1 if father_notmissing_atuscps==0 & father~=.

*************************************************************
*does the parent have any disability - CPS June 2008 forward*
*note no missing values for prdisflg*************************
*************************************************************

*note that flag values==-1 if younger than age 15 (not eligible for question) but 0.38% of adults are also missing (don't know or refused)
*only one mother and one father in household so evaluate to missing if their disability status was missing
gen byte temp_mother_anydisability = 0 if (hryear4>2008 | (hryear4==2008 & hrmonth>=6))
gen byte temp_father_anydisability = 0 if (hryear4>2008 | (hryear4==2008 & hrmonth>=6))
replace temp_mother_anydisability = (prdisflg==1) if idmother==1 & (hryear4>2008 | (hryear4==2008 & hrmonth>=6))
replace temp_father_anydisability = (prdisflg==1) if idfather==1 & (hryear4>2008 | (hryear4==2008 & hrmonth>=6))
replace temp_mother_anydisability = . if prdisflg==-1 & idmother==1 & (hryear4>2008 | (hryear4==2008 & hrmonth>=6))
replace temp_father_anydisability = . if prdisflg==-1 & idfather==1 & (hryear4>2008 | (hryear4==2008 & hrmonth>=6))
by tucaseid: egen byte mother_anydisability = max(temp_mother_anydisability) if (hryear4>2008 | (hryear4==2008 & hrmonth>=6)), missing
by tucaseid: egen byte father_anydisability = max(temp_father_anydisability) if (hryear4>2008 | (hryear4==2008 & hrmonth>=6)), missing
drop temp_mother_anydisability temp_father_anydisability

foreach x of new ear eye rem phy drs out{
	gen byte temp_mother_dis`x' = 0 if (hryear4>2008 | (hryear4==2008 & hrmonth>=6))
	gen byte temp_father_dis`x' = 0 if (hryear4>2008 | (hryear4==2008 & hrmonth>=6))
	replace temp_mother_dis`x' = (pedis`x'==1) if idmother==1 & (hryear4>2008 | (hryear4==2008 & hrmonth>=6))
	replace temp_father_dis`x' = pedis`x' if idfather==1 & (hryear4>2008 | (hryear4==2008 & hrmonth>=6))
	replace temp_mother_dis`x' = . if pedis`x'==-1 & idmother==1 & (hryear4>2008 | (hryear4==2008 & hrmonth>=6))
	replace temp_father_dis`x' = . if pedis`x'==-1 & idfather==1 & (hryear4>2008 | (hryear4==2008 & hrmonth>=6))
	by tucaseid: egen byte mother_dis`x' = max(temp_mother_dis`x') if (hryear4>2008 | (hryear4==2008 & hrmonth>=6)), missing
	by tucaseid: egen byte father_dis`x' = max(temp_father_dis`x') if (hryear4>2008 | (hryear4==2008 & hrmonth>=6)), missing
	drop temp_mother_dis`x' temp_father_dis`x'
}

***********************************************
*does the parent have a work-related disability
*note - one mother missing, one father missing
***********************************************

gen byte mother_workdisability = 0
gen byte father_workdisability = 0
replace mother_workdisability = 1 if idmother==1 & (pudis==1 | pudis1==1 | pudis2==1)
replace father_workdisability = 1 if idfather==1 & (pudis==1 | pudis1==1 | pudis2==1)
replace mother_workdisability = . if idmother==1 & (pudis==-2 | pudis1==-2 | pudis2==-2 | pudis==-3 | pudis1==-3 | pudis2==-3)
replace father_workdisability = . if idfather==1 & (pudis==-2 | pudis1==-2 | pudis2==-2 | pudis==-3 | pudis1==-3 | pudis2==-3)
by tucaseid: egen byte mother_wdisability = max(mother_workdisability), missing
by tucaseid: egen byte father_wdisability = max(father_workdisability), missing
drop mother_workdisability father_workdisability

******************************************************
*mother or father may be missing workdisabilty status*
******************************************************
gen byte mother_miss_workdisability = 0
gen byte father_miss_workdisability = 0
replace mother_miss_workdisability = 1 if idmother==1 & (pudis==-2 | pudis1==-2 | pudis2==-2 | pudis==-3 | pudis1==-3 | pudis2==-3)
replace father_miss_workdisability = 1 if idfather==1 & (pudis==-2 | pudis1==-2 | pudis2==-2 | pudis==-3 | pudis1==-3 | pudis2==-3)
by tucaseid: egen byte mother_missing_wdisability = max(mother_miss_workdisability)
by tucaseid: egen byte father_missing_wdisability = max(father_miss_workdisability)
drop mother_miss_workdisability father_miss_workdisability 

*****************************************
*education level of the mother and father
*no missing values for those over age 14
*****************************************
gen byte temp_motheredu = 0
gen byte temp_fatheredu = 0
replace temp_motheredu = peeduca if idmother==1 
replace temp_fatheredu = peeduca if idfather==1
by tucaseid: egen byte motheredu = max(temp_motheredu)
by tucaseid: egen byte fatheredu = max(temp_fatheredu)
drop temp_motheredu temp_fatheredu

****************************
*mother and father employed*
****************************
gen byte mother_w = 0
gen byte father_w = 0

replace mother_w = 1 if (pemlr==1 | pemlr==2) & idmother==1
replace father_w = 1 if (pemlr==1 | pemlr==2) & idfather==1
*in some cases the parent is armed services so count as employed
replace mother_w = 1 if idmother==1 & prpertyp==3 
replace father_w = 1 if idfather==1 & prpertyp==3 

by tucaseid: egen byte motheremp = max(mother_w)
by tucaseid: egen byte fatheremp = max(father_w)
drop mother_w father_w

***********************************************************************
*3. Does the parent have a work-related disability in CPS MIS4 & MIS8?*
***********************************************************************

preserve

sort hrhhid hrhhid2 pulineno

merge 1:1 hrhhid hrhhid2 pulineno using "C:/Users/PABILONIA_S/OneDrive - US Department of Labor - BLS/Documents/Charlene teens parentaldisability/Data/cpsdisabilitydata_MIS4.dta"
keep if _merge==3
rename _merge MIS4

gen byte mother_MISdisability = 0
gen byte father_MISdisability = 0
replace mother_MISdisability = 1 if idmother==1 & mis4_disability==1
replace father_MISdisability = 1 if idfather==1 & mis4_disability==1
*in some instances the disability status could be missing 
replace mother_MISdisability = . if idmother==1 & mis4_disability==.
replace father_MISdisability = . if idfather==1 & mis4_disability==.
bys tucaseid: egen byte mother_MIS4disability = max(mother_MISdisability), missing
bys tucaseid: egen byte father_MIS4disability = max(father_MISdisability), missing
drop mother_MISdisability father_MISdisability

gen byte matchedsampleMIS4 = 1
*if they don't know the status in MIS4 then treat as missing
replace matchedsampleMIS4= 0 if mother_MIS4disability==. | father_MIS4disability==.

keep tucaseid tulineno mother_MIS4disability father_MIS4disability matchedsampleMIS4  
keep if tulineno==1
save "C:/Users/PABILONIA_S/OneDrive - US Department of Labor - BLS/Documents/Charlene teens parentaldisability/Data/MIS4.dta", replace

restore

****************************************
*Calculate teen level variables*
****************************************
*keep only ATUS respondents
drop if tulineno~=1

sort tucaseid
*merge on the MIS4 disability
merge 1:1 tucaseid using "C:/Users/PABILONIA_S/OneDrive - US Department of Labor - BLS/Documents/Charlene teens parentaldisability/Data/MIS4.dta"
drop if _merge==2
drop _merge

sort tucaseid

******************************************************************
*does the teen respondent have any disability - June 2008 forward*
******************************************************************
gen byte temp_teen_anydisability = 0 if (hryear4>2008 | (hryear4==2008 & hrmonth>=6))
replace temp_teen_anydisability = (prdisflg==1) if tulineno==1 & (hryear4>2008 | (hryear4==2008 & hrmonth>=6))
replace temp_teen_anydisability = . if prdisflg==-1 & tulineno==1 & (hryear4>2008 | (hryear4==2008 & hrmonth>=6))
by tucaseid: egen byte teen_anydisability = max(temp_teen_anydisability) if (hryear4>2008 | (hryear4==2008 & hrmonth>=6)), missing
drop temp_teen_anydisability

foreach x of new ear eye rem phy drs out{
	gen byte temp_teen_dis`x' = 0 if (hryear4>2008 | (hryear4==2008 & hrmonth>=6))
	replace temp_teen_dis`x'= (pedis`x'==1) if tulineno==1 & (hryear4>2008 | (hryear4==2008 & hrmonth>=6))
	replace temp_teen_dis`x'= . if pedis`x'==-1 & tulineno==1 & (hryear4>2008 | (hryear4==2008 & hrmonth>=6))
	by tucaseid: egen byte teen_dis`x'= max(temp_teen_dis`x') if (hryear4>2008 | (hryear4==2008 & hrmonth>=6)), missing
	drop temp_teen_dis`x'
}

*lives in MSA (metropolitan status variable changes in May 2004 CPS) 

*lives in MSA
gen byte msa = (gemetsta==1) if (hryear4<2004 | hrmonth<5 & hryear4==2004)
replace msa = (gtmetsta==1) if (hrmonth>4 & hryear==2004 | hryear>2004)

*number of siblings
for num 2/19: gen byte sibX = 0
for num 2/19: replace sibX = 1 if relationX==25
egen byte numsibs = rowtotal(sib2-sib19)
drop sib2-sib19

******************************************************
*sibling gender***************************************
******************************************************

gen byte youngerbrothers = 0
for num 2/19: replace youngerbrothers = 1 if relationX==25 & ageX<age1 & sexX==1

gen byte youngersisters = 0
for num 2/19: replace youngersisters = 1 if relationX==25 & ageX<age1 & sexX==2

gen byte olderbrothers = 0
for num 2/19: replace olderbrothers = 1 if relationX==25 & ageX>age1 & sexX==1

gen byte oldersisters = 0
for num 2/19: replace oldersisters = 1 if relationX==25 & ageX>age1 & sexX==2

gen byte sameageteen = 0
for num 2/19: replace sameageteen = 1 if relationX==25 & ageX==age1

******************************************************
*extra adult (age 19+) in household that is not parent
*it could be a sibling
******************************************************

gen byte extra_adult = 0
for num 2/19: replace extra_adult = 1 if relationX~=24 & relationX~=. & ageX>18

sort tucaseid

save "$PATH/Data/atus_allyears.dta", replace



