*Author - Sabrina Wulff Pabilonia
*Paper : Parental Disabilty and Teenagers' Time Allocation
*Last Updated: March 13, 2022
*atus_parents_of_teens_parentdisability.do 

global DATA "X:/Charlene teens parentdisability/Data"
global LOG "X:/Charlene teens parentdisability/Log"
global TABLES "X:/Charlene teens parentdisability/Tables/"

clear 
set more 1 
cap log close 

version 17.0 

log using "$LOG/atus_parents_of_teens_parentdisability.log", replace 

use "$PATH/Data/atus_allyears_parents_of_teens.dta", clear

********************************************** 
*Sample restrictions 
*Parents of teenagers aged 15-17 
*interviewed during the school year 
*have valid response on parents' disability 
********************************************** 

count 

*month dummies 
tabulate tumonth, gen(m) 

*control for time of year 
gen byte summer = (tumonth==6 | tumonth==7 | tumonth==8) 
tab summer 

gen byte schoolyear = (summer==0) 

*keep those interviewed during the school year 
keep if schoolyear==1 

count

*drop if self or partner disability is missing
drop if self_missing_wdisability==1
drop if partner_missing_wdisability==1

*how many have parent with work-related disability (can't accept any work in next six months) 
gen byte disabled = (self_wdisability==1 | partner_wdisability==1) 

gen byte mdisabled = (self_wdisability==1 & sex1==2) 
replace mdisabled = 1 if partner_wdisability==1 & sex1==1 

gen byte fdisabled = (self_wdisability==1 & sex1==1) 
replace fdisabled = 1 if partner_wdisability==1 & sex1==2 

*don't know (1 missing own disability status) 
replace disabled = . if self_missing_wdisability==1 | partner_missing_wdisability==1 
drop if disabled==. 

count

*count sample of parents with teens where the family has at least one disabled parent 
tab tuyear 

*how many live with single mother 
gen byte singlemother = (single==1 & sex1==2) 
tab singlemother
 
*how many live with single father 
gen byte singlefather = (single==1 & sex1==1) 
tab singlefather 

*how many live with two parents 
tab heterosexual_couple 

*cohabiter
gen byte cohabiter = (married==0 & heterosexual_couple==1)

tab cohabiter
tab married if heterosexual_couple==1

*create day of the week dummies 
gen byte sunday = tudiaryday==1 
gen byte monday = tudiaryday==2 
gen byte tuesday = tudiaryday==3 
gen byte wed = tudiaryday==4 
gen byte thurs = tudiaryday==5 
gen byte friday = tudiaryday==6 
gen byte saturday = tudiaryday==7 
gen byte holiday = trholiday==1 

*weekend or holidays 
gen byte weekend = (sunday==1 | saturday==1 | holiday==1) 
gen byte weekday = (weekend~=1) 

*gender 
gen byte female = (sex1==2) 
gen byte male = (female==0) 

*REWEIGHT PROGRAM FOR EQUAL DAY OF THE WEEK REPRESENTATION FOR PARENT SAMPLE BY GENDER WITHIN YEAR
gen rewgtyr = 0
capture program drop reweight
program define reweight
	foreach x of num 2003/2019{
		quietly: tabstat tufinlwgt if female==1 & tuyear==`x', stat(sum) by(tudiaryday) format(%20.0g) save
		replace rewgtyr= 0 if tuyear==`x' & female==1 
		forvalues i = 1/7{
			scalar dayfac`i' = det(r(Stat`i'))/det(r(StatTotal))
			replace rewgtyr = (tufinlwgt/dayfac`i')/7 if tudiaryday==`i' & female==1 & tuyear==`x'
		}
		quietly: tabstat tufinlwgt if female==0 & tuyear==`x', stat(sum) by(tudiaryday) format(%20.0g) save
		replace rewgtyr= 0 if tuyear==`x' & female==0 
		forvalues i = 1/7{
			scalar dayfac`i' = det(r(Stat`i'))/det(r(StatTotal))
			replace rewgtyr = (tufinlwgt/dayfac`i') if tudiaryday==`i' & female==0 & tuyear==`x'
		}
	}
end
scalar drop _all

reweight
svyset [pw=rewgtyr]  

*footnote X - number of families with teenagers who have a disabled parent 
svy: mean disabled 

*create race/ethnicity variables 
*hispanic is not mutually exclusive 
gen byte hispanic = (pehspnon==1) 
*primary race category, other includes mixed race categories 
gen byte white = (ptdtrace==1) 
gen byte black = (ptdtrace==2) 
gen byte asian = (ptdtrace==4) 
gen byte other = (ptdtrace>=3 & asian~=1) 

*other race options 
gen byte asianother = (asian==1 | other==1) 
gen byte nonblack = (black==0) 
gen byte NBNH = (white==1 | other==1) 
gen byte nonwhite = (black==1 | asian==1 | other==1) 

*Census region 
quietly tab gereg, gen(reg) 

*education variables 
gen byte mbachelor = 0 
replace mbachelor = 1 if (ownedu==43 | ownedu==44 | ownedu==45 | ownedu==46) & sex1==2 
replace mbachelor = 1 if (partneredu==43 | partneredu==44 | partneredu==45 | partneredu==46) & sex1==1 
gen byte fbachelor = 0 
replace fbachelor = 1 if (ownedu==43 | ownedu==44 | ownedu==45 | ownedu==46) & sex1==1 
replace fbachelor = 1 if (partneredu==43 | partneredu==44 | partneredu==45 | partneredu==46) & sex1==2 

*household income - change categories 
*use hufaminc 2003-2009, use hefaminc 2010-2019 
gen byte incmis = 0 
gen byte inc30 = 0 
gen byte inc3075 = 0 
gen byte inc75 = 0 

replace incmis = 1 if hufaminc < 0 & hryear4<2010 
replace inc30 = 1 if (hufaminc>=1 & hufaminc<=8) & hryear4<2010 
replace inc3075 = 1 if (hufaminc>8 & hufaminc<=13) & hryear4<2010  
replace inc75 = 1 if (hufaminc>=14) & hryear4<2010 

replace incmis = 1 if (hefaminc < 0) & hryear4>=2010 
replace inc30 = 1 if (hefaminc>=1 & hefaminc<=8) & hryear4>=2010 
replace inc3075 = 1 if (hefaminc>8 & hefaminc<=13) & hryear4>=2010 
replace inc75 = 1 if hefaminc>=14 & hryear4>=2010
 
*year dummies 
for num 2003/2019: gen byte yearX = (tuyear==X) 

*age and age squared 
gen byte age = age1 
gen int agesquared = age1^2 

*create the highest degree of either parent is bachelor's degree 
gen byte parentbach = (fbachelor==1 | mbachelor==1) 
gen byte notparentbach = (parentbach==0) 

*labels for time use activities 
label var minkid_ed "Children's educational activities" 
label var minteengirl_ed "Time on teenage girl educational activities" 
label var minteenboy_ed "Time on teenage boy educational activities" 
label var minwk "Work and work-related activities(not commuting)" 
label var minsleep "Sleep" 
label var minpersonal "Personal care activities" 
label var minhousehold "Household production" 
label var minhousework "Housework (cleaning, laundry, etc.)" 
label var minbuy "Buying goods and services" 
label var minfoodprep "Food preparation and clean-up"  
label var minchildcare "Primary childcare of household children"
label var min_nonHHchildcare "Primary childcare of nonhousehold children" 
label var minadultcare "Caring/helping household adults" 
label var minpetcare "Pet care" 
label var minallleisure "Leisure" 
label var minpartner "Time with partner/spouse" 
label var minteengirls "Time with teenage daughters" 
label var minteenboys "Time with teenage sons" 
label var minHHchildren "Time with household children"
label var minchildren "Time with own children"
label var ownemp "Employed" 
label var nonwhite "Nonwhite" 
label var white "White" 
label var nonblack "Nonblack" 
label var black "Black" 
label var asianother "Other" 
label var hispanic "Hispanic" 
label var singlemother "Single mother" 
label var singlefather "Single father" 
label var disabled "A parent has a work-related disability" 
label var extra_adult "Extra adult (age 19+) not parent in household" 
label var num_HHchildren "Number of own household children under age 19" 
label define cohabiter 0 "Not cohabiter" 1 "Cohabiter"
label values cohabiter cohabiter

*adjust the controls - collapse black asianother to nonwhite, remove parent is foreign born, collapse income groups 
 
*19 controls for Table X 
global summarystats "age white nonwhite hispanic singlemother singlefather heterosexual_couple parentbach extra_adult num_HHchildren incmis inc30 inc3075 inc75 msa reg2 reg3 reg4 weekday" 

global mycontrols "age agesquared nonwhite hispanic cohabiter singlemother singlefather parentbach extra_adult num_HHchildren incmis inc3075 inc75 msa reg2 reg3 reg4 weekday m2-m5 m9-m12 year2003-year2018" 

global mycontrols_twoparents "age agesquared nonwhite hispanic parentbach extra_adult num_HHchildren incmis inc3075 inc75 msa reg2 reg3 reg4 weekday m2-m5 m9-m12 year2003-year2018" 

*17 daily minutes outcomes outcomes 
global timeuse "minkid_ed minteengirl_ed minteenboy_ed minwk minhousehold minhousework minbuy minfoodprep minchildcare minadultcare minpetcare minallleisure minsleep minpersonal minpartner minteengirls minteenboys" 

*create indicator for participation in activity 
foreach x of var minkid_ed minteengirl_ed minteenboy_ed minwk minhousehold minhousework minbuy minfoodprep minchildcare minadultcare minpetcare minallleisure minsleep minpersonal minpartner minteengirls minteenboys { 
gen byte d`x' = (`x'>0) 
} 

*17 participation outcomes 
global dtimeuse "dminkid_ed dminteengirl_ed dminteenboy_ed dminwk dminhousehold dminhousework dminbuy dminfoodprep dminchildcare dminadultcare dminpetcare dminallleisure dminsleep dminpersonal dminpartner dminteengirls dminteenboys" 

*different samples 
*all mothers living with teenage girls 
gen byte mother_girls = 0 
for num 2/14: replace mother_girls = 1 if sex1==2 & teengirl_15_17_X==1 
*all fathers living with teenage girls 
gen byte father_girls = 0 
for num 2/14: replace father_girls = 1 if sex1==1 & teengirl_15_17_X==1 
*all mothers living with teenage boys 
gen byte mother_boys = 0 
for num 2/14: replace mother_boys = 1 if sex1==2 & teenboy_15_17_X==1 
*all fathers living with teenage boys 
gen byte father_boys = 0 
for num 2/14: replace father_boys = 1 if sex1==1 & teenboy_15_17_X==1 

*sample counts and percentage disabled 
svy: tab mdisabled fdisabled if mother_girls==1 
svy: tab mdisabled fdisabled if father_girls==1 
svy: tab mdisabled fdisabled if mother_boys==1 
svy: tab mdisabled fdisabled if father_boys==1 

*text p.X - What % have a parent with a work-related disability 
svy: mean disabled mdisabled fdisabled if mother_girls==1 
svy: mean disabled mdisabled fdisabled if father_girls==1 
svy: mean disabled mdisabled fdisabled if mother_boys==1 
svy: mean disabled mdisabled fdisabled if father_boys==1 

***********************************************************************
*test whether the person is employed or employed and at work in ATUS 
*if they reported being disabled in CPS final month*
*footnote 3
***********************************************************************
*mothers
tab mdisabled ownemp if mother_girls==1 | mother_boys==1
*fathers
tab fdisabled ownemp if father_girls==1 | father_boys==1

*mothers
tab mdisabled ownworking if mother_girls==1 | mother_boys==1
*fathers
tab fdisabled ownworking if father_girls==1 | father_boys==1

*********************** 
*LIVING WITH TEEN BOYS*
*At least one teen boy*
*Coupled households**** 
*APPENDIX Table A6***** 
*********************** 
*MOTHERS 
*probit
svy, subpop(if mother_boys==1 & heterosexual_couple==1): probit ownemp fdisabled cohabiter $mycontrols_twoparents 
margins, dydx(fdisabled) post vce(unconditional) 
outreg2 using "$TABLES/TableA6.doc", bdec(3) ctitle(ownemp) nor nobs replace 
*Tobit 
svy, subpop(if mother_boys==1 & heterosexual_couple==1): tobit minwk fdisabled cohabiter $mycontrols_twoparents , ll(0) 
margins, dydx(fdisabled) predict(ystar(0,.)) post vce(unconditional) 
outreg2 using "$TABLES/TableA6.doc", bdec(3) ctitle(minwk) nor nobs ap 
*OLS 
foreach x of varlist minhousehold minallleisure minsleep minteenboys minpartner{ 
svy, subpop(if mother_boys==1 & heterosexual_couple==1): reg `x' mdisabled fdisabled cohabiter $mycontrols_twoparents  
outreg2 mdisabled fdisabled using "$TABLES/TableA6.doc", bdec(3) ctitle(`x') nocons nor nobs ap 
} 

log close 

