function [table_subsystems,all_rxns] = analyze_results(all_comb,model)
%function [table_subsystems,all_rxns] = analyze_results(all_comb,model)
% Input
% Output
%Retrieves the subsystems that correspond to each of the KO 
%and calculate the normalized ferquency of each subsystem

 
    %% Subsystems correspondence: to have a total of 14 subsystems in the model,
    %instead of 29
    correspondence={'GlycolysisGluconeogenesis','Central Carbon Metabolism';...
        'Pyruvate Metabolism','Central Carbon Metabolism';...
        'Citric Acid Cycle','Central Carbon Metabolism';...
        'Pentose Phosphate Pathway','Central Carbon Metabolism';...
        'Nucleotide Salvage Pathway','Nucleotide Biosynthesis';...
        'Purine and Pyrimidine Biosynthesis','Nucleotide Biosynthesis';...
        'Transport Extracellular','Transport';...
        'Exchange','Transport';...
        'Anaplerotic reactions','Anaplerotic reactions';...
        'Organic acid','Anaplerotic reactions';...
        'Glyoxylate Metabolism','Anaplerotic reactions';...
        'Alternate Carbon Metabolism','Alternate carbon metabolism';...
        'Cofactor and Prosthetic Group Biosynthesis','Cofactors and folate';...
        'Folate Metabolism','Cofactors and folate';...
        'Oxidative Phosphorylation','Oxidative phosphorylation';...
        'Cell Envelope Biosynthesis','Cell wall and membrane';...
        'Membrane Lipid Metabolism','Cell wall and membrane';...
        'Arginine and Proline Metabolism','Glutamate, arginine and proline metabolism';...
        'Glutamate metabolism','Glutamate, arginine and proline metabolism';...
        'Valine Leucine and Isoleucine Metabolism','Alanine, aspartate, valine and (isso)leucine metabolism';...
        'Alanine and Aspartate Metabolism','Alanine, aspartate, valine and (isso)leucine metabolism';...
        'Threonine and Lysine Metabolism','Threonine, lysine and methionine metabolism';...
        'Methionine Metabolism','Threonine, lysine and methionine metabolism';...
        'Tyrosine Tryptophan and Phenylalanine Metabolism','Histidine and aromatic aminoacids metabolism';...
        'Histidine Metabolism','Histidine and aromatic aminoacids metabolism';...
        'Glycine and Serine Metabolism','Cysteine, glycine and serine metabolism';...
        'Cysteine Metabolism','Cysteine, glycine and serine metabolism';...
        'Unassigned','Unassigned';...
        'Leakage','Unassigned';...
        'slipe','Unassigned';...
        'empty','Unassigned'};


    %% Subsystem frequency in the model

    %get array with subsystems in model
    model_subs=model.subSystems;
    model_subs(find(cellfun(@isempty,model_subs)))={'empty'};
    for i=1:length(model_subs)
        sub=model_subs{i,1};
        in=find(ismember(correspondence(:,1),sub));
        if isempty(in)
            model_subs{i,1} = ['Unidentified:' sub];
        else
            model_subs{i,1}=correspondence{in,2};
        end
    end

    %calculate frequency of subsystems 
    subsystems=unique(model_subs,'stable');
    freq_model=cell2mat(cellfun(@(x) sum(ismember(model_subs,x)),subsystems,'un',0));


    %% Subsystem frequency in the results

    %get array with subsystems in results
    all_comb=all_comb(find(~cellfun(@isempty,all_comb)));
    all_rxns=unique(all_comb);
    results_subs={};
    for i=1:length(all_rxns)
        in=find(ismember(model.rxns,all_rxns{i,1}));
        if isempty(in)
            disp(all_rxns{i,1});
        end
        results_subs{i,1}=model_subs{in,1};
    end


    %calculate frequency of of subsystems in results
    freq_results=cell2mat(cellfun(@(x) sum(ismember(results_subs,x)),subsystems,'un',0));

    %% Normalize and output

    freq_norm=(freq_results./freq_model).*100;
    
    [sorted_sub_freq,I] = sort(freq_norm,'descend');
    sorted_sub=subsystems(I);
    table_subsystems(:,1)=sorted_sub;
    table_subsystems(:,2)=num2cell(sorted_sub_freq);



end

