% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_aethelometer.R,
%   R/transform_campbell.R, R/transform_envidas.R, R/transform_mesonet.R,
%   R/transform_ultrafine.R
\name{transform_wfms_aethelometer}
\alias{transform_wfms_aethelometer}
\alias{transform_campbell}
\alias{transform_envidas_daily}
\alias{transform_wfm_envidas}
\alias{transform_psp_envidas}
\alias{transform_mesonet}
\alias{transform_ultrafine}
\title{Transform raw data into a common format}
\usage{
transform_wfms_aethelometer(f)

transform_campbell(f, site)

transform_envidas_daily(f)

transform_wfm_envidas(f)

transform_psp_envidas(f)

transform_mesonet(f)

transform_ultrafine(f)
}
\arguments{
\item{f}{Filepath of the raw data file.}

\item{site}{Site abbreviation (only needed when format varies by site).}
}
\value{
A data frame of measurements. The first column is "time" (POSIXct),
  followed by two columns for each parameter-- "value.param_name" and
  "flagged.param_name". "flagged.param_name" columns are all logical vectors,
  where flagged=TRUE indicates that the measurement shouldn't be used.
}
\description{
Read a raw data file and return a data frame of measurements in a
standardized format.
}
\section{Functions}{
\itemize{
\item \code{transform_wfms_aethelometer}: Aethelometer files.

\item \code{transform_campbell}: Campbell datalogger files (WFMS and WFMB).

\item \code{transform_envidas_daily}: Daily Envidas files generated from SQL by a script.

\item \code{transform_wfm_envidas}: Manually exported Envidas files (WFMS and WFMB).

\item \code{transform_psp_envidas}: Manually exported Envidas files (PSP).

\item \code{transform_mesonet}: NYS Mesonet files.

\item \code{transform_ultrafine}: Ultrafine (EPC) files.
}}

