% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derived_values.R
\name{sea_level_pressure}
\alias{sea_level_pressure}
\title{Sea level pressure}
\usage{
sea_level_pressure(press, temp, height)
}
\arguments{
\item{press}{Pressure in millibars.}

\item{temp}{Temperature in Celsius.}

\item{height}{Height above sea level in meters.}
}
\value{
Estimated sea level pressure.
}
\description{
Estimate sea level pressure from local pressure, temperature, and height
using the barometric formula.
}
\details{
We estimate the sea level pressure using the barometric formula,

\deqn{P = P_0 (\frac{T_0}{T})^\frac{Mg}{R^*L}}{P = P0 (T0/T)^(Mg / (Rstar L))}

where \eqn{P} is pressure, \eqn{T} is temperature (in Kelvin), \eqn{H} is
height, and \eqn{L} is the temperature lapse rate. Variables with subscript 0
are the same at sea level. Substituting \eqn{T_0 = T - LH}{T0 = T - LH}, we
can solve for \eqn{P_0}{P0} in terms of pressure, temperature, and height:

\deqn{P_0 = P (\frac{T}{T - LH})^\frac{Mg}{R^*L}}{P0 = P (T/(T - LH))^(Mg/(Rstar L))}

The values of physical constants are taken from
\insertCite{coesa_us_1976;textual}{atmoschem.process}:

\describe{
  \item{\eqn{L} (lapse rate)}{-.0065 K/m}
  \item{\eqn{M} (molar mass of air)}{0.0289644 kg/mol}
  \item{\eqn{g} (gravitational acceleration)}{9.80665 m/s^2}
  \item{\eqn{R^*}{Rstar} (universal gas constant)}{8.31432 J/(mol K)}
}
}
\examples{
# estimate sea level pressure at the Whiteface Mountain summit
sea_level_pressure(800, 30, 1483.5)

}
\references{
\insertAllCited{}
}
