% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{drift_correct}
\alias{drift_correct}
\title{Instrument drift corrections}
\usage{
drift_correct(t, v, z = NULL, s = NULL, config)
}
\arguments{
\item{t}{Measurement times (POSIXct).}

\item{v}{Measurement values.}

\item{z}{Data frame of zero calibration checks. Should contain columns
\code{time}, \code{value}, and \code{corrected} (logical, whether the
instrument was adjusted).}

\item{s}{Data frame of span calibration checks. Should contain columns
\code{time}, \code{value}, and \code{corrected} (logical, whether the
instrument was adjusted).}

\item{config}{list of Configuration options from the \code{measurement_types}
config table.}
}
\value{
Drift-corrected measurements.
}
\description{
Apply instrument drift corrections based on calibration check results.
}
\details{
Zero and span values are estimated using \code{\link{estimate_cals}}. If not
provided, zeros and spans are assumed to be 0 and 1, respectively. The
corrected values are calculated as \eqn{(measurement - zero) / span}.
}
\seealso{
\code{\link{estimate_cals}}
}
