%% RQA of benthic foraminifer record for the past 67 Ma 
% figure 3 in Westerhold et al, Science, 369, 2020

%% import data
z = importdata('CENOGRID_Loess_20.txt');

%% interpolate to uniform time scale
dt = 0.005;
t = (z.data(1,1):dt:z.data(end,1))';

y = zscore(interp1(z.data(:,1),z.data(:,2:3),t,'pchip'));

%% low-pass filter the data
[a b] = butter(5,.001,'high'); % cutoff frequ = 0.2 (1/Ma)
x = filtfilt(a,b,y);

%% get windowed results
w = round(1 ./ dt); % 1000 ky windows
ws = round(.25 ./ dt); % window step 250 ky

for param = 1:2;

   % DET in windows + confidence interval
   [rq rq_quant] = determinism(x(:,param),1,1,.1,w,ws);

   t2 = dt* w/2 + t(1:ws:length(Y));

   % plot determinism
   figure(param)
   h = plot(t2, rq);
   hold on
   plot(t([1 end],1),[rq_quant(i,2) rq_quant(i,2)],'r-.')
   ylabel(txt{i})
   set(gca,'xdir','reverse','TickDir','out','YMinorTick','on','XMinorTick','on')
   xlabel('Age (Ma)')
   title(proxy{param})
   grid on

end
