%% RP of benthic foraminifer record for the past 67 Ma 
% figure 2 in Westerhold et al, Science, 369, 2020

%% import data
z = importdata('CENOGRID_Loess_20.txt');

%% interpolate to uniform time scale and normalize data
dt = 0.005;
t = (z.data(1,1):dt:z.data(end,1))';

y = zscore(interp1(z.data(:,1),z.data(:,2:3),t,'pchip'));

%% low-pass filter the data
[a b] = butter(5,.001,'high'); % cutoff frequ = 0.2 (1/Ma)
x = filtfilt(a,b,y);

%% calculate RP
N = length(x);
proxy = {'d13C';'d18O'};
for param = 1:2;
   % distance matrix
   D = pdist2(y(:,param),y(:,param),'chebychev');
   %D = pdist2(x(:,param),x(:,param),'chebychev'); % uncomment this line if filtered data should be analysed
   
   % recurrence plot by thresholding
   R = D <= 0.1;

   % plot RP
   figure(param)
   imagesc(t,t,R)
   box on
   axis square
   xlabel('Age (Ma)'), ylabel('Age (Ma)')
   axis([t(1) t(end) t(1) t(end)])
   set(gca,'xdir','reverse','ydir','reverse',...
           'TickDir','out','YMinorTick','on',...
           'XMinorTick','on')
   title(sprintf('RP of undetrended %s',proxy{param}))
   colormap([1 1 1; 0 0 0])

end


