Data and MATLAB Code for Reproducing RPs and RQA of Westerhold et al, Science, 369, 2020
========================================================================================

The data file `CENOGRID_Loess_20.txt` contains the astronomically tuned deep-sea
benthic foraminifer carbon (δ¹³C) and oxygen (δ¹⁸O) isotope reference records uniformly covering the entire Cenozoic. The first column is the tuned age in Ma, the second
column the δ¹³C, and the third column the δ¹⁸O record.

The original calculations were performed using the CRP Toolbox for MATLAB.
In order to avoid installing the toolbox and for better performance, the
functions for calculating RP and RQA were here reimplemented, providing
identical result.

To reproduce the RPs in Fig. 2, use the script `perform_rp.m`, for reproducing
the determinism values and upper confidence bounds, use the script
`perform_rqa.m`.

Requirements
------------

`perform_rqa.m` requires the function `determinism.m`

License
-------

Creative Commons Attribution 4.0 International

Author
------

Norbert Marwan, marwan@pik-potsdam.de
