1. Copy scripts under the "python_scripts" folder to the current directory; download the trajectory file for CXF-D in DMSO
   (deuCXF_in_DMSO.pdb) from  
   https://office365stanford-my.sharepoint.com/:u:/r/personal/ymao90_stanford_edu/Documents/deuCXF_in_DMSO.pdb?csf=1&web=1&e=QxZehw 
2. Get the boxsize for each frame (simulated with NPT) and save that to a .txt file:   
   ```
   python get_pdb_boxsize.py deuCXF_in_DMSO.pdb deuCXF_in_DMSO_boxsize.txt  
   ```
3. Use the solvent processing script to generate truncated solute-solvent configurations. For cutoff radius = 7 Angstrom
   (defined in the SI), stride = 50 (which gives 100 frames), run  
   ```
   python solvent_processing.py --cutoff_values=7 --stride=50 deuCXF_in_DMSO.pdb geoms_CXFD_in_DMSO deuCXF_in_DMSO_boxsize.txt  
   ```
   The truncated solute-solvent clusters generated by this script are stored in "geoms_CXFD_in_DMSO/7A_100".  
   Note: the solvent processing script requires the installation of Python package "mdtraj" (https://www.mdtraj.org/1.9.5/index.html)
4. Shift the coordinates by executing  
   ```
   python eliminate_pbc.py -a geoms_CXFD_in_DMSO --stride=50 deuCXF_in_DMSO_boxsize.txt  
   ```
   to get rid of the periodic boundary condition
5. Generate the Q-Chem inputs: for calculations based on SPADE partition, run  
   ```
   python make_input_solvent_efield.py -m B3LYP -b dp --coarse --efield --solute=22 -a geoms_CXFD_in_DMSO/7A_100 -i input_CXFD_in_DMSO_SPADE  
   ```
   for calculations based on ALMO partitioning, run  
   ```
   python make_input_solvent_efield.py -m B3LYP -b dp --coarse --efield --solute=22 -a geoms_CXFD_in_DMSO/7A_100 -i input_CXFD_in_DMSO_ALMO --almo
   ```
   Run the Q-Chem calculations and copy the output files back to the input directories once finished
6. Calculate the electric field on C=O and C-D:  
   ```
   python calculate_efield_two_bonds.py --cutoff_values=7 --no_subtract --probe_atoms=20,22,21 input_CXFD_in_DMSO_SPADE geoms_CXFD_in_DMSO/7A_100  
   python calculate_efield_two_bonds.py --cutoff_values=7 --no_subtract --probe_atoms=20,22,21 input_CXFD_in_DMSO_ALMO geoms_CXFD_in_DMSO/7A_100  
   ```
   The script will output averaged electric field on C=O and C-D and the standard deviations. The electric field data per frame are written
   to "efield_per_frame_7A.csv" under the input directories.  
   To calculate electric fields from ESP gradient, run:  
   ```
   python calculate_efield_fromESP_two_bonds.py --cutoff_values=7 --probe_atoms=20,22,21 input_CXFD_in_DMSO_SPADE  geoms_CXFD_in_DMSO/7A_100   
   python calculate_efield_fromESP_two_bonds.py --cutoff_values=7 --probe_atoms=20,22,21 input_CXFD_in_DMSO_ALMO geoms_CXFD_in_DMSO/7A_100  
   ```
 
