#!/usr/bin/env bash

## "PPHPC OpenCL-Thesis Datasets" by Nuno Fachada are licensed under the 
## Creative Commons Attribution 4.0 International License. To view a 
## copy of this license, visit http://creativecommons.org/licenses/by/4.0/ 
## or send a letter to Creative Commons, PO Box 1866, Mountain View, 
## CA 94042, USA.

# ########################################################### #
# Script used to create the PPHPC OpenCL-Thesis Datasets      #
# GPU implementation                                          #
# ########################################################### #

# Location of the OpenCL CPU PPHPC implementation
PPCMD="${HOME}/workspace/pphpc/opencl/build/pp/pp_gpu"

# Location of output files
OUTDIR="./GPU"

# Location of simulation configuration files
CFGDIR="${HOME}/workspace/pphpc/configs"

# Create output directory if it doesn't yet exist
mkdir -p ${OUTDIR}/simout
mkdir -p ${OUTDIR}/times

# Start runs
for RUN in {1..10}
do
    # Determine seed for this run
    SEED=`echo ${RUN} | md5sum | cut -f 1 -d ' '`
    SEED=`echo ${SEED} | awk '{print toupper($0)}'`
    SEED=`echo "ibase=16; ${SEED}" | bc`
    let "SEED=SEED%2147483647"

    # Cycle through model sizes
    for SIZE in 100 200 400 800 1600
    do

        # Cycle through parameter sets
        for VERS in 1 2
        do

            # Output files
            OUTFILE="${OUTDIR}/simout/stats${SIZE}v${VERS}r${RUN}.txt"
            TIMEFILE="${OUTDIR}/times/time${SIZE}v${VERS}r${RUN}.txt"

            # Were the runs already performed?
            if [ ! -f ${OUTFILE} ] || [ ! -f ${TIMEFILE} ]; then

                # Print info about current run
                echo "Run: ${RUN}, Param.Set: ${VERS}, Size: ${SIZE}, SEED: ${SEED}"

                # Perform run
                /usr/bin/time -o ${TIMEFILE} ${PPCMD} \
                    -p ${CFGDIR}/config${SIZE}v${VERS}.txt -s ${OUTFILE} \
                    -r ${SEED} --a-rng=mwc64x -a 64 -d 0 \
                    --a-sort=abitonic --a-sort-opts="minps=1,maxps=3,maxsfs=2" \
                    --l-def=256

            fi

        done
    done
done
