/**
 * BioSimulations COMBINE API
 * Endpoints for working with models (e.g., [CellML](https://cellml.org/), [SBML](http://sbml.org/)), simulation experiments (e.g., [Simulation Experiment Description Language (SED-ML)](https://sed-ml.org/)), metadata ([OMEX Metadata](https://sys-bio.github.io/libOmexMeta/)), and simulation projects ([COMBINE/OMEX archives](https://combinearchive.org/)).  Note, this API may change significantly in the future.
 *
 * The version of the OpenAPI document: 0.1
 * Contact: info@biosimulations.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/* tslint:disable:no-unused-variable member-ordering */
import FormData from 'form-data';

import { HttpService, Inject, Injectable, Optional } from '@nestjs/common';
import { AxiosResponse } from 'axios';
import { Observable } from 'rxjs';
import { BioSimulationsCombineArchiveElementMetadata } from '../model/bioSimulationsCombineArchiveElementMetadata';
import { CombineArchive } from '../model/combineArchive';
import { CombineArchiveFileContent } from '../model/combineArchiveFileContent';
import { CombineArchiveManifest } from '../model/combineArchiveManifest';
import { CombineArchiveSedDocSpecs } from '../model/combineArchiveSedDocSpecs';
import { Environment } from '../model/environment';
import { FilenameOrUrl } from '../model/filenameOrUrl';
import { RdfTriple } from '../model/rdfTriple';
import { SimulationRunResults } from '../model/simulationRunResults';
import { ValidationReport } from '../model/validationReport';
import { Configuration } from '../configuration';

@Injectable()
export class SimulationProjectsService {
  protected basePath = 'https://combine.api.biosimulations.dev';
  public defaultHeaders = new Map();
  public configuration = new Configuration();

  constructor(
    protected httpClient: HttpService,
    @Optional() configuration: Configuration,
  ) {
    this.configuration = configuration || this.configuration;
    this.basePath = configuration?.basePath || this.basePath;
  }

  /**
   * @param consumes string[] mime-types
   * @return true: consumes contains 'multipart/form-data', false: otherwise
   */
  private canConsumeForm(consumes: string[]): boolean {
    const form = 'multipart/form-data';
    return consumes.includes(form);
  }

  /**
   * Add content items to a COMBINE/OMEX archive
   * Add content items to a COMBINE/OMEX archive.
   * @param archive
   * @param files Files to add to the COMBINE/OMEX archive and, optionally, the archive.
   * @param newContent
   * @param overwriteLocations Whether to overwrite the location if it already exists, or to add the content at an alternative location (indicated location plus a unique integer).  Default: true
   * @param download Whether to download the modified COMBINE/OMEX archive or return a URL where it can be retrieved.  Default: false
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public srcHandlersCombineAddFileHandler(
    archive: FilenameOrUrl,
    files: Array<Blob>,
    newContent: CombineArchiveFileContent,
    overwriteLocations?: boolean,
    download?: boolean,
  ): Observable<AxiosResponse<Blob>>;
  public srcHandlersCombineAddFileHandler(
    archive: FilenameOrUrl,
    files: Array<Blob>,
    newContent: CombineArchiveFileContent,
    overwriteLocations?: boolean,
    download?: boolean,
  ): Observable<any> {
    if (archive === null || archive === undefined) {
      throw new Error(
        'Required parameter archive was null or undefined when calling srcHandlersCombineAddFileHandler.',
      );
    }

    if (files === null || files === undefined) {
      throw new Error(
        'Required parameter files was null or undefined when calling srcHandlersCombineAddFileHandler.',
      );
    }

    if (newContent === null || newContent === undefined) {
      throw new Error(
        'Required parameter newContent was null or undefined when calling srcHandlersCombineAddFileHandler.',
      );
    }

    let headers: any = this.defaultHeaders;

    // to determine the Accept header
    let httpHeaderAccepts: string[] = ['application/zip', 'application/json'];
    const httpHeaderAcceptSelected: string | undefined =
      this.configuration.selectHeaderAccept(httpHeaderAccepts);
    if (httpHeaderAcceptSelected != undefined) {
      headers['Accept'] = httpHeaderAcceptSelected;
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let formParams: FormData = new FormData();
    let useForm = false;
    let convertFormParamsToString = false;

    // use FormData to transmit files using content-type "multipart/form-data"
    // see https://stackoverflow.com/questions/4007969/application-x-www-form-urlencoded-or-multipart-form-data
    useForm = canConsumeForm;
    if (useForm) {
      formParams = new FormData();
      headers = formParams.getHeaders();
    } else {
      // formParams = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
    }

    if (archive !== undefined) {
      formParams.append('archive', <any>archive);
    }

    if (overwriteLocations !== undefined) {
      formParams.append('overwriteLocations', <any>overwriteLocations);
    }

    if (download !== undefined) {
      formParams.append('download', <any>download);
    }

    if (files !== undefined) {
      formParams.append('files', <any>files);
    }

    if (newContent !== undefined) {
      formParams.append('newContent', <any>newContent);
    }

    return this.httpClient.post(
      `${this.basePath}/combine/file`,
      convertFormParamsToString ? formParams.toString() : formParams,
      {
        responseType: 'blob',
        withCredentials: this.configuration.withCredentials,
        headers: headers,
      },
    );
  }
  /**
   * Create a COMBINE/OMEX archive from files and specifications of SED-ML documents.
   * Create a COMBINE/OMEX archive from files (e.g., BNGL, CellML, SBML) and specifications of SED-ML documents.
   * @param specs
   * @param files File (e.g., model) to place into the COMBINE/OMEX archive.
   * @param download Whether to download the archive or return a URL where the archive can be downloaded.
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public srcHandlersCombineCreateHandler(
    specs: CombineArchive,
    files?: Array<Blob>,
    download?: boolean,
  ): Observable<AxiosResponse<string>>;
  public srcHandlersCombineCreateHandler(
    specs: CombineArchive,
    files?: Array<Blob>,
    download?: boolean,
  ): Observable<any> {
    if (specs === null || specs === undefined) {
      throw new Error(
        'Required parameter specs was null or undefined when calling srcHandlersCombineCreateHandler.',
      );
    }

    let headers: any = this.defaultHeaders;

    // to determine the Accept header
    let httpHeaderAccepts: string[] = ['application/json', 'application/zip'];
    const httpHeaderAcceptSelected: string | undefined =
      this.configuration.selectHeaderAccept(httpHeaderAccepts);
    if (httpHeaderAcceptSelected != undefined) {
      headers['Accept'] = httpHeaderAcceptSelected;
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let formParams: FormData = new FormData();
    let useForm = false;
    let convertFormParamsToString = false;

    // use FormData to transmit files using content-type "multipart/form-data"
    // see https://stackoverflow.com/questions/4007969/application-x-www-form-urlencoded-or-multipart-form-data
    useForm = canConsumeForm;
    if (useForm) {
      formParams = new FormData();
      headers = formParams.getHeaders();
    } else {
      // formParams = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
    }

    if (specs !== undefined) {
      formParams.append('specs', <any>specs);
    }

    if (files !== undefined) {
      formParams.append('files', <any>files);
    }

    if (download !== undefined) {
      formParams.append('download', <any>download);
    }

    return this.httpClient.post<string>(
      `${this.basePath}/combine/create`,
      convertFormParamsToString ? formParams.toString() : formParams,
      {
        withCredentials: this.configuration.withCredentials,
        headers: headers,
      },
    );
  }
  /**
   * Get a file in a COMBINE/OMEX archive
   * Get a file at a location in a COMBINE/OMEX archive.
   * @param url URL for the COMBINE/OMEX archive.
   * @param location Location in the COMBINE/OMEX archive.
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public srcHandlersCombineGetFileHandler(
    url: string,
    location: string,
  ): Observable<AxiosResponse<Blob>>;
  public srcHandlersCombineGetFileHandler(
    url: string,
    location: string,
  ): Observable<any> {
    if (url === null || url === undefined) {
      throw new Error(
        'Required parameter url was null or undefined when calling srcHandlersCombineGetFileHandler.',
      );
    }

    if (location === null || location === undefined) {
      throw new Error(
        'Required parameter location was null or undefined when calling srcHandlersCombineGetFileHandler.',
      );
    }

    let queryParameters: any = {};
    if (url !== undefined && url !== null) {
      queryParameters['url'] = <any>url;
    }
    if (location !== undefined && location !== null) {
      queryParameters['location'] = <any>location;
    }

    let headers: any = this.defaultHeaders;

    // to determine the Accept header
    let httpHeaderAccepts: string[] = [
      'application/octet-stream',
      'application/json',
    ];
    const httpHeaderAcceptSelected: string | undefined =
      this.configuration.selectHeaderAccept(httpHeaderAccepts);
    if (httpHeaderAcceptSelected != undefined) {
      headers['Accept'] = httpHeaderAcceptSelected;
    }

    // to determine the Content-Type header
    const consumes: string[] = [];
    return this.httpClient.get(`${this.basePath}/combine/file`, {
      params: queryParameters,
      responseType: 'blob',
      withCredentials: this.configuration.withCredentials,
      headers: headers,
    });
  }
  /**
   * Get the specifications of the SED-ML files in a COMBINE/OMEX archive
   * Get the specifications of the SED-ML files in a COMBINE/OMEX archive
   * @param file The two files uploaded in creating a combine archive
   * @param url URL
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public srcHandlersCombineGetManifestHandler(
    file?: Blob,
    url?: string,
  ): Observable<AxiosResponse<CombineArchiveManifest>>;
  public srcHandlersCombineGetManifestHandler(
    file?: Blob,
    url?: string,
  ): Observable<any> {
    let headers: any = this.defaultHeaders;

    // to determine the Accept header
    let httpHeaderAccepts: string[] = ['application/json'];
    const httpHeaderAcceptSelected: string | undefined =
      this.configuration.selectHeaderAccept(httpHeaderAccepts);
    if (httpHeaderAcceptSelected != undefined) {
      headers['Accept'] = httpHeaderAcceptSelected;
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let formParams: FormData = new FormData();
    let useForm = false;
    let convertFormParamsToString = false;

    // use FormData to transmit files using content-type "multipart/form-data"
    // see https://stackoverflow.com/questions/4007969/application-x-www-form-urlencoded-or-multipart-form-data
    useForm = canConsumeForm;
    if (useForm) {
      formParams = new FormData();
      headers = formParams.getHeaders();
    } else {
      // formParams = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
    }

    if (file !== undefined) {
      formParams.append('file', <any>file);
    }

    if (url !== undefined) {
      formParams.append('url', <any>url);
    }

    return this.httpClient.post<CombineArchiveManifest>(
      `${this.basePath}/combine/manifest`,
      convertFormParamsToString ? formParams.toString() : formParams,
      {
        withCredentials: this.configuration.withCredentials,
        headers: headers,
      },
    );
  }
  /**
   * Get the metadata about a COMBINE/OMEX archive
   * Get the metadata about a COMBINE/OMEX archive from the OMEX Metadata files in the archive encoded in BioSimulations\&#39; schema.
   * @param omexMetadataFormat OMEX Metadata format  Default: &#x60;rdfxml&#x60;
   * @param file The two files uploaded in creating a combine archive
   * @param url URL
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public srcHandlersCombineGetMetadataForCombineArchiveHandlerBiosimulations(
    omexMetadataFormat: string,
    file?: Blob,
    url?: string,
  ): Observable<
    AxiosResponse<Array<BioSimulationsCombineArchiveElementMetadata>>
  >;
  public srcHandlersCombineGetMetadataForCombineArchiveHandlerBiosimulations(
    omexMetadataFormat: string,
    file?: Blob,
    url?: string,
  ): Observable<any> {
    if (omexMetadataFormat === null || omexMetadataFormat === undefined) {
      throw new Error(
        'Required parameter omexMetadataFormat was null or undefined when calling srcHandlersCombineGetMetadataForCombineArchiveHandlerBiosimulations.',
      );
    }

    let headers: any = this.defaultHeaders;

    // to determine the Accept header
    let httpHeaderAccepts: string[] = ['application/json'];
    const httpHeaderAcceptSelected: string | undefined =
      this.configuration.selectHeaderAccept(httpHeaderAccepts);
    if (httpHeaderAcceptSelected != undefined) {
      headers['Accept'] = httpHeaderAcceptSelected;
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let formParams: FormData = new FormData();
    let useForm = false;
    let convertFormParamsToString = false;

    // use FormData to transmit files using content-type "multipart/form-data"
    // see https://stackoverflow.com/questions/4007969/application-x-www-form-urlencoded-or-multipart-form-data
    useForm = canConsumeForm;
    if (useForm) {
      formParams = new FormData();
      headers = formParams.getHeaders();
    } else {
      // formParams = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
    }

    if (file !== undefined) {
      formParams.append('file', <any>file);
    }

    if (url !== undefined) {
      formParams.append('url', <any>url);
    }

    if (omexMetadataFormat !== undefined) {
      formParams.append('omexMetadataFormat', <any>omexMetadataFormat);
    }

    return this.httpClient.post<
      Array<BioSimulationsCombineArchiveElementMetadata>
    >(
      `${this.basePath}/combine/metadata/biosimulations`,
      convertFormParamsToString ? formParams.toString() : formParams,
      {
        withCredentials: this.configuration.withCredentials,
        headers: headers,
      },
    );
  }
  /**
   * Get the metadata about a COMBINE/OMEX archive
   * Get the metadata about a COMBINE/OMEX archive from the OMEX Metadata files as a list of RDF triples.
   * @param omexMetadataFormat OMEX Metadata format  Default: &#x60;rdfxml&#x60;
   * @param file The two files uploaded in creating a combine archive
   * @param url URL
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public srcHandlersCombineGetMetadataForCombineArchiveHandlerRdfTriples(
    omexMetadataFormat: string,
    file?: Blob,
    url?: string,
  ): Observable<AxiosResponse<Array<RdfTriple>>>;
  public srcHandlersCombineGetMetadataForCombineArchiveHandlerRdfTriples(
    omexMetadataFormat: string,
    file?: Blob,
    url?: string,
  ): Observable<any> {
    if (omexMetadataFormat === null || omexMetadataFormat === undefined) {
      throw new Error(
        'Required parameter omexMetadataFormat was null or undefined when calling srcHandlersCombineGetMetadataForCombineArchiveHandlerRdfTriples.',
      );
    }

    let headers: any = this.defaultHeaders;

    // to determine the Accept header
    let httpHeaderAccepts: string[] = ['application/json'];
    const httpHeaderAcceptSelected: string | undefined =
      this.configuration.selectHeaderAccept(httpHeaderAccepts);
    if (httpHeaderAcceptSelected != undefined) {
      headers['Accept'] = httpHeaderAcceptSelected;
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let formParams: FormData = new FormData();
    let useForm = false;
    let convertFormParamsToString = false;

    // use FormData to transmit files using content-type "multipart/form-data"
    // see https://stackoverflow.com/questions/4007969/application-x-www-form-urlencoded-or-multipart-form-data
    useForm = canConsumeForm;
    if (useForm) {
      formParams = new FormData();
      headers = formParams.getHeaders();
    } else {
      // formParams = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
    }

    if (file !== undefined) {
      formParams.append('file', <any>file);
    }

    if (url !== undefined) {
      formParams.append('url', <any>url);
    }

    if (omexMetadataFormat !== undefined) {
      formParams.append('omexMetadataFormat', <any>omexMetadataFormat);
    }

    return this.httpClient.post<Array<RdfTriple>>(
      `${this.basePath}/combine/metadata/rdf`,
      convertFormParamsToString ? formParams.toString() : formParams,
      {
        withCredentials: this.configuration.withCredentials,
        headers: headers,
      },
    );
  }
  /**
   * Get the specifications of the SED-ML files in a COMBINE/OMEX archive
   * Get the specifications of the SED-ML files in a COMBINE/OMEX archive
   * @param file The two files uploaded in creating a combine archive
   * @param url URL
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public srcHandlersCombineGetSedmlSpecsForCombineArchiveHandler(
    file?: Blob,
    url?: string,
  ): Observable<AxiosResponse<CombineArchiveSedDocSpecs>>;
  public srcHandlersCombineGetSedmlSpecsForCombineArchiveHandler(
    file?: Blob,
    url?: string,
  ): Observable<any> {
    let headers: any = this.defaultHeaders;

    // to determine the Accept header
    let httpHeaderAccepts: string[] = ['application/json'];
    const httpHeaderAcceptSelected: string | undefined =
      this.configuration.selectHeaderAccept(httpHeaderAccepts);
    if (httpHeaderAcceptSelected != undefined) {
      headers['Accept'] = httpHeaderAcceptSelected;
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let formParams: FormData = new FormData();
    let useForm = false;
    let convertFormParamsToString = false;

    // use FormData to transmit files using content-type "multipart/form-data"
    // see https://stackoverflow.com/questions/4007969/application-x-www-form-urlencoded-or-multipart-form-data
    useForm = canConsumeForm;
    if (useForm) {
      formParams = new FormData();
      headers = formParams.getHeaders();
    } else {
      // formParams = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
    }

    if (file !== undefined) {
      formParams.append('file', <any>file);
    }

    if (url !== undefined) {
      formParams.append('url', <any>url);
    }

    return this.httpClient.post<CombineArchiveSedDocSpecs>(
      `${this.basePath}/combine/sedml-specs`,
      convertFormParamsToString ? formParams.toString() : formParams,
      {
        withCredentials: this.configuration.withCredentials,
        headers: headers,
      },
    );
  }
  /**
   * Modify the files and/or SED-ML documents in a COMBINE/OMEX archive
   * Modify the files or SED-ML documents in a COMBINE/OMEX archive.
   * @param specs
   * @param archive
   * @param files File (e.g., model) to place into the COMBINE/OMEX archive.
   * @param download Whether to download the modified archive or return a URL where the modified archive can be downloaded.
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public srcHandlersCombineModifyHandler(
    specs: CombineArchive,
    archive: FilenameOrUrl,
    files?: Array<Blob>,
    download?: boolean,
  ): Observable<AxiosResponse<string>>;
  public srcHandlersCombineModifyHandler(
    specs: CombineArchive,
    archive: FilenameOrUrl,
    files?: Array<Blob>,
    download?: boolean,
  ): Observable<any> {
    if (specs === null || specs === undefined) {
      throw new Error(
        'Required parameter specs was null or undefined when calling srcHandlersCombineModifyHandler.',
      );
    }

    if (archive === null || archive === undefined) {
      throw new Error(
        'Required parameter archive was null or undefined when calling srcHandlersCombineModifyHandler.',
      );
    }

    let headers: any = this.defaultHeaders;

    // to determine the Accept header
    let httpHeaderAccepts: string[] = ['application/json', 'application/zip'];
    const httpHeaderAcceptSelected: string | undefined =
      this.configuration.selectHeaderAccept(httpHeaderAccepts);
    if (httpHeaderAcceptSelected != undefined) {
      headers['Accept'] = httpHeaderAcceptSelected;
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let formParams: FormData = new FormData();
    let useForm = false;
    let convertFormParamsToString = false;

    // use FormData to transmit files using content-type "multipart/form-data"
    // see https://stackoverflow.com/questions/4007969/application-x-www-form-urlencoded-or-multipart-form-data
    useForm = canConsumeForm;
    if (useForm) {
      formParams = new FormData();
      headers = formParams.getHeaders();
    } else {
      // formParams = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
    }

    if (specs !== undefined) {
      formParams.append('specs', <any>specs);
    }

    if (files !== undefined) {
      formParams.append('files', <any>files);
    }

    if (download !== undefined) {
      formParams.append('download', <any>download);
    }

    if (archive !== undefined) {
      formParams.append('archive', <any>archive);
    }

    return this.httpClient.post<string>(
      `${this.basePath}/combine/modify`,
      convertFormParamsToString ? formParams.toString() : formParams,
      {
        withCredentials: this.configuration.withCredentials,
        headers: headers,
      },
    );
  }
  /**
   * Validate a COMBINE/OMEX archive and the simulation experiments and models inside it.
   * Validate a COMBINE/OMEX archive and the simulation experiments (SED-ML files) and models (e.g., SBML files) inside it.  Notes: * An OMEX Manifest file is required to validate OMEX Metadata files. As a result, the &#x60;validateOmexManifest&#x3D;false&#x60; option should often also be used with the &#x60;validateOmexMetadata&#x3D;false&#x60; option. * Currently, submission to BioSimulations requires metadata to be in RDF-XML format. * COMBINE/OMEX archives must pass all validation checks for publication to BioSimulations.
   * @param omexMetadataFormat OMEX Metadata format
   * @param omexMetadataSchema OMEX Metadata schema
   * @param file The two files uploaded in creating a combine archive
   * @param url URL
   * @param validateOmexManifest Whether to validate the manifest of the archive.  Default: &#x60;true&#x60;.
   * @param validateSedml Whether to validate the SED-ML files in the archive.  Default: &#x60;true&#x60;.
   * @param validateSedmlModels Whether to validate the source (e.g., CellML, SBML file) of each model of each SED-ML file in the archive.  Default: &#x60;true&#x60;.
   * @param validateOmexMetadata Whether to validate the OMEX Metadata files in the archive according to [BioSimulators\\\&#39; conventions](https://docs.biosimulations.org/concepts/conventions/simulation-project-metadata/).  Default: &#x60;true&#x60;.
   * @param validateImages Whether to validate the image (BMP, GIF, PNG, JPEG, TIFF, WEBP) files in the archive.  Default: &#x60;true&#x60;.
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public srcHandlersCombineValidateHandler(
    omexMetadataFormat: string,
    omexMetadataSchema: string,
    file?: Blob,
    url?: string,
    validateOmexManifest?: boolean,
    validateSedml?: boolean,
    validateSedmlModels?: boolean,
    validateOmexMetadata?: boolean,
    validateImages?: boolean,
  ): Observable<AxiosResponse<ValidationReport>>;
  public srcHandlersCombineValidateHandler(
    omexMetadataFormat: string,
    omexMetadataSchema: string,
    file?: Blob,
    url?: string,
    validateOmexManifest?: boolean,
    validateSedml?: boolean,
    validateSedmlModels?: boolean,
    validateOmexMetadata?: boolean,
    validateImages?: boolean,
  ): Observable<any> {
    if (omexMetadataFormat === null || omexMetadataFormat === undefined) {
      throw new Error(
        'Required parameter omexMetadataFormat was null or undefined when calling srcHandlersCombineValidateHandler.',
      );
    }

    if (omexMetadataSchema === null || omexMetadataSchema === undefined) {
      throw new Error(
        'Required parameter omexMetadataSchema was null or undefined when calling srcHandlersCombineValidateHandler.',
      );
    }

    let headers: any = this.defaultHeaders;

    // to determine the Accept header
    let httpHeaderAccepts: string[] = ['application/json'];
    const httpHeaderAcceptSelected: string | undefined =
      this.configuration.selectHeaderAccept(httpHeaderAccepts);
    if (httpHeaderAcceptSelected != undefined) {
      headers['Accept'] = httpHeaderAcceptSelected;
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let formParams: FormData = new FormData();
    let useForm = false;
    let convertFormParamsToString = false;

    // use FormData to transmit files using content-type "multipart/form-data"
    // see https://stackoverflow.com/questions/4007969/application-x-www-form-urlencoded-or-multipart-form-data
    useForm = canConsumeForm;
    if (useForm) {
      formParams = new FormData();
      headers = formParams.getHeaders();
    } else {
      // formParams = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
    }

    if (file !== undefined) {
      formParams.append('file', <any>file);
    }

    if (url !== undefined) {
      formParams.append('url', <any>url);
    }

    if (omexMetadataFormat !== undefined) {
      formParams.append('omexMetadataFormat', <any>omexMetadataFormat);
    }

    if (validateOmexManifest !== undefined) {
      formParams.append('validateOmexManifest', <any>validateOmexManifest);
    }

    if (omexMetadataSchema !== undefined) {
      formParams.append('omexMetadataSchema', <any>omexMetadataSchema);
    }

    if (validateSedml !== undefined) {
      formParams.append('validateSedml', <any>validateSedml);
    }

    if (validateSedmlModels !== undefined) {
      formParams.append('validateSedmlModels', <any>validateSedmlModels);
    }

    if (validateOmexMetadata !== undefined) {
      formParams.append('validateOmexMetadata', <any>validateOmexMetadata);
    }

    if (validateImages !== undefined) {
      formParams.append('validateImages', <any>validateImages);
    }

    return this.httpClient.post<ValidationReport>(
      `${this.basePath}/combine/validate`,
      convertFormParamsToString ? formParams.toString() : formParams,
      {
        withCredentials: this.configuration.withCredentials,
        headers: headers,
      },
    );
  }
  /**
   * Execute a COMBINE/OMEX archive
   * Execute the simulations defined in SED-ML format in a COMBINE/OMEX archive and return the result of each report and plot.
   * @param simulator Id of a simulation tool registered with BioSimulators.
   * @param type Type
   * @param archiveUrl URL
   * @param archiveFile The two files uploaded in creating a combine archive
   * @param environment
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public srcHandlersRunRunHandler(
    simulator: string,
    type: string,
    archiveUrl?: string,
    archiveFile?: Blob,
    environment?: Environment,
  ): Observable<AxiosResponse<SimulationRunResults>>;
  public srcHandlersRunRunHandler(
    simulator: string,
    type: string,
    archiveUrl?: string,
    archiveFile?: Blob,
    environment?: Environment,
  ): Observable<any> {
    if (simulator === null || simulator === undefined) {
      throw new Error(
        'Required parameter simulator was null or undefined when calling srcHandlersRunRunHandler.',
      );
    }

    if (type === null || type === undefined) {
      throw new Error(
        'Required parameter type was null or undefined when calling srcHandlersRunRunHandler.',
      );
    }

    let headers: any = this.defaultHeaders;

    // to determine the Accept header
    let httpHeaderAccepts: string[] = [
      'application/json',
      'application/x-hdf',
      'application/zip',
    ];
    const httpHeaderAcceptSelected: string | undefined =
      this.configuration.selectHeaderAccept(httpHeaderAccepts);
    if (httpHeaderAcceptSelected != undefined) {
      headers['Accept'] = httpHeaderAcceptSelected;
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let formParams: FormData = new FormData();
    let useForm = false;
    let convertFormParamsToString = false;

    // use FormData to transmit files using content-type "multipart/form-data"
    // see https://stackoverflow.com/questions/4007969/application-x-www-form-urlencoded-or-multipart-form-data
    useForm = canConsumeForm;
    if (useForm) {
      formParams = new FormData();
      headers = formParams.getHeaders();
    } else {
      // formParams = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
    }

    if (simulator !== undefined) {
      formParams.append('simulator', <any>simulator);
    }

    if (archiveUrl !== undefined) {
      formParams.append('archiveUrl', <any>archiveUrl);
    }

    if (archiveFile !== undefined) {
      formParams.append('archiveFile', <any>archiveFile);
    }

    if (type !== undefined) {
      formParams.append('_type', <any>type);
    }

    if (environment !== undefined) {
      formParams.append('environment', <any>environment);
    }

    return this.httpClient.post<SimulationRunResults>(
      `${this.basePath}/run/run`,
      convertFormParamsToString ? formParams.toString() : formParams,
      {
        withCredentials: this.configuration.withCredentials,
        headers: headers,
      },
    );
  }
}
