/**
 * BioSimulations COMBINE API
 * Endpoints for working with models (e.g., [CellML](https://cellml.org/), [SBML](http://sbml.org/)), simulation experiments (e.g., [Simulation Experiment Description Language (SED-ML)](https://sed-ml.org/)), metadata ([OMEX Metadata](https://sys-bio.github.io/libOmexMeta/)), and simulation projects ([COMBINE/OMEX archives](https://combinearchive.org/)).  Note, this API may change significantly in the future.
 *
 * The version of the OpenAPI document: 0.1
 * Contact: info@biosimulations.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/* tslint:disable:no-unused-variable member-ordering */
import FormData from 'form-data';

import { HttpService, Inject, Injectable, Optional } from '@nestjs/common';
import { AxiosResponse } from 'axios';
import { Observable } from 'rxjs';
import { CombineArchiveSedDocSpecs } from '../model/combineArchiveSedDocSpecs';
import { SedDocument } from '../model/sedDocument';
import { ValidationReport } from '../model/validationReport';
import { Configuration } from '../configuration';

@Injectable()
export class SimulationExperimentsService {
  protected basePath = 'https://combine.api.biosimulations.dev';
  public defaultHeaders = new Map();
  public configuration = new Configuration();

  constructor(
    protected httpClient: HttpService,
    @Optional() configuration: Configuration,
  ) {
    this.configuration = configuration || this.configuration;
    this.basePath = configuration?.basePath || this.basePath;
  }

  /**
   * @param consumes string[] mime-types
   * @return true: consumes contains 'multipart/form-data', false: otherwise
   */
  private canConsumeForm(consumes: string[]): boolean {
    const form = 'multipart/form-data';
    return consumes.includes(form);
  }

  /**
   * Get the specifications of the SED-ML files in a COMBINE/OMEX archive
   * Get the specifications of the SED-ML files in a COMBINE/OMEX archive
   * @param file The two files uploaded in creating a combine archive
   * @param url URL
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public srcHandlersCombineGetSedmlSpecsForCombineArchiveHandler(
    file?: Blob,
    url?: string,
  ): Observable<AxiosResponse<CombineArchiveSedDocSpecs>>;
  public srcHandlersCombineGetSedmlSpecsForCombineArchiveHandler(
    file?: Blob,
    url?: string,
  ): Observable<any> {
    let headers: any = this.defaultHeaders;

    // to determine the Accept header
    let httpHeaderAccepts: string[] = ['application/json'];
    const httpHeaderAcceptSelected: string | undefined =
      this.configuration.selectHeaderAccept(httpHeaderAccepts);
    if (httpHeaderAcceptSelected != undefined) {
      headers['Accept'] = httpHeaderAcceptSelected;
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let formParams: FormData = new FormData();
    let useForm = false;
    let convertFormParamsToString = false;

    // use FormData to transmit files using content-type "multipart/form-data"
    // see https://stackoverflow.com/questions/4007969/application-x-www-form-urlencoded-or-multipart-form-data
    useForm = canConsumeForm;
    if (useForm) {
      formParams = new FormData();
      headers = formParams.getHeaders();
    } else {
      // formParams = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
    }

    if (file !== undefined) {
      formParams.append('file', <any>file);
    }

    if (url !== undefined) {
      formParams.append('url', <any>url);
    }

    return this.httpClient.post<CombineArchiveSedDocSpecs>(
      `${this.basePath}/combine/sedml-specs`,
      convertFormParamsToString ? formParams.toString() : formParams,
      {
        withCredentials: this.configuration.withCredentials,
        headers: headers,
      },
    );
  }
  /**
   * Get the possible observables of a simulation as a list of SED-ML variables.
   *
   * @param modelLanguage A SED-ML URN for a model language.  The full list of recognized values is available at https://sed-ml.org/urns.html.
   * @param simulationType Type of simulation.
   * @param modelingFramework Identifier for an SBO term
   * @param simulationAlgorithm KiSAO id
   * @param modelFile The two files uploaded in creating a combine archive
   * @param modelUrl URL
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public srcHandlersSedMlGetParametersVariablesForSimulationHandler(
    modelLanguage: string,
    simulationType: string,
    modelingFramework: string,
    simulationAlgorithm: string,
    modelFile?: Blob,
    modelUrl?: string,
  ): Observable<AxiosResponse<SedDocument>>;
  public srcHandlersSedMlGetParametersVariablesForSimulationHandler(
    modelLanguage: string,
    simulationType: string,
    modelingFramework: string,
    simulationAlgorithm: string,
    modelFile?: Blob,
    modelUrl?: string,
  ): Observable<any> {
    if (modelLanguage === null || modelLanguage === undefined) {
      throw new Error(
        'Required parameter modelLanguage was null or undefined when calling srcHandlersSedMlGetParametersVariablesForSimulationHandler.',
      );
    }

    if (simulationType === null || simulationType === undefined) {
      throw new Error(
        'Required parameter simulationType was null or undefined when calling srcHandlersSedMlGetParametersVariablesForSimulationHandler.',
      );
    }

    if (modelingFramework === null || modelingFramework === undefined) {
      throw new Error(
        'Required parameter modelingFramework was null or undefined when calling srcHandlersSedMlGetParametersVariablesForSimulationHandler.',
      );
    }

    if (simulationAlgorithm === null || simulationAlgorithm === undefined) {
      throw new Error(
        'Required parameter simulationAlgorithm was null or undefined when calling srcHandlersSedMlGetParametersVariablesForSimulationHandler.',
      );
    }

    let headers: any = this.defaultHeaders;

    // to determine the Accept header
    let httpHeaderAccepts: string[] = ['application/json'];
    const httpHeaderAcceptSelected: string | undefined =
      this.configuration.selectHeaderAccept(httpHeaderAccepts);
    if (httpHeaderAcceptSelected != undefined) {
      headers['Accept'] = httpHeaderAcceptSelected;
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let formParams: FormData = new FormData();
    let useForm = false;
    let convertFormParamsToString = false;

    // use FormData to transmit files using content-type "multipart/form-data"
    // see https://stackoverflow.com/questions/4007969/application-x-www-form-urlencoded-or-multipart-form-data
    useForm = canConsumeForm;
    if (useForm) {
      formParams = new FormData();
      headers = formParams.getHeaders();
    } else {
      // formParams = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
    }

    if (modelFile !== undefined) {
      formParams.append('modelFile', <any>modelFile);
    }

    if (modelLanguage !== undefined) {
      formParams.append('modelLanguage', <any>modelLanguage);
    }

    if (simulationType !== undefined) {
      formParams.append('simulationType', <any>simulationType);
    }

    if (modelingFramework !== undefined) {
      formParams.append('modelingFramework', <any>modelingFramework);
    }

    if (simulationAlgorithm !== undefined) {
      formParams.append('simulationAlgorithm', <any>simulationAlgorithm);
    }

    if (modelUrl !== undefined) {
      formParams.append('modelUrl', <any>modelUrl);
    }

    return this.httpClient.post<SedDocument>(
      `${this.basePath}/sed-ml/get-parameters-variables-for-simulation`,
      convertFormParamsToString ? formParams.toString() : formParams,
      {
        withCredentials: this.configuration.withCredentials,
        headers: headers,
      },
    );
  }
  /**
   * Validate a SED-ML file
   * Validate a [Simulation Experiment Description Markup Language (SED-ML)](https://sed-ml.org/) file. Note, this method does not validate the sources of the models of SED-ML files or targets to models. Models files are required for more comprehensive validation. The &#x60;/combine/validate&#x60; endpoint provides more comprehensive validation that encompasses validation of model sources and targets to models.
   * @param file The two files uploaded in creating a combine archive
   * @param url URL
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public srcHandlersSedMlValidateHandler(
    file?: Blob,
    url?: string,
  ): Observable<AxiosResponse<ValidationReport>>;
  public srcHandlersSedMlValidateHandler(
    file?: Blob,
    url?: string,
  ): Observable<any> {
    let headers: any = this.defaultHeaders;

    // to determine the Accept header
    let httpHeaderAccepts: string[] = ['application/json'];
    const httpHeaderAcceptSelected: string | undefined =
      this.configuration.selectHeaderAccept(httpHeaderAccepts);
    if (httpHeaderAcceptSelected != undefined) {
      headers['Accept'] = httpHeaderAcceptSelected;
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let formParams: FormData = new FormData();
    let useForm = false;
    let convertFormParamsToString = false;

    // use FormData to transmit files using content-type "multipart/form-data"
    // see https://stackoverflow.com/questions/4007969/application-x-www-form-urlencoded-or-multipart-form-data
    useForm = canConsumeForm;
    if (useForm) {
      formParams = new FormData();
      headers = formParams.getHeaders();
    } else {
      // formParams = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
    }

    if (file !== undefined) {
      formParams.append('file', <any>file);
    }

    if (url !== undefined) {
      formParams.append('url', <any>url);
    }

    return this.httpClient.post<ValidationReport>(
      `${this.basePath}/sed-ml/validate`,
      convertFormParamsToString ? formParams.toString() : formParams,
      {
        withCredentials: this.configuration.withCredentials,
        headers: headers,
      },
    );
  }
}
