/**
 * BioSimulations COMBINE API
 * Endpoints for working with models (e.g., [CellML](https://cellml.org/), [SBML](http://sbml.org/)), simulation experiments (e.g., [Simulation Experiment Description Language (SED-ML)](https://sed-ml.org/)), metadata ([OMEX Metadata](https://sys-bio.github.io/libOmexMeta/)), and simulation projects ([COMBINE/OMEX archives](https://combinearchive.org/)).  Note, this API may change significantly in the future.
 *
 * The version of the OpenAPI document: 0.1
 * Contact: info@biosimulations.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/* tslint:disable:no-unused-variable member-ordering */

import { Inject, Injectable, Optional } from '@angular/core';
import {
  HttpClient,
  HttpHeaders,
  HttpParams,
  HttpResponse,
  HttpEvent,
  HttpParameterCodec,
} from '@angular/common/http';
import { CustomHttpParameterCodec } from '../encoder';
import { Observable } from 'rxjs';

import { BioSimulationsCombineArchiveElementMetadata } from '../model/models';
import { CombineArchive } from '../model/models';
import { CombineArchiveFileContent } from '../model/models';
import { CombineArchiveManifest } from '../model/models';
import { CombineArchiveSedDocSpecs } from '../model/models';
import { Environment } from '../model/models';
import { FilenameOrUrl } from '../model/models';
import { RdfTriple } from '../model/models';
import { SimulationRunResults } from '../model/models';
import { ValidationReport } from '../model/models';

import { BASE_PATH } from '../variables';
import { Configuration } from '../configuration';

@Injectable({
  providedIn: 'root',
})
export class SimulationProjectsService {
  protected basePath = 'https://combine.api.biosimulations.dev';
  public defaultHeaders = new HttpHeaders();
  public configuration = new Configuration();
  public encoder: HttpParameterCodec;

  constructor(
    protected httpClient: HttpClient,
    @Optional() @Inject(BASE_PATH) basePath: string,
    @Optional() configuration: Configuration,
  ) {
    if (configuration) {
      this.configuration = configuration;
    }
    if (typeof this.configuration.basePath !== 'string') {
      if (typeof basePath !== 'string') {
        basePath = this.basePath;
      }
      this.configuration.basePath = basePath;
    }
    this.encoder = this.configuration.encoder || new CustomHttpParameterCodec();
  }

  /**
   * @param consumes string[] mime-types
   * @return true: consumes contains 'multipart/form-data', false: otherwise
   */
  private canConsumeForm(consumes: string[]): boolean {
    const form = 'multipart/form-data';
    for (const consume of consumes) {
      if (form === consume) {
        return true;
      }
    }
    return false;
  }

  private addToHttpParams(
    httpParams: HttpParams,
    value: any,
    key?: string,
  ): HttpParams {
    if (typeof value === 'object' && value instanceof Date === false) {
      httpParams = this.addToHttpParamsRecursive(httpParams, value);
    } else {
      httpParams = this.addToHttpParamsRecursive(httpParams, value, key);
    }
    return httpParams;
  }

  private addToHttpParamsRecursive(
    httpParams: HttpParams,
    value?: any,
    key?: string,
  ): HttpParams {
    if (value == null) {
      return httpParams;
    }

    if (typeof value === 'object') {
      if (Array.isArray(value)) {
        (value as any[]).forEach(
          (elem) =>
            (httpParams = this.addToHttpParamsRecursive(httpParams, elem, key)),
        );
      } else if (value instanceof Date) {
        if (key != null) {
          httpParams = httpParams.append(
            key,
            (value as Date).toISOString().substr(0, 10),
          );
        } else {
          throw Error('key may not be null if value is Date');
        }
      } else {
        Object.keys(value).forEach(
          (k) =>
            (httpParams = this.addToHttpParamsRecursive(
              httpParams,
              value[k],
              key != null ? `${key}.${k}` : k,
            )),
        );
      }
    } else if (key != null) {
      httpParams = httpParams.append(key, value);
    } else {
      throw Error('key may not be null if value is not object or array');
    }
    return httpParams;
  }

  /**
   * Add content items to a COMBINE/OMEX archive
   * Add content items to a COMBINE/OMEX archive.
   * @param archive
   * @param files Files to add to the COMBINE/OMEX archive and, optionally, the archive.
   * @param newContent
   * @param overwriteLocations Whether to overwrite the location if it already exists, or to add the content at an alternative location (indicated location plus a unique integer).  Default: true
   * @param download Whether to download the modified COMBINE/OMEX archive or return a URL where it can be retrieved.  Default: false
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public srcHandlersCombineAddFileHandler(
    archive: FilenameOrUrl,
    files: Array<Blob>,
    newContent: CombineArchiveFileContent,
    overwriteLocations?: boolean,
    download?: boolean,
    observe?: 'body',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/zip' | 'application/json' },
  ): Observable<Blob>;
  public srcHandlersCombineAddFileHandler(
    archive: FilenameOrUrl,
    files: Array<Blob>,
    newContent: CombineArchiveFileContent,
    overwriteLocations?: boolean,
    download?: boolean,
    observe?: 'response',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/zip' | 'application/json' },
  ): Observable<HttpResponse<Blob>>;
  public srcHandlersCombineAddFileHandler(
    archive: FilenameOrUrl,
    files: Array<Blob>,
    newContent: CombineArchiveFileContent,
    overwriteLocations?: boolean,
    download?: boolean,
    observe?: 'events',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/zip' | 'application/json' },
  ): Observable<HttpEvent<Blob>>;
  public srcHandlersCombineAddFileHandler(
    archive: FilenameOrUrl,
    files: Array<Blob>,
    newContent: CombineArchiveFileContent,
    overwriteLocations?: boolean,
    download?: boolean,
    observe: any = 'body',
    reportProgress: boolean = false,
    options?: { httpHeaderAccept?: 'application/zip' | 'application/json' },
  ): Observable<any> {
    if (archive === null || archive === undefined) {
      throw new Error(
        'Required parameter archive was null or undefined when calling srcHandlersCombineAddFileHandler.',
      );
    }
    if (files === null || files === undefined) {
      throw new Error(
        'Required parameter files was null or undefined when calling srcHandlersCombineAddFileHandler.',
      );
    }
    if (newContent === null || newContent === undefined) {
      throw new Error(
        'Required parameter newContent was null or undefined when calling srcHandlersCombineAddFileHandler.',
      );
    }

    let localVarHeaders = this.defaultHeaders;

    let localVarHttpHeaderAcceptSelected: string | undefined =
      options && options.httpHeaderAccept;
    if (localVarHttpHeaderAcceptSelected === undefined) {
      // to determine the Accept header
      const httpHeaderAccepts: string[] = [
        'application/zip',
        'application/json',
      ];
      localVarHttpHeaderAcceptSelected =
        this.configuration.selectHeaderAccept(httpHeaderAccepts);
    }
    if (localVarHttpHeaderAcceptSelected !== undefined) {
      localVarHeaders = localVarHeaders.set(
        'Accept',
        localVarHttpHeaderAcceptSelected,
      );
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let localVarFormParams: { append(param: string, value: any): any };
    const localVarUseForm = false;
    const localVarConvertFormParamsToString = false;
    if (localVarUseForm) {
      localVarFormParams = new FormData();
    } else {
      localVarFormParams = new HttpParams({ encoder: this.encoder });
    }

    return this.httpClient.post(
      `${this.configuration.basePath}/combine/file`,
      localVarConvertFormParamsToString
        ? localVarFormParams.toString()
        : localVarFormParams,
      {
        responseType: 'blob',
        withCredentials: this.configuration.withCredentials,
        headers: localVarHeaders,
        observe: observe,
        reportProgress: reportProgress,
      },
    );
  }

  /**
   * Create a COMBINE/OMEX archive from files and specifications of SED-ML documents.
   * Create a COMBINE/OMEX archive from files (e.g., BNGL, CellML, SBML) and specifications of SED-ML documents.
   * @param specs
   * @param files File (e.g., model) to place into the COMBINE/OMEX archive.
   * @param download Whether to download the archive or return a URL where the archive can be downloaded.
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public srcHandlersCombineCreateHandler(
    specs: CombineArchive,
    files?: Array<Blob>,
    download?: boolean,
    observe?: 'body',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' | 'application/zip' },
  ): Observable<string>;
  public srcHandlersCombineCreateHandler(
    specs: CombineArchive,
    files?: Array<Blob>,
    download?: boolean,
    observe?: 'response',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' | 'application/zip' },
  ): Observable<HttpResponse<string>>;
  public srcHandlersCombineCreateHandler(
    specs: CombineArchive,
    files?: Array<Blob>,
    download?: boolean,
    observe?: 'events',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' | 'application/zip' },
  ): Observable<HttpEvent<string>>;
  public srcHandlersCombineCreateHandler(
    specs: CombineArchive,
    files?: Array<Blob>,
    download?: boolean,
    observe: any = 'body',
    reportProgress: boolean = false,
    options?: { httpHeaderAccept?: 'application/json' | 'application/zip' },
  ): Observable<any> {
    if (specs === null || specs === undefined) {
      throw new Error(
        'Required parameter specs was null or undefined when calling srcHandlersCombineCreateHandler.',
      );
    }

    let localVarHeaders = this.defaultHeaders;

    let localVarHttpHeaderAcceptSelected: string | undefined =
      options && options.httpHeaderAccept;
    if (localVarHttpHeaderAcceptSelected === undefined) {
      // to determine the Accept header
      const httpHeaderAccepts: string[] = [
        'application/json',
        'application/zip',
      ];
      localVarHttpHeaderAcceptSelected =
        this.configuration.selectHeaderAccept(httpHeaderAccepts);
    }
    if (localVarHttpHeaderAcceptSelected !== undefined) {
      localVarHeaders = localVarHeaders.set(
        'Accept',
        localVarHttpHeaderAcceptSelected,
      );
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let localVarFormParams: { append(param: string, value: any): any };
    const localVarUseForm = false;
    const localVarConvertFormParamsToString = false;
    if (localVarUseForm) {
      localVarFormParams = new FormData();
    } else {
      localVarFormParams = new HttpParams({ encoder: this.encoder });
    }

    let responseType_: 'text' | 'json' = 'json';
    if (
      localVarHttpHeaderAcceptSelected &&
      localVarHttpHeaderAcceptSelected.startsWith('text')
    ) {
      responseType_ = 'text';
    }

    return this.httpClient.post<string>(
      `${this.configuration.basePath}/combine/create`,
      localVarConvertFormParamsToString
        ? localVarFormParams.toString()
        : localVarFormParams,
      {
        responseType: <any>responseType_,
        withCredentials: this.configuration.withCredentials,
        headers: localVarHeaders,
        observe: observe,
        reportProgress: reportProgress,
      },
    );
  }

  /**
   * Get a file in a COMBINE/OMEX archive
   * Get a file at a location in a COMBINE/OMEX archive.
   * @param url URL for the COMBINE/OMEX archive.
   * @param location Location in the COMBINE/OMEX archive.
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public srcHandlersCombineGetFileHandler(
    url: string,
    location: string,
    observe?: 'body',
    reportProgress?: boolean,
    options?: {
      httpHeaderAccept?: 'application/octet-stream' | 'application/json';
    },
  ): Observable<Blob>;
  public srcHandlersCombineGetFileHandler(
    url: string,
    location: string,
    observe?: 'response',
    reportProgress?: boolean,
    options?: {
      httpHeaderAccept?: 'application/octet-stream' | 'application/json';
    },
  ): Observable<HttpResponse<Blob>>;
  public srcHandlersCombineGetFileHandler(
    url: string,
    location: string,
    observe?: 'events',
    reportProgress?: boolean,
    options?: {
      httpHeaderAccept?: 'application/octet-stream' | 'application/json';
    },
  ): Observable<HttpEvent<Blob>>;
  public srcHandlersCombineGetFileHandler(
    url: string,
    location: string,
    observe: any = 'body',
    reportProgress: boolean = false,
    options?: {
      httpHeaderAccept?: 'application/octet-stream' | 'application/json';
    },
  ): Observable<any> {
    if (url === null || url === undefined) {
      throw new Error(
        'Required parameter url was null or undefined when calling srcHandlersCombineGetFileHandler.',
      );
    }
    if (location === null || location === undefined) {
      throw new Error(
        'Required parameter location was null or undefined when calling srcHandlersCombineGetFileHandler.',
      );
    }

    let localVarQueryParameters = new HttpParams({ encoder: this.encoder });
    if (url !== undefined && url !== null) {
      localVarQueryParameters = this.addToHttpParams(
        localVarQueryParameters,
        <any>url,
        'url',
      );
    }
    if (location !== undefined && location !== null) {
      localVarQueryParameters = this.addToHttpParams(
        localVarQueryParameters,
        <any>location,
        'location',
      );
    }

    let localVarHeaders = this.defaultHeaders;

    let localVarHttpHeaderAcceptSelected: string | undefined =
      options && options.httpHeaderAccept;
    if (localVarHttpHeaderAcceptSelected === undefined) {
      // to determine the Accept header
      const httpHeaderAccepts: string[] = [
        'application/octet-stream',
        'application/json',
      ];
      localVarHttpHeaderAcceptSelected =
        this.configuration.selectHeaderAccept(httpHeaderAccepts);
    }
    if (localVarHttpHeaderAcceptSelected !== undefined) {
      localVarHeaders = localVarHeaders.set(
        'Accept',
        localVarHttpHeaderAcceptSelected,
      );
    }

    return this.httpClient.get(`${this.configuration.basePath}/combine/file`, {
      params: localVarQueryParameters,
      responseType: 'blob',
      withCredentials: this.configuration.withCredentials,
      headers: localVarHeaders,
      observe: observe,
      reportProgress: reportProgress,
    });
  }

  /**
   * Get the specifications of the SED-ML files in a COMBINE/OMEX archive
   * Get the specifications of the SED-ML files in a COMBINE/OMEX archive
   * @param file The two files uploaded in creating a combine archive
   * @param url URL
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public srcHandlersCombineGetManifestHandler(
    file?: Blob,
    url?: string,
    observe?: 'body',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' },
  ): Observable<CombineArchiveManifest>;
  public srcHandlersCombineGetManifestHandler(
    file?: Blob,
    url?: string,
    observe?: 'response',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' },
  ): Observable<HttpResponse<CombineArchiveManifest>>;
  public srcHandlersCombineGetManifestHandler(
    file?: Blob,
    url?: string,
    observe?: 'events',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' },
  ): Observable<HttpEvent<CombineArchiveManifest>>;
  public srcHandlersCombineGetManifestHandler(
    file?: Blob,
    url?: string,
    observe: any = 'body',
    reportProgress: boolean = false,
    options?: { httpHeaderAccept?: 'application/json' },
  ): Observable<any> {
    let localVarHeaders = this.defaultHeaders;

    let localVarHttpHeaderAcceptSelected: string | undefined =
      options && options.httpHeaderAccept;
    if (localVarHttpHeaderAcceptSelected === undefined) {
      // to determine the Accept header
      const httpHeaderAccepts: string[] = ['application/json'];
      localVarHttpHeaderAcceptSelected =
        this.configuration.selectHeaderAccept(httpHeaderAccepts);
    }
    if (localVarHttpHeaderAcceptSelected !== undefined) {
      localVarHeaders = localVarHeaders.set(
        'Accept',
        localVarHttpHeaderAcceptSelected,
      );
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let localVarFormParams: { append(param: string, value: any): any };
    const localVarUseForm = false;
    const localVarConvertFormParamsToString = false;
    if (localVarUseForm) {
      localVarFormParams = new FormData();
    } else {
      localVarFormParams = new HttpParams({ encoder: this.encoder });
    }

    let responseType_: 'text' | 'json' = 'json';
    if (
      localVarHttpHeaderAcceptSelected &&
      localVarHttpHeaderAcceptSelected.startsWith('text')
    ) {
      responseType_ = 'text';
    }

    return this.httpClient.post<CombineArchiveManifest>(
      `${this.configuration.basePath}/combine/manifest`,
      localVarConvertFormParamsToString
        ? localVarFormParams.toString()
        : localVarFormParams,
      {
        responseType: <any>responseType_,
        withCredentials: this.configuration.withCredentials,
        headers: localVarHeaders,
        observe: observe,
        reportProgress: reportProgress,
      },
    );
  }

  /**
   * Get the metadata about a COMBINE/OMEX archive
   * Get the metadata about a COMBINE/OMEX archive from the OMEX Metadata files in the archive encoded in BioSimulations\&#39; schema.
   * @param omexMetadataFormat OMEX Metadata format  Default: &#x60;rdfxml&#x60;
   * @param file The two files uploaded in creating a combine archive
   * @param url URL
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public srcHandlersCombineGetMetadataForCombineArchiveHandlerBiosimulations(
    omexMetadataFormat: string,
    file?: Blob,
    url?: string,
    observe?: 'body',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' },
  ): Observable<Array<BioSimulationsCombineArchiveElementMetadata>>;
  public srcHandlersCombineGetMetadataForCombineArchiveHandlerBiosimulations(
    omexMetadataFormat: string,
    file?: Blob,
    url?: string,
    observe?: 'response',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' },
  ): Observable<
    HttpResponse<Array<BioSimulationsCombineArchiveElementMetadata>>
  >;
  public srcHandlersCombineGetMetadataForCombineArchiveHandlerBiosimulations(
    omexMetadataFormat: string,
    file?: Blob,
    url?: string,
    observe?: 'events',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' },
  ): Observable<HttpEvent<Array<BioSimulationsCombineArchiveElementMetadata>>>;
  public srcHandlersCombineGetMetadataForCombineArchiveHandlerBiosimulations(
    omexMetadataFormat: string,
    file?: Blob,
    url?: string,
    observe: any = 'body',
    reportProgress: boolean = false,
    options?: { httpHeaderAccept?: 'application/json' },
  ): Observable<any> {
    if (omexMetadataFormat === null || omexMetadataFormat === undefined) {
      throw new Error(
        'Required parameter omexMetadataFormat was null or undefined when calling srcHandlersCombineGetMetadataForCombineArchiveHandlerBiosimulations.',
      );
    }

    let localVarHeaders = this.defaultHeaders;

    let localVarHttpHeaderAcceptSelected: string | undefined =
      options && options.httpHeaderAccept;
    if (localVarHttpHeaderAcceptSelected === undefined) {
      // to determine the Accept header
      const httpHeaderAccepts: string[] = ['application/json'];
      localVarHttpHeaderAcceptSelected =
        this.configuration.selectHeaderAccept(httpHeaderAccepts);
    }
    if (localVarHttpHeaderAcceptSelected !== undefined) {
      localVarHeaders = localVarHeaders.set(
        'Accept',
        localVarHttpHeaderAcceptSelected,
      );
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let localVarFormParams: { append(param: string, value: any): any };
    const localVarUseForm = false;
    const localVarConvertFormParamsToString = false;
    if (localVarUseForm) {
      localVarFormParams = new FormData();
    } else {
      localVarFormParams = new HttpParams({ encoder: this.encoder });
    }

    let responseType_: 'text' | 'json' = 'json';
    if (
      localVarHttpHeaderAcceptSelected &&
      localVarHttpHeaderAcceptSelected.startsWith('text')
    ) {
      responseType_ = 'text';
    }

    return this.httpClient.post<
      Array<BioSimulationsCombineArchiveElementMetadata>
    >(
      `${this.configuration.basePath}/combine/metadata/biosimulations`,
      localVarConvertFormParamsToString
        ? localVarFormParams.toString()
        : localVarFormParams,
      {
        responseType: <any>responseType_,
        withCredentials: this.configuration.withCredentials,
        headers: localVarHeaders,
        observe: observe,
        reportProgress: reportProgress,
      },
    );
  }

  /**
   * Get the metadata about a COMBINE/OMEX archive
   * Get the metadata about a COMBINE/OMEX archive from the OMEX Metadata files as a list of RDF triples.
   * @param omexMetadataFormat OMEX Metadata format  Default: &#x60;rdfxml&#x60;
   * @param file The two files uploaded in creating a combine archive
   * @param url URL
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public srcHandlersCombineGetMetadataForCombineArchiveHandlerRdfTriples(
    omexMetadataFormat: string,
    file?: Blob,
    url?: string,
    observe?: 'body',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' },
  ): Observable<Array<RdfTriple>>;
  public srcHandlersCombineGetMetadataForCombineArchiveHandlerRdfTriples(
    omexMetadataFormat: string,
    file?: Blob,
    url?: string,
    observe?: 'response',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' },
  ): Observable<HttpResponse<Array<RdfTriple>>>;
  public srcHandlersCombineGetMetadataForCombineArchiveHandlerRdfTriples(
    omexMetadataFormat: string,
    file?: Blob,
    url?: string,
    observe?: 'events',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' },
  ): Observable<HttpEvent<Array<RdfTriple>>>;
  public srcHandlersCombineGetMetadataForCombineArchiveHandlerRdfTriples(
    omexMetadataFormat: string,
    file?: Blob,
    url?: string,
    observe: any = 'body',
    reportProgress: boolean = false,
    options?: { httpHeaderAccept?: 'application/json' },
  ): Observable<any> {
    if (omexMetadataFormat === null || omexMetadataFormat === undefined) {
      throw new Error(
        'Required parameter omexMetadataFormat was null or undefined when calling srcHandlersCombineGetMetadataForCombineArchiveHandlerRdfTriples.',
      );
    }

    let localVarHeaders = this.defaultHeaders;

    let localVarHttpHeaderAcceptSelected: string | undefined =
      options && options.httpHeaderAccept;
    if (localVarHttpHeaderAcceptSelected === undefined) {
      // to determine the Accept header
      const httpHeaderAccepts: string[] = ['application/json'];
      localVarHttpHeaderAcceptSelected =
        this.configuration.selectHeaderAccept(httpHeaderAccepts);
    }
    if (localVarHttpHeaderAcceptSelected !== undefined) {
      localVarHeaders = localVarHeaders.set(
        'Accept',
        localVarHttpHeaderAcceptSelected,
      );
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let localVarFormParams: { append(param: string, value: any): any };
    const localVarUseForm = false;
    const localVarConvertFormParamsToString = false;
    if (localVarUseForm) {
      localVarFormParams = new FormData();
    } else {
      localVarFormParams = new HttpParams({ encoder: this.encoder });
    }

    let responseType_: 'text' | 'json' = 'json';
    if (
      localVarHttpHeaderAcceptSelected &&
      localVarHttpHeaderAcceptSelected.startsWith('text')
    ) {
      responseType_ = 'text';
    }

    return this.httpClient.post<Array<RdfTriple>>(
      `${this.configuration.basePath}/combine/metadata/rdf`,
      localVarConvertFormParamsToString
        ? localVarFormParams.toString()
        : localVarFormParams,
      {
        responseType: <any>responseType_,
        withCredentials: this.configuration.withCredentials,
        headers: localVarHeaders,
        observe: observe,
        reportProgress: reportProgress,
      },
    );
  }

  /**
   * Get the specifications of the SED-ML files in a COMBINE/OMEX archive
   * Get the specifications of the SED-ML files in a COMBINE/OMEX archive
   * @param file The two files uploaded in creating a combine archive
   * @param url URL
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public srcHandlersCombineGetSedmlSpecsForCombineArchiveHandler(
    file?: Blob,
    url?: string,
    observe?: 'body',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' },
  ): Observable<CombineArchiveSedDocSpecs>;
  public srcHandlersCombineGetSedmlSpecsForCombineArchiveHandler(
    file?: Blob,
    url?: string,
    observe?: 'response',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' },
  ): Observable<HttpResponse<CombineArchiveSedDocSpecs>>;
  public srcHandlersCombineGetSedmlSpecsForCombineArchiveHandler(
    file?: Blob,
    url?: string,
    observe?: 'events',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' },
  ): Observable<HttpEvent<CombineArchiveSedDocSpecs>>;
  public srcHandlersCombineGetSedmlSpecsForCombineArchiveHandler(
    file?: Blob,
    url?: string,
    observe: any = 'body',
    reportProgress: boolean = false,
    options?: { httpHeaderAccept?: 'application/json' },
  ): Observable<any> {
    let localVarHeaders = this.defaultHeaders;

    let localVarHttpHeaderAcceptSelected: string | undefined =
      options && options.httpHeaderAccept;
    if (localVarHttpHeaderAcceptSelected === undefined) {
      // to determine the Accept header
      const httpHeaderAccepts: string[] = ['application/json'];
      localVarHttpHeaderAcceptSelected =
        this.configuration.selectHeaderAccept(httpHeaderAccepts);
    }
    if (localVarHttpHeaderAcceptSelected !== undefined) {
      localVarHeaders = localVarHeaders.set(
        'Accept',
        localVarHttpHeaderAcceptSelected,
      );
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let localVarFormParams: { append(param: string, value: any): any };
    const localVarUseForm = false;
    const localVarConvertFormParamsToString = false;
    if (localVarUseForm) {
      localVarFormParams = new FormData();
    } else {
      localVarFormParams = new HttpParams({ encoder: this.encoder });
    }

    let responseType_: 'text' | 'json' = 'json';
    if (
      localVarHttpHeaderAcceptSelected &&
      localVarHttpHeaderAcceptSelected.startsWith('text')
    ) {
      responseType_ = 'text';
    }

    return this.httpClient.post<CombineArchiveSedDocSpecs>(
      `${this.configuration.basePath}/combine/sedml-specs`,
      localVarConvertFormParamsToString
        ? localVarFormParams.toString()
        : localVarFormParams,
      {
        responseType: <any>responseType_,
        withCredentials: this.configuration.withCredentials,
        headers: localVarHeaders,
        observe: observe,
        reportProgress: reportProgress,
      },
    );
  }

  /**
   * Modify the files and/or SED-ML documents in a COMBINE/OMEX archive
   * Modify the files or SED-ML documents in a COMBINE/OMEX archive.
   * @param specs
   * @param archive
   * @param files File (e.g., model) to place into the COMBINE/OMEX archive.
   * @param download Whether to download the modified archive or return a URL where the modified archive can be downloaded.
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public srcHandlersCombineModifyHandler(
    specs: CombineArchive,
    archive: FilenameOrUrl,
    files?: Array<Blob>,
    download?: boolean,
    observe?: 'body',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' | 'application/zip' },
  ): Observable<string>;
  public srcHandlersCombineModifyHandler(
    specs: CombineArchive,
    archive: FilenameOrUrl,
    files?: Array<Blob>,
    download?: boolean,
    observe?: 'response',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' | 'application/zip' },
  ): Observable<HttpResponse<string>>;
  public srcHandlersCombineModifyHandler(
    specs: CombineArchive,
    archive: FilenameOrUrl,
    files?: Array<Blob>,
    download?: boolean,
    observe?: 'events',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' | 'application/zip' },
  ): Observable<HttpEvent<string>>;
  public srcHandlersCombineModifyHandler(
    specs: CombineArchive,
    archive: FilenameOrUrl,
    files?: Array<Blob>,
    download?: boolean,
    observe: any = 'body',
    reportProgress: boolean = false,
    options?: { httpHeaderAccept?: 'application/json' | 'application/zip' },
  ): Observable<any> {
    if (specs === null || specs === undefined) {
      throw new Error(
        'Required parameter specs was null or undefined when calling srcHandlersCombineModifyHandler.',
      );
    }
    if (archive === null || archive === undefined) {
      throw new Error(
        'Required parameter archive was null or undefined when calling srcHandlersCombineModifyHandler.',
      );
    }

    let localVarHeaders = this.defaultHeaders;

    let localVarHttpHeaderAcceptSelected: string | undefined =
      options && options.httpHeaderAccept;
    if (localVarHttpHeaderAcceptSelected === undefined) {
      // to determine the Accept header
      const httpHeaderAccepts: string[] = [
        'application/json',
        'application/zip',
      ];
      localVarHttpHeaderAcceptSelected =
        this.configuration.selectHeaderAccept(httpHeaderAccepts);
    }
    if (localVarHttpHeaderAcceptSelected !== undefined) {
      localVarHeaders = localVarHeaders.set(
        'Accept',
        localVarHttpHeaderAcceptSelected,
      );
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let localVarFormParams: { append(param: string, value: any): any };
    const localVarUseForm = false;
    const localVarConvertFormParamsToString = false;
    if (localVarUseForm) {
      localVarFormParams = new FormData();
    } else {
      localVarFormParams = new HttpParams({ encoder: this.encoder });
    }

    let responseType_: 'text' | 'json' = 'json';
    if (
      localVarHttpHeaderAcceptSelected &&
      localVarHttpHeaderAcceptSelected.startsWith('text')
    ) {
      responseType_ = 'text';
    }

    return this.httpClient.post<string>(
      `${this.configuration.basePath}/combine/modify`,
      localVarConvertFormParamsToString
        ? localVarFormParams.toString()
        : localVarFormParams,
      {
        responseType: <any>responseType_,
        withCredentials: this.configuration.withCredentials,
        headers: localVarHeaders,
        observe: observe,
        reportProgress: reportProgress,
      },
    );
  }

  /**
   * Validate a COMBINE/OMEX archive and the simulation experiments and models inside it.
   * Validate a COMBINE/OMEX archive and the simulation experiments (SED-ML files) and models (e.g., SBML files) inside it.  Notes: * An OMEX Manifest file is required to validate OMEX Metadata files. As a result, the &#x60;validateOmexManifest&#x3D;false&#x60; option should often also be used with the &#x60;validateOmexMetadata&#x3D;false&#x60; option. * Currently, submission to BioSimulations requires metadata to be in RDF-XML format. * COMBINE/OMEX archives must pass all validation checks for publication to BioSimulations.
   * @param omexMetadataFormat OMEX Metadata format
   * @param omexMetadataSchema OMEX Metadata schema
   * @param file The two files uploaded in creating a combine archive
   * @param url URL
   * @param validateOmexManifest Whether to validate the manifest of the archive.  Default: &#x60;true&#x60;.
   * @param validateSedml Whether to validate the SED-ML files in the archive.  Default: &#x60;true&#x60;.
   * @param validateSedmlModels Whether to validate the source (e.g., CellML, SBML file) of each model of each SED-ML file in the archive.  Default: &#x60;true&#x60;.
   * @param validateOmexMetadata Whether to validate the OMEX Metadata files in the archive according to [BioSimulators\\\&#39; conventions](https://docs.biosimulations.org/concepts/conventions/simulation-project-metadata/).  Default: &#x60;true&#x60;.
   * @param validateImages Whether to validate the image (BMP, GIF, PNG, JPEG, TIFF, WEBP) files in the archive.  Default: &#x60;true&#x60;.
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public srcHandlersCombineValidateHandler(
    omexMetadataFormat: string,
    omexMetadataSchema: string,
    file?: Blob,
    url?: string,
    validateOmexManifest?: boolean,
    validateSedml?: boolean,
    validateSedmlModels?: boolean,
    validateOmexMetadata?: boolean,
    validateImages?: boolean,
    observe?: 'body',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' },
  ): Observable<ValidationReport>;
  public srcHandlersCombineValidateHandler(
    omexMetadataFormat: string,
    omexMetadataSchema: string,
    file?: Blob,
    url?: string,
    validateOmexManifest?: boolean,
    validateSedml?: boolean,
    validateSedmlModels?: boolean,
    validateOmexMetadata?: boolean,
    validateImages?: boolean,
    observe?: 'response',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' },
  ): Observable<HttpResponse<ValidationReport>>;
  public srcHandlersCombineValidateHandler(
    omexMetadataFormat: string,
    omexMetadataSchema: string,
    file?: Blob,
    url?: string,
    validateOmexManifest?: boolean,
    validateSedml?: boolean,
    validateSedmlModels?: boolean,
    validateOmexMetadata?: boolean,
    validateImages?: boolean,
    observe?: 'events',
    reportProgress?: boolean,
    options?: { httpHeaderAccept?: 'application/json' },
  ): Observable<HttpEvent<ValidationReport>>;
  public srcHandlersCombineValidateHandler(
    omexMetadataFormat: string,
    omexMetadataSchema: string,
    file?: Blob,
    url?: string,
    validateOmexManifest?: boolean,
    validateSedml?: boolean,
    validateSedmlModels?: boolean,
    validateOmexMetadata?: boolean,
    validateImages?: boolean,
    observe: any = 'body',
    reportProgress: boolean = false,
    options?: { httpHeaderAccept?: 'application/json' },
  ): Observable<any> {
    if (omexMetadataFormat === null || omexMetadataFormat === undefined) {
      throw new Error(
        'Required parameter omexMetadataFormat was null or undefined when calling srcHandlersCombineValidateHandler.',
      );
    }
    if (omexMetadataSchema === null || omexMetadataSchema === undefined) {
      throw new Error(
        'Required parameter omexMetadataSchema was null or undefined when calling srcHandlersCombineValidateHandler.',
      );
    }

    let localVarHeaders = this.defaultHeaders;

    let localVarHttpHeaderAcceptSelected: string | undefined =
      options && options.httpHeaderAccept;
    if (localVarHttpHeaderAcceptSelected === undefined) {
      // to determine the Accept header
      const httpHeaderAccepts: string[] = ['application/json'];
      localVarHttpHeaderAcceptSelected =
        this.configuration.selectHeaderAccept(httpHeaderAccepts);
    }
    if (localVarHttpHeaderAcceptSelected !== undefined) {
      localVarHeaders = localVarHeaders.set(
        'Accept',
        localVarHttpHeaderAcceptSelected,
      );
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let localVarFormParams: { append(param: string, value: any): any };
    const localVarUseForm = false;
    const localVarConvertFormParamsToString = false;
    if (localVarUseForm) {
      localVarFormParams = new FormData();
    } else {
      localVarFormParams = new HttpParams({ encoder: this.encoder });
    }

    let responseType_: 'text' | 'json' = 'json';
    if (
      localVarHttpHeaderAcceptSelected &&
      localVarHttpHeaderAcceptSelected.startsWith('text')
    ) {
      responseType_ = 'text';
    }

    return this.httpClient.post<ValidationReport>(
      `${this.configuration.basePath}/combine/validate`,
      localVarConvertFormParamsToString
        ? localVarFormParams.toString()
        : localVarFormParams,
      {
        responseType: <any>responseType_,
        withCredentials: this.configuration.withCredentials,
        headers: localVarHeaders,
        observe: observe,
        reportProgress: reportProgress,
      },
    );
  }

  /**
   * Execute a COMBINE/OMEX archive
   * Execute the simulations defined in SED-ML format in a COMBINE/OMEX archive and return the result of each report and plot.
   * @param simulator Id of a simulation tool registered with BioSimulators.
   * @param type Type
   * @param archiveUrl URL
   * @param archiveFile The two files uploaded in creating a combine archive
   * @param environment
   * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
   * @param reportProgress flag to report request and response progress.
   */
  public srcHandlersRunRunHandler(
    simulator: string,
    type: string,
    archiveUrl?: string,
    archiveFile?: Blob,
    environment?: Environment,
    observe?: 'body',
    reportProgress?: boolean,
    options?: {
      httpHeaderAccept?:
        | 'application/json'
        | 'application/x-hdf'
        | 'application/zip';
    },
  ): Observable<SimulationRunResults>;
  public srcHandlersRunRunHandler(
    simulator: string,
    type: string,
    archiveUrl?: string,
    archiveFile?: Blob,
    environment?: Environment,
    observe?: 'response',
    reportProgress?: boolean,
    options?: {
      httpHeaderAccept?:
        | 'application/json'
        | 'application/x-hdf'
        | 'application/zip';
    },
  ): Observable<HttpResponse<SimulationRunResults>>;
  public srcHandlersRunRunHandler(
    simulator: string,
    type: string,
    archiveUrl?: string,
    archiveFile?: Blob,
    environment?: Environment,
    observe?: 'events',
    reportProgress?: boolean,
    options?: {
      httpHeaderAccept?:
        | 'application/json'
        | 'application/x-hdf'
        | 'application/zip';
    },
  ): Observable<HttpEvent<SimulationRunResults>>;
  public srcHandlersRunRunHandler(
    simulator: string,
    type: string,
    archiveUrl?: string,
    archiveFile?: Blob,
    environment?: Environment,
    observe: any = 'body',
    reportProgress: boolean = false,
    options?: {
      httpHeaderAccept?:
        | 'application/json'
        | 'application/x-hdf'
        | 'application/zip';
    },
  ): Observable<any> {
    if (simulator === null || simulator === undefined) {
      throw new Error(
        'Required parameter simulator was null or undefined when calling srcHandlersRunRunHandler.',
      );
    }
    if (type === null || type === undefined) {
      throw new Error(
        'Required parameter type was null or undefined when calling srcHandlersRunRunHandler.',
      );
    }

    let localVarHeaders = this.defaultHeaders;

    let localVarHttpHeaderAcceptSelected: string | undefined =
      options && options.httpHeaderAccept;
    if (localVarHttpHeaderAcceptSelected === undefined) {
      // to determine the Accept header
      const httpHeaderAccepts: string[] = [
        'application/json',
        'application/x-hdf',
        'application/zip',
      ];
      localVarHttpHeaderAcceptSelected =
        this.configuration.selectHeaderAccept(httpHeaderAccepts);
    }
    if (localVarHttpHeaderAcceptSelected !== undefined) {
      localVarHeaders = localVarHeaders.set(
        'Accept',
        localVarHttpHeaderAcceptSelected,
      );
    }

    // to determine the Content-Type header
    const consumes: string[] = ['multipart/form-data'];

    const canConsumeForm = this.canConsumeForm(consumes);

    let localVarFormParams: { append(param: string, value: any): any };
    const localVarUseForm = false;
    const localVarConvertFormParamsToString = false;
    if (localVarUseForm) {
      localVarFormParams = new FormData();
    } else {
      localVarFormParams = new HttpParams({ encoder: this.encoder });
    }

    let responseType_: 'text' | 'json' = 'json';
    if (
      localVarHttpHeaderAcceptSelected &&
      localVarHttpHeaderAcceptSelected.startsWith('text')
    ) {
      responseType_ = 'text';
    }

    return this.httpClient.post<SimulationRunResults>(
      `${this.configuration.basePath}/run/run`,
      localVarConvertFormParamsToString
        ? localVarFormParams.toString()
        : localVarFormParams,
      {
        responseType: <any>responseType_,
        withCredentials: this.configuration.withCredentials,
        headers: localVarHeaders,
        observe: observe,
        reportProgress: reportProgress,
      },
    );
  }
}
