# Documentation for libraries for publishing primary model repositories to BioSimulations

A portion of BioSimulations is derived from several primary model repositories that focus on models of specific biological systems, specific types of models, specific model formats, and/or specific simulation tools. We aim to automatically publish these repositories to BioSimulations each week. This publication will be implemented by a collection of Python packages and GitHub actions. Links to documentation for these packages will be available below.

| Repository                                                       | Topic                     | Formalism          | Format         | Tools              | Docs for publication to BioSimulations                                         |
|------------------------------------------------------------------|---------------------------|--------------------|----------------|--------------------|---------------------------------------------------------------|
| [BiGG](http://bigg.ucsd.edu/)                                    | Metabolism                | Flux balance       | SBML-fbc       | COBRApy and others | [Docs](https://biosimulations.github.io/biosimulations-bigg/) |
| [BioModels](http://biomodels.net/)                               | Biochemical networks      | Kinetic            | SBML           | Many               |                                                               |
| [GINsim](http://ginsim.org/models_repository)                    | Networks                  | Qualitative        | ZGINML         | GINsim             |                                                               |
| [ModelDB](http://modeldb.science/)                               | Neurophysiology           | Continuous kinetic | ODE and others | XPP and others     |                                                               |
| [Physiome](https://models.physiomeproject.org/)                  | Physiology                | Continuous kinetic | CellML         | OpenCOR and others |                                                               |
| [RBA models](https://github.com/SysBioInra/Bacterial-RBA-models) | Resource allocation       | Resource balance   | RBA XML        | RBAPy              |                                                               |
| [Rule Hub](https://github.com/RuleWorld/RuleHub)                 | Rule-based models         | Discrete kinetic   | BNGL           | BioNetGen          |                                                               |

--8<-- "glossary.md"